/* GNOME DB
 * Copyright (C) 1998 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_CONNECTION_H__
#define __GDA_CONNECTION_H__

#include <glib.h>

#include "gda.h"
#include "gda-types.h"
#include "gda-common.h"

#include "gda-recset.h"

#define GDA_CNC_COMMIT_RTN 0x1
#define GDA_CNC_ABORT_RTN  0x2

Gda_ODBC_Connection* gda_odbc_connection_new          (void);
void                 gda_odbc_connection_free         (Gda_ODBC_Connection* cnc);
gint                 gda_odbc_connection_close        (Gda_ODBC_Connection* cnc);
Gda_ODBC_Recordset*  gda_odbc_connection_open_schema  (Gda_ODBC_Connection*       cnc,
						       GDA_Connection_QType       t,
						       GDA_Connection_Constraint* constraints,
						       gint                       length);

gint                 gda_odbc_connection_open         (Gda_ODBC_Connection* cnc, const gchar* cnc_string,
						       const gchar* user, const gchar* passwd);
gchar*               gda_odbc_connection_create_recset(Gda_ODBC_Connection* cnc, GDA_RowAttributes* columns);
#endif
