/* GNOME-DB - Development Environment
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include "gda-builder.h"

#if !defined(GNOMELOCALEDIR)
#  define GNOMELOCALEDIR "/usr/locale"
#endif

static void about_cb (GtkWidget *w, gpointer data);
static void quit_cb (GtkWidget *w, gpointer data);

/* global variables */
GtkWidget*      glb_App = 0;
GtkWidget*      glb_StatusBar = 0;
CORBA_ORB       glb_Orb;
Gda_Connection* glb_dbconn = 0;

/* menus */
GnomeUIInfo filenewmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Screen"), N_("New screen"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Report"), N_("New report"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Server"), N_("New server"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Repository"), N_("New repository"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo fileopenmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Screen"), N_("Open existing screen"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Report"), N_("Open existing report"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Server"), N_("Open existing server"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Repository"), N_("Open existing repository"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo databasemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Connect..."), N_("Connect to database"),
    gb_database_connect, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_LINE_IN, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Disconnect"), N_("Close database connection"),
    gb_database_disconnect, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_STOP, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Import objects"), N_("Import database objects into repository"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo filemenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("New"), filenewmenu),
  GNOMEUIINFO_SUBTREE(N_("Open"), fileopenmenu),
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close current window"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Close all"), N_("Close all open windows"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Printer setup..."), N_("Open printer setup dialog"),
    gda_ui_print_setup_dlg_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_PRINT, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_QUIT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo helpmenu[] =
{
  GNOMEUIINFO_HELP("gnome-db"),
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("About gnome-db..."), N_("About this program"),
    about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_ABOUT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo mainmenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
  GNOMEUIINFO_SUBTREE(N_("Database"), databasemenu),
  GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
  GNOMEUIINFO_END
};

/* toolbar */
GnomeUIInfo toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("New"), N_("New Screen/Report"),
    0, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_NEW, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Open"), N_("Open Screen/Report"),
    0, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_OPEN, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Previous"), N_("Move to previous window on list"),
    0, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BACK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Next"), N_("Move to next window on list"),
    0, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_FORWARD, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Preferences"), N_("Configure user preferences"),
    0, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Exit"), N_("Exit application"),
    quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXIT, 0, 0, NULL },
  GNOMEUIINFO_END
};
static void prepare_app (void);

/* CORBA exception handler */
void
Exception (CORBA_Environment *ev)
{
  switch (ev->_major)
    {
    case CORBA_SYSTEM_EXCEPTION :
      gda_ui_show_error("CORBA system exception %s", CORBA_exception_id(ev));
      exit(1);
    case CORBA_USER_EXCEPTION :
      gda_ui_show_error("CORBA user exception %s", CORBA_exception_id(ev));
      exit(1);
    default :
      break;
    }
}

gint 
main (gint argc, gchar *argv[])
{
  CORBA_Environment ev;

  /* initialize the i18n stuff */
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  /* initialize CORBA stuff */
  CORBA_exception_init(&ev);
  glb_Orb = gnome_CORBA_init("gda-builder", VERSION, &argc, argv, 0, &ev);
  Exception(&ev);

  /* load application settings and create main window */
  prepare_app();

  /* main loop */
  gtk_main();
  return (0);
}

/*
 * Callbacks
 */
static void 
about_cb (GtkWidget *w, gpointer data)
{
  const gchar *authors[] = { "Michael Lausch <michael@lausch.at>",
			     "Rodrigo Moya <rmoya@chez.com>",
			     NULL };
  GtkWidget *about = gnome_about_new(_("GNOME-DB"), _("Builder"),
	     _("Copyright The Free Software Foundation (C) 1998"),
	     authors,
             _("This program is part of the GNOME project for LINUX. "
	       "GNOME Data Access comes with ABSOLUTELY NO WARRANTY. "
	       "This is free software, and you are welcome to redistribute "
	       "it under the conditions of the GNU General Public Licence."),
	     "gnome-db.png");
  gtk_widget_show(about);
}

static void 
quit_cb (GtkWidget *w, gpointer data)
{
  gtk_main_quit();
}

static void
prepare_app (void)
{
  GtkWidget *pane;
  
  glb_App = gnome_app_new("gda-builder", "GDA Builder");
  gtk_widget_realize(GTK_WIDGET(glb_App));
  gtk_signal_connect(GTK_OBJECT(glb_App), "delete_event",
		     GTK_SIGNAL_FUNC(quit_cb), NULL);
  gtk_signal_connect(GTK_OBJECT(glb_App), "destroy",
                     GTK_SIGNAL_FUNC(quit_cb), NULL);
                  
  /* set main window contents */
  gnome_app_create_toolbar(GNOME_APP(glb_App), toolbar);
  
  pane = gtk_hpaned_new();
  gtk_widget_show(pane);
  gnome_app_set_contents(GNOME_APP(glb_App), pane);
  
  gnome_app_create_menus(GNOME_APP(glb_App), mainmenu);
     
  /* create status bar */
  glb_StatusBar = gnome_appbar_new(TRUE, TRUE, GNOME_PREFERENCES_USER);
  gnome_appbar_set_default(GNOME_APPBAR(glb_StatusBar), _("Ready"));
  gnome_app_set_statusbar(GNOME_APP(glb_App), glb_StatusBar);
  gnome_app_install_menu_hints(GNOME_APP(glb_App), mainmenu);
  
  gtk_widget_show(glb_App);
}