/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_dberror_h__
#define __gda_dberror_h__ 1

#include <gnome.h>
#include <gda-connection.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_ERROR            (gnome_db_error_get_type())
#define GNOME_DB_ERROR(obj)            (GTK_CHECK_CAST((obj), GNOME_DB_TYPE_ERROR, GnomeDbError))
#define GNOME_DB_ERROR_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), GNOME_DB_TYPE_ERROR, GnomeDbErrorClass))
#define GNOME_DB_IS_ERROR(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_ERROR)
#define GNOME_DB_IS_ERROR_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_ERROR))

typedef struct _GnomeDbError           GnomeDbError;
typedef struct _GnomeDbErrorClass      GnomeDbErrorClass;

struct _GnomeDbError
{
  GtkVBox         box;
  Gda_Connection* cnc;
  GtkWidget*      description;
  GtkWidget*      source;
  GtkWidget*      sqlstate;
  GtkWidget*      help_button;
  GList*          error_ptr;
  GtkWidget*      position_label;
  gint            position;
};

struct _GnomeDbErrorClass
{
  GtkVBoxClass      parent_class;
  void              (*next)(GnomeDbError* error);
  void              (*prev)(GnomeDbError* error);
};

guint                         gnome_db_error_get_type   (void);

GtkWidget*                    gnome_db_error_new        (Gda_Connection* cnc);
void                          gnome_db_error_error      (GnomeDbError* error_widget);
void                          gnome_db_error_free       (GnomeDbError* error_widget);
void                          gnome_db_error_show       (GnomeDbError* error_widget);
void                          gnome_db_error_prev       (GnomeDbError* error_widget);
void                          gnome_db_error_next       (GnomeDbError* error_widget);

							 
END_GNOME_DECLS

#endif
