/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-ui.h"

/*
 * Functions
 */
GtkWidget *
gda_ui_new_button_widget (gchar *label)
{
  GtkWidget *button = label ? gtk_button_new_with_label(label) : gtk_button_new();
  gtk_widget_show(button);
  return (button);
}

GtkWidget *
gda_ui_new_button_widget_with_pixmap (const gchar *label, const gchar *icon)
{
  GtkWidget *button;
  
  g_return_val_if_fail(label != 0, 0);
  g_return_val_if_fail(icon != 0, 0);
  
  button = gnome_pixmap_button(gnome_stock_new_with_icon(icon), label);
  gtk_widget_show(button);
  return (button);
}

GtkWidget *
gda_ui_new_check_button_widget (gchar *label, gint state)
{
  GtkWidget *check = label ? gtk_check_button_new_with_label(label) : gtk_check_button_new();
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), state);
  gtk_widget_show(check);
  return (check);
}

GtkWidget *
gda_ui_new_clist_widget (gchar *titles[], gint count)
{
  gint cnt;
  GtkWidget *clist = titles ? gtk_clist_new_with_titles(count, titles) :
                              gtk_clist_new(count);
  gtk_clist_set_selection_mode(GTK_CLIST(clist), GTK_SELECTION_SINGLE);
  for (cnt = 0; cnt < count; cnt++)
    {
      gtk_clist_set_column_resizeable(GTK_CLIST(clist), cnt, TRUE);
      gtk_clist_set_column_auto_resize(GTK_CLIST(clist), cnt, TRUE);
    }
  gtk_widget_show(clist);
  return (clist);
}

GtkWidget *
gda_ui_new_combo_widget (void)
{
  GtkWidget *combo;
  combo = gtk_combo_new();
  gtk_combo_set_use_arrows(GTK_COMBO(combo), 1);
  gtk_combo_set_case_sensitive(GTK_COMBO(combo), 0);
  gtk_widget_show(combo);
  return (combo);
}

GtkWidget *
gda_ui_new_entry_widget (gint max_len, gboolean editable)
{
  GtkWidget *entry;
  if (max_len > 0)
    entry = gtk_entry_new_with_max_length((guint16) max_len);
  else entry = gtk_entry_new();
  gtk_entry_set_visibility(GTK_ENTRY(entry), TRUE);
  gtk_entry_set_editable(GTK_ENTRY(entry), editable);
  gtk_widget_show(entry);
  return (entry);  
}

GtkWidget *
gda_ui_new_icon_widget (const gchar *name)
{
  GtkWidget *icon;
  
  g_return_val_if_fail(name != 0, 0);
  
  icon = gnome_stock_new_with_icon(name);
  gtk_widget_show(icon);
  return (icon);
}

GtkWidget *
gda_ui_new_label_widget (const gchar *txt)
{
  GtkWidget *label = gtk_label_new(txt);
  gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
  gtk_widget_show(label);
  return (label);
}

GtkWidget *
gda_ui_new_radio_button_widget (const gchar *label, GtkRadioButton *group)
{
  GtkWidget *radio_button;
  GSList *lst_group;
  g_return_val_if_fail(label != NULL, NULL);
  lst_group = group ? gtk_radio_button_group(group) : NULL;
  radio_button = gtk_radio_button_new_with_label(lst_group, label);
  gtk_widget_show(radio_button);
  return (radio_button);
}

GtkWidget *
gda_ui_new_scrolled_window_widget (void)
{
  GtkWidget *scrolled_window;
  scrolled_window = gtk_scrolled_window_new(0, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
                                 GTK_POLICY_AUTOMATIC,
                                 GTK_POLICY_AUTOMATIC);
  gtk_widget_show(scrolled_window);
  return (scrolled_window);
}

GtkWidget *
gda_ui_new_tree_widget (void)
{
  GtkWidget *tree = gtk_tree_new();
  gtk_widget_show(tree);
  return (tree);
}

void
gda_ui_clear_clist (GtkCList *clist)
{
  register gint cnt;
  
  g_return_if_fail(clist != 0);
  
  gtk_clist_freeze(clist);
  while (GTK_CLIST(clist)->rows > 0)
    gtk_clist_remove(clist, 0);
  gtk_clist_thaw(clist);
}

GtkWidget *
gda_ui_new_popup_menu (GtkWidget *parent, GnomeUIInfo *ui_info, gpointer data)
{
  GtkWidget *popup_menu;
  g_return_val_if_fail(parent != NULL, NULL);
  g_return_val_if_fail(ui_info != NULL, NULL);
  popup_menu = gnome_popup_menu_new(ui_info);
  gnome_popup_menu_attach(popup_menu, parent, (gpointer) data);
  return (popup_menu);
}

void
gda_ui_show_error (const gchar *format, ...)
{
  GtkWidget *dialog;
  va_list args;
  gchar sz[256];
    
  /* build the message string */
  va_start(args, format);
  vsprintf(sz, format, args);
  va_end(args);
    
  /* create the dialog box */
  dialog = gnome_message_box_new(sz, GNOME_MESSAGE_BOX_ERROR, GNOME_STOCK_BUTTON_OK, 0);
  gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
}