/* GNOME-DB - GUI front-end
 * Copyright (c) 1998-2000 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gdafe.h"

/*
 * Public functions
 */
GtkWidget *
fe_new_view (const gchar *title, gint cols, gint rows, GnomeUIInfo *toolbar)
{
  GtkWidget *view, *table;
  
  view = gtk_frame_new(0);
  gtk_frame_set_shadow_type(GTK_FRAME(view), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show(view);
  
  table = gtk_table_new(rows, cols, FALSE);
  gtk_object_set_data(GTK_OBJECT(view), "FE_View_TableWidget", (gpointer) table);
  gtk_widget_show(table);
  gtk_container_add(GTK_CONTAINER(view), table);
  
  gtk_notebook_append_page(GTK_NOTEBOOK(glb_WorkArea), view,
                           gtk_label_new(title));
  if (toolbar != 0)
    fe_add_toolbar_to_view(view, 0, 0, cols, 1, toolbar);
  
  fe_set_notebook_page(GTK_NOTEBOOK(glb_WorkArea), view);
  return (view);
}

void
fe_destroy_view (GtkWidget *view)
{
  FE_DestroyViewFunc func;
  GList *children;
  gint current;

  g_return_if_fail(view != NULL);

  /* call the destroy function if available */
  func = (FE_DestroyViewFunc) fe_get_view_destroy_func(view);
  if (func != NULL) 
    (*func)(view, fe_get_view_data(view, "FE_View_DestroyData"));

  /* free children list */
  children = fe_get_view_data(view, "FE_View_Children");
  if (children != 0)
    {
      do
        {
          gpointer data = children->data;
          children = g_list_remove(children, children->data);
        } while (children != NULL);
    }
  current = gtk_notebook_page_num(GTK_NOTEBOOK(glb_WorkArea),
                                  GTK_WIDGET(view));
  gtk_notebook_remove_page(GTK_NOTEBOOK(glb_WorkArea), current);
}

void
fe_destroy_all_views (void)
{
  gint current;
  while ((current = gtk_notebook_get_current_page(GTK_NOTEBOOK(glb_WorkArea))) >= 0)
    {
      fe_destroy_view(gtk_notebook_get_nth_page(GTK_NOTEBOOK(glb_WorkArea), current));
    }
}

GtkWidget *
fe_get_current_view (void)
{
  gint current = gtk_notebook_get_current_page(GTK_NOTEBOOK(glb_WorkArea));
  return (gtk_notebook_get_nth_page(GTK_NOTEBOOK(glb_WorkArea), current));
}

void
fe_display_view (GtkWidget *view)
{
  g_return_if_fail(view != NULL);
  fe_set_notebook_page(GTK_NOTEBOOK(glb_WorkArea), view);
}

gpointer
fe_get_view_data (GtkWidget *view, const gchar *key)
{
  g_return_val_if_fail(view != NULL, NULL);
  g_return_val_if_fail(key != NULL, NULL);
  return ((gpointer) gtk_object_get_data(GTK_OBJECT(view), key));
}

void
fe_set_view_data (GtkWidget *view, const gchar *key, gpointer data)
{
  g_return_if_fail(view != NULL);
  g_return_if_fail(key != NULL);
  gtk_object_set_data(GTK_OBJECT(view), key, data);
}

FE_DestroyViewFunc
fe_get_view_destroy_func (GtkWidget *view)
{
  g_return_val_if_fail(view != NULL, NULL);
  return ((FE_DestroyViewFunc) fe_get_view_data(view, "FE_View_DestroyFunc"));
}

void
fe_set_view_destroy_func (GtkWidget *view, FE_DestroyViewFunc func, gpointer data)
{
  g_return_if_fail(view != NULL);
  fe_set_view_data(view, "FE_View_DestroyFunc", (gpointer) func);
  if (data != NULL)
    fe_set_view_data(view, "FE_View_DestroyData", data);
}

void
fe_add_toolbar_to_view (GtkWidget *view, gint x1, gint y1, gint x2, gint y2, GnomeUIInfo *data)
{
  GtkWidget *toolbar, *table;
  
  g_return_if_fail(view != NULL);
  table = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(view), "FE_View_TableWidget");
  g_return_if_fail(GTK_IS_TABLE(table));
  
  toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_table_attach(GTK_TABLE(table), toolbar, x1, x2, y1, y2,
                   GTK_SHRINK | GTK_FILL,
                   GTK_FILL,
                   3, 3);
  gnome_app_fill_toolbar(GTK_TOOLBAR(toolbar), data, NULL);
  gtk_widget_show(toolbar);

  fe_set_view_data(view, "FE_View_Toolbar", (gpointer) toolbar);
}

void
fe_add_widget_to_view (GtkWidget *view, gint x1, gint y1, gint x2, gint y2, GtkWidget *widget)
{
  GList *children;
  GtkWidget *table;

  g_return_if_fail(view != NULL);
  g_return_if_fail(widget != NULL);
  table = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(view), "FE_View_TableWidget");
  g_return_if_fail(GTK_IS_TABLE(table));

  /* attach widget to internal table */
  gtk_table_attach(GTK_TABLE(table), widget, x1, x2, y1, y2,
                   GTK_FILL | GTK_EXPAND,
                   GTK_FILL | GTK_EXPAND, 
                   3, 3);
  gtk_widget_show(widget);

  /* update list of children */
  children = (GList *) gtk_object_get_data(GTK_OBJECT(view), "FE_View_Children");
  children = g_list_append(children, (gpointer) widget);
  gtk_object_set_data(GTK_OBJECT(view), "FE_View_Children", children);
}

GtkWidget *
fe_get_view_toolbar (GtkWidget *view)
{
  return (gtk_object_get_data(GTK_OBJECT(view), "FE_View_Toolbar"));
}
