/*
 * berseq.C: Implementation of ASN.1 sequences
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later 
 * version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * See the AUTHORS file for a list of people who have hacked on 
 * this code. 
 * See the ChangeLog file for a list of changes.
 *
 */
#include <string.h>
#include <stdarg.h>
#include <stdio.h>

#include "ber.h"

/* berSequence - sequences are wrappers for other encoded pieces 
   of data. basically all that they do is give mark their 
   beginning and have a length. the tricky bit is that they can 
   be recursive. */

BerSequence::~BerSequence(){
  for(ElementContainer::iterator cur=elements.begin();cur!=elements.end();
      cur++)
    delete *cur;
}

BerSequence::BerSequence(unsigned char *str)
  throw(BerSequenceTagException,BerLengthException,std::bad_alloc,
	BerIntTagException,BerIntLengthExecption,
	BerCounterTagException,BerCounterLengthExecption,
	BerStringTagException,BerNullTagException,BerNullLengthExecption,
	BerOidTagException,BerTimeTickTagException,
	BerTimeTickLengthExecption,BerIPAddrLengthExecption){
  /* this is kind of tricky there are several kinds of contructor 
     tags but all of them have their high bit set to 1. */
  if(!(str[0]&CONSTRUCTOR_TAG)) throw BerSequenceTagException(); 
  unsigned char headlen;
  tag=static_cast<Tags>(str[0]);
  unsigned long seqlen=unpack_len(str,headlen);

  unsigned char junk; /* used to store the headerlen and then 
			 dispose of it */
  try{
    for(unsigned char *curpos=str+headlen;curpos<str+headlen+seqlen;
	curpos+=unpack_len(curpos,junk)+junk){
      BerBase *newone;
      switch(*curpos){
      case INT_TAG:
	newone=new BerInt(curpos);
	break;
      case COUNTER_TAG:
	newone=new BerCounter(curpos);
	break;
      case STRING_TAG:
	newone=new BerString(curpos);
	break;
      case NULL_TAG:
	newone=new BerNull(curpos);
	break;
      case OID_TAG:
	newone=new BerOid(curpos);
	break;
      case TIME_TICK_TAG:
	newone=new BerTimeTick(curpos);
	break;
      case IPADDR_TAG:
	newone=new BerIPAddr(curpos);
	break;
      default:
	newone=new BerSequence(curpos);
      }
      elements.push_back(newone);
    }
  }catch(...){ // deal with incomplete construction
    for(ElementContainer::iterator cur=elements.begin();cur!=elements.end();
	cur++)
      delete *cur;   
    throw;
  }
}

ustring &BerSequence::encode(ustring &dest){
  // string up the data
  ustring encoded_elements;
  for(ElementContainer::iterator cur=elements.begin();cur!=elements.end();
      cur++)
    (*cur)->encode(encoded_elements);
  
  start_data(tag,encoded_elements.length(),dest);
  dest+=encoded_elements;
  return dest;
}

void BerSequence::ascii_print(std::string &buf){
  buf+="( ";
  for(ElementContainer::iterator cur=elements.begin();cur!=elements.end();
      cur++){
    (*cur)->ascii_print(buf);
    buf+=' ';
  }
  buf+=")";
}


BerBase *BerSequence::extract(std::deque<BerBase*>::iterator ele){
  BerBase *retval=*ele;
  elements.erase(ele);
  return retval;
}
