/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef BOARD_INFO_H
#define BOARD_INFO_H

#include <gtk/gtk.h>
#include "engine.h"

#define BOARD_INFO(obj)	GTK_CHECK_CAST (obj, board_info_get_type(), BoardInfo)
#define BOARD_INFO_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, board_info_get_type(), BoardInfoClass)
#define IS_BOARD_INFO(obj)       GTK_CHECK_TYPE (obj, board_info_get_type())

typedef struct _BoardInfo       BoardInfo;
typedef struct _BoardInfoClass  BoardInfoClass;

struct _BoardInfoClass {
	GtkVBoxClass parent_class;
};

struct _BoardInfo {
	GtkVBox window;
	GtkWidget *child;

	GtkWidget *white_name;
	GtkWidget *black_name;
	GtkWidget *white_time;
	GtkWidget *black_time;
	GtkWidget *result;

	gint resultval;
};

guint board_info_get_type (void);
GtkWidget* board_info_new (void);

void board_info_set_game_info (BoardInfo *info, GameInfo *gameinfo);

gchar* board_info_get_white_name (BoardInfo *info);
void board_info_set_white_name (BoardInfo *info, const gchar *name);

gchar* board_info_get_black_name (BoardInfo *info);
void board_info_set_black_name (BoardInfo *info, const gchar *name);

gint board_info_get_white_time (BoardInfo *info);
void board_info_set_white_time (BoardInfo *info, gint secs);
gint board_info_get_black_time (BoardInfo *info);
void board_info_set_black_time (BoardInfo *info, gint secs);

gint board_info_get_result (BoardInfo *info);
void board_info_set_result (BoardInfo *info, gint result);

#endif

