/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  Authors: Jeffrey Stedfast <fejj@helixcode.com>
 *
 *  Copyright 2000 Helix Code, Inc. (www.helixcode.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __GMIME_H__
#define __GMIME_H__

#include <glib.h>
#include "gmime-param.h"
#include "gmime-content-type.h"
#include "gmime-part.h"
#include "gmime-message.h"
#include "internet-address.h"
#include "gmime-parser.h"
#include "gmime-utils.h"

/* GMIME version */
static const guint gmime_major_version = 0;
static const guint gmime_minor_version = 2;
static const guint gmime_micro_version = 0;
static const guint gmime_interface_age = 0;
static const guint gmime_binary_age    = 0;

#define GMIME_CHECK_VERSION(major,minor,micro)    \
    (gmime_major_version > (major) || \
     (gmime_major_version == (major) && gmime_minor_version > (minor)) || \
     (gmime_major_version == (major) && gmime_minor_version == (minor) && \
      gmime_micro_version >= (micro)))

#endif /* __GMIME_H__ */
