<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>libglom Reference Manual</title>
    <filename>index</filename>
    <docanchor file="index">basics</docanchor>
    <docanchor file="index">warning</docanchor>
    <docanchor file="index">description</docanchor>
  </compound>
  <compound kind="namespace">
    <name>Glom</name>
    <filename>namespaceGlom.html</filename>
    <namespace>Glom::Conversions</namespace>
    <namespace>Glom::DbUtils</namespace>
    <namespace>Glom::Utils</namespace>
    <class kind="class">Glom::AppState</class>
    <class kind="class">Glom::sharedptr</class>
    <class kind="class">Glom::ReportBuilder</class>
    <class kind="class">Glom::predicate_FieldHasName</class>
    <class kind="class">Glom::Field</class>
    <class kind="class">Glom::FieldTypes</class>
    <class kind="class">Glom::FoundSet</class>
    <class kind="class">Glom::HasTitleSingular</class>
    <class kind="class">Glom::GroupInfo</class>
    <class kind="class">Glom::NumericFormat</class>
    <class kind="class">Glom::ParameterNameGenerator</class>
    <class kind="class">Glom::PrintLayout</class>
    <class kind="class">Glom::Privileges</class>
    <class kind="class">Glom::Relationship</class>
    <class kind="class">Glom::Report</class>
    <class kind="class">Glom::SystemPrefs</class>
    <class kind="class">Glom::TableInfo</class>
    <class kind="class">Glom::TranslatableItem</class>
    <class kind="class">Glom::CustomTitle</class>
    <class kind="class">Glom::FieldFormatting</class>
    <class kind="class">Glom::LayoutGroup</class>
    <class kind="class">Glom::LayoutItem</class>
    <class kind="class">Glom::LayoutItem_Button</class>
    <class kind="class">Glom::LayoutItem_CalendarPortal</class>
    <class kind="class">Glom::predicate_LayoutItem_Field_IsSameField</class>
    <class kind="class">Glom::LayoutItem_Field</class>
    <class kind="class">Glom::LayoutItem_Image</class>
    <class kind="class">Glom::LayoutItem_Line</class>
    <class kind="class">Glom::LayoutItem_Notebook</class>
    <class kind="class">Glom::LayoutItem_Placeholder</class>
    <class kind="class">Glom::LayoutItem_Portal</class>
    <class kind="class">Glom::LayoutItem_Text</class>
    <class kind="class">Glom::LayoutItem_WithFormatting</class>
    <class kind="class">Glom::UsesRelationship</class>
    <class kind="class">Glom::LayoutItem_FieldSummary</class>
    <class kind="class">Glom::LayoutItem_Footer</class>
    <class kind="class">Glom::LayoutItem_GroupBy</class>
    <class kind="class">Glom::LayoutItem_Header</class>
    <class kind="class">Glom::LayoutItem_Summary</class>
    <class kind="class">Glom::LayoutItem_VerticalGroup</class>
    <class kind="class">Glom::Document</class>
    <member kind="typedef">
      <type>std::pair&lt; sharedptr&lt; const LayoutItem_Field &gt;, bool &gt;</type>
      <name>type_pair_sort_field</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a4d496233c15b7b68fbf1430ca004b457</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; type_pair_sort_field &gt;</type>
      <name>type_sort_clause</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>aac29514f502dbc3afd655f88a1a75124</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GlomBakery::View&lt; Document &gt;</type>
      <name>View_Glom</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a3a03874268c9995ac1f9431c4748850b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GlomBakery::View_Composite&lt; Document &gt;</type>
      <name>View_Composite_Glom</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a0d2b1800bbebf8ac2892789b8da66d58</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>libglom_init</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>af89e82bb7f67620b685dc0a0d4714b44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>libglom_deinit</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a665a5a3e65ac061131c030aa677e6834</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; T_obj &gt;</type>
      <name>glom_sharedptr_clone</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a1902f03a9bb43a378976e86808043e4a</anchor>
      <arglist>(const sharedptr&lt; T_obj &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; T_obj &gt;</type>
      <name>glom_sharedptr_clone</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a6d5378b67c1a63a1c74e333dbd3d10e6</anchor>
      <arglist>(const sharedptr&lt; const T_obj &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>glom_get_sharedptr_name</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>ae0d2db905f710560385acdc58553fa3d</anchor>
      <arglist>(const sharedptr&lt; T_object &gt; &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>glom_get_sharedptr_title_or_name</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a616c258fc4689ebd8eb3adbcbdd264c4</anchor>
      <arglist>(const sharedptr&lt; T_object &gt; &amp;item)</arglist>
    </member>
    <member kind="variable">
      <type>const char</type>
      <name>GLOM_IMAGE_FORMAT</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>ac3b184c3ec03b2475714fab2f7c7d460</anchor>
      <arglist>[]</arglist>
    </member>
    <member kind="variable">
      <type>const char</type>
      <name>GLOM_IMAGE_FORMAT_MIME_TYPE</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a88b68c39541524abdb8c1634fefdcad7</anchor>
      <arglist>[]</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::AppState</name>
    <filename>classGlom_1_1AppState.html</filename>
    <member kind="enumeration">
      <name>userlevels</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a2f279293e922b57b080096c2b75815d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USERLEVEL_OPERATOR</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a2f279293e922b57b080096c2b75815d7add9130b87161b0f30eead81d5605f07b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USERLEVEL_DEVELOPER</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a2f279293e922b57b080096c2b75815d7a0cd11138a9ca84a6a80d2f7a8a89e3d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::signal&lt; void, userlevels &gt;</type>
      <name>type_signal_userlevel_changed</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a884b9a86115c0e570aca5682f515d463</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AppState</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a649b630319deb65a77de938692e8bec8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AppState</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>ae50333c4d14f20a5d88b976f14b50891</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual userlevels</type>
      <name>get_userlevel</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a0ce1eb8f2e8953cde66d394d3c6dad8e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_userlevel</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a191adcdc494f374d9088633c02cae3e2</anchor>
      <arglist>(userlevels value)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>emit_userlevel_changed</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>aacd37490e17a9ecaf27598bed59c2f84</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>type_signal_userlevel_changed</type>
      <name>signal_userlevel_changed</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a3480358c40652fda0526490ccbda4927</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::sharedptr</name>
    <filename>classGlom_1_1sharedptr.html</filename>
    <templarg>T_obj</templarg>
    <member kind="typedef">
      <type>size_t</type>
      <name>size_type</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a136c71f35df111e6f6bfa9e03e9917a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T_obj</type>
      <name>object_type</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>acb058473e72cf4f006a7a23ffbbdaf35</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a7749eb805a1a96911d3244bae89611a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a915c7a122a951ec527f04ae985112ef1</anchor>
      <arglist>(T_obj *pobj)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a7e090a36f58b2811717c25cab64cae14</anchor>
      <arglist>(T_obj *pobj, size_type *refcount)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a6102dbc1119f259160e667856633042b</anchor>
      <arglist>(const sharedptr &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a04d5ed27e0cb5ef44d49fadcfeafa928</anchor>
      <arglist>(sharedptr&lt; T_obj &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a203eb1fbaaebde12e9fa2ee7a0f3fd4c</anchor>
      <arglist>(const sharedptr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a1cdd392b3e161e02a16ca205ea54311a</anchor>
      <arglist>(const sharedptr &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; T_obj &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a2de129255dda589fb769e6de3b94247e</anchor>
      <arglist>(const sharedptr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>ab4de9a1efd217faa77e39a1813c4bd0b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>af93fe9dabf864468837057cb430d6817</anchor>
      <arglist>(const sharedptr&lt; T_obj &gt; &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a107f3107052d1d026b54a7dde628cc13</anchor>
      <arglist>(const sharedptr&lt; T_obj &gt; &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a4d421575966613b3eb0862e1d0776419</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>T_obj &amp;</type>
      <name>operator*</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>ace647214b829e740d49a7a760341ee09</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const T_obj &amp;</type>
      <name>operator*</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a249c5d4eef8f2c27c72c4b5c9807cc52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>T_obj *</type>
      <name>operator-&gt;</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a3f3e93d6c6f2f2858f54abcaf3aecdcf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a2a9e0c086b97df95d465d39d29e5467b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>ad854eea3ed6f8bff576b1323d0f458f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>T_obj *</type>
      <name>obj</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a4b254013a623c15f9040b4e26772d399</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const T_obj *</type>
      <name>obj</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a14b85493ef0d6ea82e6305050259ca84</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; T_obj &gt;</type>
      <name>cast_dynamic</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>ad5d33b5025ea64781d42ac2dcfb5cf85</anchor>
      <arglist>(const sharedptr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; T_obj &gt;</type>
      <name>cast_static</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>afb08a5066123a92b73c32df6d924b702</anchor>
      <arglist>(const sharedptr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; T_obj &gt;</type>
      <name>cast_const</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a41155a5e5f5edc47f7a211f8e33deee6</anchor>
      <arglist>(const sharedptr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; T_obj &gt;</type>
      <name>create</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>aeb06d0326d1404fe72a9eb9eeb8dd981</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::ReportBuilder</name>
    <filename>classGlom_1_1ReportBuilder.html</filename>
    <member kind="function">
      <type></type>
      <name>ReportBuilder</name>
      <anchorfile>classGlom_1_1ReportBuilder.html</anchorfile>
      <anchor>a13ca84e0bccb244c69939e46758c1e07</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ReportBuilder</name>
      <anchorfile>classGlom_1_1ReportBuilder.html</anchorfile>
      <anchor>acdf24f227b81b505d2f07db2c524c8c0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_document</name>
      <anchorfile>classGlom_1_1ReportBuilder.html</anchorfile>
      <anchor>ab542882d3546771daa09543ecfa60f05</anchor>
      <arglist>(Document *document)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>report_build</name>
      <anchorfile>classGlom_1_1ReportBuilder.html</anchorfile>
      <anchor>a5b98be6636f5dad19059761353f2fe10</anchor>
      <arglist>(const FoundSet &amp;found_set, const sharedptr&lt; const Report &gt; &amp;report)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>report_build_and_save</name>
      <anchorfile>classGlom_1_1ReportBuilder.html</anchorfile>
      <anchor>a30ca32165dcec68b2dedbc8dc49c68fb</anchor>
      <arglist>(const FoundSet &amp;found_set, const sharedptr&lt; const Report &gt; &amp;report)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; Report &gt;</type>
      <name>create_standard_list_report</name>
      <anchorfile>classGlom_1_1ReportBuilder.html</anchorfile>
      <anchor>ad80193c31211cabb99db9fbc8f97ca4d</anchor>
      <arglist>(const Document *document, const Glib::ustring &amp;table_name)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::predicate_FieldHasName</name>
    <filename>classGlom_1_1predicate__FieldHasName.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>predicate_FieldHasName</name>
      <anchorfile>classGlom_1_1predicate__FieldHasName.html</anchorfile>
      <anchor>a7b14ca1de37ade9e22301fd3a71584d8</anchor>
      <arglist>(const Glib::ustring &amp;strName)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~predicate_FieldHasName</name>
      <anchorfile>classGlom_1_1predicate__FieldHasName.html</anchorfile>
      <anchor>a1ed9865d798553335f7f8a69bef1ff7f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator()</name>
      <anchorfile>classGlom_1_1predicate__FieldHasName.html</anchorfile>
      <anchor>ac772ed0984769f6a73dc919f26f137b1</anchor>
      <arglist>(const T_Element &amp;element)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator()</name>
      <anchorfile>classGlom_1_1predicate__FieldHasName.html</anchorfile>
      <anchor>a0ba37cd302871723594b17229f3fa0aa</anchor>
      <arglist>(const sharedptr&lt; T_Element &gt; &amp;element)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator()</name>
      <anchorfile>classGlom_1_1predicate__FieldHasName.html</anchorfile>
      <anchor>a2238be40ba9eb848a4378287d53dc7dd</anchor>
      <arglist>(const sharedptr&lt; const T_Element &gt; &amp;element)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::Field</name>
    <filename>classGlom_1_1Field.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="enumeration">
      <name>sql_format</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ada8c5d83c1e0937fd60888ce7dc0f6d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SQL_FORMAT_POSTGRES</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ada8c5d83c1e0937fd60888ce7dc0f6d5a3cf3686d521e0d67add2da215a7dba6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SQL_FORMAT_SQLITE</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ada8c5d83c1e0937fd60888ce7dc0f6d5ab56283c9f73d17dd0c0725e061512367</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>glom_field_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_INVALID</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12ca00cf52d1858c9fa384818e30e6361e7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_NUMERIC</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12cad950dc2be538deaf32d1d8a0c3b2ae1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_TEXT</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12ca1c7d059c2af6e8d926faeda822032db6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_DATE</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12ca9022b56a7ca173c9d0bb7d80c68b4995</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_TIME</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12cac9a5b1fff349153aaae3cd82e3cdb69f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_BOOLEAN</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12ca627e8e7391477bfc55396801a93eb483</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_IMAGE</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12ca83e2891317bc48d680d35398ad3e017d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; Glib::ustring &gt;</type>
      <name>type_list_strings</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aafd981325587760ef8d7ba154ef11fb2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; glom_field_type, Glib::ustring &gt;</type>
      <name>type_map_type_names</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a56155f103e46e51360cdd2993590f13f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Field</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ab16773ddcb24e1abf06698394ddeddea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Field</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a47d5af89431e1a0aa03c9d2e0920a1a8</anchor>
      <arglist>(const Field &amp;src)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Field</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aa0cd80c44dcdc16eb9df80a76a807333</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Field &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ae7b077ead4a13ea12632f2c124b8e389</anchor>
      <arglist>(const Field &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a0404d92688dcc5ab74f9455b27d73f5e</anchor>
      <arglist>(const Field &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ae656efcd871323cbdc33f19f91c83397</anchor>
      <arglist>(const Field &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>Field *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ae98793c84128a5a7022c4d4d5db066e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>glom_field_type</type>
      <name>get_glom_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a1c0be7f23eed331e03933c64ae76f8a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_glom_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a3406391c25e522224ea2ad8027bea3aa</anchor>
      <arglist>(glom_field_type fieldtype)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aad54268166b2657723a7446947f26801</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_name</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a17d91155b336c922354c48843924b9df</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_auto_increment</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a194e7066edf0c068c92789cdf798d2fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_auto_increment</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a85f425795b1e92440fac67a0252f1995</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_primary_key</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a4347150af91b26fe0b44691c77b1b483</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_primary_key</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a512e83cec34d698e69e86d7698b5b79a</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_unique_key</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a7ec1971af5993f1ef6cddd8091486d41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_unique_key</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a30976018811becd64286979eb5d7d9fb</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>get_default_value</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ae0a95c5473b7938c605b08596ab4917b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_default_value</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ab47c1ab9feeb66914091319fb42bcfeb</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gnome::Gda::Column &gt;</type>
      <name>get_field_info</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a917f58f6c9c15c2a093e82c825e32fe4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Gnome::Gda::Column &gt;</type>
      <name>get_field_info</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a4467ff420c300199b659bff2103fb653</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_field_info</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a0225380341f4687252524cfa181d537b</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Column &gt; &amp;fieldInfo)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>field_info_from_database_is_equal</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>acfa5b26f62bc28c446ef606f7520afc6</anchor>
      <arglist>(const Glib::RefPtr&lt; const Gnome::Gda::Column &gt; &amp;field)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_lookup</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ad753285064bd881597dc7daa09caf18f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Relationship &gt;</type>
      <name>get_lookup_relationship</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ad35f87b975d716c6266d59d457d8959b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_lookup_relationship</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a06e99b24090775e710146f1609078d3f</anchor>
      <arglist>(const sharedptr&lt; Relationship &gt; &amp;strRelationship)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_lookup_field</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a71eeb4dccbdfb37004a7d509301285e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_lookup_field</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a8950d7de8111a4222c5ab73d131d4ce3</anchor>
      <arglist>(const Glib::ustring &amp;strField)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sql_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a90925cd40a7309423b5f7df9c2b7b5b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_gda_type_name</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a3dbb72491db5f94a100b7d805ef9077f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gnome::Gda::Holder &gt;</type>
      <name>get_holder</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a96e350c8d4ec18b34fd2711f9d242997</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value, const Glib::ustring &amp;name=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_gda_holder_string</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>acc66ee95a44701872b6e280d228d3459</anchor>
      <arglist>(const Glib::ustring &amp;name=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>sql</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a1f08a2e6f26f7adea81fc5ff846cf664</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value, const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;connection) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>sql</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a7eba101ea773462b56919ce084ba4749</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>to_file_format</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aac63bd78c81d3d818e5dba334fbd46bd</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>from_file_format</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a1fc51c5610d4084bfcbb77926fa8d75a</anchor>
      <arglist>(const Glib::ustring &amp;str, bool &amp;success) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>sql_find</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a7f6af900d048b288d806d694b982fcec</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::SqlOperatorType</type>
      <name>sql_find_operator</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a779392a8792e1e0603d0d5aa27b76a7b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_calculation</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a1978cfe72f5e20a01c90779f720eddce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_calculation</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a941efb1d13243d663adfeff41a7f3888</anchor>
      <arglist>(const Glib::ustring &amp;calculation)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_calculation</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a40bfeff3fcd237db92d887f15ac2dc47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>type_list_strings</type>
      <name>get_calculation_relationships</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>afda7d568e1b84835fb0ab564d3e6a982</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_visible</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aa6d99f2ec74aaa32bdf47cddae28f4cc</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_visible</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a428a1225bd43e4d2f7050564739e0765</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>to_file_format</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ae44179e45b5b63d125c6a5f409a0c814</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value, glom_field_type glom_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Gnome::Gda::Value</type>
      <name>from_file_format</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ae327ced903f23e1b5347eb417789e113</anchor>
      <arglist>(const Glib::ustring &amp;str, glom_field_type glom_type, bool &amp;success)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static type_map_type_names</type>
      <name>get_type_names</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a2a9fbdc2129b709682441bcac77e5415</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static type_map_type_names</type>
      <name>get_type_names_ui</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ac0aad53771b673e864ca2e5eb267ebc2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static type_map_type_names</type>
      <name>get_usable_type_names</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a75f3add1adbf94e6284332677c836181</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_type_name_ui</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aa9247323b6a478eb3f5071137d11dbf8</anchor>
      <arglist>(glom_field_type glom_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static glom_field_type</type>
      <name>get_type_for_ui_name</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a52e67b6848bea20dea02f434bf5f833f</anchor>
      <arglist>(const Glib::ustring &amp;glom_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static glom_field_type</type>
      <name>get_glom_type_for_gda_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a6ff5da53f569ff62d80525cb75dd4a16</anchor>
      <arglist>(GType gda_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_gda_type_for_glom_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ade2da04e5bee34dfdb4359e8a2bb8d8c</anchor>
      <arglist>(Field::glom_field_type glom_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>get_conversion_possible</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a4009927f4b9dbfca9e17ecaa8c8883e3</anchor>
      <arglist>(glom_field_type field_type_src, glom_field_type field_type_dest)</arglist>
    </member>
    <member kind="variable">
      <type>FieldFormatting</type>
      <name>m_default_formatting</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a86858b09350d0a64e5c8f8a68e130750</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::FieldTypes</name>
    <filename>classGlom_1_1FieldTypes.html</filename>
    <member kind="function">
      <type></type>
      <name>FieldTypes</name>
      <anchorfile>classGlom_1_1FieldTypes.html</anchorfile>
      <anchor>ac9cc840694ac1ff2017f61846690d34b</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;gda_connection)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FieldTypes</name>
      <anchorfile>classGlom_1_1FieldTypes.html</anchorfile>
      <anchor>a0bdcdb038c32a7b0aa5b9675ce868beb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_string_name_for_gdavaluetype</name>
      <anchorfile>classGlom_1_1FieldTypes.html</anchorfile>
      <anchor>a31372ed25860df9ac7612087f9c4ac8f</anchor>
      <arglist>(GType field_type) const </arglist>
    </member>
    <member kind="function">
      <type>GType</type>
      <name>get_fallback_type_for_gdavaluetype</name>
      <anchorfile>classGlom_1_1FieldTypes.html</anchorfile>
      <anchor>a085a318379cbd6bd7bf260abb899a9a7</anchor>
      <arglist>(GType field_type) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::FoundSet</name>
    <filename>classGlom_1_1FoundSet.html</filename>
    <member kind="typedef">
      <type>std::pair&lt; sharedptr&lt; const LayoutItem_Field &gt;, bool &gt;</type>
      <name>type_pair_sort_field</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>a4bfb5c943cef4b5a5b571b2aba979dbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; type_pair_sort_field &gt;</type>
      <name>type_sort_clause</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>af4a3fcea8b710f06dbcbc7ed6148fd9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FoundSet</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>a4c287194a475ab7d4f9b22521564d11a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FoundSet</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>abd97863cdbbffcef50f4e3cc23718707</anchor>
      <arglist>(const FoundSet &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>FoundSet &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>ab1d7d2b141e71363b68271fc184005af</anchor>
      <arglist>(const FoundSet &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>a408114590c6006b5e73d8764903ece4a</anchor>
      <arglist>(const FoundSet &amp;src) const </arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_table_name</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>af21405a9e9b748acf2704e3886e4b67f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; const Relationship &gt;</type>
      <name>m_extra_join</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>ae76bc6b6344e980b98166c9cdee61a54</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Gnome::Gda::SqlExpr</type>
      <name>m_where_clause</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>a717a83daf941a7af1f004c2cc64e5291</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>type_sort_clause</type>
      <name>m_sort_clause</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>adbb2fd3155dfaa83e44b7cc4dc085ca7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::HasTitleSingular</name>
    <filename>classGlom_1_1HasTitleSingular.html</filename>
    <member kind="function">
      <type></type>
      <name>HasTitleSingular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>aa0c39ce866aeb19abc259c1a2837a421</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HasTitleSingular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a5fdc3e299b428451ca61c33ddfb9dd49</anchor>
      <arglist>(const HasTitleSingular &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~HasTitleSingular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a2383a07ff844ebae9038b588320cccb0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HasTitleSingular &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a20b23a4cac31f668e1f4861d0095e22e</anchor>
      <arglist>(const HasTitleSingular &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a17759330bd64796d6da3f26061c25610</anchor>
      <arglist>(const HasTitleSingular &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a605244ae6c172dcad52db98cad6af476</anchor>
      <arglist>(const HasTitleSingular &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_singular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>acebe8a67348aacd5e735d5f88987d3e1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_singular_with_fallback</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a786b76189efc83864adb4fbcd62abe3d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title_singular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a7b20c72d40b18f355ba673f4d99e0b7a</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; TranslatableItem &gt;</type>
      <name>m_title_singular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a2a6b14f5898388830e09b071092b53cf</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::GroupInfo</name>
    <filename>classGlom_1_1GroupInfo.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="typedef">
      <type>std::map&lt; Glib::ustring, Privileges &gt;</type>
      <name>type_map_table_privileges</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>ac0c0a9cf3ce4d33656a8691d55e564f7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GroupInfo</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>aab4134bcd0e0f328ee2167dd524ba785</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GroupInfo</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>a75ca49042cc16c8fd832fc3946debdc9</anchor>
      <arglist>(const GroupInfo &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~GroupInfo</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>a1283dbf70da8aaf687ec24df17de0aa7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GroupInfo &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>ad1dd9d70cb5755d9120a085d81c243c8</anchor>
      <arglist>(const GroupInfo &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>aba1272fb72097e814696404bc49efb55</anchor>
      <arglist>(const GroupInfo &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>a8837141e8516889ba9ba0efd098e3847</anchor>
      <arglist>(const GroupInfo &amp;src) const </arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_developer</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>a38d0afd82991f1e0d82132a68ddd8c07</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>type_map_table_privileges</type>
      <name>m_map_privileges</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>aae8d6c3c5e6a544d49a80a0500de260a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::NumericFormat</name>
    <filename>classGlom_1_1NumericFormat.html</filename>
    <member kind="function">
      <type></type>
      <name>NumericFormat</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>aaf955d13fa451e126e504d3dc2c87de1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>NumericFormat</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a32243f98e403d8eba8be283a7911162f</anchor>
      <arglist>(const NumericFormat &amp;src)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~NumericFormat</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>af3e680cf6d09f07af1b76ba6c349dfea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>NumericFormat &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>adbe33abed5ce3977ba164c6a3480a8e0</anchor>
      <arglist>(const NumericFormat &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a9b87f17b841f81b3149c1117155c0088</anchor>
      <arglist>(const NumericFormat &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>ae54a335f1c28a4440b8ee5f6d1f8468b</anchor>
      <arglist>(const NumericFormat &amp;src) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_alternative_color_for_negatives</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a5028510bfcbcb32aee9073699441da01</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static guint</type>
      <name>get_default_precision</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a4eb5117e40ee6192902a35c79105b441</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_currency_symbol</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a2138c60199b12fbb39e206c8b7a0be3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_use_thousands_separator</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a0cc3f7af432d63a9ed58f0b1352a9d1d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_decimal_places_restricted</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a00fa7436dfe76375b60a20efa3371bfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>guint</type>
      <name>m_decimal_places</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a551be2f91ec8b1bbd08342b16447950d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_alt_foreground_color_for_negatives</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a687d90667e6d6f4e7ea782e88488347c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::ParameterNameGenerator</name>
    <filename>classGlom_1_1ParameterNameGenerator.html</filename>
    <member kind="function">
      <type></type>
      <name>ParameterNameGenerator</name>
      <anchorfile>classGlom_1_1ParameterNameGenerator.html</anchorfile>
      <anchor>ae46a47e145dd2b1c271326dba042627f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ParameterNameGenerator</name>
      <anchorfile>classGlom_1_1ParameterNameGenerator.html</anchorfile>
      <anchor>a5b511f44628ce35b3bef554b9a9cbf53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_next_name</name>
      <anchorfile>classGlom_1_1ParameterNameGenerator.html</anchorfile>
      <anchor>a4a01b4660eb8af5aa05cba331a3acf19</anchor>
      <arglist>(unsigned int &amp;id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name_from_id</name>
      <anchorfile>classGlom_1_1ParameterNameGenerator.html</anchorfile>
      <anchor>a9d71b392911800dc1afbb054987a64da</anchor>
      <arglist>(unsigned int id)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::PrintLayout</name>
    <filename>classGlom_1_1PrintLayout.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="typedef">
      <type>std::vector&lt; double &gt;</type>
      <name>type_vec_doubles</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a95a2d43865c2ae583b2f1b69159e2078</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PrintLayout</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>aa24618bcdf93f211321336657b8ce440</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PrintLayout</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a5b1c2ddc046b18cf2c3a06a35cca1300</anchor>
      <arglist>(const PrintLayout &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>PrintLayout &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>af452974b6a8fa144a13c64218243a88c</anchor>
      <arglist>(const PrintLayout &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_show_table_title</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a262eb060afda4aae28206387e3bf56c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_show_table_title</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>ad8dbb34ebb40ca05367938cb811ec5b7</anchor>
      <arglist>(bool show_table_title=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_page_setup</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a2bacab030c749af331df465c13ba9d15</anchor>
      <arglist>(const std::string &amp;page_setup)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_page_setup</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>ac1272d3458acb8005a955fc1f4d270df</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_page_count</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a007a19c35a73bf027139cf739812e714</anchor>
      <arglist>(guint count)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_page_count</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>af7453686a4fc0518f9b7105e8a5b43b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_show_grid</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>ab626479b562a545462daa2af3b2ddb37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_show_grid</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>aa559a4a6f253dc53d521193a3d0c4679</anchor>
      <arglist>(bool show_grid=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_show_rules</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>ae88e2820c876cfa3dfa1cff6ff532c29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_show_rules</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a2ae4e7d1114252163d977ac7e5b861e1</anchor>
      <arglist>(bool show_rules=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_show_outlines</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a1d6bb8701aae6d8cee8d4db3cf0802be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_show_outlines</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a7c01eb46aba5ebb59304ebd03aa3655c</anchor>
      <arglist>(bool show_outlines=true)</arglist>
    </member>
    <member kind="function">
      <type>type_vec_doubles</type>
      <name>get_horizontal_rules</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a23c3c0d66e9861abea576824c7ad0168</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_horizontal_rules</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>aa73b4578a0c62985f392dbe7d823c6cc</anchor>
      <arglist>(const type_vec_doubles &amp;rules)</arglist>
    </member>
    <member kind="function">
      <type>type_vec_doubles</type>
      <name>get_vertical_rules</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a06be49334dc418f160ca6955e151d201</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_vertical_rules</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>abffab0cef45d5b5a70a2cdcad75f5e86</anchor>
      <arglist>(const type_vec_doubles &amp;rules)</arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; LayoutGroup &gt;</type>
      <name>m_layout_group</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>aebaeba846e1c45cb86803ebbef33e390</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::Privileges</name>
    <filename>classGlom_1_1Privileges.html</filename>
    <member kind="function">
      <type></type>
      <name>Privileges</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>aa44942247f9f5cd37c0158ea3135253f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Privileges</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>aff22fb4d93c74fb5533903930c0ee02e</anchor>
      <arglist>(const Privileges &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Privileges</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>a62cac50bc16c8f5935245303afcc710a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Privileges &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>a885340a310cb27f174c29e375519fa03</anchor>
      <arglist>(const Privileges &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>a7264e33cc541dd98b27ce1180312a8f8</anchor>
      <arglist>(const Privileges &amp;src) const </arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_view</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>a1f8f0726dc4b89fdd9d909df18ba1dd6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_edit</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>a83b1171087ab5947209e14b82cd93cc4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_create</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>a57d83d9f39bd03c21cdf1e41c24c7590</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_delete</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>ab52ae304f6508b669d766682b21d43b7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::Relationship</name>
    <filename>classGlom_1_1Relationship.html</filename>
    <base>Glom::TranslatableItem</base>
    <base>Glom::HasTitleSingular</base>
    <member kind="function">
      <type></type>
      <name>Relationship</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a94cde292c4af02b28692980f82ef19ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Relationship</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a330ffdd12dc99aae589364a432b19c2f</anchor>
      <arglist>(const Relationship &amp;src)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Relationship</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a94560e4f063db28593bdc56bcbd30877</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Relationship &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a3e10c06dc8bee36e41c1dda026d0cecf</anchor>
      <arglist>(const Relationship &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a2e2ba2b426295ebe9dbed54850ef447a</anchor>
      <arglist>(const Relationship &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>Relationship *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>abeabb4e90d4615cced2b94c490066389</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_from_table</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a3b3e458ca899746fc175f8731ea4ff49</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_from_field</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a08462b33b37d76c0c3a221f4f7ccf528</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_to_table</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a04fc32785f3eea359abfed6831c79ba8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_to_field</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a990a22e48d31b32b738dcc3bdfdbd051</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_from_table</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a41b604bd24c681045dc8ee3fa23c3573</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_from_field</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>acfe2d31f53f95630165be62a173121c4</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_to_table</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a0fcdbf621390747042fea5363f80bf74</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_to_field</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a80c36f036e5d5ec265635b574cd42e18</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_auto_create</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>ae656e6249a01e944f5f7307a9536ee64</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_auto_create</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>ac93cbceb752c10780babe3a9631e22e7</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_allow_edit</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a20b38d5f5a4ded2aa137c3b9fc0fc9ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_allow_edit</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a7cdacd3004b9be677b6d2e480d443753</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_fields</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a6512b2b14220b946b2679ddda4456f88</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_to_table</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>ac93aa928e7eb80165bc8c9b1d2183bdb</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::Report</name>
    <filename>classGlom_1_1Report.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="function">
      <type></type>
      <name>Report</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>ac16b046a107dcb425a9c063be5c76662</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Report</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>a9c08e09fb6722138ca649668d6f85c2f</anchor>
      <arglist>(const Report &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>Report &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>a02a557a43bb0cb59ac3f0260d2d3cad5</anchor>
      <arglist>(const Report &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_show_table_title</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>ad2ce809d2f6c3dee2bae42584f942327</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_show_table_title</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>a169be4aa13172643ecb93377638846e8</anchor>
      <arglist>(bool show_table_title=true)</arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; LayoutGroup &gt;</type>
      <name>m_layout_group</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>aa06fd1de0f21e02409524f9c3402c68c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::SystemPrefs</name>
    <filename>classGlom_1_1SystemPrefs.html</filename>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_name</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>aaa6b3baae3c6c36d70fad0bfb0aa5932</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_name</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>a4c77401a02d4d8d916b7549d01abcf7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_street</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>a49def901c0c857f7114b2659bd621c6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_street2</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>aa8d9cfd0ca0673c07ad95b454e2990bd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_town</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>a64ab452bd2ba2dbd00c6ad4b185a9772</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_county</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>a0ed741d895302266d54f1c4c319b89e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_country</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>ab4528856d49e81dd0720c81f4699a1b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_postcode</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>ab5e758740c2f6defa091f98307d77cba</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Gnome::Gda::Value</type>
      <name>m_org_logo</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>ab3d3a3730e198564e4702ec3e2bee844</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::TableInfo</name>
    <filename>classGlom_1_1TableInfo.html</filename>
    <base>Glom::TranslatableItem</base>
    <base>Glom::HasTitleSingular</base>
    <member kind="function">
      <type></type>
      <name>TableInfo</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>aad05b7307836a9b7548e5161ba6cd8f2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TableInfo</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>a9557bc606d9bb73c58544ed90c962b55</anchor>
      <arglist>(const TableInfo &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>TableInfo &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>acc160e1cf3e0c85d2a48dfd4995ab287</anchor>
      <arglist>(const TableInfo &amp;src)</arglist>
    </member>
    <member kind="variable">
      <type>guint</type>
      <name>m_sequence</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>a19e6003776b7826467dddf1c99cfe5e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_hidden</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>aa532f7a43eeda83a050df796ca6ac4fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_default</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>a216ce24bbbe21dfc1fca9ee90c5b3b24</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::TranslatableItem</name>
    <filename>classGlom_1_1TranslatableItem.html</filename>
    <member kind="enumeration">
      <name>enumTranslatableItemType</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_INVALID</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09aa0e068f4c925e126640b5713d30df90d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_FIELD</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a0d44075d1d61db1c44573ee2fc1d7085</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_RELATIONSHIP</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a351c7ac2e55e769d65eb352ab56d259d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_LAYOUT_ITEM</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a5b6a542b337cf60fdfeeb14fc81df55e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_CUSTOM_TITLE</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a9ac77fa3c1931a962640283b55f6be2a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_PRINT_LAYOUT</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a4d90339e4e1360096b7b3e2cce3b6694</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_REPORT</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09acc95af040162973a318d31805618bceb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_TABLE</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09ae7222449dfa5a27b485267d70a587fcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_BUTTON</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09abb8fada243c986dc43e4795155bf1e07</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_TEXTOBJECT</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a6174f2152734f488adfe3d572f746a66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_IMAGEOBJECT</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a4a84bd31da6cda2d3bb4a1d522d794b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; Glib::ustring, Glib::ustring &gt;</type>
      <name>type_map_locale_to_translations</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a1c9755f8567b4247f4a37bb46435f4c5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TranslatableItem</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a59d9f54952fb3953c70c3cf79e5b0397</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TranslatableItem</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a6d86fb79fc616db7ba0ac5005d0e74c1</anchor>
      <arglist>(const TranslatableItem &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~TranslatableItem</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ab51c8f9f14efe502dc9d3d438dcb765a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>TranslatableItem &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>afdbcbf1375c65a72fde249add210f109</anchor>
      <arglist>(const TranslatableItem &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ae33a145dda75b7322e7a5f2a5635f8d8</anchor>
      <arglist>(const TranslatableItem &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a1c80c03608eedd719b36f9e917d92bbe</anchor>
      <arglist>(const TranslatableItem &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_name</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a1d92c4d6473471e3a31ccfd2608f8302</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a77169f3b9749c430de2237cfae53bd1b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_name_not_empty</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>aa1c2999c30fc5878b9c55eeaafa1d04d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_title_or_name</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>abc0158ffa6f80e3c8bdbe3d3071a7d55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_title</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a6967d010259af8203a6c05fede769acd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a8f13a76fb5816066c85343626eba0057</anchor>
      <arglist>(const Glib::ustring &amp;locale) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_original</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ac06d29f1097153cd6bd47eb97739869f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a9252d016031a8a553e54844b085f1ee1</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a18e23a932295d1969d27e02b20d17986</anchor>
      <arglist>(const Glib::ustring &amp;locale, const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title_original</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a9a6619911111f34afbb378e477366048</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_translation</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a679816b224ce7c2a6bcf18dcb82394b7</anchor>
      <arglist>(const Glib::ustring &amp;locale, const Glib::ustring &amp;translation)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_translation</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ac9dc3a4c56155779a561fe56fc1f7c26</anchor>
      <arglist>(const Glib::ustring &amp;locale) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_title_in_all_locales</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ad972e58a60f9d2a7458e2abd1253b75f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_translations</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a627b76316a98caa6e84f4f12eb2e8e65</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>enumTranslatableItemType</type>
      <name>get_translatable_item_type</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a8662cbbb35e38fd76b4aeef8ac4961fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_translatable_type_name</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>af948c5c1a66dd832543f311887ba4d8c</anchor>
      <arglist>(enumTranslatableItemType item_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_translatable_type_name_nontranslated</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>afd55350c7ad05e7be1e03de43fb83608</anchor>
      <arglist>(enumTranslatableItemType item_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_current_locale</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a81875b54db0d67a549e649f6fd16a397</anchor>
      <arglist>(const Glib::ustring &amp;locale)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_current_locale</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a3b5f30c2f6531b15076a246c621ff308</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_original_locale</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a4e71600170a2ae89b2ab6bf2e08836cd</anchor>
      <arglist>(const Glib::ustring &amp;locale)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>get_current_locale_not_original</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ad5b60e33c27396f5ac3126f87ce9c2a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>enumTranslatableItemType</type>
      <name>m_translatable_item_type</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ab4ef5af7ccfc36bbf2f5feb23918b9f6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::CustomTitle</name>
    <filename>classGlom_1_1CustomTitle.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="function">
      <type></type>
      <name>CustomTitle</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>a83b387ddcc97c0e6305fd01ecf024c1a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CustomTitle</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>ac372dc9e7e50789eafd5e9e339e29706</anchor>
      <arglist>(const CustomTitle &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>CustomTitle &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>a2ddbdb3a5e017514ea8f313a3f22af4b</anchor>
      <arglist>(const CustomTitle &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~CustomTitle</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>a655048366beddddc589b79f5772f4100</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>ae9de8d727f7891656d4de1df2df5dca4</anchor>
      <arglist>(const CustomTitle &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_use_custom_title</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>aa88c42fa7f233511bc8cd96bd34347b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_use_custom_title</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>a0b700c95ca30481b7e029df969dcde53</anchor>
      <arglist>(bool use_custom_title=true)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::FieldFormatting</name>
    <filename>classGlom_1_1FieldFormatting.html</filename>
    <base>Glom::UsesRelationship</base>
    <member kind="enumeration">
      <name>HorizontalAlignment</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a9e0dd58899dc50f6128742a2f531f709</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HORIZONTAL_ALIGNMENT_AUTO</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a9e0dd58899dc50f6128742a2f531f709ab2f4faba7018584860cbe42142c0b324</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HORIZONTAL_ALIGNMENT_LEFT</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a9e0dd58899dc50f6128742a2f531f709aa28648b7b0ea81073dbc6ca26d246847</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HORIZONTAL_ALIGNMENT_RIGHT</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a9e0dd58899dc50f6128742a2f531f709ace7cebab10575d11aa5dfe93e874f11f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; Gnome::Gda::Value &gt;</type>
      <name>type_list_values</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>af2fd1be87ba4d56bd91a15d14fdf655b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FieldFormatting</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a324953d7d2a70acf6a0d09526aa49693</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FieldFormatting</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a60281263b2a706ba7b77044c5244686f</anchor>
      <arglist>(const FieldFormatting &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>FieldFormatting &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a0ce74a2248a48d4bff161fabad41c204</anchor>
      <arglist>(const FieldFormatting &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FieldFormatting</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a36b6397780df7b02bfda107d91981d1e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a07b919f21a55568c4de9431f4b27ac41</anchor>
      <arglist>(const FieldFormatting &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a936095f1607a70e1ea3f9524318a87c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_related_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>aec1be05e6f8283f84c0dcf6a713a011b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_related_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a68e6b2a9c57631c84820751fed8dff27</anchor>
      <arglist>(bool &amp;show_all, bool &amp;with_second) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_has_related_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a8dd266633e776f32309785aeb0120a8c</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_custom_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>abf5a7d3bd42d0faf269db5d9ddcf818d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_has_custom_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>aecadbbe6a9446f4a1624252d0400c514</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual type_list_values</type>
      <name>get_choices_custom</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>ac7c30da4b795b4758351933beb8862e1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_choices_custom</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a5085ef4eff25b51ab3daa42de5cc8f10</anchor>
      <arglist>(const type_list_values &amp;choices)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_choices_restricted</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a0e2ea102b0fb0d814e958e19932557ab</anchor>
      <arglist>(bool &amp;as_radio_buttons) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_choices_restricted</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a913266eb2bed0e334454dad2e3acbd25</anchor>
      <arglist>(bool val=true, bool as_radio_buttons=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_choices_related</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a7e07ed04785bf05792db3e815f7d209c</anchor>
      <arglist>(sharedptr&lt; const Relationship &gt; &amp;relationship, sharedptr&lt; LayoutItem_Field &gt; &amp;field, sharedptr&lt; LayoutGroup &gt; &amp;extra_layout, bool &amp;show_all)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_choices_related</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a5ffee51ef9933ae3bc10680e3527d8fb</anchor>
      <arglist>(sharedptr&lt; const Relationship &gt; &amp;relationship, sharedptr&lt; const LayoutItem_Field &gt; &amp;field, sharedptr&lt; const LayoutGroup &gt; &amp;extra_layout, bool &amp;show_all) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_choices_related</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>aec61e2dc21f01ee1d73ea1c4fee9fd65</anchor>
      <arglist>(const sharedptr&lt; const Relationship &gt; &amp;relationship_name, const sharedptr&lt; LayoutItem_Field &gt; &amp;field, const sharedptr&lt; LayoutGroup &gt; &amp;extra_layout, bool show_all)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const Relationship &gt;</type>
      <name>get_choices_related_relationship</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a6f4a7e1791c51c6be701aaebe3207db9</anchor>
      <arglist>(bool &amp;show_all) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_text_format_multiline</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a87b8fc92401ae238e9c13dce88afeb35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text_format_multiline</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a32651adde2e28c69c441bb0a2e4019d8</anchor>
      <arglist>(bool value=true)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_text_format_multiline_height_lines</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a84d92c8621b279feaa403d97c94e7035</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text_format_multiline_height_lines</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a0ac2bb0727ac828cedce15f2333be63e</anchor>
      <arglist>(guint value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text_format_font</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a9feafa8a602bd7501fe5cf5d94daeb4a</anchor>
      <arglist>(const Glib::ustring &amp;font_desc)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_format_font</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a1e346ff2d265a1d328d1986d1ffa5b47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text_format_color_foreground</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>adeebfc014989cbc9e1799b91fd6e1a46</anchor>
      <arglist>(const Glib::ustring &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_format_color_foreground_to_use</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a68fe9ba2e9c5732852b2944c4b2236a1</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_format_color_foreground</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>abfa7355dfef0fd2a179d3b2b094ce1a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text_format_color_background</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a6ded5f1a442d1227cc29747a8b545b5a</anchor>
      <arglist>(const Glib::ustring &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_format_color_background</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>ae368aa78ca42de29060df3abed4cbb8e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_horizontal_alignment</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>ae78d7d92b21db21d69ac414b4f59926c</anchor>
      <arglist>(HorizontalAlignment alignment)</arglist>
    </member>
    <member kind="function">
      <type>HorizontalAlignment</type>
      <name>get_horizontal_alignment</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a91fda4dce2e3a773ac3a0894b52a2e72</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>change_field_item_name</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>ab4258f03d2263e5ae381ce4b48a68eaa</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name_old, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="variable">
      <type>NumericFormat</type>
      <name>m_numeric_format</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>ae1e666e03916c892cd44f3cd16255d55</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutGroup</name>
    <filename>classGlom_1_1LayoutGroup.html</filename>
    <base>Glom::LayoutItem</base>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; LayoutItem &gt; &gt;</type>
      <name>type_list_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a5444b6f4cd0a9f227dc4ee06fe3b3cf0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; const LayoutItem &gt; &gt;</type>
      <name>type_list_const_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>af8b21f87bf200e1eb5362f2ce60e8e4a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutGroup</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>ab6f26b67e8f5ac3d1663435efc517950</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutGroup</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>ad28231f56022d8e89693d72136b9ea8c</anchor>
      <arglist>(const LayoutGroup &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutGroup &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>aaa8a5bba0d9680acc8ae21c60674899d</anchor>
      <arglist>(const LayoutGroup &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutGroup</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>af1e2feb8df081463c5f02851abbbe87c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a1ddf5c761622a415411253a265a67027</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_field</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>acf1fe5c384be59079712a45b1ee62f83</anchor>
      <arglist>(const Glib::ustring &amp;field_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_any_fields</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>affc3a68341d7ffff6fc3df720a677fda</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_item</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a2f600f375268eda33a8f87affe1e2940</anchor>
      <arglist>(const sharedptr&lt; LayoutItem &gt; &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_item</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>acf3a338ec10048565183f5f42e71f6f5</anchor>
      <arglist>(const sharedptr&lt; LayoutItem &gt; &amp;item, const sharedptr&lt; const LayoutItem &gt; &amp;position)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_item</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a948a966cd9828181f58247d74cedcc0b</anchor>
      <arglist>(const sharedptr&lt; LayoutItem &gt; &amp;item)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>remove_field</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>ac1f6cbefa5a2e8c13e5ab588e3b1de99</anchor>
      <arglist>(const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>remove_field</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>aac5a0d1ed7c9510fc5e33ada6acba94d</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a782b22d60d283514519d5853cc4d4791</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_related_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a602a9612a4ff78598f5b02688f9cba70</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>remove_relationship</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a8a93478039c6c4bd9a432d2a1ef7da34</anchor>
      <arglist>(const sharedptr&lt; const Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_all_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>ab59d9816e75104f40f00ccdbcbdab22e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_border_width</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>ae18431459e3d9ebfddcb1f70611f9b7b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_border_width</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a5e8081f3580ce4a9ee15c58a6215c4a3</anchor>
      <arglist>(double border_width)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_items_count</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>afd4f75d0f44bd3271763973853133a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_columns_count</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a1fa9afce617b16ccedeb39e74a8cc1ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_columns_count</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a6e72f4a42d7332dfe32429d5036f39ce</anchor>
      <arglist>(guint columns_count)</arglist>
    </member>
    <member kind="function">
      <type>type_list_items</type>
      <name>get_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>aa8afa06e32af948046dcacf8ec54c5df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>type_list_const_items</type>
      <name>get_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>aa1725fd135554a0637ad1d00f68c0333</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>type_list_const_items</type>
      <name>get_items_recursive</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a365ddadcd1a6027c95aaa99f5380db35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>type_list_items</type>
      <name>get_items_recursive</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a7dbc8ffb45e9b4b8d4a1bb304e40079d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a634bd443769eb5cb7806b6003d50298b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a7de834453116afaadf759c1793743d32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>type_list_items</type>
      <name>m_list_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a39cb33d72ffed3ddaad8930c773e385a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem</name>
    <filename>classGlom_1_1LayoutItem.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a370b521941530a78789bca5628b7dd5f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a193bc6da7f754929c242fdcc58a5862a</anchor>
      <arglist>(const LayoutItem &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>aa68eb6b1540dda91d1e5db768e8a6cc1</anchor>
      <arglist>(const LayoutItem &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>abcfb3b2398aa99cd41fde144f95b5f4e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>aec14051b9835ffc6b370847bbba39234</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>ad07e79bf80a127b9581039b504bda49f</anchor>
      <arglist>(const LayoutItem &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>get_editable</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>abaed7e31de4a7b3a228ff9d7468359d1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_editable</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>ab432aa3e83f9c8d3333d92c0ce541f2f</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_layout_display_name</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>ab7d9a251ecd46551198878528623b1ce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a294c70c200ae58a60b1764419fd962f9</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>aa7f041f7f67d684532ca0e0d035865e7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_display_width</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>ab893b325d963cad72ae557d9e55fb028</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_width</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a45c16168ebc8e42034c4be660f85ea97</anchor>
      <arglist>(guint value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_print_layout_position</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>ae4f9461068589f667c4076bfae665211</anchor>
      <arglist>(double &amp;x, double &amp;y, double &amp;width, double &amp;height) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout_position</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a0772df4266c5ef33161ba9e61b3f0c4a</anchor>
      <arglist>(double x, double y, double width, double height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout_position_y</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a871eccfb0235967dae9f2e559f43b0e3</anchor>
      <arglist>(double y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout_split_across_pages</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>afec222cdd038e9c8821aa19209911d26</anchor>
      <arglist>(bool split=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_print_layout_split_across_pages</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a4ec5a36401301273708a2578a5ad2066</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Button</name>
    <filename>classGlom_1_1LayoutItem__Button.html</filename>
    <base>Glom::LayoutItem_WithFormatting</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Button</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a00b3f32c5de0f54a75b7c3b43ea67df7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Button</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a2a4ff9550af019cae8483f91e8480f57</anchor>
      <arglist>(const LayoutItem_Button &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Button &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>acf38a587ada5b5385f32ddcd089e79c1</anchor>
      <arglist>(const LayoutItem_Button &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Button</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a672fe5d19abc8ca872c61171db9fd87f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>ab21e53587b70467ca19e02832c5313a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>acd7d494fd05a26c1a54911fcff348ffa</anchor>
      <arglist>(const LayoutItem_Button &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a1688d872d97a30860e8a116ad080129a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_script</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a17a9f7f4a29eef0d493067d567f09663</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_script</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>aedd2bb0ab0a11abc2a0ae72c06c676fd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_script</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a81253a97704133bc0a4a12cebdab6764</anchor>
      <arglist>(const Glib::ustring &amp;script)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_CalendarPortal</name>
    <filename>classGlom_1_1LayoutItem__CalendarPortal.html</filename>
    <base>Glom::LayoutItem_Portal</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_CalendarPortal</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>af51129ed35a198ff4af45f19302a82d9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_CalendarPortal</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a160ecf721711fd7245a18b6c5cdd6d20</anchor>
      <arglist>(const LayoutItem_CalendarPortal &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_CalendarPortal &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a3690429a0898c800925148618e6b53a6</anchor>
      <arglist>(const LayoutItem_CalendarPortal &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_CalendarPortal</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a148637c95541f3ff639aa5d0e4ce93a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>adb5e7757076a6f76bdebc61196833d07</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a8591138cfa51a4e3ae109c790f6ad80e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Field &gt;</type>
      <name>get_date_field</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>ac25a7693d3206c5a7a831601b501e5bd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const Field &gt;</type>
      <name>get_date_field</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>abacf290a745eacaba0d767b400bf87d0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_date_field</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a9c6fd10f1b7f9a4ceb521fb9a461f301</anchor>
      <arglist>(const sharedptr&lt; Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a21ba211a5d784363fdd4bdac42c7c790</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_related_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>aec5b8b069543b47ae537970595821bae</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::predicate_LayoutItem_Field_IsSameField</name>
    <filename>classGlom_1_1predicate__LayoutItem__Field__IsSameField.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>predicate_LayoutItem_Field_IsSameField</name>
      <anchorfile>classGlom_1_1predicate__LayoutItem__Field__IsSameField.html</anchorfile>
      <anchor>a0caaf532f226ff5044634b5c3bc3cd0f</anchor>
      <arglist>(const sharedptr&lt; const T_Element &gt; &amp;layout_item)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator()</name>
      <anchorfile>classGlom_1_1predicate__LayoutItem__Field__IsSameField.html</anchorfile>
      <anchor>a93aaee3a50d1f53001c0660ae194d3b5</anchor>
      <arglist>(const sharedptr&lt; const T_Element &gt; &amp;element)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Field</name>
    <filename>classGlom_1_1LayoutItem__Field.html</filename>
    <base>Glom::LayoutItem_WithFormatting</base>
    <base>Glom::UsesRelationship</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Field</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a312279764f2e2b122e72175e7c784491</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Field</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a83995649de46f3b46768f79022e93b07</anchor>
      <arglist>(const LayoutItem_Field &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Field &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a51ab08b4c2fe1e3216278205ccd8345c</anchor>
      <arglist>(const LayoutItem_Field &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Field</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>acc10b38c3fd09adf745877289c5519c7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>adb84dde6619536fb5d1cbfa723318e62</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a3a2ac0bc68570560609f8226aef49ff9</anchor>
      <arglist>(const LayoutItem_Field &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a5e96a2b505a5729ebecc1005a9ac1a7c</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>aa0248c59510ec98e8b954d6ecfcb4cb1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_title</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a695d0e0eaf0d0c002e76c0b670338937</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_title_or_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>acef5bef9eb93985917efa88b0ec26837</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_or_name_no_custom</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a268a810908b775c13e782b801bac55ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const CustomTitle &gt;</type>
      <name>get_title_custom</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>af7585cb570b7d2cbe97565923b1547bf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; CustomTitle &gt;</type>
      <name>get_title_custom</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>afa37c8c67e87952027215bf3ed0d7d06</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title_custom</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a92e701f44e8b59cad3235cac4a301cd2</anchor>
      <arglist>(const sharedptr&lt; CustomTitle &gt; &amp;title)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_layout_display_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>aca877212b1731c41f905fed3f2e7261b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>ae18e50675595ea39d3c7c8e0eaaa5318</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a2563ec56502589479bb2ec2ec21ed205</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_full_field_details</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a9ab952dfe0242c0eca45a6fc3fb5d8df</anchor>
      <arglist>(const sharedptr&lt; const Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const Field &gt;</type>
      <name>get_full_field_details</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>af176258e62a5906ca2a67d0e913e2f99</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Field::glom_field_type</type>
      <name>get_glom_type</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a4f988b415db9bd4aa4e5c8488d4e2998</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_editable_and_allowed</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a90d532d50123f0094940cf0b7dc9a91a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_hidden</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>af2eb4539b3550bc75d0adff0e364b82d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_hidden</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a9a1015d10fc93c8810c8d460313f25d6</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_formatting_use_default</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a118b982f10589e3f0306c62aa84d2695</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_formatting_use_default</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a2e3083a50fe5c26e63f496e3a46a3268</anchor>
      <arglist>(bool use_default=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const FieldFormatting &amp;</type>
      <name>get_formatting_used</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a21a4fa8e655e979e49246d11c5154444</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual FieldFormatting::HorizontalAlignment</type>
      <name>get_formatting_used_horizontal_alignment</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a25f5b99cdca4e2961fb5f8d2cff5d990</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_same_field</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a56d81dae9c69e16ae9742c59150f1c0e</anchor>
      <arglist>(const sharedptr&lt; const LayoutItem_Field &gt; &amp;field) const </arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_priv_view</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a89c7f17a6fe692c7e2388032cd1cec96</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_priv_edit</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a2bf327f386eaf382447e1f7dc8f57d97</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Image</name>
    <filename>classGlom_1_1LayoutItem__Image.html</filename>
    <base>Glom::LayoutItem</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>aad409f1b3b0248e49f78e9b18263bbbb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a1167f8d69a599aa2954bd3f6777aa55b</anchor>
      <arglist>(const LayoutItem_Image &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Image &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a1c93fc8ace0dd45bb912cb5103ac4b3a</anchor>
      <arglist>(const LayoutItem_Image &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a99f1ba6c5be562b567d957d9c90b0bc1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>aefd3186f7ccd65c8d4992885443c82cc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a1361251a5f1a68473f8cd0e734e210fd</anchor>
      <arglist>(const LayoutItem_Image &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a06b49e2e856ba3d175dc9900ca7481fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a5c3ded4748529c109f8fc771595aba4e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>get_image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a71112b07fca1b96c24b657a1530857e5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a6d85bae161efeafc6be7a25bc950e7a2</anchor>
      <arglist>(const Gnome::Gda::Value &amp;image)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>create_local_image_uri</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a995973b3bc0a34e784b03857ddf05b8b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>Gnome::Gda::Value</type>
      <name>m_image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>ad73ae1d7a678f8b3395b9301905422a0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Line</name>
    <filename>classGlom_1_1LayoutItem__Line.html</filename>
    <base>Glom::LayoutItem</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Line</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a56566dcba44ad36603724e1aeaa00e9b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Line</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a09512d126a5e21f038025a01027ed8a6</anchor>
      <arglist>(const LayoutItem_Line &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Line &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a77ef7cc070a42a709080b3f220ad2dd7</anchor>
      <arglist>(const LayoutItem_Line &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Line</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a78c4bb191f4a5ff2e33b6f50a744b51d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a2bf6fcf8c42dc9749296c9a4c09884dd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a1d4a3a10824a01d06550e75bc70903cb</anchor>
      <arglist>(const LayoutItem_Line &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>ae5422861e4b17f540958ca066b193097</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>ab304d1dc4baff0d88cad3cd6a6a2f0a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_coordinates</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>afefd4f89604aaa0cf28ac8b9e89f9ea8</anchor>
      <arglist>(double &amp;start_x, double &amp;start_y, double &amp;end_x, double &amp;end_y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_coordinates</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a296b6a81745f8bfd80c9d4d9a2356f1e</anchor>
      <arglist>(double start_x, double start_y, double end_x, double end_y)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_line_width</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a02f77947d7837a497884780f4d9e6ea1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_line_width</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a90de85c150524c8f03245d3e1212c560</anchor>
      <arglist>(double line_width)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_line_color</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a699c7285e9ef853e174af3e4890f5918</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_line_color</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a10731087f63c58df78c58a8cbe5ff774</anchor>
      <arglist>(const Glib::ustring &amp;color)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Notebook</name>
    <filename>classGlom_1_1LayoutItem__Notebook.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Notebook</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>a1db785b35a8a27e0168e07040e06ada0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Notebook</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>a5a88eac42b2ce249535524bd1f605fe9</anchor>
      <arglist>(const LayoutItem_Notebook &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Notebook &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>abd93103fdc0270208a174e958b4d3d81</anchor>
      <arglist>(const LayoutItem_Notebook &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Notebook</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>a37314fb234b269926fb96655053fb369</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>afbaeb08aa14f882d5e2130ab9277ca20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>a2eb0a6017bddf620fd743f1eb586b1ba</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Placeholder</name>
    <filename>classGlom_1_1LayoutItem__Placeholder.html</filename>
    <base>Glom::LayoutItem</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Placeholder</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>a5e2da34b8731604cc7147f4c736f74c9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~LayoutItem_Placeholder</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>aa9eb7caa697c5df480c5557075d626f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Placeholder</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>aafc3689d681ea80b8ed88bbbe205fb1e</anchor>
      <arglist>(const LayoutItem_Placeholder &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>a35cb8c68a84a45c02b73c84361f698bb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>a572489919f4cf00e478a7b0cb11b6611</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>a6cfd34400b8f169bcdac845cb2cf1f94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>aa4712068ad68656f2ece7f5ff6a68990</anchor>
      <arglist>(const LayoutItem_Placeholder *src) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Portal</name>
    <filename>classGlom_1_1LayoutItem__Portal.html</filename>
    <base>Glom::LayoutGroup</base>
    <base>Glom::UsesRelationship</base>
    <member kind="enumeration">
      <name>navigation_type</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>aee2aed2ac459d4f6a0e32b6b6c9f0f75</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NAVIGATION_NONE</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>aee2aed2ac459d4f6a0e32b6b6c9f0f75a329b6c6510b5d604146a8b20aad5af9b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NAVIGATION_AUTOMATIC</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>aee2aed2ac459d4f6a0e32b6b6c9f0f75a1bd463cd69729f739cbd493b27a2cdcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NAVIGATION_SPECIFIC</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>aee2aed2ac459d4f6a0e32b6b6c9f0f75a0db576ac945533ba968c47c548ed79fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Portal</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ac3f6ee86b16bf685a1865ca4af56ffcf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Portal</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a954b4241b93c441733d4efccfc273551</anchor>
      <arglist>(const LayoutItem_Portal &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Portal &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a43edecb7d7ef207f571022899d006260</anchor>
      <arglist>(const LayoutItem_Portal &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Portal</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>aa09b2ee368553c600d8793699c454816</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ad2b7fa5dc4e10ea20419a38b033de855</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_title</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ad683c1e62220ab834b6d662ff7528db9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_title_or_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ac849e0e44b2d1ec58ad36d3a5f79c571</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ac367919be804872aa902578b678c5705</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a03538cdb5aaa32ff28f853294f92515e</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_related_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a57445965ca4471e5fce086bd3a532519</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_from_table</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>acdb03d31a8822f900c7baf42b2dbe026</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; UsesRelationship &gt;</type>
      <name>get_navigation_relationship_specific</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a95e5f43421d21e805695c8789e8cf2e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const UsesRelationship &gt;</type>
      <name>get_navigation_relationship_specific</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>aaffff294ec775a400fa3def7d2be08bc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_navigation_relationship_specific</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a0f8420d7b9f54e5a42e6f98fea43ced7</anchor>
      <arglist>(const sharedptr&lt; UsesRelationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset_navigation_relationship</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ae115a916fb3cc3e510d9cdeba2be20da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>navigation_type</type>
      <name>get_navigation_type</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a7919b2be87e5e2f9de31e19597b1282b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_navigation_type</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a4b6e005d2800eb04995b9c641872bb65</anchor>
      <arglist>(navigation_type type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_suitable_table_to_view_details</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ae9431f02555153084df6f562a7b12167</anchor>
      <arglist>(Glib::ustring &amp;table_name, sharedptr&lt; const UsesRelationship &gt; &amp;relationship, const Document *document) const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const UsesRelationship &gt;</type>
      <name>get_portal_navigation_relationship_automatic</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a426fde8bbffc4889c4bb08282db4d526</anchor>
      <arglist>(const Document *document) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_print_layout_row_height</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a0fc8ea5d4186768c8d029cd585a94823</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout_row_height</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ad30c7ab27c5af843f2aba81f31e7bc48</anchor>
      <arglist>(double row_height)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_print_layout_row_line_width</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>af0f846bd5913e00933ad489c29ae5cf0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout_row_line_width</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a935e51fb356b70139bb3e5856bfcb7d3</anchor>
      <arglist>(double width)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_print_layout_column_line_width</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a41b913c6a72b1ef550f1ec96182e1c06</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout_column_line_width</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ae3e8454174c06036606636c36dd7d2c8</anchor>
      <arglist>(double width)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_print_layout_line_color</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>acafecb5c818c16e8e32378e3808f6359</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout_line_color</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>abc31e267981d9470ac82876db578a6ef</anchor>
      <arglist>(const Glib::ustring &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_rows_count</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ac864524195fefaf6fc49c18270eef87e</anchor>
      <arglist>(gulong &amp;rows_count_min, gulong &amp;rows_count_max) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_rows_count</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a1d507ac7e721307e940bc762e560ec9a</anchor>
      <arglist>(gulong rows_count_min, gulong rows_count_max)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Text</name>
    <filename>classGlom_1_1LayoutItem__Text.html</filename>
    <base>Glom::LayoutItem_WithFormatting</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a5cf0aa60dacdba7f3294bb34e777b0d1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>afe3b7b46f6690b54d9e5f0dadb3a7cd1</anchor>
      <arglist>(const LayoutItem_Text &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Text &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>aa2cde544e052ad1b4fdcd6492ec145f4</anchor>
      <arglist>(const LayoutItem_Text &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a1a2ad4428f294a78a402eafd00e27168</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a9454fdbd40c634be172306978c1f660c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a1a27554f574c0489086afc6b8962c0c5</anchor>
      <arglist>(const LayoutItem_Text &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a8ca162c630f723d3aa443a7db6d4b519</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>acda4996ffb302eb596d4beb7baf87ad5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>ae67f458a315a2ee7bed6f75bd70bd65a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a61a075fb2a7c20a18c65a668a29dce8e</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; TranslatableItem &gt;</type>
      <name>m_text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>ac28edbfeef06c5bc6f9ad122994d9933</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_WithFormatting</name>
    <filename>classGlom_1_1LayoutItem__WithFormatting.html</filename>
    <base>Glom::LayoutItem</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_WithFormatting</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>a3af7021b565392474390d225bcf6840e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_WithFormatting</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>ab362e44a2c211cd24a8372871a85a6db</anchor>
      <arglist>(const LayoutItem_WithFormatting &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_WithFormatting &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>aa0c0c041d7c00e11d8414a18b9d43b82</anchor>
      <arglist>(const LayoutItem_WithFormatting &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_WithFormatting</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>aec0e9171c508e98e8dfb2fe1686024f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>abc75b88f0302d9faf23a010dde2c52ef</anchor>
      <arglist>(const LayoutItem_WithFormatting &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const FieldFormatting &amp;</type>
      <name>get_formatting_used</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>aeba371dfb49f97e92ce115ef3a297808</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual FieldFormatting::HorizontalAlignment</type>
      <name>get_formatting_used_horizontal_alignment</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>ad7fcdcffa05187c345675e793fa56559</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>FieldFormatting</type>
      <name>m_formatting</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>a649bca5ff5f9e2f1a14d897b80d59c7a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::UsesRelationship</name>
    <filename>classGlom_1_1UsesRelationship.html</filename>
    <member kind="function">
      <type></type>
      <name>UsesRelationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a08d9232e304a6be1929f826c07be8401</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UsesRelationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>ad1c70e67858276fa99873c02ff8a792b</anchor>
      <arglist>(const UsesRelationship &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>UsesRelationship &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>af4fb6ac7c853d638f6f8d0b804af8e0a</anchor>
      <arglist>(const UsesRelationship &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UsesRelationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>af5bfa953f8b4a33bd715c74e9530d435</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a854b7d9573391af22ffd58a315e27f24</anchor>
      <arglist>(const UsesRelationship &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_relationship_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a8de43ba6a30c8f6d0b59dfe7dd1d070b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_related_relationship_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a77c12cb5a554e4364992394492e64178</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_relationship_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>ab6ea484067457f54de8895d34fe6c2dc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_related_relationship_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a7d15ed810c92859fb53a82e26b5face0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const Relationship &gt;</type>
      <name>get_relationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a40cfa11ef5fdf8d3c0e3e16085cad938</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_relationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a74095e72197767f88d82c46a7e34a736</anchor>
      <arglist>(const sharedptr&lt; const Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const Relationship &gt;</type>
      <name>get_related_relationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>abcf10758be1aab7fa9c9fbef1bead50e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_related_relationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a54efb0dfb756d96fbb8b5158ea987d1f</anchor>
      <arglist>(const sharedptr&lt; const Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_table_used</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a9c318b7b53b289b2cce4b7a2837c6ac3</anchor>
      <arglist>(const Glib::ustring &amp;parent_table) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_used</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>ad2a0d15ff3f128efbea3a7dcd4822cd9</anchor>
      <arglist>(const Glib::ustring &amp;parent_table_title) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_singular_used</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a72680483b5f7805860a4b7d96e43f1fb</anchor>
      <arglist>(const Glib::ustring &amp;parent_table_title) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_to_field_used</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>ad617dbc1dac6a36622e1df4d19460820</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_relationship_name_used</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>aba1275ef9104195d0295ededca4baa87</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_relationship_used_allows_edit</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a5f62a279a3b92f332a281908e7373cc1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sql_join_alias_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a848a62d4a236699d2b72eeb07336e118</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sql_table_or_join_alias_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a4e11c0d9f8ce41071d029a577c2d1bb4</anchor>
      <arglist>(const Glib::ustring &amp;parent_table) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_relationship_display_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a5f39f0e0ba5ca199ed38cb30aa17a519</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_FieldSummary</name>
    <filename>classGlom_1_1LayoutItem__FieldSummary.html</filename>
    <base>Glom::LayoutItem_Field</base>
    <member kind="enumeration">
      <name>summaryType</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac7a444ba46f7e39d99f404f0732470a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_INVALID</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac7a444ba46f7e39d99f404f0732470a8a93cc3a5462b74dcefc32c7cbd7f86e95</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_SUM</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac7a444ba46f7e39d99f404f0732470a8aaf4eed59bf396496c2aa7a19bd30ac64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_AVERAGE</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac7a444ba46f7e39d99f404f0732470a8a00e4f4aaa38f0cd0e129b66294f63fde</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_COUNT</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac7a444ba46f7e39d99f404f0732470a8a31f89bf6388e3abff94f08dfdc5e68b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_FieldSummary</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a1a383a4360f51784799b0231494a9c65</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_FieldSummary</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>aa3bf4352da0411e0e5800a1295d69213</anchor>
      <arglist>(const LayoutItem_FieldSummary &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_FieldSummary &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a16cf05d7a4fc348180853e32d95bff86</anchor>
      <arglist>(const LayoutItem_FieldSummary &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_FieldSummary</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a6fa170a3d750d6f9ee7adc7810fc4496</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a19923194d1c2539943d09e0e26e5019a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a543e2195dd01dfd706ee9974c51cee13</anchor>
      <arglist>(const LayoutItem_FieldSummary &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>af9cd593a191dc9346350adb59228caaa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>af6bf3d9534a0851dbdcd73f856301599</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>summaryType</type>
      <name>get_summary_type</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a485f114337139cdc3a56582354358e66</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_summary_type</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac8f5d02ec14cd7ef0632a7553a70982a</anchor>
      <arglist>(summaryType summary_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_summary_type_sql</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a0939ff5eb6ae75dbb9699fd611a3227b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_summary_type_from_sql</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a40e8f2829757218074199758c33d298a</anchor>
      <arglist>(const Glib::ustring &amp;summary_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_field</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ad5efd580794a4a82845dda895f0c641c</anchor>
      <arglist>(const sharedptr&lt; LayoutItem_Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_title</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a9972e887b8c068aecdd69eb7d61b7fa6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_title_or_name</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a2b52dcf63c82a3dccf2fad411977b048</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_layout_display_name</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a83dca29064de2165f09f8e92bc36d6e0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_layout_display_name_field</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>af8e643306d8317bc1515cde40e50a0fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_summary_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a73400ed5d8aca7f8c5cb427a542871a9</anchor>
      <arglist>(summaryType summary_type)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Footer</name>
    <filename>classGlom_1_1LayoutItem__Footer.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Footer</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>af42d7a6df5f3f6bce10160cf4d480a3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Footer</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>ab29ec6bf51dba1da570443eed0022247</anchor>
      <arglist>(const LayoutItem_Footer &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Footer &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>ac352b9abb7d43aff4a3aec839170ef19</anchor>
      <arglist>(const LayoutItem_Footer &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Footer</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>a1e719d590a8d26f7edbab966b9c6275e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>a1e1bca341bf633e8d5b9d6c08bdcd94e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>aed9b8281b68262a077693ae625eb4ee3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>a6af2e86389acd26332d71355e1b243b4</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_GroupBy</name>
    <filename>classGlom_1_1LayoutItem__GroupBy.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="typedef">
      <type>std::pair&lt; sharedptr&lt; const LayoutItem_Field &gt;, bool &gt;</type>
      <name>type_pair_sort_field</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a86f86a567ec6f540decf10565e952046</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; type_pair_sort_field &gt;</type>
      <name>type_list_sort_fields</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a67c7de91a9dd24988a4e34779274b3d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_GroupBy</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>aef2d5076b2bcd6ea87fc6f6fb778bd77</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_GroupBy</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a177a17665f678a1b8c07069ab0a343a6</anchor>
      <arglist>(const LayoutItem_GroupBy &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_GroupBy &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>ab8952eca3d750a55cfb358db2e8a053f</anchor>
      <arglist>(const LayoutItem_GroupBy &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_GroupBy</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>abfeb7c298375ebec4d589a9780c1c604</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a2973ccf0450912be8e8892ee149430d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; LayoutItem_Field &gt;</type>
      <name>get_field_group_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>af5b9976941cc8328939f5e39ffcfd52d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const LayoutItem_Field &gt;</type>
      <name>get_field_group_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a52c726e6f3d5a0b60ca0ef755debd036</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_field_group_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>ad72cab568a4f32840cfba438ac97da1e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_field_group_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>ac27d718e2d915c0e3c196f5c44d1b8ad</anchor>
      <arglist>(const sharedptr&lt; LayoutItem_Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function">
      <type>type_list_sort_fields</type>
      <name>get_fields_sort_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>add29516e3c95f5509178aae73601a245</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>type_list_sort_fields</type>
      <name>get_fields_sort_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>adc8fb840e69c11058a29b76b530b34e7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_fields_sort_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a5d6486b3ea63b5a833d0fcea310a084e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fields_sort_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>af6233ebe91f08a75108a5252e8653657</anchor>
      <arglist>(const type_list_sort_fields &amp;field)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_layout_display_name</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>aab72f62b0b4133d80719cc0d562b5e31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a708270a94b3f40aa817ff6a74be28fc9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a75ad3b1c59d57e5b8cd6e1ebd430910b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; LayoutGroup &gt;</type>
      <name>m_group_secondary_fields</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>ac46b432524b317165679c5e3fdf1cf33</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>type_list_sort_fields</type>
      <name>m_fields_sort_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a04906696db25ea8d6ec2c47538e2278f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Header</name>
    <filename>classGlom_1_1LayoutItem__Header.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Header</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>a298fce41d5a9e990b8180a34fa89c7a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Header</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>a882f33e654234866417d2aa94fd9bc78</anchor>
      <arglist>(const LayoutItem_Header &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Header &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>af6ce4cd7277a6838928966ee3463cf41</anchor>
      <arglist>(const LayoutItem_Header &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Header</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>a78160bc0cb8fb66259497930e729549e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>a95fe5d54548a1558af18caf2c43cdeeb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>a2464f44e07ebf75415cc9b714b3cca9f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>af17682c3a50c894eb944ebb9073e8659</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Summary</name>
    <filename>classGlom_1_1LayoutItem__Summary.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Summary</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>a18f140ac144c7b8e4be2e9b792a9e006</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Summary</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>aac13147739481f2874215e83244a7b5d</anchor>
      <arglist>(const LayoutItem_Summary &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Summary &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>ac9eca899e182114045a74a7727c7cf7a</anchor>
      <arglist>(const LayoutItem_Summary &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Summary</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>a7fd0db396f1cfabcd8263dcd878c9a9c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>a9b136c6c351f0d2fb8582e25d0845396</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>a73cbf61053eab424681c6c7071dd2574</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>a9f00bcf851f7df72c990b5086e9eeca1</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_VerticalGroup</name>
    <filename>classGlom_1_1LayoutItem__VerticalGroup.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_VerticalGroup</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a0565284ac341dd56b2969fdc1125bb36</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_VerticalGroup</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a75020c234aeda70afa11e81005c6c932</anchor>
      <arglist>(const LayoutItem_VerticalGroup &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_VerticalGroup &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a752efa41e5688d659419001cca39d2d0</anchor>
      <arglist>(const LayoutItem_VerticalGroup &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_VerticalGroup</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a5ec7b24846d5ab61d99070bd1f9ca219</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a47e75f27cbe504ec935641d9fced5f49</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a014d47784b111300bd9bad18aa1849d4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a96f65b960fe7413ac36127c7faf60435</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::Document</name>
    <filename>classGlom_1_1Document.html</filename>
    <base>GlomBakery::Document_XML</base>
    <member kind="enumeration">
      <name>HostingMode</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a54256dad3f42641da3434bf687d5da49</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOSTING_MODE_POSTGRES_CENTRAL</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a54256dad3f42641da3434bf687d5da49ab86dcd950027408ed28e171902e769aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOSTING_MODE_POSTGRES_SELF</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a54256dad3f42641da3434bf687d5da49af6a98f13e469bdd6bfcd933b25fea68b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOSTING_MODE_SQLITE</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a54256dad3f42641da3434bf687d5da49abf9c730e96318c88df8766514cfdfa9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOSTING_MODE_DEFAULT</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a54256dad3f42641da3434bf687d5da49a901e9051108e8e556ba4f260d5adb2f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>userLevelReason</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abc26e179ab1bb3fc08dbfbe06fbaf410</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USER_LEVEL_REASON_UNKNOWN</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abc26e179ab1bb3fc08dbfbe06fbaf410a8d7d9bacad5ba54589f1b5a412bb3dd4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USER_LEVEL_REASON_FILE_READ_ONLY</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abc26e179ab1bb3fc08dbfbe06fbaf410a8c5889c747c97b125f96d0d720598315</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USER_LEVEL_REASON_DATABASE_ACCESS_LEVEL</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abc26e179ab1bb3fc08dbfbe06fbaf410a4e77ef46784db3ff58ff34686c45cc7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USER_LEVEL_REASON_OPENED_FROM_BROWSE</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abc26e179ab1bb3fc08dbfbe06fbaf410a014d8667d572ce4617e504183bdf7462</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>load_failure_codes</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a66a6e7180bd2e8ed4b0cd3c98e04bb77</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LOAD_FAILURE_CODE_FILE_VERSION_TOO_NEW</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a66a6e7180bd2e8ed4b0cd3c98e04bb77aaa943ae3fc9f302196739a7da25e2f4a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; Relationship &gt; &gt;</type>
      <name>type_vec_relationships</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a5f5a0cd04d7505fc767d8c3fa3619721</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; Field &gt; &gt;</type>
      <name>type_vec_fields</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9cae49d450ede55a856575682eab53dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; LayoutGroup &gt; &gt;</type>
      <name>type_list_layout_groups</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9d8a77d03f244bc189e08e133eb475fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; sharedptr&lt; TranslatableItem &gt; &gt;</type>
      <name>type_list_translatables</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a84c669bb6dc95ce7ffa16b61b4056f1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; sharedptr&lt; TableInfo &gt; &gt;</type>
      <name>type_listTableInfo</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae42cb0d25dbdcd3a09cf704f238f9f9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; Gnome::Gda::Value &gt;</type>
      <name>type_row_data</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aca8431de4908b829ce8024e798b4ff8c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; type_row_data &gt;</type>
      <name>type_example_rows</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab5905a45fa16a88d745959b620a038bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; GroupInfo &gt;</type>
      <name>type_list_groups</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abfa5f5dfb05a1f4396022a30d202d051</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; Glib::ustring &gt;</type>
      <name>type_listReports</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>acf8dcf5aa53edb41903a089e8887a754</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; Glib::ustring &gt;</type>
      <name>type_listPrintLayouts</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab7532d847364e062dfb1ca8bfa512552</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::signal&lt; void, AppState::userlevels &gt;</type>
      <name>type_signal_userlevel_changed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7a0abb07acbcae993250c2108c650184</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void &gt;</type>
      <name>SlotProgress</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7fd0175b92c01373c623a3e50b75a9e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Document</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a90ff6b08dcaf5ddcae4f3499c2578bf3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Document</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ad1137e6d112a281cfa43a20bcff4e9bd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_modified</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a6603e178b34d70fc90575b152f0bc1a8</anchor>
      <arglist>(bool value=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_file_uri</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a5ceef4693df960dd98481061f3742e59</anchor>
      <arglist>(const Glib::ustring &amp;file_uri, bool bEnforceFileExtension=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a1ede7d94348089309c46b7b01229e79e</anchor>
      <arglist>(int &amp;failure_code)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_opened_from_browse</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0e008dfbf0d238b5a77c0f45298edf29</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_opened_from_browse</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a18bb5479ce943ef28278558960920766</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_allow_autosave</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae203d2b063dac5287da64fa63ae50c5e</anchor>
      <arglist>(bool value=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_example_file</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a2ecc05580205e89f46aa90c5230ac6a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_example_file</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a8d4d81de8c825f1f68d1821c05d1023e</anchor>
      <arglist>(bool value=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_backup_file</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a975584b92b39970310ba24f18581f95e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_backup_file</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>accadb18c3bb59d1176df9083b3a2212d</anchor>
      <arglist>(bool value=true)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_document_format_version</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ac3976a7656969455e9c4e1c3c7567972</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_hosting_mode</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ace5a3278c813d2110776852899c22944</anchor>
      <arglist>(HostingMode mode)</arglist>
    </member>
    <member kind="function">
      <type>HostingMode</type>
      <name>get_hosting_mode</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aee42dce3aeb3af15c7e4f5f8ce32fb3c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_network_shared</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3e15ba717ea6589c46c5082564e700e7</anchor>
      <arglist>(bool shared=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_network_shared</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a07e3a92de7638d028f8b66f69f588466</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_connection_server</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a044d90398f59d87e55a6bb7b79bbdc1e</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_connection_database</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0c9cd11c69ff2d32661a9c6d9473b660</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_connection_port</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a05e4aec6becad68439b753d020b8c43d</anchor>
      <arglist>(unsigned int port_number)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_connection_try_other_ports</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a288a93328e6058bb769e74f56ed18791</anchor>
      <arglist>(bool val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_connection_user</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ad2d85b9e4840a99197ec327a3f39584b</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_connection_self_hosted_directory_uri</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a6bac0c857baecc5c84731af9d6fa6251</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_connection_server</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a1883d24f1120b747ad064b8d7a73d21f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_connection_database</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a85c082c4808d6fe39c42e4a14f2299a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>get_connection_port</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7bfc56a68650f5a899573c57a38aa425</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_connection_try_other_ports</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7a11f7a921bf490a9de6506919fd213d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_connection_user</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a036e47f17250ef6b8af83164cce5c1b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_translation_original_locale</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abd8e2bc47132dbdf9c5fa98024729b07</anchor>
      <arglist>(const Glib::ustring &amp;locale)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_translation_original_locale</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a8d805cbac982814fec599d010c5236dc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>type_vec_relationships</type>
      <name>get_relationships</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ad57c89ae1226099b004879ba999c26f3</anchor>
      <arglist>(const Glib::ustring &amp;table_name, bool plus_system_prefs=false) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_relationships</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3d8df9373a64f30bc6c9127a69f0a07b</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vec_relationships &amp;vecRelationships)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Relationship &gt;</type>
      <name>get_relationship</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a18d63c511eb610c6f52ad0091d76cd0a</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;relationship_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_relationship</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a16f7565b30384dadcd17d3525f628be6</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_relationship</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a15a2ab17697301f2726d080d7baad1f5</anchor>
      <arglist>(const sharedptr&lt; const Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_relationship_is_to_one</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3c98c23ac46b78af711d49111fa5b44d</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;relationship_name) const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const Relationship &gt;</type>
      <name>get_field_used_in_relationship_to_one</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a59be2eee4286b47d7a0142aa8672974a</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; const LayoutItem_Field &gt; &amp;layout_field) const </arglist>
    </member>
    <member kind="function">
      <type>type_vec_fields</type>
      <name>get_table_fields</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0cfc1350c6fc648215c156dd4793ad15</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_table_fields</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a657108407aaed9a6cca6232a1587f116</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vec_fields &amp;vecFields)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Field &gt;</type>
      <name>get_field</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a202075e290a0ad7d94fbbb38a52f1c1c</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;strFieldName) const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Field &gt;</type>
      <name>get_field_primary_key</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab3cfa3d036ca0e8116186d5d2a70a8b7</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_field</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a07027365c86499ca1a5d820aabfe0457</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function">
      <type>type_list_layout_groups</type>
      <name>get_data_layout_groups</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abda9d5440a4f8ffc4836633af2711b32</anchor>
      <arglist>(const Glib::ustring &amp;layout_name, const Glib::ustring &amp;parent_table_name, const Glib::ustring &amp;layout_platform=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_data_layout_groups_have_any_fields</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7e381754fc804dd08b3096ee7522214b</anchor>
      <arglist>(const Glib::ustring &amp;layout_name, const Glib::ustring &amp;parent_table_name, const Glib::ustring &amp;layout_platform=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_data_layout_groups</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab33878ff9cf67dfcfea57a095a0eced4</anchor>
      <arglist>(const Glib::ustring &amp;layout_name, const Glib::ustring &amp;parent_table_name, const Glib::ustring &amp;layout_platform, const type_list_layout_groups &amp;groups)</arglist>
    </member>
    <member kind="function">
      <type>type_list_layout_groups</type>
      <name>get_data_layout_groups_plus_new_fields</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ade3010c94dce5edf4d03f4c5d3fb32b9</anchor>
      <arglist>(const Glib::ustring &amp;layout_name, const Glib::ustring &amp;parent_table_name, const Glib::ustring &amp;layout_platform=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>type_list_layout_groups</type>
      <name>get_data_layout_groups_default</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9caf5b84d58e39a21e1c1d92a460a903</anchor>
      <arglist>(const Glib::ustring &amp;layout_name, const Glib::ustring &amp;parent_table_name, const Glib::ustring &amp;layout_platform=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>type_list_translatables</type>
      <name>get_translatable_layout_items</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0139486b693d4fc466af340f0de496c7</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>type_list_translatables</type>
      <name>get_translatable_report_items</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3d818d8546a6f1ef1df81e674abd600b</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;report_title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_layout_field_details</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a78d0b24d0b76a960c3229a0df2014d14</anchor>
      <arglist>(const Glib::ustring &amp;parent_table_name, const sharedptr&lt; LayoutGroup &gt; &amp;layout_group) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_layout_field_details</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ad600378dbbd8dd695a860b1442f1c4ac</anchor>
      <arglist>(const Glib::ustring &amp;parent_table_name, type_list_layout_groups &amp;groups) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_field_name</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>af5a1f5b0c3da19b7efcda3c930ca47b2</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;strFieldNameOld, const Glib::ustring &amp;strFieldNameNew)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_table_name</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a4cf00bbe1e0e933babbb7232fe18f3e2</anchor>
      <arglist>(const Glib::ustring &amp;table_name_old, const Glib::ustring &amp;table_name_new)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_relationship_name</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a70f3bcd7d6a6b6db063f0b3d99a59f9c</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;name, const Glib::ustring &amp;name_new)</arglist>
    </member>
    <member kind="function">
      <type>type_listTableInfo</type>
      <name>get_tables</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a4089c972eef475174f1900b95bfebbe6</anchor>
      <arglist>(bool plus_system_prefs=false) const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>get_table_names</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a1616c5f5d3f883b7f5efd78e1c7515c5</anchor>
      <arglist>(bool plus_system_prefs=false) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_tables</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a1793737ae7580ca7eda799182dce95bc</anchor>
      <arglist>(const type_listTableInfo &amp;tables)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; TableInfo &gt;</type>
      <name>get_table</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9ddf9ceedb1fb8702ee6fd6099e3b2d0</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_table</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aa10ca51126b3584e6b08c252d1b0de94</anchor>
      <arglist>(const sharedptr&lt; TableInfo &gt; &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_table</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>af8a8df4382e37d65864efb6d211f50e2</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_table_is_known</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aef76714a9cbca223eaa407c2eaa0327f</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_table_is_hidden</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a2879c2d8d949bab631e07ff421bc481b</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_table_title</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9a66b0361d754351f2d6d39515414b01</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_table_title</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae716dda0e1fec4f96bc1f1e71a1635af</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_table_title_singular</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a5e16ef68c717ae8ac71e0ca0e1df391b</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_table_example_data</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>afedc945ec10ff9dbab28eddee55fa8d0</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_example_rows &amp;rows)</arglist>
    </member>
    <member kind="function">
      <type>type_example_rows</type>
      <name>get_table_example_data</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a08778c86bf51fc7f31e778b0417bc572</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abc53c753fc86bf0278610b0f20d31f9e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_default_table</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3578eab4e777bdbc552e6d72c4cbcd12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_first_table</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a194af911d3ce865c40b9a0e3cc4a6fba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_database_title</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ac7395b0f421de0a6e4b7ce2d7a071861</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_database_title</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a84b1c7bf8678ab058fb8e741c8496b7d</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>get_library_module_names</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a624cb5b533b2947a1ca33af0c9dee3cf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_library_module</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab92ce8dd4687ae3b45257ad007a60511</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::ustring &amp;script)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_library_module</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>af40255606bf9091cbac43fa54c2dd703</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_library_module</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0fdc644b88c714eaf8fb13d3d05f97fe</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_startup_script</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae917d14c0bb3760a3b249e2f82688d24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_startup_script</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7babdeae6c108d1a8fe5ce98b62b1541</anchor>
      <arglist>(const Glib::ustring &amp;script)</arglist>
    </member>
    <member kind="function">
      <type>type_list_groups</type>
      <name>get_groups</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a5df0256b130fd6d93b76d0a1863dc92a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_group</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3e77240d9e4eb38502951e604d5c4e5c</anchor>
      <arglist>(GroupInfo &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_group</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae49bf6ebfe9961f3b1d4f7cf09ca6dc2</anchor>
      <arglist>(const Glib::ustring &amp;group_name)</arglist>
    </member>
    <member kind="function">
      <type>type_listReports</type>
      <name>get_report_names</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae43c2c308e810fe2216d9e6df07ea0d8</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_report</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a47faae146fbbc9dea0752f412f2a3595</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; Report &gt; &amp;report)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Report &gt;</type>
      <name>get_report</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aec14f82fc1c02f5ee0d28e3b4b28ec87</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;report_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_report</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a8b231a7d8dbfe07ad8c5074fa2dde323</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;report_name)</arglist>
    </member>
    <member kind="function">
      <type>type_listPrintLayouts</type>
      <name>get_print_layout_names</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aef7c56f4285e57ea49265a25375f6054</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a2afd8bdf6a5634933c2c819c3e9373a1</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; PrintLayout &gt; &amp;print_layout)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; PrintLayout &gt;</type>
      <name>get_print_layout</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>acfed669f397069f1b76138f4fc7accbe</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;print_layout_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_print_layout</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a375934cf55b339d500daa64ca8435f05</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;print_layout_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_layout_record_viewed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a11900053dde2eb3cd26e54e5c0f5e53f</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;layout_name, const Gnome::Gda::Value &amp;primary_key_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>forget_layout_record_viewed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7f4be165d31a3a2a79ac48b949164d74</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>get_layout_record_viewed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9e5f6ebd2ea216bef094c024540ab179</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;layout_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_layout_current</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a6d2ce3a3100db68f9b901198d308cf90</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;layout_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_criteria_current</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ac8fe4bdc200ddc160df1ce8c98b91af5</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const FoundSet &amp;found_set)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_layout_current</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a4c0a2e8c578cd930b67d8995783df6dc</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>FoundSet</type>
      <name>get_criteria_current</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>acd5d4b86efeb529937d481a04153a1c6</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_table_overview_position</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3a092c6f1683877c1ac7b488b44d156a</anchor>
      <arglist>(const Glib::ustring &amp;table_name, float &amp;x, float &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_table_overview_position</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a18f56166c46a675e0b3485f1983a6280</anchor>
      <arglist>(const Glib::ustring &amp;utable_name, float x, float y)</arglist>
    </member>
    <member kind="function">
      <type>AppState::userlevels</type>
      <name>get_userlevel</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ad3647830784ebc50678b3fef30c6fedf</anchor>
      <arglist>(userLevelReason &amp;reason) const </arglist>
    </member>
    <member kind="function">
      <type>AppState::userlevels</type>
      <name>get_userlevel</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3beaf21050dd7b8a5be28e5cac4f2690</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_userlevel</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aa6ec845cf0ea70ed218b248aeb554a4c</anchor>
      <arglist>(AppState::userlevels userlevel)</arglist>
    </member>
    <member kind="function">
      <type>type_signal_userlevel_changed</type>
      <name>signal_userlevel_changed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3c2bf693aaceaa8cfb91eb81b1b06846</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emit_userlevel_changed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9bd93833eb1d8e098c6a6111a5bd2ce0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_active_layout_platform</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab72b14ad85f8a6764fead1cd8af2bd82</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_active_layout_platform</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0a0a5ce1b3e1456628a6db90b387a5db</anchor>
      <arglist>(const Glib::ustring &amp;layout_platform=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>build_and_get_contents</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aad09e0b498f1071f526ba441183f8a0f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>save_backup_file</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a077761b2542b90634df6c8ab059245da</anchor>
      <arglist>(const Glib::ustring &amp;uri, const SlotProgress &amp;slot_progress)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static guint</type>
      <name>get_latest_known_document_format_version</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a68275fcf2ed364f98040aabdf4b48a79</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>restore_backup_file</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a6f0fbca2b24feb7481affca8dfda8988</anchor>
      <arglist>(const Glib::ustring &amp;backup_uri, const SlotProgress &amp;slot_progress)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; TableInfo &gt;</type>
      <name>create_table_system_preferences</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7ad8db097fa9d525a0d01f1200a9d6b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; TableInfo &gt;</type>
      <name>create_table_system_preferences</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab39ed3e2fa2249f1f486ee544f66ae38</anchor>
      <arglist>(type_vec_fields &amp;fields)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; Relationship &gt;</type>
      <name>create_relationship_system_preferences</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a161b891548f4b59d81405c88fea5fe49</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>get_relationship_is_system_properties</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a90bef6dd6f39ac421fe8626f488cb0a8</anchor>
      <arglist>(const sharedptr&lt; const Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>set_node_attribute_value_as_decimal</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0860ad2cd972c4c4a37ae37195ff73ca</anchor>
      <arglist>(xmlpp::Element *node, const Glib::ustring &amp;strAttributeName, guint value, guint value_default=0)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>set_node_attribute_value_as_decimal_double</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aee282bf7817172e3825cb6c97500be77</anchor>
      <arglist>(xmlpp::Element *node, const Glib::ustring &amp;strAttributeName, double value)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Glom::Conversions</name>
    <filename>namespaceGlom_1_1Conversions.html</filename>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_for_gda_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a48b6fb46196063a4f2c04a051f9a0107</anchor>
      <arglist>(Field::glom_field_type glom_type, const Gnome::Gda::Value &amp;value, const NumericFormat &amp;numeric_format=NumericFormat())</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_for_gda_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a01aae2cbc1607de2bb918880494a9f0b</anchor>
      <arglist>(Field::glom_field_type glom_type, const Gnome::Gda::Value &amp;value, const std::locale &amp;locale, const NumericFormat &amp;numeric_format=NumericFormat(), bool iso_format=false)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_double_for_gda_value_numeric</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a033e0bf3a766f7d69b2f818205669e67</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>format_time</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a051b5314fe433eabf051f3c43a8f7dfc</anchor>
      <arglist>(const tm &amp;tm_data)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>format_time</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a6714edf75c290bd4de66af771a4b3a56</anchor>
      <arglist>(const tm &amp;tm_data, const std::locale &amp;locale, bool iso_format=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>format_date</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a764f1ac62953357796ada21349d8a563</anchor>
      <arglist>(const tm &amp;tm_data)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>format_date</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>ad865bddc0f3454b011f979abd66ee7df</anchor>
      <arglist>(const tm &amp;tm_data, const std::locale &amp;locale, bool iso_format=false)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>parse_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>aeb7a666d6bb259222cf845be878433b3</anchor>
      <arglist>(double number)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>parse_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a242567311d55e2e445389b485354ab1c</anchor>
      <arglist>(Field::glom_field_type glom_type, const Glib::ustring &amp;text, bool &amp;success, bool iso_format=false)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>parse_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a07d9613945623145e881e2037ba4c31b</anchor>
      <arglist>(Field::glom_field_type glom_type, const Glib::ustring &amp;text, const NumericFormat &amp;numeric_format, bool &amp;success, bool iso_format=false)</arglist>
    </member>
    <member kind="function">
      <type>tm</type>
      <name>parse_date</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a2e6cff95cf134f278a10d82fc0088f42</anchor>
      <arglist>(const Glib::ustring &amp;text, bool &amp;success)</arglist>
    </member>
    <member kind="function">
      <type>tm</type>
      <name>parse_date</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a0c39a1f6bd76df296d7dd8a1782c3c00</anchor>
      <arglist>(const Glib::ustring &amp;text, const std::locale &amp;locale, bool &amp;success)</arglist>
    </member>
    <member kind="function">
      <type>tm</type>
      <name>parse_time</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>ab1d9cd8f22d5f3a033f6ecad14676f70</anchor>
      <arglist>(const Glib::ustring &amp;text, bool &amp;success)</arglist>
    </member>
    <member kind="function">
      <type>tm</type>
      <name>parse_time</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a00d777f4efd24b5c43a8fe8d917f965b</anchor>
      <arglist>(const Glib::ustring &amp;text, const std::locale &amp;locale, bool &amp;success)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>sanity_check_date_parsing</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a46a1c1a6c1e5fe998d64835e7788a4b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>sanity_check_date_text_representation_uses_4_digit_years</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a66dd29fe0a9bd12ea1b12b203c95ab4d</anchor>
      <arglist>(bool debug_output=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>format_tm</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>afa89e12c3c63d94cb14fd2bc5a59c2b0</anchor>
      <arglist>(const tm &amp;tm_data, const std::locale &amp;locale, const char *format)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>value_is_empty</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a2b8ded4c899f974d4bb995d5aef600b7</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>get_empty_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>ae75ba006d16abd95bb4fb82920bc5a54</anchor>
      <arglist>(Field::glom_field_type field_type)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>get_example_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>ababe2a34181fa01f8575f34a67184016</anchor>
      <arglist>(Field::glom_field_type field_type)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>convert_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>afdb2d3c3d6db46bdd372b69f3009c6e1</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value, Field::glom_field_type target_glom_type)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Glom::DbUtils</name>
    <filename>namespaceGlom_1_1DbUtils.html</filename>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; Field &gt; &gt;</type>
      <name>type_vec_fields</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>abb42c8203423a937b841974ac822410c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>type_vec_strings</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>ae9bc6d6b4fb5d622d9aaca35a3d5669c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>create_database</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a74ca3ca573827b629d8505a9a64f56e3</anchor>
      <arglist>(Document *document, const Glib::ustring &amp;database_name, const Glib::ustring &amp;title, const sigc::slot&lt; void &gt; &amp;progress)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>recreate_database_from_document</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>ad4ceee76d0b1ed6efcf33840a5ff44e6</anchor>
      <arglist>(Document *document, const sigc::slot&lt; void &gt; &amp;progress)</arglist>
    </member>
    <member kind="function">
      <type>SystemPrefs</type>
      <name>get_database_preferences</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a91478a871fc311c36bac24e48a3c1bea</anchor>
      <arglist>(Document *document)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_database_preferences</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>aecf3de9ed6b204dacd7116f2894013e7</anchor>
      <arglist>(Document *document, const SystemPrefs &amp;prefs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_standard_tables</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a83d04c8f108de2758c3f92d2da39c47b</anchor>
      <arglist>(Document *document)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_standard_groups</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>adbc2d8d8eb196a30e4ac0dd836497351</anchor>
      <arglist>(Document *document)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_groups_from_document</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>ae6f25b14f488d2a569f7e24ae10a0e0b</anchor>
      <arglist>(Document *document)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_table_privileges_groups_from_document</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a42c07c63ee9f84a6f09a4b5dff5d513d</anchor>
      <arglist>(Document *document)</arglist>
    </member>
    <member kind="function">
      <type>type_vec_fields</type>
      <name>get_fields_for_table_from_database</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>af4de0e165e8f68f08c2c856305e51e48</anchor>
      <arglist>(const Glib::ustring &amp;table_name, bool including_system_fields=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_field_exists_in_database</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a4304740177c37fe5064fe935d75bc100</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function">
      <type>type_vec_strings</type>
      <name>get_table_names_from_database</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a6bac069d6654e675bc739648dbdc8bbf</anchor>
      <arglist>(bool ignore_system_tables=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_table_exists_in_database</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a7b1489bc8fdb5c434ad4ee6cba96d8c9</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>create_table</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a62551bf0590fd1de03447367afde2f0a</anchor>
      <arglist>(const sharedptr&lt; const TableInfo &gt; &amp;table_info, const Document::type_vec_fields &amp;fields)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>create_table_with_default_fields</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a85188d99df945b3aea151693148ad658</anchor>
      <arglist>(Document *document, const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>create_table_add_missing_fields</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a13bb08a30e11285983135abd6d06e7b4</anchor>
      <arglist>(const sharedptr&lt; const TableInfo &gt; &amp;table_info, const Document::type_vec_fields &amp;fields)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_column</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a7cd3f238eb92dfe05a4a1e90951e9bcc</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; const Field &gt; &amp;field, Gtk::Window *parent_window)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>drop_column</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a91dce7a060ca1c249d77e26f34e5ec94</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>insert_example_data</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a7dbd8b794276e7bade759eb1e3e6faf3</anchor>
      <arglist>(Document *document, const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gnome::Gda::DataModel &gt;</type>
      <name>query_execute_select</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>aa7e3c7e44ee803b29de888b4839dd90d</anchor>
      <arglist>(const Glib::RefPtr&lt; const Gnome::Gda::SqlBuilder &gt; &amp;builder, bool use_cursor=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_execute_string</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>ab5f26298a395abc3b9b2b503ebd49178</anchor>
      <arglist>(const Glib::ustring &amp;strQuery, const Glib::RefPtr&lt; Gnome::Gda::Set &gt; &amp;params=Glib::RefPtr&lt; Gnome::Gda::Set &gt;(0))</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_execute</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a7df091154f81400dfaf04c8b2005d3eb</anchor>
      <arglist>(const Glib::RefPtr&lt; const Gnome::Gda::SqlBuilder &gt; &amp;builder)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>auto_increment_insert_first_if_necessary</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>abd90a12ee756f6eee5bc7b5911aef431</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>get_next_auto_increment_value</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>ac8dec35caeb1bfd4300a881ef466962b</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_auto_increment</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a1387981b8ab07885b9d805a1a2f8250d</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>layout_item_fill_field_details</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a761c02e5c6e710bf1898f3f0c8aba8b2</anchor>
      <arglist>(Document *document, const Glib::ustring &amp;parent_table_name, sharedptr&lt; LayoutItem_Field &gt; &amp;layout_item)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>layout_field_should_have_navigation</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a785cc54d9b161914c3dd4a60f512f357</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; const LayoutItem_Field &gt; &amp;layout_item, const Document *document, sharedptr&lt; Relationship &gt; &amp;field_used_in_relationship_to_one)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_unused_database_name</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>abea6d0f83f17ddf2882319e096cce3c1</anchor>
      <arglist>(const Glib::ustring &amp;base_name)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>count_rows_returned_by</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a08e633cef13054b3a83148abf2f23797</anchor>
      <arglist>(const Glib::RefPtr&lt; const Gnome::Gda::SqlBuilder &gt; &amp;sql_query)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>rename_table</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a07716c1ec4274884c4687826913bb32a</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;new_table_name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>drop_table</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>ab96735eb94f8d49062d139c1aa9b00f3</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>escape_sql_id</name>
      <anchorfile>namespaceGlom_1_1DbUtils.html</anchorfile>
      <anchor>a237fa2e0bd26217598eacd2e2f8a183a</anchor>
      <arglist>(const Glib::ustring &amp;id)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Glom::Utils</name>
    <filename>namespaceGlom_1_1Utils.html</filename>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; LayoutItem_Field &gt; &gt;</type>
      <name>type_vecLayoutFields</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a8f8fbf1c248f46a7142f510b9e76dbae</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; const LayoutItem_Field &gt; &gt;</type>
      <name>type_vecConstLayoutFields</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a62d84be27491c2ba60f84bb54ed7795e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; Gnome::Gda::Value &gt;</type>
      <name>type_list_values</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ac9160b405608a8328e0c15ea2f1d66e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; std::pair&lt; Gnome::Gda::Value, type_list_values &gt; &gt;</type>
      <name>type_list_values_with_second</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>aa6b7e4d5fe2b836e65b9a9a9ba09523f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>type_vec_strings</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a52b82841a1690a3a6fe86838470ec1ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>trim_whitespace</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>acc1ef56d72b6a4a34ad1411490c0bba4</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>string_replace</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a042b6b2d25000ba1d2a6ea3342d7f652</anchor>
      <arglist>(const Glib::ustring &amp;src, const Glib::ustring &amp;search_for, const Glib::ustring &amp;replace_with)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>string_clean_for_xml</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a199966b2ee8cad4b651d53225cfa063b</anchor>
      <arglist>(const Glib::ustring &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::SqlExpr</type>
      <name>build_simple_where_expression</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a5aa4fb1c8b23f01e444056e29368126e</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; const Field &gt; &amp;key_field, const Gnome::Gda::Value &amp;key_value)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::SqlExpr</type>
      <name>build_combined_where_expression</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ace11f9a501566ea3f92748218f214040</anchor>
      <arglist>(const Gnome::Gda::SqlExpr &amp;a, const Gnome::Gda::SqlExpr &amp;b, Gnome::Gda::SqlOperatorType op)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>build_sql_select_add_fields_to_get</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a6577405c94a0065afe93ec224dd97746</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::SqlBuilder &gt; &amp;builder, const Glib::ustring &amp;table_name, const type_vecConstLayoutFields &amp;fieldsToGet, const type_sort_clause &amp;sort_clause, bool extra_join)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gnome::Gda::SqlBuilder &gt;</type>
      <name>build_sql_select_with_where_clause</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a21e7a7ae41fc536f7226eb73001faef0</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vecLayoutFields &amp;fieldsToGet, const Gnome::Gda::SqlExpr &amp;where_clause=Gnome::Gda::SqlExpr(), const sharedptr&lt; const Relationship &gt; &amp;extra_join=sharedptr&lt; const Relationship &gt;(), const type_sort_clause &amp;sort_clause=type_sort_clause(), guint limit=0)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gnome::Gda::SqlBuilder &gt;</type>
      <name>build_sql_select_with_key</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a9dc6f12301a65d262e2f091dd58239aa</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vecConstLayoutFields &amp;fieldsToGet, const sharedptr&lt; const Field &gt; &amp;key_field, const Gnome::Gda::Value &amp;key_value, const type_sort_clause &amp;sort_clause=type_sort_clause(), guint limit=0)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gnome::Gda::SqlBuilder &gt;</type>
      <name>build_sql_select_count_rows</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a03666744f8a4a1fd76cd18467d39cf03</anchor>
      <arglist>(const Glib::RefPtr&lt; const Gnome::Gda::SqlBuilder &gt; &amp;sql_query)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::SqlExpr</type>
      <name>get_find_where_clause_quick</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a2754ca449d65f9bf8d58f9433144f9b8</anchor>
      <arglist>(const Document *document, const Glib::ustring &amp;table_name, const Gnome::Gda::Value &amp;quick_search)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gnome::Gda::SqlBuilder &gt;</type>
      <name>build_sql_update_with_where_clause</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a107141db428e1202df9cf9a8ab4fd7c0</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; const Field &gt; &amp;field, const Gnome::Gda::Value &amp;value, const Gnome::Gda::SqlExpr &amp;where_clause)</arglist>
    </member>
    <member kind="function">
      <type>type_list_values_with_second</type>
      <name>get_choice_values_all</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a2ed07f25d7a4d24f4082b5fe667fa563</anchor>
      <arglist>(const Document *document, const sharedptr&lt; const LayoutItem_Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function">
      <type>type_list_values_with_second</type>
      <name>get_choice_values</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a62cad8c90e5532328cf0fbbac25e0159</anchor>
      <arglist>(const Document *document, const sharedptr&lt; const LayoutItem_Field &gt; &amp;field, const Gnome::Gda::Value &amp;foreign_key_value)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>sqlbuilder_get_full_query</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a8c88e4670ad36350d71a256621b8dd60</anchor>
      <arglist>(const Glib::RefPtr&lt; const Gnome::Gda::SqlBuilder &gt; &amp;builder)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>create_name_from_title</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ace6b7b73bbbfc9a213e1d7661d83af49</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>string_escape_underscores</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>adc81f0ad92fcc2ca0c120067d7dfa586</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>locale_simplify</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a1eea3c7eef1c01a97e960a3ec6a6a733</anchor>
      <arglist>(const Glib::ustring &amp;locale_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>locale_language_id</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>aa44a168cd7efec82207c21fe65672e71</anchor>
      <arglist>(const Glib::ustring &amp;locale_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>create_local_image_uri</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a61dcbaa20abb7153e2f873dccfdfff85</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>string_from_decimal</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ada8087969d3728b1cd1d9c2513d3fc28</anchor>
      <arglist>(guint decimal)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>title_from_string</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>aaa273e5833bc375648851bc23f9bed9f</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>type_vec_strings</type>
      <name>string_separate</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ab2c1a87110d1bae3e630815038d21f89</anchor>
      <arglist>(const Glib::ustring &amp;str, const Glib::ustring &amp;separator, bool ignore_quoted_separator=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>string_trim</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a837d3376b91338c742cdcb7eb3c4125c</anchor>
      <arglist>(const Glib::ustring &amp;str, const Glib::ustring &amp;to_remove)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>string_remove_suffix</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a255530113a42f6c853b09605d42b7efb</anchor>
      <arglist>(const Glib::ustring &amp;str, const Glib::ustring &amp;suffix, bool case_sensitive=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>file_exists</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a3eed787dc0ed308e80d95a8f4819d582</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>file_exists</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a1d73c0303388a5e5417a7dccefae3bc7</anchor>
      <arglist>(const Glib::RefPtr&lt; Gio::File &gt; &amp;file)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>delete_directory</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a49d9014b117c54fb6f63d1488201a3cf</anchor>
      <arglist>(const Glib::RefPtr&lt; Gio::File &gt; &amp;directory)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>delete_directory</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ab2154776db257cd90059224089a5f768</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_directory_child_with_suffix</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a14b3b3833c80138102f68a68ce1a2f9d</anchor>
      <arglist>(const Glib::ustring &amp;uri_directory, const std::string &amp;suffix, bool recursive)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_file_uri_without_extension</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a92abe1e4cc75719e6ea4f2d209238b52</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_file_path_without_extension</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a5b4990a3afa5f47fef68f01c0c02f7f4</anchor>
      <arglist>(const std::string &amp;filepath)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_list_of_layout_items_for_display</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>afd0af4acc4a7b14c275160ebedc394a7</anchor>
      <arglist>(const LayoutGroup::type_list_items &amp;list_layout_fields)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_list_of_layout_items_for_display</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a7f180d430c5def14c2b96817f76dd896</anchor>
      <arglist>(const sharedptr&lt; const LayoutGroup &gt; &amp;layout_group)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_temp_file_path</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a9e7ed258a7019df5d9c566ae785b0742</anchor>
      <arglist>(const std::string &amp;prefix=std::string(), const std::string &amp;extension=std::string())</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_temp_file_uri</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a65dfa09f34681b14818c05afb9c9a9a2</anchor>
      <arglist>(const std::string &amp;prefix=std::string(), const std::string &amp;extension=std::string())</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_temp_directory_path</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ac91a06f4c8e995e928e7dd51188988cc</anchor>
      <arglist>(const std::string &amp;prefix=std::string())</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_temp_directory_uri</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ac0954f6db1f6d9ebc03d9acad7dc625f</anchor>
      <arglist>(const std::string &amp;prefix=std::string())</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>GlomBakery</name>
    <filename>namespaceGlomBakery.html</filename>
    <class kind="class">GlomBakery::Document</class>
    <class kind="class">GlomBakery::Document_XML</class>
    <class kind="class">GlomBakery::View</class>
    <class kind="class">GlomBakery::View_Composite</class>
    <class kind="class">GlomBakery::ViewBase</class>
  </compound>
  <compound kind="class">
    <name>GlomBakery::Document</name>
    <filename>classGlomBakery_1_1Document.html</filename>
    <member kind="enumeration">
      <name>LoadFailureCodes</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>aee1b6b5a8d4686c9bfc169d9a75bdc53</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LOAD_FAILURE_CODE_NONE</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>aee1b6b5a8d4686c9bfc169d9a75bdc53a1cab8645581656f92574a3c98519b653</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LOAD_FAILURE_CODE_NOT_FOUND</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>aee1b6b5a8d4686c9bfc169d9a75bdc53abb44f06404dbf86bbccdcb50a679a3be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LOAD_FAILURE_CODE_LAST</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>aee1b6b5a8d4686c9bfc169d9a75bdc53ad4109c4886aa5ac52a48e740acb54e5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::signal&lt; void, bool &gt;</type>
      <name>type_signal_modified</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a3338f8ada621546f631e871e9bcae2f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::signal&lt; void &gt;</type>
      <name>type_signal_forget</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a8247a2739645ca2398e35f6037f3dcfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Document</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a7021d383cf7160ac5a393c257bbae2a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Document</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a39431a55d3de96daeb19f54761dc5611</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>save</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a5d8543c7cbf31acdd6778c8444037e2d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a6bdd515846e4e047a44daa54b38ce9aa</anchor>
      <arglist>(int &amp;failure_code)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_from_data</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>ad639db1aebeb7a2db2d50c9f6ee0a159</anchor>
      <arglist>(const guchar *data, std::size_t length, int &amp;failure_code)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_modified</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a7d0fa388f9dc3011c4e6e806ade550e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_modified</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>afa5d675e0c12fa51e416047f0daa93d8</anchor>
      <arglist>(bool bVal=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_new</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>af1a8d6f2c8eaf55ba0ee5e7968ba0c9a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_new</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a76c8b9c6ecc0e191e3f85cf7f39a8376</anchor>
      <arglist>(bool bVal)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_contents</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a896bf57ee143517b22cf56308ff8bd4a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_file_uri_with_extension</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a50e355f3c5e974071cd8bf0223ff1802</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_file_uri</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a5fff07fdeaae76a4ed2dad64579fda59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_file_uri</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a6e78066f06cc7a9e8eb7c51583d2a4b8</anchor>
      <arglist>(const Glib::ustring &amp;file_uri, bool bEnforceFileExtension=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>ae2e5f2165ed384a31d4ea0b2bf3a1e47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_read_only</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a69e0b06ad7a5c095b2549d5ea8689f11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_read_only</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>aca92138301a2be9318ec5f3ceb01d5d3</anchor>
      <arglist>(bool bVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_view</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a5ab97a539e9daccd3dc30eb1af0239c4</anchor>
      <arglist>(ViewBase *pView)</arglist>
    </member>
    <member kind="function">
      <type>ViewBase *</type>
      <name>get_view</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a94507eea243c59a8729a1511cb643417</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_file_extension</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>ad487e0619d41cb27d757a94f211ba516</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_file_extension</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>adea9e4e177278e9a65245cbcad0c94b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>type_signal_modified &amp;</type>
      <name>signal_modified</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a2cf84900ee8116c57c49be9c5e7eb077</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>type_signal_forget &amp;</type>
      <name>signal_forget</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>abc145161b68bdbb33295318905b6f16c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>util_file_uri_get_name</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>afd048ced2b460fd52ca616297af87086</anchor>
      <arglist>(const Glib::ustring &amp;file_uri, const Glib::ustring &amp;file_extension)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>load_after</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a4c8ac0b46b4695eb5f04727b0e3be371</anchor>
      <arglist>(int &amp;failure_code)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>save_before</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>abd0e672bb5e8ddd7fc5cb81b76b2d314</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>read_from_disk</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a47de195a88290d2ca8547899ab53432d</anchor>
      <arglist>(int &amp;failure_code)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>write_to_disk</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a613b6457c155ed3678eb5de98c4b3360</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::ustring</type>
      <name>m_strContents</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a09071125e90b766828eaa1be07455412</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::ustring</type>
      <name>m_file_uri</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a992fbbb6c4bedf0564333234bd5009b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::ustring</type>
      <name>m_file_extension</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a03baa3e84f21e9ac4820d78dc28fe076</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ViewBase *</type>
      <name>m_pView</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>adff3979feb69cc4b4d7631322b3b098a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>type_signal_modified</type>
      <name>signal_modified_</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a8c2cb147672f6b9612b8d4d1f5dedeaf</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>type_signal_forget</type>
      <name>signal_forget_</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a98b58ec93a7909f7f70bf0037c2f7360</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_bModified</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a490873f3f13b3c0b95c45fb6b8a653dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_bIsNew</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>ab184cb795e5528f3b919b3b138b6f39d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_bReadOnly</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a9e413c2d465c6f8b235ec4cf374c17b6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GlomBakery::Document_XML</name>
    <filename>classGlomBakery_1_1Document__XML.html</filename>
    <base>GlomBakery::Document</base>
    <member kind="function">
      <type></type>
      <name>Document_XML</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a92f6aff28272abe41b6aa14545660243</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Document_XML</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>acaf74f89ead221993f19e1d6d59eb977</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>load_after</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>afb041d83177715c7f6f4f079a0b9faf5</anchor>
      <arglist>(int &amp;failure_code)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>save_before</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>aba129457041243e5229e96a11e922bd1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_dtd_name</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a7cb117b1444954eadc60dcce2e3fd5ef</anchor>
      <arglist>(const std::string &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_dtd_name</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>af1c479c9f64f2ad904ad4fe171b1e2cf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_dtd_root_node_name</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a499c9b565a3054c7e1e57edd922bce2e</anchor>
      <arglist>(const Glib::ustring &amp;strVal, const Glib::ustring &amp;xmlns=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_dtd_root_node_name</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a6ed81009e4168b32867bf992aee16985</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_indenting_white_space</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>af8ef363dddab833dd67d8f1893009dbc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_xml</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a8b57b63ee4c42d33fee05397599d6462</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>GlomBakery::Document</type>
      <name>type_base</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>aa3ae223391c3b157f24c09d91ee01bfe</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected">
      <type>const xmlpp::Element *</type>
      <name>get_node_document</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a4ebd78f7c993de6973d691c17aebaa70</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>xmlpp::Element *</type>
      <name>get_node_document</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>ac7d1d5976389e3f0ec4740f5e4a38314</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>Util_DOM_Write</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>aedadf61425d76ea986d40c282768d0d8</anchor>
      <arglist>(Glib::ustring &amp;refstrXML) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>add_indenting_white_space_to_node</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>af7de2985683f5539cea5d9fa0fe4d75d</anchor>
      <arglist>(xmlpp::Node *node=0, const Glib::ustring &amp;start_indent=Glib::ustring())</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static Glib::ustring</type>
      <name>get_node_attribute_value</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a4767f3aa33c8078e8b90c6e7bd58c9e7</anchor>
      <arglist>(const xmlpp::Element *node, const Glib::ustring &amp;strAttributeName)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>set_node_attribute_value</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a4d1fe24a95bff15ebc94845bcff59daf</anchor>
      <arglist>(xmlpp::Element *node, const Glib::ustring &amp;strAttributeName, const Glib::ustring &amp;strValue)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static xmlpp::Element *</type>
      <name>get_node_child_named</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a53a035f7a6d626e105f2c72ac1e2a446</anchor>
      <arglist>(const xmlpp::Element *node, const Glib::ustring &amp;strName)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static xmlpp::Element *</type>
      <name>get_node_child_named_with_add</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>af5513c3fbac6cf491970c7fa195ef6aa</anchor>
      <arglist>(xmlpp::Element *node, const Glib::ustring &amp;strName)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>xmlpp::DomParser</type>
      <name>m_DOM_Parser</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a600b6538863c6d22cc6027d0d2dbd20a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>xmlpp::Document *</type>
      <name>m_pDOM_Document</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>aa690187c9bae2055901a3576b4e228ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>m_strDTD_Name</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a690c6dbe1564e23d58b382e78eb82333</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::ustring</type>
      <name>m_strRootNodeName</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a48baedb0ab2139019adee963cb0a04e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::ustring</type>
      <name>m_root_xmlns</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>ae0796cbd8cf5584a028a418ae324eedb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_write_formatted</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a0de7e441b660c1aeb00a0de754925601</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GlomBakery::View</name>
    <filename>classGlomBakery_1_1View.html</filename>
    <templarg></templarg>
    <base>GlomBakery::ViewBase</base>
    <member kind="typedef">
      <type>View&lt; T_Document &gt;</type>
      <name>type_self</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>ab1b595773be83ad108df574b5d9297df</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>View</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>afed624fec48619fb1b374609c9160a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~View</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>a7feea682734afc980f69fe0507badd7c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual T_Document *</type>
      <name>get_document</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>a2507e30b994c4a49c47119639e195811</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const T_Document *</type>
      <name>get_document</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>aad8d8742b3ca8cb5e0dd000e23bcc84b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_document</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>a8f5a68a501f9af2e7fc6cc18c8c2a6d0</anchor>
      <arglist>(T_Document *pDocument)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_modified</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>ae885ea7e7fdd5fd477f8a0ed974660f0</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>on_document_forget</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>afc7d8dfe849f5358acf1be53fd130c3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>T_Document *</type>
      <name>m_pDocument</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>a8f82380a65a1f1fb1625913b4a9e2b5e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GlomBakery::View_Composite</name>
    <filename>classGlomBakery_1_1View__Composite.html</filename>
    <templarg></templarg>
    <base>GlomBakery::View</base>
    <member kind="typedef">
      <type>View&lt; T_Document &gt;</type>
      <name>type_view</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>a3c886ba14fb8e9e4471f5328cae5421e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>View_Composite</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>aa4341ec5946d3b8c5b00ddae0fe83b47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~View_Composite</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>af86e0f7d8844e70c100d10401fadbc34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>add_view</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>a266321969053523ba8e1613ede9896a1</anchor>
      <arglist>(type_view *pView)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>remove_view</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>aee997e9bf84fc72e37c01797f9ec0244</anchor>
      <arglist>(type_view *pView)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_document</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>a43be3e59014edafd8f91f632bad8f806</anchor>
      <arglist>(T_Document *pDocument)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>load_from_document</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>ab66293fd7ac7926b158c1d8b9c2b9034</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>save_to_document</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>a0afd143dd3d2384226745fcc2e6e42ab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>std::vector&lt; type_view * &gt;</type>
      <name>type_vec_views</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>a6e5a4a09f5716106fbb62c0c412560b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>type_vec_views</type>
      <name>m_vecViews</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>ac81060a8eb58e1776d1ecefe96227a2d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GlomBakery::ViewBase</name>
    <filename>classGlomBakery_1_1ViewBase.html</filename>
    <base virtualness="virtual">sigc::trackable</base>
    <member kind="function">
      <type></type>
      <name>ViewBase</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>a7948afa22bc7a7769bb049f23dddc3bc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ViewBase</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>ad36ce7da0fbb26962a0559c219efb9b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>load_from_document</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>a202370fe4a22aba9df41687d2290ff48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>save_to_document</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>ae0232282d6f5ff7e781ced408d5b1614</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clipboard_copy</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>a353afaaa7ec3f179a4cc6623b80c5a34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clipboard_paste</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>a68fa9510b56b2133b39cffc367d11ad4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clipboard_clear</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>a68132a802bd9edf7e0337e008dd1cbaf</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Gtk</name>
    <filename>namespaceGtk.html</filename>
  </compound>
</tagfile>
