/* Glom
 *
 * Copyright (C) 2001-2004 Murray Cumming
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "box_data_list_find.h"
#include <libintl.h>

Box_Data_List_Find::Box_Data_List_Find()
: m_HBox(false, 6)
{
  m_strHint = gettext("Enter the search criteria and click [Find]\n Glom will then change to Data mode to display the results.");

  m_HBox.pack_end(m_Button_Find, Gtk::PACK_EXPAND_WIDGET);
  pack_start(m_HBox, Gtk::PACK_EXPAND_WIDGET);

  show_all();
}

Box_Data_List_Find::~Box_Data_List_Find()
{
}


void Box_Data_List_Find::fill_from_database()
{
g_warning("Box_Data_List_Find::Fill");

  Bakery::BusyCursor(*get_app_window());
    
  Box_DB_Table::fill_from_database();

  try
  {
    sharedptr<SharedConnection> sharedconnection = connect_to_server();
    if(sharedconnection)
    {
      Glib::RefPtr<Gnome::Gda::Connection> connection = sharedconnection->get_gda_connection();
    
      Glib::RefPtr<Gnome::Gda::DataModel> result;

      //Field Names:
      m_AddDel.remove_all_columns();

      //Primary Key:
      guint iKey = 0;
      bool bKeyFound = get_field_primary_key(iKey);

      guint uiCol = 0;

      if(bKeyFound)
      {
        const Glib::ustring& strKey = m_Fields[iKey].get_name();
        m_AddDel.add_column(strKey, strKey); //TODO: Use the field title.
        uiCol++;
      }

      //Other fields
      for(guint i = 0; i < m_Fields.size(); i++)
      {
        bool bDo = true;
        if(bKeyFound && (i == iKey))
          bDo = false;

        if(bDo)
        {
          const Glib::ustring& strName = m_Fields[i].get_name();
          m_AddDel.add_column(strName, strName); //TODO: Use the field title.
          uiCol++;
        }
      }
      
    }


    //m_AddDel.remove_all();
  }
  catch(std::exception& ex)
  {
    handle_error(ex);
  }

  fill_end();
}
