/*  Glimmer - windows.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "windows.h"
#include "main.h"
#include "misc.h"
#include "signals.h"
#include "widgets/gdsfile.h"

void new_window_cb(GtkWidget *widget, gpointer data)
{
   gchar *command = NULL;
   command = g_strdup_printf("%s &", PACKAGE);
   system(command);
   g_free(command);
}

void cycle_left_cb(GtkWidget *widget, gpointer data)
{
   GdsFile *new_file;
   gint index;
   gint new_index;
   gint total;
   total = g_list_length(GTK_NOTEBOOK(files_book)->children);
   index = get_nth_file_number(cur_file);
   if(index == -1) return;
   if(index == 0) new_index = total-1;
   else new_index = index-1;
   if(index == new_index) return;
   new_file = get_nth_file_proper(new_index);
   if(new_file) file_change(NULL, new_file);
}

void cycle_right_cb(GtkWidget *widget, gpointer data)
{
   GdsFile *new_file;
   gint index;
   gint new_index;
   gint total;
   total = g_list_length(GTK_NOTEBOOK(files_book)->children);
   index = get_nth_file_number(cur_file);
   if(index == -1) return;
   if(index == total-1) new_index = 0;
   else new_index = index+1;
   if(index == new_index) return;
   new_file = get_nth_file_proper(new_index);
   if(new_file) file_change(NULL, new_file);
}

void move_left_cb(GtkWidget *widget, gpointer data)
{
   GdsFile *new_file;
   GtkWidget *parent;
   GtkWidget *menu_item;
   gint index;
   gint new_index;
   gint new_file_index;
   gint total;
   total = g_list_length(GTK_NOTEBOOK(files_book)->children);
   index = get_nth_file_number(cur_file);
   if(index == -1) return;
   if(index == 0) new_index = total-1;
   else new_index = index-1;
   if(index == new_index) return;
#ifdef WITH_PYTHON
   app_emit_scripting_signal("move-left");
#endif
   new_file = get_nth_file_proper(new_index);
   new_file_index = g_list_index(files_list, new_file);
   files_list = g_list_remove(files_list, (gpointer)cur_file);
   files_list = g_list_insert(files_list, (gpointer)cur_file, new_file_index);
   gtk_notebook_reorder_child(GTK_NOTEBOOK(files_book), cur_file->tear_away, new_index);
   menu_item = cur_file->menu_item;
   parent = menu_item->parent;
   gtk_widget_ref(menu_item);
   gtk_container_remove(GTK_CONTAINER(parent), menu_item);
   gtk_menu_shell_insert(GTK_MENU_SHELL(parent), menu_item, new_file_index+2);
   gtk_widget_unref(menu_item);
   cur_page = new_index;
}

void move_right_cb(GtkWidget *widget, gpointer data)
{
   GdsFile *new_file;
   GtkWidget *parent;
   GtkWidget *menu_item;
   gint index;
   gint new_index;
   gint new_file_index;
   gint total;
   total = g_list_length(GTK_NOTEBOOK(files_book)->children);
   index = get_nth_file_number(cur_file);
   if(index == -1) return;
   if(index == total-1) new_index = 0;
   else new_index = index+1;
   if(index == new_index) return;
#ifdef WITH_PYTHON
   app_emit_scripting_signal("move-right");
#endif
   new_file = get_nth_file_proper(new_index);
   new_file_index = g_list_index(files_list, new_file);
   files_list = g_list_remove(files_list, (gpointer)cur_file);
   files_list = g_list_insert(files_list, (gpointer)cur_file, new_file_index);
   gtk_notebook_reorder_child(GTK_NOTEBOOK(files_book), cur_file->tear_away, new_index);
   menu_item = cur_file->menu_item;
   parent = menu_item->parent;
   gtk_widget_ref(menu_item);
   gtk_container_remove(GTK_CONTAINER(parent), menu_item);
   gtk_menu_shell_insert(GTK_MENU_SHELL(parent), menu_item, new_file_index+2);
   gtk_widget_unref(menu_item);
   cur_page = new_index;
}
