/*  Glimmer - file-io.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef FILE_IO_H
#define FILE_IO_H

#ifdef __cplusplus
extern "C" {
#endif

#include "declarations.h"
#include "widgets/gdsfile.h"
#include "widgets/gnomefilelist.h"

void new_file_real(gchar *filename);
void new_file_cb(GtkWidget *widget, gpointer data);
void open_file_cb(GtkWidget *widget, gpointer data);
void open_file_cb_continue(GtkWidget *widget, GnomeFileList *file_list);
void open_files_cb(GtkWidget *widget, gpointer data);
void open_files_cb_continue(GtkWidget *widget, GnomeFileList *file_list);
void open_file_error_cb(GtkWidget *widget, gchar *filename);
void open_file_real(gchar *filename);
void revert_current_file(GtkWidget *widget, gpointer data);
void save_file_cb(GtkWidget *widget, gpointer data);
void save_file_error_cb(GtkWidget *widget, GdsFile *file);
void save_file_real(GdsFile *gds_file);
void save_file_as_cb(GtkWidget *widget, gpointer data);
void save_file_as_continue(GtkWidget *widget, GnomeFileList *file_list);
void save_file_as_error_cb(GtkWidget *widget, gchar *filename);
void save_file_as_real(GdsFile *gds_file, gchar *filename);
void save_all_files_cb(GtkWidget *widget, gpointer data);
void reload_file_cb(GtkWidget *widget, GdsFile *gds_file);
void save_file_or_dialog(GdsFile *gds_file);
void close_file_cb(GtkWidget *widget, gpointer data);
void close_file_error_cb(GtkWidget *widget, GdsFile *file);
void close_file_real(GdsFile *file);
void close_all_files_cb(GtkWidget *widget, gpointer data);
gboolean open_file_add_text(GtkWidget *text, gchar *filename);
gboolean check_if_file_exists(gchar *filename);
gboolean check_if_file_can_exist(gchar *filename);
gboolean check_if_read_only(gchar *filename, GdsFile *temp, gboolean set_ro, gboolean do_error);
void file_create(GtkWidget *widget, gchar *filename);

gint get_time(gchar *filename);

extern gchar *last_dir;
extern GList *recent_files;

#ifdef __cplusplus
}
#endif

#endif
