/*  Glimmer - edit.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "edit.h"
#include "commandbar.h"
#include "main.h"
#include "syntax-highlight.h"

void reverse_bookmark_cb(GtkWidget *widget, gpointer data)
{
   GtkExText *text;
   GdkPixmap *pixmap;
   GdkBitmap *mask;
   gint line;
   text = GTK_EXTEXT(cur_file->text);
   line = gtk_extext_get_line(text);
   gtk_extext_get_line_pixmap(text, line, &pixmap, &mask);
   if(pixmap == NULL)
   {
      gtk_extext_set_line_pixmap(text, line, bookmark_pixmap->pixmap, bookmark_pixmap->mask);
      gtk_widget_queue_draw(cur_file->text);
   }
   else if(pixmap == bookmark_pixmap->pixmap)
   {
      gtk_extext_set_line_pixmap(text, line, NULL, NULL);
      gtk_widget_queue_draw(cur_file->text);
   }
}

void undo_last_cb(GtkWidget *widget, gpointer data)
{
   undo_last_real(cur_file);
}

void undo_last_real(GdsFile *file)
{
   GtkExText *extext;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   extext = GTK_EXTEXT(file->text);
   gtk_extext_undo(GTK_EXTEXT(file->text));
   GDS_EDITOR(file->text)->changed -= 2;
   gtk_signal_emit_by_name(GTK_OBJECT(file->text), "move_to_column", 0, NULL);
}

void redo_last_cb(GtkWidget *widget, gpointer data)
{
   redo_last_real(cur_file);
}

void redo_last_real(GdsFile *file)
{
   GtkExText *extext;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   extext = GTK_EXTEXT(file->text);
   gtk_extext_redo(GTK_EXTEXT(file->text));
   gtk_signal_emit_by_name(GTK_OBJECT(file->text), "move_to_column", 0, NULL);
}

void cut_text_cb(GtkWidget *widget, gpointer data)
{
   cut_text_real(cur_file);
}

void cut_text_real(GdsFile *file)
{
   GtkExText *extext;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   extext = GTK_EXTEXT(file->text);
   gtk_extext_cut_clipboard(extext);
}

void copy_text_cb(GtkWidget *widget, gpointer data)
{
   copy_text_real(cur_file);
}

void copy_text_real(GdsFile *file)
{
   GtkExText *extext;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   extext = GTK_EXTEXT(file->text);
   gtk_extext_copy_clipboard(extext);
}

void paste_text_cb(GtkWidget *widget, gpointer data)
{
   paste_text_real(cur_file);
}

void paste_text_real(GdsFile *file)
{
   GtkExText *extext;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   extext = GTK_EXTEXT(file->text);
   gtk_extext_paste_clipboard(extext);
}

void clear_text_cb(GtkWidget *widget, gpointer data)
{
   g_return_if_fail(cur_file);
   clear_text_real(cur_file);
}

void clear_text_real(GdsFile *file)
{
   GtkExText *extext;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   extext = GTK_EXTEXT(file->text);

   if(!extext->has_selection)
      select_all_text_real(file);
   gtk_extext_delete_selection(extext);
}

void clear_line_cb(GtkWidget *widget, gpointer data)
{
   GtkExText *text;
   GtkExTextLineData *linedata;
   g_return_if_fail(cur_file);
   text = GTK_EXTEXT(cur_file->text);
   linedata = gtk_extext_get_line_data(text, text->line_number, text->scroll_line_start);
   if(linedata)
   {
      gds_editor_delete_text(GDS_EDITOR(text), linedata->startpos, linedata->endpos);
      g_free(linedata);
   }
}

void clear_end_cb(GtkWidget *widget, gpointer data)
{
   GtkExText *text;
   GtkExTextLineData *linedata;
   g_return_if_fail(cur_file);
   text = GTK_EXTEXT(cur_file->text);
   linedata = gtk_extext_get_line_data(text, text->line_number, text->scroll_line_start);
   if(linedata)
   {
      gds_editor_delete_text(GDS_EDITOR(text), GTK_EXTEXT(text)->current_pos, linedata->endpos);
      g_free(linedata);
   }
}

void clear_start_cb(GtkWidget *widget, gpointer data)
{
   GtkExText *text;
   GtkExTextLineData *linedata;
   g_return_if_fail(cur_file);
   text = GTK_EXTEXT(cur_file->text);
   linedata = gtk_extext_get_line_data(text, text->line_number, text->scroll_line_start);
   if(linedata)
   {
      gds_editor_delete_text(GDS_EDITOR(text), linedata->startpos, GTK_EXTEXT(text)->current_pos);
      g_free(linedata);
   }
}

void clear_entry_real(void)
{
#ifdef WITH_PYTHON
   GtkEntry *entry;
   entry = GTK_ENTRY(macro_entry);
   gtk_entry_set_text(entry, "");
#endif
}

void select_line_cb(GtkWidget *widget, gpointer data)
{
   GtkExText *text;
   GtkExTextLineData *linedata;
   g_return_if_fail(cur_file);
   text = GTK_EXTEXT(cur_file->text);
   linedata = gtk_extext_get_line_data(text, text->line_number, text->scroll_line_start);
   if(linedata && linedata->startpos < linedata->endpos)
   {
      gtk_extext_select_region(text, linedata->startpos, linedata->endpos);
   }
   g_free(linedata);
}

void select_current_cb(GtkWidget *widget, gpointer data)
{
   select_current_real(cur_file);
}

void select_current_real(GdsFile *file)
{
   gint start, end;
   GtkExText *extext;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   extext = GTK_EXTEXT(file->text);
   start = gtk_extext_get_position(extext);
   if(gtk_extext_get_current_word(extext, &start, &end))
      gtk_extext_select_region(extext, start, end);
}

void select_all_text_cb(GtkWidget *widget, gpointer data)
{
   select_all_text_real(cur_file);
}

void select_all_text_real(GdsFile *file)
{
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));
   gtk_extext_select_region(GTK_EXTEXT(file->text), 0, gtk_extext_get_length(GTK_EXTEXT(file->text)));
}

void highlight_syntax_cb(GtkWidget *widget, gpointer data)
{
   highlight_syntax_real(cur_file);
}

void highlight_syntax_real(GdsFile *file)
{
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));
   gds_editor_highlight(GDS_EDITOR(file->text));
}

void reparse_highlight_table_cb(GtkWidget *widget, gpointer data)
{
   g_return_if_fail(cur_file != NULL);
   reparse_highlight_table(cur_file->tables);      
}
