/*  Glimmer - dialogs.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "dialogs.h"
#include "file-io.h"
#include "misc.h"
#include "main.h"

static void main_quit(GtkWidget *widget, gpointer data);

gint file_dne_error(gchar *filename, GtkSignalFunc callback)
{
   GtkWidget *error_window;
   GnomeDialog *dialog;
   GtkWidget *pixmap;
   GtkWidget *box;
   gchar *name;
   GtkWidget *label;
   gchar *string;
   gchar *line;
   gint result;
    
   string = g_strdup(filename);
   error_window = gnome_dialog_new(_("Read Error!"), GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO, NULL);
   dialog = GNOME_DIALOG(error_window);

   box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(dialog->vbox), box, FALSE, FALSE, 0);
   gtk_widget_show(box);

   name = gnome_pixmap_file("gnome-question.png");
   if(name)
   {
      pixmap = gnome_pixmap_new_from_file(name);
      gtk_box_pack_start(GTK_BOX(box), pixmap, FALSE, FALSE, 10);
      gtk_widget_show(pixmap);
   }

   line = g_strconcat(string, _(" does not exist.\nWould you like to create it?"), NULL);
   label = gtk_label_new(line);
   gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);
   g_free(line);

   gnome_dialog_button_connect_object(dialog, 1, GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(error_window));
   gnome_dialog_set_default(dialog, 1);

   gnome_dialog_button_connect(dialog, 0, GTK_SIGNAL_FUNC(file_create), (gpointer)string);
   gnome_dialog_button_connect(dialog, 0, callback, (gpointer)string);
   gnome_dialog_button_connect_object(dialog, 0, GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(error_window));

   gnome_dialog_set_parent(dialog, GTK_WINDOW(window));
   result = gnome_dialog_run_and_close(dialog);
   g_free(string);
   return(result);
}

gint file_exists_error(gchar *filename, GtkSignalFunc callback)
{
   GtkWidget *error_window;
   GnomeDialog *dialog;
   GtkWidget *pixmap;
   GtkWidget *box;
   gchar *name;
   GtkWidget *label;
   gchar *string;
   gchar *line;
   gint result;
   
   string = g_strdup(filename);
   error_window = gnome_dialog_new(_("Write Error!"), GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO, NULL);
   dialog = GNOME_DIALOG(error_window);

   box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(dialog->vbox), box, FALSE, FALSE, 0);
   gtk_widget_show(box);

   name = gnome_pixmap_file("gnome-question.png");
   if(name)
   {
      pixmap = gnome_pixmap_new_from_file(name);
      gtk_box_pack_start(GTK_BOX(box), pixmap, FALSE, FALSE, 10);
      gtk_widget_show(pixmap);
   }

   line = g_strconcat(string, _(" already exists.\nWould you like to overwrite it?"), NULL);
   label = gtk_label_new(line);
   gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);
   g_free(line);

   gnome_dialog_button_connect(dialog, 0, callback, (gpointer)string);
   gnome_dialog_set_default(dialog, 1);

   gnome_dialog_set_parent(dialog, GTK_WINDOW(window));
   result = gnome_dialog_run_and_close(dialog);
   g_free(string);
   return(result);
}

gint file_not_saved(char *filename, GdsFile *file, GtkSignalFunc func_yes, GtkSignalFunc func_no)
{
   GtkWidget *error_window;
   GnomeDialog *dialog;
   GtkWidget *pixmap;
   GtkWidget *box;
   gchar *name;
   GtkWidget *label;
   gchar *line;
   gint result;
   
   error_window = gnome_dialog_new(_("Save Error!"), GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO, GNOME_STOCK_BUTTON_CANCEL, NULL);
   dialog = GNOME_DIALOG(error_window);

   box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(dialog->vbox), box, FALSE, FALSE, 0);
   gtk_widget_show(box);

   name = gnome_pixmap_file("gnome-question.png");
   if(name)
   {
      pixmap = gnome_pixmap_new_from_file(name);
      gtk_box_pack_start(GTK_BOX(box), pixmap, FALSE, FALSE, 10);
      gtk_widget_show(pixmap);
   }

   line = g_strconcat(filename, _(" has been changed.\nWould you like to save it now it?"), NULL);
   label = gtk_label_new(line);
   gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);
   g_free(line);

   gnome_dialog_button_connect(dialog, 0, GTK_SIGNAL_FUNC(save_file_error_cb), (gpointer)file);
   gnome_dialog_button_connect(dialog, 0, GTK_SIGNAL_FUNC(close_file_error_cb), (gpointer)file);
   if(func_yes) gnome_dialog_button_connect(dialog, 0, func_yes, NULL);

   gnome_dialog_button_connect(dialog, 1, GTK_SIGNAL_FUNC(close_file_error_cb), (gpointer)file);
   if(func_no) gnome_dialog_button_connect(dialog, 1, func_no, NULL);

   gnome_dialog_set_default(dialog, 2);

   gnome_dialog_set_parent(dialog, GTK_WINDOW(window));
   result = gnome_dialog_run_and_close(dialog);
   return(result);
}

gint file_not_saved_no_close(char *filename, GdsFile *file, GtkSignalFunc func_yes, GtkSignalFunc func_no)
{
   GtkWidget *error_window;
   GnomeDialog *dialog;
   GtkWidget *pixmap;
   GtkWidget *box;
   gchar *name;
   GtkWidget *label;
   gchar *line;
   gint result;
   
   error_window = gnome_dialog_new(_("Save Error!"), GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO, GNOME_STOCK_BUTTON_CANCEL, NULL);
   dialog = GNOME_DIALOG(error_window);

   box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(dialog->vbox), box, FALSE, FALSE, 0);
   gtk_widget_show(box);

   name = gnome_pixmap_file("gnome-question.png");
   if(name)
   {
      pixmap = gnome_pixmap_new_from_file(name);
      gtk_box_pack_start(GTK_BOX(box), pixmap, FALSE, FALSE, 10);
      gtk_widget_show(pixmap);
   }

   line = g_strconcat(filename, _(" has been changed.\nWould you like to save it now it?"), NULL);
   label = gtk_label_new(line);
   gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);
   g_free(line);

   gnome_dialog_button_connect(dialog, 0, GTK_SIGNAL_FUNC(save_file_error_cb), (gpointer)file);
   if(func_yes) gnome_dialog_button_connect(dialog, 0, func_yes, file);
   if(func_no) gnome_dialog_button_connect(dialog, 1, func_no, file);
   gnome_dialog_set_default(dialog, 2);

   gnome_dialog_set_parent(dialog, GTK_WINDOW(window));
   result = gnome_dialog_run_and_close(dialog);
   return(result);
}

static void main_quit(GtkWidget *widget, gpointer data)
{
   gtk_main_quit();
}

gint file_not_saved_save_as(char *filename, GdsFile *file, GtkSignalFunc func_yes, GtkSignalFunc func_no)
{
   GtkWidget *error_window;
   GnomeDialog *dialog;
   GtkWidget *pixmap;
   GtkWidget *box;
   gchar *name;
   GtkWidget *label;
   gchar *line;
   gint result;
   
   error_window = gnome_dialog_new(_("Save Error!"), GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO, GNOME_STOCK_BUTTON_CANCEL, NULL);
   dialog = GNOME_DIALOG(error_window);

   box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(dialog->vbox), box, FALSE, FALSE, 0);
   gtk_widget_show(box);

   name = gnome_pixmap_file("gnome-question.png");
   if(name)
   {
      pixmap = gnome_pixmap_new_from_file(name);
      gtk_box_pack_start(GTK_BOX(box), pixmap, FALSE, FALSE, 10);
      gtk_widget_show(pixmap);
   }

   line = g_strconcat(filename, _(" has been changed.\nWould you like to save it now it?"), NULL);
   label = gtk_label_new(line);
   gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);
   g_free(line);

   if(func_yes) gnome_dialog_button_connect(dialog, 0, func_yes, NULL);

   gnome_dialog_button_connect(dialog, 1, GTK_SIGNAL_FUNC(close_file_error_cb), (gpointer)file);
   if(func_no) gnome_dialog_button_connect(dialog, 1, func_no, file);

   gnome_dialog_set_default(dialog, 2);
   gnome_dialog_set_parent(dialog, GTK_WINDOW(window));

   result = gnome_dialog_run_and_close(dialog);
   if(result == 0)
   {
      gchar *str = NULL;
      GtkWidget *widget;
      str = get_path_from_filename(cur_file->filename);
      widget = gnome_filelist_new_with_path(str);
      g_free(str);
      gnome_filelist_set_title(GNOME_FILELIST(widget), _("Save file with new name..."));
      gtk_signal_connect(GTK_OBJECT(GNOME_FILELIST(widget)->ok_button), "clicked", GTK_SIGNAL_FUNC(save_file_as_continue), widget);
      gtk_signal_connect_object(GTK_OBJECT(GNOME_FILELIST(widget)->ok_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(widget));
      gtk_signal_connect_object(GTK_OBJECT(GNOME_FILELIST(widget)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(widget));
      gtk_window_set_modal(GTK_WINDOW(widget), TRUE);
      gtk_window_set_transient_for(GTK_WINDOW(widget), GTK_WINDOW(window));
      gtk_widget_show(widget);
      str = get_file_from_filename(cur_file->filename);
      if(str) gtk_entry_set_text(GTK_ENTRY(GNOME_FILELIST(widget)->selection_entry), str);
      g_free(str);
      gtk_widget_grab_focus(GNOME_FILELIST(widget)->selection_entry);
      gtk_signal_connect_object(GTK_OBJECT(widget), "destroy", GTK_SIGNAL_FUNC(gtk_grab_remove), GTK_OBJECT(widget));
      gtk_signal_connect(GTK_OBJECT(widget), "destroy", GTK_SIGNAL_FUNC(main_quit), NULL);
      gtk_main();
      close_file_real(file);
   }
   return(result);
}

gint file_externally_modified_reload(char *filename, GdsFile *file, GtkSignalFunc func_yes, GtkSignalFunc func_no)
{
   GtkWidget *error_window;
   GnomeDialog *dialog;
   GtkWidget *pixmap;
   GtkWidget *box;
   gchar *name;
   GtkWidget *label;
   gchar *line;
   gint result;
   
   error_window = gnome_dialog_new(_("File Modified!"), GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO, NULL);
   dialog = GNOME_DIALOG(error_window);

   box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(dialog->vbox), box, FALSE, FALSE, 0);
   gtk_widget_show(box);

   name = gnome_pixmap_file("gnome-question.png");
   if(name)
   {
      pixmap = gnome_pixmap_new_from_file(name);
      gtk_box_pack_start(GTK_BOX(box), pixmap, FALSE, FALSE, 10);
      gtk_widget_show(pixmap);
   }

   line = g_strconcat(filename, _(" has been modified on disk since the last save.\nWould you like to reload it now?"), NULL);
   label = gtk_label_new(line);
   gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);
   g_free(line);

   gnome_dialog_button_connect(dialog, 0, GTK_SIGNAL_FUNC(reload_file_cb), (gpointer)file);
   if(func_yes) gnome_dialog_button_connect(dialog, 0, func_yes, file);
   if(func_no) gnome_dialog_button_connect(dialog, 1, func_no, file);
   gnome_dialog_set_default(dialog, 0);

   gnome_dialog_set_parent(dialog, GTK_WINDOW(window));
   result = gnome_dialog_run_and_close(dialog);
   return(result);
}

void read_error(gchar *filename)
{
   GtkWidget *error_window;
   GnomeDialog *dialog;
   GtkWidget *pixmap;
   GtkWidget *box;
   gchar *name;
   GtkWidget *label;
   gchar *line;
   gint result;
   
   error_window = gnome_dialog_new(_("Read Error!"), GNOME_STOCK_BUTTON_OK, NULL);
   dialog = GNOME_DIALOG(error_window);

   box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(dialog->vbox), box, FALSE, FALSE, 0);
   gtk_widget_show(box);

   name = gnome_pixmap_file("gnome-warning.png");
   if(name)
   {
      pixmap = gnome_pixmap_new_from_file(name);
      gtk_box_pack_start(GTK_BOX(box), pixmap, FALSE, FALSE, 10);
      gtk_widget_show(pixmap);
   }

   line = g_strconcat(filename, _(" could not be read."), NULL);
   label = gtk_label_new(line);
   gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);
   g_free(line);

   gnome_dialog_set_default(dialog, 0);
   gnome_dialog_set_parent(dialog, GTK_WINDOW(window));
   result = gnome_dialog_run_and_close(dialog);
}

void save_error(gchar *filename)
{
   GtkWidget *error_window;
   GnomeDialog *dialog;
   GtkWidget *pixmap;
   GtkWidget *box;
   gchar *name;
   GtkWidget *label;
   gchar *line;
   gint result;
   
   error_window = gnome_dialog_new(_("Save Error!"), GNOME_STOCK_BUTTON_OK, NULL);
   dialog = GNOME_DIALOG(error_window);

   box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(dialog->vbox), box, FALSE, FALSE, 0);
   gtk_widget_show(box);

   name = gnome_pixmap_file("gnome-warning.png");
   if(name)
   {
      pixmap = gnome_pixmap_new_from_file(name);
      gtk_box_pack_start(GTK_BOX(box), pixmap, FALSE, FALSE, 10);
      gtk_widget_show(pixmap);
   }

   line = g_strconcat(filename, _(" could not be saved!"), NULL);
   label = gtk_label_new(line);
   gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);
   g_free(line);

   gnome_dialog_set_default(dialog, 0);
   gnome_dialog_set_parent(dialog, GTK_WINDOW(window));
   result = gnome_dialog_run_and_close(dialog);
}


void read_only(gchar *filename)
{
   GtkWidget *error_window;
   GnomeDialog *dialog;
   GtkWidget *pixmap;
   GtkWidget *box;
   gchar *name;
   GtkWidget *label;
   gchar *line;
   gint result;
   
   error_window = gnome_dialog_new(_("Read Error!"), GNOME_STOCK_BUTTON_OK, NULL);
   dialog = GNOME_DIALOG(error_window);

   box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(dialog->vbox), box, FALSE, FALSE, 0);
   gtk_widget_show(box);

   name = gnome_pixmap_file("gnome-info.png");
   if(name)
   {
      pixmap = gnome_pixmap_new_from_file(name);
      gtk_box_pack_start(GTK_BOX(box), pixmap, FALSE, FALSE, 10);
      gtk_widget_show(pixmap);
   }

   line = g_strconcat(filename, _(" opened as read-only!"), NULL);
   label = gtk_label_new(line);
   gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);
   g_free(line);

   gnome_dialog_set_default(dialog, 0);
   gnome_dialog_set_parent(dialog, GTK_WINDOW(window));
   result = gnome_dialog_run_and_close(dialog);
}


void create_error(gchar *filename)
{
   GtkWidget *error_window;
   GnomeDialog *dialog;
   GtkWidget *pixmap;
   GtkWidget *box;
   gchar *name;
   GtkWidget *label;
   gchar *line;
   gint result;
   
   error_window = gnome_dialog_new(_("Create Error!"), GNOME_STOCK_BUTTON_OK, NULL);
   dialog = GNOME_DIALOG(error_window);

   box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(dialog->vbox), box, FALSE, FALSE, 0);
   gtk_widget_show(box);

   name = gnome_pixmap_file("gnome-warning.png");
   if(name)
   {
      pixmap = gnome_pixmap_new_from_file(name);
      gtk_box_pack_start(GTK_BOX(box), pixmap, FALSE, FALSE, 10);
      gtk_widget_show(pixmap);
   }

   line = g_strconcat(filename, _(" could not be created!"), NULL);
   label = gtk_label_new(line);
   gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);
   g_free(line);

   gnome_dialog_set_default(dialog, 0);
   gnome_dialog_set_parent(dialog, GTK_WINDOW(window));
   result = gnome_dialog_run_and_close(dialog);
}

void generic_dialog_with_text(gchar *text)
{
   GtkWidget *error_window;
   GnomeDialog *dialog;
   GtkWidget *pixmap;
   GtkWidget *box;
   gchar *name;
   GtkWidget *label;
   gint result;
   
   error_window = gnome_dialog_new(_("Information"), GNOME_STOCK_BUTTON_CLOSE, NULL);
   dialog = GNOME_DIALOG(error_window);

   box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(dialog->vbox), box, FALSE, FALSE, 0);
   gtk_widget_show(box);

   name = gnome_pixmap_file("gnome-info.png");
   if(name)
   {
      pixmap = gnome_pixmap_new_from_file(name);
      gtk_box_pack_start(GTK_BOX(box), pixmap, FALSE, FALSE, 10);
      gtk_widget_show(pixmap);
   }

   label = gtk_label_new(text);
   gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);

   gnome_dialog_set_default(dialog, 0);
   gnome_dialog_set_parent(dialog, GTK_WINDOW(window));
   result = gnome_dialog_run_and_close(dialog);
}
