/*  Glimmer - commandbar.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "commandbar.h"
#include "main.h"
#include "misc.h"
#include "settings.h"

#ifdef WITH_PYTHON
static void execute_macro_cb(GtkWidget* widget, gpointer data);
static void check_macro_button_cb(GtkWidget* widget, GtkWidget *target);

GtkWidget *commandbar;
GtkWidget *macro_combo;
GtkWidget *macro_entry;
static GList *macro_history = NULL;

void make_command_combo(void)
{
   GtkWidget *macro_button;
   GtkWidget *pixmapwid;

   commandbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
   gtk_container_set_border_width(GTK_CONTAINER(commandbar), 2);
   gtk_toolbar_set_button_relief(GTK_TOOLBAR(commandbar), GTK_RELIEF_NONE);
   gtk_widget_show(commandbar);
   macro_combo = gtk_combo_new();
   gtk_widget_set_usize(macro_combo, 250, 23);
   gtk_combo_disable_activate(GTK_COMBO(macro_combo));
   gtk_combo_set_case_sensitive(GTK_COMBO(macro_combo), TRUE);
   gtk_toolbar_append_widget(GTK_TOOLBAR(commandbar), macro_combo, _("Execute string"), NULL);
   macro_entry = GTK_COMBO(macro_combo)->entry;
   gtk_signal_connect(GTK_OBJECT(macro_entry), "activate", GTK_SIGNAL_FUNC(execute_macro_cb), NULL);
   command_combo_set_history(build_glist_from_file("command.hist", general_preferences.history));
   gtk_widget_show(macro_combo);
   gtk_toolbar_append_space(GTK_TOOLBAR(commandbar));
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_EXEC, 21, 21);
   macro_button = gtk_toolbar_append_item(GTK_TOOLBAR(commandbar), 0, _("Execute a command"), 0, pixmapwid, GTK_SIGNAL_FUNC(execute_macro_cb), 0);
   gtk_widget_set_sensitive(macro_button, FALSE);
   gtk_signal_connect(GTK_OBJECT(macro_entry), "changed", GTK_SIGNAL_FUNC(check_macro_button_cb), macro_button);
   gnome_app_add_docked(GNOME_APP(app), commandbar, "CommandBar", GNOME_DOCK_ITEM_BEH_NORMAL, GNOME_DOCK_TOP, 3, 2, 0);
}

static void execute_macro_cb(GtkWidget* widget, gpointer data)
{
   gchar *text;
   text = gtk_entry_get_text(GTK_ENTRY(macro_entry));
   if(strlen(text)>0)
   {
      execute_macro_string(text);
      add_string_to_file("command.hist", text);
      command_combo_add_string(text);
   }
}

static void check_macro_button_cb(GtkWidget* widget, GtkWidget *target)
{
   gchar *text;
   text = gtk_entry_get_text(GTK_ENTRY(macro_entry));
   if(strlen(text) > 0)
      gtk_widget_set_sensitive(target, TRUE);
   else
      gtk_widget_set_sensitive(target, FALSE);
}

void command_combo_set_history(GList *history)
{
   if(history == NULL) return;
   macro_history = history;
   gtk_combo_set_popdown_strings(GTK_COMBO(macro_combo), macro_history);
   gtk_entry_set_text(GTK_ENTRY(macro_entry), "");
}

gboolean command_combo_add_string(gchar *string)
{
   gint pos;
   gpointer temp;
   GList *ptr;
   gboolean success = FALSE;
   pos = check_list_for_string(macro_history, string);
   if(pos)
   {
      temp = g_list_nth_data(macro_history, pos-1);
      macro_history = g_list_remove(macro_history, temp);
   }
   else
   {
      temp = g_new(char, strlen(string)+1);
      strcpy((gchar *)temp, string);
   }

   macro_history = g_list_prepend(macro_history, temp);

   while(g_list_length(macro_history) > general_preferences.history)
   {
      ptr = g_list_nth(macro_history, g_list_length(macro_history)-1);
      if(ptr)
      {
         temp = ptr->data;
         macro_history = g_list_remove(macro_history, ptr->data);
         g_free(ptr->data);
      }
   }
   gtk_combo_set_popdown_strings(GTK_COMBO(macro_combo), macro_history);
   return(success);
}
#endif
