/*  Glimmer - bindings-python.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"

#include "bindings.h"
#include "settings.h"
#include "signals.h"
#include "toolbar.h"

static void paned_child_hide(GtkWidget *widget, GtkPaned *paned);
static void paned_child_show(GtkWidget *widget, GtkPaned *paned);

static PyObject *_wrap_get_file_number(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int result;

   self = self;
   if(!PyArg_ParseTuple(args,":get_file_number")) 
      return NULL;
   result = (int)get_file_number();
   resultobj = Py_BuildValue("i", result);
   return resultobj;
}

static PyObject *_wrap_change(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int result;
   int arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:change",&arg0)) 
      return NULL;
   result = (int)change(arg0);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_get_files(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int result;

   self = self;
   if(!PyArg_ParseTuple(args,":get_files")) 
      return NULL;
   result = (int)get_files();
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_get_default_term_command(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   gchar *command;

   self = self;
   if(!PyArg_ParseTuple(args,":get_default_term_command")) 
      return NULL;
   command = get_default_term_command();
   resultobj = Py_BuildValue("s", command);
   g_free(command);
   return resultobj;
}

static PyObject *_wrap_get_default_make_command(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *command;

   self = self;
   if(!PyArg_ParseTuple(args,":get_default_make_command")) 
      return NULL;
   command = get_default_make_command();
   resultobj = Py_BuildValue("s", command);
   g_free(command);
   return resultobj;
}

static PyObject *_wrap_get_tab_stops(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int tab_stops;

   self = self;
   if(!PyArg_ParseTuple(args,":get_tab_stops")) 
      return NULL;
   tab_stops = get_tab_stops();
   resultobj = Py_BuildValue("i", tab_stops);
   return resultobj;
}

static PyObject *_wrap_get_file_length(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:get_file_length",&arg0)) 
      return NULL;
   result = (int)get_file_length(arg0);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_get_file_changed(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:get_file_changed",&arg0)) 
      return NULL;
   result = (int)get_file_changed(arg0);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_get_file_tab_width(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:get_file_tab_width",&arg0)) 
      return NULL;
   result = (int)get_file_tab_width(arg0);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_get_file_use_spaces(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:get_file_use_spaces",&arg0)) 
      return NULL;
   result = (int)get_file_use_spaces(arg0);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_get_full_filename(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:get_full_filename",&arg0)) 
      return NULL;
   result = (char *)get_full_filename(arg0);
   resultobj = Py_BuildValue("s", result);
   g_free(result);
   return resultobj;
}

static PyObject *_wrap_get_filename(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:get_filename",&arg0)) 
      return NULL;
   result = (char *)get_filename(arg0);
   resultobj = Py_BuildValue("s", result);
   g_free(result);
   return resultobj;
}

static PyObject *_wrap_get_path(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:get_path",&arg0)) 
      return NULL;
   result = (char *)get_path(arg0);
   resultobj = Py_BuildValue("s", result);
   g_free(result);
   return resultobj;
}

static PyObject *_wrap_get_file(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:get_file",&arg0)) 
      return NULL;
   result = (char *)get_file(arg0);
   resultobj = Py_BuildValue("s", result);
   g_free(result);
   return resultobj;
}

static PyObject *_wrap_get_file_compile_string(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:get_file_compile_string",&arg0)) 
      return NULL;
   result = (char *)get_file_compile_string(arg0);
   resultobj = Py_BuildValue("s", result);
   g_free(result);
   return resultobj;
}

static PyObject *_wrap_get_file_debug_string(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:get_file_debug_string",&arg0)) 
      return NULL;
   result = (char *)get_file_debug_string(arg0);
   resultobj = Py_BuildValue("s", result);
   g_free(result);
   return resultobj;
}

static PyObject *_wrap_get_file_execute_string(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:get_file_execute_string",&arg0)) 
      return NULL;
   result = (char *)get_file_execute_string(arg0);
   resultobj = Py_BuildValue("s", result);
   g_free(result);
   return resultobj;
}

static PyObject *_wrap_set_file_done_compiling(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:set_file_done_compiling",&arg0)) 
      return NULL;
   set_file_done_compiling(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_set_file_done_debugging(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:set_file_done_debugging",&arg0)) 
      return NULL;
   set_file_done_debugging(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_set_file_done_executing(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:set_file_done_executing",&arg0)) 
      return NULL;
   set_file_done_executing(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_has_selection(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;

   self = self;
   if(!PyArg_ParseTuple(args,":has_selection")) 
      return NULL;
   result = (int)has_selection();
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_selection_start(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;

   self = self;
   if(!PyArg_ParseTuple(args,":selection_start")) 
      return NULL;
   result = (int)selection_start();
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_selection_end(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;

   self = self;
   if(!PyArg_ParseTuple(args,":selection_end")) 
      return NULL;
   result = (int)selection_end();
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_move(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:move",&arg0)) 
      return NULL;
   move(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_move_to(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:move_to",&arg0)) 
      return NULL;
   move_to(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_current_position(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;

   self = self;
   if(!PyArg_ParseTuple(args,":current_position")) 
      return NULL;
   result = (int)current_position();
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_buffer_size(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;

   self = self;
   if(!PyArg_ParseTuple(args,":buffer_size")) 
      return NULL;
   result = (int)buffer_size();
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_insert_in(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;
   int  arg1;
   char * arg2;

   self = self;
   if(!PyArg_ParseTuple(args,"iis:insert_in",&arg0,&arg1,&arg2)) 
      return NULL;
   insert_in(arg0,arg1,arg2);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_insert(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char * arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"s:insert",&arg0)) 
      return NULL;
   insert(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_move_to_line(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:move_to_line",&arg0)) 
      return NULL;
   move_to_line(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_move_lines(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:move_lines",&arg0)) 
      return NULL;
   move_lines(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_current_line(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;

   self = self;
   if(!PyArg_ParseTuple(args,":current_line")) 
      return NULL;
   result = (int)current_line();
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_line_start(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;

   self = self;
   if(!PyArg_ParseTuple(args,":line_start")) 
      return NULL;
   result = (int)line_start();
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}
static PyObject *_wrap_line_end(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;

   self = self;
   if(!PyArg_ParseTuple(args,":line_end")) 
      return NULL;
   result = (int)line_end();
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}
static PyObject *_wrap_freeze(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;

   self = self;
   if(!PyArg_ParseTuple(args,":freeze")) 
      return NULL;
   result = (int)freeze();
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_thaw(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;

   self = self;
   if(!PyArg_ParseTuple(args,":thaw")) 
      return NULL;
   result = (int)thaw();
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_line_by_pos(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:line_by_pos",&arg0)) 
      return NULL;
   result = (int)line_by_pos(arg0);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_move_to_col(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:move_to_col",&arg0)) 
      return NULL;
   move_to_col(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_get_text(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *result;
   int  arg0;
   int  arg1;

   self = self;
   if(!PyArg_ParseTuple(args,"ii:get_text",&arg0,&arg1)) 
      return NULL;
   result = (char *)get_text(arg0,arg1);
   resultobj = Py_BuildValue("s", result);
   g_free(result);
   return resultobj;
}

static PyObject *_wrap_get_current_char(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char  result;

   self = self;
   if(!PyArg_ParseTuple(args,":get_current_char")) 
      return NULL;
   result = (char )get_current_char();
   resultobj = Py_BuildValue("c",result);
   return resultobj;
}

static PyObject *_wrap_get_next_char(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char  result;

   self = self;
   if(!PyArg_ParseTuple(args,":get_next_char")) 
      return NULL;
   result = (char )get_next_char();
   resultobj = Py_BuildValue("c",result);
   return resultobj;
}

static PyObject *_wrap_delete_text(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;
   int  arg1;

   self = self;
   if(!PyArg_ParseTuple(args,"ii:delete_text",&arg0,&arg1)) 
      return NULL;
   delete_text(arg0,arg1);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_delete_text_in(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;
   int  arg1;
   int  arg2;

   self = self;
   if(!PyArg_ParseTuple(args,"iii:delete_text_in",&arg0,&arg1,&arg2)) 
      return NULL;
   delete_text_in(arg0,arg1,arg2);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_forward_delete(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:forward_delete",&arg0)) 
      return NULL;
   forward_delete(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_backward_delete(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:backward_delete",&arg0)) 
      return NULL;
   backward_delete(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_undo(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":undo")) 
      return NULL;
   undo();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_undo_last(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:undo_last",&arg0)) 
      return NULL;
   undo_last(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_redo(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":redo")) 
      return NULL;
   redo();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_redo_last(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:redo_last",&arg0)) 
      return NULL;
   redo_last(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_cut(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":cut")) 
      return NULL;
   cut();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_cut_text(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:cut_text",&arg0)) 
      return NULL;
   cut_text(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_copy(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":copy")) 
      return NULL;
   copy();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_copy_text(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:copy_text",&arg0)) 
      return NULL;
   copy_text(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_paste(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":paste")) 
      return NULL;
   paste();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_paste_text(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:paste_text",&arg0)) 
      return NULL;
   paste_text(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_clear(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":clear")) 
      return NULL;
   clear();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_clear_text(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:clear_text",&arg0)) 
      return NULL;
   clear_text(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_clear_entry(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":clear_entry")) 
      return NULL;
   clear_entry();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_select_area(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;
   int  arg1;

   self = self;
   if(!PyArg_ParseTuple(args,"ii:select_area",&arg0,&arg1)) 
      return NULL;
   select_area(arg0,arg1);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_select_text(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;
   int  arg1;
   int  arg2;

   self = self;
   if(!PyArg_ParseTuple(args,"iii:select_text",&arg0,&arg1,&arg2)) 
      return NULL;
   select_text(arg0,arg1,arg2);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_select_current(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":select_current")) 
      return NULL;
   select_current();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_select_all(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":select_all")) 
      return NULL;
   select_all();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_select_all_text(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:select_all_text",&arg0)) 
      return NULL;
   select_all_text(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_highlight_syntax(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:highlight_syntax",&arg0)) 
      return NULL;
   highlight_syntax(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_new_window(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":new_window")) 
      return NULL;
   new_window();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_new_file(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char * arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"s:new_file",&arg0)) 
      return NULL;
   new_file(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_open_file(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char * arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"s:open_file",&arg0)) 
      return NULL;
   open_file(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_close_file(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"i:close_file",&arg0)) 
      return NULL;
   close_file(arg0);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_save_all_files(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":save_all_files")) 
      return NULL;
   save_all_files();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_close_all_files(PyObject *self, PyObject *args)
{
   PyObject *resultobj;

   self = self;
   if(!PyArg_ParseTuple(args,":close_all_files")) 
      return NULL;
   close_all_files();
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_find(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   char * arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"s:find",&arg0)) 
      return NULL;
   result = (int)find(arg0);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_find_in(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   int  arg0;
   char * arg1;

   self = self;
   if(!PyArg_ParseTuple(args,"is:find_in",&arg0,&arg1)) 
      return NULL;
   result = (int)find_in(arg0,arg1);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_find_regex(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   char * arg0;

   self = self;
   if(!PyArg_ParseTuple(args,"s:find_regex",&arg0)) 
      return NULL;
   result = (int)find_regex(arg0);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_find_regex_in(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   int  arg0;
   char * arg1;

   self = self;
   if(!PyArg_ParseTuple(args,"is:find_regex_in",&arg0,&arg1)) 
      return NULL;
   result = (int)find_regex_in(arg0,arg1);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_replace(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   char * arg0;
   char * arg1;

   self = self;
   if(!PyArg_ParseTuple(args,"ss:replace",&arg0,&arg1)) 
      return NULL;
   result = (int)replace(arg0,arg1);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_replace_in(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   int  arg0;
   char * arg1;
   char * arg2;

   self = self;
   if(!PyArg_ParseTuple(args,"iss:replace_in",&arg0,&arg1,&arg2)) 
      return NULL;
   result = (int)replace_in(arg0,arg1,arg2);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_replace_all(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   char * arg0;
   char * arg1;

   self = self;
   if(!PyArg_ParseTuple(args,"ss:replace_all",&arg0,&arg1)) 
      return NULL;
   result = (int)replace_all(arg0,arg1);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_replace_all_in(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   int  result;
   int  arg0;
   char * arg1;
   char * arg2;

   self = self;
   if(!PyArg_ParseTuple(args,"iss:replace_all_in",&arg0,&arg1,&arg2)) 
      return NULL;
   result = (int)replace_all_in(arg0,arg1,arg2);
   resultobj = Py_BuildValue("i",result);
   return resultobj;
}

static PyObject *_wrap_add_syntax_entry(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *arg0;
   char *arg1;
   char *arg2;
   char *arg3;
   char *arg4;

   self = self;
   if(!PyArg_ParseTuple(args,"sssss:add_syntax_entry",&arg0,&arg1,&arg2,&arg3,&arg4)) 
      return NULL;
   add_syntax_entry(arg0,arg1,arg2,arg3,arg4);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_add_pattern_entry(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *arg0;
   char *arg1;
   char *arg2;
   char *arg3;

   self = self;
   if(!PyArg_ParseTuple(args,"ssss:add_pattern_entry",&arg0,&arg1,&arg2,&arg3)) 
      return NULL;
   add_pattern_entry(arg0,arg1,arg2,arg3);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *_wrap_add_embedded_entry(PyObject *self, PyObject *args)
{
   PyObject *resultobj;
   char *arg0;
   char *arg1;
   char *arg2;
   char *arg3;
   char *arg4;
   char *arg5;

   self = self;
   if(!PyArg_ParseTuple(args,"ssssss:add_embedded_entry",&arg0,&arg1,&arg2,&arg3,&arg4,&arg5)) 
      return NULL;
   add_embedded_entry(arg0,arg1,arg2,arg3,arg4,arg5);
   Py_INCREF(Py_None);
   resultobj = Py_None;
   return resultobj;
}

static PyObject *add_item_to_menu(PyObject* self, PyObject* args)
{
   PyObject *callback;
   GtkWidget *menu_item;
   char *path;
   char *label;
   char *hint;
   char *keys;
   int position;
   gchar *str;
   GList *ptr = NULL;
   gboolean separator;
   GnomeUIInfo new_menu[] =
   {
      GNOMEUIINFO_END,
      GNOMEUIINFO_END
   };
   if(!PyArg_ParseTuple(args, "ssssiO", &path, &label, &hint, &keys, &position, &callback))
      return NULL;
   separator = label && strlen(label) ? FALSE : TRUE;
   if(!separator && !PyCallable_Check(callback))
   {
      PyErr_SetString(PyExc_TypeError, "add_item_to_menu argument must be callable");
      return NULL;
   }
   if(!separator) Py_INCREF(callback);
	new_menu[0].type = separator ? GNOME_APP_UI_SEPARATOR : GNOME_APP_UI_ITEM;
	new_menu[0].label = label;
	new_menu[0].hint = hint;
	new_menu[0].moreinfo = (gpointer)call_python_function_cb;
	new_menu[0].user_data = (gpointer)callback;
	new_menu[0].unused_data = NULL;
	new_menu[0].pixmap_type = GNOME_APP_PIXMAP_NONE;
	new_menu[0].pixmap_info = NULL;
   if (keys && strlen(keys))
   {
      gtk_accelerator_parse(keys, &new_menu[0].accelerator_key, &new_menu[0].ac_mods);
   }
   else
   {
      new_menu[0].accelerator_key = 0;
      new_menu[0].ac_mods = (GdkModifierType) 0;
   }
	new_menu[0].widget = NULL;

   gnome_app_insert_menus(GNOME_APP(app), path, &new_menu[0]);
   menu_item = new_menu[0].widget;
   gtk_menu_reorder_child(GTK_MENU(menu_item->parent), menu_item, position);
   gtk_signal_connect(GTK_OBJECT(menu_item), "destroy", GTK_SIGNAL_FUNC(remove_pyref), (gpointer)callback);
   if((str = strstr(path, "Scripts")) && str == path)
   {
      dynamic_scripts = g_list_append(dynamic_scripts, (gpointer)menu_item);
   }
   else
   {
      if(parse_table)
      {
         parse_table->menu_entries = g_list_append(parse_table->menu_entries, (gpointer)menu_item);
         ptr = g_list_nth(parse_table->menu_entries, g_list_index(parse_table->menu_entries, (gpointer)menu_item));
      }
      else
      {
         static_entries = g_list_append(static_entries, (gpointer)menu_item);
         ptr = g_list_nth(static_entries, g_list_index(static_entries, (gpointer)menu_item));
      }
   }
   if(ptr) gtk_signal_connect(GTK_OBJECT(menu_item), "destroy", GTK_SIGNAL_FUNC(kill_widget_ptr), &ptr->data);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject *add_sub_to_menu(PyObject* self,PyObject* args)
{
   GtkWidget *menu_item = NULL;
   GtkWidget *submenu = NULL;
   char *path;
   char* label;
   int position;
   gchar *str;
   GList *ptr = NULL;

   GnomeUIInfo new_menu[] =
   {
      GNOMEUIINFO_END,
      GNOMEUIINFO_END
   };
   GnomeUIInfo sub_menu[] =
   {
      GNOMEUIINFO_SEPARATOR,
      GNOMEUIINFO_END
   };

   if(!PyArg_ParseTuple(args, "ssi", &path, &label, &position))
      return NULL;
	new_menu[0].type = GNOME_APP_UI_SUBTREE;
	new_menu[0].label = label;
	new_menu[0].hint = "";
	new_menu[0].moreinfo = (gpointer)sub_menu;
	new_menu[0].user_data = NULL;
	new_menu[0].unused_data = NULL;
	new_menu[0].pixmap_type = GNOME_APP_PIXMAP_NONE;
	new_menu[0].pixmap_info = NULL;
   new_menu[0].accelerator_key = 0;
   new_menu[0].ac_mods = (GdkModifierType) 0;
	new_menu[0].widget = NULL;

   gnome_app_insert_menus(GNOME_APP(app), path, &new_menu[0]);
   menu_item = new_menu[0].widget;
   if(sub_menu[0].widget) submenu = sub_menu[0].widget->parent;
   gtk_menu_reorder_child(GTK_MENU(menu_item->parent), menu_item, position);
   
   if((str = strstr(path, "Scripts")) && str == path)
   {
      dynamic_scripts = g_list_append(dynamic_scripts, (gpointer)menu_item);
      dynamic_scripts = g_list_append(dynamic_scripts, (gpointer)submenu);
   }
   else
   {
      if(parse_table)
      {
         parse_table->menu_entries = g_list_append(parse_table->menu_entries, (gpointer)menu_item);
         ptr = g_list_nth(parse_table->menu_entries, g_list_index(parse_table->menu_entries, (gpointer)menu_item));
         if(ptr) gtk_signal_connect(GTK_OBJECT(menu_item), "destroy", GTK_SIGNAL_FUNC(kill_widget_ptr), &ptr->data);
         parse_table->menu_entries = g_list_append(parse_table->menu_entries, (gpointer)submenu);
         ptr = g_list_nth(parse_table->menu_entries, g_list_index(parse_table->menu_entries, (gpointer)submenu));
         if(ptr) gtk_signal_connect(GTK_OBJECT(menu_item), "destroy", GTK_SIGNAL_FUNC(kill_widget_ptr), &ptr->data);
      }
      else
      {
         static_entries = g_list_append(static_entries, (gpointer)menu_item);
         ptr = g_list_nth(static_entries, g_list_index(static_entries, (gpointer)menu_item));
         if(ptr) gtk_signal_connect(GTK_OBJECT(menu_item), "destroy", GTK_SIGNAL_FUNC(kill_widget_ptr), &ptr->data);
         static_entries = g_list_append(static_entries, (gpointer)submenu);
         ptr = g_list_nth(static_entries, g_list_index(static_entries, (gpointer)submenu));
         if(ptr) gtk_signal_connect(GTK_OBJECT(menu_item), "destroy", GTK_SIGNAL_FUNC(kill_widget_ptr), &ptr->data);
      }
      if((str = strstr(path, "Build")) && str == path && parsing_language)
         dynamic_build = g_list_append(dynamic_build, (gpointer)menu_item);
   }
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject *add_widget_to_menu(PyObject* self, PyObject* args)
{
   PyObject *item;
   GtkObject *obj;
   GtkWidget *parent;
   GtkWidget *menu_item;
   char *path;
   gint pos = 0;
   if(!PyArg_ParseTuple(args, "sO", &path, &item))
      return NULL;
   if(!item) return NULL;
   if(!PyGtk_Check(item))
   {
      g_print("add_widget_to_menu: Second argument must be a GtkObject!\n");
   }
   else
   {
      obj = PyGtk_Get(item);
      if(!GTK_IS_WIDGET(obj)) return NULL;
      menu_item = GTK_WIDGET(obj);
      parent = gnome_app_find_menu_pos(GNOME_APP(app)->menubar, path, &pos);
      if(parent) gtk_menu_shell_insert(GTK_MENU_SHELL(parent), menu_item, pos);
   }
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject *add_item_to_popup_menu(PyObject* self, PyObject* args)
{
   PyObject *callback;
   GtkWidget *menu_item;
   char* label;
   int position;
   GtkWidget *parent;
   GList *ptr;
   if(!PyArg_ParseTuple(args, "siO", &label, &position, &callback))
    return NULL;
   if(!PyCallable_Check(callback))
   {
     PyErr_SetString(PyExc_TypeError, "add_item_to_popup argument must be callable");
     return NULL;
   }
   Py_INCREF(callback); /* possible referennce leak */
   menu_item = gtk_menu_item_new_with_label(label);
   if(parse_table)
     parent = (GtkWidget *)g_list_nth_data(parse_table->menu_entries, position);
   else
     parent = (GtkWidget *)g_list_nth_data(static_entries, position);
   if(!parent || !GTK_IS_MENU(parent))
   {
     parent = edit_popup_menu;
     if(parsing_language)
       edit_entries = g_list_append(edit_entries, (gpointer)menu_item);
   }
   gtk_menu_append(GTK_MENU(parent), menu_item);
   gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(call_python_function_cb), (gpointer)callback);
   gtk_signal_connect(GTK_OBJECT(menu_item), "destroy", GTK_SIGNAL_FUNC(remove_pyref), (gpointer)callback);
   if(parse_table)
   {
     parse_table->menu_entries = g_list_append(parse_table->menu_entries, (gpointer)menu_item);
     ptr = g_list_nth(parse_table->menu_entries, g_list_index(parse_table->menu_entries, (gpointer)menu_item));
   }
   else
   {
     static_entries = g_list_append(static_entries, (gpointer)menu_item);
     ptr = g_list_nth(static_entries, g_list_index(static_entries, (gpointer)menu_item));
   }
   gtk_signal_connect(GTK_OBJECT(menu_item), "destroy", GTK_SIGNAL_FUNC(kill_widget_ptr), &ptr->data);
   gtk_widget_show(menu_item);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject *add_sub_to_popup_menu(PyObject* self, PyObject* args)
{
   PyObject *result;
   GtkWidget *menu_item;
   GtkWidget *submenu;
   char* label;
   int position = -1;
   GtkWidget *parent;
   GList *ptr;
   if(!PyArg_ParseTuple(args, "si", &label, &position))
     return NULL;
   menu_item = gtk_menu_item_new_with_label(label);
   if(parse_table)
   {
     parse_table->menu_entries = g_list_append(parse_table->menu_entries, (gpointer)menu_item);
     ptr = g_list_nth(parse_table->menu_entries, g_list_index(parse_table->menu_entries, (gpointer)menu_item));
   }
   else
   {
     static_entries = g_list_append(static_entries, (gpointer)menu_item);
     ptr = g_list_nth(static_entries, g_list_index(static_entries, (gpointer)menu_item));
   }
   gtk_signal_connect(GTK_OBJECT(menu_item), "destroy", GTK_SIGNAL_FUNC(kill_widget_ptr), &ptr->data);
   gtk_widget_show(menu_item);
   if(parse_table)
     parent = (GtkWidget *)g_list_nth_data(parse_table->menu_entries, position);
   else
     parent = (GtkWidget *)g_list_nth_data(static_entries, position);
   if(!parent || !GTK_IS_MENU(parent))
   {
     parent = edit_popup_menu;
     if(parsing_language)
       edit_entries = g_list_append(edit_entries, (gpointer)menu_item);
   }
   gtk_menu_append(GTK_MENU(parent), menu_item);
   submenu = gtk_menu_new();
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), submenu);   
   if(parse_table)
   {
     parse_table->menu_entries = g_list_append(parse_table->menu_entries, (gpointer)submenu);
     position = g_list_index(parse_table->menu_entries, (gpointer)submenu);
     ptr = g_list_nth(parse_table->menu_entries, position);
   }
   else
   {
     static_entries = g_list_append(static_entries, (gpointer)submenu);
     position = g_list_index(static_entries, (gpointer)submenu);
     ptr = g_list_nth(static_entries, position);
   }
   gtk_signal_connect(GTK_OBJECT(submenu), "destroy", GTK_SIGNAL_FUNC(kill_widget_ptr), &ptr->data);
   gtk_widget_show(submenu);
   result = Py_BuildValue("i", position);
   return result;
}

static PyObject *register_signal_hook(PyObject* self, PyObject* args)
{
   PyObject *callback;
   gchar *name;
   gboolean matched = FALSE;

   if(!PyArg_ParseTuple(args, "sO", &name, &callback))
      return NULL;
   if(!PyCallable_Check(callback))
   {
      PyErr_SetString(PyExc_TypeError, "arg2 of register_signal_hook must be callable");
      return NULL;
   }
   if(parse_table)
   {
      if(!strcmp("table-add", name))
      {
         parse_table->table_add_callback = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("table-remove", name))
      {
         parse_table->table_remove_callback = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("table-destroy", name))
      {
         parse_table->table_destroy_callback = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("focus-in", name))
      {
         parse_table->file_focus_callback = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("focus-out", name))
      {
         parse_table->file_unfocus_callback = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("enter-pressed", name))
      {
         parse_table->enter_pressed_callback = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("tab-pressed", name))
      {
         parse_table->tab_pressed_callback = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("anti-tab-pressed", name))
      {
         parse_table->anti_tab_pressed_callback = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("compile", name))
      {
         parse_table->compile_hook = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("stop-compile", name) && parse_table->compile_hook)
      {
         parse_table->stop_compile_hook = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("debug", name))
      {
         parse_table->debug_hook = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("stop-debug", name) && parse_table->debug_hook)
      {
         parse_table->stop_debug_hook = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("execute", name))
      {
         parse_table->execute_hook = (gpointer)callback;
         matched = TRUE;
      }
      else if(!strcmp("stop-execute", name) && parse_table->execute_hook)
      {
         parse_table->stop_execute_hook = (gpointer)callback;
         matched = TRUE;
      }
      /* App callbacks */
      else if(!strcmp("open-file", name))
      {
         open_signals = g_list_append(open_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("revert-file", name))
      {
         revert_signals = g_list_append(revert_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("save-file", name))
      {
         save_signals = g_list_append(save_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("save-as-file", name))
      {
         save_as_signals = g_list_append(save_as_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("close-file", name))
      {
         close_signals = g_list_append(close_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("change-file", name))
      {
         change_signals = g_list_append(change_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("move-left", name))
      {
         move_left_signals = g_list_append(move_left_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("move-right", name))
      {
         move_right_signals = g_list_append(move_right_signals, (gpointer)callback);
         matched = TRUE;
      }
      if(matched) parse_table->hooks = g_list_append(parse_table->hooks, (gpointer)callback);
   }
   else
   {
      if(!strcmp("open-file", name))
      {
         open_signals = g_list_append(open_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("revert-file", name))
      {
         revert_signals = g_list_append(revert_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("save-file", name))
      {
         save_signals = g_list_append(save_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("save-as-file", name))
      {
         save_as_signals = g_list_append(save_as_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("close-file", name))
      {
         close_signals = g_list_append(close_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("change-file", name))
      {
         change_signals = g_list_append(change_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("move-left", name))
      {
         move_left_signals = g_list_append(move_left_signals, (gpointer)callback);
         matched = TRUE;
      }
      else if(!strcmp("move-right", name))
      {
         move_right_signals = g_list_append(move_right_signals, (gpointer)callback);
         matched = TRUE;
      }
   }
   if(!matched)
   {
      g_warning("Signal (%s) does not exist!\n", name);
   }
   else
   {
      Py_INCREF(callback);
   }
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject *add_custom_toolbar_entry(PyObject* self, PyObject* args)
{
   PyObject *callback;
   GtkWidget *toolbar;
   GtkWidget *item;
   GtkWidget *pixmapwid = NULL;
   gchar *label;
   gchar *pixmap;
   gint number;
   gint type;
   if(!PyArg_ParseTuple(args, "sisiO:add_item_to_custombar", &label, &number, &pixmap, &type, &callback))
     return NULL;
   if(!PyCallable_Check(callback))
   {
     PyErr_SetString(PyExc_TypeError, "callback argument must be callable");
     return NULL;
   }
   toolbar = (GtkWidget *)g_list_nth_data(custombars, number);
   if(!toolbar) toolbar = custombar;
   if(type == 0)
      pixmapwid = gnome_stock_pixmap_widget_at_size(window, pixmap, 21, 21);
   else if(type == 1)
      pixmapwid = gnome_pixmap_new_from_file_at_size(pixmap, 21, 21);
   if(pixmapwid)
   {
      Py_INCREF(callback);
      item = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), 0, label, 0, pixmapwid, GTK_SIGNAL_FUNC(call_python_function_cb), (gpointer)callback);
      gtk_signal_connect(GTK_OBJECT(item), "destroy", GTK_SIGNAL_FUNC(remove_pyref), (gpointer)callback);
      if(parse_table) parse_table->toolbar_entries = g_list_append(parse_table->toolbar_entries, (gpointer)item);
      Py_INCREF(Py_None);
      return Py_None;
   }
   return NULL;
}

static PyObject *append_custom_toolbar_page(PyObject* self, PyObject* args)
{
   PyObject *result;
   GtkWidget *toolbar;
   GtkWidget *label;
   gchar *string;
   gint page;

   if(!PyArg_ParseTuple(args, "s", &string))
    return NULL;

   label = gtk_label_new(string);
   toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
   gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar), GTK_RELIEF_NONE);
   gtk_container_set_border_width(GTK_CONTAINER(toolbar), 2);
   gtk_widget_show(toolbar);
   custombars = g_list_append(custombars, (gpointer)toolbar);
   page = g_list_index(custombars, (gpointer)toolbar);
   gtk_notebook_append_page(GTK_NOTEBOOK(customnotebook), toolbar, label);
   gtk_widget_show(customnotebook);
   result = Py_BuildValue("i", page);
   return result;
}

static PyObject *add_dock_item(PyObject* self, PyObject* args)
{
   PyObject *w;
   GtkObject *obj;
   GtkWidget *widget;
   gchar *name;
   GnomeDockPlacement placement;
   gint band_num;
   gint band_position;
   gint offset;
   GtkWidget *dock;

   if(!PyArg_ParseTuple(args, "Osiiii:add_dock_item", &w, &name, &placement, &band_num, &band_position, &offset))
     return NULL;
   if(!w) return NULL;
   obj = PyGtk_Get(w);
   if(!GTK_IS_WIDGET(obj)) return NULL;
   widget = GTK_WIDGET(obj);
   dock = gnome_dock_item_new(name, GNOME_DOCK_ITEM_BEH_NORMAL);
   gtk_container_set_border_width(GTK_CONTAINER(dock), 2);
   gtk_container_add(GTK_CONTAINER(dock), widget);
   gtk_widget_show(dock);
   gnome_dock_add_item(GNOME_DOCK(GNOME_APP(app)->dock),
                  GNOME_DOCK_ITEM(dock),
                  placement, band_num,
                  band_position, offset, FALSE);
   gtk_signal_connect_object(GTK_OBJECT(widget), "hide", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(dock));
   gtk_signal_connect_object(GTK_OBJECT(widget), "show", GTK_SIGNAL_FUNC(gtk_widget_show), GTK_OBJECT(dock));
   gtk_signal_connect_object(GTK_OBJECT(widget), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dock));
   gtk_signal_connect_object(GTK_OBJECT(dock), "hide", GTK_SIGNAL_FUNC(gtk_widget_queue_resize), GTK_OBJECT(window));
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject *get_gnome_app(PyObject* self, PyObject* args)
{
   PyObject *pyapp = NULL;
   GtkObject *obj = NULL;

   if(!PyArg_ParseTuple(args, ":get_gnome_app"))
      return NULL;
   obj = GTK_OBJECT(app);
   pyapp = PyGtk_New(obj);
   return(pyapp);
}

static PyObject *get_file_box(PyObject* self, PyObject* args)
{
   PyObject *pyobj = NULL;
   GdsFile *file = NULL;
   GtkObject *obj = NULL;
   int file_no = -1;

   if(!PyArg_ParseTuple(args, "i:get_file_box", &file_no))
      return NULL;
   Py_INCREF(Py_None);
   file = (GdsFile *)g_list_nth_data(files_list, file_no);
   g_return_val_if_fail(file != NULL, Py_None);
   g_return_val_if_fail(GDS_IS_FILE(file), Py_None);
   Py_DECREF(Py_None);
   obj = GTK_OBJECT(file->script_box);
   pyobj = PyGtk_New(obj);
   return(pyobj);
}

static PyObject *get_text_widget(PyObject* self, PyObject* args)
{
   PyObject *pyobj = NULL;
   GdsFile *file = NULL;
   GtkObject *obj = NULL;
   int file_no = -1;

   if(!PyArg_ParseTuple(args, "i:get_text_widget", &file_no))
      return NULL;
   Py_INCREF(Py_None);
   file = (GdsFile *)g_list_nth_data(files_list, file_no);
   g_return_val_if_fail(file != NULL, Py_None);
   g_return_val_if_fail(GDS_IS_FILE(file), Py_None);
   Py_DECREF(Py_None);
   obj = GTK_OBJECT(file->text);
   pyobj = PyGtk_New(obj);
   return(pyobj);
}

static PyObject *add_paned_object(PyObject* self, PyObject* args)
{
   PyObject *pyobj;
   PyObject *w;
   GtkObject *obj;
   GtkWidget *widget;
   GtkPaned *paned;
   int pos = -1;

   if(!PyArg_ParseTuple(args, "Oi:add_paned_object", &w, &pos))
      return NULL;
   if(!w) return NULL;
   obj = PyGtk_Get(w);
   if(!GTK_IS_WIDGET(obj)) return NULL;
   widget = GTK_WIDGET(obj);

   switch(pos)
   {
      case 0:
         gtk_paned_add1(GTK_PANED(hpaned1), widget);
         paned = GTK_PANED(hpaned1);
         obj = GTK_OBJECT(hpaned1);
         break;
      case 1:
         gtk_paned_add1(GTK_PANED(vpaned2), widget);
         paned = GTK_PANED(vpaned2);
         obj = GTK_OBJECT(vpaned2);
         break;
      case 2:
         gtk_paned_add2(GTK_PANED(hpaned3), widget);
         paned = GTK_PANED(hpaned3);
         obj = GTK_OBJECT(hpaned3);
         break;
      default:
         gtk_paned_add2(GTK_PANED(vpaned4), widget);
         paned = GTK_PANED(vpaned4);
         obj = GTK_OBJECT(vpaned4);
         break;
   }
   gtk_signal_connect(GTK_OBJECT(widget), "hide", GTK_SIGNAL_FUNC(paned_child_hide), paned);
   gtk_signal_connect(GTK_OBJECT(widget), "show", GTK_SIGNAL_FUNC(paned_child_show), paned);
   gtk_paned_set_gutter_size(paned, 8);
   gtk_paned_set_handle_size(paned, 6);
   pyobj = PyGtk_New(obj);
   return(pyobj);
}

static void paned_child_hide(GtkWidget *widget, GtkPaned *paned)
{
   gtk_paned_set_gutter_size(paned, 0);
   gtk_paned_set_handle_size(paned, 0);
   gtk_paned_set_position(paned, 0);
}

static void paned_child_show(GtkWidget *widget, GtkPaned *paned)
{
   paned->position_set = 0;
   gtk_paned_set_gutter_size(paned, 8);
   gtk_paned_set_handle_size(paned, 6);
}

static PyObject *remove_paned_object(PyObject* self, PyObject* args)
{
   GtkObject *obj;
   GtkPaned *paned;
   int pos = -1;

   if(!PyArg_ParseTuple(args, "i:remove_paned_object", &pos))
      return NULL;

   switch(pos)
   {
      case 0:
         paned = GTK_PANED(hpaned1);
         obj = GTK_OBJECT(paned->child1);
         break;
      case 1:
         paned = GTK_PANED(vpaned2);
         obj = GTK_OBJECT(paned->child1);
         break;
      case 2:
         paned = GTK_PANED(hpaned3);
         obj = GTK_OBJECT(paned->child2);
         break;
      default:
         paned = GTK_PANED(vpaned4);
         obj = GTK_OBJECT(paned->child2);
         break;
   }
   gtk_container_remove(GTK_CONTAINER(paned), GTK_WIDGET(obj));
   gtk_paned_set_gutter_size(paned, 0);
   gtk_paned_set_handle_size(paned, 0);
   gtk_paned_set_position(paned, 0);
   paned->position_set = 0;
   Py_INCREF(Py_None);
   return(Py_None);
}

static PyObject *get_paned_object(PyObject* self, PyObject* args)
{
   PyObject *pyobj;
   GtkObject *obj;
   GtkPaned *paned;
   int pos = -1;

   if(!PyArg_ParseTuple(args, "i:get_paned_object", &pos))
      return NULL;

   switch(pos)
   {
      case 0:
         paned = GTK_PANED(hpaned1);
         obj = GTK_OBJECT(paned->child1);
         break;
      case 1:
         paned = GTK_PANED(vpaned2);
         obj = GTK_OBJECT(paned->child1);
         break;
      case 2:
         paned = GTK_PANED(hpaned3);
         obj = GTK_OBJECT(paned->child2);
         break;
      default:
         paned = GTK_PANED(vpaned4);
         obj = GTK_OBJECT(paned->child2);
         break;
   }
   pyobj = PyGtk_New(obj);
   return(pyobj);
}

static PyMethodDef glimmerMethods[] =
{
   { "get_paned_object", get_paned_object, 1 },
   { "remove_paned_object", remove_paned_object, 1 },
   { "add_paned_object", add_paned_object, 1 },
   { "get_text_widget", get_text_widget, 1 },
   { "get_file_box", get_file_box, 1 },
   { "get_gnome_app", get_gnome_app, 1 },
   { "add_dock_item", add_dock_item, 1 },
   { "add_custom_toolbar_entry", add_custom_toolbar_entry, 1 },
   { "append_custom_toolbar_page", append_custom_toolbar_page, 1 },
   { "register_signal_hook", register_signal_hook, 1 },
   { "add_item_to_popup_menu", add_item_to_popup_menu, 1 },
   { "add_sub_to_popup_menu", add_sub_to_popup_menu, 1 },
   { "add_widget_to_menu", add_widget_to_menu, 1 },
   { "add_item_to_menu", add_item_to_menu, 1 },
   { "add_sub_to_menu", add_sub_to_menu, 1 },
   { "add_embedded_entry", _wrap_add_embedded_entry, 1 },
   { "add_pattern_entry", _wrap_add_pattern_entry, 1 },
   { "add_syntax_entry", _wrap_add_syntax_entry, 1 },
   { "replace_all_in", _wrap_replace_all_in, 1 },
   { "replace_all", _wrap_replace_all, 1 },
   { "replace_in", _wrap_replace_in, 1 },
   { "replace", _wrap_replace, 1 },
   { "find_regex_in", _wrap_find_regex_in, 1 },
   { "find_regex", _wrap_find_regex, 1 },
   { "find_in", _wrap_find_in, 1 },
   { "find", _wrap_find, 1 },
   { "close_all_files", _wrap_close_all_files, 1 },
   { "save_all_files", _wrap_save_all_files, 1 },
   { "close_file", _wrap_close_file, 1 },
   { "open_file", _wrap_open_file, 1 },
   { "new_file", _wrap_new_file, 1 },
   { "new_window", _wrap_new_window, 1 },
   { "highlight_syntax", _wrap_highlight_syntax, 1 },
   { "select_all_text", _wrap_select_all_text, 1 },
   { "select_all", _wrap_select_all, 1 },
   { "select_current", _wrap_select_current, 1 },
   { "select_text", _wrap_select_text, 1 },
   { "select_area", _wrap_select_area, 1 },
   { "clear_entry", _wrap_clear_entry, 1 },
   { "clear_text", _wrap_clear_text, 1 },
   { "clear", _wrap_clear, 1 },
   { "paste_text", _wrap_paste_text, 1 },
   { "paste", _wrap_paste, 1 },
   { "copy_text", _wrap_copy_text, 1 },
   { "copy", _wrap_copy, 1 },
   { "cut_text", _wrap_cut_text, 1 },
   { "cut", _wrap_cut, 1 },
   { "redo_last", _wrap_redo_last, 1 },
   { "redo", _wrap_redo, 1 },
   { "undo_last", _wrap_undo_last, 1 },
   { "undo", _wrap_undo, 1 },
   { "backward_delete", _wrap_backward_delete, 1 },
   { "forward_delete", _wrap_forward_delete, 1 },
   { "delete_text_in", _wrap_delete_text_in, 1 },
   { "delete_text", _wrap_delete_text, 1 },
   { "get_next_char", _wrap_get_next_char, 1 },
   { "get_current_char", _wrap_get_current_char, 1 },
   { "get_text", _wrap_get_text, 1 },
   { "current_line", _wrap_current_line, 1 },
   { "line_start", _wrap_line_start, 1 },
   { "line_end", _wrap_line_end, 1 },
   { "freeze", _wrap_freeze, 1 },
   { "thaw", _wrap_thaw, 1 },
   { "move_to_col", _wrap_move_to_col, 1 },
   { "line_by_pos", _wrap_line_by_pos, 1 },
   { "move_lines", _wrap_move_lines, 1 },
   { "move_to_line", _wrap_move_to_line, 1 },
   { "insert", _wrap_insert, 1 },
   { "insert_in", _wrap_insert_in, 1 },
   { "buffer_size", _wrap_buffer_size, 1 },
   { "current_position", _wrap_current_position, 1 },
   { "move_to", _wrap_move_to, 1 },
   { "move", _wrap_move, 1 },
   { "selection_end", _wrap_selection_end, 1 },
   { "selection_start", _wrap_selection_start, 1 },
   { "has_selection", _wrap_has_selection, 1 },
   { "set_file_done_executing", _wrap_set_file_done_executing, 1 },
   { "set_file_done_debugging", _wrap_set_file_done_debugging, 1 },
   { "set_file_done_compiling", _wrap_set_file_done_compiling, 1 },
   { "get_file_execute_string", _wrap_get_file_execute_string, 1 },
   { "get_file_debug_string", _wrap_get_file_debug_string, 1 },
   { "get_file_compile_string", _wrap_get_file_compile_string, 1 },
   { "get_file", _wrap_get_file, 1 },
   { "get_path", _wrap_get_path, 1 },
   { "get_filename", _wrap_get_filename, 1 },
   { "get_full_filename", _wrap_get_full_filename, 1 },
   { "get_file_tab_width", _wrap_get_file_tab_width, 1 },
   { "get_file_use_spaces", _wrap_get_file_use_spaces, 1 },
   { "get_file_changed", _wrap_get_file_changed, 1 },
   { "get_file_length", _wrap_get_file_length, 1 },
   { "get_tab_stops", _wrap_get_tab_stops, 1 },
   { "get_default_make_command", _wrap_get_default_make_command, 1 },
   { "get_default_term_command", _wrap_get_default_term_command, 1 },
   { "get_files", _wrap_get_files, 1 },
   { "change", _wrap_change, 1 },
   { "get_file_number", _wrap_get_file_number, 1 },
   { NULL, NULL }
};

void init_scripting(void)
{
   PyObject *m, *d;
   m = Py_InitModule("glimmer", glimmerMethods);
   d = PyModule_GetDict(m);
}
