/* GnomeSearchDialog
*
*  A gnome widget searching stuff
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#ifndef GNOME_SEARCH_DIALOG_H__
#define GNOME_SEARCH_DIALOG_H__
#ifdef __cplusplus
extern "C" {
#endif

#define GNOME_TYPE_SEARCH_DIALOG (gnome_search_dialog_get_type())
#define GNOME_SEARCH_DIALOG(obj) (GTK_CHECK_CAST ((obj), GNOME_TYPE_SEARCH_DIALOG, GnomeSearchDialog))
#define GNOME_SEARCH_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_SEARCH_DIALOG, GnomeSearchDialogClass))
#define GNOME_IS_SEARCH_DIALOG(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_SEARCH_DIALOG))
#define GNOME_IS_SEARCH_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_TYPE_SEARCH_DIALOG))

typedef struct _GnomeSearchDialog GnomeSearchDialog;
typedef struct _GnomeSearchDialogClass GnomeSearchDialogClass;

typedef enum {
   GNOME_SEARCH_STYLE_REGEX,
   GNOME_SEARCH_STYLE_NORM
}GnomeSearchStyle;

typedef enum {
   GNOME_SEARCH_START_CURRENT,
   GNOME_SEARCH_START_TOP
}GnomeSearchStart;

typedef enum {
   GNOME_SEARCH_FIND,
   GNOME_SEARCH_REPLACE
}GnomeSearchDialogType;

struct _GnomeSearchDialog {
   GtkWindow window;
   GtkWidget *find_combo;
   GtkWidget *replace_combo;
   GtkWidget *check_case_sensitive;
   GtkWidget *check_search_style;
   GtkWidget *check_search_start;
   GtkWidget *check_search_multi;
   GtkWidget *check_stay_open;
   GtkWidget *find_button;
   GtkWidget *replace_button;
   GtkWidget *replace_all;   
   GtkWidget *cancel_button;
   GnomeSearchDialogType dialog_type;
   GnomeSearchStyle search_style;   
   GnomeSearchStart search_start;
   GList *find_history;
   GList *replace_history;
   gboolean search_selection;
   guint startpos;
   guint endpos;
   gint max_entries;
};

struct _GnomeSearchDialogClass {
   GtkWindowClass parent_class;
};

GtkType gnome_search_dialog_get_type(void);

GtkWidget *gnome_search_dialog_new(GnomeSearchDialogType type);

void gnome_search_dialog_set_find_text(GnomeSearchDialog *sd, const gchar *text);
void gnome_search_dialog_set_replace_text(GnomeSearchDialog *sd, const gchar *text);

/*
 * These are used for a specific purpose in LATTE, namely that you can select
 * an area of text to search. This conflicts with another feature, being able to select
 * some text and have it be set in the find dialog entry, so we use the rule: 
 * if entry->selection->size < 64 (sounds like a long enough search string), then it 
 * will be put into the entry, else the start and end are set.
 */
void gnome_search_dialog_search_selection(GnomeSearchDialog *sd, gboolean tf);
void gnome_search_dialog_set_startpos(GnomeSearchDialog *sd, guint pos);
void gnome_search_dialog_set_endpos(GnomeSearchDialog *sd, guint pos);

gchar *gnome_search_dialog_get_find_text(GnomeSearchDialog *sd);
gchar *gnome_search_dialog_get_replace_text(GnomeSearchDialog *sd);

GnomeSearchDialogType gnome_search_dialog_get_dialog_type(GnomeSearchDialog *sd);
GnomeSearchStyle gnome_search_dialog_get_search_style(GnomeSearchDialog *sd);
GnomeSearchStart gnome_search_dialog_get_search_start(GnomeSearchDialog *sd);

gboolean gnome_search_dialog_case_sensitive(GnomeSearchDialog *sd);
gboolean gnome_search_dialog_keep_window_open(GnomeSearchDialog *sd);
void gnome_search_dialog_set_max_entries(GnomeSearchDialog *sd, gint entries);
void gnome_search_dialog_set_find_history(GnomeSearchDialog *sd, GList *history);
void gnome_search_dialog_set_replace_history(GnomeSearchDialog *sd, GList *history);

gboolean gnome_search_dialog_add_find_string(GnomeSearchDialog *sd, gchar *string);
gboolean gnome_search_dialog_add_replace_string(GnomeSearchDialog *sd, gchar *string);

#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif
