// -*- c++ -*-
// Generated by gmmproc 2.47.3.1 -- DO NOT MODIFY!
#ifndef _GIOMM_INETSOCKETADDRESS_H
#define _GIOMM_INETSOCKETADDRESS_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2009 jonathon jongsma
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/socketaddress.h>
#include <giomm/inetaddress.h>
#include <giomm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GInetSocketAddress GInetSocketAddress;
typedef struct _GInetSocketAddressClass GInetSocketAddressClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gio
{ class InetSocketAddress_Class; } // namespace Gio
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gio
{

/** Internet SocketAddress
 *
 * An IPv4 or IPv6 socket address; that is, the combination of a
 * InetAddress and a port number.
 *
 * An IPv4 or IPv6 socket address, corresponding to a struct sockaddr_in or
 * struct sockaddr_in6.
 *
 * @newin{2,24}
 * @ingroup NetworkIO
 */

class InetSocketAddress
: public SocketAddress
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef InetSocketAddress CppObjectType;
  typedef InetSocketAddress_Class CppClassType;
  typedef GInetSocketAddress BaseObjectType;
  typedef GInetSocketAddressClass BaseClassType;

  // noncopyable
  InetSocketAddress(const InetSocketAddress&) = delete;
  InetSocketAddress& operator=(const InetSocketAddress&) = delete;

private:  friend class InetSocketAddress_Class;
  static CppClassType inetsocketaddress_class_;

protected:
  explicit InetSocketAddress(const Glib::ConstructParams& construct_params);
  explicit InetSocketAddress(GInetSocketAddress* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  InetSocketAddress(InetSocketAddress&& src) noexcept;
  InetSocketAddress& operator=(InetSocketAddress&& src) noexcept;

  virtual ~InetSocketAddress() noexcept;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GInetSocketAddress*       gobj()       { return reinterpret_cast<GInetSocketAddress*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GInetSocketAddress* gobj() const { return reinterpret_cast<GInetSocketAddress*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GInetSocketAddress* gobj_copy();

private:


protected:
   explicit InetSocketAddress(const Glib::RefPtr<InetAddress>& address, guint16 port);


public:
 
  static Glib::RefPtr<InetSocketAddress> create(const Glib::RefPtr<InetAddress>& address, guint16 port);


  /** Gets @a address's InetAddress.
   * 
   * @newin{2,22}
   * 
   * @return The InetAddress for @a address, which must be
   * Glib::object_ref()'d if it will be stored.
   */
  Glib::RefPtr<InetAddress> get_address();
 
  /** Gets @a address's InetAddress.
   * 
   * @newin{2,22}
   * 
   * @return The InetAddress for @a address, which must be
   * Glib::object_ref()'d if it will be stored.
   */
  Glib::RefPtr<const InetAddress> get_address() const;

 
  /** Gets @a address's port.
   * 
   * @newin{2,22}
   * 
   * @return The port for @a address.
   */
  guint16 get_port() const;

 
  /** Gets the `sin6_flowinfo` field from @a address,
   * which must be an IPv6 address.
   * 
   * @newin{2,32}
   * 
   * @return The flowinfo field.
   */
  guint32 get_flowinfo() const;
 
  /** Gets the `sin6_scope_id` field from @a address,
   * which must be an IPv6 address.
   * 
   * @newin{2,32}
   * 
   * @return The scope id field.
   */
  guint32 get_scope_id() const;

 /** The address.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<InetAddress> > property_address() const;


 /** The port.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint16 > property_port() const;


 /** The `sin6_flowinfo` field, for IPv6 addresses.
   * 
   * @newin{2,32}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint32 > property_flowinfo() const;


 /** IPv6 scope ID.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint32 > property_scope_id() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::InetSocketAddress
   */
  Glib::RefPtr<Gio::InetSocketAddress> wrap(GInetSocketAddress* object, bool take_copy = false);
}


#endif /* _GIOMM_INETSOCKETADDRESS_H */

