// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_RESOLVER_H
#define _GIOMM_RESOLVER_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2009 jonathon jongsma
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/inetaddress.h>
#include <giomm/cancellable.h>
#include <giomm/srvtarget.h>
#include <giomm/asyncresult.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GResolver GResolver;
typedef struct _GResolverClass GResolverClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Resolver_Class; } // namespace Gio
namespace Gio
{

/** Asynchronous and cancellable DNS resolver
 *
 * Resolver provides cancellable synchronous and asynchronous DNS resolution,
 * for hostnames (lookup_by_address(), lookup_by_name() and their async
 * variants) and SRV (service) records (lookup_service()).
 *
 * NetworkAddress and NetworkService provide wrappers around Resolver
 * functionality that also implement SocketConnectable, making it easy to
 * connect to a remote host/service.
 *
 * @newin{2,24}
 * @ingroup NetworkIO
 */

class Resolver
: public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Resolver CppObjectType;
  typedef Resolver_Class CppClassType;
  typedef GResolver BaseObjectType;
  typedef GResolverClass BaseClassType;

private:  friend class Resolver_Class;
  static CppClassType resolver_class_;

private:
  // noncopyable
  Resolver(const Resolver&);
  Resolver& operator=(const Resolver&);

protected:
  explicit Resolver(const Glib::ConstructParams& construct_params);
  explicit Resolver(GResolver* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Resolver();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GResolver*       gobj()       { return reinterpret_cast<GResolver*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GResolver* gobj() const { return reinterpret_cast<GResolver*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GResolver* gobj_copy();

private:


protected:

public:
  static Glib::RefPtr<Resolver> get_default();
  
  static void set_default(const Glib::RefPtr<Resolver>& resolver);
  

  // g_resolver_free_addresses is just a C convenience function
  

  /** Synchronously resolves @a hostname to determine its associated IP
   * address(es). @a hostname may be an ASCII-only or UTF-8 hostname, or
   * the textual form of an IP address (in which case this just becomes
   * a wrapper around g_inet_address_new_from_string()).
   * 
   * On success, g_resolver_lookup_by_name() will return a List of
   * InetAddress, sorted in order of preference. (That is, you should
   * attempt to connect to the first address first, then the second if
   * the first fails, etc.)
   * 
   * If the DNS resolution fails, @a error (if non-<tt>0</tt>) will be set to a
   * value from ResolverError.
   * 
   * If @a cancellable is non-<tt>0</tt>, it can be used to cancel the
   * operation, in which case @a error (if non-<tt>0</tt>) will be set to
   * IO_ERROR_CANCELLED.
   * 
   * If you are planning to connect to a socket on the resolved IP
   * address, it may be easier to create a NetworkAddress and use its
   * SocketConnectable interface.
   * 
   * @newin{2,22}
   * @param hostname The hostname to look up.
   * @param cancellable A Cancellable, or <tt>0</tt>.
   * @return A List of InetAddress, or <tt>0</tt> on error. You
   * must unref each of the addresses and free the list when you are
   * done with it. (You can use g_resolver_free_addresses() to do this.).
   */
  Glib::ListHandle< Glib::RefPtr<InetAddress> > lookup_by_name(const Glib::ustring& hostname, const Glib::RefPtr<Cancellable>& cancellable);
  Glib::ListHandle< Glib::RefPtr<InetAddress> > lookup_by_name(const Glib::ustring& hostname);
  void lookup_by_name_async(const Glib::ustring& hostname, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable);
  void lookup_by_name_async(const Glib::ustring& hostname, const SlotAsyncReady& slot);
  
  
  /** Retrieves the result of a call to
   * g_resolver_lookup_by_name_async().
   * 
   * If the DNS resolution failed, @a error (if non-<tt>0</tt>) will be set to
   * a value from ResolverError. If the operation was cancelled,
   *  @a error will be set to IO_ERROR_CANCELLED.
   * 
   * @newin{2,22}
   * @param result The result passed to your AsyncReadyCallback.
   * @return A List of InetAddress, or <tt>0</tt> on error. See
   * g_resolver_lookup_by_name() for more details.
   */
  Glib::ListHandle< Glib::RefPtr<InetAddress> > lookup_by_name_finish(const Glib::RefPtr<AsyncResult>& result);

 
  /** Synchronously reverse-resolves @a address to determine its
   * associated hostname.
   * 
   * If the DNS resolution fails, @a error (if non-<tt>0</tt>) will be set to
   * a value from ResolverError.
   * 
   * If @a cancellable is non-<tt>0</tt>, it can be used to cancel the
   * operation, in which case @a error (if non-<tt>0</tt>) will be set to
   * IO_ERROR_CANCELLED.
   * 
   * @newin{2,22}
   * @param address The address to reverse-resolve.
   * @param cancellable A Cancellable, or <tt>0</tt>.
   * @return A hostname (either ASCII-only, or in ASCII-encoded
   * form), or <tt>0</tt> on error.
   */
  Glib::ustring lookup_by_address(const Glib::RefPtr<InetAddress>& address, const Glib::RefPtr<Cancellable>& cancellable);
  Glib::ustring lookup_by_address(const Glib::RefPtr<InetAddress>& address);
  void lookup_by_address_async(const Glib::RefPtr<InetAddress>& address, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable);
  void lookup_by_address_async(const Glib::RefPtr<InetAddress>& address, const SlotAsyncReady& slot);
  
  
  /** Retrieves the result of a previous call to
   * g_resolver_lookup_by_address_async().
   * 
   * If the DNS resolution failed, @a error (if non-<tt>0</tt>) will be set to
   * a value from ResolverError. If the operation was cancelled,
   *  @a error will be set to IO_ERROR_CANCELLED.
   * 
   * @newin{2,22}
   * @param result The result passed to your AsyncReadyCallback.
   * @return A hostname (either ASCII-only, or in ASCII-encoded
   * form), or <tt>0</tt> on error.
   */
  Glib::ustring lookup_by_address_finish(const Glib::RefPtr<AsyncResult>& result);

 
  /** Synchronously performs a DNS SRV lookup for the given @a service and
   *  @a protocol in the given @a domain and returns an array of SrvTarget.
   *  @a domain may be an ASCII-only or UTF-8 hostname. Note also that the
   *  @a service and @a protocol arguments <em>do not</em>
   * include the leading underscore that appears in the actual DNS
   * entry.
   * 
   * On success, g_resolver_lookup_service() will return a List of
   * SrvTarget, sorted in order of preference. (That is, you should
   * attempt to connect to the first target first, then the second if
   * the first fails, etc.)
   * 
   * If the DNS resolution fails, @a error (if non-<tt>0</tt>) will be set to
   * a value from ResolverError.
   * 
   * If @a cancellable is non-<tt>0</tt>, it can be used to cancel the
   * operation, in which case @a error (if non-<tt>0</tt>) will be set to
   * IO_ERROR_CANCELLED.
   * 
   * If you are planning to connect to the service, it is usually easier
   * to create a NetworkService and use its SocketConnectable
   * interface.
   * 
   * @newin{2,22}
   * @param service The service type to look up (eg, "ldap").
   * @param protocol The networking protocol to use for @a service (eg, "tcp").
   * @param domain The DNS domain to look up the service in.
   * @param cancellable A Cancellable, or <tt>0</tt>.
   * @return A List of SrvTarget, or <tt>0</tt> on error. You must
   * free each of the targets and the list when you are done with it.
   * (You can use g_resolver_free_targets() to do this.).
   */
  ListHandle_SrvTarget lookup_service(const Glib::ustring& service, const Glib::ustring& protocol, const Glib::ustring& domain, const Glib::RefPtr<Cancellable>& cancellable);
  ListHandle_SrvTarget lookup_service(const Glib::ustring& service, const Glib::ustring& protocol, const Glib::ustring& domain);
  void lookup_service_async(const Glib::ustring& service, const Glib::ustring& protocol, const Glib::ustring& domain, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable);
  void lookup_service_async(const Glib::ustring& service, const Glib::ustring& protocol, const Glib::ustring& domain, const SlotAsyncReady& slot);
  
  
  /** Retrieves the result of a previous call to
   * g_resolver_lookup_service_async().
   * 
   * If the DNS resolution failed, @a error (if non-<tt>0</tt>) will be set to
   * a value from ResolverError. If the operation was cancelled,
   *  @a error will be set to IO_ERROR_CANCELLED.
   * 
   * @newin{2,22}
   * @param result The result passed to your AsyncReadyCallback.
   * @return A List of SrvTarget, or <tt>0</tt> on error. See
   * g_resolver_lookup_service() for more details.
   */
  ListHandle_SrvTarget lookup_service_finish(const Glib::RefPtr<AsyncResult>& result);


  //TODO: Remove no_default_handler when we can break ABI:
  
  /**
   * @par Prototype:
   * <tt>void on_my_%reload()</tt>
   */

  Glib::SignalProxy0< void > signal_reload();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

std::string hostname_to_ascii (const Glib::ustring& hostname);
Glib::ustring hostname_to_unicode (const Glib::ustring& hostname);
bool hostname_is_non_ascii (const Glib::ustring& hostname);
bool hostname_is_ascii_encoded (const Glib::ustring& hostname);
bool hostname_is_ip_address (const Glib::ustring& hostname);

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Resolver
   */
  Glib::RefPtr<Gio::Resolver> wrap(GResolver* object, bool take_copy = false);
}


#endif /* _GIOMM_RESOLVER_H */

