// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/resolver.h>
#include <giomm/private/resolver_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2008 Jonathon Jongsma
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include "slot_async.h"

namespace Gio
{

Glib::RefPtr<Resolver> Resolver::get_default()
{
    return Glib::wrap(g_resolver_get_default());
}

void Resolver::set_default(const Glib::RefPtr<Resolver>& resolver)
{
    g_resolver_set_default(Glib::unwrap(resolver));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ListHandle< Glib::RefPtr<InetAddress> > Resolver::lookup_by_name(const Glib::ustring& hostname)
#else
Glib::ListHandle< Glib::RefPtr<InetAddress> > Resolver::lookup_by_name(const Glib::ustring& hostname, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::ListHandle< Glib::RefPtr<InetAddress> > retvalue = Glib::ListHandle< Glib::RefPtr<InetAddress> >(g_resolver_lookup_by_name(gobj(), hostname.c_str(), 0, &(gerror)), Glib::OWNERSHIP_SHALLOW);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring Resolver::lookup_by_address(const Glib::RefPtr<InetAddress>& address)
#else
Glib::ustring Resolver::lookup_by_address(const Glib::RefPtr<InetAddress>& address, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::ustring retvalue = Glib::convert_return_gchar_ptr_to_ustring(g_resolver_lookup_by_address(gobj(), const_cast<GInetAddress*>(Glib::unwrap(address)), 0, &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
ListHandle_SrvTarget Resolver::lookup_service(const Glib::ustring& service, const Glib::ustring& protocol, const Glib::ustring& domain)
#else
ListHandle_SrvTarget Resolver::lookup_service(const Glib::ustring& service, const Glib::ustring& protocol, const Glib::ustring& domain, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  ListHandle_SrvTarget retvalue = ListHandle_SrvTarget(g_resolver_lookup_service(gobj(), service.c_str(), protocol.c_str(), domain.c_str(), 0, &(gerror)), Glib::OWNERSHIP_SHALLOW);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

void
Resolver::lookup_by_name_async(const Glib::ustring& hostname,
                               const SlotAsyncReady& slot,
                               const Glib::RefPtr<Cancellable>& cancellable)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_resolver_lookup_by_name_async (gobj(),
                                   hostname.c_str(),
                                   Glib::unwrap(cancellable),
                                   &SignalProxy_async_callback,
                                   slot_copy);
}

void
Resolver::lookup_by_name_async(const Glib::ustring& hostname,
                               const SlotAsyncReady& slot)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_resolver_lookup_by_name_async (gobj(),
                                   hostname.c_str(),
                                   0,
                                   &SignalProxy_async_callback,
                                   slot_copy);
}

void
Resolver::lookup_by_address_async(const Glib::RefPtr<InetAddress>& address,
                                  const SlotAsyncReady& slot,
                                  const Glib::RefPtr<Cancellable>& cancellable)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_resolver_lookup_by_address_async (gobj(),
                                      Glib::unwrap(address),
                                      Glib::unwrap(cancellable),
                                      &SignalProxy_async_callback,
                                      slot_copy);
}

void
Resolver::lookup_by_address_async(const Glib::RefPtr<InetAddress>& address,
                                  const SlotAsyncReady& slot)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_resolver_lookup_by_address_async (gobj(),
                                      Glib::unwrap(address),
                                      0,
                                      &SignalProxy_async_callback,
                                      slot_copy);
}

void
Resolver::lookup_service_async(const Glib::ustring& service,
                               const Glib::ustring& protocol,
                               const Glib::ustring& domain,
                               const SlotAsyncReady& slot,
                               const Glib::RefPtr<Cancellable>& cancellable)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_resolver_lookup_service_async (gobj(),
                                   service.c_str(),
                                   protocol.c_str(),
                                   domain.c_str(),
                                   Glib::unwrap(cancellable),
                                   &SignalProxy_async_callback,
                                   slot_copy);
}

void
Resolver::lookup_service_async(const Glib::ustring& service,
                               const Glib::ustring& protocol,
                               const Glib::ustring& domain,
                               const SlotAsyncReady& slot)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_resolver_lookup_service_async (gobj(),
                                   service.c_str(),
                                   protocol.c_str(),
                                   domain.c_str(),
                                   0,
                                   &SignalProxy_async_callback,
                                   slot_copy);
}

std::string
hostname_to_ascii (const Glib::ustring& hostname)
{
    return Glib::convert_return_gchar_ptr_to_stdstring
        (g_hostname_to_ascii (hostname.c_str ()));
}

Glib::ustring
hostname_to_unicode (const Glib::ustring& hostname)
{
    return Glib::convert_return_gchar_ptr_to_ustring
        (g_hostname_to_unicode (hostname.c_str ()));
}

bool
hostname_is_non_ascii (const Glib::ustring& hostname)
{
    return g_hostname_is_non_ascii (hostname.c_str ());
}

bool
hostname_is_ascii_encoded (const Glib::ustring& hostname)
{
    return g_hostname_is_ascii_encoded (hostname.c_str ());
}

bool
hostname_is_ip_address (const Glib::ustring& hostname)
{
    return g_hostname_is_ip_address (hostname.c_str ());
}

} //namespace Gio

namespace
{


static const Glib::SignalProxyInfo Resolver_signal_reload_info =
{
  "reload",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::Resolver> wrap(GResolver* object, bool take_copy)
{
  return Glib::RefPtr<Gio::Resolver>( dynamic_cast<Gio::Resolver*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& Resolver_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Resolver_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_resolver_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Resolver_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Resolver_Class::wrap_new(GObject* object)
{
  return new Resolver((GResolver*)object);
}


/* The implementation: */

GResolver* Resolver::gobj_copy()
{
  reference();
  return gobj();
}

Resolver::Resolver(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Resolver::Resolver(GResolver* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Resolver::~Resolver()
{}


Resolver::CppClassType Resolver::resolver_class_; // initialize static member

GType Resolver::get_type()
{
  return resolver_class_.init().get_type();
}


GType Resolver::get_base_type()
{
  return g_resolver_get_type();
}


#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ListHandle< Glib::RefPtr<InetAddress> > Resolver::lookup_by_name(const Glib::ustring& hostname, const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::ListHandle< Glib::RefPtr<InetAddress> > Resolver::lookup_by_name(const Glib::ustring& hostname, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::ListHandle< Glib::RefPtr<InetAddress> > retvalue = Glib::ListHandle< Glib::RefPtr<InetAddress> >(g_resolver_lookup_by_name(gobj(), hostname.c_str(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)), Glib::OWNERSHIP_SHALLOW);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ListHandle< Glib::RefPtr<InetAddress> > Resolver::lookup_by_name_finish(const Glib::RefPtr<AsyncResult>& result)
#else
Glib::ListHandle< Glib::RefPtr<InetAddress> > Resolver::lookup_by_name_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::ListHandle< Glib::RefPtr<InetAddress> > retvalue = Glib::ListHandle< Glib::RefPtr<InetAddress> >(g_resolver_lookup_by_name_finish(gobj(), Glib::unwrap(result), &(gerror)), Glib::OWNERSHIP_SHALLOW);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring Resolver::lookup_by_address(const Glib::RefPtr<InetAddress>& address, const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::ustring Resolver::lookup_by_address(const Glib::RefPtr<InetAddress>& address, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::ustring retvalue = Glib::convert_return_gchar_ptr_to_ustring(g_resolver_lookup_by_address(gobj(), const_cast<GInetAddress*>(Glib::unwrap(address)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring Resolver::lookup_by_address_finish(const Glib::RefPtr<AsyncResult>& result)
#else
Glib::ustring Resolver::lookup_by_address_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::ustring retvalue = Glib::convert_return_gchar_ptr_to_ustring(g_resolver_lookup_by_address_finish(gobj(), Glib::unwrap(result), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
ListHandle_SrvTarget Resolver::lookup_service(const Glib::ustring& service, const Glib::ustring& protocol, const Glib::ustring& domain, const Glib::RefPtr<Cancellable>& cancellable)
#else
ListHandle_SrvTarget Resolver::lookup_service(const Glib::ustring& service, const Glib::ustring& protocol, const Glib::ustring& domain, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  ListHandle_SrvTarget retvalue = ListHandle_SrvTarget(g_resolver_lookup_service(gobj(), service.c_str(), protocol.c_str(), domain.c_str(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)), Glib::OWNERSHIP_SHALLOW);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
ListHandle_SrvTarget Resolver::lookup_service_finish(const Glib::RefPtr<AsyncResult>& result)
#else
ListHandle_SrvTarget Resolver::lookup_service_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  ListHandle_SrvTarget retvalue = ListHandle_SrvTarget(g_resolver_lookup_service_finish(gobj(), Glib::unwrap(result), &(gerror)), Glib::OWNERSHIP_SHALLOW);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}


Glib::SignalProxy0< void > Resolver::signal_reload()
{
  return Glib::SignalProxy0< void >(this, &Resolver_signal_reload_info);
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gio


