// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/socket.h>
#include <giomm/private/socket_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include <giomm/asyncresult.h>
#include "slot_async.h"

namespace Gio
{
} // namespace Gio

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gio::SocketType>::value_type()
{
  return g_socket_type_get_type();
}

// static
GType Glib::Value<Gio::SocketProtocol>::value_type()
{
  return g_socket_protocol_get_type();
}

// static
GType Glib::Value<Gio::SocketMsgFlags>::value_type()
{
  return g_socket_msg_flags_get_type();
}


namespace Glib
{

Glib::RefPtr<Gio::Socket> wrap(GSocket* object, bool take_copy)
{
  return Glib::RefPtr<Gio::Socket>( dynamic_cast<Gio::Socket*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& Socket_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Socket_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_socket_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Initable::add_interface(get_type());

  }

  return *this;
}


void Socket_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Socket_Class::wrap_new(GObject* object)
{
  return new Socket((GSocket*)object);
}


/* The implementation: */

GSocket* Socket::gobj_copy()
{
  reference();
  return gobj();
}

Socket::Socket(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Socket::Socket(GSocket* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Socket::~Socket()
{}


Socket::CppClassType Socket::socket_class_; // initialize static member

GType Socket::get_type()
{
  return socket_class_.init().get_type();
}


GType Socket::get_base_type()
{
  return g_socket_get_type();
}


#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Socket::bind(const Glib::RefPtr<SocketAddress>& address, bool allow_reuse)
#else
void Socket::bind(const Glib::RefPtr<SocketAddress>& address, bool allow_reuse, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_socket_bind(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), static_cast<int>(allow_reuse), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Socket::listen()
#else
void Socket::listen(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_socket_listen(gobj(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<Socket> Socket::accept()
#else
Glib::RefPtr<Socket> Socket::accept(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<Socket> retvalue = Glib::wrap(g_socket_accept(gobj(), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Socket::connect(const Glib::RefPtr<SocketAddress>& address)
#else
void Socket::connect(const Glib::RefPtr<SocketAddress>& address, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_socket_connect(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Socket::check_connect_result()
#else
void Socket::check_connect_result(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_socket_check_connect_result(gobj(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
gssize Socket::receive(char* buffer, gsize size)
#else
gssize Socket::receive(char* buffer, gsize size, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  gssize retvalue = g_socket_receive(gobj(), buffer, size, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
gssize Socket::send(const gchar* buffer, gsize size)
#else
gssize Socket::send(const gchar* buffer, gsize size, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  gssize retvalue = g_socket_send(gobj(), buffer, size, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
gssize Socket::send_to(const Glib::RefPtr<SocketAddress>& address, const char* buffer, gsize size)
#else
gssize Socket::send_to(const Glib::RefPtr<SocketAddress>& address, const char* buffer, gsize size, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  gssize retvalue = g_socket_send_to(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), buffer, size, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Socket::close()
#else
void Socket::close(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_socket_close(gobj(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

bool Socket::is_closed()
{
  return g_socket_is_closed(gobj());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Socket::shutdown(bool shutdown_read, bool shutdown_write)
#else
void Socket::shutdown(bool shutdown_read, bool shutdown_write, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_socket_shutdown(gobj(), static_cast<int>(shutdown_read), static_cast<int>(shutdown_write), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

bool Socket::is_connected()
{
  return g_socket_is_connected(gobj());
}

Glib::IOCondition Socket::condition_check(Glib::IOCondition condition)
{
  return ((Glib::IOCondition)(g_socket_condition_check(gobj(), ((GIOCondition)(condition)))));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Socket::condition_wait(Glib::IOCondition condition, const Glib::RefPtr<Cancellable>& cancellable)
#else
void Socket::condition_wait(Glib::IOCondition condition, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_socket_condition_wait(gobj(), ((GIOCondition)(condition)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

void Socket::set_listen_backlog(int backlog)
{
g_socket_set_listen_backlog(gobj(), backlog); 
}

int Socket::get_listen_backlog() const
{
  return g_socket_get_listen_backlog(const_cast<GSocket*>(gobj()));
}

void Socket::set_blocking(bool blocking)
{
g_socket_set_blocking(gobj(), static_cast<int>(blocking)); 
}

bool Socket::get_blocking() const
{
  return g_socket_get_blocking(const_cast<GSocket*>(gobj()));
}

void Socket::set_keepalive(bool keepalive)
{
g_socket_set_keepalive(gobj(), static_cast<int>(keepalive)); 
}

bool Socket::get_keepalive() const
{
  return g_socket_get_keepalive(const_cast<GSocket*>(gobj()));
}

SocketFamily Socket::get_family() const
{
  return ((SocketFamily)(g_socket_get_family(const_cast<GSocket*>(gobj()))));
}

int Socket::get_fd() const
{
  return g_socket_get_fd(const_cast<GSocket*>(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<SocketAddress> Socket::get_local_address() const
#else
Glib::RefPtr<SocketAddress> Socket::get_local_address(std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<SocketAddress> retvalue = Glib::wrap(g_socket_get_local_address(const_cast<GSocket*>(gobj()), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<SocketAddress> Socket::get_remote_address() const
#else
Glib::RefPtr<SocketAddress> Socket::get_remote_address(std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<SocketAddress> retvalue = Glib::wrap(g_socket_get_remote_address(const_cast<GSocket*>(gobj()), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

SocketProtocol Socket::get_protocol() const
{
  return ((SocketProtocol)(g_socket_get_protocol(const_cast<GSocket*>(gobj()))));
}

SocketType Socket::get_socket_type() const
{
  return ((SocketType)(g_socket_get_socket_type(const_cast<GSocket*>(gobj()))));
}

bool Socket::speaks_ipv4() const
{
  return g_socket_speaks_ipv4(const_cast<GSocket*>(gobj()));
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Socket::property_blocking() 
{
  return Glib::PropertyProxy<bool>(this, "blocking");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Socket::property_blocking() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "blocking");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<SocketFamily> Socket::property_family() const
{
  return Glib::PropertyProxy_ReadOnly<SocketFamily>(this, "family");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Socket::property_fd() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "fd");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Socket::property_keepalive() 
{
  return Glib::PropertyProxy<bool>(this, "keepalive");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Socket::property_keepalive() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "keepalive");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Socket::property_listen_backlog() 
{
  return Glib::PropertyProxy<int>(this, "listen-backlog");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Socket::property_listen_backlog() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "listen-backlog");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> > Socket::property_local_address() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> >(this, "local-address");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> > Socket::property_remote_address() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> >(this, "remote-address");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<SocketProtocol> Socket::property_protocol() const
{
  return Glib::PropertyProxy_ReadOnly<SocketProtocol>(this, "protocol");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<SocketType> Socket::property_type() const
{
  return Glib::PropertyProxy_ReadOnly<SocketType>(this, "type");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gio


