/* gitg-diff-view.c generated by valac 0.32.1, the Vala compiler
 * generated from gitg-diff-view.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gtksourceview/gtksource.h>
#include <cairo.h>
#include <stdio.h>


#define GITG_TYPE_DIFF_VIEW (gitg_diff_view_get_type ())
#define GITG_DIFF_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW, GitgDiffView))
#define GITG_DIFF_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW, GitgDiffViewClass))
#define GITG_IS_DIFF_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW))
#define GITG_IS_DIFF_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW))
#define GITG_DIFF_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW, GitgDiffViewClass))

typedef struct _GitgDiffView GitgDiffView;
typedef struct _GitgDiffViewClass GitgDiffViewClass;
typedef struct _GitgDiffViewPrivate GitgDiffViewPrivate;

#define GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS (gitg_diff_view_commit_details_get_type ())
#define GITG_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetails))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))

typedef struct _GitgDiffViewCommitDetails GitgDiffViewCommitDetails;
typedef struct _GitgDiffViewCommitDetailsClass GitgDiffViewCommitDetailsClass;

#define GITG_TYPE_DIFF_VIEW_OPTIONS (gitg_diff_view_options_get_type ())
#define GITG_DIFF_VIEW_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptions))
#define GITG_DIFF_VIEW_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptionsClass))
#define GITG_IS_DIFF_VIEW_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS))
#define GITG_IS_DIFF_VIEW_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_OPTIONS))
#define GITG_DIFF_VIEW_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptionsClass))

typedef struct _GitgDiffViewOptions GitgDiffViewOptions;
typedef struct _GitgDiffViewOptionsClass GitgDiffViewOptionsClass;

#define GITG_TYPE_COMMIT (gitg_commit_get_type ())
#define GITG_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT, GitgCommit))
#define GITG_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT, GitgCommitClass))
#define GITG_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT))
#define GITG_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT))
#define GITG_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT, GitgCommitClass))

typedef struct _GitgCommit GitgCommit;
typedef struct _GitgCommitClass GitgCommitClass;

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE (gitg_diff_view_file_get_type ())
#define GITG_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile))
#define GITG_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))
#define GITG_IS_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_IS_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_DIFF_VIEW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))

typedef struct _GitgDiffViewFile GitgDiffViewFile;
typedef struct _GitgDiffViewFileClass GitgDiffViewFileClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))

#define GITG_TYPE_DIFF_SELECTABLE (gitg_diff_selectable_get_type ())
#define GITG_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectable))
#define GITG_IS_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_SELECTABLE))
#define GITG_DIFF_SELECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectableIface))

typedef struct _GitgDiffSelectable GitgDiffSelectable;
typedef struct _GitgDiffSelectableIface GitgDiffSelectableIface;

#define GITG_TYPE_PATCH_SET (gitg_patch_set_get_type ())
#define GITG_PATCH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PATCH_SET, GitgPatchSet))
#define GITG_PATCH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PATCH_SET, GitgPatchSetClass))
#define GITG_IS_PATCH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PATCH_SET))
#define GITG_IS_PATCH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PATCH_SET))
#define GITG_PATCH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PATCH_SET, GitgPatchSetClass))

typedef struct _GitgPatchSet GitgPatchSet;
typedef struct _GitgPatchSetClass GitgPatchSetClass;

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER (gitg_diff_view_file_renderer_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRenderer))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER))
#define GITG_DIFF_VIEW_FILE_RENDERER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRendererIface))

typedef struct _GitgDiffViewFileRenderer GitgDiffViewFileRenderer;
typedef struct _GitgDiffViewFileRendererIface GitgDiffViewFileRendererIface;
typedef struct _Block6Data Block6Data;
#define _ggit_diff_hunk_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_hunk_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT (gitg_diff_view_file_renderer_text_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererText))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererTextClass))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererTextClass))

typedef struct _GitgDiffViewFileRendererText GitgDiffViewFileRendererText;
typedef struct _GitgDiffViewFileRendererTextClass GitgDiffViewFileRendererTextClass;
typedef struct _GitgPatchSetPrivate GitgPatchSetPrivate;

#define GITG_PATCH_SET_TYPE_PATCH (gitg_patch_set_patch_get_type ())

#define GITG_PATCH_SET_TYPE_TYPE (gitg_patch_set_type_get_type ())
typedef struct _GitgPatchSetPatch GitgPatchSetPatch;
#define _gitg_patch_set_unref0(var) ((var == NULL) ? NULL : (var = (gitg_patch_set_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GitgDiffView {
	GtkGrid parent_instance;
	GitgDiffViewPrivate * priv;
};

struct _GitgDiffViewClass {
	GtkGridClass parent_class;
	void (*options_changed) (GitgDiffView* self);
};

struct _GitgDiffViewPrivate {
	GitgDiffViewCommitDetails* d_commit_details;
	GtkScrolledWindow* d_scrolledwindow;
	GtkGrid* d_grid_files;
	GtkEventBox* d_event_box;
	GtkRevealer* d_revealer_options;
	GitgDiffViewOptions* d_diff_view_options;
	GtkTextView* d_text_view_message;
	GgitDiff* d_diff;
	GitgCommit* d_commit;
	GgitDiffOptions* d_options;
	GCancellable* d_cancellable;
	gulong d_expanded_notify;
	gulong d_parent_commit_notify;
	gboolean d_changes_inline;
	guint d_reveal_options_timeout;
	guint d_unreveal_options_timeout;
	gboolean _has_selection;
	gboolean _wrap_lines;
	gboolean _staged;
	gboolean _unstaged;
	gboolean _show_parents;
	gboolean _default_collapse_all;
	gboolean _use_gravatar;
	gint _tab_width;
	gboolean _handle_selection;
	gboolean _highlight;
	GitgRepository* _repository;
	gboolean _new_is_workdir;
};

struct _GitgDiffSelectableIface {
	GTypeInterface parent_iface;
	gboolean (*get_has_selection) (GitgDiffSelectable* self);
	gboolean (*get_can_select) (GitgDiffSelectable* self);
	void (*set_can_select) (GitgDiffSelectable* self, gboolean value);
	GitgPatchSet* (*get_selection) (GitgDiffSelectable* self);
};

struct _GitgDiffViewFileRendererIface {
	GTypeInterface parent_iface;
	void (*add_hunk) (GitgDiffViewFileRenderer* self, GgitDiffHunk* hunk, GeeArrayList* lines);
};

typedef void (*GitgDiffViewAnon) (void* user_data);
struct _Block6Data {
	int _ref_count_;
	GitgDiffView* self;
	GeeArrayList* files;
	GitgDiffViewFile* current_file;
	GgitDiffHunk* current_hunk;
	GeeArrayList* current_lines;
	gint maxlines;
	GitgDiffViewAnon add_hunk;
	gpointer add_hunk_target;
	GDestroyNotify add_hunk_target_destroy_notify;
	GitgDiffViewAnon add_file;
	gpointer add_file_target;
	GDestroyNotify add_file_target_destroy_notify;
	GCancellable* cancellable;
};

typedef enum  {
	GITG_PATCH_SET_TYPE_ADD = 'a',
	GITG_PATCH_SET_TYPE_REMOVE = 'r'
} GitgPatchSetType;

struct _GitgPatchSetPatch {
	GitgPatchSetType type;
	gsize old_offset;
	gsize new_offset;
	gsize length;
};

struct _GitgPatchSet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgPatchSetPrivate * priv;
	gchar* filename;
	GitgPatchSetPatch* patches;
	gint patches_length1;
};

struct _GitgPatchSetClass {
	GTypeClass parent_class;
	void (*finalize) (GitgPatchSet *self);
};


static gpointer gitg_diff_view_parent_class = NULL;
static GRegex* gitg_diff_view_s_message_regexp;
static GRegex* gitg_diff_view_s_message_regexp = NULL;

GType gitg_diff_view_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_commit_details_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_options_get_type (void) G_GNUC_CONST;
GType gitg_commit_get_type (void) G_GNUC_CONST;
GType gitg_repository_get_type (void) G_GNUC_CONST;
#define GITG_DIFF_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_DIFF_VIEW, GitgDiffViewPrivate))
enum  {
	GITG_DIFF_VIEW_DUMMY_PROPERTY,
	GITG_DIFF_VIEW_OPTIONS,
	GITG_DIFF_VIEW_HAS_SELECTION,
	GITG_DIFF_VIEW_DIFF,
	GITG_DIFF_VIEW_COMMIT,
	GITG_DIFF_VIEW_WRAP_LINES,
	GITG_DIFF_VIEW_STAGED,
	GITG_DIFF_VIEW_UNSTAGED,
	GITG_DIFF_VIEW_SHOW_PARENTS,
	GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL,
	GITG_DIFF_VIEW_USE_GRAVATAR,
	GITG_DIFF_VIEW_TAB_WIDTH,
	GITG_DIFF_VIEW_HANDLE_SELECTION,
	GITG_DIFF_VIEW_HIGHLIGHT,
	GITG_DIFF_VIEW_REPOSITORY,
	GITG_DIFF_VIEW_NEW_IS_WORKDIR,
	GITG_DIFF_VIEW_IGNORE_WHITESPACE,
	GITG_DIFF_VIEW_CHANGES_INLINE,
	GITG_DIFF_VIEW_CONTEXT_LINES
};
static gboolean gitg_diff_view_flag_get (GitgDiffView* self, GgitDiffOption f);
GgitDiffOptions* gitg_diff_view_get_options (GitgDiffView* self);
static void gitg_diff_view_flag_set (GitgDiffView* self, GgitDiffOption f, gboolean val);
static void gitg_diff_view_real_constructed (GObject* base);
static void gitg_diff_view_update_expanded_files (GitgDiffView* self);
static void _gitg_diff_view_update_expanded_files_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gitg_diff_view_parent_commit_changed (GitgDiffView* self);
static void _gitg_diff_view_parent_commit_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean gitg_diff_view_motion_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventMotion* event);
static gboolean _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void gitg_diff_view_options_set_view (GitgDiffViewOptions* self, GitgDiffView* value);
static void gitg_diff_view_real_dispose (GObject* base);
static void gitg_diff_view_update (GitgDiffView* self, gboolean preserve_expanded);
gboolean gitg_diff_view_commit_details_get_expanded (GitgDiffViewCommitDetails* self);
GType gitg_diff_view_file_get_type (void) G_GNUC_CONST;
void gitg_diff_view_file_set_expanded (GitgDiffViewFile* self, gboolean value);
static gchar* gitg_diff_view_message_without_subject (GitgDiffView* self, GitgCommit* commit);
void gitg_diff_view_commit_details_set_commit (GitgDiffViewCommitDetails* self, GgitCommit* value);
GgitCommit* gitg_diff_view_commit_details_get_parent_commit (GitgDiffViewCommitDetails* self);
static void _vala_GgitOId_free (GgitOId* self);
GgitDiff* gitg_commit_get_diff (GitgCommit* self, GgitDiffOptions* options, gint parent);
static void gitg_diff_view_update_diff (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GCancellable* cancellable);
static void gitg_diff_view_auto_change_expanded (GitgDiffView* self, gboolean expanded);
void gitg_diff_view_commit_details_set_expanded (GitgDiffViewCommitDetails* self, gboolean value);
static void gitg_diff_view_on_selection_changed (GitgDiffView* self);
gpointer gitg_patch_set_ref (gpointer instance);
void gitg_patch_set_unref (gpointer instance);
GParamSpec* gitg_param_spec_patch_set (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gitg_value_set_patch_set (GValue* value, gpointer v_object);
void gitg_value_take_patch_set (GValue* value, gpointer v_object);
gpointer gitg_value_get_patch_set (const GValue* value);
GType gitg_patch_set_get_type (void) G_GNUC_CONST;
GType gitg_diff_selectable_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_file_renderer_get_type (void) G_GNUC_CONST;
GitgDiffViewFileRenderer* gitg_diff_view_file_get_renderer (GitgDiffViewFile* self);
gboolean gitg_diff_selectable_get_has_selection (GitgDiffSelectable* self);
gboolean gitg_diff_view_get_has_selection (GitgDiffView* self);
static void gitg_diff_view_set_has_selection (GitgDiffView* self, gboolean value);
static gchar* gitg_diff_view_primary_path (GitgDiffView* self, GitgDiffViewFile* f);
GgitDiffDelta* gitg_diff_view_file_get_delta (GitgDiffViewFile* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda53_ (Block6Data* _data6_);
void gitg_diff_view_file_add_hunk (GitgDiffViewFile* self, GgitDiffHunk* hunk, GeeArrayList* lines);
static void ___lambda53__gitg_diff_view_anon (gpointer self);
static void __lambda54_ (Block6Data* _data6_);
static void _gitg_diff_view_on_selection_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda54__gitg_diff_view_anon (gpointer self);
static gint ___lambda55_ (Block6Data* _data6_, GgitDiffDelta* delta, gfloat progress);
GitgRepository* gitg_diff_view_get_repository (GitgDiffView* self);
gboolean gitg_diff_view_get_new_is_workdir (GitgDiffView* self);
gboolean gitg_diff_view_get_handle_selection (GitgDiffView* self);
GitgDiffViewFile* gitg_diff_view_file_new_text (GitgRepository* repository, GgitDiffDelta* delta, gboolean new_is_workdir, gboolean handle_selection);
GitgDiffViewFile* gitg_diff_view_file_construct_text (GType object_type, GitgRepository* repository, GgitDiffDelta* delta, gboolean new_is_workdir, gboolean handle_selection);
static gint ____lambda55__ggit_diff_file_callback (GgitDiffDelta* delta, gfloat progress, gpointer self);
static gint ___lambda56_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffBinary* binary);
static gint ____lambda56__ggit_diff_binary_callback (GgitDiffDelta* delta, GgitDiffBinary* binary, gpointer self);
static gint ___lambda57_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffHunk* hunk);
static gint ____lambda57__ggit_diff_hunk_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, gpointer self);
static gint ___lambda58_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line);
static gint ____lambda58__ggit_diff_line_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line, gpointer self);
gboolean gitg_diff_view_file_get_expanded (GitgDiffViewFile* self);
gboolean gitg_diff_view_get_default_collapse_all (GitgDiffView* self);
void gitg_diff_view_commit_details_set_expander_visible (GitgDiffViewCommitDetails* self, gboolean value);
GType gitg_diff_view_file_renderer_text_get_type (void) G_GNUC_CONST;
void gitg_diff_view_file_renderer_text_set_maxlines (GitgDiffViewFileRendererText* self, gint value);
static void gitg_diff_view_auto_update_expanded (GitgDiffView* self);
static void _gitg_diff_view_auto_update_expanded_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gitg_diff_view_update_hide_show_options (GitgDiffView* self, GdkWindow* window, gint ex, gint ey);
static gboolean ___lambda59_ (GitgDiffView* self);
static gboolean ____lambda59__gsource_func (gpointer self);
static gboolean _____lambda60_ (GitgDiffView* self);
static gboolean ______lambda60__gsource_func (gpointer self);
static gboolean gitg_diff_view_leave_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event);
static gboolean _gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean gitg_diff_view_enter_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event);
static gboolean _gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
GitgDiffView* gitg_diff_view_new (void);
GitgDiffView* gitg_diff_view_construct (GType object_type);
GgitDiff* gitg_diff_view_get_diff (GitgDiffView* self);
void gitg_diff_view_set_diff (GitgDiffView* self, GgitDiff* value);
GitgCommit* gitg_diff_view_get_commit (GitgDiffView* self);
void gitg_diff_view_set_commit (GitgDiffView* self, GitgCommit* value);
gboolean gitg_diff_view_get_wrap_lines (GitgDiffView* self);
void gitg_diff_view_set_wrap_lines (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_staged (GitgDiffView* self);
void gitg_diff_view_set_staged (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_unstaged (GitgDiffView* self);
void gitg_diff_view_set_unstaged (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_show_parents (GitgDiffView* self);
void gitg_diff_view_set_show_parents (GitgDiffView* self, gboolean value);
void gitg_diff_view_set_default_collapse_all (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_use_gravatar (GitgDiffView* self);
void gitg_diff_view_set_use_gravatar (GitgDiffView* self, gboolean value);
gint gitg_diff_view_get_tab_width (GitgDiffView* self);
void gitg_diff_view_set_tab_width (GitgDiffView* self, gint value);
void gitg_diff_view_set_handle_selection (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_highlight (GitgDiffView* self);
void gitg_diff_view_set_highlight (GitgDiffView* self, gboolean value);
void gitg_diff_view_set_repository (GitgDiffView* self, GitgRepository* value);
void gitg_diff_view_set_new_is_workdir (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_ignore_whitespace (GitgDiffView* self);
void gitg_diff_view_set_ignore_whitespace (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_changes_inline (GitgDiffView* self);
void gitg_diff_view_set_changes_inline (GitgDiffView* self, gboolean value);
gint gitg_diff_view_get_context_lines (GitgDiffView* self);
void gitg_diff_view_set_context_lines (GitgDiffView* self, gint value);
GitgPatchSet** gitg_diff_view_get_selection (GitgDiffView* self, int* result_length1);
GitgPatchSet* gitg_diff_selectable_get_selection (GitgDiffSelectable* self);
GType gitg_patch_set_patch_get_type (void) G_GNUC_CONST;
GType gitg_patch_set_type_get_type (void) G_GNUC_CONST;
GitgPatchSetPatch* gitg_patch_set_patch_dup (const GitgPatchSetPatch* self);
void gitg_patch_set_patch_free (GitgPatchSetPatch* self);
static void _vala_array_add2 (GitgPatchSet*** array, int* length, int* size, GitgPatchSet* value);
static void gitg_diff_view_real_options_changed (GitgDiffView* self);
static void gitg_diff_view_finalize (GObject* obj);
static void _vala_gitg_diff_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_diff_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean gitg_diff_view_flag_get (GitgDiffView* self, GgitDiffOption f) {
	gboolean result = FALSE;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	GgitDiffOption _tmp2_ = 0;
	GgitDiffOption _tmp3_ = 0;
	GgitDiffOption _tmp4_ = 0;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_flags (_tmp1_);
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = f;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = (_tmp3_ & _tmp4_) != 0;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 428 "gitg-diff-view.c"
}


static void gitg_diff_view_flag_set (GitgDiffView* self, GgitDiffOption f, gboolean val) {
	GgitDiffOption flags = 0;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	GgitDiffOption _tmp2_ = 0;
	GgitDiffOption _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	GgitDiffOption _tmp9_ = 0;
	GgitDiffOptions* _tmp10_ = NULL;
	GgitDiffOptions* _tmp11_ = NULL;
	GgitDiffOption _tmp12_ = 0;
	GgitDiffOption _tmp13_ = 0;
#line 128 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_flags (_tmp1_);
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	flags = _tmp3_;
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = val;
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp4_) {
#line 460 "gitg-diff-view.c"
		GgitDiffOption _tmp5_ = 0;
		GgitDiffOption _tmp6_ = 0;
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = flags;
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = f;
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		flags = _tmp5_ | _tmp6_;
#line 469 "gitg-diff-view.c"
	} else {
		GgitDiffOption _tmp7_ = 0;
		GgitDiffOption _tmp8_ = 0;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = flags;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = f;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		flags = _tmp7_ & (~_tmp8_);
#line 479 "gitg-diff-view.c"
	}
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = flags;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = gitg_diff_view_get_options (self);
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = _tmp10_;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp12_ = ggit_diff_options_get_flags (_tmp11_);
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = _tmp12_;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != _tmp13_) {
#line 493 "gitg-diff-view.c"
		GgitDiffOptions* _tmp14_ = NULL;
		GgitDiffOptions* _tmp15_ = NULL;
		GgitDiffOption _tmp16_ = 0;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = gitg_diff_view_get_options (self);
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = _tmp14_;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = flags;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_flags (_tmp15_, _tmp16_);
#line 144 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_emit_by_name (self, "options-changed");
#line 507 "gitg-diff-view.c"
	}
}


static void _gitg_diff_view_update_expanded_files_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_expanded_files ((GitgDiffView*) self);
#line 515 "gitg-diff-view.c"
}


static void _gitg_diff_view_parent_commit_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_parent_commit_changed ((GitgDiffView*) self);
#line 522 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_motion_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 531 "gitg-diff-view.c"
}


static void gitg_diff_view_real_constructed (GObject* base) {
	GitgDiffView * self;
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GitgDiffViewCommitDetails* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
	GitgDiffViewCommitDetails* _tmp4_ = NULL;
	GtkEventBox* _tmp5_ = NULL;
	GitgDiffViewOptions* _tmp6_ = NULL;
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = (GitgDiffView*) base;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = g_signal_connect_object ((GObject*) _tmp0_, "notify::expanded", (GCallback) _gitg_diff_view_update_expanded_files_g_object_notify, self, 0);
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_expanded_notify = _tmp1_;
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_commit_details;
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = g_signal_connect_object ((GObject*) _tmp2_, "notify::parent-commit", (GCallback) _gitg_diff_view_parent_commit_changed_g_object_notify, self, 0);
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_parent_commit_notify = _tmp3_;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->d_commit_details;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_bind_property_with_closures ((GObject*) self, "use-gravatar", (GObject*) _tmp4_, "use-gravatar", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_event_box;
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp5_, "motion-notify-event", (GCallback) _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event, self, 0);
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_diff_view_options;
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_options_set_view (_tmp6_, self);
#line 570 "gitg-diff-view.c"
}


static void gitg_diff_view_real_dispose (GObject* base) {
	GitgDiffView * self;
	GCancellable* _tmp0_ = NULL;
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = (GitgDiffView*) base;
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_cancellable;
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != NULL) {
#line 583 "gitg-diff-view.c"
		GCancellable* _tmp1_ = NULL;
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = self->priv->d_cancellable;
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_cancellable_cancel (_tmp1_);
#line 589 "gitg-diff-view.c"
	}
#line 205 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (gitg_diff_view_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid));
#line 593 "gitg-diff-view.c"
}


static void gitg_diff_view_parent_commit_changed (GitgDiffView* self) {
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 210 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 602 "gitg-diff-view.c"
}


static void gitg_diff_view_update_expanded_files (GitgDiffView* self) {
	gboolean expanded = FALSE;
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkGrid* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
#line 213 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gitg_diff_view_commit_details_get_expanded (_tmp0_);
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _tmp1_;
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	expanded = _tmp2_;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = self->priv->d_grid_files;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
#line 627 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp4_;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 635 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 639 "gitg-diff-view.c"
			{
				GtkWidget* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = file;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = expanded;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gitg_diff_view_file_set_expanded (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp5_) : NULL, _tmp6_);
#line 649 "gitg-diff-view.c"
			}
		}
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 654 "gitg-diff-view.c"
	}
}


static gchar* gitg_diff_view_message_without_subject (GitgDiffView* self, GitgCommit* commit) {
	gchar* result = NULL;
	gchar* message = NULL;
	GitgCommit* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GMatchInfo* minfo = NULL;
	GRegex* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GMatchInfo* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp9_ = NULL;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (commit != NULL, NULL);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = commit;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = ggit_commit_get_message ((GgitCommit*) _tmp0_);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	message = _tmp2_;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = gitg_diff_view_s_message_regexp;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = message;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = g_regex_match (_tmp3_, _tmp4_, 0, &_tmp5_);
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_match_info_unref0 (minfo);
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	minfo = _tmp5_;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp6_) {
#line 695 "gitg-diff-view.c"
		GMatchInfo* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = minfo;
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = g_match_info_fetch_named (_tmp7_, "message");
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = _tmp8_;
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_match_info_unref0 (minfo);
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (message);
#line 240 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 710 "gitg-diff-view.c"
	}
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = g_strdup ("");
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp9_;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_match_info_unref0 (minfo);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_free0 (message);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 722 "gitg-diff-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 729 "gitg-diff-view.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 736 "gitg-diff-view.c"
}


static void gitg_diff_view_update (GitgDiffView* self, gboolean preserve_expanded) {
	gboolean _tmp0_ = FALSE;
	GgitDiff* _tmp1_ = NULL;
	GitgDiffViewCommitDetails* _tmp5_ = NULL;
	GtkScrolledWindow* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	GitgCommit* _tmp9_ = NULL;
	GgitDiff* _tmp56_ = NULL;
#line 246 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_diff;
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ == NULL) {
#line 755 "gitg-diff-view.c"
		GitgCommit* _tmp2_ = NULL;
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = self->priv->d_commit;
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 761 "gitg-diff-view.c"
	} else {
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 765 "gitg-diff-view.c"
	}
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 769 "gitg-diff-view.c"
		GitgDiffViewCommitDetails* _tmp3_ = NULL;
		GtkScrolledWindow* _tmp4_ = NULL;
#line 252 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = self->priv->d_commit_details;
#line 252 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp4_ = self->priv->d_scrolledwindow;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp4_);
#line 254 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 782 "gitg-diff-view.c"
	}
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_commit_details;
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp5_);
#line 258 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_scrolledwindow;
#line 258 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp6_);
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = self->priv->d_cancellable;
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_cancellable_cancel (_tmp7_);
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = g_cancellable_new ();
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_cancellable);
#line 262 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_cancellable = _tmp8_;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = self->priv->d_commit;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != NULL) {
#line 806 "gitg-diff-view.c"
		GitgDiffViewCommitDetails* _tmp10_ = NULL;
		gulong _tmp11_ = 0UL;
		GitgDiffViewCommitDetails* _tmp12_ = NULL;
		GitgCommit* _tmp13_ = NULL;
		GitgDiffViewCommitDetails* _tmp14_ = NULL;
		gulong _tmp15_ = 0UL;
		gint parent = 0;
		GgitCommitParents* parents = NULL;
		GitgCommit* _tmp16_ = NULL;
		GgitCommitParents* _tmp17_ = NULL;
		GgitCommit* parent_commit = NULL;
		GitgDiffViewCommitDetails* _tmp18_ = NULL;
		GgitCommit* _tmp19_ = NULL;
		GgitCommit* _tmp20_ = NULL;
		GgitCommit* _tmp21_ = NULL;
		GgitCommit* _tmp22_ = NULL;
		GitgCommit* _tmp39_ = NULL;
		GgitDiffOptions* _tmp40_ = NULL;
		GgitDiffOptions* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		GgitDiff* _tmp43_ = NULL;
		GitgDiffViewCommitDetails* _tmp44_ = NULL;
		gchar* message = NULL;
		GitgCommit* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		GtkTextView* _tmp47_ = NULL;
		GtkTextBuffer* _tmp48_ = NULL;
		GtkTextBuffer* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		GtkTextView* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = self->priv->d_commit_details;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = self->priv->d_parent_commit_notify;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_handler_block (_tmp10_, _tmp11_);
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = self->priv->d_commit_details;
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp13_ = self->priv->d_commit;
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_commit_details_set_commit (_tmp12_, (GgitCommit*) _tmp13_);
#line 268 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = self->priv->d_commit_details;
#line 268 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = self->priv->d_parent_commit_notify;
#line 268 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_handler_unblock (_tmp14_, _tmp15_);
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		parent = 0;
#line 271 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = self->priv->d_commit;
#line 271 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = ggit_commit_get_parents ((GgitCommit*) _tmp16_);
#line 271 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		parents = _tmp17_;
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp18_ = self->priv->d_commit_details;
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp19_ = gitg_diff_view_commit_details_get_parent_commit (_tmp18_);
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp20_ = _tmp19_;
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = _g_object_ref0 (_tmp20_);
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		parent_commit = _tmp21_;
#line 275 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp22_ = parent_commit;
#line 275 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp22_ != NULL) {
#line 878 "gitg-diff-view.c"
			{
				gint i = 0;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				i = 0;
#line 883 "gitg-diff-view.c"
				{
					gboolean _tmp23_ = FALSE;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp23_ = TRUE;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					while (TRUE) {
#line 890 "gitg-diff-view.c"
						gint _tmp25_ = 0;
						GgitCommitParents* _tmp26_ = NULL;
						guint _tmp27_ = 0U;
						guint _tmp28_ = 0U;
						GgitOId* id = NULL;
						GgitCommitParents* _tmp29_ = NULL;
						gint _tmp30_ = 0;
						GgitOId* _tmp31_ = NULL;
						GgitOId* _tmp32_ = NULL;
						GgitCommit* _tmp33_ = NULL;
						GgitOId* _tmp34_ = NULL;
						GgitOId* _tmp35_ = NULL;
						gboolean _tmp36_ = FALSE;
						gboolean _tmp37_ = FALSE;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						if (!_tmp23_) {
#line 907 "gitg-diff-view.c"
							gint _tmp24_ = 0;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							_tmp24_ = i;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							i = _tmp24_ + 1;
#line 913 "gitg-diff-view.c"
						}
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp23_ = FALSE;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp25_ = i;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp26_ = parents;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp27_ = ggit_commit_parents_get_size (_tmp26_);
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp28_ = _tmp27_;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						if (!(((guint) _tmp25_) < _tmp28_)) {
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							break;
#line 929 "gitg-diff-view.c"
						}
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp29_ = parents;
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp30_ = i;
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp31_ = ggit_commit_parents_get_id (_tmp29_, (guint) _tmp30_);
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						id = _tmp31_;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp32_ = id;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp33_ = parent_commit;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp34_ = ggit_object_get_id ((GgitObject*) _tmp33_);
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp35_ = _tmp34_;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp36_ = ggit_oid_equal (_tmp32_, _tmp35_);
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp37_ = _tmp36_;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						__vala_GgitOId_free0 (_tmp35_);
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						if (_tmp37_) {
#line 955 "gitg-diff-view.c"
							gint _tmp38_ = 0;
#line 283 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							_tmp38_ = i;
#line 283 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							parent = _tmp38_;
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							__vala_GgitOId_free0 (id);
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
							break;
#line 965 "gitg-diff-view.c"
						}
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						__vala_GgitOId_free0 (id);
#line 969 "gitg-diff-view.c"
					}
				}
			}
		}
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp39_ = self->priv->d_commit;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp40_ = gitg_diff_view_get_options (self);
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp41_ = _tmp40_;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp42_ = parent;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp43_ = gitg_commit_get_diff (_tmp39_, _tmp41_, _tmp42_);
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = _tmp43_;
#line 290 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp44_ = self->priv->d_commit_details;
#line 290 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_show ((GtkWidget*) _tmp44_);
#line 292 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp45_ = self->priv->d_commit;
#line 292 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp46_ = gitg_diff_view_message_without_subject (self, _tmp45_);
#line 292 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		message = _tmp46_;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp47_ = self->priv->d_text_view_message;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp48_ = gtk_text_view_get_buffer (_tmp47_);
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp49_ = _tmp48_;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp50_ = message;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_text_buffer_set_text (_tmp49_, _tmp50_, -1);
#line 295 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp51_ = self->priv->d_text_view_message;
#line 295 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp52_ = message;
#line 295 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp51_, g_strcmp0 (_tmp52_, "") != 0);
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (message);
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (parent_commit);
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (parents);
#line 1020 "gitg-diff-view.c"
	} else {
		GitgDiffViewCommitDetails* _tmp53_ = NULL;
		GitgDiffViewCommitDetails* _tmp54_ = NULL;
		GtkTextView* _tmp55_ = NULL;
#line 299 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp53_ = self->priv->d_commit_details;
#line 299 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_commit_details_set_commit (_tmp53_, NULL);
#line 300 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp54_ = self->priv->d_commit_details;
#line 300 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp54_);
#line 302 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp55_ = self->priv->d_text_view_message;
#line 302 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp55_);
#line 1037 "gitg-diff-view.c"
	}
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp56_ = self->priv->d_diff;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp56_ != NULL) {
#line 1043 "gitg-diff-view.c"
		GgitDiff* _tmp57_ = NULL;
		gboolean _tmp58_ = FALSE;
		GCancellable* _tmp59_ = NULL;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp57_ = self->priv->d_diff;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp58_ = preserve_expanded;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp59_ = self->priv->d_cancellable;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_update_diff (self, _tmp57_, _tmp58_, _tmp59_);
#line 1055 "gitg-diff-view.c"
	}
}


static void gitg_diff_view_auto_change_expanded (GitgDiffView* self, gboolean expanded) {
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GitgDiffViewCommitDetails* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GitgDiffViewCommitDetails* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_expanded_notify;
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_handler_block (_tmp0_, _tmp1_);
#line 316 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_commit_details;
#line 316 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = expanded;
#line 316 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expanded (_tmp2_, _tmp3_);
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->d_commit_details;
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_expanded_notify;
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_handler_unblock (_tmp4_, _tmp5_);
#line 1087 "gitg-diff-view.c"
}


static void gitg_diff_view_on_selection_changed (GitgDiffView* self) {
	gboolean something_selected = FALSE;
	GtkGrid* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
#line 320 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	something_selected = FALSE;
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_grid_files;
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 1105 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp1_;
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 1113 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 1117 "gitg-diff-view.c"
			{
				GitgDiffSelectable* selectable = NULL;
				GtkWidget* _tmp2_ = NULL;
				GitgDiffViewFileRenderer* _tmp3_ = NULL;
				GitgDiffViewFileRenderer* _tmp4_ = NULL;
				GitgDiffSelectable* _tmp5_ = NULL;
				GitgDiffSelectable* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp2_ = file;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = gitg_diff_view_file_get_renderer (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp2_) : NULL);
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = _tmp3_;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GITG_TYPE_DIFF_SELECTABLE) ? ((GitgDiffSelectable*) _tmp4_) : NULL;
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp5_ == NULL) {
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp4_);
#line 1139 "gitg-diff-view.c"
				}
#line 326 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				selectable = _tmp5_;
#line 328 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = selectable;
#line 328 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp7_ = gitg_diff_selectable_get_has_selection (_tmp6_);
#line 328 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp8_ = _tmp7_;
#line 328 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp8_) {
#line 330 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					something_selected = TRUE;
#line 331 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (selectable);
#line 331 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					break;
#line 1157 "gitg-diff-view.c"
				}
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (selectable);
#line 1161 "gitg-diff-view.c"
			}
		}
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 1166 "gitg-diff-view.c"
	}
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = self->priv->_has_selection;
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = something_selected;
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != _tmp10_) {
#line 1174 "gitg-diff-view.c"
		gboolean _tmp11_ = FALSE;
#line 337 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = something_selected;
#line 337 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_has_selection (self, _tmp11_);
#line 1180 "gitg-diff-view.c"
	}
}


static gchar* gitg_diff_view_primary_path (GitgDiffView* self, GitgDiffViewFile* f) {
	gchar* result = NULL;
	gchar* path = NULL;
	GitgDiffViewFile* _tmp0_ = NULL;
	GgitDiffDelta* _tmp1_ = NULL;
	GgitDiffDelta* _tmp2_ = NULL;
	GgitDiffFile* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (f != NULL, NULL);
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = f;
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gitg_diff_view_file_get_delta (_tmp0_);
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _tmp1_;
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = ggit_diff_delta_get_old_file (_tmp2_);
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = ggit_diff_file_get_path (_tmp3_);
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	path = _tmp5_;
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = path;
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp6_ == NULL) {
#line 1217 "gitg-diff-view.c"
		GitgDiffViewFile* _tmp7_ = NULL;
		GgitDiffDelta* _tmp8_ = NULL;
		GgitDiffDelta* _tmp9_ = NULL;
		GgitDiffFile* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 347 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = f;
#line 347 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = gitg_diff_view_file_get_delta (_tmp7_);
#line 347 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = _tmp8_;
#line 347 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = ggit_diff_delta_get_new_file (_tmp9_);
#line 347 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = ggit_diff_file_get_path (_tmp10_);
#line 347 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 347 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (path);
#line 347 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		path = _tmp12_;
#line 1240 "gitg-diff-view.c"
	}
#line 350 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = path;
#line 350 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1246 "gitg-diff-view.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return _data6_;
#line 1255 "gitg-diff-view.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 1264 "gitg-diff-view.c"
		GitgDiffView* self;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self = _data6_->self;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		(_data6_->add_file_target_destroy_notify == NULL) ? NULL : (_data6_->add_file_target_destroy_notify (_data6_->add_file_target), NULL);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_file = NULL;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_file_target = NULL;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_file_target_destroy_notify = NULL;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		(_data6_->add_hunk_target_destroy_notify == NULL) ? NULL : (_data6_->add_hunk_target_destroy_notify (_data6_->add_hunk_target), NULL);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_hunk = NULL;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_hunk_target = NULL;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_hunk_target_destroy_notify = NULL;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->current_lines);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_hunk_unref0 (_data6_->current_hunk);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->current_file);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->files);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->cancellable);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 1298 "gitg-diff-view.c"
	}
}


static void __lambda53_ (Block6Data* _data6_) {
	GitgDiffView* self;
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 364 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_data6_->current_hunk != NULL) {
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_file_add_hunk (_data6_->current_file, _data6_->current_hunk, _data6_->current_lines);
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->current_lines);
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->current_lines = NULL;
#line 369 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_hunk_unref0 (_data6_->current_hunk);
#line 369 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->current_hunk = NULL;
#line 1319 "gitg-diff-view.c"
	}
}


static void ___lambda53__gitg_diff_view_anon (gpointer self) {
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	__lambda53_ (self);
#line 1327 "gitg-diff-view.c"
}


static void _gitg_diff_view_on_selection_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 379 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_on_selection_changed ((GitgDiffView*) self);
#line 1334 "gitg-diff-view.c"
}


static void __lambda54_ (Block6Data* _data6_) {
	GitgDiffView* self;
#line 373 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk (_data6_->add_hunk_target);
#line 376 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_data6_->current_file != NULL) {
#line 1346 "gitg-diff-view.c"
		GitgDiffViewFileRenderer* _tmp0_ = NULL;
		GitgDiffViewFileRenderer* _tmp1_ = NULL;
		GitgDiffViewFileRenderer* _tmp2_ = NULL;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_show ((GtkWidget*) _data6_->current_file);
#line 379 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = gitg_diff_view_file_get_renderer (_data6_->current_file);
#line 379 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = _tmp0_;
#line 379 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _tmp1_;
#line 379 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_connect_object ((GObject*) _tmp2_, "notify::has-selection", (GCallback) _gitg_diff_view_on_selection_changed_g_object_notify, self, 0);
#line 379 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_tmp2_);
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data6_->files, _data6_->current_file);
#line 383 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->current_file);
#line 383 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_->current_file = NULL;
#line 1368 "gitg-diff-view.c"
	}
}


static void ___lambda54__gitg_diff_view_anon (gpointer self) {
#line 373 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	__lambda54_ (self);
#line 1376 "gitg-diff-view.c"
}


static gint ___lambda55_ (Block6Data* _data6_, GgitDiffDelta* delta, gfloat progress) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GitgRepository* _tmp4_ = NULL;
	GgitDiffDelta* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GitgDiffViewFile* _tmp8_ = NULL;
	GitgDiffViewFileRenderer* _tmp9_ = NULL;
	GitgDiffViewFileRenderer* _tmp10_ = NULL;
	GitgDiffViewFileRenderer* _tmp11_ = NULL;
#line 390 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 390 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data6_->cancellable;
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 1401 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data6_->cancellable;
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 1410 "gitg-diff-view.c"
	} else {
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 1414 "gitg-diff-view.c"
	}
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1422 "gitg-diff-view.c"
	}
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_file (_data6_->add_file_target);
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->_repository;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = delta;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->_new_is_workdir;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = self->priv->_handle_selection;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = gitg_diff_view_file_new_text (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_ref_sink (_tmp8_);
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data6_->current_file);
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_file = _tmp8_;
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = gitg_diff_view_file_get_renderer (_data6_->current_file);
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = _tmp9_;
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = _tmp10_;
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_bind_property_with_closures ((GObject*) self, "highlight", (GObject*) _tmp11_, "highlight", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_tmp11_);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1456 "gitg-diff-view.c"
}


static gint ____lambda55__ggit_diff_file_callback (GgitDiffDelta* delta, gfloat progress, gpointer self) {
	gint result;
	result = ___lambda55_ (self, delta, progress);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1465 "gitg-diff-view.c"
}


static gint ___lambda56_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffBinary* binary) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
#line 404 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 404 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 404 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (binary != NULL, 0);
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data6_->cancellable;
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 1484 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data6_->cancellable;
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 1493 "gitg-diff-view.c"
	} else {
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 1497 "gitg-diff-view.c"
	}
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1505 "gitg-diff-view.c"
	}
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 411 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1511 "gitg-diff-view.c"
}


static gint ____lambda56__ggit_diff_binary_callback (GgitDiffDelta* delta, GgitDiffBinary* binary, gpointer self) {
	gint result;
	result = ___lambda56_ (self, delta, binary);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1520 "gitg-diff-view.c"
}


static gpointer _ggit_diff_hunk_ref0 (gpointer self) {
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return self ? ggit_diff_hunk_ref (self) : NULL;
#line 1527 "gitg-diff-view.c"
}


static gint ___lambda57_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffHunk* hunk) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GgitDiffHunk* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GgitDiffHunk* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GgitDiffHunk* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GgitDiffHunk* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GgitDiffHunk* _tmp14_ = NULL;
	GgitDiffHunk* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
#line 414 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 414 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 414 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (hunk != NULL, 0);
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data6_->cancellable;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 1559 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data6_->cancellable;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 1568 "gitg-diff-view.c"
	} else {
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 1572 "gitg-diff-view.c"
	}
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1580 "gitg-diff-view.c"
	}
#line 420 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = hunk;
#line 420 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = ggit_diff_hunk_get_old_start (_tmp4_);
#line 420 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = hunk;
#line 420 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = ggit_diff_hunk_get_old_lines (_tmp6_);
#line 420 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = MAX (_data6_->maxlines, _tmp5_ + _tmp7_);
#line 420 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->maxlines = _tmp8_;
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = hunk;
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = ggit_diff_hunk_get_new_start (_tmp9_);
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = hunk;
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp12_ = ggit_diff_hunk_get_new_lines (_tmp11_);
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = MAX (_data6_->maxlines, _tmp10_ + _tmp12_);
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->maxlines = _tmp13_;
#line 423 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk (_data6_->add_hunk_target);
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp14_ = hunk;
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp15_ = _ggit_diff_hunk_ref0 (_tmp14_);
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_ggit_diff_hunk_unref0 (_data6_->current_hunk);
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_hunk = _tmp15_;
#line 426 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp16_ = gee_array_list_new (ggit_diff_line_get_type (), (GBoxedCopyFunc) ggit_diff_line_ref, ggit_diff_line_unref, NULL, NULL, NULL);
#line 426 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data6_->current_lines);
#line 426 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_lines = _tmp16_;
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1626 "gitg-diff-view.c"
}


static gint ____lambda57__ggit_diff_hunk_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, gpointer self) {
	gint result;
	result = ___lambda57_ (self, delta, hunk);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1635 "gitg-diff-view.c"
}


static gint ___lambda58_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GgitDiffDelta* _tmp4_ = NULL;
	GgitDiffFlag _tmp5_ = 0;
#line 431 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 431 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 431 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (hunk != NULL, 0);
#line 431 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (line != NULL, 0);
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data6_->cancellable;
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 1658 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data6_->cancellable;
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 1667 "gitg-diff-view.c"
	} else {
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 1671 "gitg-diff-view.c"
	}
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 434 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 434 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1679 "gitg-diff-view.c"
	}
#line 437 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = delta;
#line 437 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = ggit_diff_delta_get_flags (_tmp4_);
#line 437 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if ((_tmp5_ & GGIT_DIFF_FLAG_BINARY) == 0) {
#line 1687 "gitg-diff-view.c"
		GgitDiffLine* _tmp6_ = NULL;
#line 439 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = line;
#line 439 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data6_->current_lines, _tmp6_);
#line 1693 "gitg-diff-view.c"
	}
#line 442 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 442 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1699 "gitg-diff-view.c"
}


static gint ____lambda58__ggit_diff_line_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line, gpointer self) {
	gint result;
	result = ___lambda58_ (self, delta, hunk, line);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1708 "gitg-diff-view.c"
}


static void _gitg_diff_view_auto_update_expanded_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 497 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_auto_update_expanded ((GitgDiffView*) self);
#line 1715 "gitg-diff-view.c"
}


static void gitg_diff_view_update_diff (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GCancellable* cancellable) {
	Block6Data* _data6_;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GList* file_widgets = NULL;
	GtkGrid* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GeeHashSet* was_expanded = NULL;
	GeeHashSet* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	gboolean _tmp21_ = FALSE;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	GitgDiffViewCommitDetails* _tmp25_ = NULL;
	GitgDiffViewCommitDetails* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GError * _inner_error_ = NULL;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (diff != NULL);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->_ref_count_ = 1;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->self = g_object_ref (self);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = cancellable;
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data6_->cancellable);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->cancellable = _tmp1_;
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = gee_array_list_new (GITG_TYPE_DIFF_VIEW_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->files = _tmp2_;
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_file = NULL;
#line 358 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_hunk = NULL;
#line 359 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_lines = NULL;
#line 361 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->maxlines = 0;
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk = ___lambda53__gitg_diff_view_anon;
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk_target = block6_data_ref (_data6_);
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk_target_destroy_notify = block6_data_unref;
#line 373 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_file = ___lambda54__gitg_diff_view_anon;
#line 373 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_file_target = block6_data_ref (_data6_);
#line 373 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_file_target_destroy_notify = block6_data_unref;
#line 1780 "gitg-diff-view.c"
	{
		GgitDiff* _tmp3_ = NULL;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = diff;
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_foreach (_tmp3_, ____lambda55__ggit_diff_file_callback, ____lambda56__ggit_diff_binary_callback, ____lambda57__ggit_diff_hunk_callback, ____lambda58__ggit_diff_line_callback, _data6_, &_inner_error_);
#line 389 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1789 "gitg-diff-view.c"
			goto __catch33_g_error;
		}
	}
	goto __finally33;
	__catch33_g_error:
	{
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_clear_error (&_inner_error_);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_inner_error_ = NULL;
#line 1800 "gitg-diff-view.c"
	}
	__finally33:
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		block6_data_unref (_data6_);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_data6_ = NULL;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_clear_error (&_inner_error_);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 1815 "gitg-diff-view.c"
	}
#line 447 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk (_data6_->add_hunk_target);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_file (_data6_->add_file_target);
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->d_grid_files;
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
#line 450 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	file_widgets = _tmp5_;
#line 451 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 451 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	was_expanded = _tmp6_;
#line 453 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = file_widgets;
#line 1833 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 453 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp7_;
#line 453 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 1841 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 453 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 1845 "gitg-diff-view.c"
			{
				GitgDiffViewFile* f = NULL;
				GtkWidget* _tmp8_ = NULL;
				GitgDiffViewFile* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				GitgDiffViewFile* _tmp20_ = NULL;
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp8_ = file;
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp8_) : NULL);
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				f = _tmp9_;
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp11_ = preserve_expanded;
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp11_) {
#line 1863 "gitg-diff-view.c"
					GitgDiffViewFile* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp12_ = f;
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp13_ = gitg_diff_view_file_get_expanded (_tmp12_);
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp14_ = _tmp13_;
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp10_ = _tmp14_;
#line 1875 "gitg-diff-view.c"
				} else {
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp10_ = FALSE;
#line 1879 "gitg-diff-view.c"
				}
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp10_) {
#line 1883 "gitg-diff-view.c"
					gchar* path = NULL;
					GitgDiffViewFile* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp15_ = f;
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp16_ = gitg_diff_view_primary_path (self, _tmp15_);
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					path = _tmp16_;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp17_ = path;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					if (_tmp17_ != NULL) {
#line 1898 "gitg-diff-view.c"
						GeeHashSet* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
#line 463 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp18_ = was_expanded;
#line 463 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp19_ = path;
#line 463 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
#line 1907 "gitg-diff-view.c"
					}
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_free0 (path);
#line 1911 "gitg-diff-view.c"
				}
#line 467 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp20_ = f;
#line 467 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gtk_widget_destroy ((GtkWidget*) _tmp20_);
#line 453 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (f);
#line 1919 "gitg-diff-view.c"
			}
		}
	}
#line 470 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp22_ = gee_abstract_collection_get_size ((GeeCollection*) _data6_->files);
#line 470 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp23_ = _tmp22_;
#line 470 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp23_ <= 1) {
#line 470 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = TRUE;
#line 1931 "gitg-diff-view.c"
	} else {
		gboolean _tmp24_ = FALSE;
#line 470 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp24_ = self->priv->_default_collapse_all;
#line 470 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = !_tmp24_;
#line 1938 "gitg-diff-view.c"
	}
#line 470 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp25_ = self->priv->d_commit_details;
#line 470 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expanded (_tmp25_, _tmp21_);
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp26_ = self->priv->d_commit_details;
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _data6_->files);
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp28_ = _tmp27_;
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expander_visible (_tmp26_, _tmp28_ > 1);
#line 1952 "gitg-diff-view.c"
	{
		gint i = 0;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		i = 0;
#line 1957 "gitg-diff-view.c"
		{
			gboolean _tmp29_ = FALSE;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp29_ = TRUE;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			while (TRUE) {
#line 1964 "gitg-diff-view.c"
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				GitgDiffViewFile* file = NULL;
				gint _tmp34_ = 0;
				gpointer _tmp35_ = NULL;
				gchar* path = NULL;
				GitgDiffViewFile* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gboolean _tmp38_ = FALSE;
				GitgDiffViewCommitDetails* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
				gboolean _tmp41_ = FALSE;
				GitgDiffViewFile* _tmp47_ = NULL;
				GitgDiffViewFileRendererText* renderer_text = NULL;
				GitgDiffViewFile* _tmp48_ = NULL;
				GitgDiffViewFileRenderer* _tmp49_ = NULL;
				GitgDiffViewFileRenderer* _tmp50_ = NULL;
				GitgDiffViewFileRendererText* _tmp51_ = NULL;
				GitgDiffViewFileRendererText* _tmp52_ = NULL;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
				GtkGrid* _tmp60_ = NULL;
				GitgDiffViewFile* _tmp61_ = NULL;
				GitgDiffViewFile* _tmp62_ = NULL;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp29_) {
#line 1993 "gitg-diff-view.c"
					gint _tmp30_ = 0;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp30_ = i;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					i = _tmp30_ + 1;
#line 1999 "gitg-diff-view.c"
				}
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp29_ = FALSE;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp31_ = i;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp32_ = gee_abstract_collection_get_size ((GeeCollection*) _data6_->files);
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp33_ = _tmp32_;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!(_tmp31_ < _tmp33_)) {
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					break;
#line 2013 "gitg-diff-view.c"
				}
#line 475 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp34_ = i;
#line 475 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _data6_->files, _tmp34_);
#line 475 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				file = (GitgDiffViewFile*) _tmp35_;
#line 476 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp36_ = file;
#line 476 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp37_ = gitg_diff_view_primary_path (self, _tmp36_);
#line 476 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				path = _tmp37_;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp39_ = self->priv->d_commit_details;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp40_ = gitg_diff_view_commit_details_get_expanded (_tmp39_);
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp41_ = _tmp40_;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp41_) {
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp38_ = TRUE;
#line 2037 "gitg-diff-view.c"
				} else {
					gboolean _tmp42_ = FALSE;
					const gchar* _tmp43_ = NULL;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp43_ = path;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					if (_tmp43_ != NULL) {
#line 2045 "gitg-diff-view.c"
						GeeHashSet* _tmp44_ = NULL;
						const gchar* _tmp45_ = NULL;
						gboolean _tmp46_ = FALSE;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp44_ = was_expanded;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp45_ = path;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp46_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp44_, _tmp45_);
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp42_ = _tmp46_;
#line 2057 "gitg-diff-view.c"
					} else {
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
						_tmp42_ = FALSE;
#line 2061 "gitg-diff-view.c"
					}
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp38_ = _tmp42_;
#line 2065 "gitg-diff-view.c"
				}
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp47_ = file;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gitg_diff_view_file_set_expanded (_tmp47_, _tmp38_);
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp48_ = file;
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp49_ = gitg_diff_view_file_get_renderer (_tmp48_);
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp50_ = _tmp49_;
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp51_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT) ? ((GitgDiffViewFileRendererText*) _tmp50_) : NULL;
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp51_ == NULL) {
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp50_);
#line 2083 "gitg-diff-view.c"
				}
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				renderer_text = _tmp51_;
#line 482 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp52_ = renderer_text;
#line 482 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp52_ != NULL) {
#line 2091 "gitg-diff-view.c"
					GitgDiffViewFileRendererText* _tmp53_ = NULL;
					GitgDiffViewFileRendererText* _tmp54_ = NULL;
					GitgDiffViewFileRendererText* _tmp55_ = NULL;
#line 484 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp53_ = renderer_text;
#line 484 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					gitg_diff_view_file_renderer_text_set_maxlines (_tmp53_, _data6_->maxlines);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp54_ = renderer_text;
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_object_bind_property_with_closures ((GObject*) self, "wrap-lines", (GObject*) _tmp54_, "wrap-lines", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 487 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp55_ = renderer_text;
#line 487 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_object_bind_property_with_closures ((GObject*) self, "tab-width", (GObject*) _tmp55_, "tab-width", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 2107 "gitg-diff-view.c"
				}
#line 490 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp56_ = i;
#line 490 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp57_ = gee_abstract_collection_get_size ((GeeCollection*) _data6_->files);
#line 490 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp58_ = _tmp57_;
#line 490 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp56_ == (_tmp58_ - 1)) {
#line 2117 "gitg-diff-view.c"
					GitgDiffViewFile* _tmp59_ = NULL;
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp59_ = file;
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					gtk_widget_set_vexpand ((GtkWidget*) _tmp59_, TRUE);
#line 2123 "gitg-diff-view.c"
				}
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp60_ = self->priv->d_grid_files;
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp61_ = file;
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp61_);
#line 497 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp62_ = file;
#line 497 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				g_signal_connect_object ((GObject*) _tmp62_, "notify::expanded", (GCallback) _gitg_diff_view_auto_update_expanded_g_object_notify, self, 0);
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (renderer_text);
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_free0 (path);
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (file);
#line 2141 "gitg-diff-view.c"
			}
		}
	}
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (was_expanded);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_list_free0 (file_widgets);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	block6_data_unref (_data6_);
#line 353 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_data6_ = NULL;
#line 2153 "gitg-diff-view.c"
}


static void gitg_diff_view_auto_update_expanded (GitgDiffView* self) {
	GtkGrid* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_grid_files;
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 2166 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp1_;
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 2174 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 2178 "gitg-diff-view.c"
			{
				GtkWidget* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp2_ = file;
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = gitg_diff_view_file_get_expanded (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp2_) : NULL);
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = _tmp3_;
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp4_) {
#line 507 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					gitg_diff_view_auto_change_expanded (self, FALSE);
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_list_free0 (file_collection);
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					return;
#line 2197 "gitg-diff-view.c"
				}
			}
		}
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 2203 "gitg-diff-view.c"
	}
#line 512 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_auto_change_expanded (self, TRUE);
#line 2207 "gitg-diff-view.c"
}


static gboolean ___lambda59_ (GitgDiffView* self) {
	gboolean result = FALSE;
	GtkRevealer* _tmp0_ = NULL;
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_reveal_options_timeout = (guint) 0;
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_revealer_options;
#line 565 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
#line 566 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 566 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2224 "gitg-diff-view.c"
}


static gboolean ____lambda59__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda59_ ((GitgDiffView*) self);
#line 563 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2233 "gitg-diff-view.c"
}


static gboolean _____lambda60_ (GitgDiffView* self) {
	gboolean result = FALSE;
	GtkRevealer* _tmp0_ = NULL;
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_unreveal_options_timeout = (guint) 0;
#line 583 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_revealer_options;
#line 583 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2250 "gitg-diff-view.c"
}


static gboolean ______lambda60__gsource_func (gpointer self) {
	gboolean result;
	result = _____lambda60_ ((GitgDiffView*) self);
#line 581 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2259 "gitg-diff-view.c"
}


static void gitg_diff_view_update_hide_show_options (GitgDiffView* self, GdkWindow* window, gint ex, gint ey) {
	void* data = NULL;
	GdkWindow* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	GtkWidget* w = NULL;
	void* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp5_ = NULL;
	GtkEventBox* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GtkAllocation alloc = {0};
	GtkAllocation revealer_alloc = {0};
	GtkEventBox* _tmp11_ = NULL;
	GtkAllocation _tmp12_ = {0};
	GtkRevealer* _tmp13_ = NULL;
	GtkAllocation _tmp14_ = {0};
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	GtkRevealer* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
#line 535 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 535 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (window != NULL);
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = window;
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gdk_window_get_user_data (_tmp0_, &_tmp1_);
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	data = _tmp1_;
#line 540 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = data;
#line 540 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp2_) : NULL);
#line 540 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	w = _tmp3_;
#line 542 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = w;
#line 542 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp4_ == NULL) {
#line 544 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (w);
#line 544 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 2315 "gitg-diff-view.c"
	}
#line 548 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = w;
#line 548 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_event_box;
#line 548 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = ex;
#line 548 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = ey;
#line 548 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_translate_coordinates (_tmp5_, (GtkWidget*) _tmp6_, _tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
#line 548 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	x = _tmp9_;
#line 548 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	y = _tmp10_;
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = self->priv->d_event_box;
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp11_, &_tmp12_);
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	alloc = _tmp12_;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = self->priv->d_revealer_options;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp13_, &_tmp14_);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	revealer_alloc = _tmp14_;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp18_ = self->priv->d_revealer_options;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp19_ = gtk_revealer_get_reveal_child (_tmp18_);
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp20_ = _tmp19_;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (!_tmp20_) {
#line 2351 "gitg-diff-view.c"
		gint _tmp21_ = 0;
		GtkAllocation _tmp22_ = {0};
		gint _tmp23_ = 0;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = y;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp22_ = alloc;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp23_ = _tmp22_.height;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = _tmp21_ >= (_tmp23_ - 18);
#line 2363 "gitg-diff-view.c"
	} else {
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = FALSE;
#line 2367 "gitg-diff-view.c"
	}
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp17_) {
#line 2371 "gitg-diff-view.c"
		gint _tmp24_ = 0;
		GtkAllocation _tmp25_ = {0};
		gint _tmp26_ = 0;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp24_ = x;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp25_ = alloc;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp26_ = _tmp25_.width;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = _tmp24_ >= (_tmp26_ - 150);
#line 2383 "gitg-diff-view.c"
	} else {
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = FALSE;
#line 2387 "gitg-diff-view.c"
	}
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp16_) {
#line 2391 "gitg-diff-view.c"
		guint _tmp27_ = 0U;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp27_ = self->priv->d_reveal_options_timeout;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = _tmp27_ == ((guint) 0);
#line 2397 "gitg-diff-view.c"
	} else {
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = FALSE;
#line 2401 "gitg-diff-view.c"
	}
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp15_) {
#line 2405 "gitg-diff-view.c"
		guint _tmp28_ = 0U;
		guint _tmp30_ = 0U;
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp28_ = self->priv->d_unreveal_options_timeout;
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp28_ != ((guint) 0)) {
#line 2412 "gitg-diff-view.c"
			guint _tmp29_ = 0U;
#line 559 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp29_ = self->priv->d_unreveal_options_timeout;
#line 559 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			g_source_remove (_tmp29_);
#line 560 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			self->priv->d_unreveal_options_timeout = (guint) 0;
#line 2420 "gitg-diff-view.c"
		}
#line 563 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp30_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, ____lambda59__gsource_func, g_object_ref (self), g_object_unref);
#line 563 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_reveal_options_timeout = _tmp30_;
#line 2426 "gitg-diff-view.c"
	} else {
		GtkRevealer* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
#line 569 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp31_ = self->priv->d_revealer_options;
#line 569 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp32_ = gtk_revealer_get_reveal_child (_tmp31_);
#line 569 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp33_ = _tmp32_;
#line 569 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp33_) {
#line 2439 "gitg-diff-view.c"
			gboolean above = FALSE;
			gint _tmp34_ = 0;
			GtkAllocation _tmp35_ = {0};
			gint _tmp36_ = 0;
			GtkAllocation _tmp37_ = {0};
			gint _tmp38_ = 0;
			gboolean _tmp39_ = FALSE;
			gboolean _tmp40_ = FALSE;
#line 571 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp34_ = y;
#line 571 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp35_ = alloc;
#line 571 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp36_ = _tmp35_.height;
#line 571 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp37_ = revealer_alloc;
#line 571 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp38_ = _tmp37_.height;
#line 571 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			above = _tmp34_ <= ((_tmp36_ - 6) - _tmp38_);
#line 573 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			_tmp40_ = above;
#line 573 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			if (_tmp40_) {
#line 2464 "gitg-diff-view.c"
				guint _tmp41_ = 0U;
#line 573 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp41_ = self->priv->d_unreveal_options_timeout;
#line 573 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp39_ = _tmp41_ == ((guint) 0);
#line 2470 "gitg-diff-view.c"
			} else {
#line 573 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp39_ = FALSE;
#line 2474 "gitg-diff-view.c"
			}
#line 573 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			if (_tmp39_) {
#line 2478 "gitg-diff-view.c"
				guint _tmp42_ = 0U;
				guint _tmp44_ = 0U;
#line 575 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp42_ = self->priv->d_reveal_options_timeout;
#line 575 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp42_ != ((guint) 0)) {
#line 2485 "gitg-diff-view.c"
					guint _tmp43_ = 0U;
#line 577 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp43_ = self->priv->d_reveal_options_timeout;
#line 577 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_source_remove (_tmp43_);
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					self->priv->d_reveal_options_timeout = (guint) 0;
#line 2493 "gitg-diff-view.c"
				}
#line 581 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp44_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ______lambda60__gsource_func, g_object_ref (self), g_object_unref);
#line 581 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				self->priv->d_unreveal_options_timeout = _tmp44_;
#line 2499 "gitg-diff-view.c"
			} else {
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_ = FALSE;
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp46_ = above;
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp46_) {
#line 2507 "gitg-diff-view.c"
					guint _tmp47_ = 0U;
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp47_ = self->priv->d_unreveal_options_timeout;
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp45_ = _tmp47_ != ((guint) 0);
#line 2513 "gitg-diff-view.c"
				} else {
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp45_ = FALSE;
#line 2517 "gitg-diff-view.c"
				}
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp45_) {
#line 2521 "gitg-diff-view.c"
					guint _tmp48_ = 0U;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp48_ = self->priv->d_unreveal_options_timeout;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					g_source_remove (_tmp48_);
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					self->priv->d_unreveal_options_timeout = (guint) 0;
#line 2529 "gitg-diff-view.c"
				}
			}
		}
	}
#line 535 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (w);
#line 2536 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_leave_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event) {
	gboolean result = FALSE;
	GdkEventCrossing* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventCrossing* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventCrossing* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 596 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 596 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 596 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 599 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 599 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2572 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_leave_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2581 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_enter_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event) {
	gboolean result = FALSE;
	GdkEventCrossing* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventCrossing* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventCrossing* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 605 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 605 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 605 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 605 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 605 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 605 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 605 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2617 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_enter_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2626 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_motion_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventMotion* event) {
	gboolean result = FALSE;
	GdkEventMotion* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventMotion* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventMotion* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 610 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 610 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 610 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 612 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 612 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 612 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 612 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 612 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 612 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 612 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2662 "gitg-diff-view.c"
}


GitgDiffView* gitg_diff_view_construct (GType object_type) {
	GitgDiffView * self = NULL;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = (GitgDiffView*) g_object_new (object_type, NULL);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return self;
#line 2672 "gitg-diff-view.c"
}


GitgDiffView* gitg_diff_view_new (void) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return gitg_diff_view_construct (GITG_TYPE_DIFF_VIEW);
#line 2679 "gitg-diff-view.c"
}


GgitDiffOptions* gitg_diff_view_get_options (GitgDiffView* self) {
	GgitDiffOptions* result;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp2_ = NULL;
#line 57 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_options;
#line 59 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ == NULL) {
#line 2693 "gitg-diff-view.c"
		GgitDiffOptions* _tmp1_ = NULL;
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = ggit_diff_options_new ();
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_options);
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_options = _tmp1_;
#line 2701 "gitg-diff-view.c"
	}
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_options;
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp2_;
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2709 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_has_selection (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_has_selection;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2724 "gitg-diff-view.c"
}


static void gitg_diff_view_set_has_selection (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_has_selection = _tmp0_;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "has-selection");
#line 2738 "gitg-diff-view.c"
}


GgitDiff* gitg_diff_view_get_diff (GitgDiffView* self) {
	GgitDiff* result;
	GgitDiff* _tmp0_ = NULL;
#line 75 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_diff;
#line 75 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 75 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2753 "gitg-diff-view.c"
}


void gitg_diff_view_set_diff (GitgDiffView* self, GgitDiff* value) {
	GgitDiff* _tmp0_ = NULL;
	GgitDiff* _tmp1_ = NULL;
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_diff;
#line 78 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 78 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 2768 "gitg-diff-view.c"
		GgitDiff* _tmp2_ = NULL;
		GgitDiff* _tmp3_ = NULL;
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = _tmp3_;
#line 81 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_commit);
#line 81 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_commit = NULL;
#line 2783 "gitg-diff-view.c"
	}
#line 84 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "diff");
#line 2789 "gitg-diff-view.c"
}


GitgCommit* gitg_diff_view_get_commit (GitgDiffView* self) {
	GitgCommit* result;
	GitgCommit* _tmp0_ = NULL;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 90 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2804 "gitg-diff-view.c"
}


void gitg_diff_view_set_commit (GitgDiffView* self, GitgCommit* value) {
	GitgCommit* _tmp0_ = NULL;
	GitgCommit* _tmp1_ = NULL;
#line 91 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 2819 "gitg-diff-view.c"
		GitgCommit* _tmp2_ = NULL;
		GitgCommit* _tmp3_ = NULL;
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_commit);
#line 95 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_commit = _tmp3_;
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = NULL;
#line 2834 "gitg-diff-view.c"
	}
#line 99 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 91 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "commit");
#line 2840 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_wrap_lines (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_wrap_lines;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2855 "gitg-diff-view.c"
}


void gitg_diff_view_set_wrap_lines (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_wrap_lines = _tmp0_;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "wrap-lines");
#line 2869 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_staged (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_staged;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2884 "gitg-diff-view.c"
}


void gitg_diff_view_set_staged (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_staged = _tmp0_;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "staged");
#line 2898 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_unstaged (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_unstaged;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2913 "gitg-diff-view.c"
}


void gitg_diff_view_set_unstaged (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_unstaged = _tmp0_;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "unstaged");
#line 2927 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_show_parents (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_show_parents;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2942 "gitg-diff-view.c"
}


void gitg_diff_view_set_show_parents (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_show_parents = _tmp0_;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "show-parents");
#line 2956 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_default_collapse_all (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_default_collapse_all;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2971 "gitg-diff-view.c"
}


void gitg_diff_view_set_default_collapse_all (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_default_collapse_all = _tmp0_;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "default-collapse-all");
#line 2985 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_use_gravatar (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_use_gravatar;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3000 "gitg-diff-view.c"
}


void gitg_diff_view_set_use_gravatar (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_use_gravatar = _tmp0_;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "use-gravatar");
#line 3014 "gitg-diff-view.c"
}


gint gitg_diff_view_get_tab_width (GitgDiffView* self) {
	gint result;
	gint _tmp0_ = 0;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_tab_width;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3029 "gitg-diff-view.c"
}


void gitg_diff_view_set_tab_width (GitgDiffView* self, gint value) {
	gint _tmp0_ = 0;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_tab_width = _tmp0_;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "tab-width");
#line 3043 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_handle_selection (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_handle_selection;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3058 "gitg-diff-view.c"
}


void gitg_diff_view_set_handle_selection (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_handle_selection = _tmp0_;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "handle-selection");
#line 3072 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_highlight (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_highlight;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3087 "gitg-diff-view.c"
}


void gitg_diff_view_set_highlight (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_highlight = _tmp0_;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "highlight");
#line 3101 "gitg-diff-view.c"
}


GitgRepository* gitg_diff_view_get_repository (GitgDiffView* self) {
	GitgRepository* result;
	GitgRepository* _tmp0_ = NULL;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_repository;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3116 "gitg-diff-view.c"
}


void gitg_diff_view_set_repository (GitgDiffView* self, GitgRepository* value) {
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->_repository);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_repository = _tmp1_;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "repository");
#line 3135 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_new_is_workdir (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_new_is_workdir;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3150 "gitg-diff-view.c"
}


void gitg_diff_view_set_new_is_workdir (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_new_is_workdir = _tmp0_;
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "new-is-workdir");
#line 3164 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_ignore_whitespace (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 150 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 150 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_flag_get (self, GGIT_DIFF_IGNORE_WHITESPACE);
#line 150 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 150 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3179 "gitg-diff-view.c"
}


void gitg_diff_view_set_ignore_whitespace (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_flag_set (self, GGIT_DIFF_IGNORE_WHITESPACE, _tmp0_);
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "ignore-whitespace");
#line 3193 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_changes_inline (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_changes_inline;
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3208 "gitg-diff-view.c"
}


void gitg_diff_view_set_changes_inline (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 157 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_changes_inline;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 3223 "gitg-diff-view.c"
		gboolean _tmp2_ = FALSE;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_changes_inline = _tmp2_;
#line 3229 "gitg-diff-view.c"
	}
#line 157 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "changes-inline");
#line 3233 "gitg-diff-view.c"
}


gint gitg_diff_view_get_context_lines (GitgDiffView* self) {
	gint result;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_n_context_lines (_tmp1_);
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp3_;
#line 171 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3257 "gitg-diff-view.c"
}


void gitg_diff_view_set_context_lines (GitgDiffView* self, gint value) {
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_n_context_lines (_tmp1_);
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = value;
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp3_ != _tmp4_) {
#line 3281 "gitg-diff-view.c"
		GgitDiffOptions* _tmp5_ = NULL;
		GgitDiffOptions* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		GgitDiffOptions* _tmp8_ = NULL;
		GgitDiffOptions* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = gitg_diff_view_get_options (self);
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = _tmp5_;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = value;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_n_context_lines (_tmp6_, _tmp7_);
#line 178 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = gitg_diff_view_get_options (self);
#line 178 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = _tmp8_;
#line 178 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = value;
#line 178 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_n_interhunk_lines (_tmp9_, _tmp10_);
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_signal_emit_by_name (self, "options-changed");
#line 3306 "gitg-diff-view.c"
	}
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "context-lines");
#line 3310 "gitg-diff-view.c"
}


static void _vala_array_add2 (GitgPatchSet*** array, int* length, int* size, GitgPatchSet* value) {
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if ((*length) == (*size)) {
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		*array = g_renew (GitgPatchSet*, *array, (*size) + 1);
#line 3321 "gitg-diff-view.c"
	}
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	(*array)[(*length)++] = value;
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	(*array)[*length] = NULL;
#line 3327 "gitg-diff-view.c"
}


GitgPatchSet** gitg_diff_view_get_selection (GitgDiffView* self, int* result_length1) {
	GitgPatchSet** result;
	GitgPatchSet** ret = NULL;
	GitgPatchSet** _tmp0_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GtkGrid* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GitgPatchSet** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
#line 517 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = g_new0 (GitgPatchSet*, 0 + 1);
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	ret = _tmp0_;
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	ret_length1 = 0;
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_ret_size_ = ret_length1;
#line 521 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_grid_files;
#line 521 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
#line 3355 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 521 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp2_;
#line 521 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 3363 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 521 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 3367 "gitg-diff-view.c"
			{
				GitgDiffSelectable* sel = NULL;
				GtkWidget* _tmp3_ = NULL;
				GitgDiffViewFileRenderer* _tmp4_ = NULL;
				GitgDiffViewFileRenderer* _tmp5_ = NULL;
				GitgDiffSelectable* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				GitgDiffSelectable* _tmp9_ = NULL;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = file;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = gitg_diff_view_file_get_renderer (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp3_) : NULL);
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = _tmp4_;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_DIFF_SELECTABLE) ? ((GitgDiffSelectable*) _tmp5_) : NULL;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp6_ == NULL) {
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp5_);
#line 3389 "gitg-diff-view.c"
				}
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				sel = _tmp6_;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_tmp9_ = sel;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp9_ != NULL) {
#line 3397 "gitg-diff-view.c"
					GitgDiffSelectable* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp10_ = sel;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp11_ = gitg_diff_selectable_get_has_selection (_tmp10_);
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp12_ = _tmp11_;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp8_ = _tmp12_;
#line 3409 "gitg-diff-view.c"
				} else {
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp8_ = FALSE;
#line 3413 "gitg-diff-view.c"
				}
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp8_) {
#line 3417 "gitg-diff-view.c"
					GitgDiffSelectable* _tmp13_ = NULL;
					GitgPatchSet* _tmp14_ = NULL;
					GitgPatchSet* _tmp15_ = NULL;
					GitgPatchSet* _tmp16_ = NULL;
					GitgPatchSetPatch* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp13_ = sel;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp14_ = gitg_diff_selectable_get_selection (_tmp13_);
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp15_ = _tmp14_;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp16_ = _tmp15_;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp17_ = _tmp16_->patches;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp17__length1 = _tmp16_->patches_length1;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp7_ = _tmp17__length1 != 0;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_gitg_patch_set_unref0 (_tmp16_);
#line 3440 "gitg-diff-view.c"
				} else {
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp7_ = FALSE;
#line 3444 "gitg-diff-view.c"
				}
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp7_) {
#line 3448 "gitg-diff-view.c"
					GitgPatchSet** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					GitgDiffSelectable* _tmp19_ = NULL;
					GitgPatchSet* _tmp20_ = NULL;
					GitgPatchSet* _tmp21_ = NULL;
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp18_ = ret;
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp18__length1 = ret_length1;
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp19_ = sel;
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp20_ = gitg_diff_selectable_get_selection (_tmp19_);
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_tmp21_ = _tmp20_;
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
					_vala_array_add2 (&ret, &ret_length1, &_ret_size_, _tmp21_);
#line 3466 "gitg-diff-view.c"
				}
#line 521 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (sel);
#line 3470 "gitg-diff-view.c"
			}
		}
#line 521 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 3475 "gitg-diff-view.c"
	}
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp22_ = ret;
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp22__length1 = ret_length1;
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (result_length1) {
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		*result_length1 = _tmp22__length1;
#line 3485 "gitg-diff-view.c"
	}
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp22_;
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3491 "gitg-diff-view.c"
}


static void gitg_diff_view_real_options_changed (GitgDiffView* self) {
	GitgCommit* _tmp0_ = NULL;
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 105 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != NULL) {
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_update (self, TRUE);
#line 3503 "gitg-diff-view.c"
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1412 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1413 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	result = self;
#line 1413 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 3516 "gitg-diff-view.c"
}


static void gitg_diff_view_class_init (GitgDiffViewClass * klass) {
	gint GitgDiffView_private_offset;
	GError * _inner_error_ = NULL;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_type_class_add_private (klass, sizeof (GitgDiffViewPrivate));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	((GObjectClass *) klass)->constructed = gitg_diff_view_real_constructed;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	((GObjectClass *) klass)->dispose = gitg_diff_view_real_dispose;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	((GitgDiffViewClass *) klass)->options_changed = gitg_diff_view_real_options_changed;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_view_get_property;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_view_set_property;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_view_finalize;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_OPTIONS, g_param_spec_object ("options", "options", "options", ggit_diff_options_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HAS_SELECTION, g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_DIFF, g_param_spec_object ("diff", "diff", "diff", ggit_diff_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_COMMIT, g_param_spec_object ("commit", "commit", "commit", GITG_TYPE_COMMIT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_WRAP_LINES, g_param_spec_boolean ("wrap-lines", "wrap-lines", "wrap-lines", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_STAGED, g_param_spec_boolean ("staged", "staged", "staged", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_UNSTAGED, g_param_spec_boolean ("unstaged", "unstaged", "unstaged", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_SHOW_PARENTS, g_param_spec_boolean ("show-parents", "show-parents", "show-parents", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL, g_param_spec_boolean ("default-collapse-all", "default-collapse-all", "default-collapse-all", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_USE_GRAVATAR, g_param_spec_boolean ("use-gravatar", "use-gravatar", "use-gravatar", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_TAB_WIDTH, g_param_spec_int ("tab-width", "tab-width", "tab-width", G_MININT, G_MAXINT, 4, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HANDLE_SELECTION, g_param_spec_boolean ("handle-selection", "handle-selection", "handle-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HIGHLIGHT, g_param_spec_boolean ("highlight", "highlight", "highlight", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_REPOSITORY, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_NEW_IS_WORKDIR, g_param_spec_boolean ("new-is-workdir", "new-is-workdir", "new-is-workdir", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_IGNORE_WHITESPACE, g_param_spec_boolean ("ignore-whitespace", "ignore-whitespace", "ignore-whitespace", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_CHANGES_INLINE, g_param_spec_boolean ("changes-inline", "changes-inline", "changes-inline", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_CONTEXT_LINES, g_param_spec_int ("context-lines", "context-lines", "context-lines", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	GitgDiffView_private_offset = g_type_class_get_instance_private_offset (klass);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-diff-view.ui");
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_signal_new ("options_changed", GITG_TYPE_DIFF_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgDiffViewClass, options_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "commit_details", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_commit_details));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scrolledwindow", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_scrolledwindow));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_files", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_grid_files));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "event_box", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_event_box));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer_options", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_revealer_options));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "diff_view_options", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_diff_view_options));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_view_message", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_text_view_message));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "leave_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "enter_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "motion_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event));
#line 3601 "gitg-diff-view.c"
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = g_regex_new (".*[\\R\\s]*(?P<message>(?:.|\\R)*?)\\s*$", 0, 0, &_inner_error_);
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp1_;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3612 "gitg-diff-view.c"
			goto __catch34_g_error;
		}
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _tmp0_;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = NULL;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_regex_unref0 (gitg_diff_view_s_message_regexp);
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_s_message_regexp = _tmp2_;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_regex_unref0 (_tmp0_);
#line 3625 "gitg-diff-view.c"
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* e = NULL;
		FILE* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		e = _inner_error_;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_inner_error_ = NULL;
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = stderr;
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp4_ = e;
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = _tmp4_->message;
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = string_to_string (_tmp5_);
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = g_strconcat ("Failed to compile regex: ", _tmp6_, "\n", NULL);
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = _tmp7_;
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		fprintf (_tmp3_, "%s", _tmp8_);
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (_tmp8_);
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		_g_error_free0 (e);
#line 3659 "gitg-diff-view.c"
	}
	__finally34:
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_clear_error (&_inner_error_);
#line 3668 "gitg-diff-view.c"
	}
}


static void gitg_diff_view_instance_init (GitgDiffView * self) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv = GITG_DIFF_VIEW_GET_PRIVATE (self);
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_wrap_lines = TRUE;
#line 112 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_staged = FALSE;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_unstaged = FALSE;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_show_parents = FALSE;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_default_collapse_all = TRUE;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_use_gravatar = TRUE;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_tab_width = 4;
#line 118 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_handle_selection = FALSE;
#line 119 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_highlight = TRUE;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_type_ensure (GITG_TYPE_DIFF_VIEW_OPTIONS);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	g_type_ensure (GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3700 "gitg-diff-view.c"
}


static void gitg_diff_view_finalize (GObject* obj) {
	GitgDiffView * self;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 24 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_commit_details);
#line 27 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_scrolledwindow);
#line 30 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_grid_files);
#line 33 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_event_box);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_revealer_options);
#line 39 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_diff_view_options);
#line 42 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_text_view_message);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_diff);
#line 45 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_commit);
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_options);
#line 47 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_cancellable);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->_repository);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (gitg_diff_view_parent_class)->finalize (obj);
#line 3734 "gitg-diff-view.c"
}


GType gitg_diff_view_get_type (void) {
	static volatile gsize gitg_diff_view_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_diff_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgDiffViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffView), 0, (GInstanceInitFunc) gitg_diff_view_instance_init, NULL };
		GType gitg_diff_view_type_id;
		gitg_diff_view_type_id = g_type_register_static (gtk_grid_get_type (), "GitgDiffView", &g_define_type_info, 0);
		g_once_init_leave (&gitg_diff_view_type_id__volatile, gitg_diff_view_type_id);
	}
	return gitg_diff_view_type_id__volatile;
}


static void _vala_gitg_diff_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgDiffView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	switch (property_id) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_OPTIONS:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_options (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HAS_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_has_selection (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DIFF:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_diff (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_COMMIT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_commit (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_WRAP_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_wrap_lines (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_STAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_staged (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_UNSTAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_unstaged (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_SHOW_PARENTS:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_show_parents (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_default_collapse_all (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_USE_GRAVATAR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_use_gravatar (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_TAB_WIDTH:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_int (value, gitg_diff_view_get_tab_width (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HANDLE_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_handle_selection (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HIGHLIGHT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_highlight (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_REPOSITORY:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_repository (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_NEW_IS_WORKDIR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_new_is_workdir (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_IGNORE_WHITESPACE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_ignore_whitespace (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CHANGES_INLINE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_changes_inline (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CONTEXT_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_int (value, gitg_diff_view_get_context_lines (self));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 3863 "gitg-diff-view.c"
		default:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 3869 "gitg-diff-view.c"
	}
}


static void _vala_gitg_diff_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgDiffView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
	switch (property_id) {
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HAS_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_has_selection (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DIFF:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_diff (self, g_value_get_object (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_COMMIT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_commit (self, g_value_get_object (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_WRAP_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_wrap_lines (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_STAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_staged (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_UNSTAGED:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_unstaged (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_SHOW_PARENTS:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_show_parents (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_default_collapse_all (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_USE_GRAVATAR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_use_gravatar (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_TAB_WIDTH:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_tab_width (self, g_value_get_int (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HANDLE_SELECTION:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_handle_selection (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HIGHLIGHT:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_highlight (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_REPOSITORY:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_repository (self, g_value_get_object (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_NEW_IS_WORKDIR:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_new_is_workdir (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_IGNORE_WHITESPACE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_ignore_whitespace (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CHANGES_INLINE:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_changes_inline (self, g_value_get_boolean (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CONTEXT_LINES:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_context_lines (self, g_value_get_int (value));
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 3981 "gitg-diff-view.c"
		default:
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/home/jesse/dev/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 3987 "gitg-diff-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



