/* gitg-ref.c generated by valac 0.23.1.3-23cc3-dirty, the Vala compiler
 * generated from gitg-ref.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgit2-glib/ggit.h>


#define GITG_TYPE_REF_TYPE (gitg_ref_type_get_type ())

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;
typedef struct _GitgParsedRefNamePrivate GitgParsedRefNamePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

typedef enum  {
	GITG_REF_TYPE_NONE,
	GITG_REF_TYPE_BRANCH,
	GITG_REF_TYPE_REMOTE,
	GITG_REF_TYPE_TAG,
	GITG_REF_TYPE_STASH
} GitgRefType;

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgParsedRefName {
	GObject parent_instance;
	GitgParsedRefNamePrivate * priv;
};

struct _GitgParsedRefNameClass {
	GObjectClass parent_class;
};

struct _GitgParsedRefNamePrivate {
	gchar* d_shortname;
	gchar* d_name;
	gchar* d_remote_name;
	gchar* d_remote_branch;
	GitgRefType _rtype;
};

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};

struct _Block2Data {
	int _ref_count_;
	GitgRef* self;
	GRegex* valregex;
};


static gpointer gitg_parsed_ref_name_parent_class = NULL;
static GRegex* gitg_ref_s_remote_key_regex;
static GRegex* gitg_ref_s_remote_key_regex = NULL;

GType gitg_ref_type_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
#define GITG_PARSED_REF_NAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNamePrivate))
enum  {
	GITG_PARSED_REF_NAME_DUMMY_PROPERTY,
	GITG_PARSED_REF_NAME_RTYPE,
	GITG_PARSED_REF_NAME_NAME,
	GITG_PARSED_REF_NAME_SHORTNAME,
	GITG_PARSED_REF_NAME_REMOTE_NAME,
	GITG_PARSED_REF_NAME_REMOTE_BRANCH
};
GitgParsedRefName* gitg_parsed_ref_name_new (const gchar* name);
GitgParsedRefName* gitg_parsed_ref_name_construct (GType object_type, const gchar* name);
static void gitg_parsed_ref_name_parse_name (GitgParsedRefName* self, const gchar* name);
static void gitg_parsed_ref_name_set_rtype (GitgParsedRefName* self, GitgRefType value);
GitgRefType gitg_parsed_ref_name_get_rtype (GitgParsedRefName* self);
gchar* gitg_parsed_ref_name_get_name (GitgParsedRefName* self);
gchar* gitg_parsed_ref_name_get_shortname (GitgParsedRefName* self);
gchar* gitg_parsed_ref_name_get_remote_name (GitgParsedRefName* self);
gchar* gitg_parsed_ref_name_get_remote_branch (GitgParsedRefName* self);
static void gitg_parsed_ref_name_finalize (GObject* obj);
static void _vala_gitg_parsed_ref_name_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_parsed_ref_name_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gitg_repository_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
GitgRepository* gitg_ref_get_owner (GitgRef* self);
static void gitg_ref_add_push_ref (GitgRef* self, const gchar* spec);
GitgRef* gitg_repository_lookup_reference (GitgRepository* self, const gchar* name, GError** error);
GList* gitg_ref_get_d_pushes (GitgRef* self);
static gint __lambda21_ (GitgRef* a, GitgRef* b);
static gint ___lambda21__gcompare_func (gconstpointer a, gconstpointer b);
void gitg_ref_set_d_pushes (GitgRef* self, GList* value);
static void gitg_ref_add_branch_configured_push (GitgRef* self, GgitConfig* cfg);
GitgParsedRefName* gitg_ref_get_parsed_name (GitgRef* self);
static void gitg_ref_add_remote_configured_push (GitgRef* self, GgitConfig* cfg);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint ___lambda22_ (Block2Data* _data2_, GMatchInfo* info, const gchar* val);
static gint ____lambda22__ggit_config_match_callback (GMatchInfo* match_info, const gchar* value, gpointer self);
static void gitg_ref_add_branch_same_name_push (GitgRef* self, GgitConfig* cfg);
static void gitg_ref_compose_pushes (GitgRef* self);
GitgParsedRefName* gitg_ref_get_d_parsed_name (GitgRef* self);
void gitg_ref_set_d_parsed_name (GitgRef* self, GitgParsedRefName* value);
GitgRefState gitg_ref_get_state (GitgRef* self);
void gitg_ref_set_state (GitgRef* self, GitgRefState value);
gboolean gitg_ref_get_working (GitgRef* self);
void gitg_ref_set_working (GitgRef* self, gboolean value);
GList* gitg_ref_get_pushes (GitgRef* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType gitg_ref_type_get_type (void) {
	static volatile gsize gitg_ref_type_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_ref_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GITG_REF_TYPE_NONE, "GITG_REF_TYPE_NONE", "none"}, {GITG_REF_TYPE_BRANCH, "GITG_REF_TYPE_BRANCH", "branch"}, {GITG_REF_TYPE_REMOTE, "GITG_REF_TYPE_REMOTE", "remote"}, {GITG_REF_TYPE_TAG, "GITG_REF_TYPE_TAG", "tag"}, {GITG_REF_TYPE_STASH, "GITG_REF_TYPE_STASH", "stash"}, {0, NULL, NULL}};
		GType gitg_ref_type_type_id;
		gitg_ref_type_type_id = g_enum_register_static ("GitgRefType", values);
		g_once_init_leave (&gitg_ref_type_type_id__volatile, gitg_ref_type_type_id);
	}
	return gitg_ref_type_type_id__volatile;
}


GType gitg_ref_state_get_type (void) {
	static volatile gsize gitg_ref_state_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_ref_state_type_id__volatile)) {
		static const GEnumValue values[] = {{GITG_REF_STATE_NONE, "GITG_REF_STATE_NONE", "none"}, {GITG_REF_STATE_SELECTED, "GITG_REF_STATE_SELECTED", "selected"}, {GITG_REF_STATE_PRELIGHT, "GITG_REF_STATE_PRELIGHT", "prelight"}, {0, NULL, NULL}};
		GType gitg_ref_state_type_id;
		gitg_ref_state_type_id = g_enum_register_static ("GitgRefState", values);
		g_once_init_leave (&gitg_ref_state_type_id__volatile, gitg_ref_state_type_id);
	}
	return gitg_ref_state_type_id__volatile;
}


GitgParsedRefName* gitg_parsed_ref_name_construct (GType object_type, const gchar* name) {
	GitgParsedRefName * self = NULL;
	const gchar* _tmp0_ = NULL;
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	self = (GitgParsedRefName*) g_object_new (object_type, NULL);
#line 92 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = name;
#line 92 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	gitg_parsed_ref_name_parse_name (self, _tmp0_);
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return self;
#line 214 "gitg-ref.c"
}


GitgParsedRefName* gitg_parsed_ref_name_new (const gchar* name) {
#line 90 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return gitg_parsed_ref_name_construct (GITG_TYPE_PARSED_REF_NAME, name);
#line 221 "gitg-ref.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1189 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1190 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1190 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1190 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1191 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1191 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 256 "gitg-ref.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1192 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1192 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1192 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 265 "gitg-ref.c"
	}
#line 1194 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1194 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 271 "gitg-ref.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1195 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1195 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1195 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 280 "gitg-ref.c"
	}
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 286 "gitg-ref.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 295 "gitg-ref.c"
	} else {
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 299 "gitg-ref.c"
	}
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1198 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1198 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 309 "gitg-ref.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1198 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1198 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1198 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 318 "gitg-ref.c"
	} else {
#line 1198 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 322 "gitg-ref.c"
	}
#line 1198 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1198 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1199 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1199 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1199 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1200 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1200 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1200 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1200 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1200 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1200 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 346 "gitg-ref.c"
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 918 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 919 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 919 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 919 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 919 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 921 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 921 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 371 "gitg-ref.c"
		gchar* _tmp4_ = NULL;
#line 922 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 922 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 922 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 379 "gitg-ref.c"
	} else {
#line 924 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		result = -1;
#line 924 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 385 "gitg-ref.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1156 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1156 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1156 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1156 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1157 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1157 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 409 "gitg-ref.c"
		glong _tmp4_ = 0L;
#line 1158 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1158 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1158 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 417 "gitg-ref.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1160 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1160 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1160 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1160 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 429 "gitg-ref.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1167 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1169 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1169 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 454 "gitg-ref.c"
		glong _tmp2_ = 0L;
#line 1169 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1169 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 460 "gitg-ref.c"
	} else {
#line 1169 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 464 "gitg-ref.c"
	}
#line 1169 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1169 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 470 "gitg-ref.c"
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
#line 1171 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1171 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1171 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1171 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 482 "gitg-ref.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 1173 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1173 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1173 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 492 "gitg-ref.c"
	}
#line 1176 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1176 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 498 "gitg-ref.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
#line 1177 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1177 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1177 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1178 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1178 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 512 "gitg-ref.c"
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
#line 1180 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1180 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1180 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 522 "gitg-ref.c"
	}
#line 1182 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1182 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 528 "gitg-ref.c"
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
#line 1183 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1183 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1183 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 537 "gitg-ref.c"
	}
#line 1185 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1185 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1185 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1185 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1186 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1186 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1186 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1186 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1186 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 557 "gitg-ref.c"
}


static void gitg_parsed_ref_name_parse_name (GitgParsedRefName* self, const gchar* name) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** prefixes = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint prefixes_length1 = 0;
	gint _prefixes_size_ = 0;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 95 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_if_fail (name != NULL);
#line 97 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = name;
#line 97 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 97 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (self->priv->d_name);
#line 97 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	self->priv->d_name = _tmp1_;
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp2_ = g_strdup ("refs/heads/");
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp3_ = g_strdup ("refs/remotes/");
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp4_ = g_strdup ("refs/tags/");
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp5_ = g_strdup ("refs/stash");
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp6_ = g_new0 (gchar*, 4 + 1);
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp6_[0] = _tmp2_;
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp6_[1] = _tmp3_;
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp6_[2] = _tmp4_;
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp6_[3] = _tmp5_;
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	prefixes = _tmp6_;
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	prefixes_length1 = 4;
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_prefixes_size_ = prefixes_length1;
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp7_ = name;
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (self->priv->d_shortname);
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	self->priv->d_shortname = _tmp8_;
#line 618 "gitg-ref.c"
	{
		gint i = 0;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		i = 0;
#line 623 "gitg-ref.c"
		{
			gboolean _tmp9_ = FALSE;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
			_tmp9_ = TRUE;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
			while (TRUE) {
#line 630 "gitg-ref.c"
				gboolean _tmp10_ = FALSE;
				gint _tmp12_ = 0;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				const gchar* _tmp14_ = NULL;
				gchar** _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				gint _tmp16_ = 0;
				const gchar* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				gint _tmp19_ = 0;
				GitgRefType _tmp20_ = 0;
				GitgRefType _tmp32_ = 0;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp10_ = _tmp9_;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				if (!_tmp10_) {
#line 648 "gitg-ref.c"
					gint _tmp11_ = 0;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp11_ = i;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					i = _tmp11_ + 1;
#line 654 "gitg-ref.c"
				}
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp9_ = FALSE;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp12_ = i;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp13_ = prefixes;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp13__length1 = prefixes_length1;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				if (!(_tmp12_ < _tmp13__length1)) {
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					break;
#line 668 "gitg-ref.c"
				}
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp14_ = self->priv->d_name;
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp15_ = prefixes;
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp15__length1 = prefixes_length1;
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp16_ = i;
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp17_ = _tmp15_[_tmp16_];
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp18_ = g_str_has_prefix (_tmp14_, _tmp17_);
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				if (!_tmp18_) {
#line 112 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					continue;
#line 686 "gitg-ref.c"
				}
#line 115 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp19_ = i;
#line 115 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				gitg_parsed_ref_name_set_rtype (self, (GitgRefType) (_tmp19_ + 1));
#line 117 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp20_ = self->priv->_rtype;
#line 117 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				if (_tmp20_ == GITG_REF_TYPE_STASH) {
#line 696 "gitg-ref.c"
					gchar* _tmp21_ = NULL;
#line 119 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp21_ = g_strdup ("stash");
#line 119 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_g_free0 (self->priv->d_shortname);
#line 119 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					self->priv->d_shortname = _tmp21_;
#line 704 "gitg-ref.c"
				} else {
					const gchar* _tmp22_ = NULL;
					gchar** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					gint _tmp24_ = 0;
					const gchar* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					const gchar* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					gchar* _tmp31_ = NULL;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp22_ = self->priv->d_name;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp23_ = prefixes;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp23__length1 = prefixes_length1;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp24_ = i;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp25_ = _tmp23_[_tmp24_];
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp26_ = strlen (_tmp25_);
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp27_ = _tmp26_;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp28_ = self->priv->d_name;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp29_ = strlen (_tmp28_);
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp30_ = _tmp29_;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp31_ = string_slice (_tmp22_, (glong) _tmp27_, (glong) _tmp30_);
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_g_free0 (self->priv->d_shortname);
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					self->priv->d_shortname = _tmp31_;
#line 743 "gitg-ref.c"
				}
#line 126 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				_tmp32_ = self->priv->_rtype;
#line 126 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
				if (_tmp32_ == GITG_REF_TYPE_REMOTE) {
#line 749 "gitg-ref.c"
					gint pos = 0;
					const gchar* _tmp33_ = NULL;
					gint _tmp34_ = 0;
					gint _tmp35_ = 0;
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp33_ = self->priv->d_shortname;
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp34_ = string_index_of_char (_tmp33_, (gunichar) '/', 0);
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					pos = _tmp34_;
#line 130 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					_tmp35_ = pos;
#line 130 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
					if (_tmp35_ != (-1)) {
#line 764 "gitg-ref.c"
						const gchar* _tmp36_ = NULL;
						gint _tmp37_ = 0;
						gchar* _tmp38_ = NULL;
						const gchar* _tmp39_ = NULL;
						gint _tmp40_ = 0;
						gchar* _tmp41_ = NULL;
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						_tmp36_ = self->priv->d_shortname;
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						_tmp37_ = pos;
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						_tmp38_ = string_substring (_tmp36_, (glong) 0, (glong) _tmp37_);
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						_g_free0 (self->priv->d_remote_name);
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						self->priv->d_remote_name = _tmp38_;
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						_tmp39_ = self->priv->d_shortname;
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						_tmp40_ = pos;
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						_tmp41_ = string_substring (_tmp39_, (glong) (_tmp40_ + 1), (glong) (-1));
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						_g_free0 (self->priv->d_remote_branch);
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						self->priv->d_remote_branch = _tmp41_;
#line 791 "gitg-ref.c"
					} else {
						const gchar* _tmp42_ = NULL;
						gchar* _tmp43_ = NULL;
#line 137 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						_tmp42_ = self->priv->d_shortname;
#line 137 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						_tmp43_ = g_strdup (_tmp42_);
#line 137 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						_g_free0 (self->priv->d_remote_name);
#line 137 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
						self->priv->d_remote_name = _tmp43_;
#line 803 "gitg-ref.c"
					}
				}
			}
		}
	}
#line 95 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
#line 811 "gitg-ref.c"
}


GitgRefType gitg_parsed_ref_name_get_rtype (GitgParsedRefName* self) {
	GitgRefType result;
	GitgRefType _tmp0_ = 0;
#line 55 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 55 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = self->priv->_rtype;
#line 55 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	result = _tmp0_;
#line 55 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return result;
#line 826 "gitg-ref.c"
}


static void gitg_parsed_ref_name_set_rtype (GitgParsedRefName* self, GitgRefType value) {
	GitgRefType _tmp0_ = 0;
#line 55 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_if_fail (self != NULL);
#line 55 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = value;
#line 55 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	self->priv->_rtype = _tmp0_;
#line 55 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_object_notify ((GObject *) self, "rtype");
#line 840 "gitg-ref.c"
}


gchar* gitg_parsed_ref_name_get_name (GitgParsedRefName* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 62 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 62 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = self->priv->d_name;
#line 62 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 62 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	result = _tmp1_;
#line 62 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return result;
#line 858 "gitg-ref.c"
}


gchar* gitg_parsed_ref_name_get_shortname (GitgParsedRefName* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 71 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = self->priv->d_shortname;
#line 71 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 71 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	result = _tmp1_;
#line 71 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return result;
#line 876 "gitg-ref.c"
}


gchar* gitg_parsed_ref_name_get_remote_name (GitgParsedRefName* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 79 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 79 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = self->priv->d_remote_name;
#line 79 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 79 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	result = _tmp1_;
#line 79 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return result;
#line 894 "gitg-ref.c"
}


gchar* gitg_parsed_ref_name_get_remote_branch (GitgParsedRefName* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 87 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = self->priv->d_remote_branch;
#line 87 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 87 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	result = _tmp1_;
#line 87 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return result;
#line 912 "gitg-ref.c"
}


static void gitg_parsed_ref_name_class_init (GitgParsedRefNameClass * klass) {
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	gitg_parsed_ref_name_parent_class = g_type_class_peek_parent (klass);
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_type_class_add_private (klass, sizeof (GitgParsedRefNamePrivate));
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_parsed_ref_name_get_property;
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_parsed_ref_name_set_property;
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_parsed_ref_name_finalize;
#line 927 "gitg-ref.c"
	/**
	 * The type of ref.
	 */
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PARSED_REF_NAME_RTYPE, g_param_spec_enum ("rtype", "rtype", "rtype", GITG_TYPE_REF_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 933 "gitg-ref.c"
	/**
	 * The full name of the ref.
	 */
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PARSED_REF_NAME_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 939 "gitg-ref.c"
	/**
	 * The short name of the ref. This represents the name of the ref
	 * without the information of the type of ref.
	 */
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PARSED_REF_NAME_SHORTNAME, g_param_spec_string ("shortname", "shortname", "shortname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 946 "gitg-ref.c"
	/**
	 * The remote name of the ref (only for remote refs)
	 */
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PARSED_REF_NAME_REMOTE_NAME, g_param_spec_string ("remote-name", "remote-name", "remote-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 952 "gitg-ref.c"
	/**
	 * The remote branch name of the ref (only for remote refs)
	 */
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PARSED_REF_NAME_REMOTE_BRANCH, g_param_spec_string ("remote-branch", "remote-branch", "remote-branch", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 958 "gitg-ref.c"
}


static void gitg_parsed_ref_name_instance_init (GitgParsedRefName * self) {
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	self->priv = GITG_PARSED_REF_NAME_GET_PRIVATE (self);
#line 965 "gitg-ref.c"
}


static void gitg_parsed_ref_name_finalize (GObject* obj) {
	GitgParsedRefName * self;
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName);
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (self->priv->d_shortname);
#line 48 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (self->priv->d_name);
#line 49 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (self->priv->d_remote_name);
#line 50 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (self->priv->d_remote_branch);
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	G_OBJECT_CLASS (gitg_parsed_ref_name_parent_class)->finalize (obj);
#line 983 "gitg-ref.c"
}


/**
 * Parse ref name into components.
 *
 * This class parses a refname and splits it into several components.
 *
 */
GType gitg_parsed_ref_name_get_type (void) {
	static volatile gsize gitg_parsed_ref_name_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_parsed_ref_name_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgParsedRefNameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_parsed_ref_name_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgParsedRefName), 0, (GInstanceInitFunc) gitg_parsed_ref_name_instance_init, NULL };
		GType gitg_parsed_ref_name_type_id;
		gitg_parsed_ref_name_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgParsedRefName", &g_define_type_info, 0);
		g_once_init_leave (&gitg_parsed_ref_name_type_id__volatile, gitg_parsed_ref_name_type_id);
	}
	return gitg_parsed_ref_name_type_id__volatile;
}


static void _vala_gitg_parsed_ref_name_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgParsedRefName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName);
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	switch (property_id) {
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		case GITG_PARSED_REF_NAME_RTYPE:
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_value_set_enum (value, gitg_parsed_ref_name_get_rtype (self));
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		break;
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		case GITG_PARSED_REF_NAME_NAME:
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_value_take_string (value, gitg_parsed_ref_name_get_name (self));
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		break;
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		case GITG_PARSED_REF_NAME_SHORTNAME:
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_value_take_string (value, gitg_parsed_ref_name_get_shortname (self));
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		break;
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		case GITG_PARSED_REF_NAME_REMOTE_NAME:
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_value_take_string (value, gitg_parsed_ref_name_get_remote_name (self));
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		break;
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		case GITG_PARSED_REF_NAME_REMOTE_BRANCH:
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_value_take_string (value, gitg_parsed_ref_name_get_remote_branch (self));
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		break;
#line 1040 "gitg-ref.c"
		default:
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		break;
#line 1046 "gitg-ref.c"
	}
}


static void _vala_gitg_parsed_ref_name_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgParsedRefName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName);
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	switch (property_id) {
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		case GITG_PARSED_REF_NAME_RTYPE:
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		gitg_parsed_ref_name_set_rtype (self, g_value_get_enum (value));
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		break;
#line 1062 "gitg-ref.c"
		default:
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		break;
#line 1068 "gitg-ref.c"
	}
}


GitgRepository* gitg_ref_get_owner (GitgRef* self) {
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return GITG_REF_GET_INTERFACE (self)->get_owner (self);
#line 1078 "gitg-ref.c"
}


static gint __lambda21_ (GitgRef* a, GitgRef* b) {
	gint result = 0;
	GitgRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GitgRef* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = a;
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp1_ = ggit_ref_get_name ((GgitRef*) _tmp0_);
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp2_ = b;
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp3_ = ggit_ref_get_name ((GgitRef*) _tmp2_);
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp4_ = g_ascii_strcasecmp (_tmp1_, _tmp3_);
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	result = _tmp4_;
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return result;
#line 1107 "gitg-ref.c"
}


static gint ___lambda21__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda21_ ((GitgRef*) a, (GitgRef*) b);
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return result;
#line 1116 "gitg-ref.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return self ? g_object_ref (self) : NULL;
#line 1123 "gitg-ref.c"
}


static void gitg_ref_add_push_ref (GitgRef* self, const gchar* spec) {
	GitgRef* rf = NULL;
	GList* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GitgRef* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_if_fail (spec != NULL);
#line 1136 "gitg-ref.c"
	{
		GitgRef* _tmp0_ = NULL;
		GitgRepository* _tmp1_ = NULL;
		GitgRepository* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GitgRef* _tmp4_ = NULL;
		GitgRef* _tmp5_ = NULL;
#line 175 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp1_ = gitg_ref_get_owner (self);
#line 175 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp2_ = _tmp1_;
#line 175 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp3_ = spec;
#line 175 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp4_ = gitg_repository_lookup_reference (_tmp2_, _tmp3_, &_inner_error_);
#line 175 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp5_ = _tmp4_;
#line 175 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (_tmp2_);
#line 175 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp0_ = _tmp5_;
#line 175 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		if (_inner_error_ != NULL) {
#line 1160 "gitg-ref.c"
			goto __catch4_g_error;
		}
#line 175 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (rf);
#line 175 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		rf = _tmp0_;
#line 1167 "gitg-ref.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
#line 173 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_clear_error (&_inner_error_);
#line 173 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_inner_error_ = NULL;
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (rf);
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		return;
#line 1180 "gitg-ref.c"
	}
	__finally4:
#line 173 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	if (_inner_error_ != NULL) {
#line 173 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (rf);
#line 173 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 173 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_clear_error (&_inner_error_);
#line 173 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		return;
#line 1193 "gitg-ref.c"
	}
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp6_ = gitg_ref_get_d_pushes (self);
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp7_ = _tmp6_;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp8_ = rf;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp9_ = g_list_find_custom (_tmp7_, _tmp8_, ___lambda21__gcompare_func);
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	if (_tmp9_ == NULL) {
#line 1205 "gitg-ref.c"
		GList* _tmp10_ = NULL;
		GList* _tmp11_ = NULL;
		GitgRef* _tmp12_ = NULL;
		GitgRef* _tmp13_ = NULL;
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp10_ = gitg_ref_get_d_pushes (self);
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp11_ = _tmp10_;
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp12_ = rf;
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		gitg_ref_set_d_pushes (self, g_list_append (_tmp11_, _tmp13_));
#line 1220 "gitg-ref.c"
	}
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_object_unref0 (rf);
#line 1224 "gitg-ref.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1273 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1274 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	result = self;
#line 1274 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 1236 "gitg-ref.c"
}


static void gitg_ref_add_branch_configured_push (GitgRef* self, GgitConfig* cfg) {
	gchar* remote = NULL;
	gchar* merge = NULL;
	GitgParsedRefName* nm = NULL;
	const gchar* _tmp28_ = NULL;
	GitgParsedRefName* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GitgParsedRefName* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
#line 186 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_if_fail (cfg != NULL);
#line 1258 "gitg-ref.c"
	{
		const gchar* _tmp0_ = NULL;
		GgitConfig* _tmp1_ = NULL;
		GitgParsedRefName* _tmp2_ = NULL;
		GitgParsedRefName* _tmp3_ = NULL;
		GitgParsedRefName* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GgitConfig* _tmp15_ = NULL;
		GitgParsedRefName* _tmp16_ = NULL;
		GitgParsedRefName* _tmp17_ = NULL;
		GitgParsedRefName* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp1_ = cfg;
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp2_ = gitg_ref_get_parsed_name (self);
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp3_ = _tmp2_;
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp4_ = _tmp3_;
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp5_ = gitg_parsed_ref_name_get_shortname (_tmp4_);
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp6_ = _tmp5_;
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp7_ = _tmp6_;
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp8_ = string_to_string (_tmp7_);
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp9_ = g_strconcat ("branch.", _tmp8_, ".remote", NULL);
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp10_ = _tmp9_;
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp11_ = ggit_config_get_string (_tmp1_, _tmp10_, &_inner_error_);
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp12_ = _tmp11_;
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (_tmp10_);
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (_tmp7_);
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (_tmp4_);
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp0_ = _tmp12_;
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		if (_inner_error_ != NULL) {
#line 1322 "gitg-ref.c"
			goto __catch5_g_error;
		}
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp13_ = g_strdup (_tmp0_);
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (remote);
#line 193 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		remote = _tmp13_;
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp15_ = cfg;
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp16_ = gitg_ref_get_parsed_name (self);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp17_ = _tmp16_;
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp18_ = _tmp17_;
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp19_ = gitg_parsed_ref_name_get_shortname (_tmp18_);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp20_ = _tmp19_;
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp21_ = _tmp20_;
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp22_ = string_to_string (_tmp21_);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp23_ = g_strconcat ("branch.", _tmp22_, ".merge", NULL);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp24_ = _tmp23_;
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp25_ = ggit_config_get_string (_tmp15_, _tmp24_, &_inner_error_);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp26_ = _tmp25_;
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (_tmp24_);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (_tmp21_);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (_tmp18_);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp14_ = _tmp26_;
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		if (_inner_error_ != NULL) {
#line 1365 "gitg-ref.c"
			goto __catch5_g_error;
		}
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp27_ = g_strdup (_tmp14_);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (merge);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		merge = _tmp27_;
#line 1374 "gitg-ref.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
#line 191 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_clear_error (&_inner_error_);
#line 191 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_inner_error_ = NULL;
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (merge);
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (remote);
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		return;
#line 1389 "gitg-ref.c"
	}
	__finally5:
#line 191 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	if (_inner_error_ != NULL) {
#line 191 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (merge);
#line 191 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (remote);
#line 191 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 191 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_clear_error (&_inner_error_);
#line 191 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		return;
#line 1404 "gitg-ref.c"
	}
#line 197 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp28_ = merge;
#line 197 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp29_ = gitg_parsed_ref_name_new (_tmp28_);
#line 197 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	nm = _tmp29_;
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp30_ = remote;
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp31_ = string_to_string (_tmp30_);
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp32_ = nm;
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp33_ = gitg_parsed_ref_name_get_shortname (_tmp32_);
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp34_ = _tmp33_;
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp35_ = _tmp34_;
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp36_ = string_to_string (_tmp35_);
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp37_ = g_strconcat ("refs/remotes/", _tmp31_, "/", _tmp36_, NULL);
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp38_ = _tmp37_;
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	gitg_ref_add_push_ref (self, _tmp38_);
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (_tmp38_);
#line 199 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (_tmp35_);
#line 186 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_object_unref0 (nm);
#line 186 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (merge);
#line 186 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (remote);
#line 1442 "gitg-ref.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return _data2_;
#line 1451 "gitg-ref.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1460 "gitg-ref.c"
		GitgRef* self;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		self = _data2_->self;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_regex_unref0 (_data2_->valregex);
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_slice_free (Block2Data, _data2_);
#line 1468 "gitg-ref.c"
	}
}


static gint ___lambda22_ (Block2Data* _data2_, GMatchInfo* info, const gchar* val) {
	GitgRef* self;
	gint result = 0;
	GMatchInfo* vinfo = NULL;
	GRegex* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GMatchInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* rname = NULL;
	GMatchInfo* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* pref = NULL;
	GMatchInfo* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
#line 215 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	self = _data2_->self;
#line 215 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (info != NULL, 0);
#line 215 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (val != NULL, 0);
#line 218 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = _data2_->valregex;
#line 218 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp1_ = val;
#line 218 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp3_ = g_regex_match (_tmp0_, _tmp1_, 0, &_tmp2_);
#line 218 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_match_info_unref0 (vinfo);
#line 218 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	vinfo = _tmp2_;
#line 218 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	if (!_tmp3_) {
#line 220 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		result = 0;
#line 220 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_match_info_unref0 (vinfo);
#line 220 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		return result;
#line 1517 "gitg-ref.c"
	}
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp4_ = info;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp5_ = g_match_info_fetch (_tmp4_, 1);
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	rname = _tmp5_;
#line 224 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp6_ = vinfo;
#line 224 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp7_ = g_match_info_fetch (_tmp6_, 1);
#line 224 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	pref = _tmp7_;
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp8_ = rname;
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp9_ = string_to_string (_tmp8_);
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp10_ = pref;
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp11_ = string_to_string (_tmp10_);
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp12_ = g_strconcat ("refs/remotes/", _tmp9_, "/", _tmp11_, NULL);
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp13_ = _tmp12_;
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	gitg_ref_add_push_ref (self, _tmp13_);
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (_tmp13_);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	result = 0;
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (pref);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (rname);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_match_info_unref0 (vinfo);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return result;
#line 1557 "gitg-ref.c"
}


static gint ____lambda22__ggit_config_match_callback (GMatchInfo* match_info, const gchar* value, gpointer self) {
	gint result;
	result = ___lambda22_ (self, match_info, value);
#line 215 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return result;
#line 1566 "gitg-ref.c"
}


static void gitg_ref_add_remote_configured_push (GitgRef* self, GgitConfig* cfg) {
	Block2Data* _data2_;
	GError * _inner_error_ = NULL;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_if_fail (cfg != NULL);
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_data2_->_ref_count_ = 1;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_data2_->self = g_object_ref (self);
#line 1581 "gitg-ref.c"
	{
		GRegex* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		GRegex* _tmp7_ = NULL;
		GRegex* _tmp8_ = NULL;
		GgitConfig* _tmp11_ = NULL;
		GRegex* _tmp12_ = NULL;
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp1_ = ggit_ref_get_name ((GgitRef*) self);
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp2_ = g_regex_escape_string (_tmp1_, -1);
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp3_ = _tmp2_;
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp4_ = g_strdup_printf ("^%s:(.*)", _tmp3_);
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp5_ = _tmp4_;
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp6_ = g_regex_new (_tmp5_, 0, 0, &_inner_error_);
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp7_ = _tmp6_;
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (_tmp5_);
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (_tmp3_);
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp0_ = _tmp7_;
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		if (_inner_error_ != NULL) {
#line 1616 "gitg-ref.c"
			goto __catch6_g_error;
		}
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_regex_unref0 (_data2_->valregex);
#line 208 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_data2_->valregex = _tmp0_;
#line 210 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp8_ = gitg_ref_s_remote_key_regex;
#line 210 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		if (_tmp8_ == NULL) {
#line 1627 "gitg-ref.c"
			GRegex* _tmp9_ = NULL;
			GRegex* _tmp10_ = NULL;
#line 212 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
			_tmp10_ = g_regex_new ("remote\\.(.*)\\.push", 0, 0, &_inner_error_);
#line 212 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
			_tmp9_ = _tmp10_;
#line 212 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
			if (_inner_error_ != NULL) {
#line 1636 "gitg-ref.c"
				goto __catch6_g_error;
			}
#line 212 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
			_g_regex_unref0 (gitg_ref_s_remote_key_regex);
#line 212 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
			gitg_ref_s_remote_key_regex = _tmp9_;
#line 1643 "gitg-ref.c"
		}
#line 215 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp11_ = cfg;
#line 215 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp12_ = gitg_ref_s_remote_key_regex;
#line 215 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		ggit_config_match_foreach (_tmp11_, _tmp12_, ____lambda22__ggit_config_match_callback, _data2_, &_inner_error_);
#line 215 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		if (_inner_error_ != NULL) {
#line 1653 "gitg-ref.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
#line 206 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_clear_error (&_inner_error_);
#line 206 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_inner_error_ = NULL;
#line 230 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		block2_data_unref (_data2_);
#line 230 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_data2_ = NULL;
#line 230 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		return;
#line 1670 "gitg-ref.c"
	}
	__finally6:
#line 206 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	if (_inner_error_ != NULL) {
#line 206 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		block2_data_unref (_data2_);
#line 206 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_data2_ = NULL;
#line 206 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 206 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_clear_error (&_inner_error_);
#line 206 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		return;
#line 1685 "gitg-ref.c"
	}
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	block2_data_unref (_data2_);
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_data2_ = NULL;
#line 1691 "gitg-ref.c"
}


static void gitg_ref_add_branch_same_name_push (GitgRef* self, GgitConfig* cfg) {
	gchar* remote = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GitgParsedRefName* _tmp16_ = NULL;
	GitgParsedRefName* _tmp17_ = NULL;
	GitgParsedRefName* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_if_fail (cfg != NULL);
#line 1711 "gitg-ref.c"
	{
		const gchar* _tmp0_ = NULL;
		GgitConfig* _tmp1_ = NULL;
		GitgParsedRefName* _tmp2_ = NULL;
		GitgParsedRefName* _tmp3_ = NULL;
		GitgParsedRefName* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp1_ = cfg;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp2_ = gitg_ref_get_parsed_name (self);
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp3_ = _tmp2_;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp4_ = _tmp3_;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp5_ = gitg_parsed_ref_name_get_shortname (_tmp4_);
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp6_ = _tmp5_;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp7_ = _tmp6_;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp8_ = string_to_string (_tmp7_);
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp9_ = g_strconcat ("branch.", _tmp8_, ".remote", NULL);
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp10_ = _tmp9_;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp11_ = ggit_config_get_string (_tmp1_, _tmp10_, &_inner_error_);
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp12_ = _tmp11_;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (_tmp10_);
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (_tmp7_);
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (_tmp4_);
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp0_ = _tmp12_;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		if (_inner_error_ != NULL) {
#line 1761 "gitg-ref.c"
			goto __catch7_g_error;
		}
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp13_ = g_strdup (_tmp0_);
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (remote);
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		remote = _tmp13_;
#line 1770 "gitg-ref.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_clear_error (&_inner_error_);
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_inner_error_ = NULL;
#line 240 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (remote);
#line 240 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		return;
#line 1783 "gitg-ref.c"
	}
	__finally7:
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	if (_inner_error_ != NULL) {
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_free0 (remote);
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_clear_error (&_inner_error_);
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		return;
#line 1796 "gitg-ref.c"
	}
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp14_ = remote;
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp15_ = string_to_string (_tmp14_);
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp16_ = gitg_ref_get_parsed_name (self);
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp17_ = _tmp16_;
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp18_ = _tmp17_;
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp19_ = gitg_parsed_ref_name_get_shortname (_tmp18_);
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp20_ = _tmp19_;
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp21_ = _tmp20_;
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp22_ = string_to_string (_tmp21_);
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp23_ = g_strconcat ("refs/remotes/", _tmp15_, "/", _tmp22_, NULL);
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp24_ = _tmp23_;
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	gitg_ref_add_push_ref (self, _tmp24_);
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (_tmp24_);
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (_tmp21_);
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_object_unref0 (_tmp18_);
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_free0 (remote);
#line 1830 "gitg-ref.c"
}


static void gitg_ref_compose_pushes (GitgRef* self) {
	GgitConfig* cfg = NULL;
	GgitConfig* _tmp5_ = NULL;
	GgitConfig* _tmp6_ = NULL;
	GgitConfig* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	gitg_ref_set_d_pushes (self, NULL);
#line 1842 "gitg-ref.c"
	{
		GgitConfig* _tmp0_ = NULL;
		GitgRepository* _tmp1_ = NULL;
		GitgRepository* _tmp2_ = NULL;
		GgitConfig* _tmp3_ = NULL;
		GgitConfig* _tmp4_ = NULL;
#line 253 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp1_ = gitg_ref_get_owner (self);
#line 253 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp2_ = _tmp1_;
#line 253 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp3_ = ggit_repository_get_config ((GgitRepository*) _tmp2_, &_inner_error_);
#line 253 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp4_ = _tmp3_;
#line 253 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (_tmp2_);
#line 253 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp0_ = _tmp4_;
#line 253 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		if (_inner_error_ != NULL) {
#line 1863 "gitg-ref.c"
			goto __catch8_g_error;
		}
#line 253 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (cfg);
#line 253 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		cfg = _tmp0_;
#line 1870 "gitg-ref.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
#line 251 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_clear_error (&_inner_error_);
#line 251 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_inner_error_ = NULL;
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (cfg);
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		return;
#line 1883 "gitg-ref.c"
	}
	__finally8:
#line 251 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	if (_inner_error_ != NULL) {
#line 251 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (cfg);
#line 251 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 251 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_clear_error (&_inner_error_);
#line 251 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		return;
#line 1896 "gitg-ref.c"
	}
#line 277 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp5_ = cfg;
#line 277 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	gitg_ref_add_branch_configured_push (self, _tmp5_);
#line 280 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp6_ = cfg;
#line 280 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	gitg_ref_add_remote_configured_push (self, _tmp6_);
#line 283 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp7_ = cfg;
#line 283 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	gitg_ref_add_branch_same_name_push (self, _tmp7_);
#line 245 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_g_object_unref0 (cfg);
#line 1912 "gitg-ref.c"
}


GitgParsedRefName* gitg_ref_get_d_parsed_name (GitgRef* self) {
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return GITG_REF_GET_INTERFACE (self)->get_d_parsed_name (self);
#line 1921 "gitg-ref.c"
}


void gitg_ref_set_d_parsed_name (GitgRef* self, GitgParsedRefName* value) {
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_if_fail (self != NULL);
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	GITG_REF_GET_INTERFACE (self)->set_d_parsed_name (self, value);
#line 1930 "gitg-ref.c"
}


GList* gitg_ref_get_d_pushes (GitgRef* self) {
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return GITG_REF_GET_INTERFACE (self)->get_d_pushes (self);
#line 1939 "gitg-ref.c"
}


void gitg_ref_set_d_pushes (GitgRef* self, GList* value) {
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_if_fail (self != NULL);
#line 149 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	GITG_REF_GET_INTERFACE (self)->set_d_pushes (self, value);
#line 1948 "gitg-ref.c"
}


GitgRefState gitg_ref_get_state (GitgRef* self) {
#line 151 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 151 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return GITG_REF_GET_INTERFACE (self)->get_state (self);
#line 1957 "gitg-ref.c"
}


void gitg_ref_set_state (GitgRef* self, GitgRefState value) {
#line 151 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_if_fail (self != NULL);
#line 151 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	GITG_REF_GET_INTERFACE (self)->set_state (self, value);
#line 1966 "gitg-ref.c"
}


gboolean gitg_ref_get_working (GitgRef* self) {
#line 152 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 152 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return GITG_REF_GET_INTERFACE (self)->get_working (self);
#line 1975 "gitg-ref.c"
}


void gitg_ref_set_working (GitgRef* self, gboolean value) {
#line 152 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_if_fail (self != NULL);
#line 152 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	GITG_REF_GET_INTERFACE (self)->set_working (self, value);
#line 1984 "gitg-ref.c"
}


GitgParsedRefName* gitg_ref_get_parsed_name (GitgRef* self) {
	GitgParsedRefName* result;
	GitgParsedRefName* _tmp0_ = NULL;
	GitgParsedRefName* _tmp1_ = NULL;
	GitgParsedRefName* _tmp5_ = NULL;
	GitgParsedRefName* _tmp6_ = NULL;
	GitgParsedRefName* _tmp7_ = NULL;
#line 156 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 158 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = gitg_ref_get_d_parsed_name (self);
#line 158 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp1_ = _tmp0_;
#line 158 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	if (_tmp1_ == NULL) {
#line 2003 "gitg-ref.c"
		const gchar* _tmp2_ = NULL;
		GitgParsedRefName* _tmp3_ = NULL;
		GitgParsedRefName* _tmp4_ = NULL;
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp2_ = ggit_ref_get_name ((GgitRef*) self);
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp3_ = gitg_parsed_ref_name_new (_tmp2_);
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_tmp4_ = _tmp3_;
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		gitg_ref_set_d_parsed_name (self, _tmp4_);
#line 160 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		_g_object_unref0 (_tmp4_);
#line 2017 "gitg-ref.c"
	}
#line 163 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp5_ = gitg_ref_get_d_parsed_name (self);
#line 163 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp6_ = _tmp5_;
#line 163 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 163 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	result = _tmp7_;
#line 163 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return result;
#line 2029 "gitg-ref.c"
}


GList* gitg_ref_get_pushes (GitgRef* self) {
	GList* result;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
#line 288 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 290 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp0_ = gitg_ref_get_d_pushes (self);
#line 290 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp1_ = _tmp0_;
#line 290 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	if (_tmp1_ == NULL) {
#line 292 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		gitg_ref_compose_pushes (self);
#line 2049 "gitg-ref.c"
	}
#line 295 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp2_ = gitg_ref_get_d_pushes (self);
#line 295 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	_tmp3_ = _tmp2_;
#line 295 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	result = _tmp3_;
#line 295 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	return result;
#line 2059 "gitg-ref.c"
}


static void gitg_ref_base_init (GitgRefIface * iface) {
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	static gboolean initialized = FALSE;
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
	if (!initialized) {
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		initialized = TRUE;
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("d-parsed-name", "d-parsed-name", "d-parsed-name", GITG_TYPE_PARSED_REF_NAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_object_interface_install_property (iface, g_param_spec_pointer ("d-pushes", "d-pushes", "d-pushes", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_object_interface_install_property (iface, g_param_spec_enum ("state", "state", "state", GITG_TYPE_REF_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-ref.vala"
		g_object_interface_install_property (iface, g_param_spec_boolean ("working", "working", "working", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2078 "gitg-ref.c"
	}
}


GType gitg_ref_get_type (void) {
	static volatile gsize gitg_ref_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_ref_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRefIface), (GBaseInitFunc) gitg_ref_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gitg_ref_type_id;
		gitg_ref_type_id = g_type_register_static (G_TYPE_INTERFACE, "GitgRef", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gitg_ref_type_id, ggit_ref_get_type ());
		g_once_init_leave (&gitg_ref_type_id__volatile, gitg_ref_type_id);
	}
	return gitg_ref_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



