/* gitg-application.c generated by valac 0.23.1.3-23cc3-dirty, the Vala compiler
 * generated from gitg-application.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>
#include "libgitg-ext/libgitg-ext.h"
#include "libgitg/libgitg.h"
#include <gdk/gdk.h>
#include <libgit2-glib/ggit.h>


#define GITG_TYPE_APPLICATION (gitg_application_get_type ())
#define GITG_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_APPLICATION, GitgApplication))
#define GITG_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_APPLICATION, GitgApplicationClass))
#define GITG_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_APPLICATION))
#define GITG_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_APPLICATION))
#define GITG_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_APPLICATION, GitgApplicationClass))

typedef struct _GitgApplication GitgApplication;
typedef struct _GitgApplicationClass GitgApplicationClass;
typedef struct _GitgApplicationPrivate GitgApplicationPrivate;

#define GITG_TYPE_PREFERENCES_DIALOG (gitg_preferences_dialog_get_type ())
#define GITG_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialog))
#define GITG_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialogClass))
#define GITG_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PREFERENCES_DIALOG))
#define GITG_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PREFERENCES_DIALOG))
#define GITG_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialogClass))

typedef struct _GitgPreferencesDialog GitgPreferencesDialog;
typedef struct _GitgPreferencesDialogClass GitgPreferencesDialogClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_PLUGINS_ENGINE (gitg_plugins_engine_get_type ())
#define GITG_PLUGINS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngine))
#define GITG_PLUGINS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngineClass))
#define GITG_IS_PLUGINS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PLUGINS_ENGINE))
#define GITG_IS_PLUGINS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PLUGINS_ENGINE))
#define GITG_PLUGINS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngineClass))

typedef struct _GitgPluginsEngine GitgPluginsEngine;
typedef struct _GitgPluginsEngineClass GitgPluginsEngineClass;
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_TYPE_WINDOW (gitg_window_get_type ())
#define GITG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_WINDOW, GitgWindow))
#define GITG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_WINDOW, GitgWindowClass))
#define GITG_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_WINDOW))
#define GITG_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_WINDOW))
#define GITG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_WINDOW, GitgWindowClass))

typedef struct _GitgWindow GitgWindow;
typedef struct _GitgWindowClass GitgWindowClass;

#define GITG_APPLICATION_TYPE_OPTIONS (gitg_application_options_get_type ())
typedef struct _GitgApplicationOptions GitgApplicationOptions;

struct _GitgApplication {
	GtkApplication parent_instance;
	GitgApplicationPrivate * priv;
};

struct _GitgApplicationClass {
	GtkApplicationClass parent_class;
};

struct _GitgApplicationPrivate {
	GSettings* d_state_settings;
	GitgPreferencesDialog* d_preferences;
};

struct _GitgApplicationOptions {
};


static gpointer gitg_application_parent_class = NULL;
static gboolean gitg_application_options_quit;
static gchar* gitg_application_options_activity;
static gboolean gitg_application_options_no_wd;
static GApplicationCommandLine* gitg_application_options_command_line;
static gboolean gitg_application_options_quit = FALSE;
static gchar* gitg_application_options_activity = NULL;
static gboolean gitg_application_options_no_wd = FALSE;
static GApplicationCommandLine* gitg_application_options_command_line = NULL;

GType gitg_application_get_type (void) G_GNUC_CONST;
GType gitg_preferences_dialog_get_type (void) G_GNUC_CONST;
#define GITG_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_APPLICATION, GitgApplicationPrivate))
enum  {
	GITG_APPLICATION_DUMMY_PROPERTY,
	GITG_APPLICATION_STATE_SETTINGS
};
static void gitg_application_on_app_new_window_activated (GitgApplication* self);
static void _gitg_application_on_app_new_window_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_app_help_activated (GitgApplication* self);
static void _gitg_application_on_app_help_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_app_about_activated (GitgApplication* self);
static void _gitg_application_on_app_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_app_quit_activated (GitgApplication* self);
static void _gitg_application_on_app_quit_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_preferences_activated (GitgApplication* self);
static void _gitg_application_on_preferences_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
GitgApplication* gitg_application_new (void);
GitgApplication* gitg_application_construct (GType object_type);
static void gitg_application_show_version_and_quit (void);
static void gitg_application_parse_command_line (GitgApplication* self, gchar*** argv, int* argv_length1, GError** error);
static void gitg_application_options_commit_activity (void);
GType gitg_plugins_engine_get_type (void) G_GNUC_CONST;
GitgPluginsEngine* gitg_plugins_engine_get_default (void);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static gboolean gitg_application_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status);
static gchar** _vala_array_dup1 (gchar** self, int length);
void gitg_plugins_engine_initialize (void);
static gint gitg_application_real_command_line (GApplication* base, GApplicationCommandLine* cmd);
static void _vala_array_add1 (GFile*** array, int* length, int* size, GFile* value);
static void gitg_application_new_window (GitgApplication* self, GitgRepository* repo, const gchar* hint);
gpointer gitg_resource_load_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* id, const gchar* object);
static void ___lambda65_ (GitgApplication* self, GtkWidget* w);
static void ____lambda65__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void ___lambda66_ (GitgApplication* self, GtkDialog* w, gint r);
static void ____lambda66__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void gitg_application_real_startup (GApplication* base);
GtkCssProvider* gitg_resource_load_css (const gchar* id);
static void gitg_application_real_shutdown (GApplication* base);
static void gitg_application_real_activate (GApplication* base);
static void gitg_application_present_window (GitgApplication* self);
GType gitg_window_get_type (void) G_GNUC_CONST;
static GitgWindow* gitg_application_find_window_for_file (GitgApplication* self, GFile* file);
static void gitg_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
void gitg_window_set_environment (GitgWindow* self, gchar** environment, int environment_length1);
GitgWindow* gitg_window_create_new (GtkApplication* app, GitgRepository* repository, const gchar* action);
GSettings* gitg_application_get_state_settings (GitgApplication* self);
static GType gitg_application_options_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GitgApplicationOptions* gitg_application_options_dup (const GitgApplicationOptions* self);
static void gitg_application_options_free (GitgApplicationOptions* self);
static void gitg_application_finalize (GObject* obj);
static void _vala_gitg_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry GITG_APPLICATION_app_entries[5] = {{"new", _gitg_application_on_app_new_window_activated_gsimple_action_activate_callback}, {"help", _gitg_application_on_app_help_activated_gsimple_action_activate_callback}, {"about", _gitg_application_on_app_about_activated_gsimple_action_activate_callback}, {"quit", _gitg_application_on_app_quit_activated_gsimple_action_activate_callback}, {"preferences", _gitg_application_on_preferences_activated_gsimple_action_activate_callback}};
static const GOptionEntry GITG_APPLICATION_OPTIONS_entries[5] = {{"version", 'v', (gint) G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (void*) gitg_application_show_version_and_quit, "Show the application's version", NULL}, {"activity", '\0', 0, G_OPTION_ARG_STRING, &gitg_application_options_activity, "Start gitg with a particular activity", NULL}, {"commit", 'c', (gint) G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (void*) gitg_application_options_commit_activity, "Start gitg with the commit activity (shorthand for --view commit)", NULL}, {"no-wd", (gchar) 0, 0, G_OPTION_ARG_NONE, &gitg_application_options_no_wd, "Do not try to load a repository from the current working directory", NULL}, {NULL}};

static void _gitg_application_on_app_new_window_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 257 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_new_window_activated ((GitgApplication*) self);
#line 180 "gitg-application.c"
}


static void _gitg_application_on_app_help_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 257 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_help_activated ((GitgApplication*) self);
#line 187 "gitg-application.c"
}


static void _gitg_application_on_app_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 257 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_about_activated ((GitgApplication*) self);
#line 194 "gitg-application.c"
}


static void _gitg_application_on_app_quit_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 257 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_quit_activated ((GitgApplication*) self);
#line 201 "gitg-application.c"
}


static void _gitg_application_on_preferences_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 257 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_on_preferences_activated ((GitgApplication*) self);
#line 208 "gitg-application.c"
}


GitgApplication* gitg_application_construct (GType object_type) {
	GitgApplication * self = NULL;
#line 34 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) g_object_new (object_type, "application-id", "org.gnome.gitg", "flags", (G_APPLICATION_HANDLES_OPEN | G_APPLICATION_HANDLES_COMMAND_LINE) | G_APPLICATION_SEND_ENVIRONMENT, NULL);
#line 32 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	return self;
#line 218 "gitg-application.c"
}


GitgApplication* gitg_application_new (void) {
#line 32 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	return gitg_application_construct (GITG_TYPE_APPLICATION);
#line 225 "gitg-application.c"
}


static void gitg_application_show_version_and_quit (void) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 79 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = stdout;
#line 79 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_get_application_name ();
#line 79 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	fprintf (_tmp0_, "%s %s\n", _tmp1_, VERSION);
#line 83 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_options_quit = TRUE;
#line 240 "gitg-application.c"
}


static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self) {
#line 96 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	return g_boxed_copy (peas_plugin_info_get_type (), self);
#line 247 "gitg-application.c"
}


static gpointer __vala_PeasPluginInfo_copy0 (gpointer self) {
#line 96 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
#line 254 "gitg-application.c"
}


static void _vala_PeasPluginInfo_free (PeasPluginInfo* self) {
#line 96 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_boxed_free (peas_plugin_info_get_type (), self);
#line 261 "gitg-application.c"
}


static void gitg_application_parse_command_line (GitgApplication* self, gchar*** argv, int* argv_length1, GError** error) {
	GOptionContext* ctx = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	GitgPluginsEngine* engine = NULL;
	GitgPluginsEngine* _tmp5_ = NULL;
	GitgPluginsEngine* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GOptionContext* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
#line 86 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 88 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = _ ("- Git repository viewer");
#line 88 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_option_context_new (_tmp0_);
#line 88 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	ctx = _tmp1_;
#line 90 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp2_ = ctx;
#line 90 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_option_context_add_main_entries (_tmp2_, GITG_APPLICATION_OPTIONS_entries, GETTEXT_PACKAGE);
#line 91 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp3_ = ctx;
#line 91 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp4_ = gtk_get_option_group (TRUE);
#line 91 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_option_context_add_group (_tmp3_, _tmp4_);
#line 94 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp5_ = gitg_plugins_engine_get_default ();
#line 94 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	engine = _tmp5_;
#line 96 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp6_ = engine;
#line 96 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp7_ = peas_engine_get_plugin_list ((PeasEngine*) _tmp6_);
#line 304 "gitg-application.c"
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
#line 96 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		info_collection = _tmp7_;
#line 96 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
#line 312 "gitg-application.c"
			PeasPluginInfo* _tmp8_ = NULL;
			PeasPluginInfo* info = NULL;
#line 96 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			_tmp8_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) info_it->data);
#line 96 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			info = _tmp8_;
#line 319 "gitg-application.c"
			{
				PeasPluginInfo* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
#line 98 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp9_ = info;
#line 98 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp10_ = peas_plugin_info_get_external_data (_tmp9_, "CommandLine");
#line 98 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				if (_tmp10_ != NULL) {
#line 329 "gitg-application.c"
					GitgExtCommandLine* ext = NULL;
					GitgPluginsEngine* _tmp11_ = NULL;
					PeasPluginInfo* _tmp12_ = NULL;
					PeasExtension* _tmp13_ = NULL;
					GitgExtCommandLine* _tmp14_ = NULL;
					GitgExtCommandLine* _tmp15_ = NULL;
#line 100 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp11_ = engine;
#line 100 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp12_ = info;
#line 100 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp13_ = peas_engine_create_extension ((PeasEngine*) _tmp11_, _tmp12_, GITG_EXT_TYPE_COMMAND_LINE, NULL);
#line 100 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp14_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GITG_EXT_TYPE_COMMAND_LINE) ? ((GitgExtCommandLine*) _tmp13_) : NULL;
#line 100 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					if (_tmp14_ == NULL) {
#line 100 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
						_g_object_unref0 (_tmp13_);
#line 348 "gitg-application.c"
					}
#line 100 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					ext = _tmp14_;
#line 102 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp15_ = ext;
#line 102 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					if (_tmp15_ != NULL) {
#line 356 "gitg-application.c"
						GOptionContext* _tmp16_ = NULL;
						GitgExtCommandLine* _tmp17_ = NULL;
						GOptionGroup* _tmp18_ = NULL;
#line 104 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
						_tmp16_ = ctx;
#line 104 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
						_tmp17_ = ext;
#line 104 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
						_tmp18_ = gitg_ext_command_line_get_option_group (_tmp17_);
#line 104 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
						g_option_context_add_group (_tmp16_, _tmp18_);
#line 368 "gitg-application.c"
					}
#line 98 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (ext);
#line 372 "gitg-application.c"
				}
#line 96 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				__vala_PeasPluginInfo_free0 (info);
#line 376 "gitg-application.c"
			}
		}
	}
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp19_ = ctx;
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_option_context_parse (_tmp19_, argv_length1, argv, &_inner_error_);
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_inner_error_ != NULL) {
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		if (_inner_error_->domain == G_OPTION_ERROR) {
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			g_propagate_error (error, _inner_error_);
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			_g_object_unref0 (engine);
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			_g_option_context_free0 (ctx);
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			return;
#line 396 "gitg-application.c"
		} else {
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			_g_object_unref0 (engine);
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			_g_option_context_free0 (ctx);
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			g_clear_error (&_inner_error_);
#line 109 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			return;
#line 408 "gitg-application.c"
		}
	}
#line 86 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (engine);
#line 86 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_option_context_free0 (ctx);
#line 415 "gitg-application.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	result = g_new0 (gchar*, length + 1);
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	for (i = 0; i < length; i++) {
#line 426 "gitg-application.c"
		gchar* _tmp0_ = NULL;
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp0_ = g_strdup (self[i]);
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		result[i] = _tmp0_;
#line 432 "gitg-application.c"
	}
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	return result;
#line 436 "gitg-application.c"
}


static gboolean gitg_application_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status) {
	GitgApplication * self;
	gint _vala_exit_status = 0;
	gboolean result = FALSE;
	gchar** cp = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint cp_length1 = 0;
	gint _cp_size_ = 0;
	gchar** argv = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
#line 112 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = *arguments;
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0__length1 = _vala_array_length (*arguments);
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1__length1 = _tmp0__length1;
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	cp = _tmp1_;
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	cp_length1 = _tmp1__length1;
#line 115 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_cp_size_ = cp_length1;
#line 116 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp2_ = cp;
#line 116 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp2__length1 = cp_length1;
#line 116 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	argv = _tmp2_;
#line 116 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	argv_length1 = _tmp2__length1;
#line 116 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_argv_size_ = argv_length1;
#line 118 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_plugins_engine_initialize ();
#line 488 "gitg-application.c"
	{
#line 123 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gitg_application_parse_command_line (self, &argv, &argv_length1, &_inner_error_);
#line 123 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		if (_inner_error_ != NULL) {
#line 494 "gitg-application.c"
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
#line 120 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		e = _inner_error_;
#line 120 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_inner_error_ = NULL;
#line 127 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_vala_exit_status = 1;
#line 128 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		result = TRUE;
#line 128 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_g_error_free0 (e);
#line 128 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 128 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		if (exit_status) {
#line 128 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			*exit_status = _vala_exit_status;
#line 518 "gitg-application.c"
		}
#line 128 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		return result;
#line 522 "gitg-application.c"
	}
	__finally12:
#line 120 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_inner_error_ != NULL) {
#line 120 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 120 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 120 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		g_clear_error (&_inner_error_);
#line 120 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		return FALSE;
#line 535 "gitg-application.c"
	}
#line 131 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp3_ = gitg_application_options_quit;
#line 131 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp3_) {
#line 133 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_vala_exit_status = 0;
#line 134 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		result = TRUE;
#line 134 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 134 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		if (exit_status) {
#line 134 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			*exit_status = _vala_exit_status;
#line 551 "gitg-application.c"
		}
#line 134 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		return result;
#line 555 "gitg-application.c"
	}
#line 137 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp5_ = G_APPLICATION_CLASS (gitg_application_parent_class)->local_command_line ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication), arguments, &_tmp4_);
#line 137 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_vala_exit_status = _tmp4_;
#line 137 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	result = _tmp5_;
#line 137 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 137 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (exit_status) {
#line 137 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		*exit_status = _vala_exit_status;
#line 569 "gitg-application.c"
	}
#line 137 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	return result;
#line 573 "gitg-application.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 162 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	return self ? g_object_ref (self) : NULL;
#line 580 "gitg-application.c"
}


static void _vala_array_add1 (GFile*** array, int* length, int* size, GFile* value) {
#line 175 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if ((*length) == (*size)) {
#line 175 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 175 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 591 "gitg-application.c"
	}
#line 175 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	(*array)[(*length)++] = value;
#line 175 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	(*array)[*length] = NULL;
#line 597 "gitg-application.c"
}


static gint gitg_application_real_command_line (GApplication* base, GApplicationCommandLine* cmd) {
	GitgApplication * self;
	gint result = 0;
	gchar** arguments = NULL;
	GApplicationCommandLine* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gint arguments_length1 = 0;
	gint _arguments_size_ = 0;
	gchar** argv = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gboolean _tmp7_ = FALSE;
	GApplicationCommandLine* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GApplicationCommandLine* tmpcmd = NULL;
	GApplicationCommandLine* _tmp12_ = NULL;
	GApplicationCommandLine* _tmp13_ = NULL;
	GApplicationCommandLine* _tmp14_ = NULL;
	GApplicationCommandLine* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	GApplicationCommandLine* _tmp28_ = NULL;
	GApplicationCommandLine* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
#line 140 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 140 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (cmd != NULL, 0);
#line 142 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = cmd;
#line 142 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp2_ = g_application_command_line_get_arguments (_tmp0_, &_tmp1_);
#line 142 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	arguments = _tmp2_;
#line 142 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	arguments_length1 = _tmp1_;
#line 142 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_arguments_size_ = arguments_length1;
#line 143 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp3_ = arguments;
#line 143 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp3__length1 = arguments_length1;
#line 143 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	argv = _tmp3_;
#line 143 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	argv_length1 = _tmp3__length1;
#line 143 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_argv_size_ = argv_length1;
#line 652 "gitg-application.c"
	{
#line 147 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gitg_application_parse_command_line (self, &argv, &argv_length1, &_inner_error_);
#line 147 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		if (_inner_error_ != NULL) {
#line 658 "gitg-application.c"
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GApplicationCommandLine* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 145 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		e = _inner_error_;
#line 145 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_inner_error_ = NULL;
#line 151 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp4_ = cmd;
#line 151 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp5_ = e;
#line 151 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp6_ = _tmp5_->message;
#line 151 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		g_application_command_line_printerr (_tmp4_, "option parsing failed: %s\n", _tmp6_);
#line 152 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		result = 1;
#line 152 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_g_error_free0 (e);
#line 152 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 152 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		return result;
#line 689 "gitg-application.c"
	}
	__finally13:
#line 145 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_inner_error_ != NULL) {
#line 145 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 145 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 145 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		g_clear_error (&_inner_error_);
#line 145 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		return 0;
#line 702 "gitg-application.c"
	}
#line 155 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp7_ = gitg_application_options_quit;
#line 155 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp7_) {
#line 157 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		result = 0;
#line 157 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 157 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		return result;
#line 714 "gitg-application.c"
	}
#line 160 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp8_ = cmd;
#line 160 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp9_ = g_application_command_line_get_is_remote (_tmp8_);
#line 160 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (!_tmp9_) {
#line 722 "gitg-application.c"
		GApplicationCommandLine* _tmp10_ = NULL;
		GApplicationCommandLine* _tmp11_ = NULL;
#line 162 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp10_ = cmd;
#line 162 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 162 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (gitg_application_options_command_line);
#line 162 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gitg_application_options_command_line = _tmp11_;
#line 733 "gitg-application.c"
	}
#line 165 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp12_ = gitg_application_options_command_line;
#line 165 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 165 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	tmpcmd = _tmp13_;
#line 166 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp14_ = cmd;
#line 166 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 166 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (gitg_application_options_command_line);
#line 166 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_options_command_line = _tmp15_;
#line 168 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp16_ = argv;
#line 168 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp16__length1 = argv_length1;
#line 168 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp16__length1 > 1) {
#line 755 "gitg-application.c"
		GFile** files = NULL;
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		GFile** _tmp18_ = NULL;
		gint files_length1 = 0;
		gint _files_size_ = 0;
		gint _tmp19_ = 0;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		GFile** _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		const gchar* _tmp27_ = NULL;
#line 170 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp17_ = argv;
#line 170 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp17__length1 = argv_length1;
#line 170 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp18_ = g_new0 (GFile*, (_tmp17__length1 - 1) + 1);
#line 170 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		files = _tmp18_;
#line 170 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		files_length1 = _tmp17__length1 - 1;
#line 170 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_files_size_ = files_length1;
#line 171 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		files_length1 = 0;
#line 171 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp19_ = files_length1;
#line 173 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp20_ = argv;
#line 173 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp20__length1 = argv_length1;
#line 173 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp21_ = argv;
#line 173 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp21__length1 = argv_length1;
#line 794 "gitg-application.c"
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
#line 173 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			arg_collection = _tmp20_ + 1;
#line 173 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			arg_collection_length1 = _tmp21__length1 - 1;
#line 173 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			for (arg_it = 0; arg_it < (_tmp21__length1 - 1); arg_it = arg_it + 1) {
#line 806 "gitg-application.c"
				gchar* _tmp22_ = NULL;
				gchar* arg = NULL;
#line 173 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp22_ = g_strdup (arg_collection[arg_it]);
#line 173 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				arg = _tmp22_;
#line 813 "gitg-application.c"
				{
					GFile** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					const gchar* _tmp24_ = NULL;
					GFile* _tmp25_ = NULL;
#line 175 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp23_ = files;
#line 175 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp23__length1 = files_length1;
#line 175 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp24_ = arg;
#line 175 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp25_ = g_file_new_for_commandline_arg (_tmp24_);
#line 175 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_vala_array_add1 (&files, &files_length1, &_files_size_, _tmp25_);
#line 173 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_free0 (arg);
#line 831 "gitg-application.c"
				}
			}
		}
#line 178 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp26_ = files;
#line 178 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp26__length1 = files_length1;
#line 178 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp27_ = gitg_application_options_activity;
#line 178 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		g_application_open ((GApplication*) self, _tmp26_, _tmp26__length1, _tmp27_);
#line 168 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 845 "gitg-application.c"
	} else {
#line 182 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		g_application_activate ((GApplication*) self);
#line 849 "gitg-application.c"
	}
#line 185 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp28_ = tmpcmd;
#line 185 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp29_ = _g_object_ref0 (_tmp28_);
#line 185 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (gitg_application_options_command_line);
#line 185 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_options_command_line = _tmp29_;
#line 187 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	result = 1;
#line 187 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (tmpcmd);
#line 187 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 187 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	return result;
#line 867 "gitg-application.c"
}


static void gitg_application_on_app_new_window_activated (GitgApplication* self) {
#line 190 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 192 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_new_window (self, NULL, NULL);
#line 876 "gitg-application.c"
}


static void gitg_application_on_app_help_activated (GitgApplication* self) {
#line 195 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 883 "gitg-application.c"
}


static void gitg_application_on_app_about_activated (GitgApplication* self) {
	gchar** artists = NULL;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** authors = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar* copyright = NULL;
	gchar* _tmp5_ = NULL;
	gchar* comments = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GList* wnds = NULL;
	GList* _tmp8_ = NULL;
	GtkWindow* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	GtkWindow* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
#line 199 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 201 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_strdup ("Jakub Steiner <jimmac@gmail.com>");
#line 201 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 201 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1_[0] = _tmp0_;
#line 201 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	artists = _tmp1_;
#line 201 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	artists_length1 = 1;
#line 201 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_artists_size_ = artists_length1;
#line 202 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp2_ = g_strdup ("Jesse van den Kieboom <jessevdk@gnome.org>");
#line 202 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp3_ = g_strdup ("Ignacio Casal Quinteiro <icq@gnome.org>");
#line 202 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 202 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp4_[0] = _tmp2_;
#line 202 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp4_[1] = _tmp3_;
#line 202 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	authors = _tmp4_;
#line 202 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	authors_length1 = 2;
#line 202 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_authors_size_ = authors_length1;
#line 205 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp5_ = g_strdup ("Copyright \xc2\xa9 2012 Jesse van den Kieboom");
#line 205 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	copyright = _tmp5_;
#line 206 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp6_ = _ ("gitg is a Git repository viewer for gtk+/GNOME");
#line 206 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 206 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	comments = _tmp7_;
#line 208 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp8_ = gtk_application_get_windows ((GtkApplication*) self);
#line 208 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	wnds = _tmp8_;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp10_ = wnds;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp10_ != NULL) {
#line 965 "gitg-application.c"
		GList* _tmp11_ = NULL;
		gconstpointer _tmp12_ = NULL;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp11_ = wnds;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp12_ = _tmp11_->data;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp9_ = (GtkWindow*) _tmp12_;
#line 974 "gitg-application.c"
	} else {
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp9_ = NULL;
#line 978 "gitg-application.c"
	}
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp13_ = _tmp9_;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp14_ = artists;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp14__length1 = artists_length1;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp15_ = authors;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp15__length1 = authors_length1;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp16_ = copyright;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp17_ = comments;
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp18_ = _ ("translator-credits");
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp19_ = _ ("gitg homepage");
#line 210 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gtk_show_about_dialog (_tmp13_, "artists", _tmp14_, "authors", _tmp15_, "copyright", _tmp16_, "comments", _tmp17_, "translator-credits", _tmp18_, "version", VERSION, "website", PACKAGE_URL, "website-label", _tmp19_, "logo-icon-name", PACKAGE_NAME, "license-type", GTK_LICENSE_GPL_2_0, NULL);
#line 199 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_free0 (comments);
#line 199 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_free0 (copyright);
#line 199 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 199 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
#line 1008 "gitg-application.c"
}


static void gitg_application_on_app_quit_activated (GitgApplication* self) {
	GList* _tmp0_ = NULL;
#line 223 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 225 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 1018 "gitg-application.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 225 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		window_collection = _tmp0_;
#line 225 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 1026 "gitg-application.c"
			GtkWindow* window = NULL;
#line 225 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			window = (GtkWindow*) window_it->data;
#line 1030 "gitg-application.c"
			{
				GtkWindow* _tmp1_ = NULL;
#line 227 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp1_ = window;
#line 227 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 1037 "gitg-application.c"
			}
		}
	}
}


static void ___lambda65_ (GitgApplication* self, GtkWidget* w) {
#line 240 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_if_fail (w != NULL);
#line 241 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_preferences);
#line 241 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	self->priv->d_preferences = NULL;
#line 1051 "gitg-application.c"
}


static void ____lambda65__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 240 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	___lambda65_ ((GitgApplication*) self, _sender);
#line 1058 "gitg-application.c"
}


static void ___lambda66_ (GitgApplication* self, GtkDialog* w, gint r) {
	GitgPreferencesDialog* _tmp0_ = NULL;
#line 244 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_if_fail (w != NULL);
#line 245 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = self->priv->d_preferences;
#line 245 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1070 "gitg-application.c"
}


static void ____lambda66__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 244 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	___lambda66_ ((GitgApplication*) self, _sender, response_id);
#line 1077 "gitg-application.c"
}


static void gitg_application_on_preferences_activated (GitgApplication* self) {
	GList* wnds = NULL;
	GList* _tmp0_ = NULL;
	GitgPreferencesDialog* _tmp1_ = NULL;
	GList* _tmp5_ = NULL;
	GitgPreferencesDialog* _tmp9_ = NULL;
#line 231 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 233 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 233 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	wnds = _tmp0_;
#line 236 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1_ = self->priv->d_preferences;
#line 236 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp1_ == NULL) {
#line 1097 "gitg-application.c"
		gpointer _tmp2_ = NULL;
		GitgPreferencesDialog* _tmp3_ = NULL;
		GitgPreferencesDialog* _tmp4_ = NULL;
#line 238 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp2_ = gitg_resource_load_object (GITG_TYPE_PREFERENCES_DIALOG, (GBoxedCopyFunc) g_object_ref, g_object_unref, "ui/gitg-preferences.ui", "preferences");
#line 238 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (self->priv->d_preferences);
#line 238 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		self->priv->d_preferences = (GitgPreferencesDialog*) _tmp2_;
#line 240 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp3_ = self->priv->d_preferences;
#line 240 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		g_signal_connect_object ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda65__gtk_widget_destroy, self, 0);
#line 244 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp4_ = self->priv->d_preferences;
#line 244 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		g_signal_connect_object ((GtkDialog*) _tmp4_, "response", (GCallback) ____lambda66__gtk_dialog_response, self, 0);
#line 1115 "gitg-application.c"
	}
#line 249 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp5_ = wnds;
#line 249 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp5_ != NULL) {
#line 1121 "gitg-application.c"
		GitgPreferencesDialog* _tmp6_ = NULL;
		GList* _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
#line 251 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp6_ = self->priv->d_preferences;
#line 251 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp7_ = wnds;
#line 251 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp8_ = _tmp7_->data;
#line 251 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gtk_window_set_transient_for ((GtkWindow*) _tmp6_, (GtkWindow*) _tmp8_);
#line 1133 "gitg-application.c"
	}
#line 254 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp9_ = self->priv->d_preferences;
#line 254 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gtk_window_present ((GtkWindow*) _tmp9_);
#line 1139 "gitg-application.c"
}


static void gitg_application_real_startup (GApplication* base) {
	GitgApplication * self;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GtkSettings* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp8_ = NULL;
	GtkCssProvider* _tmp9_ = NULL;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp12_ = NULL;
	GtkIconTheme* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
#line 265 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 267 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (gitg_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 270 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_settings_new ("org.gnome.gitg.state.window");
#line 270 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_state_settings);
#line 270 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	self->priv->d_state_settings = _tmp0_;
#line 271 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1_ = self->priv->d_state_settings;
#line 271 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_settings_delay (_tmp1_);
#line 273 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_action_map_add_action_entries ((GActionMap*) self, GITG_APPLICATION_app_entries, G_N_ELEMENTS (GITG_APPLICATION_app_entries), self);
#line 276 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp2_ = gtk_settings_get_default ();
#line 276 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_object_get (_tmp2_, "gtk-shell-shows-app-menu", &_tmp3_, NULL);
#line 276 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp4_ = _tmp3_;
#line 276 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp4_) {
#line 1182 "gitg-application.c"
		GMenuModel* menu = NULL;
		gpointer _tmp5_ = NULL;
		GMenuModel* _tmp6_ = NULL;
#line 278 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp5_ = gitg_resource_load_object (g_menu_model_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, "ui/gitg-menus.ui", "app-menu");
#line 278 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		menu = (GMenuModel*) _tmp5_;
#line 280 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp6_ = menu;
#line 280 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		if (_tmp6_ != NULL) {
#line 1194 "gitg-application.c"
			GMenuModel* _tmp7_ = NULL;
#line 282 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			_tmp7_ = menu;
#line 282 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			gtk_application_set_app_menu ((GtkApplication*) self, _tmp7_);
#line 1200 "gitg-application.c"
		}
#line 276 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (menu);
#line 1204 "gitg-application.c"
	} else {
#line 287 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>N", "app.new", NULL);
#line 288 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>Q", "app.quit", NULL);
#line 289 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gtk_application_add_accelerator ((GtkApplication*) self, "F1", "app.help", NULL);
#line 1212 "gitg-application.c"
	}
#line 292 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>F", "win.search", NULL);
#line 293 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>W", "win.close", NULL);
#line 294 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "F5", "win.reload", NULL);
#line 295 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>R", "win.reload", NULL);
#line 296 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "F10", "win.gear-menu", NULL);
#line 299 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp8_ = gitg_resource_load_css ("style.css");
#line 299 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	provider = _tmp8_;
#line 300 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp9_ = provider;
#line 300 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp9_ != NULL) {
#line 1232 "gitg-application.c"
		GdkScreen* _tmp10_ = NULL;
		GtkCssProvider* _tmp11_ = NULL;
#line 302 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp10_ = gdk_screen_get_default ();
#line 302 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp11_ = provider;
#line 302 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gtk_style_context_add_provider_for_screen (_tmp10_, (GtkStyleProvider*) _tmp11_, (guint) 600);
#line 1241 "gitg-application.c"
	}
#line 307 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp12_ = gtk_icon_theme_get_default ();
#line 307 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 307 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	theme = _tmp13_;
#line 308 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp14_ = g_build_filename (GITG_DATADIR, "icons", NULL);
#line 308 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp15_ = _tmp14_;
#line 308 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gtk_icon_theme_prepend_search_path (theme, _tmp15_);
#line 308 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_free0 (_tmp15_);
#line 265 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (theme);
#line 265 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (provider);
#line 1261 "gitg-application.c"
}


static void gitg_application_real_shutdown (GApplication* base) {
	GitgApplication * self;
	GSettings* _tmp0_ = NULL;
#line 311 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 313 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = self->priv->d_state_settings;
#line 313 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_settings_apply (_tmp0_);
#line 314 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (gitg_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 1276 "gitg-application.c"
}


static void gitg_application_real_activate (GApplication* base) {
	GitgApplication * self;
	gboolean _tmp0_ = FALSE;
#line 317 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 330 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = gitg_application_options_no_wd;
#line 330 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp0_) {
#line 332 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gitg_application_present_window (self);
#line 1291 "gitg-application.c"
	} else {
		gchar* wd = NULL;
		GApplicationCommandLine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFile** _tmp6_ = NULL;
		GFile** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
#line 337 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp1_ = gitg_application_options_command_line;
#line 337 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp2_ = g_application_command_line_get_cwd (_tmp1_);
#line 337 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 337 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		wd = _tmp3_;
#line 339 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp4_ = wd;
#line 339 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp5_ = g_file_new_for_path (_tmp4_);
#line 339 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp6_ = g_new0 (GFile*, 1 + 1);
#line 339 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp6_[0] = _tmp5_;
#line 339 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp7_ = _tmp6_;
#line 339 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp7__length1 = 1;
#line 339 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp8_ = gitg_application_options_activity;
#line 339 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		g_application_open ((GApplication*) self, _tmp7_, 1, _tmp8_);
#line 339 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_object_unref), NULL);
#line 343 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gitg_application_present_window (self);
#line 330 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_g_free0 (wd);
#line 1333 "gitg-application.c"
	}
#line 346 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (gitg_application_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 1337 "gitg-application.c"
}


static GitgWindow* gitg_application_find_window_for_file (GitgApplication* self, GFile* file) {
	GitgWindow* result = NULL;
	GList* _tmp0_ = NULL;
#line 349 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 349 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 351 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 1350 "gitg-application.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 351 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		window_collection = _tmp0_;
#line 351 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 1358 "gitg-application.c"
			GtkWindow* _tmp1_ = NULL;
			GtkWindow* window = NULL;
#line 351 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			_tmp1_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 351 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			window = _tmp1_;
#line 1365 "gitg-application.c"
			{
				GitgWindow* wnd = NULL;
				GtkWindow* _tmp2_ = NULL;
				GitgWindow* _tmp3_ = NULL;
				GitgWindow* _tmp4_ = NULL;
				GitgRepository* _tmp5_ = NULL;
				GitgRepository* _tmp6_ = NULL;
				GitgRepository* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				GitgWindow* _tmp9_ = NULL;
				GitgRepository* _tmp10_ = NULL;
				GitgRepository* _tmp11_ = NULL;
				GitgRepository* _tmp12_ = NULL;
				GFile* _tmp13_ = NULL;
				GFile* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
#line 353 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp2_ = window;
#line 353 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_WINDOW) ? ((GitgWindow*) _tmp2_) : NULL);
#line 353 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				wnd = _tmp3_;
#line 355 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp4_ = wnd;
#line 355 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp5_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp4_);
#line 355 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp6_ = _tmp5_;
#line 355 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp7_ = _tmp6_;
#line 355 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp8_ = _tmp7_ == NULL;
#line 355 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (_tmp7_);
#line 355 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				if (_tmp8_) {
#line 357 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (wnd);
#line 357 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 357 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					continue;
#line 1410 "gitg-application.c"
				}
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp9_ = wnd;
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp10_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp9_);
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp11_ = _tmp10_;
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp12_ = _tmp11_;
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp13_ = ggit_repository_get_location ((GgitRepository*) _tmp12_);
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp14_ = _tmp13_;
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp15_ = file;
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp16_ = g_file_equal (_tmp14_, _tmp15_);
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp17_ = _tmp16_;
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (_tmp14_);
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (_tmp12_);
#line 360 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				if (_tmp17_) {
#line 362 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					result = wnd;
#line 362 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 362 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					return result;
#line 1442 "gitg-application.c"
				}
#line 351 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (wnd);
#line 351 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (window);
#line 1448 "gitg-application.c"
			}
		}
	}
#line 366 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	result = NULL;
#line 366 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	return result;
#line 1456 "gitg-application.c"
}


static void gitg_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	GitgApplication * self;
	GFile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GFile** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GError * _inner_error_ = NULL;
#line 369 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 369 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_if_fail (hint != NULL);
#line 371 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = files;
#line 371 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0__length1 = files_length1;
#line 371 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp0__length1 == 0) {
#line 373 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		return;
#line 1479 "gitg-application.c"
	}
#line 377 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1_ = files;
#line 377 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1__length1 = files_length1;
#line 1485 "gitg-application.c"
	{
		GFile** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 377 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		f_collection = _tmp1_;
#line 377 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		f_collection_length1 = _tmp1__length1;
#line 377 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		for (f_it = 0; f_it < _tmp1__length1; f_it = f_it + 1) {
#line 1497 "gitg-application.c"
			GFile* _tmp2_ = NULL;
			GFile* f = NULL;
#line 377 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			_tmp2_ = _g_object_ref0 (f_collection[f_it]);
#line 377 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
			f = _tmp2_;
#line 1504 "gitg-application.c"
			{
				GFile* resolved = NULL;
				GitgWindow* window = NULL;
				GFile* _tmp6_ = NULL;
				GitgWindow* _tmp7_ = NULL;
				GitgWindow* _tmp8_ = NULL;
				GitgRepository* repo = NULL;
				GitgRepository* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				{
					GFile* _tmp3_ = NULL;
					GFile* _tmp4_ = NULL;
					GFile* _tmp5_ = NULL;
#line 384 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp4_ = f;
#line 384 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp5_ = ggit_repository_discover (_tmp4_, &_inner_error_);
#line 384 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp3_ = _tmp5_;
#line 384 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					if (_inner_error_ != NULL) {
#line 1526 "gitg-application.c"
						goto __catch14_g_error;
					}
#line 384 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 384 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					resolved = _tmp3_;
#line 1533 "gitg-application.c"
				}
				goto __finally14;
				__catch14_g_error:
				{
#line 382 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 382 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_inner_error_ = NULL;
#line 386 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 386 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 386 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					continue;
#line 1548 "gitg-application.c"
				}
				__finally14:
#line 382 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				if (_inner_error_ != NULL) {
#line 382 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 382 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 382 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 382 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 382 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					return;
#line 1563 "gitg-application.c"
				}
#line 389 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp6_ = resolved;
#line 389 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp7_ = gitg_application_find_window_for_file (self, _tmp6_);
#line 389 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				window = _tmp7_;
#line 391 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp8_ = window;
#line 391 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				if (_tmp8_ != NULL) {
#line 1575 "gitg-application.c"
					GitgWindow* _tmp9_ = NULL;
					GApplicationCommandLine* _tmp10_ = NULL;
					gchar** _tmp11_ = NULL;
					gchar** _tmp12_ = NULL;
					GitgWindow* _tmp13_ = NULL;
#line 394 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp9_ = window;
#line 394 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp10_ = gitg_application_options_command_line;
#line 394 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp12_ = _tmp11_ = g_application_command_line_get_environ (_tmp10_);
#line 394 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					gitg_window_set_environment (_tmp9_, _tmp12_, _vala_array_length (_tmp11_));
#line 395 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp13_ = window;
#line 395 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					gtk_window_present ((GtkWindow*) _tmp13_);
#line 396 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 396 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 396 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 396 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					continue;
#line 1601 "gitg-application.c"
				}
				{
					GitgRepository* _tmp14_ = NULL;
					GFile* _tmp15_ = NULL;
					GitgRepository* _tmp16_ = NULL;
#line 404 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp15_ = resolved;
#line 404 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp16_ = gitg_repository_new (_tmp15_, NULL, &_inner_error_);
#line 404 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_tmp14_ = _tmp16_;
#line 404 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					if (_inner_error_ != NULL) {
#line 1615 "gitg-application.c"
						goto __catch15_g_error;
					}
#line 404 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (repo);
#line 404 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					repo = _tmp14_;
#line 1622 "gitg-application.c"
				}
				goto __finally15;
				__catch15_g_error:
				{
#line 402 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 402 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_inner_error_ = NULL;
#line 406 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (repo);
#line 406 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 406 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 406 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 406 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					continue;
#line 1641 "gitg-application.c"
				}
				__finally15:
#line 402 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				if (_inner_error_ != NULL) {
#line 402 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (repo);
#line 402 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 402 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 402 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 402 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 402 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 402 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
					return;
#line 1660 "gitg-application.c"
				}
#line 409 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp17_ = repo;
#line 409 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_tmp18_ = hint;
#line 409 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				gitg_application_new_window (self, _tmp17_, _tmp18_);
#line 377 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (repo);
#line 377 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (window);
#line 377 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (resolved);
#line 377 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (f);
#line 1676 "gitg-application.c"
			}
		}
	}
}


static void gitg_application_new_window (GitgApplication* self, GitgRepository* repo, const gchar* hint) {
	GitgWindow* window = NULL;
	GitgRepository* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GitgWindow* _tmp2_ = NULL;
	GitgWindow* _tmp3_ = NULL;
#line 413 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 415 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = repo;
#line 415 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1_ = hint;
#line 415 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp2_ = gitg_window_create_new ((GtkApplication*) self, _tmp0_, _tmp1_);
#line 415 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	window = _tmp2_;
#line 417 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp3_ = window;
#line 417 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp3_ != NULL) {
#line 1703 "gitg-application.c"
		GitgWindow* _tmp4_ = NULL;
		GApplicationCommandLine* _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
#line 419 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp4_ = window;
#line 419 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp5_ = gitg_application_options_command_line;
#line 419 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		_tmp7_ = _tmp6_ = g_application_command_line_get_environ (_tmp5_);
#line 419 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gitg_window_set_environment (_tmp4_, _tmp7_, _vala_array_length (_tmp6_));
#line 1716 "gitg-application.c"
	}
#line 422 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_present_window (self);
#line 413 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (window);
#line 1722 "gitg-application.c"
}


static void gitg_application_present_window (GitgApplication* self) {
	GList* windows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GitgWindow* w = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	GitgWindow* _tmp5_ = NULL;
	GitgWindow* _tmp6_ = NULL;
	GApplicationCommandLine* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	GitgWindow* _tmp10_ = NULL;
#line 425 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 431 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 431 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	windows = _tmp0_;
#line 433 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1_ = windows;
#line 433 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	if (_tmp1_ == NULL) {
#line 435 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		gitg_application_new_window (self, NULL, NULL);
#line 436 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		return;
#line 1754 "gitg-application.c"
	}
#line 439 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp2_ = windows;
#line 439 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp3_ = g_list_first (_tmp2_);
#line 439 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp4_ = _tmp3_->data;
#line 439 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkWindow*) _tmp4_, GITG_TYPE_WINDOW, GitgWindow));
#line 439 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	w = _tmp5_;
#line 441 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp6_ = w;
#line 441 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp7_ = gitg_application_options_command_line;
#line 441 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp9_ = _tmp8_ = g_application_command_line_get_environ (_tmp7_);
#line 441 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_window_set_environment (_tmp6_, _tmp9_, _vala_array_length (_tmp8_));
#line 442 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp10_ = w;
#line 442 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gtk_window_present ((GtkWindow*) _tmp10_);
#line 425 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (w);
#line 1780 "gitg-application.c"
}


GSettings* gitg_application_get_state_settings (GitgApplication* self) {
	GSettings* result;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 29 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = self->priv->d_state_settings;
#line 29 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 29 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	result = _tmp1_;
#line 29 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	return result;
#line 1798 "gitg-application.c"
}


static void gitg_application_options_commit_activity (void) {
	gchar* _tmp0_ = NULL;
#line 50 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_strdup ("commit");
#line 50 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_free0 (gitg_application_options_activity);
#line 50 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_options_activity = _tmp0_;
#line 1810 "gitg-application.c"
}


static GitgApplicationOptions* gitg_application_options_dup (const GitgApplicationOptions* self) {
	GitgApplicationOptions* dup;
#line 40 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	dup = g_new0 (GitgApplicationOptions, 1);
#line 40 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	memcpy (dup, self, sizeof (GitgApplicationOptions));
#line 40 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	return dup;
#line 1822 "gitg-application.c"
}


static void gitg_application_options_free (GitgApplicationOptions* self) {
#line 40 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_free (self);
#line 1829 "gitg-application.c"
}


static GType gitg_application_options_get_type (void) {
	static volatile gsize gitg_application_options_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_application_options_type_id__volatile)) {
		GType gitg_application_options_type_id;
		gitg_application_options_type_id = g_boxed_type_register_static ("GitgApplicationOptions", (GBoxedCopyFunc) gitg_application_options_dup, (GBoxedFreeFunc) gitg_application_options_free);
		g_once_init_leave (&gitg_application_options_type_id__volatile, gitg_application_options_type_id);
	}
	return gitg_application_options_type_id__volatile;
}


static void gitg_application_class_init (GitgApplicationClass * klass) {
	gchar* _tmp0_ = NULL;
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_type_class_add_private (klass, sizeof (GitgApplicationPrivate));
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (klass)->local_command_line = gitg_application_real_local_command_line;
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (klass)->command_line = gitg_application_real_command_line;
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (klass)->startup = gitg_application_real_startup;
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (klass)->shutdown = gitg_application_real_shutdown;
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (klass)->activate = gitg_application_real_activate;
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (klass)->open = gitg_application_real_open;
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_application_get_property;
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_application_finalize;
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_APPLICATION_STATE_SETTINGS, g_param_spec_object ("state-settings", "state-settings", "state-settings", G_TYPE_SETTINGS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 74 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_strdup ("");
#line 74 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_free0 (gitg_application_options_activity);
#line 74 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	gitg_application_options_activity = _tmp0_;
#line 1874 "gitg-application.c"
}


static void gitg_application_instance_init (GitgApplication * self) {
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	self->priv = GITG_APPLICATION_GET_PRIVATE (self);
#line 1881 "gitg-application.c"
}


static void gitg_application_finalize (GObject* obj) {
	GitgApplication * self;
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_APPLICATION, GitgApplication);
#line 25 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_state_settings);
#line 70 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_preferences);
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	G_OBJECT_CLASS (gitg_application_parent_class)->finalize (obj);
#line 1895 "gitg-application.c"
}


GType gitg_application_get_type (void) {
	static volatile gsize gitg_application_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgApplication), 0, (GInstanceInitFunc) gitg_application_instance_init, NULL };
		GType gitg_application_type_id;
		gitg_application_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "GitgApplication", &g_define_type_info, 0);
		g_once_init_leave (&gitg_application_type_id__volatile, gitg_application_type_id);
	}
	return gitg_application_type_id__volatile;
}


static void _vala_gitg_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_APPLICATION, GitgApplication);
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
	switch (property_id) {
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		case GITG_APPLICATION_STATE_SETTINGS:
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		g_value_take_object (value, gitg_application_get_state_settings (self));
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		break;
#line 1922 "gitg-application.c"
		default:
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/git/gnome/gitg/gitg/gitg-application.vala"
		break;
#line 1928 "gitg-application.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



