/* $Id$

   Copyright (C) 2018 Ole Aamot Software
   Author(s): Ole Aamot <ole@gnome.org>
   License: GNU GPL version 3
   Version: 0.0.5 (2018-07-23)
   Website: http://www.gingerblue.org/

 */

#include <stdlib.h>
#include <gst/gst.h>
#include <gst/player/player.h>
#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <glib/gi18n.h>
#include "gingerblue.h"

GingerblueData *gingerblue_data;

int main (int argc, char **argv) {
	GDateTime *datestamp;
	GingerblueData *data;
	GstPlayer *player;
	GtkWidget *window;
	GtkWidget *frame;
	GtkWidget *input;
	GtkWidget *mixer;
	GtkWidget *control;
	GtkWidget *soundboard;
	GtkWidget *toolbar;
	GtkWidget *input_record;
	GtkWidget *input_pause;
	GtkWidget *input_break;
	GtkWidget *input_stop;
	GtkWidget *input_volume;
	gdouble input_volume_value;
	gint64 real_time;
	gtk_init (&argc, &argv);
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width (GTK_CONTAINER (window), 10);
	gtk_window_set_title (GTK_WINDOW (window), _("GNOME Gingerblue 0.0.5 (2018-07-23)"));
	gtk_window_set_default_size (GTK_WINDOW (window), 720, 540);
	soundboard = gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
	input_volume = gtk_volume_button_new ();
	/* input_record = gtk_record_button_new (); // media-record-symbolic */
	/* input_record = gtk_tool_button_new(gtk_image_new_from_icon_name(NULL, GTK_ICON_SIZE_BUTTON), _("Record")); */
	/* input_record = gtk_button_new_with_label ("Record"); */
	/* input_pause = gtk_button_new_with_label ("Pause"); */
	/* input_break = gtk_button_new_with_label ("Break"); 	 */
	frame = gtk_frame_new (NULL);
	/* gtk_container_add (GTK_CONTAINER (mixer), GTK_BUTTON(input_record)); */
	/* gtk_container_add (GTK_CONTAINER (input), GTK_BUTTON(input_pause));	 */
	/* gtk_container_add (GTK_CONTAINER (control), GTK_BUTTON(input_break));	 */
	gtk_container_add (GTK_CONTAINER (frame), GTK_BUTTON(input_volume));
	gtk_container_add (GTK_CONTAINER (soundboard), frame);
	gtk_container_add (GTK_CONTAINER (window), soundboard);
	/* toolbar = gtk_toolbar_new (); */
	/* gtk_box_pack_start (GTK_BOX (soundboard),  */
	gtk_widget_show_all (window);
	real_time = g_get_real_time();
	g_printf ("SETUP: Copy gingerblue.xml to \"%s\"\n", g_strconcat(g_get_home_dir(), _("/Music/"), g_get_real_name(), " - Song.gingerblue", NULL));
	gingerblue_data = gb_file_config_load (gingerblue_data, g_strconcat(g_get_home_dir(), _("/Music/"), g_get_real_name(), " - Song.gingerblue", NULL));
	g_printf ("CONFIG volume: %0.2f\n", atof(gingerblue_data->volume));
	gtk_scale_button_set_value (GTK_SCALE_BUTTON (input_volume), atof(gingerblue_data->volume));
	gst_init (&argc, &argv);
	/* player = play_new ("http://stream.radionorwegian.com/56.ogg", gingerblue_data->volume); */
	/* input_volume_value = gb_window_set_volume(GTK_VOLUME_BUTTON (input_volume), 0.00);   *\/ */
	/* g_signal_connect (GTK_BUTTON (input_record), "clicked", G_CALLBACK (gb_window_new_record), gingerblue_data->volume); */
	/* g_signal_connect (GTK_BUTTON (input_pause), "clicked", G_CALLBACK (gb_window_pause_record), gingerblue_data->volume); */
	/* g_signal_connect (GTK_BUTTON (input_break), "clicked", G_CALLBACK (gb_window_break_record), gingerblue_data->volume); */
	/* g_signal_connect (GTK_VOLUME_BUTTON (input_volume), "value-changed", G_CALLBACK (gb_window_pause_record), gingerblue_data->volume); */
	/* g_signal_connect (GTK_VOLUME_BUTTON (input_volume), "value-changed", G_CALLBACK (gb_window_store_volume), gingerblue_data->volume);	 */
	g_signal_connect (GTK_WINDOW (window), "destroy", G_CALLBACK (gtk_main_quit), NULL);
	g_free (gingerblue_data);
	/* play_free (player); */
	/* g_date_time_free (datestamp); */
	gtk_main ();
	return (0);
}
