/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_WINDOW_H
#define GI_WINDOW_H

#include <bonobo.h>
#include <libgide/libgide.h>

#define GIDE_WINDOW(o)          (GTK_CHECK_CAST ((o), gI_window_get_type(), GideWindow))
#define GIDE_WINDOW_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), gI_window_get_type(), GideWindowClass))
#define IS_GIDE_WINDOW(o)       (GTK_CHECK_TYPE ((o), gI_window_get_type()))

typedef struct _GideWindowClass         GideWindowClass;

struct _GideWindowClass {
	BonoboWindowClass   parent_class;
};

typedef struct _GideWindow		GideWindow;

struct _GideWindow {
	BonoboWindow app;
	BonoboUIComponent *uic;
	BonoboUIContainer *ui_container;

	GtkWidget *hpane;
	GtkWidget *vpane;
	
	GtkWidget *notebook;
	GtkWidget *debug_notebook;
	GtkWidget *build_notebook;
	GtkWidget *statusbar;

	GtkWidget *compile_dialog;
	
	GList *menu_items;	
	GList *documents;

	GtkWidget *hpane1;
	GtkWidget *hpane2;
	GtkWidget *vpane1;
	GtkWidget *vpane2;
	GtkWidget *tree_box;

	GtkWidget *tree_frame;
	GtkWidget *toolbar;

	GtkWidget *notebooks[GIDE_WINDOW_LOC_LAST];
	
	gint timeout_id;
	gint switch_page_id;

	gint debug_id;
};

/* Pointer to the main window. Obsolete, shouldn't be used */
extern GideWindow			*main_window;

/*
 * Prototypes for 'gI_window.c'
 */
guint gI_window_get_type (void);
GtkWidget *gI_window_new (void);

void gI_window_add_widget (GideWindow *window, 
			   GtkWidget *w, 
			   const gchar *title,
			   GNOME_Development_Environment_Shell_WindowLocation loc);
void gI_window_remove_widget (GideWindow *window,
			      GtkWidget *w);
void gI_window_set_cfg_values (GideWindow *window);
void gI_window_set_build (GideWindow *window, const gchar *file);
void gI_window_set_debug (GideWindow *window, const gchar *file);

/* Title functions */
void gI_window_update_title( GideWindow *window );

/* Status bar */
void gI_window_set_statusbar (GideWindow *window);
void gI_window_clear_statusbar (GideWindow *window);

/* Project tree */
void gI_window_set_visible_read_only( gint sensitive );

#define STATUSBAR_CONTEXT_CURSOR_POSITION 100

#endif

