/*
 * gIDE docstat plugin
 *
 * Shows statistics about the current document
 */

#include <config.h>

#include <libgide/libgide.h>
#include <unistd.h>
#include <sys/stat.h>
#include <ctype.h>

#define DOCSTAT_COMPONENT_IID "OAFIID:GNOME_Development_Plugin:docstat"
#define PLUGIN_NAME			"gide-docstat-plugin"
#define PLUGIN_XML			"gide-docstat-plugin.xml"

static void
docstat(
	GtkWidget*			widget,
	gpointer			data
)
{
	GideTool*			tool = (GideTool*)data;
	gchar				tmp[255];
	gchar*				c;
	gint				in_word = 0;
	glong				words = 0;
	glong				chars = 0;
	glong				chars_ns = 0;
	GtkWidget*			dlg;
	GtkWidget*			label;
	glong				i;
	glong				length;

	length = gide_get_document_length(tool);

	/* go thru document... */
	for(i = 1; i <= length; i++)
	{
		c = gide_get_document_chars(tool, i - 1, i);

		/* Character/Word Counters */
		chars++;
		if(!isspace(*c))
		{
			chars_ns++;

			if(*c == ',' || *c == ';' || *c == ':' || *c == '.')
			{
				if(in_word)
				{
					in_word = 0;
				}
			}
			else
			{
				if(!in_word)
				{
					in_word = 1;
					words++;
				}
			}
		}
		else
		{
			if(in_word)
			{
				in_word = 0;
			}
		}

		g_free(c);
	}

	/* Dialog */
	dlg = gnome_dialog_new("Tools - Word Count", GNOME_STOCK_BUTTON_OK,
		NULL);

	g_snprintf(tmp, 255, _("Characters: %ld"), chars);
	label = gtk_label_new(tmp);
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox), label, FALSE,
		TRUE, 5);

	g_snprintf(tmp, 255, _("Non-Space Characters: %ld"), chars_ns);
	label = gtk_label_new(tmp);
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox), label, FALSE,
		TRUE, 5);

	g_snprintf(tmp, 255, _("Words: %ld"), words);
	label = gtk_label_new(tmp);
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox), label, FALSE,
		TRUE, 5);

	gnome_dialog_run_and_close(GNOME_DIALOG(dlg));
}

/*
 * Define the verbs in this plugin
 */
static BonoboUIVerb verbs[] = {
	BONOBO_UI_UNSAFE_VERB("DocStat", docstat),
	BONOBO_UI_VERB_END
};

/*
 * Boilerplate initialization function
 */
static gboolean
impl_init(
	GideTool*			tool,
	gpointer			closure
)
{
	BonoboUIComponent*		uic;
	CORBA_Environment		ev;

	g_return_val_if_fail(tool != NULL, FALSE);
	g_return_val_if_fail(GIDE_IS_TOOL(tool), FALSE);

	CORBA_exception_init(&ev);

	uic = bonobo_ui_component_new(PLUGIN_NAME);
	bonobo_ui_component_set_container(uic, tool->ui_container);
	bonobo_ui_util_set_ui(uic, GIDE_DATADIR, PLUGIN_XML,
		PLUGIN_NAME);

	bonobo_ui_component_add_verb_list_with_data(uic, verbs, tool);

	CORBA_exception_free(&ev);

	return TRUE;
}

/*
 * Boilerplace cleanup function
 */
static void
impl_cleanup(
	GideTool*			tool,
	gpointer			closure
)
{
}

/*
 * Boilerplate creation function
 */
static CORBA_Object
make_object(
	PortableServer_POA		poa,
	const char*			iid,
	gpointer			impl_ptr,
	CORBA_Environment*		ev
)
{
	GideTool*			tool;

	tool = gide_tool_new(impl_init, impl_cleanup, NULL);

	oaf_plugin_use(poa, impl_ptr);

	return BONOBO_OBJREF (tool->props);
}

/*
 * List of plugins
 */
static const OAFPluginObject plugin_list[] =
{
	{
		DOCSTAT_COMPONENT_IID,
		make_object
	},
	{
		NULL
	}
};

/*
 * Plugin description
 */
const OAFPlugin OAF_Plugin_info = {
	plugin_list,
	"gIDE Document Status Plugin"
};
