/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * GGV Bonobo stuff server
 *
 * Authors:
 *   Jaka Mocnik  <jaka@gnu.org>
 *
 * Inspired by Martin Baulig's EOG image viewer
 */

#include <config.h>
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#include <gnome.h>
#include <liboaf/liboaf.h>

#include <bonobo.h>

#include <ggv-control.h>
#if 0
#include <ggv-embeddable.h>
#endif

static BonoboObject *
ggv_postscript_viewer_factory (BonoboGenericFactory *this, const char *oaf_iid,
			       void *data)
{
	GtkWidget *gs;
	GgvPostscriptView *ps_view;
	GtkAdjustment *hadj, *vadj;
	BonoboObject *retval;

	g_return_val_if_fail (this != NULL, NULL);
	g_return_val_if_fail (oaf_iid != NULL, NULL);

	hadj = GTK_ADJUSTMENT(gtk_adjustment_new(0.0, 0.0, 1.0, 0.01, 0.1, 0.09));
	vadj = GTK_ADJUSTMENT(gtk_adjustment_new(0.0, 0.0, 1.0, 0.01, 0.1, 0.09));
	gs = gtk_gs_new(hadj, vadj);

	ps_view = ggv_postscript_view_new(GTK_GS(gs), FALSE);

	if (!strcmp (oaf_iid, "OAFIID:GNOME_GGV_Control"))
		retval = BONOBO_OBJECT (ggv_control_new (ps_view));
	/*
	else if (!strcmp (oaf_iid, "OAFIID:GNOME_GGV_Embeddable"))
		retval = BONOBO_OBJECT (ggv_embeddable_new (ps_view));
	*/
	else if(!strcmp(oaf_iid, "OAFIID:GNOME_GGV_PostscriptView")) {
		retval = BONOBO_OBJECT(ps_view);
		bonobo_object_ref (BONOBO_OBJECT (ps_view));
	}
	else {
		g_warning ("Unknown IID `%s' requested", oaf_iid);
		return NULL;
	}

	bonobo_object_unref (BONOBO_OBJECT (ps_view));

	return retval;
}

static void
init_ggv_postscript_viewer_factory (void)
{
	BonoboGenericFactory *factory;

	factory = bonobo_generic_factory_new_multi (
		"OAFIID:GNOME_GGV_Factory",
		ggv_postscript_viewer_factory, NULL);

	bonobo_running_context_auto_exit_unref (
		BONOBO_OBJECT (factory));
}

static void
init_server_factory (int argc, char **argv)
{
	CORBA_Environment ev;
	CORBA_exception_init (&ev);

        gnome_init_with_popt_table ("ggv-postscript-viewer", VERSION,
				    argc, argv,
				    oaf_popt_options, 0, NULL); 
	oaf_init (argc, argv);

	if (bonobo_init (CORBA_OBJECT_NIL, CORBA_OBJECT_NIL, CORBA_OBJECT_NIL) == FALSE)
		g_error (_("I could not initialize Bonobo"));

	CORBA_exception_free (&ev);
}

int
main (int argc, char *argv [])
{
	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);

        gconf_init (argc, argv, NULL);

	init_server_factory (argc, argv);

	init_ggv_postscript_viewer_factory ();

	bonobo_main ();
	
	return 0;
}
