import pygtk
pygtk.require('2.0')
import gtk.glade
import vte

import gettext
gettext.textdomain("gevice")
from gettext import gettext as _

import config

class GeviceVte:
    def __init__ (self):
        self.hbox_label = None
        self.label = None
        self.hbox_term = None
        self.terminal = None
        self.scroll = None
        self.button_close = None
    
    def load_interface (self,name,gevice):
        self.hbox_label = gtk.HBox(False,0)
        self.label = gtk.Label(name)
        self.hbox_label.pack_start(self.label,False,False,1)
        
        self.hbox_term = gtk.HBox(False)
        self.terminal = vte.Terminal()
        self.terminal.set_mouse_autohide(True)
        self.scroll = gtk.VScrollbar(self.terminal.get_adjustment())
        
        self.hbox_term.pack_start(self.terminal,True,True,0)
        self.hbox_term.pack_start(self.scroll,False,False,0)
        
        self.terminal.set_default_colors()
        self.terminal.set_color_background(gtk.gdk.color_parse(gevice.gpref.backcolor))
        self.terminal.set_color_foreground(gtk.gdk.color_parse(gevice.gpref.forecolor))
        
        self.button_close = gevice.create_button_with_image ('gtk-close',True)
        self.hbox_label.pack_start(self.button_close,True,False,0)
        self.button_close.connect('clicked',gevice.close_page_of_notebook,self.hbox_term)
    
    def open_terminal (self,ip,proto,gevice):
        
	user = gevice.combobox_user.get_active_text()

        self.terminal.fork_command (proto,
        ['bash','-l',user,ip],
        None,
        config.DEFAULT_TMP,
        False,
        False,
        False)
    
    def show_interface (self):
        self.hbox_label.show_all()
        self.hbox_term.show_all()
