import pygtk
pygtk.require('2.0')
import gtk.glade
import os
from pygraphviz import *

import gettext
gettext.textdomain("gevice")
from gettext import gettext as _

import config

class GeviceDiagram:
    def __init__ (self):
        self.window_diagram = None
        self.button_diagram_cancel = None
        self.button_diagram_generate = None
        self.combobox_program = None
        self.combobox_format = None
        
        self.iterfirst = None

        self.A = None
        
        self.form = None
        self.prog = None

    def load_interface (self,gevice):
        glade_file = gtk.glade.XML (os.path.join (config.GLADEDIR, "gevice.glade"),"window_diagram",None)
        self.window_diagram = glade_file.get_widget ("window_diagram")
        self.button_diagram_cancel = glade_file.get_widget ("button_diagram_cancel")
        self.button_diagram_generate = glade_file.get_widget ("button_diagram_generate")
        self.combobox_program = glade_file.get_widget ("combobox_program")
        self.combobox_format = glade_file.get_widget ("combobox_format")

        # set default value for diagram
        self.combobox_format.set_active (0)
        self.combobox_program.set_active (0)

        self.window_diagram.connect ("delete-event",self.on_window_diagram_delete_event)
        self.button_diagram_cancel.connect ("clicked",self.on_button_diagram_cancel_clicked)
        self.button_diagram_generate.connect ("clicked",self.on_button_diagram_generate_clicked,gevice)		

    def show_interface (self):
        self.window_diagram.show_all()

    def close_window (self,window):
        window.destroy()

    def on_button_diagram_cancel_clicked (self,button):
        self.close_window(self.window_diagram)

    def on_window_diagram_delete_event (self,window,event):
        self.close_window(window)

    def on_button_diagram_generate_clicked (self,button,gevice):
        
        self.A = AGraph()
        
        # attributes of nodes
        self.A.node_attr['shape'] = 'box'
        self.A.node_attr['color'] = 'black'
        
        self.form = self.combobox_format.get_active_text()
        self.prog = self.combobox_program.get_active_text()

        i = gevice.gmodel.get_iter_selected(gevice.gmodel.treeview)
        name = gevice.gmodel.treestore.get(i["iter"],config.COLUMN_NAME_DEV)
        ###name = self.join_name(i["iter"],gevice)
        
        self.iterfirst = i["iter"]
        self.print_child (gevice,i["iter"],name[0])

        file = config.DEFAULT_TMP + name[0] + "." + self.form
        self.A.draw(file,format=self.form,prog=self.prog) 

        # show diagram with eog (FIXME: call to default viewer)
        id = os.spawnlp(os.P_NOWAIT,'eog','eog',file)

    def join_name (self,iter,gevice):
        name,ip,model,type_link = gevice.gmodel.treestore.get(iter,
            config.COLUMN_NAME_DEV,
            config.COLUMN_IP_DEV,
            config.COLUMN_NAME_MODEL_DEV,
            config.COLUMN_ID_TYPE_LINK_DEV)

        ###pix_link,name_link = gevice.gmodel.get_data_of_link_from_key (type_link,gevice)

        ###if (gevice.gpref.diagip):
        ###    name = name + '[' + ip + ']'

        ###if (gevice.gpref.diagmodel):
        ###    name = name + '[' + model + ']'

        ###if (gevice.gpref.diaglink):
        ###    name = name + '[' + name_link + ']'

        return name

    def print_child(self,gevice,parent_iter,parent_name):
        while (parent_iter):
            name = self.join_name (parent_iter,gevice)
            self.join_nodes (parent_name,name)

            if gevice.gmodel.treestore.iter_has_child(parent_iter):
                child = gevice.gmodel.treestore.iter_children(parent_iter)
                self.print_child (gevice,child,name)
            
            if (not self.iterfirst == parent_iter):
                next_iter = gevice.gmodel.treestore.iter_next(parent_iter)
                parent_iter = next_iter
            else:
                return

    def join_nodes (self,parent,child):
        self.A.edge_attr['color'] = 'black'
        self.A.add_edge(parent,child)
