import pygtk
pygtk.require('2.0')
import gtk
import gobject
import os

import gettext
gettext.textdomain("gevice")
from gettext import gettext as _

import psycopg2
import config

class GeviceDatabase:
    def __init__ (self):
        self.dbase = None
        self.user = None
        self.host = None
        self.passwd = None

        self.conn = None
        self.cur = None
        
        self.devices_to_connect = []
        
    
    def connect (self,passwd,gevice):
        try:
            conn = psycopg2.connect("dbname=" + gevice.gpref.dbase + " user=" + gevice.gpref.user_dbase + " host=" + gevice.gpref.host + " password=" + passwd)
            return conn
        except:
            result = gevice.show_message (_("Unable to connect to the database"),gtk.MESSAGE_ERROR,gtk.BUTTONS_OK)
            return False


    def execute_sql_select (self,gevice,sql):
        try:
            self.cur.execute(sql)
            rows = self.cur.fetchall()
            return rows
        except:
            result = gevice.show_message (_("Unable to execute SQL: " + sql),gtk.MESSAGE_ERROR,gtk.BUTTONS_OK)
            return False
        
    def execute_sql_insert (self,gevice,sql):
        try:
            self.cur.execute(sql)
            return True
        except:
            result = gevice.show_message (_("Unable to execute SQL: " + sql),gtk.MESSAGE_ERROR,gtk.BUTTONS_OK)
            return False
            
    def execute_sql_delete (self,gevice,sql):
        try:
            self.cur.execute(sql)
            return True
        except:
            result = gevice.show_message (_("Unable to execute SQL: " + sql),gtk.MESSAGE_ERROR,gtk.BUTTONS_OK)
            return False

    def execute_sql_update (self,gevice,sql):
        try:
            self.cur.execute(sql)
            return True
        except:
            result = gevice.show_message (_("Unable to execute SQL: " + sql),gtk.MESSAGE_ERROR,gtk.BUTTONS_OK)
            return False

    def load_interface (self,gevice):
		glade_file = gtk.glade.XML (os.path.join (config.GLADEDIR, "gevice.glade"),"window_database",None)
		self.window_database = glade_file.get_widget ("window_database")
		self.button_connect_cancel = glade_file.get_widget ("button_connect_cancel")
		self.button_connect_dbase = glade_file.get_widget ("button_connect_dbase")
		self.label_host = glade_file.get_widget ("label_host")
		self.label_dbase = glade_file.get_widget ("label_dbase")
		self.label_user_dbase = glade_file.get_widget ("label_user_dbase")
		self.entry_passwd_dbase = glade_file.get_widget ("entry_passwd_dbase")
		
		self.entry_passwd_dbase.connect ("key-press-event", self.on_entry_passwd_dbase_key_press,gevice)		
		self.button_connect_dbase.connect ("clicked",self.on_button_connect_dbase_clicked,gevice)
		self.button_connect_cancel.connect ("clicked",self.on_button_connect_cancel_clicked)

    def load_interface_save (self,gevice):
		glade_file = gtk.glade.XML (os.path.join (config.GLADEDIR, "gevice.glade"),"window_database_save",None)
		self.window_database = glade_file.get_widget ("window_database_save")
		self.button_connect_cancel = glade_file.get_widget ("button_connect_cancel1")
		self.button_connect_dbase = glade_file.get_widget ("button_connect_dbase1")
		self.label_host = glade_file.get_widget ("label_host1")
		self.label_dbase = glade_file.get_widget ("label_dbase1")
		self.label_user_dbase = glade_file.get_widget ("label_user_dbase1")
		self.entry_passwd_dbase = glade_file.get_widget ("entry_passwd_dbase1")
		
		self.entry_passwd_dbase.connect ("key-press-event", self.on_entry_passwd_dbase_key_press_save,gevice)		
		self.button_connect_dbase.connect ("clicked",self.on_button_connect_dbase_clicked_save,gevice)
		self.button_connect_cancel.connect ("clicked",self.on_button_connect_cancel_clicked)


    def close_window (self,window):
	    window.destroy()


    def on_entry_passwd_dbase_key_press (self,widget,event,gevice):
        if gtk.gdk.keyval_name(event.keyval) == "Return":
            self.on_button_connect_dbase_clicked(None,gevice)

    def on_entry_passwd_dbase_key_press_save (self,widget,event,gevice):
        if gtk.gdk.keyval_name(event.keyval) == "Return":
            self.on_button_connect_dbase_clicked_save(None,gevice)

    def on_button_connect_cancel_clicked (self,button):
        self.close_window (self.window_database)


    def on_button_connect_dbase_clicked (self,button,gevice):
        passwd = self.entry_passwd_dbase.get_text()
        self.conn = self.connect(passwd,gevice)
        
        if (self.conn):
            gevice.connected_to_database = True
            self.cur = self.conn.cursor()
            
            self.load_data_from_database(gevice)

            action_open = gevice.actiongroup_window.get_action("Open")
            action_open.set_property ("stock-id",gtk.STOCK_CONNECT)
            action_open.set_property ("tooltip",_("Disconnect from database"))
            action_open.set_property ("label",_("Disconnect"))
            
            self.close_window (self.window_database)
        else:
            gevice.connected_to_database = False

    def on_button_connect_dbase_clicked_save (self,button,gevice):
	passwd = self.entry_passwd_dbase.get_text()
	self.conn = self.connect(passwd,gevice)

	if (self.conn):
	    gevice.connected_to_database = True
	    self.cur = self.conn.cursor()

	    self.save_data_to_database(gevice)
	
	    self.close_window (self.window_database)
	else:
	    gevice.connected_to_database = False

    def show_interface (self):
    	self.window_database.show_all()

    
    def load_data_from_database (self,gevice):
        gevice.gmodel.treestore.clear()
        gevice.gmodel.treeview.set_model(None)
        gevice.gmodel.treeview.set_model(gevice.gmodel.treestore)

        self.lserial = []
        sql = "select dispositivo.serial from dispositivo where dispositivo.serial "
        sql = sql + "not in (select serialh from conecta order by serialh)"
        
        rows = self.execute_sql_select(gevice,sql)

        if rows:        
            # copy to list
            for row in rows:
                self.lserial.append(row[0])
        
            # for every serial, get your children
            token = None
            for serial in self.lserial:
                if (not serial == token):
                
                    self.process_row (serial,None,0,gevice)
                    token = serial
            
            gevice.gmodel.treeview.expand_all()
        
        
        gevice.actiongroup_model.set_sensitive(True)
        gevice.actiongroup_device.set_sensitive (True)



    def process_row (self,serial,iterp,id_type_link,gevice):
        sql = "select nom_disp,id_modelo,nom_tipo_disp || ' ' || nom_marca || ' ' || nom_modelo, "
        sql = sql + "ip_disp,serial,obs_disp "
        sql = sql + " from todoslosdispositivos where serial='" + serial + "'"
        
        row = self.execute_sql_select(gevice,sql)
        
        if row:
            itern = gevice.gmodel.treestore.append(iterp)        
            gevice.gmodel.insert_new_item (itern,row,id_type_link)

            sql2 = "select serialh,id_tipo_enlace from conecta where serialp='" + serial + "'"
            rows = self.execute_sql_select(gevice,sql2)
            
            if rows:        
                for children in rows:
                    self.process_row (children[0],itern,children[1],gevice)


    def save_data_to_database (self,gevice):
        self.delete_conections(gevice)
        self.delete_devices (gevice)
        self.devices_to_connect = []

        # save deviceis into database
        gevice.gmodel.treestore.foreach(self.copy_device_to_dbase,gevice)
        
        for connected in self.devices_to_connect:
            self.insert_conections(connected,gevice)
       
        self.conn.commit()


    def copy_device_to_dbase (self,model,path,iter,gevice):
        data = gevice.gmodel.treestore.get(
            iter,
            config.COLUMN_NAME_DEV,
            config.COLUMN_ID_MODEL_DEV,
            config.COLUMN_IP_DEV,
            config.COLUMN_SERIAL_DEV,
            config.COLUMN_OBS_DEV,
            config.COLUMN_ID_TYPE_LINK_DEV)

        self.insert_device (data,gevice)
        
        if (gevice.gmodel.treestore.iter_has_child(iter)):
            iterc = gevice.gmodel.treestore.iter_children(iter)
            
            next = iterc
        
            while next:
                child = gevice.gmodel.treestore.get(next,config.COLUMN_SERIAL_DEV,config.COLUMN_ID_TYPE_LINK_DEV)
                self.devices_to_connect.append ("'" + data[3] + "','" + child[0] + "'" + "," + child[1])
                next2 = gevice.gmodel.treestore.iter_next(next)
                next = next2


    def insert_device (self,data,gevice):        
        sql = "insert into dispositivo (serial,id_modelo,nom_disp,obs_disp,ip_disp) "
        sql = sql + "values ('" + data[3] + "'," + data[1] + ",'" + data[0] + "','" + data[4] + "','" + data[2] + "');"
        rp = self.execute_sql_insert (gevice,sql)

    
    def insert_conections (self,serials,gevice):
        sql = "insert into conecta (serialp,serialh,id_tipo_enlace) values (" + serials + ");"
        rp = self.execute_sql_insert (gevice,sql)

    
    def delete_conections (self,gevice):
        sql = "delete from conecta"        
        st = self.execute_sql_delete (gevice,sql)


    def delete_devices (self,gevice):
        sql = "delete from dispositivo"
        st = self.execute_sql_delete (gevice,sql)


    def get_list_of_models (self,gevice):
        liststore = gtk.ListStore(
            gobject.TYPE_STRING,
            gobject.TYPE_INT)
        
        sql = "select nom_tipo_disp || ' ' || nom_marca || ' ' || nom_modelo,modelo.id_modelo "
        sql = sql + "from modelo inner join tipo_disp on modelo.id_tipo_disp = tipo_disp.id_tipo_disp "
        sql = sql + "inner join marca on modelo.id_marca = marca.id_marca order by "
        sql = sql + "nom_tipo_disp,nom_marca,nom_modelo"
        
        rows = self.execute_sql_select(gevice,sql)
        
        if rows:
            for row in rows:
                iter = liststore.append ()
                liststore.set (
                    iter,
                    config.COLUMN_NAME_MODEL_DEV2,row[0],
                    config.COLUMN_ID_MODEL_DEV2,row[1])
        
            return liststore
        else:
            return False
    
    
    def get_list_of_links (self,gevice):
        liststore = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_INT)
            
        sql = "select nom_tipo_enlace,id_tipo_enlace from tipo_enlace"
        
        rows = self.execute_sql_select(gevice,sql)
        
        if rows:
            for row in rows:
                iter = liststore.append ()
                liststore.set (
                    iter,
                    config.COLUMN_NAME_TYPE_LINK_DEV2,row[0],
                    config.COLUMN_ID_TYPE_LINK_DEV2,row[1])
        
            return liststore
        else:
            return False

    def get_list_of_type (self,gevice):
        liststore = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_INT)
            
        sql = "select nom_tipo_disp,id_tipo_disp from tipo_disp"
        
        rows = self.execute_sql_select(gevice,sql)
        
        if rows:
            for row in rows:
                iter = liststore.append ()
                liststore.set (
                    iter,
                    0,row[0],
                    1,row[1])        
                                
            return liststore
        else:
            return False

    def get_list_of_mark (self,gevice):
        liststore = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_INT)
            
        sql = "select nom_marca,id_marca from marca"
        
        rows = self.execute_sql_select(gevice,sql)
        
        if rows:
            for row in rows:
                iter = liststore.append ()
                liststore.set (
                    iter,
                    0,row[0],
                    1,row[1])
                           
            return liststore
        else:
            return False
