#!/usr/bin/python
#
# gevice GNOME Network Device Manager.
# Copyright (C) Alejandro Valdes Jimenez 2008 <avaldes@gnome.org>
# 
# gevice.py is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# gevice.py is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.


import pygtk
pygtk.require('2.0')
import os
import os.path
import sys
import gtk
import gnome
import gtk.glade
import psycopg2
import gobject

import config
import gevicefind
import gevicediagram
import geviceprefer
import gevicevte
import gevicedevice
import gevicemodel
import gevicedatabase
import geviceexport
import gevicemaintainer

import gettext
gettext.textdomain(config.PACKAGE)
gtk.glade.textdomain(config.PACKAGE)
from gettext import gettext as _


# menu and toolbar
UI = '''<ui>
  <menubar name="MainMenu">
    <menu action="FileMenu">
      <menuitem action="Open"/>
      <menuitem action="Refresh"/>      
      <menuitem action="Save"/>
      <separator/>
      <menuitem action="Export"/>
      <menuitem action="Diagram"/>
      <separator/>
      <menuitem action="Quit"/>
    </menu>
    <menu action="EditMenu">
      <menuitem action="Prefer"/>
    </menu>
    <menu action="ViewMenu">
      <menuitem action="Tree"/>
      <menuitem action="Terminal"/>
    </menu>
    <menu action="Protocol">
      <menuitem action="ssh"/>
      <menuitem action="telnet"/>
      <menuitem action="local"/>
    </menu>
    <menu action="Maintainer">
      <menuitem action="Mark"/>
      <menuitem action="TypeOfLink"/>
      <menuitem action="TypeOfDev"/>
      <menuitem action="Model"/>
    </menu>
    <menu action="ActionsMenu">
      <menuitem action="AddDevice"/>
      <menuitem action="RemoveDevice"/>
      <menuitem action="EditDevice"/>
      <menuitem action="Find"/>
      <separator/>
      <menuitem action="Connect"/>
      <menuitem action="Expand"/>
      <menuitem action="Decrease"/>
    </menu>
    <menu action="HelpMenu">
      <menuitem action="About"/>
    </menu>
  </menubar>
  <toolbar name="MainToolbar">
    <placeholder name="placeholder1">
      <toolitem action="Open" />
      <toolitem action="Refresh" />      
      <toolitem action="Save" />
      <separator/>
      <toolitem action="AddDevice" />
      <toolitem action="RemoveDevice" />
      <toolitem action="EditDevice" />
      <toolitem action="Find" />
      <toolitem action="Expand" />
      <toolitem action="Decrease" />
      <separator/>
      <toolitem action="ssh" />
      <toolitem action="telnet" />
      <toolitem action="local" />
      <toolitem action="Connect" />
	  <separator/>
	  <toolitem action="Quit" />
    </placeholder>
  </toolbar>
</ui>'''

class Gevice:
    def __init__ (self):
        self.list_models = None
        self.list_links = None
        self.connected_to_database = False
        self.context_id = None
        self.modelusers = gtk.ListStore(gobject.TYPE_STRING)

        # get model for devices
        self.gmodel = gevicemodel.GeviceModel(self)

        # create main window
        self.window_main = gtk.Window()
        self.window_main.set_position(1)
        self.window_main.set_default_size(800,400)
        self.window_main.set_title (config.PACKAGE)
        self.window_main.set_icon (gtk.gdk.pixbuf_new_from_file(os.path.join (config.ARTDIR,"gevice.png")))
        self.window_main.connect ("delete_event",self.on_delete_event)

        # create main container
        self.vbox = gtk.VBox(False,0)
        self.window_main.add (self.vbox)

        # create an ActionGroup
        self.actiongroup_window = gtk.ActionGroup ('Window Actions')
        self.actiongroup_model = gtk.ActionGroup ('Model Actions')
        self.actiongroup_device = gtk.ActionGroup ('Device Actions')

        # create a UIManager instance
        self.uimanager = gtk.UIManager()

        # add the accelerator group to the toplevel window
        self.accelgroup = self.uimanager.get_accel_group()
        self.window_main.add_accel_group (self.accelgroup)

        # creat actions
        self.actiongroup_window.add_actions([
            ('FileMenu', None, _('_File')),
            ('EditMenu', None, _('_Edit')),
            ('ViewMenu', None, _('_View')),
            ('Protocol', None, _('_Protocol')),
            ('HelpMenu', None, _('_Help')),
            ('Maintainer', None, _('_Maintainer')),
            ('ActionsMenu', None, _('_Actions')),
            ('Open', gtk.STOCK_DISCONNECT, _('Connect'), None, _('Connect to database'), self.on_action_open),
            ('OpenLocalTerminal', gtk.STOCK_HOME, _('Local'), None, _('Open local terminal'), self.on_action_open_local_terminal),
            ('Quit', gtk.STOCK_QUIT, _('_Quit'), None, _('Quit the program'), self.on_action_quit),
            ('Prefer', gtk.STOCK_PREFERENCES, _('Preferences'), None, _('Setting preferences'), self.on_action_preferences),
            ('About', gtk.STOCK_ABOUT, None, None, None, self.on_action_about),
        ])

        self.actiongroup_model.add_actions([
            ('Find', gtk.STOCK_FIND, _('Find'),None, _('Search a device'), self.on_action_find),
            ('Save', gtk.STOCK_SAVE, _('Save'), None, _('Save model'), self.on_action_save),
            ('Refresh', gtk.STOCK_REFRESH, _('Refresh'), None, _('Refresh model'), self.on_action_refresh),
            ('Export', gtk.STOCK_SELECT_ALL, _('Export to CSV'), None, _('Export to CSV'), self.on_action_export),
            ])

        self.actiongroup_device.add_actions([
            ('AddDevice', gtk.STOCK_ADD, _('Add'),None, _('Add a device'), self.on_action_adddevice),	
            ('RemoveDevice', gtk.STOCK_REMOVE, _('Remove'), None, _('Remove device selected'), self.on_action_removedevice),
            ('EditDevice', gtk.STOCK_EDIT, _('Edit'), None, _('Edit data of device selected'), self.on_action_editdevice),
            ('Expand', gtk.STOCK_INDENT, _('Expand'), None, _('Expand tree of device selected'), self.on_action_expand),
            ('Decrease', gtk.STOCK_UNINDENT, _('Decrease'), None, _('Decrease tree of device selected'), self.on_action_decrease),
            ('Diagram', gtk.STOCK_CONVERT, _('Create diagram'),None, _('Create diagram of devices'), self.on_action_diagram),
            ('Mark', gtk.STOCK_EDIT, _('Mark'),None, _('Mark'), self.on_action_mark),
            ('TypeOfLink', gtk.STOCK_EDIT, _('Type of link'),None, _('Type of link'), self.on_action_typeoflink),
            ('TypeOfDev', gtk.STOCK_EDIT, _('Type of device'),None, _('Type of device'), self.on_action_typeofdev),
            ('Model', gtk.STOCK_EDIT, _('Model of device'),None, _('Model of device'), self.on_action_model),            
        ])

        self.actiongroup_window.add_toggle_actions([
            ('Tree', None, _('Tree'),None, _('Show tree'), self.on_toggle_tree, True),
            ('Terminal', None, _('Terminal'),None, _('Show terminal'), self.on_toggle_terminal, True)
            ])

        self.actiongroup_window.add_radio_actions([
            ('ssh', None, _('ssh'),None, _('Use ssh protocol'), 0),
            ('telnet', None, _('telnet'),None, _('Use telnet protocol'), 1),
            ('local', None, _('local'),None, _('Open local terminal'), 2),
            ],0, self.on_action_radio)

        self.actiongroup_window.add_actions([
            ('Connect', gtk.STOCK_JUMP_TO, _('Connect'), None, _('Connect to'), self.on_action_connect),
        ])

        # add the actiongroup to the uimanager
        self.uimanager.insert_action_group (self.actiongroup_window,0)
        self.uimanager.insert_action_group (self.actiongroup_model,0)
        self.uimanager.insert_action_group (self.actiongroup_device,0)

        # add a UI description
        self.uimanager.add_ui_from_string (UI)

        # create a MenuBar
        self.menubar = self.uimanager.get_widget ('/MainMenu')
        self.vbox.pack_start (self.menubar, False)

        # create horizontal container for toolbar and combobox
        self.hbox = gtk.HBox(False,0)
        self.vbox.pack_start (self.hbox,False,False)

        # create a Toolbar
        self.maintoolbar = self.uimanager.get_widget ('/MainToolbar')
        self.maintoolbar.set_style(gtk.TOOLBAR_ICONS)
        #self.maintoolbar.set_style(gtk.TOOLBAR_BOTH)

        ## create combobox user
        self.separator_user = gtk.SeparatorToolItem()
        self.toolitem_user = gtk.ToolItem()
        self.maintoolbar.insert(self.toolitem_user,12)

        self.vboxcombo = gtk.VBox(False,0)

        self.combobox_user = gtk.combo_box_entry_new_with_model(self.modelusers,0)

        self.vboxcombo.pack_end (self.combobox_user,True,False)
        self.toolitem_user.add(self.vboxcombo)

        self.hbox.pack_start (self.maintoolbar,True,True)

        self.actiongroup_window.set_sensitive (True)
        self.actiongroup_model.set_sensitive (False)
        self.actiongroup_device.set_sensitive (False)

        # get widgets of main app
        glade_file = gtk.glade.XML (os.path.join (config.GLADEDIR, "gevice.glade"),"vbox_main",None)
        self.vbox_main = glade_file.get_widget ("vbox_main")
        self.hpaned = glade_file.get_widget ("hpaned")
        self.vboxtreeview = glade_file.get_widget ("vboxtreeview")
        self.notebook = glade_file.get_widget ("notebook")

        # add treeview to vboxtreeview
        self.scroll = gtk.ScrolledWindow()
        self.scroll.set_shadow_type("GTK_SHADOW_ETCHED_IN")
        self.scroll.set_policy("GTK_POLICY_AUTOMATIC","GTK_POLICY_AUTOMATIC")
        self.scroll.add (self.gmodel.treeview)
        self.vboxtreeview.add (self.scroll)

        # create notebook
        self.notebook.set_scrollable (True)
        self.notebook.set_show_border (False)
        self.notebook.set_show_tabs (True)
        self.notebook.set_group_id(1)
        self.hpaned.add2 (self.notebook)
        self.hpaned.set_position (-1)

        self.vbox.pack_start (self.vbox_main, False)
        self.vbox.set_child_packing (self.vbox_main,True,True,0,gtk.PACK_START)

        # create statusbar
        hbox_status = gtk.HBox(False,0)
        self.statusbar = gtk.Statusbar()
        hbox_status.pack_start(self.statusbar, True)
        self.vbox.pack_start (hbox_status, False)
        self.context_id = self.statusbar.get_context_id("status")

        self.actiongroup_model.set_sensitive (False)
        self.window_main.set_title(config.PACKAGE)

        # load preferences
        self.gpref = geviceprefer.GevicePrefer(self)
        self.gpref.load_preferences(self)
        self.gpref.load_interface (self)

        self.set_listusers_on_combobox()

        # show all
        self.window_main.show_all()
        return

    def set_listusers_on_combobox (self):
        self.modelusers.clear()
        for user in self.gpref.listusers:
            self.combobox_user.append_text(user)
        
        self.combobox_user.set_active (0)
        

    def main(self):
        gtk.main()

    def show_message (self,msg,type_msg,buttons):
        dialog = gtk.MessageDialog(None,gtk.DIALOG_MODAL,type_msg,buttons,msg)
        result = dialog.run()
        dialog.destroy()
        return result

    def close_page_of_notebook(self,widget,hbox_term):
        "close page of notebook"

        page = self.notebook.page_num(hbox_term)
        self.notebook.remove_page(page)

    def remove_all_page_of_notebook (self):
        n = self.notebook.get_n_pages()
        i = n
        while i >= 0:
            self.notebook.remove_page(i)
            i = i - 1

    def connect_to_device (self,local=None):
        i = self.gmodel.get_iter_selected (self.gmodel.treeview)

        if local:
            gvte = gevicevte.GeviceVte()
            gvte.load_interface (_("Local"),self)
            
            gvte.terminal.fork_command (
            "bash",
            None,
            None,
            "",
            False,
            False,
            False)
            
            gvte.show_interface ()
        
            page = self.notebook.append_page(gvte.hbox_term,gvte.hbox_label)
            self.notebook.set_tab_reorderable(gvte.hbox_term,True)
            self.notebook.set_tab_detachable(gvte.hbox_term,True)
            self.notebook.set_current_page(page)
            gvte.terminal.grab_focus()
            
        else:
            # if iter selected?
            if i["iter"]:
                # get data from device selected
                data = self.gmodel.get_data_of_device_from_model(self.gmodel.treeview)
                proto = self.get_protocol_selected()

                gvte = gevicevte.GeviceVte()
                gvte.load_interface (data[0],self)
                gvte.open_terminal (data[2],proto,self)
                gvte.show_interface ()
	
                page = self.notebook.append_page(gvte.hbox_term,gvte.hbox_label)
                self.notebook.set_tab_reorderable(gvte.hbox_term,True)
                self.notebook.set_tab_detachable(gvte.hbox_term,True)
                self.notebook.set_current_page(page)
                
                gvte.terminal.grab_focus()

    def create_button_with_image (self,id_stock,sensitive):
        "return a button with image, utilized in tool of browser"

        hbox_image = gtk.HBox(False,0)
        image = gtk.Image()
        image.set_from_stock(id_stock,'GTK_ICON_SIZE_MENU')
        hbox_image.pack_start(image,True,False,False)

        button = gtk.Button()
        button.set_relief('GTK_RELIEF_NONE')

        button.add(hbox_image)
        button.set_sensitive (sensitive)

        return button

    def on_action_model (gevice,action):
        sql_select = "select modelo.id_modelo,tipo_disp.nom_tipo_disp || ' ' || marca.nom_marca,modelo.nom_modelo "
        sql_select = sql_select + "from modelo inner join marca on modelo.id_marca = marca.id_marca inner join tipo_disp "
        sql_select = sql_select + "on modelo.id_tipo_disp = tipo_disp.id_tipo_disp order by 2;"
        
        sql = {"select":sql_select,
        "update1":"update modelo set nom_modelo=",
        "update2":" where id_modelo=",
        "delete":"delete from modelo where id_modelo=",
        "max_id":"select max(id_modelo) + 1 from modelo;",
        "insert":"insert into modelo values "}
        dialogmaintainer = gevicemaintainer.GeviceMaintainer ()
        dialogmaintainer.load_interface1 (gevice,_("Model of device"),sql)
        dialogmaintainer.load_data1 (gevice,sql)
        dialogmaintainer.show_interface ()


    def on_action_mark (gevice,action):
        sql = {"select":"select * from marca order by 1",
        "insert":"insert into marca values ",
        "delete":"delete from marca where id_marca=",
        "update1":"update marca set nom_marca=",
        "update2":" where id_marca=",
        "max_id":"select max(id_marca)+1 from marca;"}
        dialogmaintainer = gevicemaintainer.GeviceMaintainer ()
        dialogmaintainer.load_interface (gevice,_("Mark"),sql)
        dialogmaintainer.load_data (gevice,sql)
        dialogmaintainer.show_interface ()
        

    def on_action_typeofdev (gevice,action):
        sql = {"select":"select * from tipo_disp order by 1",
        "insert":"insert into tipo_disp values ",
        "delete":"delete from tipo_disp where id_tipo_disp=",
        "update1":"update tipo_disp set nom_tipo_disp=",
        "update2":" where id_tipo_disp=",
        "max_id":"select max(id_tipo_disp)+1 from tipo_disp;"}
        dialogmaintainer = gevicemaintainer.GeviceMaintainer ()
        dialogmaintainer.load_interface (gevice,_("Type of device"),sql)
        dialogmaintainer.load_data (gevice,sql)
        dialogmaintainer.show_interface ()


    def on_action_typeoflink (gevice,action):
        sql = {"select":"select * from tipo_enlace order by 1",
        "insert":"insert into tipo_enlace values ",
        "delete":"delete from tipo_enlace where id_tipo_enlace=",
        "update1":"update tipo_enlace set nom_tipo_enlace=",
        "update2":" where id_tipo_enlace=",
        "max_id":"select max(id_tipo_enlace)+1 from tipo_enlace;"}
        dialogmaintainer = gevicemaintainer.GeviceMaintainer ()
        dialogmaintainer.load_interface (gevice,_("Type of link"),sql)
        dialogmaintainer.load_data (gevice,sql)
        dialogmaintainer.show_interface ()


    def on_action_export (gevice,action):
        dialogexport = geviceexport.GeviceExport ()
        dialogexport.load_interface (gevice)
        dialogexport.save_file (gevice)
    

    def on_action_refresh (gevice,action):
        gevice.gdbase.cur = gevice.gdbase.conn.cursor()
        gevice.gdbase.load_data_from_database(gevice)


    def on_delete_event (self,data1=None,data2=None):
        gtk.main_quit()

    def on_action_about (self,action):
        self.create_about_dialog()

    def on_action_quit (self,action):
        self.on_delete_event ()

    def on_action_preferences (gevice,action):
        gevice.gpref.load_preferences(gevice)
        gevice.gpref.load_interface(gevice)
        gevice.gpref.show_interface()

    def on_action_find (gevice,action):
        gevice.gevicefind = gevicefind.GeviceFind ()
        gevice.gevicefind.load_interface(gevice)
        gevice.gevicefind.show_interface()

    def on_action_diagram (gevice,action):
        gevice.gdiagram = gevicediagram.GeviceDiagram ()
        gevice.gdiagram.load_interface (gevice)
        gevice.gdiagram.show_interface ()

    def on_action_print (gevice,action):
        gprint = geviceprint.GevicePrint()
        gprint.load_interface(gevice)
        gprint.show_interface()

    def on_action_expand (gevice,action):
        gevice.gmodel.expand_treeview (True)

    def on_action_decrease (gevice,action):
        gevice.gmodel.expand_treeview (False)

    def on_action_adddevice (gevice,action):
        gevice.gdevice = gevicedevice.GeviceDevice ()
        gevice.gdevice.load_interface (gevice)
        gevice.gdevice.add_device()
        gevice.gdevice.show_interface ()

    def on_action_removedevice (gevice,action):
        gevice.gdevice = gevicedevice.GeviceDevice ()
        gevice.gdevice.remove_device(gevice)


    def on_action_editdevice (gevice,action):
        gevice.gdevice = gevicedevice.GeviceDevice ()
        gevice.gdevice.load_interface (gevice)
        gevice.gdevice.modify_device(gevice)
        gevice.gdevice.show_interface ()


    def on_action_open (gevice,action):
        if (not gevice.connected_to_database):
            gevice.gdbase = gevicedatabase.GeviceDatabase ()
            gevice.gdbase.load_interface (gevice)
            gevice.gdbase.label_host.set_text (gevice.gpref.host)
            gevice.gdbase.label_dbase.set_text (gevice.gpref.dbase)
            gevice.gdbase.label_user_dbase.set_text (gevice.gpref.user_dbase)
        
            gevice.gdbase.show_interface ()
        else:
            gevice.gmodel.treestore.clear()
            gevice.gmodel.treeview.set_model(None)
            
            action_open = gevice.actiongroup_window.get_action("Open")
            action_open.set_property ("stock-id",gtk.STOCK_DISCONNECT)
            action_open.set_property ("tooltip",_("Connect to database"))
            action_open.set_property ("label",_("Connect"))
            
            gevice.actiongroup_window.set_sensitive (True)
            gevice.actiongroup_model.set_sensitive (False)
            gevice.actiongroup_device.set_sensitive (False)
            gevice.connected_to_database = False
        

    def on_action_save (gevice,action):
        # temporal
        gevice.gdbase = gevicedatabase.GeviceDatabase ()
        #gevice.gdbase.conn = psycopg2.connect("dbname=" + gevice.gpref.dbase + " user=" + gevice.gpref.user_dbase + " host=" + gevice.gpref.host + " password=rss123")
        #gevice.gdbase.cur = gevice.gdbase.conn.cursor()
        #
        #gevice.gdbase.save_data_to_database (gevice)

	gevice.gdbase.load_interface_save (gevice)
	gevice.gdbase.label_host.set_text (gevice.gpref.host)
	gevice.gdbase.label_dbase.set_text (gevice.gpref.dbase)
	gevice.gdbase.label_user_dbase.set_text (gevice.gpref.user_dbase)

	gevice.gdbase.show_interface()

    def on_action_connect(self,action):
        flag = True
        proto = self.get_protocol_selected()

        if (proto != "local"):
                flag = False
        
        self.connect_to_device(flag)

    def on_action_open_local_terminal(self,action):
        self.connect_to_device(True)

    def on_action_radio(action,current,gevice):
        # get the actionradio selected
        gevice.action_radio = action

    def on_toggle_tree (gevice,action):
        if (action.get_active() == True):
            gevice.vboxtreeview.show()
        else:
            gevice.vboxtreeview.hide ()

    def on_toggle_terminal (gevice,action):
        if (action.get_active() == True):
            gevice.notebook.show()
        else:
            gevice.notebook.hide ()

    def create_about_dialog (self):
        authors = ('Alejandro Valdes Jimenez [avaldes@gnome.org]','')
        translator_credits = ('Alejandro Valdes Jimenez [avaldes@gnome.org]')
        logo =  gtk.gdk.pixbuf_new_from_file (os.path.join (config.ARTDIR,"gevice.png"))

        ad = gtk.AboutDialog()
        ad.set_name(config.PACKAGE)
        ad.set_version(config.VERSION)
        ad.set_authors(authors)
        ad.set_translator_credits(translator_credits)
        ad.set_logo(logo)

        ad.connect ("delete-event", self.about_delete)
        ad.connect ("response", self.about_delete)
        ad.show()

    def about_delete (self,about,event):
        about.destroy()
        return True

    
    def get_protocol_selected (self):
        if (self.actiongroup_window.get_action("ssh").get_active()):
            proto = "ssh"
        elif (self.actiongroup_window.get_action("telnet").get_active()):
            proto = "telnet"
        elif (self.actiongroup_window.get_action("local").get_active()):
            proto = "local"
        
        return proto
    
    def update_statusbar (self):
        msg = _("[Host: ") + self.gpref.host + " "
        msg+= _("Database: ") + self.gpref.dbase + " "
        msg+= _("User: ") + self.gpref.user_dbase + "]"
        
        self.statusbar.push (self.context_id,msg)
    

if __name__ == "__main__":
	gnome.init(config.PACKAGE,config.VERSION)	
	gevice = Gevice()	
	gevice.main()
