import pygtk
pygtk.require('2.0')
import gtk.glade
import os

import gettext
gettext.textdomain("gevice")
from gettext import gettext as _

import config

class GeviceDevice:
    def __init__ (self):
        self.action = "add"
        
        self.window_device = None
        self.entry_name_device = None
        self.entry_ip_device = None
        self.entry_comment_device = None
        self.entry_serial_device = None
        self.combo_link = None
        self.combo_model = None
        self.button_cancel_device = None
        self.button_accept_device = None

    def add_device (self):
        self.action = "add"
        
        self.entry_name_device.set_text("")
        self.entry_ip_device.set_text("")
        self.entry_serial_device.set_text("")
        self.entry_comment_device.set_text("")
        self.combo_model.set_active(0)
        self.combo_link.set_active(0)
        self.window_device.set_title (_("New device"))

    def modify_device (self,gevice):
        self.action = "mod"       

        self.index_combo = 0
        self.index_link = 0
        
        data = gevice.gmodel.get_data_of_device_from_model(gevice.gmodel.treeview)
        
        self.id_model = data[1]
        self.id_link = data[5]
        
        
        models = gevice.gdbase.get_list_of_models (gevice)
        models.foreach (self.get_index_combo_model,gevice)
        
        links = gevice.gdbase.get_list_of_links (gevice)
        links.foreach (self.get_index_combo_link,gevice)
               
        self.entry_name_device.set_text(data[0])
        self.combo_model.set_active(self.index_combo)
        self.entry_ip_device.set_text(data[2])
        self.entry_serial_device.set_text(data[3])
        self.entry_comment_device.set_text(data[4])
        self.combo_link.set_active(self.index_link)
        
        self.window_device.set_title (_("Modify device"))
    
    def get_index_combo_model (self,model,path,iter,gevice):
        data = model.get (iter,
            config.COLUMN_ID_MODEL_DEV2)
                
        if (int(data[0]) == int(self.id_model)):
            return True
        
        self.index_combo = self.index_combo + 1


    def get_index_combo_link (self,model,path,iter,gevice):
        data = model.get (iter,
            config.COLUMN_ID_TYPE_LINK_DEV2)
                
        if (int(data[0]) == int(self.id_link)):
            return True
        
        self.index_link = self.index_link + 1


    def remove_device (self,gevice):
        self.action = "del"
        
        dialog = gtk.Dialog(config.PACKAGE,
            None,
            gtk.DIALOG_DESTROY_WITH_PARENT,
            (gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_OK,gtk.RESPONSE_ACCEPT)) 

        dialog.set_has_separator(False)
        dialog.vbox.set_spacing(15)
        dialog.vbox.pack_start(gtk.Label(_("Do you want to remove: ")))
        dialog.show_all()

        response = dialog.run ()

        if response == gtk.RESPONSE_ACCEPT:
            i = gevice.gmodel.get_iter_selected (gevice.gmodel.treeview)
            gevice.gmodel.treestore.remove(i["iter"])

        dialog.destroy()

    def load_interface (self,gevice):
        glade_file = gtk.glade.XML (os.path.join (config.GLADEDIR, "gevice.glade"),"window_device",None)
        self.window_device = glade_file.get_widget ("window_device")
        self.entry_name_device = glade_file.get_widget ("entry_name_device")
        self.entry_ip_device = glade_file.get_widget ("entry_ip_device")
        self.entry_comment_device = glade_file.get_widget ("entry_comment_device")
        self.entry_serial_device = glade_file.get_widget ("entry_serial_device")
        self.combo_link = glade_file.get_widget ("combo_link")
        self.combo_model = glade_file.get_widget ("combo_model")
        self.button_cancel_device = glade_file.get_widget ("button_cancel_device")
        self.button_accept_device = glade_file.get_widget ("button_accept_device")

        # signals window device
        self.window_device.connect ("delete-event",self.on_window_device_delete_event)
        self.button_cancel_device.connect ("clicked",self.on_button_cancel_device_clicked)
        self.button_accept_device.connect ("clicked",self.on_button_accept_device_clicked,gevice)
       
        gevice.list_models = gevice.gdbase.get_list_of_models (gevice)
        self.combo_model.set_model (gevice.list_models)
        
        gevice.list_links = gevice.gdbase.get_list_of_links (gevice)
        self.combo_link.set_model (gevice.list_links)

    def show_interface (self):
        self.window_device.show_all ()

    def close_window (self,window):
        window.destroy()

    def on_button_cancel_device_clicked (self,button):
        self.close_window (self.window_device)

    def on_window_device_delete_event (self,window,event):
        self.close_window (window)

    def on_button_accept_device_clicked (self,button,gevice):        
        name = self.entry_name_device.get_text()
        ip = self.entry_ip_device.get_text()
        serial = self.entry_serial_device.get_text()
        comment = self.entry_comment_device.get_text()

        iter_model = self.combo_model.get_active_iter()
        id_model = gevice.list_models.get_value(iter_model,config.COLUMN_ID_MODEL_DEV2)
        name_model = gevice.list_models.get_value(iter_model,config.COLUMN_NAME_MODEL_DEV2)

        iter_type_link = self.combo_link.get_active_iter()
        id_link = gevice.list_links.get_value(iter_type_link,config.COLUMN_ID_TYPE_LINK_DEV2)

        i = gevice.gmodel.get_iter_selected(gevice.gmodel.treeview)

        if name:
            if self.action == "add":
                newiter = gevice.gmodel.treestore.append(i["iter"])
            else:
                newiter = i["iter"]

            gevice.gmodel.treestore.set (newiter,
                config.COLUMN_NAME_DEV,name,
                config.COLUMN_ID_MODEL_DEV,id_model,
                config.COLUMN_NAME_MODEL_DEV,name_model,   
                config.COLUMN_IP_DEV,ip,
                config.COLUMN_SERIAL_DEV,serial,
                config.COLUMN_OBS_DEV,comment,
                config.COLUMN_ID_TYPE_LINK_DEV,id_link)

            if i["path"]:
                gevice.gmodel.treeview.expand_to_path(i["path"][0])

            self.close_window(self.window_device)
            gevice.actiongroup_model.set_sensitive (True)
