// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GEGLMM_PATH_H
#define _GEGLMM_PATH_H


#include <glibmm.h>

/* libgeglmm - a C++ wrapper for libgegl
 *
 * (c) 2009 Hubert Figuiere
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.
 */

#include <gegl.h>
#include <gegl-path.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GeglPath GeglPath;
typedef struct _GeglPathClass GeglPathClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gegl
{ class Path_Class; } // namespace Gegl
namespace Gegl
{

class PathItem
{
    public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef PathItem CppObjectType;
  typedef GeglPathItem BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:


};


class Path
  : public Glib::Object
{
	
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Path CppObjectType;
  typedef Path_Class CppClassType;
  typedef GeglPath BaseObjectType;
  typedef GeglPathClass BaseClassType;

private:  friend class Path_Class;
  static CppClassType path_class_;

private:
  // noncopyable
  Path(const Path&);
  Path& operator=(const Path&);

protected:
  explicit Path(const Glib::ConstructParams& construct_params);
  explicit Path(GeglPath* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Path();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GeglPath*       gobj()       { return reinterpret_cast<GeglPath*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GeglPath* gobj() const { return reinterpret_cast<GeglPath*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GeglPath* gobj_copy();

private:

protected:
	Path();

public:
	
  static Glib::RefPtr<Path> create();


public:
    
  bool is_empty();
    
  int get_n_nodes();
    
  double get_length();
 

  const GeglPathItem* get_node(int pos);

    
  Glib::ustring to_string();
    
  void get_matrix(GeglMatrix3 matrix);
    
  void set_matrix(GeglMatrix3 matrix);
    
  double closest_point(double x, double y, double &dx, double &dy, int & node_post_befor);
    
  void calc(double pos, double &dest_x, double &dest_y);
    
  void calc_values(guint num_samples, double & dest_xs, double & dest_ys);
    
  void get_bounds(double & min_x, double & max_x, double &min_y, double &max_y);
    //    _WRAP_METHOD(void foreach(void * each_item, gpointer data), gegl_path_foreach)
    //   gegl_path_foreach_flat
    
  void clear();
    
  void insert_node(int pos, const GeglPathItem *knot);
    
  void replace_node(int pos, const GeglPathItem *knot);
    
  void remove_node(int pos);
    
  void parse_string(const Glib::ustring & path_string);
    
    //    _WRAP_METHOD(Glib::RefPtr<Path> add_parameter_path(const Glib::ustring & parameter_name), gegl_path_add_parameter_path)
    //    _WRAP_METHOD(Glib::RefPtr<Path> get_parameter_path(const Glib::ustring & parameter_name), gegl_path_get_parameter_path)
 

  Glib::SListHandle<Glib::ustring> parameter_get_names(int *count);
    
  double parameter_calc(const Glib::ustring & parameter_name, double pos);
    
  void parameter_get_bounds(const Glib::ustring & parameter_name, double & min, double & max);
    
  void parameter_calc_values(const Glib::ustring & parameter_name, guint num_samples, double * samples);

    
  void freeze();
    
  void thaw();

    
  /**
   * @par Prototype:
   * <tt>void on_my_%changed(gpointer p0)</tt>
   */

  Glib::SignalProxy1< void,gpointer > signal_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};


}


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gegl::Path
   */
  Glib::RefPtr<Gegl::Path> wrap(GeglPath* object, bool take_copy = false);
}


#endif /* _GEGLMM_PATH_H */

