/* gca-c-backend.c generated by valac 0.28.0.11-bbdd, the Vala compiler
 * generated from gca-c-backend.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2014 - Ignacio Casal Quinteiro
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gca.h>
#include <gedit/gedit-view.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gedit/gedit-document.h>
#include <gtksourceview/gtksource.h>
#include <libpeas/peas.h>


#define GCA_C_TYPE_BACKEND (gca_c_backend_get_type ())
#define GCA_C_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_C_TYPE_BACKEND, GcaCBackend))
#define GCA_C_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_C_TYPE_BACKEND, GcaCBackendClass))
#define GCA_C_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_C_TYPE_BACKEND))
#define GCA_C_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_C_TYPE_BACKEND))
#define GCA_C_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_C_TYPE_BACKEND, GcaCBackendClass))

typedef struct _GcaCBackend GcaCBackend;
typedef struct _GcaCBackendClass GcaCBackendClass;
typedef struct _GcaCBackendPrivate GcaCBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GcaCBackend {
	GObject parent_instance;
	GcaCBackendPrivate * priv;
};

struct _GcaCBackendClass {
	GObjectClass parent_class;
};

struct _GcaCBackendPrivate {
	GeditView* d_view;
};


static gpointer gca_c_backend_parent_class = NULL;
static GcaIndentBackendIface* gca_c_backend_gca_indent_backend_parent_iface = NULL;
static GType gca_c_backend_type_id = 0;

GType gca_c_backend_get_type (void) G_GNUC_CONST;
GType gca_c_backend_register_type (GTypeModule * module);
#define GCA_C_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_C_TYPE_BACKEND, GcaCBackendPrivate))
enum  {
	GCA_C_BACKEND_DUMMY_PROPERTY,
	GCA_C_BACKEND_VIEW
};
static gchar** gca_c_backend_real_get_triggers (GcaIndentBackend* base, int* result_length1);
static gboolean gca_c_backend_move_to_no_space (GcaCBackend* self, GtkTextIter* place, gboolean forward);
static gboolean gca_c_backend_find_open_char (GcaCBackend* self, GtkTextIter* place, gunichar open, gunichar close, gboolean skip_first);
static gunichar gca_c_backend_get_first_char_in_line (GcaCBackend* self, GtkTextIter* place);
static gunichar gca_c_backend_get_last_char_in_line (GcaCBackend* self, GtkTextIter* place);
static gchar* gca_c_backend_get_word_at_iter (GcaCBackend* self, GtkTextIter* iter);
static gboolean gca_c_backend_iter_is_at_else (GcaCBackend* self, GtkTextIter* iter);
static gboolean gca_c_backend_iter_is_at_break (GcaCBackend* self, GtkTextIter* iter);
static void gca_c_backend_real_get_indent (GcaIndentBackend* base, GeditDocument* document, GtkTextIter* place, GcaIndentLevel* result);
GcaCBackend* gca_c_backend_new (void);
GcaCBackend* gca_c_backend_construct (GType object_type);
static void gca_c_backend_finalize (GObject* obj);
static void _vala_gca_c_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gca_c_backend_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
void peas_register_types (GTypeModule* module);


static gchar** gca_c_backend_real_get_triggers (GcaIndentBackend* base, int* result_length1) {
	GcaCBackend * self;
	gchar** result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	self = (GcaCBackend*) base;
	_tmp0_ = g_strdup ("0{");
	_tmp1_ = g_strdup ("0}");
	_tmp2_ = g_strdup ("0#");
	_tmp3_ = g_strdup (":");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 4;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}


static gboolean gca_c_backend_move_to_no_space (GcaCBackend* self, GtkTextIter* place, gboolean forward) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean moved = FALSE;
	gunichar c = 0U;
	gunichar _tmp5_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (place != NULL, FALSE);
	_tmp1_ = gtk_text_iter_is_end (place);
	if (_tmp1_) {
		gint _tmp2_ = 0;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = forward;
		if (_tmp3_) {
			_tmp2_ = 1;
		} else {
			_tmp2_ = -1;
		}
		_tmp4_ = gtk_text_iter_forward_chars (place, _tmp2_);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	moved = TRUE;
	_tmp5_ = gtk_text_iter_get_char (place);
	c = _tmp5_;
	while (TRUE) {
		gunichar _tmp6_ = 0U;
		gboolean _tmp7_ = FALSE;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gunichar _tmp11_ = 0U;
		_tmp6_ = c;
		_tmp7_ = g_unichar_isspace (_tmp6_);
		if (!_tmp7_) {
			break;
		}
		_tmp9_ = forward;
		if (_tmp9_) {
			_tmp8_ = 1;
		} else {
			_tmp8_ = -1;
		}
		_tmp10_ = gtk_text_iter_forward_chars (place, _tmp8_);
		if (!_tmp10_) {
			moved = FALSE;
			break;
		}
		_tmp11_ = gtk_text_iter_get_char (place);
		c = _tmp11_;
	}
	result = moved;
	return result;
}


static gboolean gca_c_backend_find_open_char (GcaCBackend* self, GtkTextIter* place, gunichar open, gunichar close, gboolean skip_first) {
	gboolean result = FALSE;
	GtkTextIter copy = {0};
	GtkTextIter _tmp0_ = {0};
	gint counter = 0;
	gboolean moved = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (place != NULL, FALSE);
	_tmp0_ = *place;
	copy = _tmp0_;
	counter = 0;
	moved = FALSE;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			gunichar c = 0U;
			gunichar _tmp3_ = 0U;
			gboolean _tmp4_ = FALSE;
			gunichar _tmp5_ = 0U;
			gunichar _tmp6_ = 0U;
			gboolean _tmp9_ = FALSE;
			gunichar _tmp10_ = 0U;
			gunichar _tmp11_ = 0U;
			gint _tmp14_ = 0;
			if (!_tmp1_) {
				gboolean _tmp2_ = FALSE;
				_tmp2_ = gtk_text_iter_backward_char (&copy);
				if (!_tmp2_) {
					break;
				}
			}
			_tmp1_ = FALSE;
			_tmp3_ = gtk_text_iter_get_char (&copy);
			c = _tmp3_;
			_tmp5_ = c;
			_tmp6_ = close;
			if (_tmp5_ == _tmp6_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp7_ = FALSE;
				_tmp7_ = skip_first;
				_tmp4_ = _tmp7_;
			}
			if (_tmp4_) {
				gint _tmp8_ = 0;
				_tmp8_ = counter;
				counter = _tmp8_ - 1;
				skip_first = FALSE;
			}
			_tmp10_ = c;
			_tmp11_ = open;
			if (_tmp10_ == _tmp11_) {
				gint _tmp12_ = 0;
				_tmp12_ = counter;
				_tmp9_ = _tmp12_ != 0;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gint _tmp13_ = 0;
				_tmp13_ = counter;
				counter = _tmp13_ + 1;
			}
			_tmp14_ = counter;
			if (_tmp14_ == 0) {
				GtkTextIter _tmp15_ = {0};
				_tmp15_ = copy;
				*place = _tmp15_;
				moved = TRUE;
				break;
			}
		}
	}
	result = moved;
	return result;
}


static gunichar gca_c_backend_get_first_char_in_line (GcaCBackend* self, GtkTextIter* place) {
	gunichar result = 0U;
	gunichar c = 0U;
	gunichar _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (place != NULL, 0U);
	gtk_text_iter_set_line_offset (place, 0);
	_tmp0_ = gtk_text_iter_get_char (place);
	c = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gunichar _tmp6_ = 0U;
		_tmp2_ = c;
		_tmp3_ = g_unichar_isspace (_tmp2_);
		if (_tmp3_) {
			gboolean _tmp4_ = FALSE;
			_tmp4_ = gtk_text_iter_ends_line (place);
			_tmp1_ = !_tmp4_;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp5_ = gtk_text_iter_forward_char (place);
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = gtk_text_iter_get_char (place);
		c = _tmp6_;
	}
	result = c;
	return result;
}


static gunichar gca_c_backend_get_last_char_in_line (GcaCBackend* self, GtkTextIter* place) {
	gunichar result = 0U;
	gboolean _tmp0_ = FALSE;
	gunichar c = 0U;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (place != NULL, 0U);
	_tmp0_ = gtk_text_iter_ends_line (place);
	if (!_tmp0_) {
		gtk_text_iter_forward_to_line_end (place);
	}
	_tmp1_ = gtk_text_iter_get_char (place);
	c = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gunichar _tmp7_ = 0U;
		_tmp3_ = c;
		_tmp4_ = g_unichar_isspace (_tmp3_);
		if (_tmp4_) {
			gboolean _tmp5_ = FALSE;
			_tmp5_ = gtk_text_iter_starts_line (place);
			_tmp2_ = !_tmp5_;
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp6_ = gtk_text_iter_backward_char (place);
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = gtk_text_iter_get_char (place);
		c = _tmp7_;
	}
	result = c;
	return result;
}


static gchar* gca_c_backend_get_word_at_iter (GcaCBackend* self, GtkTextIter* iter) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	GtkTextIter _tmp6_ = {0};
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_ends_word (iter);
	if (!_tmp0_) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = *iter;
	start = _tmp2_;
	_tmp3_ = gtk_text_iter_starts_word (&start);
	if (!_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = gtk_text_iter_backward_word_start (&start);
		if (!_tmp4_) {
			gchar* _tmp5_ = NULL;
			_tmp5_ = g_strdup ("");
			result = _tmp5_;
			return result;
		}
	}
	_tmp6_ = *iter;
	_tmp7_ = gtk_text_iter_get_text (&start, &_tmp6_);
	result = _tmp7_;
	return result;
}


static gboolean gca_c_backend_iter_is_at_else (GcaCBackend* self, GtkTextIter* iter) {
	gboolean result = FALSE;
	GtkTextIter _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = gca_c_backend_get_word_at_iter (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "else") == 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean gca_c_backend_iter_is_at_break (GcaCBackend* self, GtkTextIter* iter) {
	gboolean result = FALSE;
	GtkTextIter _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = gca_c_backend_get_word_at_iter (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "break") == 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static void gca_c_backend_real_get_indent (GcaIndentBackend* base, GeditDocument* document, GtkTextIter* place, GcaIndentLevel* result) {
	GcaCBackend * self;
	GcaIndentLevel amount = {0};
	GtkTextIter _tmp0_ = {0};
	GcaIndentLevel _tmp1_ = {0};
	GtkTextIter iter = {0};
	GtkTextIter _tmp2_ = {0};
	gint _tmp3_ = 0;
	GeditDocument* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GeditDocument* _tmp9_ = NULL;
	GtkTextIter _tmp10_ = {0};
	gboolean _tmp11_ = FALSE;
	gunichar c = 0U;
	gunichar _tmp14_ = 0U;
	gunichar _tmp15_ = 0U;
	GtkTextIter _tmp81_ = {0};
	gunichar _tmp82_ = 0U;
	self = (GcaCBackend*) base;
	g_return_if_fail (document != NULL);
	g_return_if_fail (place != NULL);
	_tmp0_ = *place;
	gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp0_, &_tmp1_);
	amount = _tmp1_;
	_tmp2_ = *place;
	iter = _tmp2_;
	_tmp3_ = gtk_text_iter_get_line (&iter);
	if (_tmp3_ == 0) {
		*result = amount;
		return;
	}
	_tmp4_ = document;
	_tmp5_ = iter;
	_tmp6_ = gtk_source_buffer_iter_has_context_class ((GtkSourceBuffer*) _tmp4_, &_tmp5_, "comment");
	if (_tmp6_) {
		*result = amount;
		return;
	}
	gtk_text_iter_set_line_offset (&iter, 0);
	_tmp7_ = gtk_text_iter_backward_char (&iter);
	if (!_tmp7_) {
		*result = amount;
		return;
	}
	_tmp8_ = gca_c_backend_move_to_no_space (self, &iter, FALSE);
	if (!_tmp8_) {
		*result = amount;
		return;
	}
	_tmp9_ = document;
	_tmp10_ = iter;
	_tmp11_ = gtk_source_buffer_iter_has_context_class ((GtkSourceBuffer*) _tmp9_, &_tmp10_, "comment");
	if (_tmp11_) {
		GeditDocument* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = document;
		_tmp13_ = gtk_source_buffer_iter_backward_to_context_class_toggle ((GtkSourceBuffer*) _tmp12_, &iter, "comment");
		if (!_tmp13_) {
			*result = amount;
			return;
		}
	}
	_tmp14_ = gtk_text_iter_get_char (&iter);
	c = _tmp14_;
	_tmp15_ = c;
	switch (_tmp15_) {
		case ';':
		{
			{
				GtkTextIter copy = {0};
				GtkTextIter _tmp16_ = {0};
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				_tmp16_ = iter;
				copy = _tmp16_;
				_tmp18_ = gtk_text_iter_backward_char (&copy);
				if (_tmp18_) {
					gunichar _tmp19_ = 0U;
					_tmp19_ = gtk_text_iter_get_char (&copy);
					_tmp17_ = _tmp19_ == ((gunichar) ')');
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					gboolean _tmp20_ = FALSE;
					_tmp20_ = gca_c_backend_find_open_char (self, &copy, (gunichar) '(', (gunichar) ')', FALSE);
					if (_tmp20_) {
						GtkTextIter _tmp21_ = {0};
						GcaIndentLevel _tmp22_ = {0};
						_tmp21_ = copy;
						gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp21_, &_tmp22_);
						amount = _tmp22_;
					} else {
						GtkTextIter _tmp23_ = {0};
						GcaIndentLevel _tmp24_ = {0};
						_tmp23_ = iter;
						gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp23_, &_tmp24_);
						amount = _tmp24_;
					}
				} else {
					gboolean _tmp25_ = FALSE;
					GtkTextIter _tmp26_ = {0};
					gboolean _tmp27_ = FALSE;
					_tmp26_ = iter;
					_tmp27_ = gca_c_backend_iter_is_at_break (self, &_tmp26_);
					if (_tmp27_) {
						GtkTextIter _tmp28_ = {0};
						gunichar _tmp29_ = 0U;
						_tmp28_ = *place;
						_tmp29_ = gca_c_backend_get_last_char_in_line (self, &_tmp28_);
						_tmp25_ = _tmp29_ == ((gunichar) ':');
					} else {
						_tmp25_ = FALSE;
					}
					if (_tmp25_) {
						GtkTextIter _tmp30_ = {0};
						GcaIndentLevel _tmp31_ = {0};
						guint iw = 0U;
						guint _tmp32_ = 0U;
						GcaIndentLevel _tmp33_ = {0};
						guint _tmp34_ = 0U;
						guint _tmp35_ = 0U;
						_tmp30_ = iter;
						gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp30_, &_tmp31_);
						amount = _tmp31_;
						_tmp32_ = gca_indent_backend_get_indent_width ((GcaIndentBackend*) self);
						iw = _tmp32_;
						_tmp33_ = amount;
						_tmp34_ = _tmp33_.indent;
						_tmp35_ = iw;
						if (_tmp34_ > _tmp35_) {
							guint _tmp36_ = 0U;
							guint _tmp37_ = 0U;
							_tmp36_ = amount.indent;
							_tmp37_ = iw;
							amount.indent = _tmp36_ - _tmp37_;
						} else {
							amount.indent = (guint) 0;
						}
					} else {
						GtkTextIter _tmp38_ = {0};
						GcaIndentLevel _tmp39_ = {0};
						_tmp38_ = iter;
						gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp38_, &_tmp39_);
						amount = _tmp39_;
					}
				}
				break;
			}
		}
		case ')':
		{
			{
				GtkTextIter copy = {0};
				GtkTextIter _tmp40_ = {0};
				gboolean _tmp41_ = FALSE;
				_tmp40_ = iter;
				copy = _tmp40_;
				_tmp41_ = gca_c_backend_find_open_char (self, &copy, (gunichar) '(', (gunichar) ')', FALSE);
				if (_tmp41_) {
					GtkTextIter _tmp42_ = {0};
					GcaIndentLevel _tmp43_ = {0};
					GtkTextIter _tmp44_ = {0};
					gunichar _tmp45_ = 0U;
					_tmp42_ = copy;
					gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp42_, &_tmp43_);
					amount = _tmp43_;
					_tmp44_ = *place;
					_tmp45_ = gca_c_backend_get_first_char_in_line (self, &_tmp44_);
					if (_tmp45_ != ((gunichar) '{')) {
						guint _tmp46_ = 0U;
						guint _tmp47_ = 0U;
						_tmp46_ = amount.indent;
						_tmp47_ = gca_indent_backend_get_indent_width ((GcaIndentBackend*) self);
						amount.indent = _tmp46_ + _tmp47_;
					}
				}
				break;
			}
		}
		case '{':
		{
			GtkTextIter _tmp48_ = {0};
			GcaIndentLevel _tmp49_ = {0};
			guint _tmp50_ = 0U;
			guint _tmp51_ = 0U;
			_tmp48_ = iter;
			gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp48_, &_tmp49_);
			amount = _tmp49_;
			_tmp50_ = amount.indent;
			_tmp51_ = gca_indent_backend_get_indent_width ((GcaIndentBackend*) self);
			amount.indent = _tmp50_ + _tmp51_;
			break;
		}
		case '}':
		{
			GtkTextIter _tmp52_ = {0};
			GcaIndentLevel _tmp53_ = {0};
			_tmp52_ = iter;
			gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp52_, &_tmp53_);
			amount = _tmp53_;
			break;
		}
		case ',':
		{
			{
				GtkTextIter copy = {0};
				GtkTextIter _tmp54_ = {0};
				gboolean _tmp55_ = FALSE;
				_tmp54_ = iter;
				copy = _tmp54_;
				_tmp55_ = gca_c_backend_find_open_char (self, &copy, (gunichar) '(', (gunichar) ')', TRUE);
				if (_tmp55_) {
					GtkTextIter _tmp56_ = {0};
					GcaIndentLevel _tmp57_ = {0};
					guint _tmp58_ = 0U;
					_tmp56_ = copy;
					gca_indent_backend_get_amount_indents_from_position ((GcaIndentBackend*) self, &_tmp56_, &_tmp57_);
					amount = _tmp57_;
					_tmp58_ = amount.alignment;
					amount.alignment = _tmp58_ + 1;
				} else {
					GtkTextIter _tmp59_ = {0};
					GcaIndentLevel _tmp60_ = {0};
					_tmp59_ = iter;
					gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp59_, &_tmp60_);
					amount = _tmp60_;
				}
				break;
			}
		}
		case ':':
		{
			GtkTextIter _tmp61_ = {0};
			GcaIndentLevel _tmp62_ = {0};
			gboolean _tmp63_ = FALSE;
			GtkTextIter _tmp64_ = {0};
			gunichar _tmp65_ = 0U;
			_tmp61_ = iter;
			gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp61_, &_tmp62_);
			amount = _tmp62_;
			_tmp64_ = *place;
			_tmp65_ = gca_c_backend_get_first_char_in_line (self, &_tmp64_);
			if (_tmp65_ != ((gunichar) '{')) {
				GtkTextIter _tmp66_ = {0};
				gunichar _tmp67_ = 0U;
				_tmp66_ = *place;
				_tmp67_ = gca_c_backend_get_last_char_in_line (self, &_tmp66_);
				_tmp63_ = _tmp67_ != ((gunichar) ':');
			} else {
				_tmp63_ = FALSE;
			}
			if (_tmp63_) {
				guint _tmp68_ = 0U;
				guint _tmp69_ = 0U;
				_tmp68_ = amount.indent;
				_tmp69_ = gca_indent_backend_get_indent_width ((GcaIndentBackend*) self);
				amount.indent = _tmp68_ + _tmp69_;
			}
			break;
		}
		case 'e':
		{
			{
				GtkTextIter cp = {0};
				GtkTextIter _tmp70_ = {0};
				gboolean _tmp71_ = FALSE;
				gboolean _tmp72_ = FALSE;
				_tmp70_ = iter;
				cp = _tmp70_;
				_tmp72_ = gtk_text_iter_forward_char (&cp);
				if (_tmp72_) {
					GtkTextIter _tmp73_ = {0};
					gboolean _tmp74_ = FALSE;
					_tmp73_ = cp;
					_tmp74_ = gca_c_backend_iter_is_at_else (self, &_tmp73_);
					_tmp71_ = _tmp74_;
				} else {
					_tmp71_ = FALSE;
				}
				if (_tmp71_) {
					GtkTextIter _tmp75_ = {0};
					GcaIndentLevel _tmp76_ = {0};
					GtkTextIter _tmp77_ = {0};
					gunichar _tmp78_ = 0U;
					_tmp75_ = iter;
					gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp75_, &_tmp76_);
					amount = _tmp76_;
					_tmp77_ = *place;
					_tmp78_ = gca_c_backend_get_first_char_in_line (self, &_tmp77_);
					if (_tmp78_ != ((gunichar) '{')) {
						guint _tmp79_ = 0U;
						guint _tmp80_ = 0U;
						_tmp79_ = amount.indent;
						_tmp80_ = gca_indent_backend_get_indent_width ((GcaIndentBackend*) self);
						amount.indent = _tmp79_ + _tmp80_;
					}
				}
				break;
			}
		}
		default:
		break;
	}
	_tmp81_ = *place;
	_tmp82_ = gca_c_backend_get_first_char_in_line (self, &_tmp81_);
	if (_tmp82_ == ((gunichar) '}')) {
		GtkTextIter copy = {0};
		GtkTextIter _tmp83_ = {0};
		gboolean _tmp84_ = FALSE;
		_tmp83_ = *place;
		copy = _tmp83_;
		gtk_text_iter_set_line_offset (&copy, 0);
		_tmp84_ = gca_c_backend_find_open_char (self, &copy, (gunichar) '{', (gunichar) '}', TRUE);
		if (_tmp84_) {
			GtkTextIter _tmp85_ = {0};
			GcaIndentLevel _tmp86_ = {0};
			_tmp85_ = copy;
			gca_indent_backend_get_line_indents ((GcaIndentBackend*) self, &_tmp85_, &_tmp86_);
			amount = _tmp86_;
		}
	} else {
		GtkTextIter _tmp87_ = {0};
		gunichar _tmp88_ = 0U;
		_tmp87_ = *place;
		_tmp88_ = gca_c_backend_get_first_char_in_line (self, &_tmp87_);
		if (_tmp88_ == ((gunichar) '#')) {
			GcaIndentLevel _tmp89_ = {0};
			GcaIndentLevel _tmp90_ = {0};
			memset (&_tmp89_, 0, sizeof (GcaIndentLevel));
			_tmp89_.indent = (guint) 0;
			_tmp89_.alignment = (guint) 0;
			amount = _tmp89_;
			_tmp90_ = amount;
		}
	}
	*result = amount;
	return;
}


GcaCBackend* gca_c_backend_construct (GType object_type) {
	GcaCBackend * self = NULL;
	self = (GcaCBackend*) g_object_new (object_type, NULL);
	return self;
}


GcaCBackend* gca_c_backend_new (void) {
	return gca_c_backend_construct (GCA_C_TYPE_BACKEND);
}


static GeditView* gca_c_backend_real_get_view (GcaIndentBackend* base) {
	GeditView* result;
	GcaCBackend* self;
	GeditView* _tmp0_ = NULL;
	self = (GcaCBackend*) base;
	_tmp0_ = self->priv->d_view;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gca_c_backend_real_set_view (GcaIndentBackend* base, GeditView* value) {
	GcaCBackend* self;
	GeditView* _tmp0_ = NULL;
	GeditView* _tmp1_ = NULL;
	self = (GcaCBackend*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->d_view);
	self->priv->d_view = _tmp1_;
	g_object_notify ((GObject *) self, "view");
}


static void gca_c_backend_class_init (GcaCBackendClass * klass) {
	gca_c_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcaCBackendPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gca_c_backend_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gca_c_backend_set_property;
	G_OBJECT_CLASS (klass)->finalize = gca_c_backend_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_C_BACKEND_VIEW, g_param_spec_object ("view", "view", "view", gedit_view_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gca_c_backend_gca_indent_backend_interface_init (GcaIndentBackendIface * iface) {
	gca_c_backend_gca_indent_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_triggers = (gchar** (*)(GcaIndentBackend*, int*)) gca_c_backend_real_get_triggers;
	iface->get_indent = (void (*)(GcaIndentBackend*, GeditDocument*, GtkTextIter*, GcaIndentLevel*)) gca_c_backend_real_get_indent;
	iface->get_view = gca_c_backend_real_get_view;
	iface->set_view = gca_c_backend_real_set_view;
}


static void gca_c_backend_instance_init (GcaCBackend * self) {
	self->priv = GCA_C_BACKEND_GET_PRIVATE (self);
}


static void gca_c_backend_finalize (GObject* obj) {
	GcaCBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_C_TYPE_BACKEND, GcaCBackend);
	_g_object_unref0 (self->priv->d_view);
	G_OBJECT_CLASS (gca_c_backend_parent_class)->finalize (obj);
}


GType gca_c_backend_get_type (void) {
	return gca_c_backend_type_id;
}


GType gca_c_backend_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcaCBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_c_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaCBackend), 0, (GInstanceInitFunc) gca_c_backend_instance_init, NULL };
	static const GInterfaceInfo gca_indent_backend_info = { (GInterfaceInitFunc) gca_c_backend_gca_indent_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	gca_c_backend_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcaCBackend", &g_define_type_info, 0);
	g_type_module_add_interface (module, gca_c_backend_type_id, GCA_TYPE_INDENT_BACKEND, &gca_indent_backend_info);
	return gca_c_backend_type_id;
}


static void _vala_gca_c_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcaCBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCA_C_TYPE_BACKEND, GcaCBackend);
	switch (property_id) {
		case GCA_C_BACKEND_VIEW:
		g_value_set_object (value, gca_indent_backend_get_view ((GcaIndentBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gca_c_backend_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GcaCBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCA_C_TYPE_BACKEND, GcaCBackend);
	switch (property_id) {
		case GCA_C_BACKEND_VIEW:
		gca_indent_backend_set_view ((GcaIndentBackend*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void peas_register_types (GTypeModule* module) {
	PeasObjectModule* mod = NULL;
	GTypeModule* _tmp0_ = NULL;
	PeasObjectModule* _tmp1_ = NULL;
	g_return_if_fail (module != NULL);
	gca_c_backend_register_type (module);
	_tmp0_ = module;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, peas_object_module_get_type ()) ? ((PeasObjectModule*) _tmp0_) : NULL);
	mod = _tmp1_;
	peas_object_module_register_extension_type (mod, GCA_TYPE_INDENT_BACKEND, GCA_C_TYPE_BACKEND);
	_g_object_unref0 (mod);
}



