/* gcp-document.c generated by valac 0.14.0, the Vala compiler
 * generated from gcp-document.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-document.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>


#define GCP_TYPE_DOCUMENT (gcp_document_get_type ())
#define GCP_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DOCUMENT, GcpDocument))
#define GCP_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DOCUMENT, GcpDocumentClass))
#define GCP_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DOCUMENT))
#define GCP_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DOCUMENT))
#define GCP_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DOCUMENT, GcpDocumentClass))

typedef struct _GcpDocument GcpDocument;
typedef struct _GcpDocumentClass GcpDocumentClass;
typedef struct _GcpDocumentPrivate GcpDocumentPrivate;

#define GCP_TYPE_DIAGNOSTIC_SUPPORT (gcp_diagnostic_support_get_type ())
#define GCP_DIAGNOSTIC_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT, GcpDiagnosticSupport))
#define GCP_IS_DIAGNOSTIC_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT))
#define GCP_DIAGNOSTIC_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT, GcpDiagnosticSupportIface))

typedef struct _GcpDiagnosticSupport GcpDiagnosticSupport;
typedef struct _GcpDiagnosticSupportIface GcpDiagnosticSupportIface;

#define GCP_TYPE_DIAGNOSTIC_TAGS (gcp_diagnostic_tags_get_type ())
#define GCP_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTags))
#define GCP_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))
#define GCP_IS_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_IS_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_DIAGNOSTIC_TAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))

typedef struct _GcpDiagnosticTags GcpDiagnosticTags;
typedef struct _GcpDiagnosticTagsClass GcpDiagnosticTagsClass;

#define GCP_TYPE_SOURCE_INDEX (gcp_source_index_get_type ())
#define GCP_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndex))
#define GCP_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))
#define GCP_IS_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_INDEX))
#define GCP_IS_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_INDEX))
#define GCP_SOURCE_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))

typedef struct _GcpSourceIndex GcpSourceIndex;
typedef struct _GcpSourceIndexClass GcpSourceIndexClass;

#define GCP_TYPE_DIAGNOSTIC (gcp_diagnostic_get_type ())
#define GCP_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnostic))
#define GCP_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))
#define GCP_IS_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC))
#define GCP_IS_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC))
#define GCP_DIAGNOSTIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))

typedef struct _GcpDiagnostic GcpDiagnostic;
typedef struct _GcpDiagnosticClass GcpDiagnosticClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;

#define GCP_DIAGNOSTIC_TYPE_SEVERITY (gcp_diagnostic_severity_get_type ())
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

#define GCP_TYPE_SOURCE_RANGE_SUPPORT (gcp_source_range_support_get_type ())
#define GCP_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupport))
#define GCP_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT))
#define GCP_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupportIface))

typedef struct _GcpSourceRangeSupport GcpSourceRangeSupport;
typedef struct _GcpSourceRangeSupportIface GcpSourceRangeSupportIface;

#define GCP_DIAGNOSTIC_TYPE_FIXIT (gcp_diagnostic_fixit_get_type ())
typedef struct _GcpDiagnosticFixit GcpDiagnosticFixit;

#define GCP_SOURCE_INDEX_TYPE_ITERATOR (gcp_source_index_iterator_get_type ())
#define GCP_SOURCE_INDEX_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIterator))
#define GCP_SOURCE_INDEX_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIteratorClass))
#define GCP_SOURCE_INDEX_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR))
#define GCP_SOURCE_INDEX_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_SOURCE_INDEX_TYPE_ITERATOR))
#define GCP_SOURCE_INDEX_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIteratorClass))

typedef struct _GcpSourceIndexIterator GcpSourceIndexIterator;
typedef struct _GcpSourceIndexIteratorClass GcpSourceIndexIteratorClass;

struct _GcpDocument {
	GObject parent_instance;
	GcpDocumentPrivate * priv;
};

struct _GcpDocumentClass {
	GObjectClass parent_class;
	gboolean (*get_tainted) (GcpDocument* self);
	void (*set_tainted) (GcpDocument* self, gboolean value);
};

struct _GcpDocumentPrivate {
	GeditDocument* d_document;
	gboolean d_untitled;
	gboolean d_modified;
	gchar* d_text;
	GFile* d_location;
	gboolean d_tainted;
};

struct _GcpDiagnosticSupportIface {
	GTypeInterface parent_iface;
	GcpDiagnosticTags* (*get_tags) (GcpDiagnosticSupport* self);
	void (*set_tags) (GcpDiagnosticSupport* self, GcpDiagnosticTags* value);
	GcpSourceIndex* (*get_diagnostics) (GcpDiagnosticSupport* self);
};

typedef enum  {
	GCP_DIAGNOSTIC_SEVERITY_NONE,
	GCP_DIAGNOSTIC_SEVERITY_INFO,
	GCP_DIAGNOSTIC_SEVERITY_WARNING,
	GCP_DIAGNOSTIC_SEVERITY_ERROR,
	GCP_DIAGNOSTIC_SEVERITY_FATAL,
	GCP_DIAGNOSTIC_SEVERITY_NUM
} GcpDiagnosticSeverity;

struct _GcpSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcpSourceRange* (*get_range) (GcpSourceRangeSupport* self);
	GcpSourceRange** (*get_ranges) (GcpSourceRangeSupport* self, int* result_length1);
};

struct _GcpDiagnosticFixit {
	GcpSourceRange* range;
	gchar* replacement;
};


static gpointer gcp_document_parent_class = NULL;
static GType gcp_document_type_id = 0;

GType gcp_document_get_type (void) G_GNUC_CONST;
GType gcp_document_register_type (GTypeModule * module);
#define GCP_DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_DOCUMENT, GcpDocumentPrivate))
enum  {
	GCP_DOCUMENT_DUMMY_PROPERTY,
	GCP_DOCUMENT_TAINTED,
	GCP_DOCUMENT_LOCATION,
	GCP_DOCUMENT_TEXT,
	GCP_DOCUMENT_IS_MODIFIED,
	GCP_DOCUMENT_DOCUMENT
};
static void gcp_document_on_document_modified_changed (GcpDocument* self);
static void _gcp_document_on_document_modified_changed_gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self);
static void gcp_document_on_location_changed (GcpDocument* self);
static void _gcp_document_on_location_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gcp_document_on_document_changed (GcpDocument* self);
static void _gcp_document_on_document_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void gcp_document_on_document_saved (GcpDocument* self);
static void _gcp_document_on_document_saved_gedit_document_saved (GeditDocument* _sender, void* _error_, gpointer self);
gpointer gcp_diagnostic_tags_ref (gpointer instance);
void gcp_diagnostic_tags_unref (gpointer instance);
GParamSpec* gcp_param_spec_diagnostic_tags (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_diagnostic_tags (GValue* value, gpointer v_object);
void gcp_value_take_diagnostic_tags (GValue* value, gpointer v_object);
gpointer gcp_value_get_diagnostic_tags (const GValue* value);
GType gcp_diagnostic_tags_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_tags_register_type (GTypeModule * module);
GType gcp_source_index_get_type (void) G_GNUC_CONST;
GType gcp_source_index_register_type (GTypeModule * module);
GType gcp_diagnostic_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_register_type (GTypeModule * module);
GType gcp_diagnostic_support_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_support_register_type (GTypeModule * module);
static void gcp_document_on_diagnostic_updated (GcpDocument* self, GcpDiagnosticSupport* diagnostic);
static void _gcp_document_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated (GcpDiagnosticSupport* _sender, gpointer self);
static void gcp_document_remove_marks (GcpDocument* self);
GcpDocument* gcp_document_new (GeditDocument* document);
GcpDocument* gcp_document_construct (GType object_type, GeditDocument* document);
static void gcp_document_update_modified (GcpDocument* self);
static void gcp_document_update_location (GcpDocument* self);
const gchar* gcp_document_get_info_mark_category (void);
const gchar* gcp_document_get_warning_mark_category (void);
const gchar* gcp_document_get_error_mark_category (void);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GType gcp_source_location_register_type (GTypeModule * module);
static gboolean gcp_document_source_location (GcpDocument* self, GcpSourceLocation* location, GtkTextIter* iter);
gint gcp_source_location_get_line (GcpSourceLocation* self);
gint gcp_source_location_get_column (GcpSourceLocation* self);
GType gcp_source_range_get_type (void) G_GNUC_CONST;
GType gcp_source_range_register_type (GTypeModule * module);
gboolean gcp_document_source_range (GcpDocument* self, GcpSourceRange* range, GtkTextIter* start, GtkTextIter* end);
GcpSourceLocation* gcp_source_range_get_start (GcpSourceRange* self);
GcpSourceLocation* gcp_source_range_get_end (GcpSourceRange* self);
GType gcp_diagnostic_severity_get_type (void) G_GNUC_CONST;
gchar* gcp_document_mark_category_for_severity (GcpDiagnosticSeverity severity);
static void gcp_document_mark_diagnostic_range (GcpDocument* self, GcpDiagnostic* diagnostic, GtkTextIter* start, GtkTextIter* end);
GcpDiagnosticTags* gcp_diagnostic_support_get_tags (GcpDiagnosticSupport* self);
GtkTextTag* gcp_diagnostic_tags_get (GcpDiagnosticTags* self, GcpDiagnosticSeverity severity);
GcpDiagnosticSeverity gcp_diagnostic_get_severity (GcpDiagnostic* self);
static void gcp_document_mark_diagnostic (GcpDocument* self, GcpDiagnostic* diagnostic);
GType gcp_source_range_support_get_type (void) G_GNUC_CONST;
GType gcp_source_range_support_register_type (GTypeModule * module);
GcpSourceRange** gcp_source_range_support_get_ranges (GcpSourceRangeSupport* self, int* result_length1);
GcpSourceLocation* gcp_diagnostic_get_location (GcpDiagnostic* self);
GtkTextTag* gcp_diagnostic_tags_get_location_tag (GcpDiagnosticTags* self);
GType gcp_diagnostic_fixit_get_type (void) G_GNUC_CONST;
GcpDiagnosticFixit* gcp_diagnostic_fixit_dup (const GcpDiagnosticFixit* self);
void gcp_diagnostic_fixit_free (GcpDiagnosticFixit* self);
void gcp_diagnostic_fixit_copy (const GcpDiagnosticFixit* self, GcpDiagnosticFixit* dest);
void gcp_diagnostic_fixit_destroy (GcpDiagnosticFixit* self);
GcpDiagnosticFixit* gcp_diagnostic_get_fixits (GcpDiagnostic* self, int* result_length1);
GtkTextTag* gcp_diagnostic_tags_get_fixit_tag (GcpDiagnosticTags* self);
GtkTextTag* gcp_diagnostic_tags_get_error_tag (GcpDiagnosticTags* self);
GtkTextTag* gcp_diagnostic_tags_get_warning_tag (GcpDiagnosticTags* self);
GtkTextTag* gcp_diagnostic_tags_get_info_tag (GcpDiagnosticTags* self);
GcpSourceIndex* gcp_diagnostic_support_get_diagnostics (GcpDiagnosticSupport* self);
GType gcp_source_index_iterator_get_type (void) G_GNUC_CONST;
GType gcp_source_index_iterator_register_type (GTypeModule * module);
GcpSourceIndexIterator* gcp_source_index_iterator (GcpSourceIndex* self);
gboolean gcp_source_index_iterator_next (GcpSourceIndexIterator* self);
gpointer gcp_source_index_iterator_get (GcpSourceIndexIterator* self);
static void gcp_document_set_location (GcpDocument* self, GFile* location);
GeditDocument* gcp_document_get_document (GcpDocument* self);
static void gcp_document_update_text (GcpDocument* self);
void gcp_document_emit_changed (GcpDocument* self);
gboolean gcp_document_get_tainted (GcpDocument* self);
void gcp_document_set_tainted (GcpDocument* self, gboolean value);
GFile* gcp_document_get_location (GcpDocument* self);
const gchar* gcp_document_get_text (GcpDocument* self);
gboolean gcp_document_get_is_modified (GcpDocument* self);
static void gcp_document_finalize (GObject* obj);
static void _vala_gcp_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gcp_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _gcp_document_on_document_modified_changed_gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self) {
	gcp_document_on_document_modified_changed (self);
}


static void _gcp_document_on_location_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gcp_document_on_location_changed (self);
}


static void _gcp_document_on_document_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	gcp_document_on_document_changed (self);
}


static void _gcp_document_on_document_saved_gedit_document_saved (GeditDocument* _sender, void* _error_, gpointer self) {
	gcp_document_on_document_saved (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gcp_document_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated (GcpDiagnosticSupport* _sender, gpointer self) {
	gcp_document_on_diagnostic_updated (self, _sender);
}


GcpDocument* gcp_document_construct (GType object_type, GeditDocument* document) {
	GcpDocument * self = NULL;
	GeditDocument* _tmp0_;
	GeditDocument* _tmp1_;
	GeditDocument* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeditDocument* _tmp4_;
	GeditDocument* _tmp5_;
	GeditDocument* _tmp6_;
	GeditDocument* _tmp7_;
	GcpDiagnosticSupport* _tmp8_;
	GcpDiagnosticSupport* diag;
	GcpDiagnosticSupport* _tmp9_;
	g_return_val_if_fail (document != NULL, NULL);
	self = (GcpDocument*) g_object_new (object_type, NULL);
	_tmp0_ = document;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->d_document);
	self->priv->d_document = _tmp1_;
	_tmp2_ = self->priv->d_document;
	_tmp3_ = gedit_document_is_untitled (_tmp2_);
	self->priv->d_untitled = _tmp3_;
	self->priv->d_modified = FALSE;
	_g_free0 (self->priv->d_text);
	self->priv->d_text = NULL;
	gcp_document_update_modified (self);
	_tmp4_ = self->priv->d_document;
	g_signal_connect_object ((GtkTextBuffer*) _tmp4_, "modified-changed", (GCallback) _gcp_document_on_document_modified_changed_gtk_text_buffer_modified_changed, self, 0);
	_tmp5_ = self->priv->d_document;
	g_signal_connect_object ((GtkTextBuffer*) _tmp5_, "changed", (GCallback) _gcp_document_on_document_changed_gtk_text_buffer_changed, self, 0);
	_tmp6_ = self->priv->d_document;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::location", (GCallback) _gcp_document_on_location_changed_g_object_notify, self, 0);
	_tmp7_ = self->priv->d_document;
	g_signal_connect_object (_tmp7_, "saved", (GCallback) _gcp_document_on_document_saved_gedit_document_saved, self, 0);
	_g_object_unref0 (self->priv->d_location);
	self->priv->d_location = NULL;
	gcp_document_update_location (self);
	_tmp8_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (self) ? ((GcpDiagnosticSupport*) self) : NULL);
	diag = _tmp8_;
	_tmp9_ = diag;
	if (_tmp9_ != NULL) {
		GcpDiagnosticSupport* _tmp10_;
		_tmp10_ = diag;
		g_signal_connect_object (_tmp10_, "diagnostics-updated", (GCallback) _gcp_document_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated, self, 0);
	}
	_g_object_unref0 (diag);
	return self;
}


GcpDocument* gcp_document_new (GeditDocument* document) {
	return gcp_document_construct (GCP_TYPE_DOCUMENT, document);
}


static void gcp_document_remove_marks (GcpDocument* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GeditDocument* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GeditDocument* _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GeditDocument* _tmp8_;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_ = {0};
	GeditDocument* _tmp11_;
	GtkTextIter _tmp12_;
	GtkTextIter _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GeditDocument* _tmp16_;
	GtkTextIter _tmp17_ = {0};
	GtkTextIter _tmp18_ = {0};
	GeditDocument* _tmp19_;
	GtkTextIter _tmp20_;
	GtkTextIter _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_document;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp0_, &_tmp1_, &_tmp2_);
	start = _tmp1_;
	end = _tmp2_;
	_tmp3_ = self->priv->d_document;
	_tmp4_ = start;
	_tmp5_ = end;
	_tmp6_ = gcp_document_get_info_mark_category ();
	_tmp7_ = _tmp6_;
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) _tmp3_, &_tmp4_, &_tmp5_, _tmp7_);
	_tmp8_ = self->priv->d_document;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp8_, &_tmp9_, &_tmp10_);
	start = _tmp9_;
	end = _tmp10_;
	_tmp11_ = self->priv->d_document;
	_tmp12_ = start;
	_tmp13_ = end;
	_tmp14_ = gcp_document_get_warning_mark_category ();
	_tmp15_ = _tmp14_;
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) _tmp11_, &_tmp12_, &_tmp13_, _tmp15_);
	_tmp16_ = self->priv->d_document;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp16_, &_tmp17_, &_tmp18_);
	start = _tmp17_;
	end = _tmp18_;
	_tmp19_ = self->priv->d_document;
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = gcp_document_get_error_mark_category ();
	_tmp23_ = _tmp22_;
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) _tmp19_, &_tmp20_, &_tmp21_, _tmp23_);
}


static gboolean gcp_document_source_location (GcpDocument* self, GcpSourceLocation* location, GtkTextIter* iter) {
	GtkTextIter _vala_iter = {0};
	gboolean result = FALSE;
	GeditDocument* _tmp0_;
	GcpSourceLocation* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkTextIter _tmp4_ = {0};
	gint _tmp5_ = 0;
	GcpSourceLocation* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GcpSourceLocation* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = self->priv->d_document;
	_tmp1_ = location;
	_tmp2_ = gcp_source_location_get_line (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp0_, &_tmp4_, _tmp3_ - 1);
	_vala_iter = _tmp4_;
	_tmp5_ = gtk_text_iter_get_line (&_vala_iter);
	_tmp6_ = location;
	_tmp7_ = gcp_source_location_get_line (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp5_ != (_tmp8_ - 1)) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp9_ = location;
	_tmp10_ = gcp_source_location_get_column (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > 1) {
		GtkTextIter enditer = {0};
		GeditDocument* _tmp12_;
		GtkTextIter _tmp13_ = {0};
		gboolean _tmp14_ = FALSE;
		GcpSourceLocation* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp21_;
		gint _tmp22_ = 0;
		GcpSourceLocation* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		_tmp12_ = self->priv->d_document;
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) _tmp12_, &_tmp13_);
		enditer = _tmp13_;
		_tmp15_ = location;
		_tmp16_ = gcp_source_location_get_column (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = gtk_text_iter_forward_chars (&_vala_iter, _tmp17_ - 1);
		if (!_tmp18_) {
			GtkTextIter _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp19_ = enditer;
			_tmp20_ = gtk_text_iter_equal (&_vala_iter, &_tmp19_);
			_tmp14_ = !_tmp20_;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp21_ = _tmp14_;
		if (_tmp21_) {
			result = FALSE;
			if (iter) {
				*iter = _vala_iter;
			}
			return result;
		}
		_tmp22_ = gtk_text_iter_get_line (&_vala_iter);
		_tmp23_ = location;
		_tmp24_ = gcp_source_location_get_line (_tmp23_);
		_tmp25_ = _tmp24_;
		result = _tmp22_ == (_tmp25_ - 1);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	} else {
		result = TRUE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	if (iter) {
		*iter = _vala_iter;
	}
}


gboolean gcp_document_source_range (GcpDocument* self, GcpSourceRange* range, GtkTextIter* start, GtkTextIter* end) {
	GtkTextIter _vala_start = {0};
	GtkTextIter _vala_end = {0};
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GcpSourceRange* _tmp1_;
	GcpSourceLocation* _tmp2_;
	GcpSourceLocation* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (range != NULL, FALSE);
	_tmp1_ = range;
	_tmp2_ = gcp_source_range_get_start (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp5_ = gcp_document_source_location (self, _tmp3_, &_tmp4_);
	_vala_start = _tmp4_;
	if (_tmp5_) {
		GcpSourceRange* _tmp6_;
		GcpSourceLocation* _tmp7_;
		GcpSourceLocation* _tmp8_;
		GtkTextIter _tmp9_ = {0};
		gboolean _tmp10_ = FALSE;
		_tmp6_ = range;
		_tmp7_ = gcp_source_range_get_end (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp10_ = gcp_document_source_location (self, _tmp8_, &_tmp9_);
		_vala_end = _tmp9_;
		_tmp0_ = _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp11_ = _tmp0_;
	result = _tmp11_;
	if (start) {
		*start = _vala_start;
	}
	if (end) {
		*end = _vala_end;
	}
	return result;
}


gchar* gcp_document_mark_category_for_severity (GcpDiagnosticSeverity severity) {
	gchar* result = NULL;
	GcpDiagnosticSeverity _tmp0_;
	_tmp0_ = severity;
	switch (_tmp0_) {
		case GCP_DIAGNOSTIC_SEVERITY_WARNING:
		{
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = gcp_document_get_warning_mark_category ();
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case GCP_DIAGNOSTIC_SEVERITY_ERROR:
		case GCP_DIAGNOSTIC_SEVERITY_FATAL:
		{
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = gcp_document_get_error_mark_category ();
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case GCP_DIAGNOSTIC_SEVERITY_INFO:
		{
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = gcp_document_get_info_mark_category ();
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


static void gcp_document_mark_diagnostic_range (GcpDocument* self, GcpDiagnostic* diagnostic, GtkTextIter* start, GtkTextIter* end) {
	GcpDiagnosticSupport* _tmp0_;
	GcpDiagnosticSupport* sup;
	GcpDiagnosticSupport* _tmp1_;
	GcpDiagnosticTags* _tmp2_;
	GcpDiagnosticTags* _tmp3_;
	GcpDiagnostic* _tmp4_;
	GcpDiagnosticSeverity _tmp5_;
	GcpDiagnosticSeverity _tmp6_;
	GtkTextTag* _tmp7_ = NULL;
	GtkTextTag* tag;
	GcpDiagnostic* _tmp8_;
	GcpDiagnosticSeverity _tmp9_;
	GcpDiagnosticSeverity _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* category;
	GeditDocument* _tmp12_;
	GtkTextTag* _tmp13_;
	GtkTextIter _tmp14_;
	GtkTextIter _tmp15_;
	GtkTextIter _tmp16_;
	GtkTextIter m;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diagnostic != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (self) ? ((GcpDiagnosticSupport*) self) : NULL);
	sup = _tmp0_;
	_tmp1_ = sup;
	_tmp2_ = gcp_diagnostic_support_get_tags (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = diagnostic;
	_tmp5_ = gcp_diagnostic_get_severity (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gcp_diagnostic_tags_get (_tmp3_, _tmp6_);
	tag = _tmp7_;
	_tmp8_ = diagnostic;
	_tmp9_ = gcp_diagnostic_get_severity (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gcp_document_mark_category_for_severity (_tmp10_);
	category = _tmp11_;
	_tmp12_ = self->priv->d_document;
	_tmp13_ = tag;
	_tmp14_ = *start;
	_tmp15_ = *end;
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) _tmp12_, _tmp13_, &_tmp14_, &_tmp15_);
	_tmp16_ = *start;
	m = _tmp16_;
	_tmp17_ = gtk_text_iter_starts_line (&m);
	if (!_tmp17_) {
		gtk_text_iter_set_line_offset (&m, 0);
	}
	while (TRUE) {
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_;
		gboolean _tmp22_;
		gboolean alreadyhas;
		GeditDocument* _tmp23_;
		GtkTextIter _tmp24_;
		const gchar* _tmp25_;
		GSList* _tmp26_ = NULL;
		gboolean _tmp31_;
		gboolean _tmp40_ = FALSE;
		_tmp19_ = category;
		if (_tmp19_ != NULL) {
			GtkTextIter _tmp20_;
			gint _tmp21_ = 0;
			_tmp20_ = *end;
			_tmp21_ = gtk_text_iter_compare (&m, &_tmp20_);
			_tmp18_ = _tmp21_ <= 0;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp22_ = _tmp18_;
		if (!_tmp22_) {
			break;
		}
		alreadyhas = FALSE;
		_tmp23_ = self->priv->d_document;
		_tmp24_ = m;
		_tmp25_ = category;
		_tmp26_ = gtk_source_buffer_get_source_marks_at_iter ((GtkSourceBuffer*) _tmp23_, &_tmp24_, _tmp25_);
		{
			GSList* mark_collection = NULL;
			GSList* mark_it = NULL;
			mark_collection = _tmp26_;
			for (mark_it = mark_collection; mark_it != NULL; mark_it = mark_it->next) {
				GtkSourceMark* _tmp27_;
				GtkSourceMark* mark = NULL;
				_tmp27_ = _g_object_ref0 ((GtkSourceMark*) mark_it->data);
				mark = _tmp27_;
				{
					GtkSourceMark* _tmp28_;
					gconstpointer _tmp29_ = NULL;
					GcpDiagnostic* _tmp30_;
					_tmp28_ = mark;
					_tmp29_ = g_object_get_data ((GObject*) _tmp28_, "Gcp.Document.MarkDiagnostic");
					_tmp30_ = diagnostic;
					if (((GcpDiagnostic*) _tmp29_) == _tmp30_) {
						alreadyhas = TRUE;
						_g_object_unref0 (mark);
						break;
					}
					_g_object_unref0 (mark);
				}
			}
			_g_slist_free0 (mark_collection);
		}
		_tmp31_ = alreadyhas;
		if (!_tmp31_) {
			GeditDocument* _tmp32_;
			const gchar* _tmp33_;
			GtkTextIter _tmp34_;
			GtkSourceMark* _tmp35_ = NULL;
			GtkSourceMark* _tmp36_;
			GtkSourceMark* mark;
			GtkSourceMark* _tmp37_;
			GcpDiagnostic* _tmp38_;
			GcpDiagnostic* _tmp39_;
			_tmp32_ = self->priv->d_document;
			_tmp33_ = category;
			_tmp34_ = m;
			_tmp35_ = gtk_source_buffer_create_source_mark ((GtkSourceBuffer*) _tmp32_, NULL, _tmp33_, &_tmp34_);
			_tmp36_ = _g_object_ref0 (_tmp35_);
			mark = _tmp36_;
			_tmp37_ = mark;
			_tmp38_ = diagnostic;
			_tmp39_ = _g_object_ref0 (_tmp38_);
			g_object_set_data_full ((GObject*) _tmp37_, "Gcp.Document.MarkDiagnostic", _tmp39_, g_object_unref);
			_g_object_unref0 (mark);
		}
		_tmp40_ = gtk_text_iter_forward_line (&m);
		if (!_tmp40_) {
			break;
		}
	}
	_g_free0 (category);
	_g_object_unref0 (tag);
	_g_object_unref0 (sup);
}


static void gcp_document_mark_diagnostic (GcpDocument* self, GcpDiagnostic* diagnostic) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GcpDiagnosticSupport* _tmp0_;
	GcpDiagnosticSupport* sup;
	GcpDiagnosticSupport* _tmp1_;
	GcpDiagnosticTags* _tmp2_;
	GcpDiagnosticTags* _tmp3_;
	GcpDiagnostic* _tmp4_;
	GcpDiagnosticSeverity _tmp5_;
	GcpDiagnosticSeverity _tmp6_;
	GtkTextTag* _tmp7_ = NULL;
	GtkTextTag* tag;
	GcpDiagnostic* _tmp8_;
	GcpDiagnosticSeverity _tmp9_;
	GcpDiagnosticSeverity _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* category;
	GcpDiagnostic* _tmp34_;
	GcpSourceLocation* _tmp35_;
	GcpSourceLocation* _tmp36_;
	GtkTextIter _tmp37_ = {0};
	gboolean _tmp38_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diagnostic != NULL);
	_tmp0_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (self) ? ((GcpDiagnosticSupport*) self) : NULL);
	sup = _tmp0_;
	_tmp1_ = sup;
	_tmp2_ = gcp_diagnostic_support_get_tags (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = diagnostic;
	_tmp5_ = gcp_diagnostic_get_severity (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gcp_diagnostic_tags_get (_tmp3_, _tmp6_);
	tag = _tmp7_;
	_tmp8_ = diagnostic;
	_tmp9_ = gcp_diagnostic_get_severity (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gcp_document_mark_category_for_severity (_tmp10_);
	category = _tmp11_;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp12_;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_;
				guint _tmp15_;
				GcpDiagnostic* _tmp16_;
				GcpSourceRange** _tmp17_;
				gint _tmp17__length1;
				GcpSourceRange** _tmp18_;
				gint _tmp18__length1;
				GcpSourceRange** _tmp19_;
				gint _tmp19__length1;
				gboolean _tmp20_;
				GcpDiagnostic* _tmp21_;
				GcpSourceRange** _tmp22_;
				gint _tmp22__length1;
				GcpSourceRange** _tmp23_;
				gint _tmp23__length1;
				GcpSourceRange** _tmp24_;
				gint _tmp24__length1;
				guint _tmp25_;
				GcpSourceRange* _tmp26_;
				GtkTextIter _tmp27_ = {0};
				GtkTextIter _tmp28_ = {0};
				gboolean _tmp29_ = FALSE;
				gboolean _tmp30_;
				GcpDiagnostic* _tmp31_;
				GtkTextIter _tmp32_;
				GtkTextIter _tmp33_;
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					guint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp15_ = i;
				_tmp16_ = diagnostic;
				_tmp17_ = gcp_source_range_support_get_ranges ((GcpSourceRangeSupport*) _tmp16_, &_tmp17__length1);
				_tmp18_ = _tmp17_;
				_tmp18__length1 = _tmp17__length1;
				_tmp19_ = _tmp18_;
				_tmp19__length1 = _tmp18__length1;
				_tmp20_ = !(_tmp15_ < ((guint) _tmp18__length1));
				_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_object_unref), NULL);
				if (_tmp20_) {
					break;
				}
				_tmp21_ = diagnostic;
				_tmp22_ = gcp_source_range_support_get_ranges ((GcpSourceRangeSupport*) _tmp21_, &_tmp22__length1);
				_tmp23_ = _tmp22_;
				_tmp23__length1 = _tmp22__length1;
				_tmp24_ = _tmp23_;
				_tmp24__length1 = _tmp23__length1;
				_tmp25_ = i;
				_tmp26_ = _tmp24_[_tmp25_];
				_tmp29_ = gcp_document_source_range (self, _tmp26_, &_tmp27_, &_tmp28_);
				start = _tmp27_;
				end = _tmp28_;
				_tmp30_ = !_tmp29_;
				_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_object_unref), NULL);
				if (_tmp30_) {
					continue;
				}
				_tmp31_ = diagnostic;
				_tmp32_ = start;
				_tmp33_ = end;
				gcp_document_mark_diagnostic_range (self, _tmp31_, &_tmp32_, &_tmp33_);
			}
		}
	}
	_tmp34_ = diagnostic;
	_tmp35_ = gcp_diagnostic_get_location (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp38_ = gcp_document_source_location (self, _tmp36_, &_tmp37_);
	start = _tmp37_;
	if (_tmp38_) {
		GtkTextIter _tmp39_;
		gboolean _tmp40_ = FALSE;
		GcpDiagnostic* _tmp41_;
		GtkTextIter _tmp42_;
		GtkTextIter _tmp43_;
		GeditDocument* _tmp44_;
		GcpDiagnosticSupport* _tmp45_;
		GcpDiagnosticTags* _tmp46_;
		GcpDiagnosticTags* _tmp47_;
		GtkTextTag* _tmp48_;
		GtkTextTag* _tmp49_;
		GtkTextIter _tmp50_;
		GtkTextIter _tmp51_;
		_tmp39_ = start;
		end = _tmp39_;
		_tmp40_ = gtk_text_iter_ends_line (&start);
		if (!_tmp40_) {
			gtk_text_iter_forward_char (&end);
		}
		_tmp41_ = diagnostic;
		_tmp42_ = start;
		_tmp43_ = end;
		gcp_document_mark_diagnostic_range (self, _tmp41_, &_tmp42_, &_tmp43_);
		_tmp44_ = self->priv->d_document;
		_tmp45_ = sup;
		_tmp46_ = gcp_diagnostic_support_get_tags (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = gcp_diagnostic_tags_get_location_tag (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = start;
		_tmp51_ = end;
		gtk_text_buffer_apply_tag ((GtkTextBuffer*) _tmp44_, _tmp49_, &_tmp50_, &_tmp51_);
	}
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp52_;
			_tmp52_ = TRUE;
			while (TRUE) {
				gboolean _tmp53_;
				guint _tmp55_;
				GcpDiagnostic* _tmp56_;
				GcpDiagnosticFixit* _tmp57_;
				gint _tmp57__length1;
				GcpDiagnosticFixit* _tmp58_;
				gint _tmp58__length1;
				GcpDiagnostic* _tmp59_;
				GcpDiagnosticFixit* _tmp60_;
				gint _tmp60__length1;
				GcpDiagnosticFixit* _tmp61_;
				gint _tmp61__length1;
				guint _tmp62_;
				GcpDiagnosticFixit _tmp63_;
				GcpSourceRange* _tmp64_;
				GcpSourceRange* _tmp65_;
				GcpSourceRange* r;
				GcpSourceRange* _tmp66_;
				GtkTextIter _tmp67_ = {0};
				GtkTextIter _tmp68_ = {0};
				gboolean _tmp69_ = FALSE;
				_tmp53_ = _tmp52_;
				if (!_tmp53_) {
					guint _tmp54_;
					_tmp54_ = i;
					i = _tmp54_ + 1;
				}
				_tmp52_ = FALSE;
				_tmp55_ = i;
				_tmp56_ = diagnostic;
				_tmp57_ = gcp_diagnostic_get_fixits (_tmp56_, &_tmp57__length1);
				_tmp58_ = _tmp57_;
				_tmp58__length1 = _tmp57__length1;
				if (!(_tmp55_ < ((guint) _tmp58__length1))) {
					break;
				}
				_tmp59_ = diagnostic;
				_tmp60_ = gcp_diagnostic_get_fixits (_tmp59_, &_tmp60__length1);
				_tmp61_ = _tmp60_;
				_tmp61__length1 = _tmp60__length1;
				_tmp62_ = i;
				_tmp63_ = _tmp61_[_tmp62_];
				_tmp64_ = _tmp63_.range;
				_tmp65_ = _g_object_ref0 (_tmp64_);
				r = _tmp65_;
				_tmp66_ = r;
				_tmp69_ = gcp_document_source_range (self, _tmp66_, &_tmp67_, &_tmp68_);
				start = _tmp67_;
				end = _tmp68_;
				if (_tmp69_) {
					GeditDocument* _tmp70_;
					GcpDiagnosticSupport* _tmp71_;
					GcpDiagnosticTags* _tmp72_;
					GcpDiagnosticTags* _tmp73_;
					GtkTextTag* _tmp74_;
					GtkTextTag* _tmp75_;
					GtkTextIter _tmp76_;
					GtkTextIter _tmp77_;
					_tmp70_ = self->priv->d_document;
					_tmp71_ = sup;
					_tmp72_ = gcp_diagnostic_support_get_tags (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp74_ = gcp_diagnostic_tags_get_fixit_tag (_tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = start;
					_tmp77_ = end;
					gtk_text_buffer_apply_tag ((GtkTextBuffer*) _tmp70_, _tmp75_, &_tmp76_, &_tmp77_);
				}
				_g_object_unref0 (r);
			}
		}
	}
	_g_free0 (category);
	_g_object_unref0 (tag);
	_g_object_unref0 (sup);
}


static void gcp_document_on_diagnostic_updated (GcpDocument* self, GcpDiagnosticSupport* diagnostic) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GeditDocument* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GeditDocument* _tmp3_;
	GcpDiagnosticSupport* _tmp4_;
	GcpDiagnosticTags* _tmp5_;
	GcpDiagnosticTags* _tmp6_;
	GtkTextTag* _tmp7_;
	GtkTextTag* _tmp8_;
	GtkTextIter _tmp9_;
	GtkTextIter _tmp10_;
	GeditDocument* _tmp11_;
	GcpDiagnosticSupport* _tmp12_;
	GcpDiagnosticTags* _tmp13_;
	GcpDiagnosticTags* _tmp14_;
	GtkTextTag* _tmp15_;
	GtkTextTag* _tmp16_;
	GtkTextIter _tmp17_;
	GtkTextIter _tmp18_;
	GeditDocument* _tmp19_;
	GcpDiagnosticSupport* _tmp20_;
	GcpDiagnosticTags* _tmp21_;
	GcpDiagnosticTags* _tmp22_;
	GtkTextTag* _tmp23_;
	GtkTextTag* _tmp24_;
	GtkTextIter _tmp25_;
	GtkTextIter _tmp26_;
	GeditDocument* _tmp27_;
	GcpDiagnosticSupport* _tmp28_;
	GcpDiagnosticTags* _tmp29_;
	GcpDiagnosticTags* _tmp30_;
	GtkTextTag* _tmp31_;
	GtkTextTag* _tmp32_;
	GtkTextIter _tmp33_;
	GtkTextIter _tmp34_;
	GeditDocument* _tmp35_;
	GcpDiagnosticSupport* _tmp36_;
	GcpDiagnosticTags* _tmp37_;
	GcpDiagnosticTags* _tmp38_;
	GtkTextTag* _tmp39_;
	GtkTextTag* _tmp40_;
	GtkTextIter _tmp41_;
	GtkTextIter _tmp42_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diagnostic != NULL);
	_tmp0_ = self->priv->d_document;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp0_, &_tmp1_, &_tmp2_);
	start = _tmp1_;
	end = _tmp2_;
	_tmp3_ = self->priv->d_document;
	_tmp4_ = diagnostic;
	_tmp5_ = gcp_diagnostic_support_get_tags (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gcp_diagnostic_tags_get_error_tag (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = start;
	_tmp10_ = end;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) _tmp3_, _tmp8_, &_tmp9_, &_tmp10_);
	_tmp11_ = self->priv->d_document;
	_tmp12_ = diagnostic;
	_tmp13_ = gcp_diagnostic_support_get_tags (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = gcp_diagnostic_tags_get_warning_tag (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = start;
	_tmp18_ = end;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) _tmp11_, _tmp16_, &_tmp17_, &_tmp18_);
	_tmp19_ = self->priv->d_document;
	_tmp20_ = diagnostic;
	_tmp21_ = gcp_diagnostic_support_get_tags (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = gcp_diagnostic_tags_get_info_tag (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = start;
	_tmp26_ = end;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) _tmp19_, _tmp24_, &_tmp25_, &_tmp26_);
	_tmp27_ = self->priv->d_document;
	_tmp28_ = diagnostic;
	_tmp29_ = gcp_diagnostic_support_get_tags (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = gcp_diagnostic_tags_get_location_tag (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = start;
	_tmp34_ = end;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) _tmp27_, _tmp32_, &_tmp33_, &_tmp34_);
	_tmp35_ = self->priv->d_document;
	_tmp36_ = diagnostic;
	_tmp37_ = gcp_diagnostic_support_get_tags (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = gcp_diagnostic_tags_get_fixit_tag (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = start;
	_tmp42_ = end;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) _tmp35_, _tmp40_, &_tmp41_, &_tmp42_);
	gcp_document_remove_marks (self);
	{
		GcpDiagnosticSupport* _tmp43_;
		GcpSourceIndex* _tmp44_;
		GcpSourceIndex* _tmp45_;
		GcpSourceIndexIterator* _tmp46_ = NULL;
		GcpSourceIndexIterator* _diag_it;
		_tmp43_ = diagnostic;
		_tmp44_ = gcp_diagnostic_support_get_diagnostics (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = gcp_source_index_iterator (_tmp45_);
		_diag_it = _tmp46_;
		while (TRUE) {
			GcpSourceIndexIterator* _tmp47_;
			gboolean _tmp48_ = FALSE;
			GcpSourceIndexIterator* _tmp49_;
			gpointer _tmp50_ = NULL;
			GcpDiagnostic* diag;
			GcpDiagnostic* _tmp51_;
			_tmp47_ = _diag_it;
			_tmp48_ = gcp_source_index_iterator_next (_tmp47_);
			if (!_tmp48_) {
				break;
			}
			_tmp49_ = _diag_it;
			_tmp50_ = gcp_source_index_iterator_get (_tmp49_);
			diag = (GcpDiagnostic*) _tmp50_;
			_tmp51_ = diag;
			gcp_document_mark_diagnostic (self, _tmp51_);
			_g_object_unref0 (diag);
		}
		_g_object_unref0 (_diag_it);
	}
}


static void gcp_document_set_location (GcpDocument* self, GFile* location) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* prev;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = location;
	_tmp1_ = self->priv->d_location;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = self->priv->d_location;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	prev = _tmp3_;
	_tmp4_ = location;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->d_location);
	self->priv->d_location = _tmp5_;
	_tmp6_ = prev;
	_tmp7_ = self->priv->d_location;
	if ((_tmp6_ == NULL) != (_tmp7_ == NULL)) {
		GFile* _tmp8_;
		_tmp8_ = prev;
		g_signal_emit_by_name (self, "location-changed", _tmp8_);
	} else {
		gboolean _tmp9_ = FALSE;
		GFile* _tmp10_;
		gboolean _tmp14_;
		_tmp10_ = prev;
		if (_tmp10_ != NULL) {
			GFile* _tmp11_;
			GFile* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp11_ = prev;
			_tmp12_ = self->priv->d_location;
			_tmp13_ = g_file_equal (_tmp11_, _tmp12_);
			_tmp9_ = !_tmp13_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp14_ = _tmp9_;
		if (_tmp14_) {
			GFile* _tmp15_;
			_tmp15_ = prev;
			g_signal_emit_by_name (self, "location-changed", _tmp15_);
		}
	}
	_g_object_unref0 (prev);
}


static void gcp_document_update_location (GcpDocument* self) {
	GeditDocument* _tmp0_;
	GeditDocument* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeditDocument* _tmp3_;
	GeditDocument* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeditDocument* _tmp6_;
	GeditDocument* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gcp_document_get_document (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gedit_document_is_untitled (_tmp1_);
	if (_tmp2_) {
		gcp_document_set_location (self, NULL);
		return;
	}
	_tmp3_ = gcp_document_get_document (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = gedit_document_is_local (_tmp4_);
	if (!_tmp5_) {
		gcp_document_set_location (self, NULL);
		return;
	}
	_tmp6_ = gcp_document_get_document (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = gedit_document_get_location (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	gcp_document_set_location (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
}


static void gcp_document_update_modified (GcpDocument* self) {
	gboolean _tmp0_;
	GeditDocument* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_modified;
	_tmp1_ = self->priv->d_document;
	_tmp2_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp1_);
	if (_tmp0_ == _tmp2_) {
		return;
	}
	_g_free0 (self->priv->d_text);
	self->priv->d_text = NULL;
	_tmp3_ = self->priv->d_modified;
	self->priv->d_modified = !_tmp3_;
	_tmp4_ = self->priv->d_modified;
	if (_tmp4_) {
		gcp_document_update_text (self);
	} else {
		gcp_document_emit_changed (self);
	}
}


void gcp_document_emit_changed (GcpDocument* self) {
	g_return_if_fail (self != NULL);
	self->priv->d_tainted = TRUE;
	g_signal_emit_by_name (self, "changed");
}


static void gcp_document_update_text (GcpDocument* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GeditDocument* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GeditDocument* _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_document;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp0_, &_tmp1_, &_tmp2_);
	start = _tmp1_;
	end = _tmp2_;
	_tmp3_ = self->priv->d_document;
	_tmp4_ = start;
	_tmp5_ = end;
	_tmp6_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp3_, &_tmp4_, &_tmp5_, TRUE);
	_g_free0 (self->priv->d_text);
	self->priv->d_text = _tmp6_;
	gcp_document_emit_changed (self);
}


static void gcp_document_on_document_changed (GcpDocument* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_modified;
	if (_tmp0_) {
		gcp_document_update_text (self);
	}
}


static void gcp_document_on_document_modified_changed (GcpDocument* self) {
	g_return_if_fail (self != NULL);
	gcp_document_update_modified (self);
}


static void gcp_document_on_location_changed (GcpDocument* self) {
	g_return_if_fail (self != NULL);
	gcp_document_update_location (self);
}


static void gcp_document_on_document_saved (GcpDocument* self) {
	g_return_if_fail (self != NULL);
	gcp_document_emit_changed (self);
}


const gchar* gcp_document_get_error_mark_category (void) {
	const gchar* result;
	result = "Gcp.Document.ErrorCategory";
	return result;
}


const gchar* gcp_document_get_warning_mark_category (void) {
	const gchar* result;
	result = "Gcp.Document.WarningCategory";
	return result;
}


const gchar* gcp_document_get_info_mark_category (void) {
	const gchar* result;
	result = "Gcp.Document.InfoCategory";
	return result;
}


gboolean gcp_document_get_tainted (GcpDocument* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GCP_DOCUMENT_GET_CLASS (self)->get_tainted (self);
}


static gboolean gcp_document_real_get_tainted (GcpDocument* base) {
	gboolean result;
	GcpDocument* self;
	gboolean _tmp0_;
	self = base;
	_tmp0_ = self->priv->d_tainted;
	result = _tmp0_;
	return result;
}


void gcp_document_set_tainted (GcpDocument* self, gboolean value) {
	g_return_if_fail (self != NULL);
	GCP_DOCUMENT_GET_CLASS (self)->set_tainted (self, value);
}


static void gcp_document_real_set_tainted (GcpDocument* base, gboolean value) {
	GcpDocument* self;
	self = base;
	self->priv->d_tainted = FALSE;
	g_object_notify ((GObject *) self, "tainted");
}


GFile* gcp_document_get_location (GcpDocument* self) {
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_location;
	result = _tmp0_;
	return result;
}


const gchar* gcp_document_get_text (GcpDocument* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_text;
	result = _tmp0_;
	return result;
}


gboolean gcp_document_get_is_modified (GcpDocument* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_modified;
	result = _tmp0_;
	return result;
}


GeditDocument* gcp_document_get_document (GcpDocument* self) {
	GeditDocument* result;
	GeditDocument* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_document;
	result = _tmp0_;
	return result;
}


static void gcp_document_class_init (GcpDocumentClass * klass) {
	gcp_document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpDocumentPrivate));
	GCP_DOCUMENT_CLASS (klass)->get_tainted = gcp_document_real_get_tainted;
	GCP_DOCUMENT_CLASS (klass)->set_tainted = gcp_document_real_set_tainted;
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gcp_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = gcp_document_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DOCUMENT_TAINTED, g_param_spec_boolean ("tainted", "tainted", "tainted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DOCUMENT_LOCATION, g_param_spec_object ("location", "location", "location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DOCUMENT_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DOCUMENT_IS_MODIFIED, g_param_spec_boolean ("is-modified", "is-modified", "is-modified", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DOCUMENT_DOCUMENT, g_param_spec_object ("document", "document", "document", gedit_document_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("location_changed", GCP_TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_FILE);
	g_signal_new ("changed", GCP_TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gcp_document_instance_init (GcpDocument * self) {
	self->priv = GCP_DOCUMENT_GET_PRIVATE (self);
}


static void gcp_document_finalize (GObject* obj) {
	GcpDocument * self;
	GeditDocument* _tmp0_;
	guint _tmp1_ = 0U;
	GeditDocument* _tmp2_;
	guint _tmp3_ = 0U;
	GQuark _tmp4_ = 0U;
	GeditDocument* _tmp5_;
	guint _tmp6_ = 0U;
	GeditDocument* _tmp7_;
	guint _tmp8_ = 0U;
	GcpDiagnosticSupport* _tmp9_;
	GcpDiagnosticSupport* diag;
	GcpDiagnosticSupport* _tmp10_;
	self = GCP_DOCUMENT (obj);
	_tmp0_ = self->priv->d_document;
	g_signal_parse_name ("modified-changed", GTK_TYPE_TEXT_BUFFER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gcp_document_on_document_modified_changed_gtk_text_buffer_modified_changed, self);
	_tmp2_ = self->priv->d_document;
	g_signal_parse_name ("notify::location", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _gcp_document_on_location_changed_g_object_notify, self);
	_tmp5_ = self->priv->d_document;
	g_signal_parse_name ("changed", GTK_TYPE_TEXT_BUFFER, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _gcp_document_on_document_changed_gtk_text_buffer_changed, self);
	_tmp7_ = self->priv->d_document;
	g_signal_parse_name ("saved", gedit_document_get_type (), &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _gcp_document_on_document_saved_gedit_document_saved, self);
	_tmp9_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (self) ? ((GcpDiagnosticSupport*) self) : NULL);
	diag = _tmp9_;
	_tmp10_ = diag;
	if (_tmp10_ != NULL) {
		GcpDiagnosticSupport* _tmp11_;
		guint _tmp12_ = 0U;
		_tmp11_ = diag;
		g_signal_parse_name ("diagnostics-updated", GCP_TYPE_DIAGNOSTIC_SUPPORT, &_tmp12_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _gcp_document_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated, self);
		gcp_document_remove_marks (self);
	}
	_g_object_unref0 (diag);
	_g_object_unref0 (self->priv->d_document);
	_g_free0 (self->priv->d_text);
	_g_object_unref0 (self->priv->d_location);
	G_OBJECT_CLASS (gcp_document_parent_class)->finalize (obj);
}


GType gcp_document_get_type (void) {
	return gcp_document_type_id;
}


GType gcp_document_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpDocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpDocument), 0, (GInstanceInitFunc) gcp_document_instance_init, NULL };
	gcp_document_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpDocument", &g_define_type_info, 0);
	return gcp_document_type_id;
}


static void _vala_gcp_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpDocument * self;
	self = GCP_DOCUMENT (object);
	switch (property_id) {
		case GCP_DOCUMENT_TAINTED:
		g_value_set_boolean (value, gcp_document_get_tainted (self));
		break;
		case GCP_DOCUMENT_LOCATION:
		g_value_set_object (value, gcp_document_get_location (self));
		break;
		case GCP_DOCUMENT_TEXT:
		g_value_set_string (value, gcp_document_get_text (self));
		break;
		case GCP_DOCUMENT_IS_MODIFIED:
		g_value_set_boolean (value, gcp_document_get_is_modified (self));
		break;
		case GCP_DOCUMENT_DOCUMENT:
		g_value_set_object (value, gcp_document_get_document (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gcp_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GcpDocument * self;
	self = GCP_DOCUMENT (object);
	switch (property_id) {
		case GCP_DOCUMENT_TAINTED:
		gcp_document_set_tainted (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



