/* GdkPixbuf library - standalone color parsing
 *
 * Copyright (C) 2001 Eazel, Inc.
 *
 * Authors: John Harper <jsh@eazel.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifndef PATH_RGB_TXT
# define PATH_RGB_TXT "/usr/lib/X11/rgb.txt"
#endif

#include "gdk-pixbuf.h"
#include "gdk-pixbuf-private.h"

#include <glib.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/* Used internally to avoid taking a GDK or Xlib dependency */
typedef struct {
	gushort red;
	gushort green;
	gushort blue;
} rgb_color;

/* Mapping from color name to rgb_color struct */
static GHashTable *named_colors;

/* In case we can't find rgb.txt, a local copy */
struct {
	char *name;
	rgb_color rgb;
} local_rgb_txt[] = {
	{ "alice blue", { 240 + (240 << 8), 248 + (248 << 8), 255 + (255 << 8) } },
	{ "aliceblue", { 240 + (240 << 8), 248 + (248 << 8), 255 + (255 << 8) } },
	{ "antique white", { 250 + (250 << 8), 235 + (235 << 8), 215 + (215 << 8) } },
	{ "antiquewhite", { 250 + (250 << 8), 235 + (235 << 8), 215 + (215 << 8) } },
	{ "antiquewhite1", { 255 + (255 << 8), 239 + (239 << 8), 219 + (219 << 8) } },
	{ "antiquewhite2", { 238 + (238 << 8), 223 + (223 << 8), 204 + (204 << 8) } },
	{ "antiquewhite3", { 205 + (205 << 8), 192 + (192 << 8), 176 + (176 << 8) } },
	{ "antiquewhite4", { 139 + (139 << 8), 131 + (131 << 8), 120 + (120 << 8) } },
	{ "aquamarine", { 127 + (127 << 8), 255 + (255 << 8), 212 + (212 << 8) } },
	{ "aquamarine1", { 127 + (127 << 8), 255 + (255 << 8), 212 + (212 << 8) } },
	{ "aquamarine2", { 118 + (118 << 8), 238 + (238 << 8), 198 + (198 << 8) } },
	{ "aquamarine3", { 102 + (102 << 8), 205 + (205 << 8), 170 + (170 << 8) } },
	{ "aquamarine4", { 69 + (69 << 8), 139 + (139 << 8), 116 + (116 << 8) } },
	{ "azure", { 240 + (240 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "azure1", { 240 + (240 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "azure2", { 224 + (224 << 8), 238 + (238 << 8), 238 + (238 << 8) } },
	{ "azure3", { 193 + (193 << 8), 205 + (205 << 8), 205 + (205 << 8) } },
	{ "azure4", { 131 + (131 << 8), 139 + (139 << 8), 139 + (139 << 8) } },
	{ "beige", { 245 + (245 << 8), 245 + (245 << 8), 220 + (220 << 8) } },
	{ "bisque", { 255 + (255 << 8), 228 + (228 << 8), 196 + (196 << 8) } },
	{ "bisque1", { 255 + (255 << 8), 228 + (228 << 8), 196 + (196 << 8) } },
	{ "bisque2", { 238 + (238 << 8), 213 + (213 << 8), 183 + (183 << 8) } },
	{ "bisque3", { 205 + (205 << 8), 183 + (183 << 8), 158 + (158 << 8) } },
	{ "bisque4", { 139 + (139 << 8), 125 + (125 << 8), 107 + (107 << 8) } },
	{ "black", { 0 + (0 << 8), 0 + (0 << 8), 0 + (0 << 8) } },
	{ "blanched almond", { 255 + (255 << 8), 235 + (235 << 8), 205 + (205 << 8) } },
	{ "blanchedalmond", { 255 + (255 << 8), 235 + (235 << 8), 205 + (205 << 8) } },
	{ "blue violet", { 138 + (138 << 8), 43 + (43 << 8), 226 + (226 << 8) } },
	{ "blue", { 0 + (0 << 8), 0 + (0 << 8), 255 + (255 << 8) } },
	{ "blue1", { 0 + (0 << 8), 0 + (0 << 8), 255 + (255 << 8) } },
	{ "blue2", { 0 + (0 << 8), 0 + (0 << 8), 238 + (238 << 8) } },
	{ "blue3", { 0 + (0 << 8), 0 + (0 << 8), 205 + (205 << 8) } },
	{ "blue4", { 0 + (0 << 8), 0 + (0 << 8), 139 + (139 << 8) } },
	{ "blueviolet", { 138 + (138 << 8), 43 + (43 << 8), 226 + (226 << 8) } },
	{ "brown", { 165 + (165 << 8), 42 + (42 << 8), 42 + (42 << 8) } },
	{ "brown1", { 255 + (255 << 8), 64 + (64 << 8), 64 + (64 << 8) } },
	{ "brown2", { 238 + (238 << 8), 59 + (59 << 8), 59 + (59 << 8) } },
	{ "brown3", { 205 + (205 << 8), 51 + (51 << 8), 51 + (51 << 8) } },
	{ "brown4", { 139 + (139 << 8), 35 + (35 << 8), 35 + (35 << 8) } },
	{ "burlywood", { 222 + (222 << 8), 184 + (184 << 8), 135 + (135 << 8) } },
	{ "burlywood1", { 255 + (255 << 8), 211 + (211 << 8), 155 + (155 << 8) } },
	{ "burlywood2", { 238 + (238 << 8), 197 + (197 << 8), 145 + (145 << 8) } },
	{ "burlywood3", { 205 + (205 << 8), 170 + (170 << 8), 125 + (125 << 8) } },
	{ "burlywood4", { 139 + (139 << 8), 115 + (115 << 8), 85 + (85 << 8) } },
	{ "cadet blue", { 95 + (95 << 8), 158 + (158 << 8), 160 + (160 << 8) } },
	{ "cadetblue", { 95 + (95 << 8), 158 + (158 << 8), 160 + (160 << 8) } },
	{ "cadetblue1", { 152 + (152 << 8), 245 + (245 << 8), 255 + (255 << 8) } },
	{ "cadetblue2", { 142 + (142 << 8), 229 + (229 << 8), 238 + (238 << 8) } },
	{ "cadetblue3", { 122 + (122 << 8), 197 + (197 << 8), 205 + (205 << 8) } },
	{ "cadetblue4", { 83 + (83 << 8), 134 + (134 << 8), 139 + (139 << 8) } },
	{ "chartreuse", { 127 + (127 << 8), 255 + (255 << 8), 0 + (0 << 8) } },
	{ "chartreuse1", { 127 + (127 << 8), 255 + (255 << 8), 0 + (0 << 8) } },
	{ "chartreuse2", { 118 + (118 << 8), 238 + (238 << 8), 0 + (0 << 8) } },
	{ "chartreuse3", { 102 + (102 << 8), 205 + (205 << 8), 0 + (0 << 8) } },
	{ "chartreuse4", { 69 + (69 << 8), 139 + (139 << 8), 0 + (0 << 8) } },
	{ "chocolate", { 210 + (210 << 8), 105 + (105 << 8), 30 + (30 << 8) } },
	{ "chocolate1", { 255 + (255 << 8), 127 + (127 << 8), 36 + (36 << 8) } },
	{ "chocolate2", { 238 + (238 << 8), 118 + (118 << 8), 33 + (33 << 8) } },
	{ "chocolate3", { 205 + (205 << 8), 102 + (102 << 8), 29 + (29 << 8) } },
	{ "chocolate4", { 139 + (139 << 8), 69 + (69 << 8), 19 + (19 << 8) } },
	{ "coral", { 255 + (255 << 8), 127 + (127 << 8), 80 + (80 << 8) } },
	{ "coral1", { 255 + (255 << 8), 114 + (114 << 8), 86 + (86 << 8) } },
	{ "coral2", { 238 + (238 << 8), 106 + (106 << 8), 80 + (80 << 8) } },
	{ "coral3", { 205 + (205 << 8), 91 + (91 << 8), 69 + (69 << 8) } },
	{ "coral4", { 139 + (139 << 8), 62 + (62 << 8), 47 + (47 << 8) } },
	{ "cornflower blue", { 100 + (100 << 8), 149 + (149 << 8), 237 + (237 << 8) } },
	{ "cornflowerblue", { 100 + (100 << 8), 149 + (149 << 8), 237 + (237 << 8) } },
	{ "cornsilk", { 255 + (255 << 8), 248 + (248 << 8), 220 + (220 << 8) } },
	{ "cornsilk1", { 255 + (255 << 8), 248 + (248 << 8), 220 + (220 << 8) } },
	{ "cornsilk2", { 238 + (238 << 8), 232 + (232 << 8), 205 + (205 << 8) } },
	{ "cornsilk3", { 205 + (205 << 8), 200 + (200 << 8), 177 + (177 << 8) } },
	{ "cornsilk4", { 139 + (139 << 8), 136 + (136 << 8), 120 + (120 << 8) } },
	{ "cyan", { 0 + (0 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "cyan1", { 0 + (0 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "cyan2", { 0 + (0 << 8), 238 + (238 << 8), 238 + (238 << 8) } },
	{ "cyan3", { 0 + (0 << 8), 205 + (205 << 8), 205 + (205 << 8) } },
	{ "cyan4", { 0 + (0 << 8), 139 + (139 << 8), 139 + (139 << 8) } },
	{ "dark blue", { 0 + (0 << 8), 0 + (0 << 8), 139 + (139 << 8) } },
	{ "dark cyan", { 0 + (0 << 8), 139 + (139 << 8), 139 + (139 << 8) } },
	{ "dark goldenrod", { 184 + (184 << 8), 134 + (134 << 8), 11 + (11 << 8) } },
	{ "dark gray", { 169 + (169 << 8), 169 + (169 << 8), 169 + (169 << 8) } },
	{ "dark green", { 0 + (0 << 8), 100 + (100 << 8), 0 + (0 << 8) } },
	{ "dark grey", { 169 + (169 << 8), 169 + (169 << 8), 169 + (169 << 8) } },
	{ "dark khaki", { 189 + (189 << 8), 183 + (183 << 8), 107 + (107 << 8) } },
	{ "dark magenta", { 139 + (139 << 8), 0 + (0 << 8), 139 + (139 << 8) } },
	{ "dark olive green", { 85 + (85 << 8), 107 + (107 << 8), 47 + (47 << 8) } },
	{ "dark orange", { 255 + (255 << 8), 140 + (140 << 8), 0 + (0 << 8) } },
	{ "dark orchid", { 153 + (153 << 8), 50 + (50 << 8), 204 + (204 << 8) } },
	{ "dark red", { 139 + (139 << 8), 0 + (0 << 8), 0 + (0 << 8) } },
	{ "dark salmon", { 233 + (233 << 8), 150 + (150 << 8), 122 + (122 << 8) } },
	{ "dark sea green", { 143 + (143 << 8), 188 + (188 << 8), 143 + (143 << 8) } },
	{ "dark slate blue", { 72 + (72 << 8), 61 + (61 << 8), 139 + (139 << 8) } },
	{ "dark slate gray", { 47 + (47 << 8), 79 + (79 << 8), 79 + (79 << 8) } },
	{ "dark slate grey", { 47 + (47 << 8), 79 + (79 << 8), 79 + (79 << 8) } },
	{ "dark turquoise", { 0 + (0 << 8), 206 + (206 << 8), 209 + (209 << 8) } },
	{ "dark violet", { 148 + (148 << 8), 0 + (0 << 8), 211 + (211 << 8) } },
	{ "darkblue", { 0 + (0 << 8), 0 + (0 << 8), 139 + (139 << 8) } },
	{ "darkcyan", { 0 + (0 << 8), 139 + (139 << 8), 139 + (139 << 8) } },
	{ "darkgoldenrod", { 184 + (184 << 8), 134 + (134 << 8), 11 + (11 << 8) } },
	{ "darkgoldenrod1", { 255 + (255 << 8), 185 + (185 << 8), 15 + (15 << 8) } },
	{ "darkgoldenrod2", { 238 + (238 << 8), 173 + (173 << 8), 14 + (14 << 8) } },
	{ "darkgoldenrod3", { 205 + (205 << 8), 149 + (149 << 8), 12 + (12 << 8) } },
	{ "darkgoldenrod4", { 139 + (139 << 8), 101 + (101 << 8), 8 + (8 << 8) } },
	{ "darkgray", { 169 + (169 << 8), 169 + (169 << 8), 169 + (169 << 8) } },
	{ "darkgreen", { 0 + (0 << 8), 100 + (100 << 8), 0 + (0 << 8) } },
	{ "darkgrey", { 169 + (169 << 8), 169 + (169 << 8), 169 + (169 << 8) } },
	{ "darkkhaki", { 189 + (189 << 8), 183 + (183 << 8), 107 + (107 << 8) } },
	{ "darkmagenta", { 139 + (139 << 8), 0 + (0 << 8), 139 + (139 << 8) } },
	{ "darkolivegreen", { 85 + (85 << 8), 107 + (107 << 8), 47 + (47 << 8) } },
	{ "darkolivegreen1", { 202 + (202 << 8), 255 + (255 << 8), 112 + (112 << 8) } },
	{ "darkolivegreen2", { 188 + (188 << 8), 238 + (238 << 8), 104 + (104 << 8) } },
	{ "darkolivegreen3", { 162 + (162 << 8), 205 + (205 << 8), 90 + (90 << 8) } },
	{ "darkolivegreen4", { 110 + (110 << 8), 139 + (139 << 8), 61 + (61 << 8) } },
	{ "darkorange", { 255 + (255 << 8), 140 + (140 << 8), 0 + (0 << 8) } },
	{ "darkorange1", { 255 + (255 << 8), 127 + (127 << 8), 0 + (0 << 8) } },
	{ "darkorange2", { 238 + (238 << 8), 118 + (118 << 8), 0 + (0 << 8) } },
	{ "darkorange3", { 205 + (205 << 8), 102 + (102 << 8), 0 + (0 << 8) } },
	{ "darkorange4", { 139 + (139 << 8), 69 + (69 << 8), 0 + (0 << 8) } },
	{ "darkorchid", { 153 + (153 << 8), 50 + (50 << 8), 204 + (204 << 8) } },
	{ "darkorchid1", { 191 + (191 << 8), 62 + (62 << 8), 255 + (255 << 8) } },
	{ "darkorchid2", { 178 + (178 << 8), 58 + (58 << 8), 238 + (238 << 8) } },
	{ "darkorchid3", { 154 + (154 << 8), 50 + (50 << 8), 205 + (205 << 8) } },
	{ "darkorchid4", { 104 + (104 << 8), 34 + (34 << 8), 139 + (139 << 8) } },
	{ "darkred", { 139 + (139 << 8), 0 + (0 << 8), 0 + (0 << 8) } },
	{ "darksalmon", { 233 + (233 << 8), 150 + (150 << 8), 122 + (122 << 8) } },
	{ "darkseagreen", { 143 + (143 << 8), 188 + (188 << 8), 143 + (143 << 8) } },
	{ "darkseagreen1", { 193 + (193 << 8), 255 + (255 << 8), 193 + (193 << 8) } },
	{ "darkseagreen2", { 180 + (180 << 8), 238 + (238 << 8), 180 + (180 << 8) } },
	{ "darkseagreen3", { 155 + (155 << 8), 205 + (205 << 8), 155 + (155 << 8) } },
	{ "darkseagreen4", { 105 + (105 << 8), 139 + (139 << 8), 105 + (105 << 8) } },
	{ "darkslateblue", { 72 + (72 << 8), 61 + (61 << 8), 139 + (139 << 8) } },
	{ "darkslategray", { 47 + (47 << 8), 79 + (79 << 8), 79 + (79 << 8) } },
	{ "darkslategray1", { 151 + (151 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "darkslategray2", { 141 + (141 << 8), 238 + (238 << 8), 238 + (238 << 8) } },
	{ "darkslategray3", { 121 + (121 << 8), 205 + (205 << 8), 205 + (205 << 8) } },
	{ "darkslategray4", { 82 + (82 << 8), 139 + (139 << 8), 139 + (139 << 8) } },
	{ "darkslategrey", { 47 + (47 << 8), 79 + (79 << 8), 79 + (79 << 8) } },
	{ "darkturquoise", { 0 + (0 << 8), 206 + (206 << 8), 209 + (209 << 8) } },
	{ "darkviolet", { 148 + (148 << 8), 0 + (0 << 8), 211 + (211 << 8) } },
	{ "deep pink", { 255 + (255 << 8), 20 + (20 << 8), 147 + (147 << 8) } },
	{ "deep sky blue", { 0 + (0 << 8), 191 + (191 << 8), 255 + (255 << 8) } },
	{ "deeppink", { 255 + (255 << 8), 20 + (20 << 8), 147 + (147 << 8) } },
	{ "deeppink1", { 255 + (255 << 8), 20 + (20 << 8), 147 + (147 << 8) } },
	{ "deeppink2", { 238 + (238 << 8), 18 + (18 << 8), 137 + (137 << 8) } },
	{ "deeppink3", { 205 + (205 << 8), 16 + (16 << 8), 118 + (118 << 8) } },
	{ "deeppink4", { 139 + (139 << 8), 10 + (10 << 8), 80 + (80 << 8) } },
	{ "deepskyblue", { 0 + (0 << 8), 191 + (191 << 8), 255 + (255 << 8) } },
	{ "deepskyblue1", { 0 + (0 << 8), 191 + (191 << 8), 255 + (255 << 8) } },
	{ "deepskyblue2", { 0 + (0 << 8), 178 + (178 << 8), 238 + (238 << 8) } },
	{ "deepskyblue3", { 0 + (0 << 8), 154 + (154 << 8), 205 + (205 << 8) } },
	{ "deepskyblue4", { 0 + (0 << 8), 104 + (104 << 8), 139 + (139 << 8) } },
	{ "dim gray", { 105 + (105 << 8), 105 + (105 << 8), 105 + (105 << 8) } },
	{ "dim grey", { 105 + (105 << 8), 105 + (105 << 8), 105 + (105 << 8) } },
	{ "dimgray", { 105 + (105 << 8), 105 + (105 << 8), 105 + (105 << 8) } },
	{ "dimgrey", { 105 + (105 << 8), 105 + (105 << 8), 105 + (105 << 8) } },
	{ "dodger blue", { 30 + (30 << 8), 144 + (144 << 8), 255 + (255 << 8) } },
	{ "dodgerblue", { 30 + (30 << 8), 144 + (144 << 8), 255 + (255 << 8) } },
	{ "dodgerblue1", { 30 + (30 << 8), 144 + (144 << 8), 255 + (255 << 8) } },
	{ "dodgerblue2", { 28 + (28 << 8), 134 + (134 << 8), 238 + (238 << 8) } },
	{ "dodgerblue3", { 24 + (24 << 8), 116 + (116 << 8), 205 + (205 << 8) } },
	{ "dodgerblue4", { 16 + (16 << 8), 78 + (78 << 8), 139 + (139 << 8) } },
	{ "firebrick", { 178 + (178 << 8), 34 + (34 << 8), 34 + (34 << 8) } },
	{ "firebrick1", { 255 + (255 << 8), 48 + (48 << 8), 48 + (48 << 8) } },
	{ "firebrick2", { 238 + (238 << 8), 44 + (44 << 8), 44 + (44 << 8) } },
	{ "firebrick3", { 205 + (205 << 8), 38 + (38 << 8), 38 + (38 << 8) } },
	{ "firebrick4", { 139 + (139 << 8), 26 + (26 << 8), 26 + (26 << 8) } },
	{ "floral white", { 255 + (255 << 8), 250 + (250 << 8), 240 + (240 << 8) } },
	{ "floralwhite", { 255 + (255 << 8), 250 + (250 << 8), 240 + (240 << 8) } },
	{ "forest green", { 34 + (34 << 8), 139 + (139 << 8), 34 + (34 << 8) } },
	{ "forestgreen", { 34 + (34 << 8), 139 + (139 << 8), 34 + (34 << 8) } },
	{ "gainsboro", { 220 + (220 << 8), 220 + (220 << 8), 220 + (220 << 8) } },
	{ "ghost white", { 248 + (248 << 8), 248 + (248 << 8), 255 + (255 << 8) } },
	{ "ghostwhite", { 248 + (248 << 8), 248 + (248 << 8), 255 + (255 << 8) } },
	{ "gold", { 255 + (255 << 8), 215 + (215 << 8), 0 + (0 << 8) } },
	{ "gold1", { 255 + (255 << 8), 215 + (215 << 8), 0 + (0 << 8) } },
	{ "gold2", { 238 + (238 << 8), 201 + (201 << 8), 0 + (0 << 8) } },
	{ "gold3", { 205 + (205 << 8), 173 + (173 << 8), 0 + (0 << 8) } },
	{ "gold4", { 139 + (139 << 8), 117 + (117 << 8), 0 + (0 << 8) } },
	{ "goldenrod", { 218 + (218 << 8), 165 + (165 << 8), 32 + (32 << 8) } },
	{ "goldenrod1", { 255 + (255 << 8), 193 + (193 << 8), 37 + (37 << 8) } },
	{ "goldenrod2", { 238 + (238 << 8), 180 + (180 << 8), 34 + (34 << 8) } },
	{ "goldenrod3", { 205 + (205 << 8), 155 + (155 << 8), 29 + (29 << 8) } },
	{ "goldenrod4", { 139 + (139 << 8), 105 + (105 << 8), 20 + (20 << 8) } },
	{ "gray", { 190 + (190 << 8), 190 + (190 << 8), 190 + (190 << 8) } },
	{ "gray0", { 0 + (0 << 8), 0 + (0 << 8), 0 + (0 << 8) } },
	{ "gray1", { 3 + (3 << 8), 3 + (3 << 8), 3 + (3 << 8) } },
	{ "gray10", { 26 + (26 << 8), 26 + (26 << 8), 26 + (26 << 8) } },
	{ "gray100", { 255 + (255 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "gray11", { 28 + (28 << 8), 28 + (28 << 8), 28 + (28 << 8) } },
	{ "gray12", { 31 + (31 << 8), 31 + (31 << 8), 31 + (31 << 8) } },
	{ "gray13", { 33 + (33 << 8), 33 + (33 << 8), 33 + (33 << 8) } },
	{ "gray14", { 36 + (36 << 8), 36 + (36 << 8), 36 + (36 << 8) } },
	{ "gray15", { 38 + (38 << 8), 38 + (38 << 8), 38 + (38 << 8) } },
	{ "gray16", { 41 + (41 << 8), 41 + (41 << 8), 41 + (41 << 8) } },
	{ "gray17", { 43 + (43 << 8), 43 + (43 << 8), 43 + (43 << 8) } },
	{ "gray18", { 46 + (46 << 8), 46 + (46 << 8), 46 + (46 << 8) } },
	{ "gray19", { 48 + (48 << 8), 48 + (48 << 8), 48 + (48 << 8) } },
	{ "gray2", { 5 + (5 << 8), 5 + (5 << 8), 5 + (5 << 8) } },
	{ "gray20", { 51 + (51 << 8), 51 + (51 << 8), 51 + (51 << 8) } },
	{ "gray21", { 54 + (54 << 8), 54 + (54 << 8), 54 + (54 << 8) } },
	{ "gray22", { 56 + (56 << 8), 56 + (56 << 8), 56 + (56 << 8) } },
	{ "gray23", { 59 + (59 << 8), 59 + (59 << 8), 59 + (59 << 8) } },
	{ "gray24", { 61 + (61 << 8), 61 + (61 << 8), 61 + (61 << 8) } },
	{ "gray25", { 64 + (64 << 8), 64 + (64 << 8), 64 + (64 << 8) } },
	{ "gray26", { 66 + (66 << 8), 66 + (66 << 8), 66 + (66 << 8) } },
	{ "gray27", { 69 + (69 << 8), 69 + (69 << 8), 69 + (69 << 8) } },
	{ "gray28", { 71 + (71 << 8), 71 + (71 << 8), 71 + (71 << 8) } },
	{ "gray29", { 74 + (74 << 8), 74 + (74 << 8), 74 + (74 << 8) } },
	{ "gray3", { 8 + (8 << 8), 8 + (8 << 8), 8 + (8 << 8) } },
	{ "gray30", { 77 + (77 << 8), 77 + (77 << 8), 77 + (77 << 8) } },
	{ "gray31", { 79 + (79 << 8), 79 + (79 << 8), 79 + (79 << 8) } },
	{ "gray32", { 82 + (82 << 8), 82 + (82 << 8), 82 + (82 << 8) } },
	{ "gray33", { 84 + (84 << 8), 84 + (84 << 8), 84 + (84 << 8) } },
	{ "gray34", { 87 + (87 << 8), 87 + (87 << 8), 87 + (87 << 8) } },
	{ "gray35", { 89 + (89 << 8), 89 + (89 << 8), 89 + (89 << 8) } },
	{ "gray36", { 92 + (92 << 8), 92 + (92 << 8), 92 + (92 << 8) } },
	{ "gray37", { 94 + (94 << 8), 94 + (94 << 8), 94 + (94 << 8) } },
	{ "gray38", { 97 + (97 << 8), 97 + (97 << 8), 97 + (97 << 8) } },
	{ "gray39", { 99 + (99 << 8), 99 + (99 << 8), 99 + (99 << 8) } },
	{ "gray4", { 10 + (10 << 8), 10 + (10 << 8), 10 + (10 << 8) } },
	{ "gray40", { 102 + (102 << 8), 102 + (102 << 8), 102 + (102 << 8) } },
	{ "gray41", { 105 + (105 << 8), 105 + (105 << 8), 105 + (105 << 8) } },
	{ "gray42", { 107 + (107 << 8), 107 + (107 << 8), 107 + (107 << 8) } },
	{ "gray43", { 110 + (110 << 8), 110 + (110 << 8), 110 + (110 << 8) } },
	{ "gray44", { 112 + (112 << 8), 112 + (112 << 8), 112 + (112 << 8) } },
	{ "gray45", { 115 + (115 << 8), 115 + (115 << 8), 115 + (115 << 8) } },
	{ "gray46", { 117 + (117 << 8), 117 + (117 << 8), 117 + (117 << 8) } },
	{ "gray47", { 120 + (120 << 8), 120 + (120 << 8), 120 + (120 << 8) } },
	{ "gray48", { 122 + (122 << 8), 122 + (122 << 8), 122 + (122 << 8) } },
	{ "gray49", { 125 + (125 << 8), 125 + (125 << 8), 125 + (125 << 8) } },
	{ "gray5", { 13 + (13 << 8), 13 + (13 << 8), 13 + (13 << 8) } },
	{ "gray50", { 127 + (127 << 8), 127 + (127 << 8), 127 + (127 << 8) } },
	{ "gray51", { 130 + (130 << 8), 130 + (130 << 8), 130 + (130 << 8) } },
	{ "gray52", { 133 + (133 << 8), 133 + (133 << 8), 133 + (133 << 8) } },
	{ "gray53", { 135 + (135 << 8), 135 + (135 << 8), 135 + (135 << 8) } },
	{ "gray54", { 138 + (138 << 8), 138 + (138 << 8), 138 + (138 << 8) } },
	{ "gray55", { 140 + (140 << 8), 140 + (140 << 8), 140 + (140 << 8) } },
	{ "gray56", { 143 + (143 << 8), 143 + (143 << 8), 143 + (143 << 8) } },
	{ "gray57", { 145 + (145 << 8), 145 + (145 << 8), 145 + (145 << 8) } },
	{ "gray58", { 148 + (148 << 8), 148 + (148 << 8), 148 + (148 << 8) } },
	{ "gray59", { 150 + (150 << 8), 150 + (150 << 8), 150 + (150 << 8) } },
	{ "gray6", { 15 + (15 << 8), 15 + (15 << 8), 15 + (15 << 8) } },
	{ "gray60", { 153 + (153 << 8), 153 + (153 << 8), 153 + (153 << 8) } },
	{ "gray61", { 156 + (156 << 8), 156 + (156 << 8), 156 + (156 << 8) } },
	{ "gray62", { 158 + (158 << 8), 158 + (158 << 8), 158 + (158 << 8) } },
	{ "gray63", { 161 + (161 << 8), 161 + (161 << 8), 161 + (161 << 8) } },
	{ "gray64", { 163 + (163 << 8), 163 + (163 << 8), 163 + (163 << 8) } },
	{ "gray65", { 166 + (166 << 8), 166 + (166 << 8), 166 + (166 << 8) } },
	{ "gray66", { 168 + (168 << 8), 168 + (168 << 8), 168 + (168 << 8) } },
	{ "gray67", { 171 + (171 << 8), 171 + (171 << 8), 171 + (171 << 8) } },
	{ "gray68", { 173 + (173 << 8), 173 + (173 << 8), 173 + (173 << 8) } },
	{ "gray69", { 176 + (176 << 8), 176 + (176 << 8), 176 + (176 << 8) } },
	{ "gray7", { 18 + (18 << 8), 18 + (18 << 8), 18 + (18 << 8) } },
	{ "gray70", { 179 + (179 << 8), 179 + (179 << 8), 179 + (179 << 8) } },
	{ "gray71", { 181 + (181 << 8), 181 + (181 << 8), 181 + (181 << 8) } },
	{ "gray72", { 184 + (184 << 8), 184 + (184 << 8), 184 + (184 << 8) } },
	{ "gray73", { 186 + (186 << 8), 186 + (186 << 8), 186 + (186 << 8) } },
	{ "gray74", { 189 + (189 << 8), 189 + (189 << 8), 189 + (189 << 8) } },
	{ "gray75", { 191 + (191 << 8), 191 + (191 << 8), 191 + (191 << 8) } },
	{ "gray76", { 194 + (194 << 8), 194 + (194 << 8), 194 + (194 << 8) } },
	{ "gray77", { 196 + (196 << 8), 196 + (196 << 8), 196 + (196 << 8) } },
	{ "gray78", { 199 + (199 << 8), 199 + (199 << 8), 199 + (199 << 8) } },
	{ "gray79", { 201 + (201 << 8), 201 + (201 << 8), 201 + (201 << 8) } },
	{ "gray8", { 20 + (20 << 8), 20 + (20 << 8), 20 + (20 << 8) } },
	{ "gray80", { 204 + (204 << 8), 204 + (204 << 8), 204 + (204 << 8) } },
	{ "gray81", { 207 + (207 << 8), 207 + (207 << 8), 207 + (207 << 8) } },
	{ "gray82", { 209 + (209 << 8), 209 + (209 << 8), 209 + (209 << 8) } },
	{ "gray83", { 212 + (212 << 8), 212 + (212 << 8), 212 + (212 << 8) } },
	{ "gray84", { 214 + (214 << 8), 214 + (214 << 8), 214 + (214 << 8) } },
	{ "gray85", { 217 + (217 << 8), 217 + (217 << 8), 217 + (217 << 8) } },
	{ "gray86", { 219 + (219 << 8), 219 + (219 << 8), 219 + (219 << 8) } },
	{ "gray87", { 222 + (222 << 8), 222 + (222 << 8), 222 + (222 << 8) } },
	{ "gray88", { 224 + (224 << 8), 224 + (224 << 8), 224 + (224 << 8) } },
	{ "gray89", { 227 + (227 << 8), 227 + (227 << 8), 227 + (227 << 8) } },
	{ "gray9", { 23 + (23 << 8), 23 + (23 << 8), 23 + (23 << 8) } },
	{ "gray90", { 229 + (229 << 8), 229 + (229 << 8), 229 + (229 << 8) } },
	{ "gray91", { 232 + (232 << 8), 232 + (232 << 8), 232 + (232 << 8) } },
	{ "gray92", { 235 + (235 << 8), 235 + (235 << 8), 235 + (235 << 8) } },
	{ "gray93", { 237 + (237 << 8), 237 + (237 << 8), 237 + (237 << 8) } },
	{ "gray94", { 240 + (240 << 8), 240 + (240 << 8), 240 + (240 << 8) } },
	{ "gray95", { 242 + (242 << 8), 242 + (242 << 8), 242 + (242 << 8) } },
	{ "gray96", { 245 + (245 << 8), 245 + (245 << 8), 245 + (245 << 8) } },
	{ "gray97", { 247 + (247 << 8), 247 + (247 << 8), 247 + (247 << 8) } },
	{ "gray98", { 250 + (250 << 8), 250 + (250 << 8), 250 + (250 << 8) } },
	{ "gray99", { 252 + (252 << 8), 252 + (252 << 8), 252 + (252 << 8) } },
	{ "green yellow", { 173 + (173 << 8), 255 + (255 << 8), 47 + (47 << 8) } },
	{ "green", { 0 + (0 << 8), 255 + (255 << 8), 0 + (0 << 8) } },
	{ "green1", { 0 + (0 << 8), 255 + (255 << 8), 0 + (0 << 8) } },
	{ "green2", { 0 + (0 << 8), 238 + (238 << 8), 0 + (0 << 8) } },
	{ "green3", { 0 + (0 << 8), 205 + (205 << 8), 0 + (0 << 8) } },
	{ "green4", { 0 + (0 << 8), 139 + (139 << 8), 0 + (0 << 8) } },
	{ "greenyellow", { 173 + (173 << 8), 255 + (255 << 8), 47 + (47 << 8) } },
	{ "grey", { 190 + (190 << 8), 190 + (190 << 8), 190 + (190 << 8) } },
	{ "grey0", { 0 + (0 << 8), 0 + (0 << 8), 0 + (0 << 8) } },
	{ "grey1", { 3 + (3 << 8), 3 + (3 << 8), 3 + (3 << 8) } },
	{ "grey10", { 26 + (26 << 8), 26 + (26 << 8), 26 + (26 << 8) } },
	{ "grey100", { 255 + (255 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "grey11", { 28 + (28 << 8), 28 + (28 << 8), 28 + (28 << 8) } },
	{ "grey12", { 31 + (31 << 8), 31 + (31 << 8), 31 + (31 << 8) } },
	{ "grey13", { 33 + (33 << 8), 33 + (33 << 8), 33 + (33 << 8) } },
	{ "grey14", { 36 + (36 << 8), 36 + (36 << 8), 36 + (36 << 8) } },
	{ "grey15", { 38 + (38 << 8), 38 + (38 << 8), 38 + (38 << 8) } },
	{ "grey16", { 41 + (41 << 8), 41 + (41 << 8), 41 + (41 << 8) } },
	{ "grey17", { 43 + (43 << 8), 43 + (43 << 8), 43 + (43 << 8) } },
	{ "grey18", { 46 + (46 << 8), 46 + (46 << 8), 46 + (46 << 8) } },
	{ "grey19", { 48 + (48 << 8), 48 + (48 << 8), 48 + (48 << 8) } },
	{ "grey2", { 5 + (5 << 8), 5 + (5 << 8), 5 + (5 << 8) } },
	{ "grey20", { 51 + (51 << 8), 51 + (51 << 8), 51 + (51 << 8) } },
	{ "grey21", { 54 + (54 << 8), 54 + (54 << 8), 54 + (54 << 8) } },
	{ "grey22", { 56 + (56 << 8), 56 + (56 << 8), 56 + (56 << 8) } },
	{ "grey23", { 59 + (59 << 8), 59 + (59 << 8), 59 + (59 << 8) } },
	{ "grey24", { 61 + (61 << 8), 61 + (61 << 8), 61 + (61 << 8) } },
	{ "grey25", { 64 + (64 << 8), 64 + (64 << 8), 64 + (64 << 8) } },
	{ "grey26", { 66 + (66 << 8), 66 + (66 << 8), 66 + (66 << 8) } },
	{ "grey27", { 69 + (69 << 8), 69 + (69 << 8), 69 + (69 << 8) } },
	{ "grey28", { 71 + (71 << 8), 71 + (71 << 8), 71 + (71 << 8) } },
	{ "grey29", { 74 + (74 << 8), 74 + (74 << 8), 74 + (74 << 8) } },
	{ "grey3", { 8 + (8 << 8), 8 + (8 << 8), 8 + (8 << 8) } },
	{ "grey30", { 77 + (77 << 8), 77 + (77 << 8), 77 + (77 << 8) } },
	{ "grey31", { 79 + (79 << 8), 79 + (79 << 8), 79 + (79 << 8) } },
	{ "grey32", { 82 + (82 << 8), 82 + (82 << 8), 82 + (82 << 8) } },
	{ "grey33", { 84 + (84 << 8), 84 + (84 << 8), 84 + (84 << 8) } },
	{ "grey34", { 87 + (87 << 8), 87 + (87 << 8), 87 + (87 << 8) } },
	{ "grey35", { 89 + (89 << 8), 89 + (89 << 8), 89 + (89 << 8) } },
	{ "grey36", { 92 + (92 << 8), 92 + (92 << 8), 92 + (92 << 8) } },
	{ "grey37", { 94 + (94 << 8), 94 + (94 << 8), 94 + (94 << 8) } },
	{ "grey38", { 97 + (97 << 8), 97 + (97 << 8), 97 + (97 << 8) } },
	{ "grey39", { 99 + (99 << 8), 99 + (99 << 8), 99 + (99 << 8) } },
	{ "grey4", { 10 + (10 << 8), 10 + (10 << 8), 10 + (10 << 8) } },
	{ "grey40", { 102 + (102 << 8), 102 + (102 << 8), 102 + (102 << 8) } },
	{ "grey41", { 105 + (105 << 8), 105 + (105 << 8), 105 + (105 << 8) } },
	{ "grey42", { 107 + (107 << 8), 107 + (107 << 8), 107 + (107 << 8) } },
	{ "grey43", { 110 + (110 << 8), 110 + (110 << 8), 110 + (110 << 8) } },
	{ "grey44", { 112 + (112 << 8), 112 + (112 << 8), 112 + (112 << 8) } },
	{ "grey45", { 115 + (115 << 8), 115 + (115 << 8), 115 + (115 << 8) } },
	{ "grey46", { 117 + (117 << 8), 117 + (117 << 8), 117 + (117 << 8) } },
	{ "grey47", { 120 + (120 << 8), 120 + (120 << 8), 120 + (120 << 8) } },
	{ "grey48", { 122 + (122 << 8), 122 + (122 << 8), 122 + (122 << 8) } },
	{ "grey49", { 125 + (125 << 8), 125 + (125 << 8), 125 + (125 << 8) } },
	{ "grey5", { 13 + (13 << 8), 13 + (13 << 8), 13 + (13 << 8) } },
	{ "grey50", { 127 + (127 << 8), 127 + (127 << 8), 127 + (127 << 8) } },
	{ "grey51", { 130 + (130 << 8), 130 + (130 << 8), 130 + (130 << 8) } },
	{ "grey52", { 133 + (133 << 8), 133 + (133 << 8), 133 + (133 << 8) } },
	{ "grey53", { 135 + (135 << 8), 135 + (135 << 8), 135 + (135 << 8) } },
	{ "grey54", { 138 + (138 << 8), 138 + (138 << 8), 138 + (138 << 8) } },
	{ "grey55", { 140 + (140 << 8), 140 + (140 << 8), 140 + (140 << 8) } },
	{ "grey56", { 143 + (143 << 8), 143 + (143 << 8), 143 + (143 << 8) } },
	{ "grey57", { 145 + (145 << 8), 145 + (145 << 8), 145 + (145 << 8) } },
	{ "grey58", { 148 + (148 << 8), 148 + (148 << 8), 148 + (148 << 8) } },
	{ "grey59", { 150 + (150 << 8), 150 + (150 << 8), 150 + (150 << 8) } },
	{ "grey6", { 15 + (15 << 8), 15 + (15 << 8), 15 + (15 << 8) } },
	{ "grey60", { 153 + (153 << 8), 153 + (153 << 8), 153 + (153 << 8) } },
	{ "grey61", { 156 + (156 << 8), 156 + (156 << 8), 156 + (156 << 8) } },
	{ "grey62", { 158 + (158 << 8), 158 + (158 << 8), 158 + (158 << 8) } },
	{ "grey63", { 161 + (161 << 8), 161 + (161 << 8), 161 + (161 << 8) } },
	{ "grey64", { 163 + (163 << 8), 163 + (163 << 8), 163 + (163 << 8) } },
	{ "grey65", { 166 + (166 << 8), 166 + (166 << 8), 166 + (166 << 8) } },
	{ "grey66", { 168 + (168 << 8), 168 + (168 << 8), 168 + (168 << 8) } },
	{ "grey67", { 171 + (171 << 8), 171 + (171 << 8), 171 + (171 << 8) } },
	{ "grey68", { 173 + (173 << 8), 173 + (173 << 8), 173 + (173 << 8) } },
	{ "grey69", { 176 + (176 << 8), 176 + (176 << 8), 176 + (176 << 8) } },
	{ "grey7", { 18 + (18 << 8), 18 + (18 << 8), 18 + (18 << 8) } },
	{ "grey70", { 179 + (179 << 8), 179 + (179 << 8), 179 + (179 << 8) } },
	{ "grey71", { 181 + (181 << 8), 181 + (181 << 8), 181 + (181 << 8) } },
	{ "grey72", { 184 + (184 << 8), 184 + (184 << 8), 184 + (184 << 8) } },
	{ "grey73", { 186 + (186 << 8), 186 + (186 << 8), 186 + (186 << 8) } },
	{ "grey74", { 189 + (189 << 8), 189 + (189 << 8), 189 + (189 << 8) } },
	{ "grey75", { 191 + (191 << 8), 191 + (191 << 8), 191 + (191 << 8) } },
	{ "grey76", { 194 + (194 << 8), 194 + (194 << 8), 194 + (194 << 8) } },
	{ "grey77", { 196 + (196 << 8), 196 + (196 << 8), 196 + (196 << 8) } },
	{ "grey78", { 199 + (199 << 8), 199 + (199 << 8), 199 + (199 << 8) } },
	{ "grey79", { 201 + (201 << 8), 201 + (201 << 8), 201 + (201 << 8) } },
	{ "grey8", { 20 + (20 << 8), 20 + (20 << 8), 20 + (20 << 8) } },
	{ "grey80", { 204 + (204 << 8), 204 + (204 << 8), 204 + (204 << 8) } },
	{ "grey81", { 207 + (207 << 8), 207 + (207 << 8), 207 + (207 << 8) } },
	{ "grey82", { 209 + (209 << 8), 209 + (209 << 8), 209 + (209 << 8) } },
	{ "grey83", { 212 + (212 << 8), 212 + (212 << 8), 212 + (212 << 8) } },
	{ "grey84", { 214 + (214 << 8), 214 + (214 << 8), 214 + (214 << 8) } },
	{ "grey85", { 217 + (217 << 8), 217 + (217 << 8), 217 + (217 << 8) } },
	{ "grey86", { 219 + (219 << 8), 219 + (219 << 8), 219 + (219 << 8) } },
	{ "grey87", { 222 + (222 << 8), 222 + (222 << 8), 222 + (222 << 8) } },
	{ "grey88", { 224 + (224 << 8), 224 + (224 << 8), 224 + (224 << 8) } },
	{ "grey89", { 227 + (227 << 8), 227 + (227 << 8), 227 + (227 << 8) } },
	{ "grey9", { 23 + (23 << 8), 23 + (23 << 8), 23 + (23 << 8) } },
	{ "grey90", { 229 + (229 << 8), 229 + (229 << 8), 229 + (229 << 8) } },
	{ "grey91", { 232 + (232 << 8), 232 + (232 << 8), 232 + (232 << 8) } },
	{ "grey92", { 235 + (235 << 8), 235 + (235 << 8), 235 + (235 << 8) } },
	{ "grey93", { 237 + (237 << 8), 237 + (237 << 8), 237 + (237 << 8) } },
	{ "grey94", { 240 + (240 << 8), 240 + (240 << 8), 240 + (240 << 8) } },
	{ "grey95", { 242 + (242 << 8), 242 + (242 << 8), 242 + (242 << 8) } },
	{ "grey96", { 245 + (245 << 8), 245 + (245 << 8), 245 + (245 << 8) } },
	{ "grey97", { 247 + (247 << 8), 247 + (247 << 8), 247 + (247 << 8) } },
	{ "grey98", { 250 + (250 << 8), 250 + (250 << 8), 250 + (250 << 8) } },
	{ "grey99", { 252 + (252 << 8), 252 + (252 << 8), 252 + (252 << 8) } },
	{ "honeydew", { 240 + (240 << 8), 255 + (255 << 8), 240 + (240 << 8) } },
	{ "honeydew1", { 240 + (240 << 8), 255 + (255 << 8), 240 + (240 << 8) } },
	{ "honeydew2", { 224 + (224 << 8), 238 + (238 << 8), 224 + (224 << 8) } },
	{ "honeydew3", { 193 + (193 << 8), 205 + (205 << 8), 193 + (193 << 8) } },
	{ "honeydew4", { 131 + (131 << 8), 139 + (139 << 8), 131 + (131 << 8) } },
	{ "hot pink", { 255 + (255 << 8), 105 + (105 << 8), 180 + (180 << 8) } },
	{ "hotpink", { 255 + (255 << 8), 105 + (105 << 8), 180 + (180 << 8) } },
	{ "hotpink1", { 255 + (255 << 8), 110 + (110 << 8), 180 + (180 << 8) } },
	{ "hotpink2", { 238 + (238 << 8), 106 + (106 << 8), 167 + (167 << 8) } },
	{ "hotpink3", { 205 + (205 << 8), 96 + (96 << 8), 144 + (144 << 8) } },
	{ "hotpink4", { 139 + (139 << 8), 58 + (58 << 8), 98 + (98 << 8) } },
	{ "indian red", { 205 + (205 << 8), 92 + (92 << 8), 92 + (92 << 8) } },
	{ "indianred", { 205 + (205 << 8), 92 + (92 << 8), 92 + (92 << 8) } },
	{ "indianred1", { 255 + (255 << 8), 106 + (106 << 8), 106 + (106 << 8) } },
	{ "indianred2", { 238 + (238 << 8), 99 + (99 << 8), 99 + (99 << 8) } },
	{ "indianred3", { 205 + (205 << 8), 85 + (85 << 8), 85 + (85 << 8) } },
	{ "indianred4", { 139 + (139 << 8), 58 + (58 << 8), 58 + (58 << 8) } },
	{ "ivory", { 255 + (255 << 8), 255 + (255 << 8), 240 + (240 << 8) } },
	{ "ivory1", { 255 + (255 << 8), 255 + (255 << 8), 240 + (240 << 8) } },
	{ "ivory2", { 238 + (238 << 8), 238 + (238 << 8), 224 + (224 << 8) } },
	{ "ivory3", { 205 + (205 << 8), 205 + (205 << 8), 193 + (193 << 8) } },
	{ "ivory4", { 139 + (139 << 8), 139 + (139 << 8), 131 + (131 << 8) } },
	{ "khaki", { 240 + (240 << 8), 230 + (230 << 8), 140 + (140 << 8) } },
	{ "khaki1", { 255 + (255 << 8), 246 + (246 << 8), 143 + (143 << 8) } },
	{ "khaki2", { 238 + (238 << 8), 230 + (230 << 8), 133 + (133 << 8) } },
	{ "khaki3", { 205 + (205 << 8), 198 + (198 << 8), 115 + (115 << 8) } },
	{ "khaki4", { 139 + (139 << 8), 134 + (134 << 8), 78 + (78 << 8) } },
	{ "lavender blush", { 255 + (255 << 8), 240 + (240 << 8), 245 + (245 << 8) } },
	{ "lavender", { 230 + (230 << 8), 230 + (230 << 8), 250 + (250 << 8) } },
	{ "lavenderblush", { 255 + (255 << 8), 240 + (240 << 8), 245 + (245 << 8) } },
	{ "lavenderblush1", { 255 + (255 << 8), 240 + (240 << 8), 245 + (245 << 8) } },
	{ "lavenderblush2", { 238 + (238 << 8), 224 + (224 << 8), 229 + (229 << 8) } },
	{ "lavenderblush3", { 205 + (205 << 8), 193 + (193 << 8), 197 + (197 << 8) } },
	{ "lavenderblush4", { 139 + (139 << 8), 131 + (131 << 8), 134 + (134 << 8) } },
	{ "lawn green", { 124 + (124 << 8), 252 + (252 << 8), 0 + (0 << 8) } },
	{ "lawngreen", { 124 + (124 << 8), 252 + (252 << 8), 0 + (0 << 8) } },
	{ "lemon chiffon", { 255 + (255 << 8), 250 + (250 << 8), 205 + (205 << 8) } },
	{ "lemonchiffon", { 255 + (255 << 8), 250 + (250 << 8), 205 + (205 << 8) } },
	{ "lemonchiffon1", { 255 + (255 << 8), 250 + (250 << 8), 205 + (205 << 8) } },
	{ "lemonchiffon2", { 238 + (238 << 8), 233 + (233 << 8), 191 + (191 << 8) } },
	{ "lemonchiffon3", { 205 + (205 << 8), 201 + (201 << 8), 165 + (165 << 8) } },
	{ "lemonchiffon4", { 139 + (139 << 8), 137 + (137 << 8), 112 + (112 << 8) } },
	{ "light blue", { 173 + (173 << 8), 216 + (216 << 8), 230 + (230 << 8) } },
	{ "light coral", { 240 + (240 << 8), 128 + (128 << 8), 128 + (128 << 8) } },
	{ "light cyan", { 224 + (224 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "light goldenrod yellow", { 250 + (250 << 8), 250 + (250 << 8), 210 + (210 << 8) } },
	{ "light goldenrod", { 238 + (238 << 8), 221 + (221 << 8), 130 + (130 << 8) } },
	{ "light gray", { 211 + (211 << 8), 211 + (211 << 8), 211 + (211 << 8) } },
	{ "light green", { 144 + (144 << 8), 238 + (238 << 8), 144 + (144 << 8) } },
	{ "light grey", { 211 + (211 << 8), 211 + (211 << 8), 211 + (211 << 8) } },
	{ "light pink", { 255 + (255 << 8), 182 + (182 << 8), 193 + (193 << 8) } },
	{ "light salmon", { 255 + (255 << 8), 160 + (160 << 8), 122 + (122 << 8) } },
	{ "light sea green", { 32 + (32 << 8), 178 + (178 << 8), 170 + (170 << 8) } },
	{ "light sky blue", { 135 + (135 << 8), 206 + (206 << 8), 250 + (250 << 8) } },
	{ "light slate blue", { 132 + (132 << 8), 112 + (112 << 8), 255 + (255 << 8) } },
	{ "light slate gray", { 119 + (119 << 8), 136 + (136 << 8), 153 + (153 << 8) } },
	{ "light slate grey", { 119 + (119 << 8), 136 + (136 << 8), 153 + (153 << 8) } },
	{ "light steel blue", { 176 + (176 << 8), 196 + (196 << 8), 222 + (222 << 8) } },
	{ "light yellow", { 255 + (255 << 8), 255 + (255 << 8), 224 + (224 << 8) } },
	{ "lightblue", { 173 + (173 << 8), 216 + (216 << 8), 230 + (230 << 8) } },
	{ "lightblue1", { 191 + (191 << 8), 239 + (239 << 8), 255 + (255 << 8) } },
	{ "lightblue2", { 178 + (178 << 8), 223 + (223 << 8), 238 + (238 << 8) } },
	{ "lightblue3", { 154 + (154 << 8), 192 + (192 << 8), 205 + (205 << 8) } },
	{ "lightblue4", { 104 + (104 << 8), 131 + (131 << 8), 139 + (139 << 8) } },
	{ "lightcoral", { 240 + (240 << 8), 128 + (128 << 8), 128 + (128 << 8) } },
	{ "lightcyan", { 224 + (224 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "lightcyan1", { 224 + (224 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "lightcyan2", { 209 + (209 << 8), 238 + (238 << 8), 238 + (238 << 8) } },
	{ "lightcyan3", { 180 + (180 << 8), 205 + (205 << 8), 205 + (205 << 8) } },
	{ "lightcyan4", { 122 + (122 << 8), 139 + (139 << 8), 139 + (139 << 8) } },
	{ "lightgoldenrod", { 238 + (238 << 8), 221 + (221 << 8), 130 + (130 << 8) } },
	{ "lightgoldenrod1", { 255 + (255 << 8), 236 + (236 << 8), 139 + (139 << 8) } },
	{ "lightgoldenrod2", { 238 + (238 << 8), 220 + (220 << 8), 130 + (130 << 8) } },
	{ "lightgoldenrod3", { 205 + (205 << 8), 190 + (190 << 8), 112 + (112 << 8) } },
	{ "lightgoldenrod4", { 139 + (139 << 8), 129 + (129 << 8), 76 + (76 << 8) } },
	{ "lightgoldenrodyellow", { 250 + (250 << 8), 250 + (250 << 8), 210 + (210 << 8) } },
	{ "lightgray", { 211 + (211 << 8), 211 + (211 << 8), 211 + (211 << 8) } },
	{ "lightgreen", { 144 + (144 << 8), 238 + (238 << 8), 144 + (144 << 8) } },
	{ "lightgrey", { 211 + (211 << 8), 211 + (211 << 8), 211 + (211 << 8) } },
	{ "lightpink", { 255 + (255 << 8), 182 + (182 << 8), 193 + (193 << 8) } },
	{ "lightpink1", { 255 + (255 << 8), 174 + (174 << 8), 185 + (185 << 8) } },
	{ "lightpink2", { 238 + (238 << 8), 162 + (162 << 8), 173 + (173 << 8) } },
	{ "lightpink3", { 205 + (205 << 8), 140 + (140 << 8), 149 + (149 << 8) } },
	{ "lightpink4", { 139 + (139 << 8), 95 + (95 << 8), 101 + (101 << 8) } },
	{ "lightsalmon", { 255 + (255 << 8), 160 + (160 << 8), 122 + (122 << 8) } },
	{ "lightsalmon1", { 255 + (255 << 8), 160 + (160 << 8), 122 + (122 << 8) } },
	{ "lightsalmon2", { 238 + (238 << 8), 149 + (149 << 8), 114 + (114 << 8) } },
	{ "lightsalmon3", { 205 + (205 << 8), 129 + (129 << 8), 98 + (98 << 8) } },
	{ "lightsalmon4", { 139 + (139 << 8), 87 + (87 << 8), 66 + (66 << 8) } },
	{ "lightseagreen", { 32 + (32 << 8), 178 + (178 << 8), 170 + (170 << 8) } },
	{ "lightskyblue", { 135 + (135 << 8), 206 + (206 << 8), 250 + (250 << 8) } },
	{ "lightskyblue1", { 176 + (176 << 8), 226 + (226 << 8), 255 + (255 << 8) } },
	{ "lightskyblue2", { 164 + (164 << 8), 211 + (211 << 8), 238 + (238 << 8) } },
	{ "lightskyblue3", { 141 + (141 << 8), 182 + (182 << 8), 205 + (205 << 8) } },
	{ "lightskyblue4", { 96 + (96 << 8), 123 + (123 << 8), 139 + (139 << 8) } },
	{ "lightslateblue", { 132 + (132 << 8), 112 + (112 << 8), 255 + (255 << 8) } },
	{ "lightslategray", { 119 + (119 << 8), 136 + (136 << 8), 153 + (153 << 8) } },
	{ "lightslategrey", { 119 + (119 << 8), 136 + (136 << 8), 153 + (153 << 8) } },
	{ "lightsteelblue", { 176 + (176 << 8), 196 + (196 << 8), 222 + (222 << 8) } },
	{ "lightsteelblue1", { 202 + (202 << 8), 225 + (225 << 8), 255 + (255 << 8) } },
	{ "lightsteelblue2", { 188 + (188 << 8), 210 + (210 << 8), 238 + (238 << 8) } },
	{ "lightsteelblue3", { 162 + (162 << 8), 181 + (181 << 8), 205 + (205 << 8) } },
	{ "lightsteelblue4", { 110 + (110 << 8), 123 + (123 << 8), 139 + (139 << 8) } },
	{ "lightyellow", { 255 + (255 << 8), 255 + (255 << 8), 224 + (224 << 8) } },
	{ "lightyellow1", { 255 + (255 << 8), 255 + (255 << 8), 224 + (224 << 8) } },
	{ "lightyellow2", { 238 + (238 << 8), 238 + (238 << 8), 209 + (209 << 8) } },
	{ "lightyellow3", { 205 + (205 << 8), 205 + (205 << 8), 180 + (180 << 8) } },
	{ "lightyellow4", { 139 + (139 << 8), 139 + (139 << 8), 122 + (122 << 8) } },
	{ "lime green", { 50 + (50 << 8), 205 + (205 << 8), 50 + (50 << 8) } },
	{ "limegreen", { 50 + (50 << 8), 205 + (205 << 8), 50 + (50 << 8) } },
	{ "linen", { 250 + (250 << 8), 240 + (240 << 8), 230 + (230 << 8) } },
	{ "magenta", { 255 + (255 << 8), 0 + (0 << 8), 255 + (255 << 8) } },
	{ "magenta1", { 255 + (255 << 8), 0 + (0 << 8), 255 + (255 << 8) } },
	{ "magenta2", { 238 + (238 << 8), 0 + (0 << 8), 238 + (238 << 8) } },
	{ "magenta3", { 205 + (205 << 8), 0 + (0 << 8), 205 + (205 << 8) } },
	{ "magenta4", { 139 + (139 << 8), 0 + (0 << 8), 139 + (139 << 8) } },
	{ "maroon", { 176 + (176 << 8), 48 + (48 << 8), 96 + (96 << 8) } },
	{ "maroon1", { 255 + (255 << 8), 52 + (52 << 8), 179 + (179 << 8) } },
	{ "maroon2", { 238 + (238 << 8), 48 + (48 << 8), 167 + (167 << 8) } },
	{ "maroon3", { 205 + (205 << 8), 41 + (41 << 8), 144 + (144 << 8) } },
	{ "maroon4", { 139 + (139 << 8), 28 + (28 << 8), 98 + (98 << 8) } },
	{ "medium aquamarine", { 102 + (102 << 8), 205 + (205 << 8), 170 + (170 << 8) } },
	{ "medium blue", { 0 + (0 << 8), 0 + (0 << 8), 205 + (205 << 8) } },
	{ "medium orchid", { 186 + (186 << 8), 85 + (85 << 8), 211 + (211 << 8) } },
	{ "medium purple", { 147 + (147 << 8), 112 + (112 << 8), 219 + (219 << 8) } },
	{ "medium sea green", { 60 + (60 << 8), 179 + (179 << 8), 113 + (113 << 8) } },
	{ "medium slate blue", { 123 + (123 << 8), 104 + (104 << 8), 238 + (238 << 8) } },
	{ "medium spring green", { 0 + (0 << 8), 250 + (250 << 8), 154 + (154 << 8) } },
	{ "medium turquoise", { 72 + (72 << 8), 209 + (209 << 8), 204 + (204 << 8) } },
	{ "medium violet red", { 199 + (199 << 8), 21 + (21 << 8), 133 + (133 << 8) } },
	{ "mediumaquamarine", { 102 + (102 << 8), 205 + (205 << 8), 170 + (170 << 8) } },
	{ "mediumblue", { 0 + (0 << 8), 0 + (0 << 8), 205 + (205 << 8) } },
	{ "mediumorchid", { 186 + (186 << 8), 85 + (85 << 8), 211 + (211 << 8) } },
	{ "mediumorchid1", { 224 + (224 << 8), 102 + (102 << 8), 255 + (255 << 8) } },
	{ "mediumorchid2", { 209 + (209 << 8), 95 + (95 << 8), 238 + (238 << 8) } },
	{ "mediumorchid3", { 180 + (180 << 8), 82 + (82 << 8), 205 + (205 << 8) } },
	{ "mediumorchid4", { 122 + (122 << 8), 55 + (55 << 8), 139 + (139 << 8) } },
	{ "mediumpurple", { 147 + (147 << 8), 112 + (112 << 8), 219 + (219 << 8) } },
	{ "mediumpurple1", { 171 + (171 << 8), 130 + (130 << 8), 255 + (255 << 8) } },
	{ "mediumpurple2", { 159 + (159 << 8), 121 + (121 << 8), 238 + (238 << 8) } },
	{ "mediumpurple3", { 137 + (137 << 8), 104 + (104 << 8), 205 + (205 << 8) } },
	{ "mediumpurple4", { 93 + (93 << 8), 71 + (71 << 8), 139 + (139 << 8) } },
	{ "mediumseagreen", { 60 + (60 << 8), 179 + (179 << 8), 113 + (113 << 8) } },
	{ "mediumslateblue", { 123 + (123 << 8), 104 + (104 << 8), 238 + (238 << 8) } },
	{ "mediumspringgreen", { 0 + (0 << 8), 250 + (250 << 8), 154 + (154 << 8) } },
	{ "mediumturquoise", { 72 + (72 << 8), 209 + (209 << 8), 204 + (204 << 8) } },
	{ "mediumvioletred", { 199 + (199 << 8), 21 + (21 << 8), 133 + (133 << 8) } },
	{ "midnight blue", { 25 + (25 << 8), 25 + (25 << 8), 112 + (112 << 8) } },
	{ "midnightblue", { 25 + (25 << 8), 25 + (25 << 8), 112 + (112 << 8) } },
	{ "mint cream", { 245 + (245 << 8), 255 + (255 << 8), 250 + (250 << 8) } },
	{ "mintcream", { 245 + (245 << 8), 255 + (255 << 8), 250 + (250 << 8) } },
	{ "misty rose", { 255 + (255 << 8), 228 + (228 << 8), 225 + (225 << 8) } },
	{ "mistyrose", { 255 + (255 << 8), 228 + (228 << 8), 225 + (225 << 8) } },
	{ "mistyrose1", { 255 + (255 << 8), 228 + (228 << 8), 225 + (225 << 8) } },
	{ "mistyrose2", { 238 + (238 << 8), 213 + (213 << 8), 210 + (210 << 8) } },
	{ "mistyrose3", { 205 + (205 << 8), 183 + (183 << 8), 181 + (181 << 8) } },
	{ "mistyrose4", { 139 + (139 << 8), 125 + (125 << 8), 123 + (123 << 8) } },
	{ "moccasin", { 255 + (255 << 8), 228 + (228 << 8), 181 + (181 << 8) } },
	{ "navajo white", { 255 + (255 << 8), 222 + (222 << 8), 173 + (173 << 8) } },
	{ "navajowhite", { 255 + (255 << 8), 222 + (222 << 8), 173 + (173 << 8) } },
	{ "navajowhite1", { 255 + (255 << 8), 222 + (222 << 8), 173 + (173 << 8) } },
	{ "navajowhite2", { 238 + (238 << 8), 207 + (207 << 8), 161 + (161 << 8) } },
	{ "navajowhite3", { 205 + (205 << 8), 179 + (179 << 8), 139 + (139 << 8) } },
	{ "navajowhite4", { 139 + (139 << 8), 121 + (121 << 8), 94 + (94 << 8) } },
	{ "navy blue", { 0 + (0 << 8), 0 + (0 << 8), 128 + (128 << 8) } },
	{ "navy", { 0 + (0 << 8), 0 + (0 << 8), 128 + (128 << 8) } },
	{ "navyblue", { 0 + (0 << 8), 0 + (0 << 8), 128 + (128 << 8) } },
	{ "old lace", { 253 + (253 << 8), 245 + (245 << 8), 230 + (230 << 8) } },
	{ "oldlace", { 253 + (253 << 8), 245 + (245 << 8), 230 + (230 << 8) } },
	{ "olive drab", { 107 + (107 << 8), 142 + (142 << 8), 35 + (35 << 8) } },
	{ "olivedrab", { 107 + (107 << 8), 142 + (142 << 8), 35 + (35 << 8) } },
	{ "olivedrab1", { 192 + (192 << 8), 255 + (255 << 8), 62 + (62 << 8) } },
	{ "olivedrab2", { 179 + (179 << 8), 238 + (238 << 8), 58 + (58 << 8) } },
	{ "olivedrab3", { 154 + (154 << 8), 205 + (205 << 8), 50 + (50 << 8) } },
	{ "olivedrab4", { 105 + (105 << 8), 139 + (139 << 8), 34 + (34 << 8) } },
	{ "orange red", { 255 + (255 << 8), 69 + (69 << 8), 0 + (0 << 8) } },
	{ "orange", { 255 + (255 << 8), 165 + (165 << 8), 0 + (0 << 8) } },
	{ "orange1", { 255 + (255 << 8), 165 + (165 << 8), 0 + (0 << 8) } },
	{ "orange2", { 238 + (238 << 8), 154 + (154 << 8), 0 + (0 << 8) } },
	{ "orange3", { 205 + (205 << 8), 133 + (133 << 8), 0 + (0 << 8) } },
	{ "orange4", { 139 + (139 << 8), 90 + (90 << 8), 0 + (0 << 8) } },
	{ "orangered", { 255 + (255 << 8), 69 + (69 << 8), 0 + (0 << 8) } },
	{ "orangered1", { 255 + (255 << 8), 69 + (69 << 8), 0 + (0 << 8) } },
	{ "orangered2", { 238 + (238 << 8), 64 + (64 << 8), 0 + (0 << 8) } },
	{ "orangered3", { 205 + (205 << 8), 55 + (55 << 8), 0 + (0 << 8) } },
	{ "orangered4", { 139 + (139 << 8), 37 + (37 << 8), 0 + (0 << 8) } },
	{ "orchid", { 218 + (218 << 8), 112 + (112 << 8), 214 + (214 << 8) } },
	{ "orchid1", { 255 + (255 << 8), 131 + (131 << 8), 250 + (250 << 8) } },
	{ "orchid2", { 238 + (238 << 8), 122 + (122 << 8), 233 + (233 << 8) } },
	{ "orchid3", { 205 + (205 << 8), 105 + (105 << 8), 201 + (201 << 8) } },
	{ "orchid4", { 139 + (139 << 8), 71 + (71 << 8), 137 + (137 << 8) } },
	{ "pale goldenrod", { 238 + (238 << 8), 232 + (232 << 8), 170 + (170 << 8) } },
	{ "pale green", { 152 + (152 << 8), 251 + (251 << 8), 152 + (152 << 8) } },
	{ "pale turquoise", { 175 + (175 << 8), 238 + (238 << 8), 238 + (238 << 8) } },
	{ "pale violet red", { 219 + (219 << 8), 112 + (112 << 8), 147 + (147 << 8) } },
	{ "palegoldenrod", { 238 + (238 << 8), 232 + (232 << 8), 170 + (170 << 8) } },
	{ "palegreen", { 152 + (152 << 8), 251 + (251 << 8), 152 + (152 << 8) } },
	{ "palegreen1", { 154 + (154 << 8), 255 + (255 << 8), 154 + (154 << 8) } },
	{ "palegreen2", { 144 + (144 << 8), 238 + (238 << 8), 144 + (144 << 8) } },
	{ "palegreen3", { 124 + (124 << 8), 205 + (205 << 8), 124 + (124 << 8) } },
	{ "palegreen4", { 84 + (84 << 8), 139 + (139 << 8), 84 + (84 << 8) } },
	{ "paleturquoise", { 175 + (175 << 8), 238 + (238 << 8), 238 + (238 << 8) } },
	{ "paleturquoise1", { 187 + (187 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "paleturquoise2", { 174 + (174 << 8), 238 + (238 << 8), 238 + (238 << 8) } },
	{ "paleturquoise3", { 150 + (150 << 8), 205 + (205 << 8), 205 + (205 << 8) } },
	{ "paleturquoise4", { 102 + (102 << 8), 139 + (139 << 8), 139 + (139 << 8) } },
	{ "palevioletred", { 219 + (219 << 8), 112 + (112 << 8), 147 + (147 << 8) } },
	{ "palevioletred1", { 255 + (255 << 8), 130 + (130 << 8), 171 + (171 << 8) } },
	{ "palevioletred2", { 238 + (238 << 8), 121 + (121 << 8), 159 + (159 << 8) } },
	{ "palevioletred3", { 205 + (205 << 8), 104 + (104 << 8), 137 + (137 << 8) } },
	{ "palevioletred4", { 139 + (139 << 8), 71 + (71 << 8), 93 + (93 << 8) } },
	{ "papaya whip", { 255 + (255 << 8), 239 + (239 << 8), 213 + (213 << 8) } },
	{ "papayawhip", { 255 + (255 << 8), 239 + (239 << 8), 213 + (213 << 8) } },
	{ "peach puff", { 255 + (255 << 8), 218 + (218 << 8), 185 + (185 << 8) } },
	{ "peachpuff", { 255 + (255 << 8), 218 + (218 << 8), 185 + (185 << 8) } },
	{ "peachpuff1", { 255 + (255 << 8), 218 + (218 << 8), 185 + (185 << 8) } },
	{ "peachpuff2", { 238 + (238 << 8), 203 + (203 << 8), 173 + (173 << 8) } },
	{ "peachpuff3", { 205 + (205 << 8), 175 + (175 << 8), 149 + (149 << 8) } },
	{ "peachpuff4", { 139 + (139 << 8), 119 + (119 << 8), 101 + (101 << 8) } },
	{ "peru", { 205 + (205 << 8), 133 + (133 << 8), 63 + (63 << 8) } },
	{ "pink", { 255 + (255 << 8), 192 + (192 << 8), 203 + (203 << 8) } },
	{ "pink1", { 255 + (255 << 8), 181 + (181 << 8), 197 + (197 << 8) } },
	{ "pink2", { 238 + (238 << 8), 169 + (169 << 8), 184 + (184 << 8) } },
	{ "pink3", { 205 + (205 << 8), 145 + (145 << 8), 158 + (158 << 8) } },
	{ "pink4", { 139 + (139 << 8), 99 + (99 << 8), 108 + (108 << 8) } },
	{ "plum", { 221 + (221 << 8), 160 + (160 << 8), 221 + (221 << 8) } },
	{ "plum1", { 255 + (255 << 8), 187 + (187 << 8), 255 + (255 << 8) } },
	{ "plum2", { 238 + (238 << 8), 174 + (174 << 8), 238 + (238 << 8) } },
	{ "plum3", { 205 + (205 << 8), 150 + (150 << 8), 205 + (205 << 8) } },
	{ "plum4", { 139 + (139 << 8), 102 + (102 << 8), 139 + (139 << 8) } },
	{ "powder blue", { 176 + (176 << 8), 224 + (224 << 8), 230 + (230 << 8) } },
	{ "powderblue", { 176 + (176 << 8), 224 + (224 << 8), 230 + (230 << 8) } },
	{ "purple", { 160 + (160 << 8), 32 + (32 << 8), 240 + (240 << 8) } },
	{ "purple1", { 155 + (155 << 8), 48 + (48 << 8), 255 + (255 << 8) } },
	{ "purple2", { 145 + (145 << 8), 44 + (44 << 8), 238 + (238 << 8) } },
	{ "purple3", { 125 + (125 << 8), 38 + (38 << 8), 205 + (205 << 8) } },
	{ "purple4", { 85 + (85 << 8), 26 + (26 << 8), 139 + (139 << 8) } },
	{ "red", { 255 + (255 << 8), 0 + (0 << 8), 0 + (0 << 8) } },
	{ "red1", { 255 + (255 << 8), 0 + (0 << 8), 0 + (0 << 8) } },
	{ "red2", { 238 + (238 << 8), 0 + (0 << 8), 0 + (0 << 8) } },
	{ "red3", { 205 + (205 << 8), 0 + (0 << 8), 0 + (0 << 8) } },
	{ "red4", { 139 + (139 << 8), 0 + (0 << 8), 0 + (0 << 8) } },
	{ "rosy brown", { 188 + (188 << 8), 143 + (143 << 8), 143 + (143 << 8) } },
	{ "rosybrown", { 188 + (188 << 8), 143 + (143 << 8), 143 + (143 << 8) } },
	{ "rosybrown1", { 255 + (255 << 8), 193 + (193 << 8), 193 + (193 << 8) } },
	{ "rosybrown2", { 238 + (238 << 8), 180 + (180 << 8), 180 + (180 << 8) } },
	{ "rosybrown3", { 205 + (205 << 8), 155 + (155 << 8), 155 + (155 << 8) } },
	{ "rosybrown4", { 139 + (139 << 8), 105 + (105 << 8), 105 + (105 << 8) } },
	{ "royal blue", { 65 + (65 << 8), 105 + (105 << 8), 225 + (225 << 8) } },
	{ "royalblue", { 65 + (65 << 8), 105 + (105 << 8), 225 + (225 << 8) } },
	{ "royalblue1", { 72 + (72 << 8), 118 + (118 << 8), 255 + (255 << 8) } },
	{ "royalblue2", { 67 + (67 << 8), 110 + (110 << 8), 238 + (238 << 8) } },
	{ "royalblue3", { 58 + (58 << 8), 95 + (95 << 8), 205 + (205 << 8) } },
	{ "royalblue4", { 39 + (39 << 8), 64 + (64 << 8), 139 + (139 << 8) } },
	{ "saddle brown", { 139 + (139 << 8), 69 + (69 << 8), 19 + (19 << 8) } },
	{ "saddlebrown", { 139 + (139 << 8), 69 + (69 << 8), 19 + (19 << 8) } },
	{ "salmon", { 250 + (250 << 8), 128 + (128 << 8), 114 + (114 << 8) } },
	{ "salmon1", { 255 + (255 << 8), 140 + (140 << 8), 105 + (105 << 8) } },
	{ "salmon2", { 238 + (238 << 8), 130 + (130 << 8), 98 + (98 << 8) } },
	{ "salmon3", { 205 + (205 << 8), 112 + (112 << 8), 84 + (84 << 8) } },
	{ "salmon4", { 139 + (139 << 8), 76 + (76 << 8), 57 + (57 << 8) } },
	{ "sandy brown", { 244 + (244 << 8), 164 + (164 << 8), 96 + (96 << 8) } },
	{ "sandybrown", { 244 + (244 << 8), 164 + (164 << 8), 96 + (96 << 8) } },
	{ "sea green", { 46 + (46 << 8), 139 + (139 << 8), 87 + (87 << 8) } },
	{ "seagreen", { 46 + (46 << 8), 139 + (139 << 8), 87 + (87 << 8) } },
	{ "seagreen1", { 84 + (84 << 8), 255 + (255 << 8), 159 + (159 << 8) } },
	{ "seagreen2", { 78 + (78 << 8), 238 + (238 << 8), 148 + (148 << 8) } },
	{ "seagreen3", { 67 + (67 << 8), 205 + (205 << 8), 128 + (128 << 8) } },
	{ "seagreen4", { 46 + (46 << 8), 139 + (139 << 8), 87 + (87 << 8) } },
	{ "seashell", { 255 + (255 << 8), 245 + (245 << 8), 238 + (238 << 8) } },
	{ "seashell1", { 255 + (255 << 8), 245 + (245 << 8), 238 + (238 << 8) } },
	{ "seashell2", { 238 + (238 << 8), 229 + (229 << 8), 222 + (222 << 8) } },
	{ "seashell3", { 205 + (205 << 8), 197 + (197 << 8), 191 + (191 << 8) } },
	{ "seashell4", { 139 + (139 << 8), 134 + (134 << 8), 130 + (130 << 8) } },
	{ "sienna", { 160 + (160 << 8), 82 + (82 << 8), 45 + (45 << 8) } },
	{ "sienna1", { 255 + (255 << 8), 130 + (130 << 8), 71 + (71 << 8) } },
	{ "sienna2", { 238 + (238 << 8), 121 + (121 << 8), 66 + (66 << 8) } },
	{ "sienna3", { 205 + (205 << 8), 104 + (104 << 8), 57 + (57 << 8) } },
	{ "sienna4", { 139 + (139 << 8), 71 + (71 << 8), 38 + (38 << 8) } },
	{ "sky blue", { 135 + (135 << 8), 206 + (206 << 8), 235 + (235 << 8) } },
	{ "skyblue", { 135 + (135 << 8), 206 + (206 << 8), 235 + (235 << 8) } },
	{ "skyblue1", { 135 + (135 << 8), 206 + (206 << 8), 255 + (255 << 8) } },
	{ "skyblue2", { 126 + (126 << 8), 192 + (192 << 8), 238 + (238 << 8) } },
	{ "skyblue3", { 108 + (108 << 8), 166 + (166 << 8), 205 + (205 << 8) } },
	{ "skyblue4", { 74 + (74 << 8), 112 + (112 << 8), 139 + (139 << 8) } },
	{ "slate blue", { 106 + (106 << 8), 90 + (90 << 8), 205 + (205 << 8) } },
	{ "slate gray", { 112 + (112 << 8), 128 + (128 << 8), 144 + (144 << 8) } },
	{ "slate grey", { 112 + (112 << 8), 128 + (128 << 8), 144 + (144 << 8) } },
	{ "slateblue", { 106 + (106 << 8), 90 + (90 << 8), 205 + (205 << 8) } },
	{ "slateblue1", { 131 + (131 << 8), 111 + (111 << 8), 255 + (255 << 8) } },
	{ "slateblue2", { 122 + (122 << 8), 103 + (103 << 8), 238 + (238 << 8) } },
	{ "slateblue3", { 105 + (105 << 8), 89 + (89 << 8), 205 + (205 << 8) } },
	{ "slateblue4", { 71 + (71 << 8), 60 + (60 << 8), 139 + (139 << 8) } },
	{ "slategray", { 112 + (112 << 8), 128 + (128 << 8), 144 + (144 << 8) } },
	{ "slategray1", { 198 + (198 << 8), 226 + (226 << 8), 255 + (255 << 8) } },
	{ "slategray2", { 185 + (185 << 8), 211 + (211 << 8), 238 + (238 << 8) } },
	{ "slategray3", { 159 + (159 << 8), 182 + (182 << 8), 205 + (205 << 8) } },
	{ "slategray4", { 108 + (108 << 8), 123 + (123 << 8), 139 + (139 << 8) } },
	{ "slategrey", { 112 + (112 << 8), 128 + (128 << 8), 144 + (144 << 8) } },
	{ "snow", { 255 + (255 << 8), 250 + (250 << 8), 250 + (250 << 8) } },
	{ "snow1", { 255 + (255 << 8), 250 + (250 << 8), 250 + (250 << 8) } },
	{ "snow2", { 238 + (238 << 8), 233 + (233 << 8), 233 + (233 << 8) } },
	{ "snow3", { 205 + (205 << 8), 201 + (201 << 8), 201 + (201 << 8) } },
	{ "snow4", { 139 + (139 << 8), 137 + (137 << 8), 137 + (137 << 8) } },
	{ "spring green", { 0 + (0 << 8), 255 + (255 << 8), 127 + (127 << 8) } },
	{ "springgreen", { 0 + (0 << 8), 255 + (255 << 8), 127 + (127 << 8) } },
	{ "springgreen1", { 0 + (0 << 8), 255 + (255 << 8), 127 + (127 << 8) } },
	{ "springgreen2", { 0 + (0 << 8), 238 + (238 << 8), 118 + (118 << 8) } },
	{ "springgreen3", { 0 + (0 << 8), 205 + (205 << 8), 102 + (102 << 8) } },
	{ "springgreen4", { 0 + (0 << 8), 139 + (139 << 8), 69 + (69 << 8) } },
	{ "steel blue", { 70 + (70 << 8), 130 + (130 << 8), 180 + (180 << 8) } },
	{ "steelblue", { 70 + (70 << 8), 130 + (130 << 8), 180 + (180 << 8) } },
	{ "steelblue1", { 99 + (99 << 8), 184 + (184 << 8), 255 + (255 << 8) } },
	{ "steelblue2", { 92 + (92 << 8), 172 + (172 << 8), 238 + (238 << 8) } },
	{ "steelblue3", { 79 + (79 << 8), 148 + (148 << 8), 205 + (205 << 8) } },
	{ "steelblue4", { 54 + (54 << 8), 100 + (100 << 8), 139 + (139 << 8) } },
	{ "tan", { 210 + (210 << 8), 180 + (180 << 8), 140 + (140 << 8) } },
	{ "tan1", { 255 + (255 << 8), 165 + (165 << 8), 79 + (79 << 8) } },
	{ "tan2", { 238 + (238 << 8), 154 + (154 << 8), 73 + (73 << 8) } },
	{ "tan3", { 205 + (205 << 8), 133 + (133 << 8), 63 + (63 << 8) } },
	{ "tan4", { 139 + (139 << 8), 90 + (90 << 8), 43 + (43 << 8) } },
	{ "thistle", { 216 + (216 << 8), 191 + (191 << 8), 216 + (216 << 8) } },
	{ "thistle1", { 255 + (255 << 8), 225 + (225 << 8), 255 + (255 << 8) } },
	{ "thistle2", { 238 + (238 << 8), 210 + (210 << 8), 238 + (238 << 8) } },
	{ "thistle3", { 205 + (205 << 8), 181 + (181 << 8), 205 + (205 << 8) } },
	{ "thistle4", { 139 + (139 << 8), 123 + (123 << 8), 139 + (139 << 8) } },
	{ "tomato", { 255 + (255 << 8), 99 + (99 << 8), 71 + (71 << 8) } },
	{ "tomato1", { 255 + (255 << 8), 99 + (99 << 8), 71 + (71 << 8) } },
	{ "tomato2", { 238 + (238 << 8), 92 + (92 << 8), 66 + (66 << 8) } },
	{ "tomato3", { 205 + (205 << 8), 79 + (79 << 8), 57 + (57 << 8) } },
	{ "tomato4", { 139 + (139 << 8), 54 + (54 << 8), 38 + (38 << 8) } },
	{ "turquoise", { 64 + (64 << 8), 224 + (224 << 8), 208 + (208 << 8) } },
	{ "turquoise1", { 0 + (0 << 8), 245 + (245 << 8), 255 + (255 << 8) } },
	{ "turquoise2", { 0 + (0 << 8), 229 + (229 << 8), 238 + (238 << 8) } },
	{ "turquoise3", { 0 + (0 << 8), 197 + (197 << 8), 205 + (205 << 8) } },
	{ "turquoise4", { 0 + (0 << 8), 134 + (134 << 8), 139 + (139 << 8) } },
	{ "violet red", { 208 + (208 << 8), 32 + (32 << 8), 144 + (144 << 8) } },
	{ "violet", { 238 + (238 << 8), 130 + (130 << 8), 238 + (238 << 8) } },
	{ "violetred", { 208 + (208 << 8), 32 + (32 << 8), 144 + (144 << 8) } },
	{ "violetred1", { 255 + (255 << 8), 62 + (62 << 8), 150 + (150 << 8) } },
	{ "violetred2", { 238 + (238 << 8), 58 + (58 << 8), 140 + (140 << 8) } },
	{ "violetred3", { 205 + (205 << 8), 50 + (50 << 8), 120 + (120 << 8) } },
	{ "violetred4", { 139 + (139 << 8), 34 + (34 << 8), 82 + (82 << 8) } },
	{ "wheat", { 245 + (245 << 8), 222 + (222 << 8), 179 + (179 << 8) } },
	{ "wheat1", { 255 + (255 << 8), 231 + (231 << 8), 186 + (186 << 8) } },
	{ "wheat2", { 238 + (238 << 8), 216 + (216 << 8), 174 + (174 << 8) } },
	{ "wheat3", { 205 + (205 << 8), 186 + (186 << 8), 150 + (150 << 8) } },
	{ "wheat4", { 139 + (139 << 8), 126 + (126 << 8), 102 + (102 << 8) } },
	{ "white smoke", { 245 + (245 << 8), 245 + (245 << 8), 245 + (245 << 8) } },
	{ "white", { 255 + (255 << 8), 255 + (255 << 8), 255 + (255 << 8) } },
	{ "whitesmoke", { 245 + (245 << 8), 245 + (245 << 8), 245 + (245 << 8) } },
	{ "yellow green", { 154 + (154 << 8), 205 + (205 << 8), 50 + (50 << 8) } },
	{ "yellow", { 255 + (255 << 8), 255 + (255 << 8), 0 + (0 << 8) } },
	{ "yellow1", { 255 + (255 << 8), 255 + (255 << 8), 0 + (0 << 8) } },
	{ "yellow2", { 238 + (238 << 8), 238 + (238 << 8), 0 + (0 << 8) } },
	{ "yellow3", { 205 + (205 << 8), 205 + (205 << 8), 0 + (0 << 8) } },
	{ "yellow4", { 139 + (139 << 8), 139 + (139 << 8), 0 + (0 << 8) } },
	{ "yellowgreen", { 154 + (154 << 8), 205 + (205 << 8), 50 + (50 << 8) } },
	{ 0, { 0, 0, 0 } }
};


/* utility functions */

static char *
string_downcase (const char *in)
{
	char *out, *ptr;

	out = g_strdup (in);
	for (ptr = out; *ptr != 0; ptr++) {
		*ptr = tolower (*ptr);
	}

	return out;
}

static gboolean
next_int (char **ptr, int *value)
{
	errno = 0;
	*value = strtol (*ptr, ptr, 10);
	return errno == 0;
}

static guint
read_hex_digits (const char *ptr, int chars)
{
	char buf[16];
	g_assert (chars + 1 < sizeof (buf));
	strncpy (buf, ptr, chars);
	return strtol (buf, 0, 16);
}


/* Named color management */

static void
load_rgb_txt (void)
{
	FILE *fh;
	char buf[256];
	char *ptr, *end;
	int red, green, blue;
	rgb_color *color;
	int i;

	named_colors = g_hash_table_new (g_str_hash, g_str_equal);

	fh = fopen (PATH_RGB_TXT, "r");
	if (fh != NULL) {
		while (fgets (buf, sizeof (buf), fh) != NULL) {
			if (buf[0] == '!') {
				continue;
			}

			ptr = buf;
			if (next_int (&ptr, &red)
			    && next_int (&ptr, &green)
			    && next_int (&ptr, &blue)) {
				ptr += strspn (ptr, " \t");
				end = strchr (ptr, '\n');
				if (end != NULL) {
					*end = 0;
					color = g_new (rgb_color, 1);

					color->red = red | (red << 8);
					color->green = green | (green << 8);
					color->blue = blue | (blue << 8);

					g_hash_table_insert (named_colors,
							     string_downcase (ptr),
							     color);
				}
			}
		}
		fclose (fh);
	} else {
		/* use the local copy */
		for (i = 0; local_rgb_txt[i].name != NULL; i++) {
			g_hash_table_insert (named_colors,
					     local_rgb_txt[i].name,
					     &local_rgb_txt[i].rgb);
		}
	}
}


/* Color parser */

gboolean
gdk_pixbuf_parse_color (const char *spec, gushort *red, gushort *green, gushort *blue)
{
	rgb_color *rgb;
	char *downcase_spec;
	const char *ptr;
	int chars;

	if (spec[0] == '#') {

		chars = 0;
		for (ptr = spec + 1; isxdigit (*ptr); ptr++) {
			chars++;
		}

		switch (chars) {
		case 3:
			*red = read_hex_digits (spec + 1, 1) << 12;
			*green = read_hex_digits (spec + 2, 1) << 12;
			*blue = read_hex_digits (spec + 3, 1) << 12;
			return TRUE;

		case 6:
			*red = read_hex_digits (spec + 1, 2) << 8;
			*green = read_hex_digits (spec + 3, 2) << 8;
			*blue = read_hex_digits (spec + 5, 2) << 8;
			return TRUE;

		case 9:
			*red = read_hex_digits (spec + 1, 3) << 4;
			*green = read_hex_digits (spec + 4, 3) << 4;
			*blue = read_hex_digits (spec + 7, 3) << 4;
			return TRUE;

		case 12:
			*red = read_hex_digits (spec + 1, 4);
			*green = read_hex_digits (spec + 5, 4);
			*blue = read_hex_digits (spec + 9, 4);
			return TRUE;

		default:
			return FALSE;
		}
	} else {

		/* FIXME: handle other X color specs? E.g.

		   rgb:<red>/<green>/<blue>
		   rgbi:<red>/<green>/<blue>
		   CIEXYZ:<X>/<Y>/<Z>
		   CIEuvY:<u>/<v>/<Y>
		   CIExyY:<x>/<y>/<Y>
		   CIELab:<L>/<a>/<b>
		   CIELuv:<L>/<u>/<v>
		   TekHVC:<H>/<V>/<C> */

		if (named_colors == NULL) {
			load_rgb_txt ();
		}

		downcase_spec = string_downcase (spec);
		rgb = g_hash_table_lookup (named_colors, downcase_spec);
		g_free (downcase_spec);

		if (rgb != NULL) {
			*red = rgb->red;
			*green = rgb->green;
			*blue = rgb->blue;
			return TRUE;
		} else {
			return FALSE;
		}
	}
}


/* Test harness */

#ifdef TEST
static void
test_color (const char *spec)
{
	gushort red, green, blue;
	if (!gdk_pixbuf_parse_color (spec, &red, &green, &blue)) {
		printf ("parsing `%s' -> failed\n", spec);
	} else {
		printf ("parsing `%s' -> %04x %04x %04x\n",
			spec, red, green, blue);
	}
}

int
main (int argc, char **argv)
{
	test_color ("red");
	test_color ("steelblue1");
	test_color ("#fff");
	test_color ("#18f");
	test_color ("#224466");
	test_color ("#333444555");
	test_color ("#444455556666");

	test_color ("foobar");
	test_color ("#ffff");
	test_color ("#ggzz11");

	return 0;
}
#endif /* TEST */
