/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */

#ifndef INCL_STATUS_INTERFACE_HH
#define INCL_STATUS_INTERFACE_HH

#include "BaseGabberWindow.hh"

class ShowDlg :
     public BaseGabberDialog
{
public:
     ShowDlg(jabberoo::Presence::Show current_show, const string& current_status, int priority = 0);
private:
     void on_UpdateStatus_clicked();
     void on_Cancel_clicked();
     gint on_key_press_event(GdkEventKey* e);
     string _pix_path;
     Gtk::Text*               _txtStatus;
     jabberoo::Presence::Show _curShow;
     Gtk::SpinButton*         _spinPriority;
};

class StatusIndicator
{
public:
     static void display(jabberoo::Presence::Show current_show, const string& current_status);
};

class DockletWin
     : public SigC::Object
{
public:
     static void display(jabberoo::Presence::Show current_show, const string& current_status);
     ~DockletWin();
protected:
     gint on_window_delete(GdkEventAny *e);
     void on_close();
     DockletWin(jabberoo::Presence::Show current_show, const string& current_status);
     void update_status(jabberoo::Presence::Show current_show, const string& current_status);
     int on_button_press(GdkEventButton* e);
     gint FlashEvents();
private:
     bool _flash_events;
     bool _need_refresh;
     jabberoo::Presence::Show _current_show;
     string _pix_path;
     Gtk::Window* _status_docklet;
     Gdk_Bitmap _icon_mask;
     Gtk::Tooltips _tips;
     static DockletWin* _statusDock;
};

#endif
