/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */

#ifndef INCL_PREFS_INTERFACE_HH
#define INCL_PREFS_INTERFACE_HH

#include "BaseGabberWindow.hh"
#include "GabberUtility.hh"

class LoginDlg : 
     public BaseGabberDialog
{
public:
     static void execute();
     // Destructor
     ~LoginDlg();
protected:
     // Non-static manipulators
     void on_Login_clicked();
     void loadconfig();
     void saveconfig();
     void on_Cancel_clicked();
     void on_Help_clicked();
     void changed();
     void on_SSL_toggled();
     // Internalize default constructor
     LoginDlg();
private:
     Gtk::Button* _btnLogin;
     Gtk::Entry*  _entUsername;
     Gtk::Entry*  _entServer;
     Gtk::SpinButton*  _spinPort;
     Gtk::SpinButton*  _spinPriority;
     Gtk::Entry*  _entPassword;
     Gtk::Entry*  _entResource;
     Gtk::CheckButton* _chkSavePassword;
     Gtk::CheckButton* _chkDigest;
     Gtk::CheckButton* _chkSSL;
     Gtk::CheckButton* _chkAutologin;
     Gtk::CheckButton* _chkAutoreconnect;
     static LoginDlg*  _Dialog;
};

class PrefsWin : public BaseGabberDialog
{
public:
     static void execute();
     PrefsWin();
     ~PrefsWin();
     // Non-static manipulators
     void loadconfig();
     void saveconfig(gint page_num);
     void changed();
     void colorchanged(unsigned int arg1, unsigned int arg2, unsigned int arg3, unsigned int arg4);
     void on_apply(gint page_num);
     void on_help(gint page_num);
     void on_destroy();
     void on_GPGKey_select_row(gint,gint,GdkEvent*);
private:
     static PrefsWin* _Dialog;
     Gnome::PropertyBox* prefs;
     // Log widgets
     Gtk::CheckButton* _chkLogsNone;
     Gtk::CheckButton* _chkLogsEncrypted;
     Gtk::CheckButton* _chkLogsSave;
     Gtk::CheckButton* _chkLogsPurge;
     //Gnome::FileEntry* _fileLogsDir;
     Gtk::Entry*       _entLogsDir;
     Gtk::CheckButton* _chkLogsHTML;
     Gtk::CheckButton* _chkLogsXML;
     // Connection widgets
     Gtk::CheckButton* _chkConnAutologin;
     Gtk::CheckButton* _chkConnAutorecon;
     // Messages widgets
     Gtk::CheckButton* _chkMsgsSendMsgs;
     Gtk::CheckButton* _chkMsgsSendOOOChats;
     Gtk::CheckButton* _chkMsgsRecvNon;
     Gtk::CheckButton* _chkMsgsRecvMsgs;
     Gtk::CheckButton* _chkMsgsRecvOOOChats;
     Gtk::CheckButton* _chkMsgsOpenMsgs;
     Gtk::CheckButton* _chkMsgsOpenOOOChats;
     // Color widgets
     Gnome::ColorPicker* _colorAvailable;
     Gnome::ColorPicker* _colorChat;
     Gnome::ColorPicker* _colorAway;
     Gnome::ColorPicker* _colorXa;
     Gnome::ColorPicker* _colorDnd;
     Gnome::ColorPicker* _colorUnavailable;
     Gnome::ColorPicker* _colorNotInList;
     Gnome::ColorPicker* _colorStalker;
     Gnome::ColorPicker* _colorMessage;
     Gnome::ColorPicker* _colorOOOChat;
     // Icons
     Gtk::CheckButton* _chkIcons;
     // Size and Pos
     Gtk::CheckButton* _chkSize;
     Gtk::CheckButton* _chkPos;
     // Toolbar widgets
     Gtk::CheckButton* _chkToolbarShow;
     Gtk::CheckButton* _chkStatusShow;
     // Spelling
     Gtk::CheckButton* _chkSpellCheck;
     // Docklet
     Gtk::CheckButton* _chkDockletShow;
     // Chats
     Gtk::CheckButton* _chkChatsOOOTime;
     Gtk::CheckButton* _chkChatsGroupTime;
     //Encryption
     Gtk::CheckButton* _chkGPGEnable;
     Gtk::CList*       _clistGPGKey;
     bool	       _gotKeys;
     // Auto-away
     Gtk::CheckButton*   _chkAutoAway;
     Gtk::SpinButton*    _spinAwayAfter;
     Gtk::SpinButton*    _spinXAAfter;
     Gtk::Text*          _txtStatus;
};

#endif

