/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2000 Dave Smith & Julian Missig
 */

#ifndef INCL_MESSAGE_MANAGER_HH
#define INCL_MESSAGE_MANAGER_HH

#include "Gabber.hh"
// #include "MessageViews.hh"

class MessageView;
typedef map<string, MessageView*> ViewMap;

class MessageManager
     : public SigC::Object
{
public:
     MessageManager(const string& spooldir);
     ~MessageManager();

     enum MessageType
     {
          mtNone, mtNormal, mtError, mtChat, mtGroupchat, mtHeadline, mtRoster, mtURL, mtGCI
     };
     static const unsigned int numTypes = 9;

     enum Encryption
     {
	  encNone, encSign, encEncrypt
     };

     typedef pair<string, MessageType> EventPair;
     typedef list<EventPair> EventList;

     // Public operations
     void add(const jabberoo::Message& m, bool spool = true);
     MessageView* display(const string jid, const MessageType type);
     bool hasQueue(const string& jid);
     bool hasView(const string& jid, MessageType type = mtNormal);

     EventList& getEvents() { return _events; }
     EventList::iterator getEvent(const string& jid);

     // send a message
     bool send_message(jabberoo::Message m, Encryption& encryption);

     // Type translations
     static MessageType translateType(const jabberoo::Message& m);
     static string translateType(MessageType type);

private:
     // Internal ops
     MessageView* render(const jabberoo::Message& m);
     MessageView* render(const string& jid, MessageType type);
     void initdir();
     void clearSpool(const string& jid, MessageType type);
     void clearEvents(const string& jid, MessageType type);

     // Message list structures
     typedef list<jabberoo::Message> MList;
     map<string, MList>* _mlistmap;

     // Spooling info
     string _spool;

     // Message spooling map
     map<string, ofstream*>* _mspools;

     // Message display structures
     ViewMap* _mviews;

     // Use a list to keep track of the order that the messages arrived
     EventList _events;

     static const string XML_FOOTER;
};

class MessageLoader
     : private judo::TagStream
{
public:
     MessageLoader(const string& filename, MessageManager& mm);
     ~MessageLoader();
private:
     MessageManager& _manager;
     virtual void OnTag(Tag& t);
};

#endif
