/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */

#ifndef INCL_GABBER_UTILITY_HH
#define INCL_GABBER_UTILITY_HH

#include "Gabber.hh"

namespace GabberUtil
{
     void toggle_visible(Gtk::ToggleButton* t, Gtk::Widget* w);
     gint strcasecmp_clist_items(GtkCList* c, const void* lhs, const void* rhs);
     void change_pixmap(Gtk::PixmapMenuItem* pitem, const string& filename);
     string toUTF8(Gtk::Widget* w, const string& text);
     string toUTF8(GtkWidget* w, const string& text);
     string fromUTF8(Gtk::Widget* w, const string& text);
     string fromUTF8(GtkWidget* w, const string& text);
     string getShowName(jabberoo::Presence::Show type);
     string getS10nName(jabberoo::Roster::Subscription type);
     string getS10nInfo(jabberoo::Roster::Subscription type);
     jabberoo::Presence::Show indexShow(int show_index);
     int    indexShow(jabberoo::Presence::Show show_index);
};

class MenuBuilder
     : public SigC::Object
{
public:
     MenuBuilder();
     Gtk::Menu* get_menu() { return menu; }
     void add_tearoff();
     void add_separator();
     Gtk::MenuItem* add_item(const string& label, int num, bool submenu = false);
     Gtk::PixmapMenuItem* add_item(const string& pixmap, const string& label, int num, bool submenu = false);
     void add_presence_items();
     void finish_items();
private:
    Gtk::Menu* menu;
public:
     SigC::Signal1<void, int> selected;
};

class PresenceMenuBuilder
     : public SigC::Object
{
public:
     PresenceMenuBuilder();
     Gtk::Menu* get_menu() { return _menu; }
private:
     MenuBuilder _main;
     Gtk::Menu* _menu;
     MenuBuilder _online;
     MenuBuilder _chat;
     MenuBuilder _away;
     MenuBuilder _xa;
     MenuBuilder _dnd;
public:
     SigC::Signal1<void, int> main_selected;
//     SigC::Signal2<void, int, jabberoo::Presence::Show> presence_selected;
};

class FileSel
     : public SigC::Object
{
public:
     FileSel::FileSel(const string& jid, const string& title, const string& log);
protected:
     void FileSel::on_ok_clicked();
     void FileSel::on_cancel_clicked();
private:
     const string& _log;
     Gtk::FileSelection* _fileSel;
};

#endif
