/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */
#ifndef INCL_AGENT_BROWSER
#define INCL_AGENT_BROWSER

#include "BaseGabberWindow.hh"

class AgentBrowser
     : public SigC::Object
{
public:
     AgentBrowser(BaseGabberWindow* base, const string& base_string, const string& server, const jabberoo::AgentList& l);
     ~AgentBrowser();
     void update_agents(const string& server, jabberoo::AgentList l);
     void browse();
     jabberoo::Agent* get_current_agent() { return _current_agent; }
protected:
     void on_browse_clicked();
     gint on_key_press_event(GdkEventKey* e);
     void on_tree_expand(Gtk::CTree::Row r);
     void on_tree_collapse(Gtk::CTree::Row r);
     int  on_tree_button(GdkEventButton* e);
     void on_tree_select(Gtk::CTree::Row r, int col);
     void on_tree_unselect(Gtk::CTree::Row r, int col);
     void on_agent_fetch_complete(bool successful, GtkCTreeNode* agentnode, GtkCTreeNode* dummynode);
     void handle_agents_IQ(const Tag& iq);
     // Agent render
     void render_agent(jabberoo::Agent& a, GtkCTreeNode* parent = NULL);
private:
     BaseGabberWindow*   _base;
     jabberoo::AgentList _agent_list;
     jabberoo::Agent*    _current_agent;
     Gtk::CTree*         _ctreeAgent;
     Gtk::Entry*         _entServer;
     Gnome::Entry*       _gentServer;

public:
     SigC::Signal5<void, bool, bool, bool, bool, bool> agent_selected;
};

class AgentBrowserDlg
     : public BaseGabberDialog
{
public:
     static void execute();
protected:
     AgentBrowserDlg(const string& server, jabberoo::AgentList a);
     virtual ~AgentBrowserDlg() {}
     // Event handlers
     void on_info_clicked();
     void on_register_clicked();
     void on_search_clicked();
     void on_close_clicked();
     void AgentBrowserDlg::on_agent_selected(bool selected, bool registerable, bool searchable, bool gccapable, bool agents);
     gint on_key_pressed(GdkEventKey* e);
     // Static IQ Callback
     static void handle_agents_IQ_s(const Tag& iq);
private:
     AgentBrowser*       _browser;
     Gtk::Button*        _infoBtn;
     Gtk::Button*        _registerBtn;
     Gtk::Button*        _searchBtn;
};

class AgentRegisterDruid
     : public BaseGabberWindow
{
public:
     AgentRegisterDruid(jabberoo::Agent& a);
     virtual ~AgentRegisterDruid() {}
protected:
     void handle_request_reply(const Tag& iq);
     void on_register_reply(const Tag& iq);
     void on_Fields_prepare();
     bool on_Fields_next();
     void on_Registered_prepare();
     bool on_Registered_back();
     void on_finish();
     void on_cancel();
private:
     typedef list<Gtk::Entry *> EntryList;
     typedef list<string> StringList;

     Gnome::Druid* _druid;
     Gtk::VBox*    _fields_vbox;
     Gtk::Label*   _instr_lbl;

     Gtk::Label*   _lblRegistered;
     Gnome::DruidPage* _RDruid_loading;
     Gnome::DruidPage* _RDruid_fields;
     Gnome::DruidPage* _RDruid_registering;
     Gnome::DruidPage* _RDruid_registered;
     Gnome::AppBar* _barStatus;
     string _key;
     EntryList _entrys;
     StringList _field_names;
     jabberoo::Agent& _agent;
     bool _init_interface;
};

#endif
