/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */

#ifndef INCL_ADD_CONTACT_DRUID_HH
#define INCL_ADD_CONTACT_DRUID_HH

#include "Gabber.hh"
#include "GabberUtility.hh"
#include "BaseGabberWindow.hh"
#include "AgentInterface.hh"

class AddContactDruid :
     public BaseGabberWindow
{
public:
     // Page type
     enum Page {
	  auIntro, auChoice, auNormaladd, auAgents, auSearch, auNickname
     };
     static void display(Page first_page);
     static void display(const string& jid);
     static void display(jabberoo::Agent& a);
     // Destructor
     virtual ~AddContactDruid() {};
protected:
     // Default constructor
     AddContactDruid(Page first_page, const string& jid);
     AddContactDruid(Page first_page, jabberoo::Agent& agent);
     void init();
     // Non-static manipulators
     void on_cancel();
     void on_Choice_prepare();
     bool on_Choice_next();
     void on_Normaladd_prepare();
     bool on_Normaladd_next();
     void on_Nickname_prepare();
     void get_vCard(const Tag& t);
     bool on_Nickname_next();
     bool on_Nickname_prev();
     void on_Confirm_prepare();
     bool on_Confirm_next();
     void on_finish();
     Gnome::DruidPage* translate_page(Page given_page);
     void on_Username_changed();
     void on_Server_changed();
     void on_Nickname_changed();
     void on_AddAgain_toggled();
     void get_trans_JID(int selected);
     // Search
     void on_Agents_prepare();
     void on_agent_selected(bool selected, bool registerable, bool searchable, bool gccapable, bool agents);
     void handle_Agents_iq(const Tag& iq);
     bool on_Agents_next();
     void on_Search_prepare();
     void handle_search_request_reply(const Tag& iq);
     bool on_Search_next();
     void on_search_reply(const Tag& iq);
     void on_SearchResults_select_row(int row, int col, GdkEvent* e);
     bool on_SearchResults_next();
     void search_buttons_toggle();
     void on_agents_reply(const Tag& iq);
     void on_agent_reply(const Tag& iq);
private:
     static AddContactDruid* _Dialog;
     Gnome::Druid* _druid;
     Gnome::DruidPage* _AUDruid_intro;
     Gnome::DruidPage* _AUDruid_choice;
     Gnome::DruidPage* _AUDruid_normaladd;
     Gnome::DruidPage* _AUDruid_agents;
     Gnome::DruidPage* _AUDruid_nickname;
     Gnome::DruidPage* _AUDruid_options;
     Gnome::DruidPage* _AUDruid_confirm;
     Gnome::DruidPage* _AUDruid_finish;
     Gnome::DruidPage* _lastPage;
     Gtk::OptionMenu*  _optTrans;
     Gnome::AppBar*    _barStatus;
     Gtk::Entry* _entUsername;
     Gtk::Entry* _entServer;
     Gtk::Entry* _entNickname;
     Gtk::Text*  _txtRequest;
     string _JID;
     string _nickname;
     bool _have_agents;
     MenuBuilder _menuTrans;
     vector<string> _jidlist;
     // Search
     typedef list<Gtk::Entry *> EntryList;
     typedef list<string> StringList;
     Gnome::DruidPage* _AUDruid_search;
     Gnome::DruidPage* _AUDruid_searchresults;
     jabberoo::Agent*  _agent;
     AgentBrowser*     _browserSearch;
     Gtk::VBox*        _vboxSearch;
     Gtk::Label*       _lblLoading;
     Gtk::CList*    _results_clist;
     Gtk::Frame*    _results_frame;
     Gtk::ScrolledWindow* _results_scroll;
     EntryList _entrys;
     StringList _field_names;
     string _key;
     bool _init_interface;
     bool _have_key;
     bool _currently_searchresults;
};

#endif
