/* test-ai.c generated by valac 0.36.4, the Vala compiler
 * generated from test-ai.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Michael Catanzaro
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of Four-in-a-row.
 *
 * Four-in-a-row is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Four-in-a-row is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Four-in-a-row.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_DECISION_TREE (decision_tree_get_type ())
#define DECISION_TREE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DECISION_TREE, DecisionTree))
#define DECISION_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DECISION_TREE, DecisionTreeClass))
#define IS_DECISION_TREE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DECISION_TREE))
#define IS_DECISION_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DECISION_TREE))
#define DECISION_TREE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DECISION_TREE, DecisionTreeClass))

typedef struct _DecisionTree DecisionTree;
typedef struct _DecisionTreeClass DecisionTreeClass;
#define _decision_tree_unref0(var) ((var == NULL) ? NULL : (var = (decision_tree_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);



#define NUMBER_GAMES 5
#define MAXIMUM_GAMES 100
#define THRESHOLD_DENOMINATOR 4
void test_horizontal_win (void);
gint playgame (const gchar* moves_until_now);
void test_vertical_win (void);
void test_forward_diagonal_win (void);
void test_backward_diagonal_win (void);
void test_avoid_vertical_loss (void);
void test_avoid_forward_diagonal_loss (void);
void test_avoid_backward_diagonal_loss (void);
void test_avoid_horizontal_loss (void);
void test_draw (void);
void test_random (void);
gint test_ai_vs_ai (const gchar* easier, const gchar* harder);
gpointer decision_tree_ref (gpointer instance);
void decision_tree_unref (gpointer instance);
GParamSpec* param_spec_decision_tree (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_decision_tree (GValue* value, gpointer v_object);
void value_take_decision_tree (GValue* value, gpointer v_object);
gpointer value_get_decision_tree (const GValue* value);
GType decision_tree_get_type (void) G_GNUC_CONST;
DecisionTree* decision_tree_new (void);
DecisionTree* decision_tree_construct (GType object_type);
gint decision_tree_playandcheck (DecisionTree* self, const gchar* vstr);
void repeat_contests (const gchar* easier, const gchar* harder, gint* games_contested, gint* easy_wins);
void test_easy_vs_medium (void);
void test_easy_vs_hard (void);
void test_medium_vs_hard (void);
gint _vala_main (gchar** args, int args_length1);
static void _test_horizontal_win_gtest_func (void);
static void _test_vertical_win_gtest_func (void);
static void _test_forward_diagonal_win_gtest_func (void);
static void _test_backward_diagonal_win_gtest_func (void);
static void _test_avoid_horizontal_loss_gtest_func (void);
static void _test_avoid_vertical_loss_gtest_func (void);
static void _test_avoid_forward_diagonal_loss_gtest_func (void);
static void _test_avoid_backward_diagonal_loss_gtest_func (void);
static void _test_easy_vs_medium_gtest_func (void);
static void _test_easy_vs_hard_gtest_func (void);
static void _test_medium_vs_hard_gtest_func (void);
static void _test_draw_gtest_func (void);
static void _test_random_gtest_func (void);


void test_horizontal_win (void) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = playgame ("a1727370");
	_vala_assert (_tmp0_ == 4, "playgame (\"a1727370\") == 4");
	_tmp1_ = playgame ("a7315651311324420");
	_vala_assert (_tmp1_ == 6, "playgame (\"a7315651311324420\") == 6");
	_tmp2_ = playgame ("a232225657223561611133440");
	_vala_assert (_tmp2_ == 4, "playgame (\"a232225657223561611133440\") == 4");
	_tmp3_ = playgame ("a242215322574255543341746677453337710");
	_vala_assert (_tmp3_ == 1, "playgame (\"a242215322574255543341746677453337710\") == 1");
}


void test_vertical_win (void) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = playgame ("a1213140");
	_vala_assert (_tmp0_ == 1, "playgame (\"a1213140\") == 1");
	_tmp1_ = playgame ("a14456535526613130");
	_vala_assert (_tmp1_ == 1, "playgame (\"a14456535526613130\") == 1");
	_tmp2_ = playgame ("a432334277752576710");
	_vala_assert (_tmp2_ == 7, "playgame (\"a432334277752576710\") == 7");
	_tmp3_ = playgame ("a547477454544323321712116260");
	_vala_assert (_tmp3_ == 2, "playgame (\"a547477454544323321712116260\") == 2");
}


void test_forward_diagonal_win (void) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = playgame ("a54221164712446211622157570");
	_vala_assert (_tmp0_ == 7, "playgame (\"a54221164712446211622157570\") == 7");
	_tmp1_ = playgame ("a4256424426621271412117175776343330");
	_vala_assert (_tmp1_ == 3, "playgame (\"a4256424426621271412117175776343330\") == 3");
	_tmp2_ = playgame ("a132565522322662666775443351131113540");
	_vala_assert (_tmp2_ == 4, "playgame (\"a132565522322662666775443351131113540\") == 4");
	_tmp3_ = playgame ("a4571311334541225544112245262577767733360");
	_vala_assert (_tmp3_ == 6, "playgame (\"a4571311334541225544112245262577767733360\") == 6");
}


void test_backward_diagonal_win (void) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = playgame ("5422327343142110");
	_vala_assert (_tmp0_ == 1, "playgame (\"5422327343142110\") == 1");
	_tmp1_ = playgame ("a1415113315143220");
	_vala_assert (_tmp1_ == 2, "playgame (\"a1415113315143220\") == 2");
	_tmp2_ = playgame ("a547323452213345110");
	_vala_assert (_tmp2_ == 1, "playgame (\"a547323452213345110\") == 1");
	_tmp3_ = playgame ("a4256424426621271412117175776343330");
	_vala_assert (_tmp3_ == 3, "playgame (\"a4256424426621271412117175776343330\") == 3");
}


void test_avoid_vertical_loss (void) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = playgame ("a42563117273430");
	_vala_assert (_tmp0_ == 3, "playgame (\"a42563117273430\") == 3");
	_tmp1_ = playgame ("a3642571541322340");
	_vala_assert (_tmp1_ == 4, "playgame (\"a3642571541322340\") == 4");
	_tmp2_ = playgame ("a144566264475171137750");
	_vala_assert (_tmp2_ == 5, "playgame (\"a144566264475171137750\") == 5");
	_tmp3_ = playgame ("a54747745454432332171210");
	_vala_assert (_tmp3_ == 1, "playgame (\"a54747745454432332171210\") == 1");
}


void test_avoid_forward_diagonal_loss (void) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = playgame ("a34256477331566570");
	_vala_assert (_tmp0_ == 7, "playgame (\"a34256477331566570\") == 7");
	_tmp1_ = playgame ("a1445662644751711370");
	_vala_assert (_tmp1_ == 7, "playgame (\"a1445662644751711370\") == 7");
	_tmp2_ = playgame ("a43442235372115113340");
	_vala_assert (_tmp2_ == 4, "playgame (\"a43442235372115113340\") == 4");
	_tmp3_ = playgame ("a4143525567766443543125411170");
	_vala_assert (_tmp3_ == 7, "playgame (\"a4143525567766443543125411170\") == 7");
}


void test_avoid_backward_diagonal_loss (void) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = playgame ("a47465234222530");
	_vala_assert (_tmp0_ == 3, "playgame (\"a47465234222530\") == 3");
	_tmp1_ = playgame ("a4344223537211510");
	_vala_assert (_tmp1_ == 1, "playgame (\"a4344223537211510\") == 1");
	_tmp2_ = playgame ("a4141311525513520");
	_vala_assert (_tmp2_ == 2, "playgame (\"a4141311525513520\") == 2");
	_tmp3_ = playgame ("a1445662644751711377553330");
	_vala_assert (_tmp3_ == 3, "playgame (\"a1445662644751711377553330\") == 3");
}


void test_avoid_horizontal_loss (void) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = playgame ("a445360");
	_vala_assert (_tmp0_ == 7, "playgame (\"a445360\") == 7");
	_tmp1_ = playgame ("a745534131117114777720");
	_vala_assert (_tmp1_ == 2, "playgame (\"a745534131117114777720\") == 2");
	_tmp2_ = playgame ("a243466431217112323350");
	_vala_assert (_tmp2_ == 5, "playgame (\"a243466431217112323350\") == 5");
	_tmp3_ = playgame ("a24147356465355111336631615240");
	_vala_assert (_tmp3_ == 4, "playgame (\"a24147356465355111336631615240\") == 4");
}


void test_draw (void) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = playgame ("a1311313113652226667224247766737374455445550");
	_vala_assert (_tmp0_ == 0, "playgame (\"a1311313113652226667224247766737374455445550\") == 0");
	_tmp1_ = playgame ("a6121151135432322433425566474425617635677770");
	_vala_assert (_tmp1_ == 0, "playgame (\"a6121151135432322433425566474425617635677770\") == 0");
	_tmp2_ = playgame ("a4226111412113275256335534443264375577676670");
	_vala_assert (_tmp2_ == 0, "playgame (\"a4226111412113275256335534443264375577676670\") == 0");
	_tmp3_ = playgame ("a4212116575717754775221133434432366655342660");
	_vala_assert (_tmp3_ == 0, "playgame (\"a4212116575717754775221133434432366655342660\") == 0");
}


void test_random (void) {
	gint x = 0;
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gint _tmp8_;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	gint _tmp12_;
	gboolean _tmp13_ = FALSE;
	gint _tmp14_;
	_tmp0_ = playgame ("a443256214350");
	x = _tmp0_;
	_tmp2_ = x;
	if (_tmp2_ >= 1) {
		gint _tmp3_;
		_tmp3_ = x;
		_tmp1_ = _tmp3_ <= 7;
	} else {
		_tmp1_ = FALSE;
	}
	_vala_assert (_tmp1_, "x >= 1 && x <= 7");
	_tmp4_ = playgame ("a241473564653551113366316150");
	x = _tmp4_;
	_tmp6_ = x;
	if (_tmp6_ >= 1) {
		gint _tmp7_;
		_tmp7_ = x;
		_tmp5_ = _tmp7_ <= 7;
	} else {
		_tmp5_ = FALSE;
	}
	_vala_assert (_tmp5_, "x >= 1 && x <= 7");
	_tmp8_ = playgame ("a24357315461711177416622623350");
	x = _tmp8_;
	_tmp10_ = x;
	if (_tmp10_ >= 1) {
		gint _tmp11_;
		_tmp11_ = x;
		_tmp9_ = _tmp11_ <= 7;
	} else {
		_tmp9_ = FALSE;
	}
	_vala_assert (_tmp9_, "x >= 1 && x <= 7");
	_tmp12_ = playgame ("a1445662644751711377553333665775446110");
	x = _tmp12_;
	_tmp14_ = x;
	if (_tmp14_ >= 1) {
		gint _tmp15_;
		_tmp15_ = x;
		_tmp13_ = _tmp15_ <= 7;
	} else {
		_tmp13_ = FALSE;
	}
	_vala_assert (_tmp13_, "x >= 1 && x <= 7");
}


gint test_ai_vs_ai (const gchar* easier, const gchar* harder) {
	gint result = 0;
	gint easier_wins = 0;
	gint draw = 0;
	gint harder_wins = 0;
	g_return_val_if_fail (easier != NULL, 0);
	g_return_val_if_fail (harder != NULL, 0);
	easier_wins = 0;
	draw = 0;
	harder_wins = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GString* e = NULL;
				GString* _tmp3_;
				GString* _tmp4_;
				const gchar* _tmp5_;
				GString* m = NULL;
				GString* _tmp6_;
				GString* _tmp7_;
				const gchar* _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < NUMBER_GAMES)) {
					break;
				}
				_tmp3_ = g_string_new ("");
				e = _tmp3_;
				_tmp4_ = e;
				_tmp5_ = easier;
				g_string_append (_tmp4_, _tmp5_);
				_tmp6_ = g_string_new ("");
				m = _tmp6_;
				_tmp7_ = m;
				_tmp8_ = harder;
				g_string_append (_tmp7_, _tmp8_);
				while (TRUE) {
					gint move = 0;
					DecisionTree* t = NULL;
					DecisionTree* _tmp9_;
					DecisionTree* _tmp10_;
					GString* _tmp11_;
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					gint _tmp16_;
					GString* _tmp18_;
					GString* _tmp19_;
					const gchar* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					GString* _tmp26_;
					GString* _tmp27_;
					const gchar* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					DecisionTree* d = NULL;
					DecisionTree* _tmp34_;
					DecisionTree* _tmp35_;
					GString* _tmp36_;
					const gchar* _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					gint _tmp41_;
					GString* _tmp43_;
					GString* _tmp44_;
					const gchar* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					GString* _tmp51_;
					GString* _tmp52_;
					const gchar* _tmp53_;
					gint _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					_tmp9_ = decision_tree_new ();
					t = _tmp9_;
					_tmp10_ = t;
					_tmp11_ = e;
					_tmp12_ = _tmp11_->str;
					_tmp13_ = decision_tree_playandcheck (_tmp10_, _tmp12_);
					move = _tmp13_;
					_tmp14_ = move;
					if (_tmp14_ == 0) {
						gint _tmp15_;
						_tmp15_ = draw;
						draw = _tmp15_ + 1;
						_decision_tree_unref0 (t);
						break;
					}
					_tmp16_ = move;
					if (_tmp16_ == 1000) {
						gint _tmp17_;
						_tmp17_ = easier_wins;
						easier_wins = _tmp17_ + 1;
						_decision_tree_unref0 (t);
						break;
					}
					_tmp18_ = e;
					_tmp19_ = e;
					_tmp20_ = _tmp19_->str;
					_tmp21_ = strlen (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = move;
					_tmp24_ = g_strdup_printf ("%i", _tmp23_);
					_tmp25_ = _tmp24_;
					g_string_insert (_tmp18_, (gssize) (_tmp22_ - 1), _tmp25_);
					_g_free0 (_tmp25_);
					_tmp26_ = m;
					_tmp27_ = m;
					_tmp28_ = _tmp27_->str;
					_tmp29_ = strlen (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = move;
					_tmp32_ = g_strdup_printf ("%i", _tmp31_);
					_tmp33_ = _tmp32_;
					g_string_insert (_tmp26_, (gssize) (_tmp30_ - 1), _tmp33_);
					_g_free0 (_tmp33_);
					_tmp34_ = decision_tree_new ();
					d = _tmp34_;
					_tmp35_ = d;
					_tmp36_ = m;
					_tmp37_ = _tmp36_->str;
					_tmp38_ = decision_tree_playandcheck (_tmp35_, _tmp37_);
					move = _tmp38_;
					_tmp39_ = move;
					if (_tmp39_ == 0) {
						gint _tmp40_;
						_tmp40_ = draw;
						draw = _tmp40_ + 1;
						_decision_tree_unref0 (d);
						_decision_tree_unref0 (t);
						break;
					}
					_tmp41_ = move;
					if (_tmp41_ == 1000) {
						gint _tmp42_;
						_tmp42_ = harder_wins;
						harder_wins = _tmp42_ + 1;
						_decision_tree_unref0 (d);
						_decision_tree_unref0 (t);
						break;
					}
					_tmp43_ = e;
					_tmp44_ = e;
					_tmp45_ = _tmp44_->str;
					_tmp46_ = strlen (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = move;
					_tmp49_ = g_strdup_printf ("%i", _tmp48_);
					_tmp50_ = _tmp49_;
					g_string_insert (_tmp43_, (gssize) (_tmp47_ - 1), _tmp50_);
					_g_free0 (_tmp50_);
					_tmp51_ = m;
					_tmp52_ = m;
					_tmp53_ = _tmp52_->str;
					_tmp54_ = strlen (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = move;
					_tmp57_ = g_strdup_printf ("%i", _tmp56_);
					_tmp58_ = _tmp57_;
					g_string_insert (_tmp51_, (gssize) (_tmp55_ - 1), _tmp58_);
					_g_free0 (_tmp58_);
					_decision_tree_unref0 (d);
					_decision_tree_unref0 (t);
				}
				_g_string_free0 (m);
				_g_string_free0 (e);
			}
		}
	}
	result = easier_wins;
	return result;
}


void repeat_contests (const gchar* easier, const gchar* harder, gint* games_contested, gint* easy_wins) {
	gint _vala_games_contested = 0;
	gint _vala_easy_wins = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	g_return_if_fail (easier != NULL);
	g_return_if_fail (harder != NULL);
	_tmp0_ = easier;
	_tmp1_ = harder;
	_tmp2_ = test_ai_vs_ai (_tmp0_, _tmp1_);
	_vala_easy_wins = _tmp2_;
	_vala_games_contested = NUMBER_GAMES;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gint _tmp4_;
		gint _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp4_ = _vala_games_contested;
		if (_tmp4_ <= MAXIMUM_GAMES) {
			gint _tmp5_;
			gint _tmp6_;
			_tmp5_ = _vala_easy_wins;
			_tmp6_ = _vala_games_contested;
			_tmp3_ = _tmp5_ > (_tmp6_ / THRESHOLD_DENOMINATOR);
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp7_ = _vala_easy_wins;
		_tmp8_ = easier;
		_tmp9_ = harder;
		_tmp10_ = test_ai_vs_ai (_tmp8_, _tmp9_);
		_vala_easy_wins = _tmp7_ + _tmp10_;
		_tmp11_ = _vala_games_contested;
		_vala_games_contested = _tmp11_ + NUMBER_GAMES;
	}
	if (games_contested) {
		*games_contested = _vala_games_contested;
	}
	if (easy_wins) {
		*easy_wins = _vala_easy_wins;
	}
}


void test_easy_vs_medium (void) {
	gint easy_wins = 0;
	gint games_contested = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	repeat_contests ("a0", "b0", &_tmp0_, &_tmp1_);
	games_contested = _tmp0_;
	easy_wins = _tmp1_;
	_vala_assert (easy_wins <= (games_contested / THRESHOLD_DENOMINATOR), "easy_wins <= games_contested/THRESHOLD_DENOMINATOR");
}


void test_easy_vs_hard (void) {
	gint easy_wins = 0;
	gint games_contested = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	repeat_contests ("a0", "c0", &_tmp0_, &_tmp1_);
	games_contested = _tmp0_;
	easy_wins = _tmp1_;
	_vala_assert (easy_wins <= (games_contested / THRESHOLD_DENOMINATOR), "easy_wins <= games_contested/THRESHOLD_DENOMINATOR");
}


void test_medium_vs_hard (void) {
	gint medium_wins = 0;
	gint games_contested = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	repeat_contests ("b0", "c0", &_tmp0_, &_tmp1_);
	games_contested = _tmp0_;
	medium_wins = _tmp1_;
	_vala_assert (medium_wins <= (games_contested / THRESHOLD_DENOMINATOR), "medium_wins <= games_contested/THRESHOLD_DENOMINATOR");
}


static void _test_horizontal_win_gtest_func (void) {
	test_horizontal_win ();
}


static void _test_vertical_win_gtest_func (void) {
	test_vertical_win ();
}


static void _test_forward_diagonal_win_gtest_func (void) {
	test_forward_diagonal_win ();
}


static void _test_backward_diagonal_win_gtest_func (void) {
	test_backward_diagonal_win ();
}


static void _test_avoid_horizontal_loss_gtest_func (void) {
	test_avoid_horizontal_loss ();
}


static void _test_avoid_vertical_loss_gtest_func (void) {
	test_avoid_vertical_loss ();
}


static void _test_avoid_forward_diagonal_loss_gtest_func (void) {
	test_avoid_forward_diagonal_loss ();
}


static void _test_avoid_backward_diagonal_loss_gtest_func (void) {
	test_avoid_backward_diagonal_loss ();
}


static void _test_easy_vs_medium_gtest_func (void) {
	test_easy_vs_medium ();
}


static void _test_easy_vs_hard_gtest_func (void) {
	test_easy_vs_hard ();
}


static void _test_medium_vs_hard_gtest_func (void) {
	test_medium_vs_hard ();
}


static void _test_draw_gtest_func (void) {
	test_draw ();
}


static void _test_random_gtest_func (void) {
	test_random ();
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gint _tmp0_;
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/AI/Take Win/Horizontal Win", _test_horizontal_win_gtest_func);
	g_test_add_func ("/AI/Take Win/Vertical Win", _test_vertical_win_gtest_func);
	g_test_add_func ("/AI/Take Win/Forward Diagonal Win", _test_forward_diagonal_win_gtest_func);
	g_test_add_func ("/AI/Take Win/Backward Diagonal Win", _test_backward_diagonal_win_gtest_func);
	g_test_add_func ("/AI/Avoid Loss/Horizontal Loss", _test_avoid_horizontal_loss_gtest_func);
	g_test_add_func ("/AI/Avoid Loss/Vertical Loss", _test_avoid_vertical_loss_gtest_func);
	g_test_add_func ("/AI/Avoid Loss/Forward Diagonal Loss", _test_avoid_forward_diagonal_loss_gtest_func);
	g_test_add_func ("/AI/Avoid Loss/Backward Diagonal Loss", _test_avoid_backward_diagonal_loss_gtest_func);
	g_test_add_func ("/AI/AI vs AI/Easy vs Medium", _test_easy_vs_medium_gtest_func);
	g_test_add_func ("/AI/AI vs AI/Easy vs Hard", _test_easy_vs_hard_gtest_func);
	g_test_add_func ("/AI/AI vs AI/Medium vs Hard", _test_medium_vs_hard_gtest_func);
	g_test_add_func ("/AI/Draw", _test_draw_gtest_func);
	g_test_add_func ("/AI/Random", _test_random_gtest_func);
	_tmp0_ = g_test_run ();
	result = _tmp0_;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}



