/* utils.c generated by valac 0.13.4, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks/folks.h>
#include <stdarg.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define FOLKS_INSPECT_TYPE_UTILS (folks_inspect_utils_get_type ())
#define FOLKS_INSPECT_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtils))
#define FOLKS_INSPECT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))
#define FOLKS_INSPECT_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))

typedef struct _FolksInspectUtils FolksInspectUtils;
typedef struct _FolksInspectUtilsClass FolksInspectUtilsClass;
typedef struct _FolksInspectUtilsPrivate FolksInspectUtilsPrivate;

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;
typedef struct _FolksInspectClientPrivate FolksInspectClientPrivate;
typedef struct _FolksInspectParamSpecUtils FolksInspectParamSpecUtils;

struct _FolksInspectUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectUtilsPrivate * priv;
};

struct _FolksInspectUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectUtils *self);
};

struct _FolksInspectClient {
	GObject parent_instance;
	FolksInspectClientPrivate * priv;
	GeeHashMap* commands;
};

struct _FolksInspectClientClass {
	GObjectClass parent_class;
};

struct _FolksInspectParamSpecUtils {
	GParamSpec parent_instance;
};


static gpointer folks_inspect_utils_parent_class = NULL;
static guint folks_inspect_utils_indentation;
static guint folks_inspect_utils_indentation = (guint) 0;
static gchar* folks_inspect_utils_indentation_string;
static gchar* folks_inspect_utils_indentation_string = NULL;
static GeeMapIterator* folks_inspect_utils_command_name_iter;
static GeeMapIterator* folks_inspect_utils_command_name_iter = NULL;
static GeeMapIterator* folks_inspect_utils_individual_id_iter;
static GeeMapIterator* folks_inspect_utils_individual_id_iter = NULL;
static GeeIterator* folks_inspect_utils_persona_uid_iter;
static GeeIterator* folks_inspect_utils_persona_uid_iter = NULL;
static GeeIterator* folks_inspect_utils_backend_name_iter;
static GeeIterator* folks_inspect_utils_backend_name_iter = NULL;
static GeeMapIterator* folks_inspect_utils_persona_store_id_iter;
static GeeMapIterator* folks_inspect_utils_persona_store_id_iter = NULL;
extern FolksInspectClient* main_client;

gpointer folks_inspect_utils_ref (gpointer instance);
void folks_inspect_utils_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_utils (GValue* value, gpointer v_object);
void folks_inspect_value_take_utils (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_utils (const GValue* value);
GType folks_inspect_utils_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_UTILS_DUMMY_PROPERTY
};
gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
void folks_inspect_utils_init (void);
static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
void folks_inspect_utils_indent (void);
void folks_inspect_utils_unindent (void);
void folks_inspect_utils_print_line (const gchar* format, ...);
void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas);
static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value);
void folks_inspect_utils_print_persona (FolksPersona* persona);
void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas);
gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value);
gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state);
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state);
FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state);
gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state);
FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self);
gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state);
FolksInspectUtils* folks_inspect_utils_new (void);
FolksInspectUtils* folks_inspect_utils_construct (GType object_type);
static void folks_inspect_utils_finalize (FolksInspectUtils* obj);


static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_object_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_persona_store_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_string_array_to_string (src_value, dest_value);
}


void folks_inspect_utils_init (void) {
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
	g_value_register_transform_func (G_TYPE_OBJECT, G_TYPE_STRING, _folks_inspect_utils_transform_object_to_string_gvalue_transform);
	g_value_register_transform_func (FOLKS_TYPE_PERSONA_STORE, G_TYPE_STRING, _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform);
	g_value_register_transform_func (G_TYPE_STRV, G_TYPE_STRING, _folks_inspect_utils_transform_string_array_to_string_gvalue_transform);
}


static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest) {
	GValue _vala_dest = {0};
	GObject* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* output;
	gchar* _tmp2_;
	GValue _tmp3_ = {0};
	g_return_if_fail (src != NULL);
	_tmp0_ = g_value_get_object (src);
	_tmp1_ = g_strdup_printf ("%p", _tmp0_);
	output = _tmp1_;
	_tmp2_ = output;
	output = NULL;
	g_value_init (&_tmp3_, G_TYPE_STRING);
	g_value_take_string (&_tmp3_, _tmp2_);
	G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	_vala_dest = _tmp3_;
	_g_free0 (output);
	if (dest) {
		*dest = _vala_dest;
	} else {
		G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest) {
	GValue _vala_dest = {0};
	GValue _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* store;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* output;
	gchar* _tmp9_;
	GValue _tmp10_ = {0};
	g_return_if_fail (src != NULL);
	_tmp0_ = *src;
	_tmp1_ = _g_object_ref0 (g_value_get_object (&_tmp0_));
	store = _tmp1_;
	_tmp2_ = folks_persona_store_get_type_id (store);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_persona_store_get_id (store);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_persona_store_get_display_name (store);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%p: %s, %s (%s)", store, _tmp3_, _tmp5_, _tmp7_);
	output = _tmp8_;
	_tmp9_ = output;
	output = NULL;
	g_value_init (&_tmp10_, G_TYPE_STRING);
	g_value_take_string (&_tmp10_, _tmp9_);
	G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	_vala_dest = _tmp10_;
	_g_free0 (output);
	_g_object_unref0 (store);
	if (dest) {
		*dest = _vala_dest;
	} else {
		G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	}
}


static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest) {
	GValue _vala_dest = {0};
	GValue _tmp0_;
	gchar** array;
	gint array_length1;
	gint _array_size_;
	gchar* _tmp1_;
	gchar* output;
	gboolean first;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GValue _tmp15_ = {0};
	g_return_if_fail (src != NULL);
	_tmp0_ = *src;
	array = g_value_get_boxed (&_tmp0_);
	array_length1 = g_strv_length (g_value_get_boxed (&_tmp0_));
	_array_size_ = array_length1;
	_tmp1_ = g_strdup ("{ ");
	output = _tmp1_;
	first = TRUE;
	_tmp2_ = array;
	_tmp2__length1 = array_length1;
	{
		gchar** element_collection = NULL;
		gint element_collection_length1 = 0;
		gint _element_collection_size_ = 0;
		gint element_it = 0;
		element_collection = _tmp2_;
		element_collection_length1 = _tmp2__length1;
		for (element_it = 0; element_it < _tmp2__length1; element_it = element_it + 1) {
			gchar* _tmp3_;
			gchar* element = NULL;
			_tmp3_ = g_strdup (element_collection[element_it]);
			element = _tmp3_;
			{
				gboolean _tmp4_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp4_ = first;
				if (_tmp4_ == FALSE) {
					const gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp5_ = output;
					_tmp6_ = g_strconcat (_tmp5_, ", ", NULL);
					_g_free0 (output);
					output = _tmp6_;
				}
				_tmp7_ = output;
				_tmp8_ = element;
				_tmp9_ = g_strdup_printf ("'%s'", _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat (_tmp7_, _tmp10_, NULL);
				_g_free0 (output);
				output = _tmp11_;
				_g_free0 (_tmp10_);
				first = FALSE;
				_g_free0 (element);
			}
		}
	}
	_tmp12_ = output;
	_tmp13_ = g_strconcat (_tmp12_, " }", NULL);
	_g_free0 (output);
	output = _tmp13_;
	_tmp14_ = output;
	output = NULL;
	g_value_init (&_tmp15_, G_TYPE_STRING);
	g_value_take_string (&_tmp15_, _tmp14_);
	G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	_vala_dest = _tmp15_;
	_g_free0 (output);
	if (dest) {
		*dest = _vala_dest;
	} else {
		G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	}
}


void folks_inspect_utils_indent (void) {
	guint _tmp0_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	_tmp0_ = folks_inspect_utils_indentation;
	folks_inspect_utils_indentation = _tmp0_ + 2;
	_tmp1_ = folks_inspect_utils_indentation;
	_tmp2_ = g_strnfill ((gsize) _tmp1_, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp2_;
}


void folks_inspect_utils_unindent (void) {
	guint _tmp0_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	_tmp0_ = folks_inspect_utils_indentation;
	folks_inspect_utils_indentation = _tmp0_ - 2;
	_tmp1_ = folks_inspect_utils_indentation;
	_tmp2_ = g_strnfill ((gsize) _tmp1_, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp2_;
}


void folks_inspect_utils_print_line (const gchar* format, ...) {
	va_list valist = {0};
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* output;
	FILE* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (format != NULL);
	va_start (valist, format);
	_tmp0_ = format;
	_tmp1_ = g_strdup_vprintf (_tmp0_, valist);
	output = _tmp1_;
	_tmp2_ = stdout;
	_tmp3_ = folks_inspect_utils_indentation_string;
	fprintf (_tmp2_, "%s%s\n", _tmp3_, output);
	_g_free0 (output);
	va_end (valist);
}


void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas) {
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksIndividual* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	FolksIndividual* _tmp8_;
	GObjectClass* _tmp9_ = NULL;
	guint _tmp10_;
	GParamSpec** _tmp11_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp12_;
	gint _tmp12__length1;
	gboolean _tmp33_;
	g_return_if_fail (individual != NULL);
	_tmp0_ = individual;
	_tmp1_ = folks_individual_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = individual;
	_tmp4_ = folks_individual_get_personas (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	folks_inspect_utils_print_line ("Individual '%s' with %u personas:", _tmp2_, (guint) _tmp7_);
	_tmp8_ = individual;
	_tmp9_ = G_OBJECT_GET_CLASS ((GObject*) _tmp8_);
	_tmp11_ = g_object_class_list_properties (_tmp9_, &_tmp10_);
	properties = _tmp11_;
	properties_length1 = _tmp10_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp12_ = properties;
	_tmp12__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp12_;
		pspec_collection_length1 = _tmp12__length1;
		for (pspec_it = 0; pspec_it < _tmp12__length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_;
				gboolean _tmp17_;
				GParamSpec* _tmp18_;
				GType _tmp19_;
				GValue _tmp20_ = {0};
				FolksIndividual* _tmp21_;
				GParamSpec* _tmp22_;
				const gchar* _tmp23_ = NULL;
				FolksIndividual* _tmp24_;
				GType _tmp25_ = 0UL;
				GParamSpec* _tmp26_;
				const gchar* _tmp27_ = NULL;
				GValue _tmp28_;
				gchar* _tmp29_ = NULL;
				GParamSpec* _tmp30_;
				const gchar* _tmp31_ = NULL;
				const gchar* _tmp32_;
				_tmp14_ = show_personas;
				if (_tmp14_ == TRUE) {
					GParamSpec* _tmp15_;
					const gchar* _tmp16_ = NULL;
					_tmp15_ = pspec;
					_tmp16_ = g_param_spec_get_name (_tmp15_);
					_tmp13_ = g_strcmp0 (_tmp16_, "personas") == 0;
				} else {
					_tmp13_ = FALSE;
				}
				_tmp17_ = _tmp13_;
				if (_tmp17_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				_tmp18_ = pspec;
				_tmp19_ = _tmp18_->value_type;
				g_value_init (&_tmp20_, _tmp19_);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp20_;
				_tmp21_ = individual;
				_tmp22_ = pspec;
				_tmp23_ = g_param_spec_get_name (_tmp22_);
				g_object_get_property ((GObject*) _tmp21_, _tmp23_, &prop_value);
				_tmp24_ = individual;
				_tmp25_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp24_);
				_tmp26_ = pspec;
				_tmp27_ = g_param_spec_get_name (_tmp26_);
				_tmp28_ = prop_value;
				_tmp29_ = folks_inspect_utils_property_to_string (_tmp25_, _tmp27_, &_tmp28_);
				_g_free0 (output_string);
				output_string = _tmp29_;
				_tmp30_ = pspec;
				_tmp31_ = g_param_spec_get_nick (_tmp30_);
				_tmp32_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp31_, _tmp32_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	_tmp33_ = show_personas;
	if (_tmp33_ == TRUE) {
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		{
			FolksIndividual* _tmp34_;
			GeeSet* _tmp35_;
			GeeSet* _tmp36_;
			GeeIterator* _tmp37_ = NULL;
			GeeIterator* _persona_it;
			_tmp34_ = individual;
			_tmp35_ = folks_individual_get_personas (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = gee_iterable_iterator ((GeeIterable*) _tmp36_);
			_persona_it = _tmp37_;
			while (TRUE) {
				GeeIterator* _tmp38_;
				gboolean _tmp39_ = FALSE;
				GeeIterator* _tmp40_;
				gpointer _tmp41_ = NULL;
				FolksPersona* persona;
				FolksPersona* _tmp42_;
				_tmp38_ = _persona_it;
				_tmp39_ = gee_iterator_next (_tmp38_);
				if (!_tmp39_) {
					break;
				}
				_tmp40_ = _persona_it;
				_tmp41_ = gee_iterator_get (_tmp40_);
				persona = (FolksPersona*) _tmp41_;
				_tmp42_ = persona;
				folks_inspect_utils_print_persona (_tmp42_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
}


void folks_inspect_utils_print_persona (FolksPersona* persona) {
	FolksPersona* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksPersona* _tmp3_;
	GObjectClass* _tmp4_ = NULL;
	guint _tmp5_;
	GParamSpec** _tmp6_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (persona != NULL);
	_tmp0_ = persona;
	_tmp1_ = folks_persona_get_uid (_tmp0_);
	_tmp2_ = _tmp1_;
	folks_inspect_utils_print_line ("Persona '%s':", _tmp2_);
	_tmp3_ = persona;
	_tmp4_ = G_OBJECT_GET_CLASS ((GObject*) _tmp3_);
	_tmp6_ = g_object_class_list_properties (_tmp4_, &_tmp5_);
	properties = _tmp6_;
	properties_length1 = _tmp5_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp7_ = properties;
	_tmp7__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp7_;
		pspec_collection_length1 = _tmp7__length1;
		for (pspec_it = 0; pspec_it < _tmp7__length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				GParamSpec* _tmp8_;
				GType _tmp9_;
				GValue _tmp10_ = {0};
				FolksPersona* _tmp11_;
				GParamSpec* _tmp12_;
				const gchar* _tmp13_ = NULL;
				FolksPersona* _tmp14_;
				GType _tmp15_ = 0UL;
				GParamSpec* _tmp16_;
				const gchar* _tmp17_ = NULL;
				GValue _tmp18_;
				gchar* _tmp19_ = NULL;
				GParamSpec* _tmp20_;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_;
				_tmp8_ = pspec;
				_tmp9_ = _tmp8_->value_type;
				g_value_init (&_tmp10_, _tmp9_);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp10_;
				_tmp11_ = persona;
				_tmp12_ = pspec;
				_tmp13_ = g_param_spec_get_name (_tmp12_);
				g_object_get_property ((GObject*) _tmp11_, _tmp13_, &prop_value);
				_tmp14_ = persona;
				_tmp15_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp14_);
				_tmp16_ = pspec;
				_tmp17_ = g_param_spec_get_name (_tmp16_);
				_tmp18_ = prop_value;
				_tmp19_ = folks_inspect_utils_property_to_string (_tmp15_, _tmp17_, &_tmp18_);
				_g_free0 (output_string);
				output_string = _tmp19_;
				_tmp20_ = pspec;
				_tmp21_ = g_param_spec_get_nick (_tmp20_);
				_tmp22_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp21_, _tmp22_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
}


void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas) {
	FolksPersonaStore* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FolksPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	FolksPersonaStore* _tmp9_;
	GeeMap* _tmp10_;
	GeeMap* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	FolksPersonaStore* _tmp14_;
	GObjectClass* _tmp15_ = NULL;
	guint _tmp16_;
	GParamSpec** _tmp17_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp18_;
	gint _tmp18__length1;
	gboolean _tmp39_;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = folks_persona_store_get_is_prepared (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == FALSE) {
		FolksPersonaStore* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = store;
		_tmp4_ = folks_persona_store_get_id (_tmp3_);
		_tmp5_ = _tmp4_;
		folks_inspect_utils_print_line ("Persona store '%s':", _tmp5_);
		folks_inspect_utils_indent ();
		folks_inspect_utils_print_line ("Not prepared.");
		folks_inspect_utils_unindent ();
		return;
	}
	_tmp6_ = store;
	_tmp7_ = folks_persona_store_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = store;
	_tmp10_ = folks_persona_store_get_personas (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_map_get_size (_tmp11_);
	_tmp13_ = _tmp12_;
	folks_inspect_utils_print_line ("Persona store '%s' with %u personas:", _tmp8_, (guint) _tmp13_);
	_tmp14_ = store;
	_tmp15_ = G_OBJECT_GET_CLASS ((GObject*) _tmp14_);
	_tmp17_ = g_object_class_list_properties (_tmp15_, &_tmp16_);
	properties = _tmp17_;
	properties_length1 = _tmp16_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp18_ = properties;
	_tmp18__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp18_;
		pspec_collection_length1 = _tmp18__length1;
		for (pspec_it = 0; pspec_it < _tmp18__length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_;
				gboolean _tmp23_;
				GParamSpec* _tmp24_;
				GType _tmp25_;
				GValue _tmp26_ = {0};
				FolksPersonaStore* _tmp27_;
				GParamSpec* _tmp28_;
				const gchar* _tmp29_ = NULL;
				FolksPersonaStore* _tmp30_;
				GType _tmp31_ = 0UL;
				GParamSpec* _tmp32_;
				const gchar* _tmp33_ = NULL;
				GValue _tmp34_;
				gchar* _tmp35_ = NULL;
				GParamSpec* _tmp36_;
				const gchar* _tmp37_ = NULL;
				const gchar* _tmp38_;
				_tmp20_ = show_personas;
				if (_tmp20_ == TRUE) {
					GParamSpec* _tmp21_;
					const gchar* _tmp22_ = NULL;
					_tmp21_ = pspec;
					_tmp22_ = g_param_spec_get_name (_tmp21_);
					_tmp19_ = g_strcmp0 (_tmp22_, "personas") == 0;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp23_ = _tmp19_;
				if (_tmp23_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				_tmp24_ = pspec;
				_tmp25_ = _tmp24_->value_type;
				g_value_init (&_tmp26_, _tmp25_);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp26_;
				_tmp27_ = store;
				_tmp28_ = pspec;
				_tmp29_ = g_param_spec_get_name (_tmp28_);
				g_object_get_property ((GObject*) _tmp27_, _tmp29_, &prop_value);
				_tmp30_ = store;
				_tmp31_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp30_);
				_tmp32_ = pspec;
				_tmp33_ = g_param_spec_get_name (_tmp32_);
				_tmp34_ = prop_value;
				_tmp35_ = folks_inspect_utils_property_to_string (_tmp31_, _tmp33_, &_tmp34_);
				_g_free0 (output_string);
				output_string = _tmp35_;
				_tmp36_ = pspec;
				_tmp37_ = g_param_spec_get_nick (_tmp36_);
				_tmp38_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp37_, _tmp38_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	_tmp39_ = show_personas;
	if (_tmp39_ == TRUE) {
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		{
			FolksPersonaStore* _tmp40_;
			GeeMap* _tmp41_;
			GeeMap* _tmp42_;
			GeeCollection* _tmp43_;
			GeeCollection* _tmp44_;
			GeeCollection* _tmp45_;
			GeeIterator* _tmp46_ = NULL;
			GeeIterator* _tmp47_;
			GeeIterator* _persona_it;
			_tmp40_ = store;
			_tmp41_ = folks_persona_store_get_personas (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = gee_map_get_values (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = _tmp44_;
			_tmp46_ = gee_iterable_iterator ((GeeIterable*) _tmp45_);
			_tmp47_ = _tmp46_;
			_g_object_unref0 (_tmp45_);
			_persona_it = _tmp47_;
			while (TRUE) {
				GeeIterator* _tmp48_;
				gboolean _tmp49_ = FALSE;
				GeeIterator* _tmp50_;
				gpointer _tmp51_ = NULL;
				FolksPersona* persona;
				FolksPersona* _tmp52_;
				_tmp48_ = _persona_it;
				_tmp49_ = gee_iterator_next (_tmp48_);
				if (!_tmp49_) {
					break;
				}
				_tmp50_ = _persona_it;
				_tmp51_ = gee_iterator_get (_tmp50_);
				persona = (FolksPersona*) _tmp51_;
				_tmp52_ = persona;
				folks_inspect_utils_print_persona (_tmp52_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value) {
	gchar* result = NULL;
	gchar* output_string = NULL;
	gboolean _tmp0_ = FALSE;
	GType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_;
	GValue _tmp213_;
	gchar* _tmp214_ = NULL;
	g_return_val_if_fail (prop_name != NULL, NULL);
	g_return_val_if_fail (prop_value != NULL, NULL);
	_tmp1_ = object_type;
	_tmp2_ = g_type_is_a (_tmp1_, FOLKS_TYPE_INDIVIDUAL);
	if (_tmp2_) {
		const gchar* _tmp3_;
		_tmp3_ = prop_name;
		_tmp0_ = g_strcmp0 (_tmp3_, "personas") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		GObject* _tmp5_ = NULL;
		GeeSet* _tmp6_;
		GeeSet* personas;
		GeeSet* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_ = NULL;
		_tmp5_ = g_value_get_object (prop_value);
		_tmp6_ = _g_object_ref0 (GEE_SET (_tmp5_));
		personas = _tmp6_;
		_tmp7_ = personas;
		_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("List of %u personas", (guint) _tmp9_);
		result = _tmp10_;
		_g_object_unref0 (personas);
		_g_free0 (output_string);
		return result;
	} else {
		gboolean _tmp11_ = FALSE;
		GType _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp15_;
		_tmp12_ = object_type;
		_tmp13_ = g_type_is_a (_tmp12_, FOLKS_TYPE_PERSONA_STORE);
		if (_tmp13_) {
			const gchar* _tmp14_;
			_tmp14_ = prop_name;
			_tmp11_ = g_strcmp0 (_tmp14_, "personas") == 0;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp15_ = _tmp11_;
		if (_tmp15_) {
			GObject* _tmp16_ = NULL;
			GeeMap* _tmp17_;
			GeeMap* personas;
			GeeMap* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gchar* _tmp21_ = NULL;
			_tmp16_ = g_value_get_object (prop_value);
			_tmp17_ = _g_object_ref0 (GEE_MAP (_tmp16_));
			personas = _tmp17_;
			_tmp18_ = personas;
			_tmp19_ = gee_map_get_size (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strdup_printf ("Set of %u personas", (guint) _tmp20_);
			result = _tmp21_;
			_g_object_unref0 (personas);
			_g_free0 (output_string);
			return result;
		} else {
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_;
			gboolean _tmp25_;
			_tmp23_ = prop_name;
			if (g_strcmp0 (_tmp23_, "groups") == 0) {
				_tmp22_ = TRUE;
			} else {
				const gchar* _tmp24_;
				_tmp24_ = prop_name;
				_tmp22_ = g_strcmp0 (_tmp24_, "local-ids") == 0;
			}
			_tmp25_ = _tmp22_;
			if (_tmp25_) {
				GObject* _tmp26_ = NULL;
				GeeSet* _tmp27_;
				GeeSet* groups;
				gchar* _tmp28_;
				gboolean first;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp26_ = g_value_get_object (prop_value);
				_tmp27_ = _g_object_ref0 (GEE_SET (_tmp26_));
				groups = _tmp27_;
				_tmp28_ = g_strdup ("{ ");
				_g_free0 (output_string);
				output_string = _tmp28_;
				first = TRUE;
				{
					GeeSet* _tmp29_;
					GeeIterator* _tmp30_ = NULL;
					GeeIterator* _group_it;
					_tmp29_ = groups;
					_tmp30_ = gee_iterable_iterator ((GeeIterable*) _tmp29_);
					_group_it = _tmp30_;
					while (TRUE) {
						GeeIterator* _tmp31_;
						gboolean _tmp32_ = FALSE;
						GeeIterator* _tmp33_;
						gpointer _tmp34_ = NULL;
						gchar* group;
						gboolean _tmp35_;
						const gchar* _tmp38_;
						const gchar* _tmp39_;
						gchar* _tmp40_ = NULL;
						gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp31_ = _group_it;
						_tmp32_ = gee_iterator_next (_tmp31_);
						if (!_tmp32_) {
							break;
						}
						_tmp33_ = _group_it;
						_tmp34_ = gee_iterator_get (_tmp33_);
						group = (gchar*) _tmp34_;
						_tmp35_ = first;
						if (_tmp35_ == FALSE) {
							const gchar* _tmp36_;
							gchar* _tmp37_;
							_tmp36_ = output_string;
							_tmp37_ = g_strconcat (_tmp36_, ", ", NULL);
							_g_free0 (output_string);
							output_string = _tmp37_;
						}
						_tmp38_ = output_string;
						_tmp39_ = group;
						_tmp40_ = g_strdup_printf ("'%s'", _tmp39_);
						_tmp41_ = _tmp40_;
						_tmp42_ = g_strconcat (_tmp38_, _tmp41_, NULL);
						_g_free0 (output_string);
						output_string = _tmp42_;
						_g_free0 (_tmp41_);
						first = FALSE;
						_g_free0 (group);
					}
					_g_object_unref0 (_group_it);
				}
				_tmp43_ = output_string;
				_tmp44_ = g_strconcat (_tmp43_, " }", NULL);
				_g_free0 (output_string);
				output_string = _tmp44_;
				result = output_string;
				_g_object_unref0 (groups);
				return result;
			} else {
				const gchar* _tmp45_;
				_tmp45_ = prop_name;
				if (g_strcmp0 (_tmp45_, "avatar") == 0) {
					gchar* ret;
					GObject* _tmp46_ = NULL;
					GLoadableIcon* _tmp47_;
					GLoadableIcon* avatar;
					gboolean _tmp48_ = FALSE;
					gboolean _tmp49_ = FALSE;
					GLoadableIcon* _tmp50_;
					gboolean _tmp52_;
					gboolean _tmp55_;
					ret = NULL;
					_tmp46_ = g_value_get_object (prop_value);
					_tmp47_ = _g_object_ref0 (G_LOADABLE_ICON (_tmp46_));
					avatar = _tmp47_;
					_tmp50_ = avatar;
					if (_tmp50_ != NULL) {
						GLoadableIcon* _tmp51_;
						_tmp51_ = avatar;
						_tmp49_ = G_IS_FILE_ICON (_tmp51_);
					} else {
						_tmp49_ = FALSE;
					}
					_tmp52_ = _tmp49_;
					if (_tmp52_) {
						GLoadableIcon* _tmp53_;
						GFile* _tmp54_ = NULL;
						_tmp53_ = avatar;
						_tmp54_ = g_file_icon_get_file (G_FILE_ICON (_tmp53_));
						_tmp48_ = _tmp54_ != NULL;
					} else {
						_tmp48_ = FALSE;
					}
					_tmp55_ = _tmp48_;
					if (_tmp55_) {
						GLoadableIcon* _tmp56_;
						GLoadableIcon* _tmp57_;
						GFile* _tmp58_ = NULL;
						gchar* _tmp59_ = NULL;
						gchar* _tmp60_;
						gchar* _tmp61_ = NULL;
						_tmp56_ = avatar;
						_tmp57_ = avatar;
						_tmp58_ = g_file_icon_get_file (G_FILE_ICON (_tmp57_));
						_tmp59_ = g_file_get_uri (_tmp58_);
						_tmp60_ = _tmp59_;
						_tmp61_ = g_strdup_printf ("%p (file: %s)", _tmp56_, _tmp60_);
						_g_free0 (ret);
						ret = _tmp61_;
						_g_free0 (_tmp60_);
					} else {
						GLoadableIcon* _tmp62_;
						_tmp62_ = avatar;
						if (_tmp62_ != NULL) {
							GLoadableIcon* _tmp63_;
							gchar* _tmp64_ = NULL;
							_tmp63_ = avatar;
							_tmp64_ = g_strdup_printf ("%p", _tmp63_);
							_g_free0 (ret);
							ret = _tmp64_;
						}
					}
					result = ret;
					_g_object_unref0 (avatar);
					_g_free0 (output_string);
					return result;
				} else {
					gboolean _tmp65_ = FALSE;
					const gchar* _tmp66_;
					gboolean _tmp68_;
					_tmp66_ = prop_name;
					if (g_strcmp0 (_tmp66_, "im-addresses") == 0) {
						_tmp65_ = TRUE;
					} else {
						const gchar* _tmp67_;
						_tmp67_ = prop_name;
						_tmp65_ = g_strcmp0 (_tmp67_, "web-service-addresses") == 0;
					}
					_tmp68_ = _tmp65_;
					if (_tmp68_) {
						GObject* _tmp69_ = NULL;
						GeeMultiMap* _tmp70_;
						GeeMultiMap* prop_list;
						gchar* _tmp71_;
						gboolean first;
						const gchar* _tmp110_;
						gchar* _tmp111_;
						_tmp69_ = g_value_get_object (prop_value);
						_tmp70_ = _g_object_ref0 (GEE_MULTI_MAP (_tmp69_));
						prop_list = _tmp70_;
						_tmp71_ = g_strdup ("{ ");
						_g_free0 (output_string);
						output_string = _tmp71_;
						first = TRUE;
						{
							GeeMultiMap* _tmp72_;
							GeeSet* _tmp73_ = NULL;
							GeeSet* _tmp74_;
							GeeIterator* _tmp75_ = NULL;
							GeeIterator* _tmp76_;
							GeeIterator* _k_it;
							_tmp72_ = prop_list;
							_tmp73_ = gee_multi_map_get_keys (_tmp72_);
							_tmp74_ = _tmp73_;
							_tmp75_ = gee_iterable_iterator ((GeeIterable*) _tmp74_);
							_tmp76_ = _tmp75_;
							_g_object_unref0 (_tmp74_);
							_k_it = _tmp76_;
							while (TRUE) {
								GeeIterator* _tmp77_;
								gboolean _tmp78_ = FALSE;
								GeeIterator* _tmp79_;
								gpointer _tmp80_ = NULL;
								gchar* k;
								gboolean _tmp81_;
								const gchar* _tmp84_;
								const gchar* _tmp85_;
								gchar* _tmp86_ = NULL;
								gchar* _tmp87_;
								gchar* _tmp88_;
								GeeMultiMap* _tmp89_;
								const gchar* _tmp90_;
								GeeCollection* _tmp91_ = NULL;
								GeeCollection* v;
								gboolean _first;
								const gchar* _tmp108_;
								gchar* _tmp109_;
								_tmp77_ = _k_it;
								_tmp78_ = gee_iterator_next (_tmp77_);
								if (!_tmp78_) {
									break;
								}
								_tmp79_ = _k_it;
								_tmp80_ = gee_iterator_get (_tmp79_);
								k = (gchar*) _tmp80_;
								_tmp81_ = first;
								if (_tmp81_ == FALSE) {
									const gchar* _tmp82_;
									gchar* _tmp83_;
									_tmp82_ = output_string;
									_tmp83_ = g_strconcat (_tmp82_, ", ", NULL);
									_g_free0 (output_string);
									output_string = _tmp83_;
								}
								_tmp84_ = output_string;
								_tmp85_ = k;
								_tmp86_ = g_strdup_printf ("'%s' : { ", _tmp85_);
								_tmp87_ = _tmp86_;
								_tmp88_ = g_strconcat (_tmp84_, _tmp87_, NULL);
								_g_free0 (output_string);
								output_string = _tmp88_;
								_g_free0 (_tmp87_);
								first = FALSE;
								_tmp89_ = prop_list;
								_tmp90_ = k;
								_tmp91_ = gee_multi_map_get (_tmp89_, _tmp90_);
								v = _tmp91_;
								_first = TRUE;
								{
									GeeCollection* _tmp92_;
									GeeIterator* _tmp93_ = NULL;
									GeeIterator* _a_it;
									_tmp92_ = v;
									_tmp93_ = gee_iterable_iterator ((GeeIterable*) _tmp92_);
									_a_it = _tmp93_;
									while (TRUE) {
										GeeIterator* _tmp94_;
										gboolean _tmp95_ = FALSE;
										GeeIterator* _tmp96_;
										gpointer _tmp97_ = NULL;
										FolksAbstractFieldDetails* a;
										gboolean _tmp98_;
										const gchar* _tmp101_;
										FolksAbstractFieldDetails* _tmp102_;
										gconstpointer _tmp103_;
										const gchar* _tmp104_;
										gchar* _tmp105_ = NULL;
										gchar* _tmp106_;
										gchar* _tmp107_;
										_tmp94_ = _a_it;
										_tmp95_ = gee_iterator_next (_tmp94_);
										if (!_tmp95_) {
											break;
										}
										_tmp96_ = _a_it;
										_tmp97_ = gee_iterator_get (_tmp96_);
										a = (FolksAbstractFieldDetails*) _tmp97_;
										_tmp98_ = _first;
										if (_tmp98_ == FALSE) {
											const gchar* _tmp99_;
											gchar* _tmp100_;
											_tmp99_ = output_string;
											_tmp100_ = g_strconcat (_tmp99_, ", ", NULL);
											_g_free0 (output_string);
											output_string = _tmp100_;
										}
										_tmp101_ = output_string;
										_tmp102_ = a;
										_tmp103_ = folks_abstract_field_details_get_value (_tmp102_);
										_tmp104_ = _tmp103_;
										_tmp105_ = g_strdup_printf ("'%s'", (const gchar*) _tmp104_);
										_tmp106_ = _tmp105_;
										_tmp107_ = g_strconcat (_tmp101_, _tmp106_, NULL);
										_g_free0 (output_string);
										output_string = _tmp107_;
										_g_free0 (_tmp106_);
										_first = FALSE;
										_g_object_unref0 (a);
									}
									_g_object_unref0 (_a_it);
								}
								_tmp108_ = output_string;
								_tmp109_ = g_strconcat (_tmp108_, " }", NULL);
								_g_free0 (output_string);
								output_string = _tmp109_;
								_g_object_unref0 (v);
								_g_free0 (k);
							}
							_g_object_unref0 (_k_it);
						}
						_tmp110_ = output_string;
						_tmp111_ = g_strconcat (_tmp110_, " }", NULL);
						_g_free0 (output_string);
						output_string = _tmp111_;
						result = output_string;
						_g_object_unref0 (prop_list);
						return result;
					} else {
						gboolean _tmp112_ = FALSE;
						gboolean _tmp113_ = FALSE;
						const gchar* _tmp114_;
						gboolean _tmp116_;
						gboolean _tmp118_;
						_tmp114_ = prop_name;
						if (g_strcmp0 (_tmp114_, "email-addresses") == 0) {
							_tmp113_ = TRUE;
						} else {
							const gchar* _tmp115_;
							_tmp115_ = prop_name;
							_tmp113_ = g_strcmp0 (_tmp115_, "phone-numbers") == 0;
						}
						_tmp116_ = _tmp113_;
						if (_tmp116_) {
							_tmp112_ = TRUE;
						} else {
							const gchar* _tmp117_;
							_tmp117_ = prop_name;
							_tmp112_ = g_strcmp0 (_tmp117_, "urls") == 0;
						}
						_tmp118_ = _tmp112_;
						if (_tmp118_) {
							gchar* _tmp119_;
							gboolean first;
							GObject* _tmp120_ = NULL;
							GeeSet* _tmp121_;
							GeeSet* prop_list;
							const gchar* _tmp136_;
							gchar* _tmp137_;
							_tmp119_ = g_strdup ("{ ");
							_g_free0 (output_string);
							output_string = _tmp119_;
							first = TRUE;
							_tmp120_ = g_value_get_object (prop_value);
							_tmp121_ = _g_object_ref0 (GEE_SET (_tmp120_));
							prop_list = _tmp121_;
							{
								GeeSet* _tmp122_;
								GeeIterator* _tmp123_ = NULL;
								GeeIterator* _p_it;
								_tmp122_ = prop_list;
								_tmp123_ = gee_iterable_iterator ((GeeIterable*) _tmp122_);
								_p_it = _tmp123_;
								while (TRUE) {
									GeeIterator* _tmp124_;
									gboolean _tmp125_ = FALSE;
									GeeIterator* _tmp126_;
									gpointer _tmp127_ = NULL;
									FolksAbstractFieldDetails* p;
									gboolean _tmp128_;
									const gchar* _tmp131_;
									FolksAbstractFieldDetails* _tmp132_;
									gconstpointer _tmp133_;
									const gchar* _tmp134_;
									gchar* _tmp135_;
									_tmp124_ = _p_it;
									_tmp125_ = gee_iterator_next (_tmp124_);
									if (!_tmp125_) {
										break;
									}
									_tmp126_ = _p_it;
									_tmp127_ = gee_iterator_get (_tmp126_);
									p = (FolksAbstractFieldDetails*) _tmp127_;
									_tmp128_ = first;
									if (!_tmp128_) {
										const gchar* _tmp129_;
										gchar* _tmp130_;
										_tmp129_ = output_string;
										_tmp130_ = g_strconcat (_tmp129_, ", ", NULL);
										_g_free0 (output_string);
										output_string = _tmp130_;
									}
									_tmp131_ = output_string;
									_tmp132_ = p;
									_tmp133_ = folks_abstract_field_details_get_value (_tmp132_);
									_tmp134_ = _tmp133_;
									_tmp135_ = g_strconcat (_tmp131_, (const gchar*) _tmp134_, NULL);
									_g_free0 (output_string);
									output_string = _tmp135_;
									first = FALSE;
									_g_object_unref0 (p);
								}
								_g_object_unref0 (_p_it);
							}
							_tmp136_ = output_string;
							_tmp137_ = g_strconcat (_tmp136_, " }", NULL);
							_g_free0 (output_string);
							output_string = _tmp137_;
							result = output_string;
							_g_object_unref0 (prop_list);
							return result;
						} else {
							const gchar* _tmp138_;
							_tmp138_ = prop_name;
							if (g_strcmp0 (_tmp138_, "birthday") == 0) {
								void* _tmp139_ = NULL;
								GDateTime* dobj;
								GDateTime* _tmp140_;
								_tmp139_ = g_value_get_boxed (prop_value);
								dobj = (GDateTime*) _tmp139_;
								_tmp140_ = dobj;
								if (_tmp140_ != NULL) {
									GDateTime* _tmp141_;
									gchar* _tmp142_ = NULL;
									_tmp141_ = dobj;
									_tmp142_ = g_date_time_to_string (_tmp141_);
									result = _tmp142_;
									_g_free0 (output_string);
									return result;
								} else {
									gchar* _tmp143_;
									_tmp143_ = g_strdup ("");
									result = _tmp143_;
									_g_free0 (output_string);
									return result;
								}
							} else {
								const gchar* _tmp144_;
								_tmp144_ = prop_name;
								if (g_strcmp0 (_tmp144_, "postal-addresses") == 0) {
									gchar* _tmp145_;
									gboolean first;
									GObject* _tmp146_ = NULL;
									GeeSet* _tmp147_;
									GeeSet* prop_list;
									const gchar* _tmp164_;
									gchar* _tmp165_;
									_tmp145_ = g_strdup ("{ ");
									_g_free0 (output_string);
									output_string = _tmp145_;
									first = TRUE;
									_tmp146_ = g_value_get_object (prop_value);
									_tmp147_ = _g_object_ref0 (GEE_SET (_tmp146_));
									prop_list = _tmp147_;
									{
										GeeSet* _tmp148_;
										GeeIterator* _tmp149_ = NULL;
										GeeIterator* _p_it;
										_tmp148_ = prop_list;
										_tmp149_ = gee_iterable_iterator ((GeeIterable*) _tmp148_);
										_p_it = _tmp149_;
										while (TRUE) {
											GeeIterator* _tmp150_;
											gboolean _tmp151_ = FALSE;
											GeeIterator* _tmp152_;
											gpointer _tmp153_ = NULL;
											FolksPostalAddressFieldDetails* p;
											gboolean _tmp154_;
											const gchar* _tmp157_;
											FolksPostalAddressFieldDetails* _tmp158_;
											gconstpointer _tmp159_;
											FolksPostalAddress* _tmp160_;
											gchar* _tmp161_ = NULL;
											gchar* _tmp162_;
											gchar* _tmp163_;
											_tmp150_ = _p_it;
											_tmp151_ = gee_iterator_next (_tmp150_);
											if (!_tmp151_) {
												break;
											}
											_tmp152_ = _p_it;
											_tmp153_ = gee_iterator_get (_tmp152_);
											p = (FolksPostalAddressFieldDetails*) _tmp153_;
											_tmp154_ = first;
											if (!_tmp154_) {
												const gchar* _tmp155_;
												gchar* _tmp156_;
												_tmp155_ = output_string;
												_tmp156_ = g_strconcat (_tmp155_, ". ", NULL);
												_g_free0 (output_string);
												output_string = _tmp156_;
											}
											_tmp157_ = output_string;
											_tmp158_ = p;
											_tmp159_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp158_);
											_tmp160_ = _tmp159_;
											_tmp161_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp160_);
											_tmp162_ = _tmp161_;
											_tmp163_ = g_strconcat (_tmp157_, _tmp162_, NULL);
											_g_free0 (output_string);
											output_string = _tmp163_;
											_g_free0 (_tmp162_);
											first = FALSE;
											_g_object_unref0 (p);
										}
										_g_object_unref0 (_p_it);
									}
									_tmp164_ = output_string;
									_tmp165_ = g_strconcat (_tmp164_, " }", NULL);
									_g_free0 (output_string);
									output_string = _tmp165_;
									result = output_string;
									_g_object_unref0 (prop_list);
									return result;
								} else {
									const gchar* _tmp166_;
									_tmp166_ = prop_name;
									if (g_strcmp0 (_tmp166_, "notes") == 0) {
										GObject* _tmp167_ = NULL;
										GeeSet* _tmp168_;
										GeeSet* notes;
										gchar* _tmp169_;
										gboolean first;
										const gchar* _tmp184_;
										gchar* _tmp185_;
										_tmp167_ = g_value_get_object (prop_value);
										_tmp168_ = _g_object_ref0 (GEE_IS_SET (_tmp167_) ? ((GeeSet*) _tmp167_) : NULL);
										notes = _tmp168_;
										_tmp169_ = g_strdup ("{ ");
										_g_free0 (output_string);
										output_string = _tmp169_;
										first = TRUE;
										{
											GeeSet* _tmp170_;
											GeeIterator* _tmp171_ = NULL;
											GeeIterator* _note_it;
											_tmp170_ = notes;
											_tmp171_ = gee_iterable_iterator ((GeeIterable*) _tmp170_);
											_note_it = _tmp171_;
											while (TRUE) {
												GeeIterator* _tmp172_;
												gboolean _tmp173_ = FALSE;
												GeeIterator* _tmp174_;
												gpointer _tmp175_ = NULL;
												FolksNoteFieldDetails* note;
												gboolean _tmp176_;
												const gchar* _tmp179_;
												FolksNoteFieldDetails* _tmp180_;
												const gchar* _tmp181_;
												const gchar* _tmp182_;
												gchar* _tmp183_;
												_tmp172_ = _note_it;
												_tmp173_ = gee_iterator_next (_tmp172_);
												if (!_tmp173_) {
													break;
												}
												_tmp174_ = _note_it;
												_tmp175_ = gee_iterator_get (_tmp174_);
												note = (FolksNoteFieldDetails*) _tmp175_;
												_tmp176_ = first;
												if (!_tmp176_) {
													const gchar* _tmp177_;
													gchar* _tmp178_;
													_tmp177_ = output_string;
													_tmp178_ = g_strconcat (_tmp177_, ", ", NULL);
													_g_free0 (output_string);
													output_string = _tmp178_;
												}
												_tmp179_ = output_string;
												_tmp180_ = note;
												_tmp181_ = folks_note_field_details_get_uid (_tmp180_);
												_tmp182_ = _tmp181_;
												_tmp183_ = g_strconcat (_tmp179_, _tmp182_, NULL);
												_g_free0 (output_string);
												output_string = _tmp183_;
												first = FALSE;
												_g_object_unref0 (note);
											}
											_g_object_unref0 (_note_it);
										}
										_tmp184_ = output_string;
										_tmp185_ = g_strconcat (_tmp184_, " }", NULL);
										_g_free0 (output_string);
										output_string = _tmp185_;
										result = output_string;
										_g_object_unref0 (notes);
										return result;
									} else {
										const gchar* _tmp186_;
										_tmp186_ = prop_name;
										if (g_strcmp0 (_tmp186_, "roles") == 0) {
											GObject* _tmp187_ = NULL;
											GeeSet* _tmp188_;
											GeeSet* roles;
											gchar* _tmp189_;
											gboolean first;
											const gchar* _tmp206_;
											gchar* _tmp207_;
											_tmp187_ = g_value_get_object (prop_value);
											_tmp188_ = _g_object_ref0 (GEE_SET (_tmp187_));
											roles = _tmp188_;
											_tmp189_ = g_strdup ("{ ");
											_g_free0 (output_string);
											output_string = _tmp189_;
											first = TRUE;
											{
												GeeSet* _tmp190_;
												GeeIterator* _tmp191_ = NULL;
												GeeIterator* _role_it;
												_tmp190_ = roles;
												_tmp191_ = gee_iterable_iterator ((GeeIterable*) _tmp190_);
												_role_it = _tmp191_;
												while (TRUE) {
													GeeIterator* _tmp192_;
													gboolean _tmp193_ = FALSE;
													GeeIterator* _tmp194_;
													gpointer _tmp195_ = NULL;
													FolksRoleFieldDetails* role;
													gboolean _tmp196_;
													const gchar* _tmp199_;
													FolksRoleFieldDetails* _tmp200_;
													gconstpointer _tmp201_;
													FolksRole* _tmp202_;
													gchar* _tmp203_ = NULL;
													gchar* _tmp204_;
													gchar* _tmp205_;
													_tmp192_ = _role_it;
													_tmp193_ = gee_iterator_next (_tmp192_);
													if (!_tmp193_) {
														break;
													}
													_tmp194_ = _role_it;
													_tmp195_ = gee_iterator_get (_tmp194_);
													role = (FolksRoleFieldDetails*) _tmp195_;
													_tmp196_ = first;
													if (!_tmp196_) {
														const gchar* _tmp197_;
														gchar* _tmp198_;
														_tmp197_ = output_string;
														_tmp198_ = g_strconcat (_tmp197_, ", ", NULL);
														_g_free0 (output_string);
														output_string = _tmp198_;
													}
													_tmp199_ = output_string;
													_tmp200_ = role;
													_tmp201_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp200_);
													_tmp202_ = _tmp201_;
													_tmp203_ = folks_role_to_string ((FolksRole*) _tmp202_);
													_tmp204_ = _tmp203_;
													_tmp205_ = g_strconcat (_tmp199_, _tmp204_, NULL);
													_g_free0 (output_string);
													output_string = _tmp205_;
													_g_free0 (_tmp204_);
													first = FALSE;
													_g_object_unref0 (role);
												}
												_g_object_unref0 (_role_it);
											}
											_tmp206_ = output_string;
											_tmp207_ = g_strconcat (_tmp206_, " }", NULL);
											_g_free0 (output_string);
											output_string = _tmp207_;
											result = output_string;
											_g_object_unref0 (roles);
											return result;
										} else {
											const gchar* _tmp208_;
											_tmp208_ = prop_name;
											if (g_strcmp0 (_tmp208_, "structured-name") == 0) {
												GObject* _tmp209_ = NULL;
												FolksStructuredName* sn;
												gchar* ret;
												FolksStructuredName* _tmp210_;
												_tmp209_ = g_value_get_object (prop_value);
												sn = FOLKS_STRUCTURED_NAME (_tmp209_);
												ret = NULL;
												_tmp210_ = sn;
												if (_tmp210_ != NULL) {
													FolksStructuredName* _tmp211_;
													gchar* _tmp212_ = NULL;
													_tmp211_ = sn;
													_tmp212_ = folks_structured_name_to_string (_tmp211_);
													_g_free0 (ret);
													ret = _tmp212_;
												}
												result = ret;
												_g_free0 (output_string);
												return result;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp213_ = *prop_value;
	_tmp214_ = folks_inspect_utils_transform_value_to_string (&_tmp213_);
	result = _tmp214_;
	_g_free0 (output_string);
	return result;
}


gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value) {
	gchar* result = NULL;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (prop_value != NULL, NULL);
	_tmp0_ = G_VALUE_TYPE (prop_value);
	_tmp1_ = g_value_type_transformable (_tmp0_, G_TYPE_STRING);
	if (_tmp1_) {
		GValue _tmp2_ = {0};
		GValue string_value;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		g_value_init (&_tmp2_, G_TYPE_STRING);
		string_value = _tmp2_;
		g_value_transform (prop_value, &string_value);
		_tmp3_ = g_value_get_string (&string_value);
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		G_IS_VALUE (&string_value) ? (g_value_unset (&string_value), NULL) : NULL;
		return result;
	} else {
		GType _tmp5_ = 0UL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp5_ = G_VALUE_TYPE (prop_value);
		_tmp6_ = g_type_name (_tmp5_);
		_tmp7_ = g_type_name (G_TYPE_STRING);
		_tmp8_ = g_strdup_printf ("Can't convert from type '%s' to '%s'", _tmp6_, _tmp7_);
		result = _tmp8_;
		return result;
	}
}


gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_;
		GeeHashMap* _tmp2_;
		GeeMapIterator* _tmp3_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = _tmp1_->commands;
		_tmp3_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp2_);
		_g_object_unref0 (folks_inspect_utils_command_name_iter);
		folks_inspect_utils_command_name_iter = _tmp3_;
	}
	while (TRUE) {
		GeeMapIterator* _tmp4_;
		gboolean _tmp5_ = FALSE;
		GeeMapIterator* _tmp6_;
		gpointer _tmp7_ = NULL;
		gchar* command_name;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp4_ = folks_inspect_utils_command_name_iter;
		_tmp5_ = gee_map_iterator_next (_tmp4_);
		if (!(_tmp5_ == TRUE)) {
			break;
		}
		_tmp6_ = folks_inspect_utils_command_name_iter;
		_tmp7_ = gee_map_iterator_get_key (_tmp6_);
		command_name = (gchar*) _tmp7_;
		_tmp8_ = command_name;
		_tmp9_ = word;
		_tmp10_ = g_str_has_prefix (_tmp8_, _tmp9_);
		if (_tmp10_) {
			result = command_name;
			return result;
		}
		_g_free0 (command_name);
	}
	_g_object_unref0 (folks_inspect_utils_command_name_iter);
	folks_inspect_utils_command_name_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_;
		FolksIndividualAggregator* _tmp2_;
		FolksIndividualAggregator* _tmp3_;
		GeeMap* _tmp4_;
		GeeMap* _tmp5_;
		GeeMapIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_aggregator (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_individual_aggregator_get_individuals (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_map_map_iterator (_tmp5_);
		_g_object_unref0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp6_;
	}
	while (TRUE) {
		GeeMapIterator* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GeeMapIterator* _tmp9_;
		gpointer _tmp10_ = NULL;
		gchar* id;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp7_ = folks_inspect_utils_individual_id_iter;
		_tmp8_ = gee_map_iterator_next (_tmp7_);
		if (!(_tmp8_ == TRUE)) {
			break;
		}
		_tmp9_ = folks_inspect_utils_individual_id_iter;
		_tmp10_ = gee_map_iterator_get_key (_tmp9_);
		id = (gchar*) _tmp10_;
		_tmp11_ = id;
		_tmp12_ = word;
		_tmp13_ = g_str_has_prefix (_tmp11_, _tmp12_);
		if (_tmp13_) {
			result = id;
			return result;
		}
		_g_free0 (id);
	}
	_g_object_unref0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_;
		FolksIndividualAggregator* _tmp2_;
		FolksIndividualAggregator* _tmp3_;
		GeeMap* _tmp4_;
		GeeMap* _tmp5_;
		GeeMapIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_aggregator (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_individual_aggregator_get_individuals (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_map_map_iterator (_tmp5_);
		_g_object_unref0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp6_;
		_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
		folks_inspect_utils_persona_uid_iter = NULL;
	}
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		GeeIterator* _tmp8_;
		gboolean _tmp11_;
		GeeMapIterator* _tmp12_;
		gpointer _tmp13_ = NULL;
		FolksIndividual* individual;
		GeeIterator* _tmp14_;
		_tmp8_ = folks_inspect_utils_persona_uid_iter;
		if (_tmp8_ != NULL) {
			_tmp7_ = TRUE;
		} else {
			GeeMapIterator* _tmp9_;
			gboolean _tmp10_ = FALSE;
			_tmp9_ = folks_inspect_utils_individual_id_iter;
			_tmp10_ = gee_map_iterator_next (_tmp9_);
			_tmp7_ = _tmp10_ == TRUE;
		}
		_tmp11_ = _tmp7_;
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = folks_inspect_utils_individual_id_iter;
		_tmp13_ = gee_map_iterator_get_value (_tmp12_);
		individual = (FolksIndividual*) _tmp13_;
		_tmp14_ = folks_inspect_utils_persona_uid_iter;
		if (_tmp14_ == NULL) {
			FolksIndividual* _tmp15_;
			FolksIndividual* _tmp16_;
			GeeSet* _tmp17_;
			GeeSet* _tmp18_;
			GeeIterator* _tmp19_ = NULL;
			_tmp15_ = individual;
			g_assert (_tmp15_ != NULL);
			_tmp16_ = individual;
			_tmp17_ = folks_individual_get_personas (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
			_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
			folks_inspect_utils_persona_uid_iter = _tmp19_;
		}
		while (TRUE) {
			GeeIterator* _tmp20_;
			gboolean _tmp21_ = FALSE;
			GeeIterator* _tmp22_;
			gpointer _tmp23_ = NULL;
			FolksPersona* persona;
			FolksPersona* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gboolean _tmp28_ = FALSE;
			_tmp20_ = folks_inspect_utils_persona_uid_iter;
			_tmp21_ = gee_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = folks_inspect_utils_persona_uid_iter;
			_tmp23_ = gee_iterator_get (_tmp22_);
			persona = (FolksPersona*) _tmp23_;
			_tmp24_ = persona;
			_tmp25_ = folks_persona_get_uid (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = word;
			_tmp28_ = g_str_has_prefix (_tmp26_, _tmp27_);
			if (_tmp28_) {
				FolksPersona* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp29_ = persona;
				_tmp30_ = folks_persona_get_uid (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_strdup (_tmp31_);
				result = _tmp32_;
				_g_object_unref0 (persona);
				_g_object_unref0 (individual);
				return result;
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
		folks_inspect_utils_persona_uid_iter = NULL;
		_g_object_unref0 (individual);
	}
	_g_object_unref0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_;
		FolksBackendStore* _tmp2_;
		FolksBackendStore* _tmp3_;
		GeeCollection* _tmp4_ = NULL;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_backend_store (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_backend_store_list_backends (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp6_;
		_g_object_unref0 (_tmp5_);
	}
	while (TRUE) {
		GeeIterator* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GeeIterator* _tmp9_;
		gpointer _tmp10_ = NULL;
		FolksBackend* backend;
		FolksBackend* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp7_ = folks_inspect_utils_backend_name_iter;
		_tmp8_ = gee_iterator_next (_tmp7_);
		if (!(_tmp8_ == TRUE)) {
			break;
		}
		_tmp9_ = folks_inspect_utils_backend_name_iter;
		_tmp10_ = gee_iterator_get (_tmp9_);
		backend = (FolksBackend*) _tmp10_;
		_tmp11_ = backend;
		_tmp12_ = folks_backend_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = word;
		_tmp15_ = g_str_has_prefix (_tmp13_, _tmp14_);
		if (_tmp15_) {
			FolksBackend* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = backend;
			_tmp17_ = folks_backend_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup (_tmp18_);
			result = _tmp19_;
			_g_object_unref0 (backend);
			return result;
		}
		_g_object_unref0 (backend);
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_;
		FolksBackendStore* _tmp2_;
		FolksBackendStore* _tmp3_;
		GeeCollection* _tmp4_ = NULL;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_backend_store (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_backend_store_list_backends (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
	}
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		GeeMapIterator* _tmp8_;
		gboolean _tmp11_;
		GeeMapIterator* _tmp12_;
		_tmp8_ = folks_inspect_utils_persona_store_id_iter;
		if (_tmp8_ != NULL) {
			_tmp7_ = TRUE;
		} else {
			GeeIterator* _tmp9_;
			gboolean _tmp10_ = FALSE;
			_tmp9_ = folks_inspect_utils_backend_name_iter;
			_tmp10_ = gee_iterator_next (_tmp9_);
			_tmp7_ = _tmp10_ == TRUE;
		}
		_tmp11_ = _tmp7_;
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = folks_inspect_utils_persona_store_id_iter;
		if (_tmp12_ == NULL) {
			GeeIterator* _tmp13_;
			gpointer _tmp14_ = NULL;
			FolksBackend* backend;
			FolksBackend* _tmp15_;
			GeeMap* _tmp16_;
			GeeMap* _tmp17_;
			GeeMapIterator* _tmp18_ = NULL;
			_tmp13_ = folks_inspect_utils_backend_name_iter;
			_tmp14_ = gee_iterator_get (_tmp13_);
			backend = (FolksBackend*) _tmp14_;
			_tmp15_ = backend;
			_tmp16_ = folks_backend_get_persona_stores (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = gee_map_map_iterator (_tmp17_);
			_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
			folks_inspect_utils_persona_store_id_iter = _tmp18_;
			_g_object_unref0 (backend);
		}
		while (TRUE) {
			GeeMapIterator* _tmp19_;
			gboolean _tmp20_ = FALSE;
			GeeMapIterator* _tmp21_;
			gpointer _tmp22_ = NULL;
			gchar* id;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gboolean _tmp25_ = FALSE;
			_tmp19_ = folks_inspect_utils_persona_store_id_iter;
			_tmp20_ = gee_map_iterator_next (_tmp19_);
			if (!(_tmp20_ == TRUE)) {
				break;
			}
			_tmp21_ = folks_inspect_utils_persona_store_id_iter;
			_tmp22_ = gee_map_iterator_get_key (_tmp21_);
			id = (gchar*) _tmp22_;
			_tmp23_ = id;
			_tmp24_ = word;
			_tmp25_ = g_str_has_prefix (_tmp23_, _tmp24_);
			if (_tmp25_) {
				result = id;
				return result;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}


FolksInspectUtils* folks_inspect_utils_construct (GType object_type) {
	FolksInspectUtils* self = NULL;
	self = (FolksInspectUtils*) g_type_create_instance (object_type);
	return self;
}


FolksInspectUtils* folks_inspect_utils_new (void) {
	return folks_inspect_utils_construct (FOLKS_INSPECT_TYPE_UTILS);
}


static void folks_inspect_value_utils_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void folks_inspect_value_utils_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		folks_inspect_utils_unref (value->data[0].v_pointer);
	}
}


static void folks_inspect_value_utils_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = folks_inspect_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer folks_inspect_value_utils_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* folks_inspect_value_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FolksInspectUtils* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = folks_inspect_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* folks_inspect_value_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FolksInspectUtils** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = folks_inspect_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FolksInspectParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FOLKS_INSPECT_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer folks_inspect_value_get_utils (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}


void folks_inspect_value_set_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		folks_inspect_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


void folks_inspect_value_take_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


static void folks_inspect_utils_class_init (FolksInspectUtilsClass * klass) {
	gchar* _tmp0_;
	folks_inspect_utils_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_UTILS_CLASS (klass)->finalize = folks_inspect_utils_finalize;
	_tmp0_ = g_strdup ("");
	folks_inspect_utils_indentation_string = _tmp0_;
}


static void folks_inspect_utils_instance_init (FolksInspectUtils * self) {
	self->ref_count = 1;
}


static void folks_inspect_utils_finalize (FolksInspectUtils* obj) {
	FolksInspectUtils * self;
	self = FOLKS_INSPECT_UTILS (obj);
}


GType folks_inspect_utils_get_type (void) {
	static volatile gsize folks_inspect_utils_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { folks_inspect_value_utils_init, folks_inspect_value_utils_free_value, folks_inspect_value_utils_copy_value, folks_inspect_value_utils_peek_pointer, "p", folks_inspect_value_utils_collect_value, "p", folks_inspect_value_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectUtils), 0, (GInstanceInitFunc) folks_inspect_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType folks_inspect_utils_type_id;
		folks_inspect_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FolksInspectUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&folks_inspect_utils_type_id__volatile, folks_inspect_utils_type_id);
	}
	return folks_inspect_utils_type_id__volatile;
}


gpointer folks_inspect_utils_ref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void folks_inspect_utils_unref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FOLKS_INSPECT_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



