/* avatar-cache.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from avatar-cache.vala, do not modify */

/*
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <string.h>
#include <stdlib.h>


#define TYPE_AVATAR_CACHE_TESTS (avatar_cache_tests_get_type ())
#define AVATAR_CACHE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTests))
#define AVATAR_CACHE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsClass))
#define IS_AVATAR_CACHE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_CACHE_TESTS))
#define IS_AVATAR_CACHE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_CACHE_TESTS))
#define AVATAR_CACHE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsClass))

typedef struct _AvatarCacheTests AvatarCacheTests;
typedef struct _AvatarCacheTestsClass AvatarCacheTestsClass;
typedef struct _AvatarCacheTestsPrivate AvatarCacheTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _AvatarCacheTests {
	FolksTestCase parent_instance;
	AvatarCacheTestsPrivate * priv;
};

struct _AvatarCacheTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AvatarCacheTestsPrivate {
	FolksAvatarCache* _cache;
	GFile* _cache_dir;
	GLoadableIcon* _avatar;
	GMainLoop* _main_loop;
};

struct _Block1Data {
	int _ref_count_;
	AvatarCacheTests * self;
	GLoadableIcon* avatar;
};


static gpointer avatar_cache_tests_parent_class = NULL;

GType avatar_cache_tests_get_type (void) G_GNUC_CONST;
#define AVATAR_CACHE_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsPrivate))
enum  {
	AVATAR_CACHE_TESTS_DUMMY_PROPERTY
};
AvatarCacheTests* avatar_cache_tests_new (void);
AvatarCacheTests* avatar_cache_tests_construct (GType object_type);
void avatar_cache_tests_test_store_and_load_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_store_avatar_overwrite (AvatarCacheTests* self);
static void _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_load_avatar_non_existent (AvatarCacheTests* self);
static void _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_remove_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_remove_avatar_non_existent (AvatarCacheTests* self);
static void _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_build_uri_for_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method (gpointer self);
static void avatar_cache_tests_real_set_up (FolksTestCase* base);
void _avatar_cache_tests_delete_cache_directory (AvatarCacheTests* self);
static void avatar_cache_tests_real_tear_down (FolksTestCase* base);
void _avatar_cache_tests_delete_directory (AvatarCacheTests* self, GFile* dir, GError** error);
gboolean _avatar_cache_tests_avatars_equal (AvatarCacheTests* self, GLoadableIcon* avatar1, GLoadableIcon* avatar2);
void _avatar_cache_tests_assert_store_avatar (AvatarCacheTests* self, const gchar* id, GLoadableIcon* avatar);
static void _lambda0_ (GObject* obj, GAsyncResult* res, AvatarCacheTests* self);
static void __lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GLoadableIcon* _avatar_cache_tests_assert_load_avatar (AvatarCacheTests* self, const gchar* id);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda1_ (GObject* obj, GAsyncResult* res, Block1Data* _data1_);
static void __lambda1__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void _avatar_cache_tests_assert_remove_avatar (AvatarCacheTests* self, const gchar* id);
static void _lambda2_ (GObject* obj, GAsyncResult* res, AvatarCacheTests* self);
static void __lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void avatar_cache_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method (gpointer self) {
	avatar_cache_tests_test_store_and_load_avatar (self);
}


static void _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method (gpointer self) {
	avatar_cache_tests_test_store_avatar_overwrite (self);
}


static void _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method (gpointer self) {
	avatar_cache_tests_test_load_avatar_non_existent (self);
}


static void _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method (gpointer self) {
	avatar_cache_tests_test_remove_avatar (self);
}


static void _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method (gpointer self) {
	avatar_cache_tests_test_remove_avatar_non_existent (self);
}


static void _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method (gpointer self) {
	avatar_cache_tests_test_build_uri_for_avatar (self);
}


AvatarCacheTests* avatar_cache_tests_construct (GType object_type) {
	AvatarCacheTests * self = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_ = NULL;
	self = (AvatarCacheTests*) folks_test_case_construct (object_type, "AvatarCache");
	_tmp0_ = g_get_tmp_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_child (_tmp2_, "folks-avatar-cache-tests");
	_g_object_unref0 (self->priv->_cache_dir);
	self->priv->_cache_dir = _tmp3_;
	_g_object_unref0 (_tmp2_);
	folks_test_case_add_test ((FolksTestCase*) self, "store-and-load-avatar", _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "store-avatar-overwrite", _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "load-avatar-non-existent", _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "remove-avatar", _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "remove-avatar-non-existent", _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "build-uri-for-avatar", _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method, self);
	return self;
}


AvatarCacheTests* avatar_cache_tests_new (void) {
	return avatar_cache_tests_construct (TYPE_AVATAR_CACHE_TESTS);
}


static void avatar_cache_tests_real_set_up (FolksTestCase* base) {
	AvatarCacheTests * self;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	FolksAvatarCache* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_;
	GFileIcon* _tmp7_;
	GMainLoop* _tmp8_;
	self = (AvatarCacheTests*) base;
	_avatar_cache_tests_delete_cache_directory (self);
	_tmp0_ = self->priv->_cache_dir;
	_tmp1_ = g_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	g_setenv ("XDG_CACHE_HOME", _tmp2_, TRUE);
	_g_free0 (_tmp2_);
	_tmp3_ = folks_avatar_cache_dup ();
	_g_object_unref0 (self->priv->_cache);
	self->priv->_cache = _tmp3_;
	_tmp4_ = g_getenv ("AVATAR_FILE_PATH");
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = (GFileIcon*) g_file_icon_new (_tmp6_);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = (GLoadableIcon*) _tmp7_;
	_g_object_unref0 (_tmp6_);
	_tmp8_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp8_;
}


static void avatar_cache_tests_real_tear_down (FolksTestCase* base) {
	AvatarCacheTests * self;
	self = (AvatarCacheTests*) base;
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = NULL;
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = NULL;
	_g_object_unref0 (self->priv->_cache);
	self->priv->_cache = NULL;
	_avatar_cache_tests_delete_cache_directory (self);
}


void _avatar_cache_tests_delete_directory (AvatarCacheTests* self, GFile* dir, GError** error) {
	GFile* _tmp0_;
	GFileEnumerator* _tmp1_ = NULL;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp2_;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* file_info;
	GFileEnumerator* _tmp17_;
	GFile* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = dir;
	_tmp1_ = g_file_enumerate_children (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	enumerator = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = enumerator;
	_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error_);
	file_info = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (enumerator);
		return;
	}
	while (TRUE) {
		GFileInfo* _tmp4_;
		GFile* _tmp5_;
		GFileInfo* _tmp6_;
		const gchar* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GFile* child_file;
		GFile* _tmp9_;
		GFileType _tmp10_ = 0;
		GFileEnumerator* _tmp13_;
		GFileInfo* _tmp14_ = NULL;
		GFileInfo* _tmp15_;
		GFileInfo* _tmp16_;
		_tmp4_ = file_info;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = dir;
		_tmp6_ = file_info;
		_tmp7_ = g_file_info_get_name (_tmp6_);
		_tmp8_ = g_file_get_child (_tmp5_, _tmp7_);
		child_file = _tmp8_;
		_tmp9_ = child_file;
		_tmp10_ = g_file_query_file_type (_tmp9_, G_FILE_QUERY_INFO_NONE, NULL);
		if (_tmp10_ == G_FILE_TYPE_DIRECTORY) {
			GFile* _tmp11_;
			_tmp11_ = child_file;
			_avatar_cache_tests_delete_directory (self, _tmp11_, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (child_file);
				_g_object_unref0 (file_info);
				_g_object_unref0 (enumerator);
				return;
			}
		} else {
			GFile* _tmp12_;
			_tmp12_ = child_file;
			g_file_delete (_tmp12_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (child_file);
				_g_object_unref0 (file_info);
				_g_object_unref0 (enumerator);
				return;
			}
		}
		_tmp13_ = enumerator;
		_tmp14_ = g_file_enumerator_next_file (_tmp13_, NULL, &_inner_error_);
		_tmp15_ = _tmp14_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (child_file);
			_g_object_unref0 (file_info);
			_g_object_unref0 (enumerator);
			return;
		}
		_tmp16_ = _tmp15_;
		_g_object_unref0 (file_info);
		file_info = _tmp16_;
		_g_object_unref0 (child_file);
	}
	_tmp17_ = enumerator;
	g_file_enumerator_close (_tmp17_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file_info);
		_g_object_unref0 (enumerator);
		return;
	}
	_tmp18_ = dir;
	g_file_delete (_tmp18_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file_info);
		_g_object_unref0 (enumerator);
		return;
	}
	_g_object_unref0 (file_info);
	_g_object_unref0 (enumerator);
}


void _avatar_cache_tests_delete_cache_directory (AvatarCacheTests* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* _tmp0_;
		_tmp0_ = self->priv->_cache_dir;
		_avatar_cache_tests_delete_directory (self, _tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean _avatar_cache_tests_avatars_equal (AvatarCacheTests* self, GLoadableIcon* avatar1, GLoadableIcon* avatar2) {
	gboolean result = FALSE;
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (avatar1 != NULL, FALSE);
	g_return_val_if_fail (avatar2 != NULL, FALSE);
	_tmp0_ = avatar1;
	_tmp1_ = avatar2;
	_tmp2_ = g_icon_equal ((GIcon*) _tmp0_, (GIcon*) _tmp1_);
	if (_tmp2_ == TRUE) {
		result = TRUE;
		return result;
	}
	{
		GLoadableIcon* _tmp3_;
		GInputStream* _tmp4_ = NULL;
		GInputStream* stream1;
		GLoadableIcon* _tmp5_;
		GInputStream* _tmp6_ = NULL;
		GInputStream* stream2;
		guint8* _tmp7_ = NULL;
		guint8* content1;
		gint content1_length1;
		gint _content1_size_;
		guint8* _tmp8_ = NULL;
		guint8* content2;
		gint content2_length1;
		gint _content2_size_;
		gssize read1;
		_tmp3_ = avatar1;
		_tmp4_ = g_loadable_icon_load (_tmp3_, -1, NULL, NULL, &_inner_error_);
		stream1 = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp5_ = avatar2;
		_tmp6_ = g_loadable_icon_load (_tmp5_, -1, NULL, NULL, &_inner_error_);
		stream2 = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream1);
			goto __catch1_g_error;
		}
		_tmp7_ = g_new0 (guint8, 512);
		content1 = _tmp7_;
		content1_length1 = 512;
		_content1_size_ = content1_length1;
		_tmp8_ = g_new0 (guint8, 512);
		content2 = _tmp8_;
		content2_length1 = 512;
		_content2_size_ = content2_length1;
		read1 = (gssize) (-1);
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				GInputStream* _tmp12_;
				guint8* _tmp13_;
				gint _tmp13__length1;
				gssize _tmp14_ = 0L;
				gssize _tmp15_;
				gssize _tmp16_;
				GInputStream* _tmp17_;
				guint8* _tmp18_;
				gint _tmp18__length1;
				gssize _tmp19_ = 0L;
				gssize read2;
				gboolean _tmp20_ = FALSE;
				gssize _tmp21_;
				gssize _tmp22_;
				gboolean _tmp27_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gssize _tmp11_;
					_tmp11_ = read1;
					if (!(_tmp11_ > ((gssize) 0))) {
						break;
					}
				}
				_tmp9_ = FALSE;
				_tmp12_ = stream1;
				_tmp13_ = content1;
				_tmp13__length1 = content1_length1;
				_tmp14_ = g_input_stream_read (_tmp12_, _tmp13_, (gsize) _tmp13__length1, NULL, &_inner_error_);
				_tmp15_ = _tmp14_;
				if (_inner_error_ != NULL) {
					content2 = (g_free (content2), NULL);
					content1 = (g_free (content1), NULL);
					_g_object_unref0 (stream2);
					_g_object_unref0 (stream1);
					goto __catch1_g_error;
				}
				_tmp16_ = _tmp15_;
				read1 = _tmp16_;
				_tmp17_ = stream2;
				_tmp18_ = content2;
				_tmp18__length1 = content2_length1;
				_tmp19_ = g_input_stream_read (_tmp17_, _tmp18_, (gsize) _tmp18__length1, NULL, &_inner_error_);
				read2 = _tmp19_;
				if (_inner_error_ != NULL) {
					content2 = (g_free (content2), NULL);
					content1 = (g_free (content1), NULL);
					_g_object_unref0 (stream2);
					_g_object_unref0 (stream1);
					goto __catch1_g_error;
				}
				_tmp21_ = read1;
				_tmp22_ = read2;
				if (_tmp21_ != _tmp22_) {
					_tmp20_ = TRUE;
				} else {
					guint8* _tmp23_;
					gint _tmp23__length1;
					guint8* _tmp24_;
					gint _tmp24__length1;
					gssize _tmp25_;
					gint _tmp26_ = 0;
					_tmp23_ = content1;
					_tmp23__length1 = content1_length1;
					_tmp24_ = content2;
					_tmp24__length1 = content2_length1;
					_tmp25_ = read1;
					_tmp26_ = memcmp (_tmp23_, _tmp24_, (gsize) _tmp25_);
					_tmp20_ = _tmp26_ != 0;
				}
				_tmp27_ = _tmp20_;
				if (_tmp27_) {
					result = FALSE;
					content2 = (g_free (content2), NULL);
					content1 = (g_free (content1), NULL);
					_g_object_unref0 (stream2);
					_g_object_unref0 (stream1);
					return result;
				}
			}
		}
		content2 = (g_free (content2), NULL);
		content1 = (g_free (content1), NULL);
		_g_object_unref0 (stream2);
		_g_object_unref0 (stream1);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void _lambda0_ (GObject* obj, GAsyncResult* res, AvatarCacheTests* self) {
	GMainLoop* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		FolksAvatarCache* _tmp0_;
		GAsyncResult* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp0_ = self->priv->_cache;
		_tmp1_ = res;
		_tmp2_ = folks_avatar_cache_store_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_error ("avatar-cache.vala:164: Error storing avatar: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = self->priv->_main_loop;
	g_main_loop_quit (_tmp6_);
}


static void __lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda0_ (source_object, res, self);
	g_object_unref (self);
}


void _avatar_cache_tests_assert_store_avatar (AvatarCacheTests* self, const gchar* id, GLoadableIcon* avatar) {
	FolksAvatarCache* _tmp0_;
	const gchar* _tmp1_;
	GLoadableIcon* _tmp2_;
	GMainLoop* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (avatar != NULL);
	_tmp0_ = self->priv->_cache;
	_tmp1_ = id;
	_tmp2_ = avatar;
	folks_avatar_cache_store_avatar (_tmp0_, _tmp1_, _tmp2_, __lambda0__gasync_ready_callback, g_object_ref (self));
	_tmp3_ = self->priv->_main_loop;
	g_main_loop_run (_tmp3_);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->avatar);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda1_ (GObject* obj, GAsyncResult* res, Block1Data* _data1_) {
	AvatarCacheTests * self;
	GMainLoop* _tmp7_;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		FolksAvatarCache* _tmp0_;
		GAsyncResult* _tmp1_;
		GLoadableIcon* _tmp2_ = NULL;
		GLoadableIcon* _tmp3_;
		GLoadableIcon* _tmp4_;
		_tmp0_ = self->priv->_cache;
		_tmp1_ = res;
		_tmp2_ = folks_avatar_cache_load_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_data1_->avatar);
		_data1_->avatar = _tmp4_;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_error ("avatar-cache.vala:185: Error loading avatar: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = self->priv->_main_loop;
	g_main_loop_quit (_tmp7_);
}


static void __lambda1__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda1_ (source_object, res, self);
	block1_data_unref (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GLoadableIcon* _avatar_cache_tests_assert_load_avatar (AvatarCacheTests* self, const gchar* id) {
	GLoadableIcon* result = NULL;
	Block1Data* _data1_;
	FolksAvatarCache* _tmp0_;
	const gchar* _tmp1_;
	GMainLoop* _tmp2_;
	GLoadableIcon* _tmp3_;
	GLoadableIcon* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->avatar = NULL;
	_tmp0_ = self->priv->_cache;
	_tmp1_ = id;
	folks_avatar_cache_load_avatar (_tmp0_, _tmp1_, __lambda1__gasync_ready_callback, block1_data_ref (_data1_));
	_tmp2_ = self->priv->_main_loop;
	g_main_loop_run (_tmp2_);
	_tmp3_ = _data1_->avatar;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static void _lambda2_ (GObject* obj, GAsyncResult* res, AvatarCacheTests* self) {
	GMainLoop* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		FolksAvatarCache* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = self->priv->_cache;
		_tmp1_ = res;
		folks_avatar_cache_remove_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_error ("avatar-cache.vala:206: Error removing avatar: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->priv->_main_loop;
	g_main_loop_quit (_tmp4_);
}


static void __lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda2_ (source_object, res, self);
	g_object_unref (self);
}


void _avatar_cache_tests_assert_remove_avatar (AvatarCacheTests* self, const gchar* id) {
	FolksAvatarCache* _tmp0_;
	const gchar* _tmp1_;
	GMainLoop* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = self->priv->_cache;
	_tmp1_ = id;
	folks_avatar_cache_remove_avatar (_tmp0_, _tmp1_, __lambda2__gasync_ready_callback, g_object_ref (self));
	_tmp2_ = self->priv->_main_loop;
	g_main_loop_run (_tmp2_);
}


void avatar_cache_tests_test_store_and_load_avatar (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_ = NULL;
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp2_;
	GLoadableIcon* _tmp3_;
	GLoadableIcon* _tmp4_;
	GLoadableIcon* _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_avatar;
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-id", _tmp0_);
	_tmp1_ = _avatar_cache_tests_assert_load_avatar (self, "test-store-avatar-id");
	avatar = _tmp1_;
	_tmp2_ = avatar;
	g_assert (_tmp2_ != NULL);
	_tmp3_ = avatar;
	g_assert (G_IS_LOADABLE_ICON (_tmp3_));
	_tmp4_ = self->priv->_avatar;
	_tmp5_ = avatar;
	_tmp6_ = _avatar_cache_tests_avatars_equal (self, _tmp4_, _tmp5_);
	g_assert (_tmp6_ == TRUE);
	_g_object_unref0 (avatar);
}


void avatar_cache_tests_test_store_avatar_overwrite (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	GLoadableIcon* _tmp2_ = NULL;
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp3_;
	GLoadableIcon* _tmp4_;
	GLoadableIcon* _tmp5_;
	GLoadableIcon* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_avatar;
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-ow-id", _tmp0_);
	_tmp1_ = self->priv->_avatar;
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-ow-id", _tmp1_);
	_tmp2_ = _avatar_cache_tests_assert_load_avatar (self, "test-store-avatar-ow-id");
	avatar = _tmp2_;
	_tmp3_ = avatar;
	g_assert (_tmp3_ != NULL);
	_tmp4_ = avatar;
	g_assert (G_IS_LOADABLE_ICON (_tmp4_));
	_tmp5_ = self->priv->_avatar;
	_tmp6_ = avatar;
	_tmp7_ = _avatar_cache_tests_avatars_equal (self, _tmp5_, _tmp6_);
	g_assert (_tmp7_ == TRUE);
	_g_object_unref0 (avatar);
}


void avatar_cache_tests_test_load_avatar_non_existent (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_ = NULL;
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _avatar_cache_tests_assert_load_avatar (self, "test-load-avatar-non-existent");
	avatar = _tmp0_;
	_tmp1_ = avatar;
	g_assert (_tmp1_ == NULL);
	_g_object_unref0 (avatar);
}


void avatar_cache_tests_test_remove_avatar (AvatarCacheTests* self) {
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_ = NULL;
	GLoadableIcon* _tmp2_;
	GLoadableIcon* _tmp3_ = NULL;
	GLoadableIcon* _tmp4_;
	g_return_if_fail (self != NULL);
	avatar = NULL;
	_tmp0_ = self->priv->_avatar;
	_avatar_cache_tests_assert_store_avatar (self, "test-remove-avatar", _tmp0_);
	_tmp1_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar");
	_g_object_unref0 (avatar);
	avatar = _tmp1_;
	_tmp2_ = avatar;
	g_assert (_tmp2_ != NULL);
	_avatar_cache_tests_assert_remove_avatar (self, "test-remove-avatar");
	_tmp3_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar");
	_g_object_unref0 (avatar);
	avatar = _tmp3_;
	_tmp4_ = avatar;
	g_assert (_tmp4_ == NULL);
	_g_object_unref0 (avatar);
}


void avatar_cache_tests_test_remove_avatar_non_existent (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_ = NULL;
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar-non-existent");
	avatar = _tmp0_;
	_tmp1_ = avatar;
	g_assert (_tmp1_ == NULL);
	_avatar_cache_tests_assert_remove_avatar (self, "test-remove-avatar-non-existent");
	_g_object_unref0 (avatar);
}


void avatar_cache_tests_test_build_uri_for_avatar (AvatarCacheTests* self) {
	FolksAvatarCache* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* uri;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cache;
	_tmp1_ = folks_avatar_cache_build_uri_for_avatar (_tmp0_, "test-id");
	uri = _tmp1_;
	_tmp2_ = uri;
	g_assert (_tmp2_ != NULL);
	_tmp3_ = uri;
	_tmp4_ = g_uri_parse_scheme (_tmp3_);
	_tmp5_ = _tmp4_;
	g_assert (_tmp5_ != NULL);
	_g_free0 (_tmp5_);
	_g_free0 (uri);
}


static void avatar_cache_tests_class_init (AvatarCacheTestsClass * klass) {
	avatar_cache_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AvatarCacheTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = avatar_cache_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = avatar_cache_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = avatar_cache_tests_finalize;
}


static void avatar_cache_tests_instance_init (AvatarCacheTests * self) {
	self->priv = AVATAR_CACHE_TESTS_GET_PRIVATE (self);
}


static void avatar_cache_tests_finalize (GObject* obj) {
	AvatarCacheTests * self;
	self = AVATAR_CACHE_TESTS (obj);
	_g_object_unref0 (self->priv->_cache);
	_g_object_unref0 (self->priv->_cache_dir);
	_g_object_unref0 (self->priv->_avatar);
	_g_main_loop_unref0 (self->priv->_main_loop);
	G_OBJECT_CLASS (avatar_cache_tests_parent_class)->finalize (obj);
}


GType avatar_cache_tests_get_type (void) {
	static volatile gsize avatar_cache_tests_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_cache_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarCacheTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_cache_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarCacheTests), 0, (GInstanceInitFunc) avatar_cache_tests_instance_init, NULL };
		GType avatar_cache_tests_type_id;
		avatar_cache_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AvatarCacheTests", &g_define_type_info, 0);
		g_once_init_leave (&avatar_cache_tests_type_id__volatile, avatar_cache_tests_type_id);
	}
	return avatar_cache_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	GTestSuite* _tmp1_;
	AvatarCacheTests* _tmp2_;
	AvatarCacheTests* _tmp3_;
	GTestSuite* _tmp4_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = root;
	_tmp2_ = avatar_cache_tests_new ();
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_test_case_get_suite ((FolksTestCase*) _tmp3_);
	g_test_suite_add_suite (_tmp1_, _tmp4_);
	_g_object_unref0 (_tmp3_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



