/* link-personas.c generated by valac 0.12.0, the Vala compiler
 * generated from link-personas.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <gconf/gconf-client.h>
#include <gee.h>
#include <gconf/gconf.h>
#include <gio/gio.h>


#define TYPE_LINK_PERSONAS_TESTS (link_personas_tests_get_type ())
#define LINK_PERSONAS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_PERSONAS_TESTS, LinkPersonasTests))
#define LINK_PERSONAS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINK_PERSONAS_TESTS, LinkPersonasTestsClass))
#define IS_LINK_PERSONAS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_PERSONAS_TESTS))
#define IS_LINK_PERSONAS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINK_PERSONAS_TESTS))
#define LINK_PERSONAS_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINK_PERSONAS_TESTS, LinkPersonasTestsClass))

typedef struct _LinkPersonasTests LinkPersonasTests;
typedef struct _LinkPersonasTestsClass LinkPersonasTestsClass;
typedef struct _LinkPersonasTestsPrivate LinkPersonasTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _gconf_value_free0(var) ((var == NULL) ? NULL : (var = (gconf_value_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _LinkPersonasTestsTestLinkingPersonasAsyncData LinkPersonasTestsTestLinkingPersonasAsyncData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _LinkPersonasTestsAddPersonasData LinkPersonasTestsAddPersonasData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _LinkPersonasTests {
	FolksTestCase parent_instance;
	LinkPersonasTestsPrivate * priv;
};

struct _LinkPersonasTestsClass {
	FolksTestCaseClass parent_class;
};

struct _LinkPersonasTestsPrivate {
	GMainLoop* _main_loop;
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gchar* _persona_fullname_1;
	gchar* _persona_fullname_2;
	gchar* _proto;
	gchar* _im_address_1;
	gchar* _im_address_2;
	gboolean _linking_fired;
	gboolean _persona_found_1;
	gboolean _persona_found_2;
	gchar* _persona_iid_1;
	gchar* _persona_iid_2;
	GList* _personas;
	gint _removed_individuals;
	gchar* _folks_config_key;
	GConfClient* _gconf_client;
	GeeHashMap* _linking_props;
};

struct _LinkPersonasTestsTestLinkingPersonasAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	LinkPersonasTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	FolksPersonaStore* pstore;
	GList* _tmp2_;
	GList* backend_collection;
	GList* backend_it;
	FolksBackend* _tmp3_;
	FolksBackend* backend;
	GHashTable* _tmp4_;
	gconstpointer _tmp5_;
	FolksPersonaStore* _tmp6_;
	GError * e;
	GError * _inner_error_;
};

struct _LinkPersonasTestsAddPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	LinkPersonasTests* self;
	FolksPersonaStore* pstore;
	GHashTable* _tmp0_;
	GHashTable* details1;
	GValue _tmp1_;
	GValue _tmp2_;
	GValue _tmp3_;
	GValue* _tmp4_;
	GValue* _tmp5_;
	GValue* v1;
	GHashTable* _tmp6_;
	GHashTable* im_addrs1;
	FolksLinkedHashSet* _tmp7_;
	FolksLinkedHashSet* addrs1;
	gchar* _tmp8_;
	FolksLinkedHashSet* _tmp9_;
	gchar* _tmp10_;
	GValue* _tmp11_;
	GValue _tmp12_;
	GValue _tmp13_;
	GValue _tmp14_;
	GValue* _tmp15_;
	GValue* _tmp16_;
	GValue* v2;
	gchar* _tmp17_;
	GValue* _tmp18_;
	GHashTable* _tmp19_;
	GHashTable* details2;
	GValue _tmp20_;
	GValue _tmp21_;
	GValue _tmp22_;
	GValue* _tmp23_;
	GValue* _tmp24_;
	GValue* v3;
	GHashTable* _tmp25_;
	GHashTable* im_addrs2;
	FolksLinkedHashSet* _tmp26_;
	FolksLinkedHashSet* addrs2;
	gchar* _tmp27_;
	FolksLinkedHashSet* _tmp28_;
	gchar* _tmp29_;
	GValue* _tmp30_;
	GValue _tmp31_;
	GValue _tmp32_;
	GValue _tmp33_;
	GValue* _tmp34_;
	GValue* _tmp35_;
	GValue* v4;
	gchar* _tmp36_;
	GValue* _tmp37_;
	FolksPersona* _tmp38_;
	FolksPersona* _tmp39_;
	FolksPersona* _tmp40_;
	FolksPersona* _tmp41_;
	GError * e;
	GError * _inner_error_;
};


static gpointer link_personas_tests_parent_class = NULL;

GType link_personas_tests_get_type (void) G_GNUC_CONST;
#define LINK_PERSONAS_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LINK_PERSONAS_TESTS, LinkPersonasTestsPrivate))
enum  {
	LINK_PERSONAS_TESTS_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
LinkPersonasTests* link_personas_tests_new (void);
LinkPersonasTests* link_personas_tests_construct (GType object_type);
void link_personas_tests_test_linking_personas (LinkPersonasTests* self);
static void _link_personas_tests_test_linking_personas_folks_test_case_test_method (gpointer self);
static void link_personas_tests_real_set_up (FolksTestCase* base);
static void link_personas_tests_real_tear_down (FolksTestCase* base);
static void _link_personas_tests_test_linking_personas_async (LinkPersonasTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _link_personas_tests_test_linking_personas_finish (LinkPersonasTests* self, GAsyncResult* _res_);
static gboolean _lambda1_ (LinkPersonasTests* self);
static gboolean __lambda1__gsource_func (gpointer self);
static void _link_personas_tests_test_linking_personas_async_data_free (gpointer _data);
static gboolean _link_personas_tests_test_linking_personas_async_co (LinkPersonasTestsTestLinkingPersonasAsyncData* data);
static void _link_personas_tests_test_linking_personas_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _link_personas_tests_individuals_changed_cb (LinkPersonasTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __link_personas_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _link_personas_tests_add_personas (LinkPersonasTests* self, FolksPersonaStore* pstore, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _link_personas_tests_add_personas_finish (LinkPersonasTests* self, GAsyncResult* _res_);
static void _link_personas_tests_add_personas_data_free (gpointer _data);
static gboolean _link_personas_tests_add_personas_co (LinkPersonasTestsAddPersonasData* data);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void _link_personas_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _link_personas_tests_check_personas (LinkPersonasTests* self, FolksIndividual* i);
static void _link_personas_tests_notify_cb (LinkPersonasTests* self, GObject* individual_obj, GParamSpec* ps);
static void __link_personas_tests_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _lambda0_ (LinkPersonasTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void link_personas_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _link_personas_tests_test_linking_personas_folks_test_case_test_method (gpointer self) {
	link_personas_tests_test_linking_personas (self);
}


LinkPersonasTests* link_personas_tests_construct (GType object_type) {
	LinkPersonasTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (LinkPersonasTests*) folks_test_case_construct (object_type, "LinkPersonasTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "test linking personas", _link_personas_tests_test_linking_personas_folks_test_case_test_method, self);
	return self;
}


LinkPersonasTests* link_personas_tests_new (void) {
	return link_personas_tests_construct (TYPE_LINK_PERSONAS_TESTS);
}


static void link_personas_tests_real_set_up (FolksTestCase* base) {
	LinkPersonasTests * self;
	GConfClient* _tmp0_ = NULL;
	GConfValue* _tmp1_ = NULL;
	GConfValue* val;
	GError * _inner_error_ = NULL;
	self = (LinkPersonasTests*) base;
	_tmp0_ = gconf_client_get_default ();
	self->priv->_gconf_client = _tmp0_;
	_tmp1_ = gconf_value_new (GCONF_VALUE_STRING);
	val = _tmp1_;
	gconf_value_set_string (val, "tracker");
	gconf_client_set (self->priv->_gconf_client, self->priv->_folks_config_key, val, &_inner_error_);
	if (_inner_error_ != NULL) {
		_gconf_value_free0 (val);
		goto __catch0_g_error;
	}
	_gconf_value_free0 (val);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("link-personas.vala:70: Couldn't set primary store: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tracker_test_backend_set_up (self->priv->_tracker_backend);
}


static void link_personas_tests_real_tear_down (FolksTestCase* base) {
	LinkPersonasTests * self;
	GError * _inner_error_ = NULL;
	self = (LinkPersonasTests*) base;
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
	gconf_client_unset (self->priv->_gconf_client, self->priv->_folks_config_key, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("link-personas.vala:92: Couldn't unset primary store: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean _lambda1_ (LinkPersonasTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


void link_personas_tests_test_linking_personas (LinkPersonasTests* self) {
	GMainLoop* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_ = NULL;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_tmp1_ = g_strdup ("persona #1");
	_g_free0 (self->priv->_persona_fullname_1);
	self->priv->_persona_fullname_1 = _tmp1_;
	_tmp2_ = g_strdup ("persona #2");
	_g_free0 (self->priv->_persona_fullname_2);
	self->priv->_persona_fullname_2 = _tmp2_;
	__g_list_free__g_object_unref0_0 (self->priv->_personas);
	self->priv->_personas = NULL;
	self->priv->_persona_found_1 = FALSE;
	self->priv->_persona_found_2 = FALSE;
	self->priv->_linking_fired = FALSE;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_linking_props);
	self->priv->_linking_props = _tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_linking_props, "prop1", self->priv->_im_address_1);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_linking_props, "prop2", self->priv->_im_address_2);
	_link_personas_tests_test_linking_personas_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda1__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	_tmp4_ = gee_map_get_size ((GeeMap*) self->priv->_linking_props);
	g_assert (_tmp4_ == 0);
	g_assert (self->priv->_removed_individuals == 2);
}


static void _link_personas_tests_test_linking_personas_async_data_free (gpointer _data) {
	LinkPersonasTestsTestLinkingPersonasAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (LinkPersonasTestsTestLinkingPersonasAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _link_personas_tests_test_linking_personas_async (LinkPersonasTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LinkPersonasTestsTestLinkingPersonasAsyncData* _data_;
	_data_ = g_slice_new0 (LinkPersonasTestsTestLinkingPersonasAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _link_personas_tests_test_linking_personas_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _link_personas_tests_test_linking_personas_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_link_personas_tests_test_linking_personas_async_co (_data_);
}


static void _link_personas_tests_test_linking_personas_finish (LinkPersonasTests* self, GAsyncResult* _res_) {
	LinkPersonasTestsTestLinkingPersonasAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _link_personas_tests_test_linking_personas_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LinkPersonasTestsTestLinkingPersonasAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_link_personas_tests_test_linking_personas_async_co (data);
}


static void __link_personas_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_link_personas_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static gboolean _link_personas_tests_test_linking_personas_async_co (LinkPersonasTestsTestLinkingPersonasAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _link_personas_tests_test_linking_personas_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __link_personas_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _link_personas_tests_test_linking_personas_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	data->pstore = NULL;
	data->_tmp2_ = NULL;
	data->_tmp2_ = folks_backend_store_dup_enabled_backends (data->store);
	{
		data->backend_collection = data->_tmp2_;
		for (data->backend_it = data->backend_collection; data->backend_it != NULL; data->backend_it = data->backend_it->next) {
			data->_tmp3_ = _g_object_ref0 ((FolksBackend*) data->backend_it->data);
			data->backend = data->_tmp3_;
			{
				data->_tmp4_ = NULL;
				data->_tmp4_ = folks_backend_get_persona_stores (data->backend);
				data->_tmp5_ = NULL;
				data->_tmp5_ = g_hash_table_lookup (data->_tmp4_, "tracker");
				data->_tmp6_ = _g_object_ref0 ((FolksPersonaStore*) data->_tmp5_);
				_g_object_unref0 (data->pstore);
				data->pstore = data->_tmp6_;
				if (data->pstore != NULL) {
					_g_object_unref0 (data->backend);
					break;
				}
				_g_object_unref0 (data->backend);
			}
		}
		__g_list_free__g_object_unref0_0 (data->backend_collection);
	}
	g_assert (data->pstore != NULL);
	data->_state_ = 3;
	_link_personas_tests_add_personas (data->self, data->pstore, _link_personas_tests_test_linking_personas_async_ready, data);
	return FALSE;
	_state_3:
	_link_personas_tests_add_personas_finish (data->self, data->_res_);
	_g_object_unref0 (data->pstore);
	goto __finally2;
	__catch2_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("link-personas.vala:154: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _link_personas_tests_add_personas_data_free (gpointer _data) {
	LinkPersonasTestsAddPersonasData* data;
	data = _data;
	_g_object_unref0 (data->pstore);
	_g_object_unref0 (data->self);
	g_slice_free (LinkPersonasTestsAddPersonasData, data);
}


static void _link_personas_tests_add_personas (LinkPersonasTests* self, FolksPersonaStore* pstore, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LinkPersonasTestsAddPersonasData* _data_;
	_data_ = g_slice_new0 (LinkPersonasTestsAddPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _link_personas_tests_add_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _link_personas_tests_add_personas_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->pstore = _g_object_ref0 (pstore);
	_link_personas_tests_add_personas_co (_data_);
}


static void _link_personas_tests_add_personas_finish (LinkPersonasTests* self, GAsyncResult* _res_) {
	LinkPersonasTestsAddPersonasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _link_personas_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LinkPersonasTestsAddPersonasData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_link_personas_tests_add_personas_co (data);
}


static gboolean _link_personas_tests_add_personas_co (LinkPersonasTestsAddPersonasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details1 = data->_tmp0_;
	memset (&data->_tmp1_, 0, sizeof (GValue));
	g_value_init (&data->_tmp1_, G_TYPE_HASH_TABLE);
	memset (&data->_tmp2_, 0, sizeof (GValue));
	data->_tmp2_ = data->_tmp1_;
	data->_tmp3_ = data->_tmp2_;
	data->_tmp4_ = __g_value_dup0 (&data->_tmp3_);
	data->_tmp5_ = data->_tmp4_;
	G_IS_VALUE (&data->_tmp3_) ? (g_value_unset (&data->_tmp3_), NULL) : NULL;
	data->v1 = data->_tmp5_;
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_object_unref0_);
	data->im_addrs1 = data->_tmp6_;
	data->_tmp7_ = NULL;
	data->_tmp7_ = folks_linked_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	data->addrs1 = data->_tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->addrs1, data->self->priv->_im_address_1);
	data->_tmp8_ = g_strdup (data->self->priv->_proto);
	data->_tmp9_ = _g_object_ref0 (data->addrs1);
	g_hash_table_insert (data->im_addrs1, data->_tmp8_, data->_tmp9_);
	g_value_set_boxed (data->v1, data->im_addrs1);
	data->_tmp10_ = g_strdup ("im-addresses");
	data->_tmp11_ = data->v1;
	data->v1 = NULL;
	g_hash_table_insert (data->details1, data->_tmp10_, data->_tmp11_);
	memset (&data->_tmp12_, 0, sizeof (GValue));
	g_value_init (&data->_tmp12_, G_TYPE_STRING);
	memset (&data->_tmp13_, 0, sizeof (GValue));
	data->_tmp13_ = data->_tmp12_;
	data->_tmp14_ = data->_tmp13_;
	data->_tmp15_ = __g_value_dup0 (&data->_tmp14_);
	data->_tmp16_ = data->_tmp15_;
	G_IS_VALUE (&data->_tmp14_) ? (g_value_unset (&data->_tmp14_), NULL) : NULL;
	data->v2 = data->_tmp16_;
	g_value_set_string (data->v2, data->self->priv->_persona_fullname_1);
	data->_tmp17_ = g_strdup ("full-name");
	data->_tmp18_ = data->v2;
	data->v2 = NULL;
	g_hash_table_insert (data->details1, data->_tmp17_, data->_tmp18_);
	data->_tmp19_ = NULL;
	data->_tmp19_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details2 = data->_tmp19_;
	memset (&data->_tmp20_, 0, sizeof (GValue));
	g_value_init (&data->_tmp20_, G_TYPE_HASH_TABLE);
	memset (&data->_tmp21_, 0, sizeof (GValue));
	data->_tmp21_ = data->_tmp20_;
	data->_tmp22_ = data->_tmp21_;
	data->_tmp23_ = __g_value_dup0 (&data->_tmp22_);
	data->_tmp24_ = data->_tmp23_;
	G_IS_VALUE (&data->_tmp22_) ? (g_value_unset (&data->_tmp22_), NULL) : NULL;
	data->v3 = data->_tmp24_;
	data->_tmp25_ = NULL;
	data->_tmp25_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_object_unref0_);
	data->im_addrs2 = data->_tmp25_;
	data->_tmp26_ = NULL;
	data->_tmp26_ = folks_linked_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	data->addrs2 = data->_tmp26_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->addrs2, data->self->priv->_im_address_2);
	data->_tmp27_ = g_strdup (data->self->priv->_proto);
	data->_tmp28_ = _g_object_ref0 (data->addrs2);
	g_hash_table_insert (data->im_addrs2, data->_tmp27_, data->_tmp28_);
	g_value_set_boxed (data->v3, data->im_addrs2);
	data->_tmp29_ = g_strdup ("im-addresses");
	data->_tmp30_ = data->v3;
	data->v3 = NULL;
	g_hash_table_insert (data->details2, data->_tmp29_, data->_tmp30_);
	memset (&data->_tmp31_, 0, sizeof (GValue));
	g_value_init (&data->_tmp31_, G_TYPE_STRING);
	memset (&data->_tmp32_, 0, sizeof (GValue));
	data->_tmp32_ = data->_tmp31_;
	data->_tmp33_ = data->_tmp32_;
	data->_tmp34_ = __g_value_dup0 (&data->_tmp33_);
	data->_tmp35_ = data->_tmp34_;
	G_IS_VALUE (&data->_tmp33_) ? (g_value_unset (&data->_tmp33_), NULL) : NULL;
	data->v4 = data->_tmp35_;
	g_value_set_string (data->v4, data->self->priv->_persona_fullname_2);
	data->_tmp36_ = g_strdup ("full-name");
	data->_tmp37_ = data->v4;
	data->v4 = NULL;
	g_hash_table_insert (data->details2, data->_tmp36_, data->_tmp37_);
	data->_state_ = 1;
	folks_individual_aggregator_add_persona_from_details (data->self->priv->_aggregator, NULL, data->pstore, data->details1, _link_personas_tests_add_personas_ready, data);
	return FALSE;
	_state_1:
	data->_tmp38_ = NULL;
	data->_tmp38_ = folks_individual_aggregator_add_persona_from_details_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	data->_tmp39_ = data->_tmp38_;
	_g_object_unref0 (data->_tmp39_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			goto __catch3_folks_individual_aggregator_error;
		}
		__vala_GValue_free0 (data->v4);
		_g_object_unref0 (data->addrs2);
		_g_hash_table_unref0 (data->im_addrs2);
		__vala_GValue_free0 (data->v3);
		_g_hash_table_unref0 (data->details2);
		__vala_GValue_free0 (data->v2);
		_g_object_unref0 (data->addrs1);
		_g_hash_table_unref0 (data->im_addrs1);
		__vala_GValue_free0 (data->v1);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_state_ = 2;
	folks_individual_aggregator_add_persona_from_details (data->self->priv->_aggregator, NULL, data->pstore, data->details2, _link_personas_tests_add_personas_ready, data);
	return FALSE;
	_state_2:
	data->_tmp40_ = NULL;
	data->_tmp40_ = folks_individual_aggregator_add_persona_from_details_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	data->_tmp41_ = data->_tmp40_;
	_g_object_unref0 (data->_tmp41_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			goto __catch3_folks_individual_aggregator_error;
		}
		__vala_GValue_free0 (data->v4);
		_g_object_unref0 (data->addrs2);
		_g_hash_table_unref0 (data->im_addrs2);
		__vala_GValue_free0 (data->v3);
		_g_hash_table_unref0 (data->details2);
		__vala_GValue_free0 (data->v2);
		_g_object_unref0 (data->addrs1);
		_g_hash_table_unref0 (data->im_addrs1);
		__vala_GValue_free0 (data->v1);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	goto __finally3;
	__catch3_folks_individual_aggregator_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("link-personas.vala:208: [AddPersonaError] add_persona_from_details: %s" \
"\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally3:
	if (data->_inner_error_ != NULL) {
		__vala_GValue_free0 (data->v4);
		_g_object_unref0 (data->addrs2);
		_g_hash_table_unref0 (data->im_addrs2);
		__vala_GValue_free0 (data->v3);
		_g_hash_table_unref0 (data->details2);
		__vala_GValue_free0 (data->v2);
		_g_object_unref0 (data->addrs1);
		_g_hash_table_unref0 (data->im_addrs1);
		__vala_GValue_free0 (data->v1);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	__vala_GValue_free0 (data->v4);
	_g_object_unref0 (data->addrs2);
	_g_hash_table_unref0 (data->im_addrs2);
	__vala_GValue_free0 (data->v3);
	_g_hash_table_unref0 (data->details2);
	__vala_GValue_free0 (data->v2);
	_g_object_unref0 (data->addrs1);
	_g_hash_table_unref0 (data->im_addrs1);
	__vala_GValue_free0 (data->v1);
	_g_hash_table_unref0 (data->details1);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void __link_personas_tests_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_link_personas_tests_notify_cb (self, _sender, pspec);
}


static void _link_personas_tests_individuals_changed_cb (LinkPersonasTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	g_return_if_fail (self != NULL);
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* i;
			i = (FolksIndividual*) i_it->data;
			{
				gboolean _tmp0_;
				_tmp0_ = folks_individual_get_is_user (i);
				if (!_tmp0_) {
					_link_personas_tests_check_personas (self, i);
					g_signal_connect_object ((GObject*) i, "notify::full-name", (GCallback) __link_personas_tests_notify_cb_g_object_notify, self, 0);
					g_signal_connect_object ((GObject*) i, "notify::im-addresses", (GCallback) __link_personas_tests_notify_cb_g_object_notify, self, 0);
				}
			}
		}
	}
	if (removed != NULL) {
		guint _tmp1_;
		_tmp1_ = g_list_length (removed);
		self->priv->_removed_individuals = self->priv->_removed_individuals + ((gint) _tmp1_);
	}
}


static void _link_personas_tests_notify_cb (LinkPersonasTests* self, GObject* individual_obj, GParamSpec* ps) {
	FolksIndividual* _tmp0_;
	FolksIndividual* i;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual_obj != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_INDIVIDUAL (individual_obj));
	i = _tmp0_;
	_link_personas_tests_check_personas (self, i);
	_g_object_unref0 (i);
}


static gboolean _lambda0_ (LinkPersonasTests* self) {
	gboolean result = FALSE;
	folks_individual_aggregator_link_personas (self->priv->_aggregator, self->priv->_personas, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static void _link_personas_tests_check_personas (LinkPersonasTests* self, FolksIndividual* i) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp35_ = FALSE;
	guint _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	_tmp1_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
	if (g_strcmp0 (_tmp1_, self->priv->_persona_fullname_1) == 0) {
		_tmp0_ = g_strcmp0 (self->priv->_persona_iid_1, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GList* _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		GList* _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		FolksPersona* _tmp8_;
		_tmp2_ = folks_individual_get_personas (i);
		_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
		_tmp4_ = folks_persona_get_iid ((FolksPersona*) _tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (self->priv->_persona_iid_1);
		self->priv->_persona_iid_1 = _tmp5_;
		_tmp6_ = folks_individual_get_personas (i);
		_tmp7_ = g_list_nth_data (_tmp6_, (guint) 0);
		_tmp8_ = _g_object_ref0 ((FolksPersona*) _tmp7_);
		self->priv->_personas = g_list_prepend (self->priv->_personas, _tmp8_);
	} else {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_ = NULL;
		_tmp10_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
		if (g_strcmp0 (_tmp10_, self->priv->_persona_fullname_2) == 0) {
			_tmp9_ = g_strcmp0 (self->priv->_persona_iid_2, "") == 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GList* _tmp11_ = NULL;
			gconstpointer _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			GList* _tmp15_ = NULL;
			gconstpointer _tmp16_ = NULL;
			FolksPersona* _tmp17_;
			_tmp11_ = folks_individual_get_personas (i);
			_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
			_tmp13_ = folks_persona_get_iid ((FolksPersona*) _tmp12_);
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (self->priv->_persona_iid_2);
			self->priv->_persona_iid_2 = _tmp14_;
			_tmp15_ = folks_individual_get_personas (i);
			_tmp16_ = g_list_nth_data (_tmp15_, (guint) 0);
			_tmp17_ = _g_object_ref0 ((FolksPersona*) _tmp16_);
			self->priv->_personas = g_list_prepend (self->priv->_personas, _tmp17_);
		} else {
			GList* _tmp18_ = NULL;
			guint _tmp19_;
			_tmp18_ = folks_individual_get_personas (i);
			_tmp19_ = g_list_length (_tmp18_);
			if (_tmp19_ > 1) {
				GHashTable* _tmp20_ = NULL;
				GList* _tmp21_ = NULL;
				gint _tmp34_;
				_tmp20_ = folks_im_details_get_im_addresses ((FolksImDetails*) i);
				_tmp21_ = g_hash_table_get_keys (_tmp20_);
				{
					GList* proto_collection;
					GList* proto_it;
					proto_collection = _tmp21_;
					for (proto_it = proto_collection; proto_it != NULL; proto_it = proto_it->next) {
						const gchar* proto;
						proto = (const gchar*) proto_it->data;
						{
							GHashTable* _tmp22_ = NULL;
							gconstpointer _tmp23_ = NULL;
							FolksLinkedHashSet* _tmp24_;
							FolksLinkedHashSet* addrs;
							_tmp22_ = folks_im_details_get_im_addresses ((FolksImDetails*) i);
							_tmp23_ = g_hash_table_lookup (_tmp22_, proto);
							_tmp24_ = _g_object_ref0 ((FolksLinkedHashSet*) _tmp23_);
							addrs = _tmp24_;
							{
								FolksLinkedHashSet* _tmp25_;
								FolksLinkedHashSet* _a_list;
								gint _tmp26_;
								gint _a_size;
								gint _a_index;
								_tmp25_ = _g_object_ref0 (addrs);
								_a_list = _tmp25_;
								_tmp26_ = gee_collection_get_size ((GeeCollection*) _a_list);
								_a_size = _tmp26_;
								_a_index = -1;
								while (TRUE) {
									gpointer _tmp27_ = NULL;
									gchar* a;
									gpointer _tmp28_ = NULL;
									gchar* _tmp29_;
									gboolean _tmp30_;
									_a_index = _a_index + 1;
									if (!(_a_index < _a_size)) {
										break;
									}
									_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _a_list, _a_index);
									a = (gchar*) _tmp27_;
									_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_linking_props, "prop1");
									_tmp29_ = (gchar*) _tmp28_;
									_tmp30_ = g_strcmp0 (a, _tmp29_) == 0;
									_g_free0 (_tmp29_);
									if (_tmp30_) {
										gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_linking_props, "prop1", NULL);
									} else {
										gpointer _tmp31_ = NULL;
										gchar* _tmp32_;
										gboolean _tmp33_;
										_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_linking_props, "prop2");
										_tmp32_ = (gchar*) _tmp31_;
										_tmp33_ = g_strcmp0 (a, _tmp32_) == 0;
										_g_free0 (_tmp32_);
										if (_tmp33_) {
											gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_linking_props, "prop2", NULL);
										}
									}
									_g_free0 (a);
								}
								_g_object_unref0 (_a_list);
							}
							_g_object_unref0 (addrs);
						}
					}
					_g_list_free0 (proto_collection);
				}
				_tmp34_ = gee_map_get_size ((GeeMap*) self->priv->_linking_props);
				if (_tmp34_ == 0) {
					g_main_loop_quit (self->priv->_main_loop);
				}
			}
		}
	}
	_tmp36_ = g_list_length (self->priv->_personas);
	if (_tmp36_ == 2) {
		_tmp35_ = self->priv->_linking_fired == FALSE;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		self->priv->_linking_fired = TRUE;
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	}
}


static void link_personas_tests_class_init (LinkPersonasTestsClass * klass) {
	link_personas_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LinkPersonasTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = link_personas_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = link_personas_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = link_personas_tests_finalize;
}


static void link_personas_tests_instance_init (LinkPersonasTests * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self->priv = LINK_PERSONAS_TESTS_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("jabber");
	self->priv->_proto = _tmp0_;
	_tmp1_ = g_strdup ("someone-1@jabber.example.org");
	self->priv->_im_address_1 = _tmp1_;
	_tmp2_ = g_strdup ("someone-2@jabber.example.org");
	self->priv->_im_address_2 = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_persona_iid_1 = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_persona_iid_2 = _tmp4_;
	self->priv->_removed_individuals = 0;
	_tmp5_ = g_strdup ("/system/folks/backends/primary_store");
	self->priv->_folks_config_key = _tmp5_;
}


static void link_personas_tests_finalize (GObject* obj) {
	LinkPersonasTests * self;
	self = LINK_PERSONAS_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_persona_fullname_1);
	_g_free0 (self->priv->_persona_fullname_2);
	_g_free0 (self->priv->_proto);
	_g_free0 (self->priv->_im_address_1);
	_g_free0 (self->priv->_im_address_2);
	_g_free0 (self->priv->_persona_iid_1);
	_g_free0 (self->priv->_persona_iid_2);
	__g_list_free__g_object_unref0_0 (self->priv->_personas);
	_g_free0 (self->priv->_folks_config_key);
	_g_object_unref0 (self->priv->_linking_props);
	G_OBJECT_CLASS (link_personas_tests_parent_class)->finalize (obj);
}


GType link_personas_tests_get_type (void) {
	static volatile gsize link_personas_tests_type_id__volatile = 0;
	if (g_once_init_enter (&link_personas_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LinkPersonasTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) link_personas_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LinkPersonasTests), 0, (GInstanceInitFunc) link_personas_tests_instance_init, NULL };
		GType link_personas_tests_type_id;
		link_personas_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "LinkPersonasTests", &g_define_type_info, 0);
		g_once_init_leave (&link_personas_tests_type_id__volatile, link_personas_tests_type_id);
	}
	return link_personas_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	LinkPersonasTests* _tmp1_ = NULL;
	LinkPersonasTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = link_personas_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



