/* aggregation.c generated by valac 0.12.0, the Vala compiler
 * generated from aggregation.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <kf-test.h>
#include <tp-test-contactlist.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <folks.h>
#include <gio/gio.h>


#define TYPE_AGGREGATION_TESTS (aggregation_tests_get_type ())
#define AGGREGATION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AGGREGATION_TESTS, AggregationTests))
#define AGGREGATION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AGGREGATION_TESTS, AggregationTestsClass))
#define IS_AGGREGATION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AGGREGATION_TESTS))
#define IS_AGGREGATION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AGGREGATION_TESTS))
#define AGGREGATION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AGGREGATION_TESTS, AggregationTestsClass))

typedef struct _AggregationTests AggregationTests;
typedef struct _AggregationTestsClass AggregationTestsClass;
typedef struct _AggregationTestsPrivate AggregationTestsPrivate;
#define _kf_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (kf_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;

struct _AggregationTests {
	FolksTestCase parent_instance;
	AggregationTestsPrivate * priv;
};

struct _AggregationTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AggregationTestsPrivate {
	KfTestBackend* _kf_backend;
	TpTestBackend* _tp_backend;
	GeeHashSet* _default_individuals;
	gchar* _individual_id_prefix;
	gint _test_timeout;
};

struct _Block1Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	GeeHashSet* expected_individuals;
	FolksIndividualAggregator* aggregator;
};

struct _Block2Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	FolksIndividual* individual1;
	FolksIndividual* individual2;
	FolksIndividualAggregator* aggregator;
};

struct _Block3Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	FolksIndividual* individual1;
	FolksIndividual* individual2;
	FolksIndividualAggregator* aggregator;
};

struct _Block4Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	FolksIndividual* user_individual;
	FolksIndividualAggregator* aggregator;
};

struct _Block5Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	FolksIndividualAggregator* aggregator;
};


static gpointer aggregation_tests_parent_class = NULL;

GType aggregation_tests_get_type (void) G_GNUC_CONST;
#define AGGREGATION_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AGGREGATION_TESTS, AggregationTestsPrivate))
enum  {
	AGGREGATION_TESTS_DUMMY_PROPERTY
};
AggregationTests* aggregation_tests_new (void);
AggregationTests* aggregation_tests_construct (GType object_type);
void aggregation_tests_test_iid (AggregationTests* self);
static void _aggregation_tests_test_iid_folks_test_case_test_method (gpointer self);
void aggregation_tests_test_linkable_properties_same_store (AggregationTests* self);
static void _aggregation_tests_test_linkable_properties_same_store_folks_test_case_test_method (gpointer self);
void aggregation_tests_test_linkable_properties_different_stores (AggregationTests* self);
static void _aggregation_tests_test_linkable_properties_different_stores_folks_test_case_test_method (gpointer self);
void aggregation_tests_test_user (AggregationTests* self);
static void _aggregation_tests_test_user_folks_test_case_test_method (gpointer self);
void aggregation_tests_test_untrusted_store (AggregationTests* self);
static void _aggregation_tests_test_untrusted_store_folks_test_case_test_method (gpointer self);
static void aggregation_tests_real_set_up (FolksTestCase* base);
static void aggregation_tests_real_tear_down (FolksTestCase* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean _lambda0_ (const gchar* d, GLogLevelFlags l, const gchar* m, AggregationTests* self);
static gboolean __lambda0__glog_fatal_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void _lambda1_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_);
static void __lambda1__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda2_ (Block1Data* _data1_);
static gboolean __lambda2__gsource_func (gpointer self);
static gboolean _lambda3_ (Block1Data* _data1_);
static void _lambda4_ (GObject* s, GAsyncResult* r, Block1Data* _data1_);
static void __lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda3__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _lambda5_ (const gchar* d, GLogLevelFlags l, const gchar* m, AggregationTests* self);
static gboolean __lambda5__glog_fatal_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void _lambda6_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block2Data* _data2_);
static void __lambda6__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda7_ (Block2Data* _data2_);
static gboolean __lambda7__gsource_func (gpointer self);
static gboolean _lambda8_ (Block2Data* _data2_);
static void _lambda9_ (GObject* s, GAsyncResult* r, Block2Data* _data2_);
static void __lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda8__gsource_func (gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean _lambda10_ (const gchar* d, GLogLevelFlags l, const gchar* m, AggregationTests* self);
static gboolean __lambda10__glog_fatal_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void _lambda11_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block3Data* _data3_);
static void __lambda11__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda12_ (Block3Data* _data3_);
static gboolean __lambda12__gsource_func (gpointer self);
static gboolean _lambda13_ (Block3Data* _data3_);
static void _lambda14_ (GObject* s, GAsyncResult* r, Block3Data* _data3_);
static void __lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda13__gsource_func (gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean _lambda15_ (const gchar* d, GLogLevelFlags l, const gchar* m, AggregationTests* self);
static gboolean __lambda15__glog_fatal_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void _lambda16_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block4Data* _data4_);
static void __lambda16__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda17_ (Block4Data* _data4_);
static gboolean __lambda17__gsource_func (gpointer self);
static gboolean _lambda18_ (Block4Data* _data4_);
static void _lambda19_ (GObject* s, GAsyncResult* r, Block4Data* _data4_);
static void __lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda18__gsource_func (gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static gboolean _lambda20_ (const gchar* d, GLogLevelFlags l, const gchar* m, AggregationTests* self);
static gboolean __lambda20__glog_fatal_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void _lambda21_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, AggregationTests* self);
static void __lambda21__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda22_ (Block5Data* _data5_);
static gboolean __lambda22__gsource_func (gpointer self);
static gboolean _lambda23_ (Block5Data* _data5_);
static void _lambda24_ (GObject* s, GAsyncResult* r, Block5Data* _data5_);
static void __lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda23__gsource_func (gpointer self);
static void aggregation_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _aggregation_tests_test_iid_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_iid (self);
}


static void _aggregation_tests_test_linkable_properties_same_store_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_linkable_properties_same_store (self);
}


static void _aggregation_tests_test_linkable_properties_different_stores_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_linkable_properties_different_stores (self);
}


static void _aggregation_tests_test_user_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_user (self);
}


static void _aggregation_tests_test_untrusted_store_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_untrusted_store (self);
}


AggregationTests* aggregation_tests_construct (GType object_type) {
	AggregationTests * self = NULL;
	KfTestBackend* _tmp0_ = NULL;
	TpTestBackend* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	self = (AggregationTests*) folks_test_case_construct (object_type, "Aggregation");
	_tmp0_ = kf_test_backend_new ();
	_kf_test_backend_unref0 (self->priv->_kf_backend);
	self->priv->_kf_backend = _tmp0_;
	_tmp1_ = tp_test_backend_new ();
	_g_object_unref0 (self->priv->_tp_backend);
	self->priv->_tp_backend = _tmp1_;
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_g_object_unref0 (self->priv->_default_individuals);
	self->priv->_default_individuals = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_default_individuals, "travis@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_default_individuals, "olivier@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_default_individuals, "guillaume@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_default_individuals, "sjoerd@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_default_individuals, "christian@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_default_individuals, "wim@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_default_individuals, "helen@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_default_individuals, "geraldine@example.com");
	folks_test_case_add_test ((FolksTestCase*) self, "IID", _aggregation_tests_test_iid_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "linkable properties:same store", _aggregation_tests_test_linkable_properties_same_store_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "linkable properties:different stores", _aggregation_tests_test_linkable_properties_different_stores_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "user", _aggregation_tests_test_user_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "untrusted store", _aggregation_tests_test_untrusted_store_folks_test_case_test_method, self);
	_tmp3_ = g_getenv ("FOLKS_TEST_VALGRIND");
	if (_tmp3_ != NULL) {
		self->priv->_test_timeout = 10;
	}
	return self;
}


AggregationTests* aggregation_tests_new (void) {
	return aggregation_tests_construct (TYPE_AGGREGATION_TESTS);
}


static void aggregation_tests_real_set_up (FolksTestCase* base) {
	AggregationTests * self;
	self = (AggregationTests*) base;
	tp_test_backend_set_up (self->priv->_tp_backend);
}


static void aggregation_tests_real_tear_down (FolksTestCase* base) {
	AggregationTests * self;
	self = (AggregationTests*) base;
	tp_test_backend_tear_down (self->priv->_tp_backend);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->aggregator);
		_g_object_unref0 (_data1_->expected_individuals);
		_g_main_loop_unref0 (_data1_->main_loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _lambda0_ (const gchar* d, GLogLevelFlags l, const gchar* m, AggregationTests* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = g_str_has_suffix (m, "The name org.freedesktop.Telepathy.Logger " "was not provided by any .service files");
	result = !_tmp0_;
	return result;
}


static gboolean __lambda0__glog_fatal_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	gboolean result;
	result = _lambda0_ (log_domain, log_levels, message, self);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda1_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_) {
	AggregationTests * self;
	self = _data1_->self;
	{
		GList* i_collection;
		GList* i_it;
		i_collection = removed;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp0_;
			FolksIndividual* i;
			_tmp0_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_;
				_tmp3_ = folks_individual_get_is_user (i);
				if (!_tmp3_) {
					GList* _tmp4_ = NULL;
					guint _tmp5_;
					_tmp4_ = folks_individual_get_personas (i);
					_tmp5_ = g_list_length (_tmp4_);
					_tmp2_ = _tmp5_ == 2;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					const gchar* _tmp6_ = NULL;
					gboolean _tmp7_;
					_tmp6_ = folks_individual_get_id (i);
					_tmp7_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_default_individuals, _tmp6_);
					_tmp1_ = _tmp7_;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					const gchar* _tmp8_ = NULL;
					_tmp8_ = folks_individual_get_id (i);
					gee_abstract_collection_add ((GeeAbstractCollection*) _data1_->expected_individuals, _tmp8_);
				}
				_g_object_unref0 (i);
			}
		}
	}
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp9_;
			FolksIndividual* i;
			_tmp9_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp9_;
			{
				GList* _tmp10_ = NULL;
				GList* personas;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_;
				_tmp10_ = folks_individual_get_personas (i);
				personas = _tmp10_;
				_tmp12_ = folks_individual_get_is_user (i);
				if (!_tmp12_) {
					guint _tmp13_;
					_tmp13_ = g_list_length (personas);
					_tmp11_ = _tmp13_ == 2;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					const gchar* _tmp14_ = NULL;
					gboolean _tmp15_;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					_tmp14_ = folks_individual_get_id (i);
					_tmp15_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _data1_->expected_individuals, _tmp14_);
					g_assert (_tmp15_);
					_tmp16_ = folks_persona_get_iid ((FolksPersona*) personas->data);
					_tmp17_ = folks_persona_get_iid ((FolksPersona*) personas->next->data);
					g_assert (g_strcmp0 (_tmp16_, _tmp17_) == 0);
				}
				_g_object_unref0 (i);
			}
		}
	}
}


static void __lambda1__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda1_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda2_ (Block1Data* _data1_) {
	AggregationTests * self;
	gboolean result = FALSE;
	self = _data1_->self;
	g_main_loop_quit (_data1_->main_loop);
	result = FALSE;
	return result;
}


static gboolean __lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda2_ (self);
	return result;
}


static void _lambda4_ (GObject* s, GAsyncResult* r, Block1Data* _data1_) {
	AggregationTests * self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (r != NULL);
	folks_individual_aggregator_prepare_finish (_data1_->aggregator, r, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e1;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("aggregation.vala:137: Failed to prepare aggregator: %s", e1->message);
		g_assert_not_reached ();
		_g_error_free0 (e1);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda4_ (source_object, res, self);
	block1_data_unref (self);
}


static gboolean _lambda3_ (Block1Data* _data1_) {
	AggregationTests * self;
	gboolean result = FALSE;
	self = _data1_->self;
	folks_individual_aggregator_prepare (_data1_->aggregator, __lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	result = FALSE;
	return result;
}


static gboolean __lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda3_ (self);
	return result;
}


void aggregation_tests_test_iid (AggregationTests* self) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	void* account1_handle;
	void* _tmp2_ = NULL;
	void* account2_handle;
	GeeHashSet* _tmp3_ = NULL;
	FolksIndividualAggregator* _tmp9_ = NULL;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data1_->main_loop = _tmp0_;
	g_test_log_set_fatal_handler (__lambda0__glog_fatal_func, self);
	kf_test_backend_set_up (self->priv->_kf_backend, "");
	_tmp1_ = tp_test_backend_add_account (self->priv->_tp_backend, "protocol", "me@example.com", "cm", "account");
	account1_handle = _tmp1_;
	_tmp2_ = tp_test_backend_add_account (self->priv->_tp_backend, "protocol", "me2@example.com", "cm", "account2");
	account2_handle = _tmp2_;
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data1_->expected_individuals = _tmp3_;
	{
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _id_it;
		_tmp4_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_default_individuals);
		_id_it = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_;
			gpointer _tmp6_ = NULL;
			gchar* id;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = gee_iterator_next (_id_it);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = gee_iterator_get (_id_it);
			id = (gchar*) _tmp6_;
			_tmp7_ = g_strconcat (self->priv->_individual_id_prefix, id, NULL);
			_tmp8_ = _tmp7_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data1_->expected_individuals, _tmp8_);
			_g_free0 (_tmp8_);
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	_tmp9_ = folks_individual_aggregator_new ();
	_data1_->aggregator = _tmp9_;
	g_signal_connect_data (_data1_->aggregator, "individuals-changed", (GCallback) __lambda1__folks_individual_aggregator_individuals_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) self->priv->_test_timeout, __lambda2__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda3__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	g_main_loop_run (_data1_->main_loop);
	_tmp10_ = gee_collection_get_size ((GeeCollection*) _data1_->expected_individuals);
	g_assert (_tmp10_ == 0);
	tp_test_backend_remove_account (self->priv->_tp_backend, account2_handle);
	tp_test_backend_remove_account (self->priv->_tp_backend, account1_handle);
	kf_test_backend_tear_down (self->priv->_kf_backend);
	_g_object_unref0 (_data1_->aggregator);
	_data1_->aggregator = NULL;
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->aggregator);
		_g_main_loop_unref0 (_data2_->main_loop);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _lambda5_ (const gchar* d, GLogLevelFlags l, const gchar* m, AggregationTests* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = g_str_has_suffix (m, "The name org.freedesktop.Telepathy.Logger " "was not provided by any .service files");
	result = !_tmp0_;
	return result;
}


static gboolean __lambda5__glog_fatal_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	gboolean result;
	result = _lambda5_ (log_domain, log_levels, message, self);
	return result;
}


static void _lambda6_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block2Data* _data2_) {
	AggregationTests * self;
	self = _data2_->self;
	{
		GList* i_collection;
		GList* i_it;
		i_collection = removed;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp0_;
			FolksIndividual* i;
			_tmp0_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_;
				_tmp2_ = folks_individual_get_is_user (i);
				if (!_tmp2_) {
					GList* _tmp3_ = NULL;
					guint _tmp4_;
					_tmp3_ = folks_individual_get_personas (i);
					_tmp4_ = g_list_length (_tmp3_);
					_tmp1_ = _tmp4_ == 5;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					if (i == _data2_->individual1) {
						_data2_->individual1 = NULL;
					} else {
						if (i == _data2_->individual2) {
							_data2_->individual2 = NULL;
						} else {
							const gchar* _tmp5_ = NULL;
							_tmp5_ = folks_individual_get_id (i);
							g_critical ("aggregation.vala:208: Unknown 5-persona individual: %s", _tmp5_);
							g_assert_not_reached ();
						}
					}
				}
				_g_object_unref0 (i);
			}
		}
	}
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp6_;
			FolksIndividual* i;
			_tmp6_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp6_;
			{
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_;
				_tmp8_ = folks_individual_get_is_user (i);
				if (!_tmp8_) {
					GList* _tmp9_ = NULL;
					guint _tmp10_;
					_tmp9_ = folks_individual_get_personas (i);
					_tmp10_ = g_list_length (_tmp9_);
					_tmp7_ = _tmp10_ == 5;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					if (_data2_->individual1 == NULL) {
						_data2_->individual1 = i;
					} else {
						if (_data2_->individual2 == NULL) {
							_data2_->individual2 = i;
						} else {
							const gchar* _tmp11_ = NULL;
							_tmp11_ = folks_individual_get_id (i);
							g_critical ("aggregation.vala:228: Unknown 5-persona individual: %s", _tmp11_);
							g_assert_not_reached ();
						}
					}
				}
				_g_object_unref0 (i);
			}
		}
	}
}


static void __lambda6__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda6_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda7_ (Block2Data* _data2_) {
	AggregationTests * self;
	gboolean result = FALSE;
	self = _data2_->self;
	g_main_loop_quit (_data2_->main_loop);
	result = FALSE;
	return result;
}


static gboolean __lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda7_ (self);
	return result;
}


static void _lambda9_ (GObject* s, GAsyncResult* r, Block2Data* _data2_) {
	AggregationTests * self;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_if_fail (r != NULL);
	folks_individual_aggregator_prepare_finish (_data2_->aggregator, r, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e1;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("aggregation.vala:254: Failed to prepare aggregator: %s", e1->message);
		g_assert_not_reached ();
		_g_error_free0 (e1);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda9_ (source_object, res, self);
	block2_data_unref (self);
}


static gboolean _lambda8_ (Block2Data* _data2_) {
	AggregationTests * self;
	gboolean result = FALSE;
	self = _data2_->self;
	folks_individual_aggregator_prepare (_data2_->aggregator, __lambda9__gasync_ready_callback, block2_data_ref (_data2_));
	result = FALSE;
	return result;
}


static gboolean __lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda8_ (self);
	return result;
}


void aggregation_tests_test_linkable_properties_same_store (AggregationTests* self) {
	Block2Data* _data2_;
	GMainLoop* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	void* account_handle;
	FolksIndividualAggregator* _tmp2_ = NULL;
	GeeHashSet* _tmp3_ = NULL;
	GeeHashSet* individual1_expected;
	GeeHashSet* _tmp4_ = NULL;
	GeeHashSet* individual2_expected;
	GeeHashSet* set_in_use;
	GList* _tmp5_ = NULL;
	gint _tmp14_;
	GList* _tmp17_ = NULL;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data2_->main_loop = _tmp0_;
	g_test_log_set_fatal_handler (__lambda5__glog_fatal_func, self);
	kf_test_backend_set_up (self->priv->_kf_backend, "[0]\n" "protocol=travis@example.com;olivier@example.com;" "guillaume@example.com;sjoerd@example.com\n" "[1]\n" "protocol=christian@example.com;wim@example.com;" "helen@example.com;geraldine@example.com");
	_tmp1_ = tp_test_backend_add_account (self->priv->_tp_backend, "protocol", "me@example.com", "cm", "account");
	account_handle = _tmp1_;
	_data2_->individual1 = NULL;
	_data2_->individual2 = NULL;
	_tmp2_ = folks_individual_aggregator_new ();
	_data2_->aggregator = _tmp2_;
	g_signal_connect_data (_data2_->aggregator, "individuals-changed", (GCallback) __lambda6__folks_individual_aggregator_individuals_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) self->priv->_test_timeout, __lambda7__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda8__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	g_main_loop_run (_data2_->main_loop);
	g_assert (_data2_->individual1 != NULL);
	g_assert (_data2_->individual2 != NULL);
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	individual1_expected = _tmp3_;
	gee_abstract_collection_add ((GeeAbstractCollection*) individual1_expected, "0");
	gee_abstract_collection_add ((GeeAbstractCollection*) individual1_expected, "travis@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) individual1_expected, "olivier@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) individual1_expected, "guillaume@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) individual1_expected, "sjoerd@example.com");
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	individual2_expected = _tmp4_;
	gee_abstract_collection_add ((GeeAbstractCollection*) individual2_expected, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) individual2_expected, "christian@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) individual2_expected, "wim@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) individual2_expected, "helen@example.com");
	gee_abstract_collection_add ((GeeAbstractCollection*) individual2_expected, "geraldine@example.com");
	set_in_use = NULL;
	_tmp5_ = folks_individual_get_personas (_data2_->individual1);
	{
		GList* p_collection;
		GList* p_it;
		p_collection = _tmp5_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* _tmp6_;
			FolksPersona* p;
			_tmp6_ = _g_object_ref0 ((FolksPersona*) p_it->data);
			p = _tmp6_;
			{
				gboolean _tmp7_ = FALSE;
				const gchar* _tmp12_ = NULL;
				gboolean _tmp13_;
				if (set_in_use == NULL) {
					const gchar* _tmp8_ = NULL;
					gboolean _tmp9_;
					_tmp8_ = folks_persona_get_display_id (p);
					_tmp9_ = gee_abstract_collection_contains ((GeeAbstractCollection*) individual1_expected, _tmp8_);
					_tmp7_ = _tmp9_;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					GeeHashSet* _tmp10_;
					_tmp10_ = _g_object_ref0 (individual1_expected);
					_g_object_unref0 (set_in_use);
					set_in_use = _tmp10_;
				} else {
					if (set_in_use == NULL) {
						GeeHashSet* _tmp11_;
						_tmp11_ = _g_object_ref0 (individual2_expected);
						_g_object_unref0 (set_in_use);
						set_in_use = _tmp11_;
					}
				}
				_tmp12_ = folks_persona_get_display_id (p);
				_tmp13_ = gee_abstract_collection_remove ((GeeAbstractCollection*) set_in_use, _tmp12_);
				g_assert (_tmp13_);
				_g_object_unref0 (p);
			}
		}
	}
	_tmp14_ = gee_collection_get_size ((GeeCollection*) set_in_use);
	g_assert (_tmp14_ == 0);
	if (set_in_use == individual1_expected) {
		GeeHashSet* _tmp15_;
		_tmp15_ = _g_object_ref0 (individual2_expected);
		_g_object_unref0 (set_in_use);
		set_in_use = _tmp15_;
	} else {
		GeeHashSet* _tmp16_;
		_tmp16_ = _g_object_ref0 (individual1_expected);
		_g_object_unref0 (set_in_use);
		set_in_use = _tmp16_;
	}
	_tmp17_ = folks_individual_get_personas (_data2_->individual2);
	{
		GList* p_collection;
		GList* p_it;
		p_collection = _tmp17_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* _tmp18_;
			FolksPersona* p;
			_tmp18_ = _g_object_ref0 ((FolksPersona*) p_it->data);
			p = _tmp18_;
			{
				const gchar* _tmp19_ = NULL;
				gboolean _tmp20_;
				_tmp19_ = folks_persona_get_display_id (p);
				_tmp20_ = gee_abstract_collection_remove ((GeeAbstractCollection*) set_in_use, _tmp19_);
				g_assert (_tmp20_);
				_g_object_unref0 (p);
			}
		}
	}
	_tmp21_ = gee_collection_get_size ((GeeCollection*) set_in_use);
	g_assert (_tmp21_ == 0);
	tp_test_backend_remove_account (self->priv->_tp_backend, account_handle);
	kf_test_backend_tear_down (self->priv->_kf_backend);
	_g_object_unref0 (_data2_->aggregator);
	_data2_->aggregator = NULL;
	_g_object_unref0 (set_in_use);
	_g_object_unref0 (individual2_expected);
	_g_object_unref0 (individual1_expected);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->aggregator);
		_g_main_loop_unref0 (_data3_->main_loop);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _lambda10_ (const gchar* d, GLogLevelFlags l, const gchar* m, AggregationTests* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = g_str_has_suffix (m, "The name org.freedesktop.Telepathy.Logger " "was not provided by any .service files");
	result = !_tmp0_;
	return result;
}


static gboolean __lambda10__glog_fatal_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	gboolean result;
	result = _lambda10_ (log_domain, log_levels, message, self);
	return result;
}


static void _lambda11_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block3Data* _data3_) {
	AggregationTests * self;
	self = _data3_->self;
	{
		GList* i_collection;
		GList* i_it;
		i_collection = removed;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp0_;
			FolksIndividual* i;
			_tmp0_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_;
				_tmp2_ = folks_individual_get_is_user (i);
				if (!_tmp2_) {
					GList* _tmp3_ = NULL;
					guint _tmp4_;
					_tmp3_ = folks_individual_get_personas (i);
					_tmp4_ = g_list_length (_tmp3_);
					_tmp1_ = _tmp4_ == 9;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					if (i == _data3_->individual1) {
						_data3_->individual1 = NULL;
					} else {
						if (i == _data3_->individual2) {
							_data3_->individual2 = NULL;
						} else {
							const gchar* _tmp5_ = NULL;
							_tmp5_ = folks_individual_get_id (i);
							g_critical ("aggregation.vala:381: Unknown 9-persona individual: %s", _tmp5_);
							g_assert_not_reached ();
						}
					}
				}
				_g_object_unref0 (i);
			}
		}
	}
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp6_;
			FolksIndividual* i;
			_tmp6_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp6_;
			{
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_;
				_tmp8_ = folks_individual_get_is_user (i);
				if (!_tmp8_) {
					GList* _tmp9_ = NULL;
					guint _tmp10_;
					_tmp9_ = folks_individual_get_personas (i);
					_tmp10_ = g_list_length (_tmp9_);
					_tmp7_ = _tmp10_ == 9;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					if (_data3_->individual1 == NULL) {
						_data3_->individual1 = i;
					} else {
						if (_data3_->individual2 == NULL) {
							_data3_->individual2 = i;
						} else {
							const gchar* _tmp11_ = NULL;
							_tmp11_ = folks_individual_get_id (i);
							g_critical ("aggregation.vala:401: Unknown 9-persona individual: %s", _tmp11_);
							g_assert_not_reached ();
						}
					}
				}
				_g_object_unref0 (i);
			}
		}
	}
}


static void __lambda11__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda11_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda12_ (Block3Data* _data3_) {
	AggregationTests * self;
	gboolean result = FALSE;
	self = _data3_->self;
	g_main_loop_quit (_data3_->main_loop);
	result = FALSE;
	return result;
}


static gboolean __lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda12_ (self);
	return result;
}


static void _lambda14_ (GObject* s, GAsyncResult* r, Block3Data* _data3_) {
	AggregationTests * self;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	g_return_if_fail (r != NULL);
	folks_individual_aggregator_prepare_finish (_data3_->aggregator, r, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e1;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("aggregation.vala:427: Failed to prepare aggregator: %s", e1->message);
		g_assert_not_reached ();
		_g_error_free0 (e1);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda14_ (source_object, res, self);
	block3_data_unref (self);
}


static gboolean _lambda13_ (Block3Data* _data3_) {
	AggregationTests * self;
	gboolean result = FALSE;
	self = _data3_->self;
	folks_individual_aggregator_prepare (_data3_->aggregator, __lambda14__gasync_ready_callback, block3_data_ref (_data3_));
	result = FALSE;
	return result;
}


static gboolean __lambda13__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda13_ (self);
	return result;
}


void aggregation_tests_test_linkable_properties_different_stores (AggregationTests* self) {
	Block3Data* _data3_;
	GMainLoop* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	void* account1_handle;
	void* _tmp2_ = NULL;
	void* account2_handle;
	FolksIndividualAggregator* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GeeHashSet* expected_personas1;
	GeeHashSet* _tmp5_ = NULL;
	GeeHashSet* expected_personas2;
	GList* _tmp9_ = NULL;
	gint _tmp17_;
	GList* _tmp18_ = NULL;
	gint _tmp26_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data3_->main_loop = _tmp0_;
	g_test_log_set_fatal_handler (__lambda10__glog_fatal_func, self);
	kf_test_backend_set_up (self->priv->_kf_backend, "[0]\n" "protocol=travis@example.com;olivier@example.com;" "guillaume@example.com;sjoerd@example.com\n" "protocol2=christian@example.com;wim@example.com;" "helen@example.com;geraldine@example.com\n" "[1]\n" "protocol=christian@example.com;wim@example.com;" "helen@example.com;geraldine@example.com\n" "protocol2=travis@example.com;olivier@example.com;" "guillaume@example.com;sjoerd@example.com");
	_tmp1_ = tp_test_backend_add_account (self->priv->_tp_backend, "protocol", "me@example.com", "cm", "account");
	account1_handle = _tmp1_;
	_tmp2_ = tp_test_backend_add_account (self->priv->_tp_backend, "protocol2", "me@example.com", "cm", "account2");
	account2_handle = _tmp2_;
	_data3_->individual1 = NULL;
	_data3_->individual2 = NULL;
	_tmp3_ = folks_individual_aggregator_new ();
	_data3_->aggregator = _tmp3_;
	g_signal_connect_data (_data3_->aggregator, "individuals-changed", (GCallback) __lambda11__folks_individual_aggregator_individuals_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) self->priv->_test_timeout, __lambda12__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda13__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	g_main_loop_run (_data3_->main_loop);
	g_assert (_data3_->individual1 != NULL);
	g_assert (_data3_->individual2 != NULL);
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	expected_personas1 = _tmp4_;
	_tmp5_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	expected_personas2 = _tmp5_;
	{
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _id_it;
		_tmp6_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_default_individuals);
		_id_it = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_;
			gpointer _tmp8_ = NULL;
			gchar* id;
			_tmp7_ = gee_iterator_next (_id_it);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = gee_iterator_get (_id_it);
			id = (gchar*) _tmp8_;
			gee_abstract_collection_add ((GeeAbstractCollection*) expected_personas1, id);
			gee_abstract_collection_add ((GeeAbstractCollection*) expected_personas2, id);
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	_tmp9_ = folks_individual_get_personas (_data3_->individual1);
	{
		GList* p_collection;
		GList* p_it;
		p_collection = _tmp9_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* _tmp10_;
			FolksPersona* p;
			_tmp10_ = _g_object_ref0 ((FolksPersona*) p_it->data);
			p = _tmp10_;
			{
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				const gchar* _tmp13_ = NULL;
				gboolean _tmp14_;
				_tmp13_ = folks_persona_get_display_id (p);
				_tmp14_ = gee_abstract_collection_remove ((GeeAbstractCollection*) expected_personas1, _tmp13_);
				if (_tmp14_) {
					_tmp12_ = TRUE;
				} else {
					const gchar* _tmp15_ = NULL;
					_tmp15_ = folks_persona_get_display_id (p);
					_tmp12_ = g_strcmp0 (_tmp15_, "0") == 0;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					const gchar* _tmp16_ = NULL;
					_tmp16_ = folks_persona_get_display_id (p);
					_tmp11_ = g_strcmp0 (_tmp16_, "1") == 0;
				}
				g_assert (_tmp11_);
				_g_object_unref0 (p);
			}
		}
	}
	_tmp17_ = gee_collection_get_size ((GeeCollection*) expected_personas1);
	g_assert (_tmp17_ == 0);
	_tmp18_ = folks_individual_get_personas (_data3_->individual2);
	{
		GList* p_collection;
		GList* p_it;
		p_collection = _tmp18_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* _tmp19_;
			FolksPersona* p;
			_tmp19_ = _g_object_ref0 ((FolksPersona*) p_it->data);
			p = _tmp19_;
			{
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				const gchar* _tmp22_ = NULL;
				gboolean _tmp23_;
				_tmp22_ = folks_persona_get_display_id (p);
				_tmp23_ = gee_abstract_collection_remove ((GeeAbstractCollection*) expected_personas2, _tmp22_);
				if (_tmp23_) {
					_tmp21_ = TRUE;
				} else {
					const gchar* _tmp24_ = NULL;
					_tmp24_ = folks_persona_get_display_id (p);
					_tmp21_ = g_strcmp0 (_tmp24_, "0") == 0;
				}
				if (_tmp21_) {
					_tmp20_ = TRUE;
				} else {
					const gchar* _tmp25_ = NULL;
					_tmp25_ = folks_persona_get_display_id (p);
					_tmp20_ = g_strcmp0 (_tmp25_, "1") == 0;
				}
				g_assert (_tmp20_);
				_g_object_unref0 (p);
			}
		}
	}
	_tmp26_ = gee_collection_get_size ((GeeCollection*) expected_personas2);
	g_assert (_tmp26_ == 0);
	tp_test_backend_remove_account (self->priv->_tp_backend, account2_handle);
	tp_test_backend_remove_account (self->priv->_tp_backend, account1_handle);
	kf_test_backend_tear_down (self->priv->_kf_backend);
	_g_object_unref0 (_data3_->aggregator);
	_data3_->aggregator = NULL;
	_g_object_unref0 (expected_personas2);
	_g_object_unref0 (expected_personas1);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->aggregator);
		_g_object_unref0 (_data4_->user_individual);
		_g_main_loop_unref0 (_data4_->main_loop);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean _lambda15_ (const gchar* d, GLogLevelFlags l, const gchar* m, AggregationTests* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = g_str_has_suffix (m, "The name org.freedesktop.Telepathy.Logger " "was not provided by any .service files");
	result = !_tmp0_;
	return result;
}


static gboolean __lambda15__glog_fatal_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	gboolean result;
	result = _lambda15_ (log_domain, log_levels, message, self);
	return result;
}


static void _lambda16_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block4Data* _data4_) {
	AggregationTests * self;
	self = _data4_->self;
	{
		GList* i_collection;
		GList* i_it;
		i_collection = removed;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp0_;
			FolksIndividual* i;
			_tmp0_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp0_;
			{
				gboolean _tmp1_;
				_tmp1_ = folks_individual_get_is_user (i);
				if (_tmp1_) {
					g_assert (_data4_->user_individual == i);
					_g_object_unref0 (_data4_->user_individual);
					_data4_->user_individual = NULL;
				}
				_g_object_unref0 (i);
			}
		}
	}
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp2_;
			FolksIndividual* i;
			_tmp2_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp2_;
			{
				gboolean _tmp3_;
				_tmp3_ = folks_individual_get_is_user (i);
				if (_tmp3_) {
					FolksIndividual* _tmp4_;
					g_assert (_data4_->user_individual == NULL);
					_tmp4_ = _g_object_ref0 (i);
					_g_object_unref0 (_data4_->user_individual);
					_data4_->user_individual = _tmp4_;
				}
				_g_object_unref0 (i);
			}
		}
	}
}


static void __lambda16__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda16_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda17_ (Block4Data* _data4_) {
	AggregationTests * self;
	gboolean result = FALSE;
	self = _data4_->self;
	g_main_loop_quit (_data4_->main_loop);
	result = FALSE;
	return result;
}


static gboolean __lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda17_ (self);
	return result;
}


static void _lambda19_ (GObject* s, GAsyncResult* r, Block4Data* _data4_) {
	AggregationTests * self;
	GError * _inner_error_ = NULL;
	self = _data4_->self;
	g_return_if_fail (r != NULL);
	folks_individual_aggregator_prepare_finish (_data4_->aggregator, r, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e1;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("aggregation.vala:542: Failed to prepare aggregator: %s", e1->message);
		g_assert_not_reached ();
		_g_error_free0 (e1);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda19_ (source_object, res, self);
	block4_data_unref (self);
}


static gboolean _lambda18_ (Block4Data* _data4_) {
	AggregationTests * self;
	gboolean result = FALSE;
	self = _data4_->self;
	folks_individual_aggregator_prepare (_data4_->aggregator, __lambda19__gasync_ready_callback, block4_data_ref (_data4_));
	result = FALSE;
	return result;
}


static gboolean __lambda18__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda18_ (self);
	return result;
}


void aggregation_tests_test_user (AggregationTests* self) {
	Block4Data* _data4_;
	GMainLoop* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	void* account1_handle;
	void* _tmp2_ = NULL;
	void* account2_handle;
	FolksIndividualAggregator* _tmp3_ = NULL;
	FolksIndividual* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	guint _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GList* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data4_->main_loop = _tmp0_;
	g_test_log_set_fatal_handler (__lambda15__glog_fatal_func, self);
	kf_test_backend_set_up (self->priv->_kf_backend, "");
	_tmp1_ = tp_test_backend_add_account (self->priv->_tp_backend, "protocol", "me@example.com", "cm", "account");
	account1_handle = _tmp1_;
	_tmp2_ = tp_test_backend_add_account (self->priv->_tp_backend, "protocol", "me2@example.com", "cm", "account2");
	account2_handle = _tmp2_;
	_data4_->user_individual = NULL;
	_tmp3_ = folks_individual_aggregator_new ();
	_data4_->aggregator = _tmp3_;
	g_signal_connect_data (_data4_->aggregator, "individuals-changed", (GCallback) __lambda16__folks_individual_aggregator_individuals_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) self->priv->_test_timeout, __lambda17__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda18__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	g_main_loop_run (_data4_->main_loop);
	_tmp4_ = folks_individual_aggregator_get_user (_data4_->aggregator);
	g_assert (_tmp4_ == _data4_->user_individual);
	_tmp5_ = folks_individual_get_personas (_data4_->user_individual);
	_tmp6_ = g_list_length (_tmp5_);
	g_assert (_tmp6_ == 2);
	_tmp9_ = folks_individual_get_personas (_data4_->user_individual);
	_tmp10_ = folks_persona_get_display_id ((FolksPersona*) _tmp9_->data);
	if (g_strcmp0 (_tmp10_, "me@example.com") == 0) {
		GList* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = folks_individual_get_personas (_data4_->user_individual);
		_tmp12_ = folks_persona_get_display_id ((FolksPersona*) _tmp11_->next->data);
		_tmp8_ = g_strcmp0 (_tmp12_, "me2@example.com") == 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp13_ = FALSE;
		GList* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = folks_individual_get_personas (_data4_->user_individual);
		_tmp15_ = folks_persona_get_display_id ((FolksPersona*) _tmp14_->data);
		if (g_strcmp0 (_tmp15_, "me2@example.com") == 0) {
			GList* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			_tmp16_ = folks_individual_get_personas (_data4_->user_individual);
			_tmp17_ = folks_persona_get_display_id ((FolksPersona*) _tmp16_->next->data);
			_tmp13_ = g_strcmp0 (_tmp17_, "me@example.com") == 0;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp7_ = _tmp13_;
	}
	g_assert (_tmp7_);
	tp_test_backend_remove_account (self->priv->_tp_backend, account2_handle);
	tp_test_backend_remove_account (self->priv->_tp_backend, account1_handle);
	kf_test_backend_tear_down (self->priv->_kf_backend);
	_g_object_unref0 (_data4_->aggregator);
	_data4_->aggregator = NULL;
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->aggregator);
		_g_main_loop_unref0 (_data5_->main_loop);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean _lambda20_ (const gchar* d, GLogLevelFlags l, const gchar* m, AggregationTests* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = g_str_has_suffix (m, "The name org.freedesktop.Telepathy.Logger " "was not provided by any .service files");
	result = !_tmp0_;
	return result;
}


static gboolean __lambda20__glog_fatal_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	gboolean result;
	result = _lambda20_ (log_domain, log_levels, message, self);
	return result;
}


static void _lambda21_ (GList* added, GList* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, AggregationTests* self) {
	{
		GList* i_collection;
		GList* i_it;
		i_collection = removed;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp0_;
			FolksIndividual* i;
			_tmp0_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_;
				_tmp2_ = folks_individual_get_is_user (i);
				if (_tmp2_) {
					_tmp1_ = TRUE;
				} else {
					GList* _tmp3_ = NULL;
					guint _tmp4_;
					_tmp3_ = folks_individual_get_personas (i);
					_tmp4_ = g_list_length (_tmp3_);
					_tmp1_ = _tmp4_ == 1;
				}
				g_assert (_tmp1_);
				_g_object_unref0 (i);
			}
		}
	}
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp5_;
			FolksIndividual* i;
			_tmp5_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_;
				_tmp7_ = folks_individual_get_is_user (i);
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					GList* _tmp8_ = NULL;
					guint _tmp9_;
					_tmp8_ = folks_individual_get_personas (i);
					_tmp9_ = g_list_length (_tmp8_);
					_tmp6_ = _tmp9_ == 1;
				}
				g_assert (_tmp6_);
				_g_object_unref0 (i);
			}
		}
	}
}


static void __lambda21__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda21_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda22_ (Block5Data* _data5_) {
	AggregationTests * self;
	gboolean result = FALSE;
	self = _data5_->self;
	g_main_loop_quit (_data5_->main_loop);
	result = FALSE;
	return result;
}


static gboolean __lambda22__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda22_ (self);
	return result;
}


static void _lambda24_ (GObject* s, GAsyncResult* r, Block5Data* _data5_) {
	AggregationTests * self;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	g_return_if_fail (r != NULL);
	folks_individual_aggregator_prepare_finish (_data5_->aggregator, r, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e1;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("aggregation.vala:628: Failed to prepare aggregator: %s", e1->message);
		g_assert_not_reached ();
		_g_error_free0 (e1);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda24_ (source_object, res, self);
	block5_data_unref (self);
}


static gboolean _lambda23_ (Block5Data* _data5_) {
	AggregationTests * self;
	gboolean result = FALSE;
	self = _data5_->self;
	folks_individual_aggregator_prepare (_data5_->aggregator, __lambda24__gasync_ready_callback, block5_data_ref (_data5_));
	result = FALSE;
	return result;
}


static gboolean __lambda23__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda23_ (self);
	return result;
}


void aggregation_tests_test_untrusted_store (AggregationTests* self) {
	Block5Data* _data5_;
	GMainLoop* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	void* account1_handle;
	void* _tmp2_ = NULL;
	void* account2_handle;
	FolksIndividualAggregator* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data5_->main_loop = _tmp0_;
	g_test_log_set_fatal_handler (__lambda20__glog_fatal_func, self);
	kf_test_backend_set_up (self->priv->_kf_backend, "");
	_tmp1_ = tp_test_backend_add_account (self->priv->_tp_backend, "irc", "me@example.com", "cm", "account");
	account1_handle = _tmp1_;
	_tmp2_ = tp_test_backend_add_account (self->priv->_tp_backend, "irc", "me2@example.com", "cm", "account2");
	account2_handle = _tmp2_;
	_tmp3_ = folks_individual_aggregator_new ();
	_data5_->aggregator = _tmp3_;
	g_signal_connect_object (_data5_->aggregator, "individuals-changed", (GCallback) __lambda21__folks_individual_aggregator_individuals_changed, self, 0);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) self->priv->_test_timeout, __lambda22__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda23__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	g_main_loop_run (_data5_->main_loop);
	tp_test_backend_remove_account (self->priv->_tp_backend, account2_handle);
	tp_test_backend_remove_account (self->priv->_tp_backend, account1_handle);
	kf_test_backend_tear_down (self->priv->_kf_backend);
	_g_object_unref0 (_data5_->aggregator);
	_data5_->aggregator = NULL;
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void aggregation_tests_class_init (AggregationTestsClass * klass) {
	aggregation_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AggregationTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = aggregation_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = aggregation_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = aggregation_tests_finalize;
}


static void aggregation_tests_instance_init (AggregationTests * self) {
	gchar* _tmp0_;
	self->priv = AGGREGATION_TESTS_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("telepathy:protocol:");
	self->priv->_individual_id_prefix = _tmp0_;
	self->priv->_test_timeout = 3;
}


static void aggregation_tests_finalize (GObject* obj) {
	AggregationTests * self;
	self = AGGREGATION_TESTS (obj);
	_kf_test_backend_unref0 (self->priv->_kf_backend);
	_g_object_unref0 (self->priv->_tp_backend);
	_g_object_unref0 (self->priv->_default_individuals);
	_g_free0 (self->priv->_individual_id_prefix);
	G_OBJECT_CLASS (aggregation_tests_parent_class)->finalize (obj);
}


GType aggregation_tests_get_type (void) {
	static volatile gsize aggregation_tests_type_id__volatile = 0;
	if (g_once_init_enter (&aggregation_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AggregationTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aggregation_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AggregationTests), 0, (GInstanceInitFunc) aggregation_tests_instance_init, NULL };
		GType aggregation_tests_type_id;
		aggregation_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AggregationTests", &g_define_type_info, 0);
		g_once_init_leave (&aggregation_tests_type_id__volatile, aggregation_tests_type_id);
	}
	return aggregation_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	AggregationTests* _tmp1_ = NULL;
	AggregationTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = aggregation_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



