/* group-details.c generated by valac 0.12.0, the Vala compiler
 * generated from group-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_GROUP_DETAILS (folks_group_details_get_type ())
#define FOLKS_GROUP_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_GROUP_DETAILS, FolksGroupDetails))
#define FOLKS_IS_GROUP_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_GROUP_DETAILS))
#define FOLKS_GROUP_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_GROUP_DETAILS, FolksGroupDetailsIface))

typedef struct _FolksGroupDetails FolksGroupDetails;
typedef struct _FolksGroupDetailsIface FolksGroupDetailsIface;

#define FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON (folks_group_details_change_reason_get_type ())

struct _FolksGroupDetailsIface {
	GTypeInterface parent_iface;
	void (*change_group) (FolksGroupDetails* self, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_group_finish) (FolksGroupDetails* self, GAsyncResult* _res_, GError** error);
	GHashTable* (*get_groups) (FolksGroupDetails* self);
	void (*set_groups) (FolksGroupDetails* self, GHashTable* value);
};

typedef enum  {
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE = 0,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_SEPARATED = 11
} FolksGroupDetailsChangeReason;



GType folks_group_details_get_type (void) G_GNUC_CONST;
GType folks_group_details_change_reason_get_type (void) G_GNUC_CONST;
void folks_group_details_change_group (FolksGroupDetails* self, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_group_details_change_group_finish (FolksGroupDetails* self, GAsyncResult* _res_, GError** error);
GHashTable* folks_group_details_get_groups (FolksGroupDetails* self);
void folks_group_details_set_groups (FolksGroupDetails* self, GHashTable* value);
static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


/**
   * The reason a group member has changed its membership in the group.
   *
   * These closely follow the
   * [[http://telepathy.freedesktop.org/spec/Channel_Interface_Group.html#Channel_Group_Change_Reason|Channel_Group_Change_Reason]]
   * interface in the Telepathy specification.
   */
GType folks_group_details_change_reason_get_type (void) {
	static volatile gsize folks_group_details_change_reason_type_id__volatile = 0;
	if (g_once_init_enter (&folks_group_details_change_reason_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE, "FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE", "none"}, {FOLKS_GROUP_DETAILS_CHANGE_REASON_OFFLINE, "FOLKS_GROUP_DETAILS_CHANGE_REASON_OFFLINE", "offline"}, {FOLKS_GROUP_DETAILS_CHANGE_REASON_KICKED, "FOLKS_GROUP_DETAILS_CHANGE_REASON_KICKED", "kicked"}, {FOLKS_GROUP_DETAILS_CHANGE_REASON_BUSY, "FOLKS_GROUP_DETAILS_CHANGE_REASON_BUSY", "busy"}, {FOLKS_GROUP_DETAILS_CHANGE_REASON_INVITED, "FOLKS_GROUP_DETAILS_CHANGE_REASON_INVITED", "invited"}, {FOLKS_GROUP_DETAILS_CHANGE_REASON_BANNED, "FOLKS_GROUP_DETAILS_CHANGE_REASON_BANNED", "banned"}, {FOLKS_GROUP_DETAILS_CHANGE_REASON_ERROR, "FOLKS_GROUP_DETAILS_CHANGE_REASON_ERROR", "error"}, {FOLKS_GROUP_DETAILS_CHANGE_REASON_INVALID_MEMBER, "FOLKS_GROUP_DETAILS_CHANGE_REASON_INVALID_MEMBER", "invalid-member"}, {FOLKS_GROUP_DETAILS_CHANGE_REASON_NO_ANSWER, "FOLKS_GROUP_DETAILS_CHANGE_REASON_NO_ANSWER", "no-answer"}, {FOLKS_GROUP_DETAILS_CHANGE_REASON_RENAMED, "FOLKS_GROUP_DETAILS_CHANGE_REASON_RENAMED", "renamed"}, {FOLKS_GROUP_DETAILS_CHANGE_REASON_PERMISSION_DENIED, "FOLKS_GROUP_DETAILS_CHANGE_REASON_PERMISSION_DENIED", "permission-denied"}, {FOLKS_GROUP_DETAILS_CHANGE_REASON_SEPARATED, "FOLKS_GROUP_DETAILS_CHANGE_REASON_SEPARATED", "separated"}, {0, NULL, NULL}};
		GType folks_group_details_change_reason_type_id;
		folks_group_details_change_reason_type_id = g_enum_register_static ("FolksGroupDetailsChangeReason", values);
		g_once_init_leave (&folks_group_details_change_reason_type_id__volatile, folks_group_details_change_reason_type_id);
	}
	return folks_group_details_change_reason_type_id__volatile;
}


void folks_group_details_change_group (FolksGroupDetails* self, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_GROUP_DETAILS_GET_INTERFACE (self)->change_group (self, group, is_member, _callback_, _user_data_);
}


void folks_group_details_change_group_finish (FolksGroupDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_GROUP_DETAILS_GET_INTERFACE (self)->change_group_finish (self, _res_, error);
}


GHashTable* folks_group_details_get_groups (FolksGroupDetails* self) {
	return FOLKS_GROUP_DETAILS_GET_INTERFACE (self)->get_groups (self);
}


void folks_group_details_set_groups (FolksGroupDetails* self, GHashTable* value) {
	FOLKS_GROUP_DETAILS_GET_INTERFACE (self)->set_groups (self, value);
}


static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static void folks_group_details_base_init (FolksGroupDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * A mapping of group ID to whether the contact is a member.
		   *
		   * Freeform group IDs are mapped to a boolean which is `true` if the
		   * contact is a member of the group, and `false` otherwise.
		   */
		g_object_interface_install_property (iface, g_param_spec_boxed ("groups", "groups", "groups", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * Emitted when the contact's membership status changes for a group.
		   *
		   * This is emitted if the contact becomes a member of a group they weren't in
		   * before, or leaves a group they were in.
		   *
		   * @param group a freeform group identifier for the group being left or joined
		   * @param is_member whether the contact is joining or leaving the group
		   * @since 0.1.11
		   */
		g_signal_new ("group_changed", FOLKS_TYPE_GROUP_DETAILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	}
}


/**
 * Interface for {@link Persona}s or {@link Individual}s which can be grouped
 * into sets of similar objects.
 */
GType folks_group_details_get_type (void) {
	static volatile gsize folks_group_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_group_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksGroupDetailsIface), (GBaseInitFunc) folks_group_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_group_details_type_id;
		folks_group_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksGroupDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_group_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_group_details_type_id__volatile, folks_group_details_type_id);
	}
	return folks_group_details_type_id__volatile;
}



