/* kf-persona.c generated by valac 0.12.0, the Vala compiler
 * generated from kf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define FOLKS_BACKENDS_KF_TYPE_PERSONA (folks_backends_kf_persona_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersona))
#define FOLKS_BACKENDS_KF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))

typedef struct _FolksBackendsKfPersona FolksBackendsKfPersona;
typedef struct _FolksBackendsKfPersonaClass FolksBackendsKfPersonaClass;
typedef struct _FolksBackendsKfPersonaPrivate FolksBackendsKfPersonaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE (folks_backends_kf_persona_store_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))

typedef struct _FolksBackendsKfPersonaStore FolksBackendsKfPersonaStore;
typedef struct _FolksBackendsKfPersonaStoreClass FolksBackendsKfPersonaStoreClass;

struct _FolksBackendsKfPersona {
	FolksPersona parent_instance;
	FolksBackendsKfPersonaPrivate * priv;
};

struct _FolksBackendsKfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _FolksBackendsKfPersonaPrivate {
	GKeyFile* _key_file;
	GeeHashMultiMap* _im_addresses;
	GeeHashMultiMap* _web_service_addresses;
	gchar* _alias;
};


static gpointer folks_backends_kf_persona_parent_class = NULL;
static FolksAliasDetailsIface* folks_backends_kf_persona_folks_alias_details_parent_iface = NULL;
static FolksImDetailsIface* folks_backends_kf_persona_folks_im_details_parent_iface = NULL;
static FolksWebServiceDetailsIface* folks_backends_kf_persona_folks_web_service_details_parent_iface = NULL;

GType folks_backends_kf_persona_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_KF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaPrivate))
enum  {
	FOLKS_BACKENDS_KF_PERSONA_DUMMY_PROPERTY,
	FOLKS_BACKENDS_KF_PERSONA_LINKABLE_PROPERTIES,
	FOLKS_BACKENDS_KF_PERSONA_ALIAS,
	FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES,
	FOLKS_BACKENDS_KF_PERSONA_WEB_SERVICE_ADDRESSES
};
FolksBackendsKfPersona* folks_backends_kf_persona_new (GKeyFile* key_file, const gchar* id, FolksPersonaStore* store);
FolksBackendsKfPersona* folks_backends_kf_persona_construct (GType object_type, GKeyFile* key_file, const gchar* id, FolksPersonaStore* store);
static void folks_backends_kf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
GType folks_backends_kf_persona_store_get_type (void) G_GNUC_CONST;
void folks_backends_kf_persona_store_save_key_file (FolksBackendsKfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backends_kf_persona_store_save_key_file_finish (FolksBackendsKfPersonaStore* self, GAsyncResult* _res_);
static void folks_backends_kf_persona_finalize (GObject* obj);
static void _vala_folks_backends_kf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_backends_kf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* FOLKS_BACKENDS_KF_PERSONA__linkable_properties[2] = {"im-addresses", "web-service-addresses"};

/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the Persona given by the group `uid` in the key file `key_file`.
   */
FolksBackendsKfPersona* folks_backends_kf_persona_construct (GType object_type, GKeyFile* key_file, const gchar* id, FolksPersonaStore* store) {
	FolksBackendsKfPersona * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* iid;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* uid;
	GeeHashMultiMap* _tmp7_ = NULL;
	GeeHashMultiMap* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gsize _tmp10_;
	gchar** _tmp11_ = NULL;
	gchar** keys;
	gint keys_length1;
	gint _keys_size_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = folks_persona_store_get_id (store);
	_tmp1_ = g_strconcat (_tmp0_, ":", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, id, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	iid = _tmp4_;
	_tmp5_ = folks_persona_store_get_id (store);
	_tmp6_ = folks_persona_build_uid ("key-file", _tmp5_, id);
	uid = _tmp6_;
	self = (FolksBackendsKfPersona*) g_object_new (object_type, "display-id", id, "iid", iid, "uid", uid, "store", store, "is-user", FALSE, NULL);
	g_debug ("kf-persona.vala:212: Adding key-file Persona '%s' (IID '%s', group '%s" \
"')", uid, iid, id);
	self->priv->_key_file = key_file;
	_tmp7_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_im_addresses);
	self->priv->_im_addresses = _tmp7_;
	_tmp8_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_web_service_addresses);
	self->priv->_web_service_addresses = _tmp8_;
	_tmp9_ = folks_persona_get_display_id ((FolksPersona*) self);
	_tmp11_ = g_key_file_get_keys (self->priv->_key_file, _tmp9_, &_tmp10_, &_inner_error_);
	keys = _tmp11_;
	keys_length1 = _tmp10_;
	_keys_size_ = _tmp10_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch1_g_key_file_error;
		}
		_g_free0 (uid);
		_g_free0 (iid);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		gchar** key_collection;
		int key_collection_length1;
		int key_it;
		key_collection = keys;
		key_collection_length1 = keys_length1;
		for (key_it = 0; key_it < keys_length1; key_it = key_it + 1) {
			const gchar* key;
			key = key_collection[key_it];
			{
				gchar** _tmp15_;
				gchar** _tmp16_ = NULL;
				gchar** decomposed_key;
				gint decomposed_key_length1;
				gint _decomposed_key_size_;
				gboolean _tmp17_ = FALSE;
				const gchar* protocol;
				const gchar* _tmp22_ = NULL;
				gsize _tmp23_;
				gchar** _tmp24_ = NULL;
				gchar** im_addresses;
				gint im_addresses_length1;
				gint _im_addresses_size_;
				if (g_strcmp0 (key, "__alias") == 0) {
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					_tmp12_ = folks_persona_get_display_id ((FolksPersona*) self);
					_tmp13_ = g_key_file_get_string (self->priv->_key_file, _tmp12_, key, &_inner_error_);
					_tmp14_ = _tmp13_;
					if (_inner_error_ != NULL) {
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (uid);
						_g_free0 (iid);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_free0 (self->priv->_alias);
					self->priv->_alias = _tmp14_;
					g_debug ("kf-persona.vala:230:     Loaded alias '%s'.", self->priv->_alias);
					continue;
				}
				_tmp16_ = _tmp15_ = g_strsplit (key, ".", 2);
				decomposed_key = _tmp16_;
				decomposed_key_length1 = _vala_array_length (_tmp15_);
				_decomposed_key_size_ = _vala_array_length (_tmp15_);
				if (decomposed_key_length1 == 2) {
					_tmp17_ = g_strcmp0 (decomposed_key[0], "web-service") == 0;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					const gchar* web_service;
					const gchar* _tmp18_ = NULL;
					gsize _tmp19_;
					gchar** _tmp20_ = NULL;
					gchar** web_service_addresses;
					gint web_service_addresses_length1;
					gint _web_service_addresses_size_;
					web_service = decomposed_key[1];
					_tmp18_ = folks_persona_get_display_id ((FolksPersona*) self);
					_tmp20_ = g_key_file_get_string_list (self->priv->_key_file, _tmp18_, web_service, &_tmp19_, &_inner_error_);
					web_service_addresses = _tmp20_;
					web_service_addresses_length1 = _tmp19_;
					_web_service_addresses_size_ = _tmp19_;
					if (_inner_error_ != NULL) {
						decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (uid);
						_g_free0 (iid);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					{
						gchar** web_service_address_collection;
						int web_service_address_collection_length1;
						int web_service_address_it;
						web_service_address_collection = web_service_addresses;
						web_service_address_collection_length1 = web_service_addresses_length1;
						for (web_service_address_it = 0; web_service_address_it < web_service_addresses_length1; web_service_address_it = web_service_address_it + 1) {
							gchar* _tmp21_;
							gchar* web_service_address;
							_tmp21_ = g_strdup (web_service_address_collection[web_service_address_it]);
							web_service_address = _tmp21_;
							{
								gee_multi_map_set ((GeeMultiMap*) self->priv->_web_service_addresses, web_service, web_service_address);
								_g_free0 (web_service_address);
							}
						}
					}
					web_service_addresses = (_vala_array_free (web_service_addresses, web_service_addresses_length1, (GDestroyNotify) g_free), NULL);
					decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				protocol = key;
				_tmp22_ = folks_persona_get_display_id ((FolksPersona*) self);
				_tmp24_ = g_key_file_get_string_list (self->priv->_key_file, _tmp22_, protocol, &_tmp23_, &_inner_error_);
				im_addresses = _tmp24_;
				im_addresses_length1 = _tmp23_;
				_im_addresses_size_ = _tmp23_;
				if (_inner_error_ != NULL) {
					decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
					if (_inner_error_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (uid);
					_g_free0 (iid);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				{
					gchar** im_address_collection;
					int im_address_collection_length1;
					int im_address_it;
					im_address_collection = im_addresses;
					im_address_collection_length1 = im_addresses_length1;
					for (im_address_it = 0; im_address_it < im_addresses_length1; im_address_it = im_address_it + 1) {
						gchar* _tmp25_;
						gchar* im_address;
						_tmp25_ = g_strdup (im_address_collection[im_address_it]);
						im_address = _tmp25_;
						{
							gchar* address = NULL;
							gchar* _tmp26_ = NULL;
							gchar* _tmp27_;
							_tmp26_ = folks_im_details_normalise_im_address (im_address, protocol, &_inner_error_);
							_tmp27_ = _tmp26_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
									goto __catch2_folks_im_details_error;
								}
								_g_free0 (address);
								_g_free0 (im_address);
								im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
								decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
								keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (uid);
								_g_free0 (iid);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
							_g_free0 (address);
							address = _tmp27_;
							goto __finally2;
							__catch2_folks_im_details_error:
							{
								GError * e;
								e = _inner_error_;
								_inner_error_ = NULL;
								g_warning ("kf-persona.vala:268: %s", e->message);
								_g_error_free0 (e);
								_g_free0 (address);
								_g_free0 (im_address);
								continue;
							}
							__finally2:
							if (_inner_error_ != NULL) {
								_g_free0 (address);
								_g_free0 (im_address);
								im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
								decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
								keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									goto __catch1_g_key_file_error;
								}
								_g_free0 (address);
								_g_free0 (im_address);
								im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
								decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
								keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (uid);
								_g_free0 (iid);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
							gee_multi_map_set ((GeeMultiMap*) self->priv->_im_addresses, protocol, address);
							_g_free0 (address);
							_g_free0 (im_address);
						}
					}
				}
				im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
				decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (!g_error_matches (e, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
			const gchar* _tmp28_ = NULL;
			_tmp28_ = _ ("Couldn't load data from key file: %s");
			g_warning (_tmp28_, e->message);
		}
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (uid);
		_g_free0 (iid);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (uid);
	_g_free0 (iid);
	return self;
}


FolksBackendsKfPersona* folks_backends_kf_persona_new (GKeyFile* key_file, const gchar* id, FolksPersonaStore* store) {
	return folks_backends_kf_persona_construct (FOLKS_BACKENDS_KF_TYPE_PERSONA, key_file, id, store);
}


/**
   * {@inheritDoc}
   */
static void folks_backends_kf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	FolksBackendsKfPersona * self;
	self = (FolksBackendsKfPersona*) base;
	g_return_if_fail (prop_name != NULL);
	if (g_strcmp0 (prop_name, "im-addresses") == 0) {
		{
			GeeSet* _tmp0_ = NULL;
			GeeSet* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _protocol_it;
			_tmp0_ = gee_multi_map_get_keys ((GeeMultiMap*) self->priv->_im_addresses);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_tmp3_ = _tmp2_;
			_g_object_unref0 (_tmp1_);
			_protocol_it = _tmp3_;
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				gchar* protocol;
				GeeCollection* _tmp6_ = NULL;
				GeeCollection* im_addresses;
				_tmp4_ = gee_iterator_next (_protocol_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_protocol_it);
				protocol = (gchar*) _tmp5_;
				_tmp6_ = gee_multi_map_get ((GeeMultiMap*) self->priv->_im_addresses, protocol);
				im_addresses = _tmp6_;
				{
					GeeIterator* _tmp7_ = NULL;
					GeeIterator* _address_it;
					_tmp7_ = gee_iterable_iterator ((GeeIterable*) im_addresses);
					_address_it = _tmp7_;
					while (TRUE) {
						gboolean _tmp8_;
						gpointer _tmp9_ = NULL;
						gchar* address;
						gchar* _tmp10_;
						gchar* _tmp11_;
						gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp8_ = gee_iterator_next (_address_it);
						if (!_tmp8_) {
							break;
						}
						_tmp9_ = gee_iterator_get (_address_it);
						address = (gchar*) _tmp9_;
						_tmp10_ = g_strconcat (protocol, ":", NULL);
						_tmp11_ = _tmp10_;
						_tmp12_ = g_strconcat (_tmp11_, address, NULL);
						_tmp13_ = _tmp12_;
						callback (_tmp13_, callback_target);
						_g_free0 (_tmp13_);
						_g_free0 (_tmp11_);
						_g_free0 (address);
					}
					_g_object_unref0 (_address_it);
				}
				_g_object_unref0 (im_addresses);
				_g_free0 (protocol);
			}
			_g_object_unref0 (_protocol_it);
		}
	} else {
		if (g_strcmp0 (prop_name, "web-service-addresses") == 0) {
			{
				GeeMultiMap* _tmp14_ = NULL;
				GeeSet* _tmp15_ = NULL;
				GeeSet* _tmp16_;
				GeeIterator* _tmp17_ = NULL;
				GeeIterator* _tmp18_;
				GeeIterator* _web_service_it;
				_tmp14_ = folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self);
				_tmp15_ = gee_multi_map_get_keys (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
				_tmp18_ = _tmp17_;
				_g_object_unref0 (_tmp16_);
				_web_service_it = _tmp18_;
				while (TRUE) {
					gboolean _tmp19_;
					gpointer _tmp20_ = NULL;
					gchar* web_service;
					GeeCollection* _tmp21_ = NULL;
					GeeCollection* web_service_addresses;
					_tmp19_ = gee_iterator_next (_web_service_it);
					if (!_tmp19_) {
						break;
					}
					_tmp20_ = gee_iterator_get (_web_service_it);
					web_service = (gchar*) _tmp20_;
					_tmp21_ = gee_multi_map_get ((GeeMultiMap*) self->priv->_web_service_addresses, web_service);
					web_service_addresses = _tmp21_;
					{
						GeeIterator* _tmp22_ = NULL;
						GeeIterator* _address_it;
						_tmp22_ = gee_iterable_iterator ((GeeIterable*) web_service_addresses);
						_address_it = _tmp22_;
						while (TRUE) {
							gboolean _tmp23_;
							gpointer _tmp24_ = NULL;
							gchar* address;
							gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							gchar* _tmp28_;
							_tmp23_ = gee_iterator_next (_address_it);
							if (!_tmp23_) {
								break;
							}
							_tmp24_ = gee_iterator_get (_address_it);
							address = (gchar*) _tmp24_;
							_tmp25_ = g_strconcat (web_service, ":", NULL);
							_tmp26_ = _tmp25_;
							_tmp27_ = g_strconcat (_tmp26_, address, NULL);
							_tmp28_ = _tmp27_;
							callback (_tmp28_, callback_target);
							_g_free0 (_tmp28_);
							_g_free0 (_tmp26_);
							_g_free0 (address);
						}
						_g_object_unref0 (_address_it);
					}
					_g_object_unref0 (web_service_addresses);
					_g_free0 (web_service);
				}
				_g_object_unref0 (_web_service_it);
			}
		} else {
			FOLKS_PERSONA_CLASS (folks_backends_kf_persona_parent_class)->linkable_property_to_links (FOLKS_PERSONA (self), prop_name, callback, callback_target);
		}
	}
}


static gchar** folks_backends_kf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksBackendsKfPersona* self;
	const gchar** _tmp0_;
	self = (FolksBackendsKfPersona*) base;
	_tmp0_ = FOLKS_BACKENDS_KF_PERSONA__linkable_properties;
	*result_length1 = G_N_ELEMENTS (FOLKS_BACKENDS_KF_PERSONA__linkable_properties);
	result = _tmp0_;
	return result;
}


static const gchar* folks_backends_kf_persona_real_get_alias (FolksAliasDetails* base) {
	const gchar* result;
	FolksBackendsKfPersona* self;
	self = (FolksBackendsKfPersona*) base;
	result = self->priv->_alias;
	return result;
}


static void folks_backends_kf_persona_real_set_alias (FolksAliasDetails* base, const gchar* value) {
	FolksBackendsKfPersona* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	FolksPersonaStore* _tmp3_ = NULL;
	self = (FolksBackendsKfPersona*) base;
	if (g_strcmp0 (self->priv->_alias, value) == 0) {
		return;
	}
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	g_debug ("kf-persona.vala:68: Setting alias of Kf.Persona '%s' to '%s'.", _tmp0_, value);
	_tmp1_ = g_strdup (value);
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp1_;
	_tmp2_ = folks_persona_get_display_id ((FolksPersona*) self);
	g_key_file_set_string (self->priv->_key_file, _tmp2_, "__alias", value);
	_tmp3_ = folks_persona_get_store ((FolksPersona*) self);
	folks_backends_kf_persona_store_save_key_file (FOLKS_BACKENDS_KF_PERSONA_STORE (_tmp3_), NULL, NULL);
	g_object_notify ((GObject *) self, "alias");
}


static GeeMultiMap* folks_backends_kf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	FolksBackendsKfPersona* self;
	self = (FolksBackendsKfPersona*) base;
	result = (GeeMultiMap*) self->priv->_im_addresses;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backends_kf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	FolksBackendsKfPersona* self;
	GeeHashMultiMap* _tmp7_ = NULL;
	GeeHashMultiMap* im_addresses;
	GeeHashMultiMap* _tmp25_;
	FolksPersonaStore* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
	self = (FolksBackendsKfPersona*) base;
	{
		GeeSet* _tmp0_ = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _protocol_it;
		_tmp0_ = gee_multi_map_get_keys ((GeeMultiMap*) self->priv->_im_addresses);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_protocol_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			gchar* protocol;
			const gchar* _tmp6_ = NULL;
			_tmp4_ = gee_iterator_next (_protocol_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_protocol_it);
			protocol = (gchar*) _tmp5_;
			_tmp6_ = folks_persona_get_display_id ((FolksPersona*) self);
			g_key_file_remove_key (self->priv->_key_file, _tmp6_, protocol, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_KEY_FILE_ERROR) {
					goto __catch3_g_key_file_error;
				}
				_g_free0 (protocol);
				_g_object_unref0 (_protocol_it);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			goto __finally3;
			__catch3_g_key_file_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (e);
			}
			__finally3:
			if (_inner_error_ != NULL) {
				_g_free0 (protocol);
				_g_object_unref0 (_protocol_it);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_free0 (protocol);
		}
		_g_object_unref0 (_protocol_it);
	}
	_tmp7_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	im_addresses = _tmp7_;
	{
		GeeSet* _tmp8_ = NULL;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_ = NULL;
		GeeIterator* _tmp11_;
		GeeIterator* _protocol_it;
		_tmp8_ = gee_multi_map_get_keys (value);
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_protocol_it = _tmp11_;
		while (TRUE) {
			gboolean _tmp12_;
			gpointer _tmp13_ = NULL;
			gchar* protocol;
			GeeCollection* _tmp14_ = NULL;
			GeeCollection* addresses;
			GeeHashSet* _tmp15_ = NULL;
			GeeHashSet* normalised_addresses;
			gint _tmp21_;
			gpointer* _tmp22_ = NULL;
			gchar** addrs;
			gint addrs_length1;
			gint _addrs_size_;
			gint _tmp23_;
			const gchar* _tmp24_ = NULL;
			_tmp12_ = gee_iterator_next (_protocol_it);
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = gee_iterator_get (_protocol_it);
			protocol = (gchar*) _tmp13_;
			_tmp14_ = gee_multi_map_get (value, protocol);
			addresses = _tmp14_;
			_tmp15_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
			normalised_addresses = _tmp15_;
			{
				GeeIterator* _tmp16_ = NULL;
				GeeIterator* _address_it;
				_tmp16_ = gee_iterable_iterator ((GeeIterable*) addresses);
				_address_it = _tmp16_;
				while (TRUE) {
					gboolean _tmp17_;
					gpointer _tmp18_ = NULL;
					gchar* address;
					gchar* normalised_address = NULL;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					_tmp17_ = gee_iterator_next (_address_it);
					if (!_tmp17_) {
						break;
					}
					_tmp18_ = gee_iterator_get (_address_it);
					address = (gchar*) _tmp18_;
					_tmp19_ = folks_im_details_normalise_im_address (address, protocol, &_inner_error_);
					_tmp20_ = _tmp19_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
							goto __catch4_folks_im_details_error;
						}
						_g_free0 (normalised_address);
						_g_free0 (address);
						_g_object_unref0 (_address_it);
						_g_object_unref0 (normalised_addresses);
						_g_object_unref0 (addresses);
						_g_free0 (protocol);
						_g_object_unref0 (_protocol_it);
						_g_object_unref0 (im_addresses);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_free0 (normalised_address);
					normalised_address = _tmp20_;
					goto __finally4;
					__catch4_folks_im_details_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						g_warning ("kf-persona.vala:123: %s", e->message);
						_g_error_free0 (e);
						_g_free0 (normalised_address);
						_g_free0 (address);
						continue;
					}
					__finally4:
					if (_inner_error_ != NULL) {
						_g_free0 (normalised_address);
						_g_free0 (address);
						_g_object_unref0 (_address_it);
						_g_object_unref0 (normalised_addresses);
						_g_object_unref0 (addresses);
						_g_free0 (protocol);
						_g_object_unref0 (_protocol_it);
						_g_object_unref0 (im_addresses);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					gee_abstract_collection_add ((GeeAbstractCollection*) normalised_addresses, normalised_address);
					gee_multi_map_set ((GeeMultiMap*) im_addresses, protocol, normalised_address);
					_g_free0 (normalised_address);
					_g_free0 (address);
				}
				_g_object_unref0 (_address_it);
			}
			_tmp22_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) normalised_addresses, &_tmp21_);
			addrs = (gchar**) _tmp22_;
			addrs_length1 = _tmp21_;
			_addrs_size_ = _tmp21_;
			_tmp23_ = gee_collection_get_size ((GeeCollection*) normalised_addresses);
			addrs_length1 = _tmp23_;
			_tmp24_ = folks_persona_get_display_id ((FolksPersona*) self);
			g_key_file_set_string_list (self->priv->_key_file, _tmp24_, protocol, (const gchar* const*) addrs, addrs_length1);
			addrs = (_vala_array_free (addrs, addrs_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (normalised_addresses);
			_g_object_unref0 (addresses);
			_g_free0 (protocol);
		}
		_g_object_unref0 (_protocol_it);
	}
	_tmp25_ = _g_object_ref0 (im_addresses);
	_g_object_unref0 (self->priv->_im_addresses);
	self->priv->_im_addresses = _tmp25_;
	_tmp26_ = folks_persona_get_store ((FolksPersona*) self);
	folks_backends_kf_persona_store_save_key_file (FOLKS_BACKENDS_KF_PERSONA_STORE (_tmp26_), NULL, NULL);
	_g_object_unref0 (im_addresses);
	g_object_notify ((GObject *) self, "im-addresses");
}


static GeeMultiMap* folks_backends_kf_persona_real_get_web_service_addresses (FolksWebServiceDetails* base) {
	GeeMultiMap* result;
	FolksBackendsKfPersona* self;
	self = (FolksBackendsKfPersona*) base;
	result = (GeeMultiMap*) self->priv->_web_service_addresses;
	return result;
}


static void folks_backends_kf_persona_real_set_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* value) {
	FolksBackendsKfPersona* self;
	GeeHashMultiMap* _tmp9_ = NULL;
	GeeHashMultiMap* web_service_addresses;
	GeeHashMultiMap* _tmp26_;
	FolksPersonaStore* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	self = (FolksBackendsKfPersona*) base;
	{
		GeeSet* _tmp0_ = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _web_service_it;
		_tmp0_ = gee_multi_map_get_keys ((GeeMultiMap*) self->priv->_web_service_addresses);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_web_service_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			gchar* web_service;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp4_ = gee_iterator_next (_web_service_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_web_service_it);
			web_service = (gchar*) _tmp5_;
			_tmp6_ = folks_persona_get_display_id ((FolksPersona*) self);
			_tmp7_ = g_strconcat ("web-service.", web_service, NULL);
			_tmp8_ = _tmp7_;
			g_key_file_remove_key (self->priv->_key_file, _tmp6_, _tmp8_, &_inner_error_);
			_g_free0 (_tmp8_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_KEY_FILE_ERROR) {
					goto __catch5_g_key_file_error;
				}
				_g_free0 (web_service);
				_g_object_unref0 (_web_service_it);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			goto __finally5;
			__catch5_g_key_file_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (e);
			}
			__finally5:
			if (_inner_error_ != NULL) {
				_g_free0 (web_service);
				_g_object_unref0 (_web_service_it);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_free0 (web_service);
		}
		_g_object_unref0 (_web_service_it);
	}
	_tmp9_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	web_service_addresses = _tmp9_;
	{
		GeeSet* _tmp10_ = NULL;
		GeeSet* _tmp11_;
		GeeIterator* _tmp12_ = NULL;
		GeeIterator* _tmp13_;
		GeeIterator* _web_service_it;
		_tmp10_ = gee_multi_map_get_keys (value);
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_web_service_it = _tmp13_;
		while (TRUE) {
			gboolean _tmp14_;
			gpointer _tmp15_ = NULL;
			gchar* web_service;
			GeeCollection* _tmp16_ = NULL;
			GeeCollection* addresses;
			gint _tmp17_;
			gpointer* _tmp18_ = NULL;
			gchar** addrs;
			gint addrs_length1;
			gint _addrs_size_;
			gint _tmp19_;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp14_ = gee_iterator_next (_web_service_it);
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = gee_iterator_get (_web_service_it);
			web_service = (gchar*) _tmp15_;
			_tmp16_ = gee_multi_map_get (value, web_service);
			addresses = _tmp16_;
			_tmp18_ = gee_collection_to_array (addresses, &_tmp17_);
			addrs = (gchar**) _tmp18_;
			addrs_length1 = _tmp17_;
			_addrs_size_ = _tmp17_;
			_tmp19_ = gee_collection_get_size (addresses);
			addrs_length1 = _tmp19_;
			_tmp20_ = folks_persona_get_display_id ((FolksPersona*) self);
			_tmp21_ = g_strconcat ("web-service.", web_service, NULL);
			_tmp22_ = _tmp21_;
			g_key_file_set_string_list (self->priv->_key_file, _tmp20_, _tmp22_, (const gchar* const*) addrs, addrs_length1);
			_g_free0 (_tmp22_);
			{
				GeeIterator* _tmp23_ = NULL;
				GeeIterator* _address_it;
				_tmp23_ = gee_iterable_iterator ((GeeIterable*) addresses);
				_address_it = _tmp23_;
				while (TRUE) {
					gboolean _tmp24_;
					gpointer _tmp25_ = NULL;
					gchar* address;
					_tmp24_ = gee_iterator_next (_address_it);
					if (!_tmp24_) {
						break;
					}
					_tmp25_ = gee_iterator_get (_address_it);
					address = (gchar*) _tmp25_;
					gee_multi_map_set ((GeeMultiMap*) web_service_addresses, web_service, address);
					_g_free0 (address);
				}
				_g_object_unref0 (_address_it);
			}
			addrs = (_vala_array_free (addrs, addrs_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (addresses);
			_g_free0 (web_service);
		}
		_g_object_unref0 (_web_service_it);
	}
	_tmp26_ = _g_object_ref0 (web_service_addresses);
	_g_object_unref0 (self->priv->_web_service_addresses);
	self->priv->_web_service_addresses = _tmp26_;
	_tmp27_ = folks_persona_get_store ((FolksPersona*) self);
	folks_backends_kf_persona_store_save_key_file (FOLKS_BACKENDS_KF_PERSONA_STORE (_tmp27_), NULL, NULL);
	_g_object_unref0 (web_service_addresses);
	g_object_notify ((GObject *) self, "web-service-addresses");
}


static void folks_backends_kf_persona_class_init (FolksBackendsKfPersonaClass * klass) {
	folks_backends_kf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsKfPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->linkable_property_to_links = folks_backends_kf_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = folks_backends_kf_persona_real_get_linkable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_kf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backends_kf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_kf_persona_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.1.15
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_ALIAS, "alias");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES, "im-addresses");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_WEB_SERVICE_ADDRESSES, "web-service-addresses");
}


static void folks_backends_kf_persona_folks_alias_details_interface_init (FolksAliasDetailsIface * iface) {
	folks_backends_kf_persona_folks_alias_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_alias = folks_backends_kf_persona_real_get_alias;
	iface->set_alias = folks_backends_kf_persona_real_set_alias;
}


static void folks_backends_kf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	folks_backends_kf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = folks_backends_kf_persona_real_get_im_addresses;
	iface->set_im_addresses = folks_backends_kf_persona_real_set_im_addresses;
}


static void folks_backends_kf_persona_folks_web_service_details_interface_init (FolksWebServiceDetailsIface * iface) {
	folks_backends_kf_persona_folks_web_service_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_web_service_addresses = folks_backends_kf_persona_real_get_web_service_addresses;
	iface->set_web_service_addresses = folks_backends_kf_persona_real_set_web_service_addresses;
}


static void folks_backends_kf_persona_instance_init (FolksBackendsKfPersona * self) {
	self->priv = FOLKS_BACKENDS_KF_PERSONA_GET_PRIVATE (self);
}


static void folks_backends_kf_persona_finalize (GObject* obj) {
	FolksBackendsKfPersona * self;
	self = FOLKS_BACKENDS_KF_PERSONA (obj);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_web_service_addresses);
	_g_free0 (self->priv->_alias);
	G_OBJECT_CLASS (folks_backends_kf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single persona from a simple key file.
 *
 * @since 0.1.13
 */
GType folks_backends_kf_persona_get_type (void) {
	static volatile gsize folks_backends_kf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_kf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsKfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_kf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsKfPersona), 0, (GInstanceInitFunc) folks_backends_kf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_alias_details_info = { (GInterfaceInitFunc) folks_backends_kf_persona_folks_alias_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) folks_backends_kf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_web_service_details_info = { (GInterfaceInitFunc) folks_backends_kf_persona_folks_web_service_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType folks_backends_kf_persona_type_id;
		folks_backends_kf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "FolksBackendsKfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (folks_backends_kf_persona_type_id, FOLKS_TYPE_ALIAS_DETAILS, &folks_alias_details_info);
		g_type_add_interface_static (folks_backends_kf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (folks_backends_kf_persona_type_id, FOLKS_TYPE_WEB_SERVICE_DETAILS, &folks_web_service_details_info);
		g_once_init_leave (&folks_backends_kf_persona_type_id__volatile, folks_backends_kf_persona_type_id);
	}
	return folks_backends_kf_persona_type_id__volatile;
}


static void _vala_folks_backends_kf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsKfPersona * self;
	int length;
	self = FOLKS_BACKENDS_KF_PERSONA (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_PERSONA_LINKABLE_PROPERTIES:
		g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_ALIAS:
		g_value_set_string (value, folks_alias_details_get_alias ((FolksAliasDetails*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_WEB_SERVICE_ADDRESSES:
		g_value_set_object (value, folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_backends_kf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendsKfPersona * self;
	self = FOLKS_BACKENDS_KF_PERSONA (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_PERSONA_ALIAS:
		folks_alias_details_set_alias ((FolksAliasDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_WEB_SERVICE_ADDRESSES:
		folks_web_service_details_set_web_service_addresses ((FolksWebServiceDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



